/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.administration.nutzereinstellungen;

import de.esg.commonclient.GlobalObjects;
import java.awt.Cursor;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.app.konfiguration.Berechtigungen;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.administration.nutzereinstellungen.Filiale;
import webetk.javaclient.framework.MainView;
import webetk.mrkprd.MarkenProdukteBerechtigungen;
import webetk.resources.Resource;

public class Firma
extends MarkenProdukteBerechtigungen {
    private static Logger log = Logger.getLogger(Firma.class);
    private String msFirmaId = null;
    private Collection<Filiale> mcFilialen = null;
    private boolean mbHatBerechtigungKatalogumfangVT = false;
    private boolean mbHatBerechtigungKatalogumfangST = false;
    private boolean mbHatBerechtigungAnzeigeProdDatum = false;

    public String getFirmaId() {
        return this.msFirmaId;
    }

    public boolean hatBerechtigungKatalogumfangVT() {
        return this.mbHatBerechtigungKatalogumfangVT;
    }

    public boolean hatBerechtigungKatalogumfangST() {
        return this.mbHatBerechtigungKatalogumfangST;
    }

    public boolean hatBerechtigungAnzeigeProdDatum() {
        return this.mbHatBerechtigungAnzeigeProdDatum;
    }

    public int getAnzahlFilialen() {
        if (this.mcFilialen == null) {
            return 0;
        }
        return this.mcFilialen.size();
    }

    public Collection<Filiale> getFilialen() {
        if (this.mcFilialen == null) {
            return new Vector<Filiale>();
        }
        return this.mcFilialen;
    }

    public boolean initFirma(String sFirmaId) {
        this.msFirmaId = sFirmaId;
        if (!this.loadBerechtigungen()) {
            return false;
        }
        return this.loadFilialen();
    }

    public boolean loadBerechtigungen() {
        log.debug((Object)"Performing Load Berechtigungen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfBerechtigungen = new TrfHashMap(null);
        trfBerechtigungen.setValue("firmaid", this.msFirmaId);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfBerechtigungen, Command.LOAD_BERECHTIGUNGEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfBerechtigungen.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfBerechtigungen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfBerechtigungen.getError().getMessage(), Resource.getInstance().getBenutzerverwaltung(), 0);
            return false;
        }
        Berechtigungen berechtigungen = (Berechtigungen)trfBerechtigungen.getValue("berechtigungen");
        this.setMarkenBerechtigungen(berechtigungen.getMarkenBerechtigungen());
        this.setProdukteBerechtigungen(berechtigungen.getProdukteBerechtigungen());
        this.mbHatBerechtigungKatalogumfangVT = berechtigungen.isKatalogumfangVT();
        this.mbHatBerechtigungKatalogumfangST = berechtigungen.isKatalogumfangST();
        this.mbHatBerechtigungAnzeigeProdDatum = berechtigungen.isProdDatum();
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    public boolean loadFilialen() {
        log.debug((Object)"Performing Load Filialen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfFilialen = new TrfHashMap(null);
        trfFilialen.setValue("firmaid", this.msFirmaId);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFilialen, Command.LOAD_FILIALEN_SPRACHEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgNutzereinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfFilialen.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFilialen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFilialen.getError().getMessage(), Resource.getInstance().getBenutzerverwaltung(), 0);
            return false;
        }
        if (this.mcFilialen == null) {
            this.mcFilialen = new Vector<Filiale>();
        } else {
            this.mcFilialen.clear();
        }
        List filialen = (List)trfFilialen.getValue("filialen");
        for (webetk.app.konfiguration.Filiale filiale : filialen) {
            this.mcFilialen.add(new Filiale(filiale.getId(), filiale.getBezeichnung()));
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }
}

