/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.administration.nutzereinstellungen.suche;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.administration.nutzereinstellungen.Nutzer;
import webetk.javaclient.dialog.administration.nutzereinstellungen.suche.DlgNutzerSuchenModel;
import webetk.javaclient.dialog.administration.nutzereinstellungen.suche.DlgNutzerSuchenView;
import webetk.javaclient.dialog.administration.nutzereinstellungen.suche.NutzerListModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class DlgNutzerSuchenController
extends AbstractDialogViewController {
    Logger log = Logger.getLogger(DlgNutzerSuchenController.class);
    DlgNutzerSuchenView view = new DlgNutzerSuchenView(MainView.getInstance());
    DlgNutzerSuchenModel model = new DlgNutzerSuchenModel();
    public static final String NUTZER = "Nutzer";
    private static final int MIN_LENGTH_SEARCH_STRING = 3;
    public static final int MAX_ANZAHL_USER_LISTBOX = 30;

    @Override
    public WorkflowStateData getExitData() {
        return this.model.getWorkflowStateData();
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        this.log.debug((Object)"init");
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        this.model.setFirmaId(sFirmaId);
        this.model.init(oWFStateData);
        this.view.init(this);
        this.view.setVisible(true);
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    public void butSucheClicked() {
        if (this.view.getSearchString().replaceAll("[*]", "").length() < 3) {
            String txt = Resource.getInstance().getSuchbegriffZuKurz();
            txt = StringUtils.substituteStringStraight(txt, "{0}", Integer.toString(3));
            this.view.updatePanel(new String[]{txt, Resource.getInstance().getWildcardsZaehlenNicht()});
        } else {
            String searchString = this.view.getSearchString().replace('*', '%');
            int anzahlDS = this.ermittleTrefferAnzahl(searchString);
            if (anzahlDS == 0) {
                this.view.updatePanel(new String[]{Resource.getInstance().getKeineDatensaetze(), Resource.getInstance().getSucheEinschraenken()});
            } else if (anzahlDS <= 30) {
                List<String[]> list = this.ermittleTreffer(searchString);
                this.view.updatePanel(new NutzerListModel(list));
            } else {
                String txt = Resource.getInstance().getZuVieleDatensaetze();
                txt = StringUtils.substituteStringStraight(txt, "{0}", Integer.toString(anzahlDS));
                this.view.updatePanel(new String[]{txt, Resource.getInstance().getSucheEinschraenken()});
            }
        }
    }

    public void butOkClicked(String userId) {
        this.model.getData().setWert(NUTZER, this.ladeNutzer(userId));
        this.view.dispose();
    }

    private int ermittleTrefferAnzahl(String searchString) {
        this.log.debug((Object)"Performing Load Anzahl Nutzer");
        ArrayList<String> aUserIdToIgnore = new ArrayList<String>();
        aUserIdToIgnore.add("score");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfNutzer = new TrfHashMap(null);
        trfNutzer.setValue("firmaid", this.model.getFirmaId());
        trfNutzer.setValue("suchbegriff", searchString);
        trfNutzer.setValue("userids_to_ignore", aUserIdToIgnore);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfNutzer, Command.LOAD_ANZAHL_NUTZER);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgNutzereinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return 0;
        }
        if (trfNutzer.getError() != null) {
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfNutzer.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfNutzer.getError().getMessage(), Resource.getInstance().getBenutzerverwaltung(), 0);
            return 0;
        }
        int anzahl = (Integer)trfNutzer.getValue("anzahlNutzer");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return anzahl;
    }

    private List<String[]> ermittleTreffer(String searchString) {
        this.log.debug((Object)"Performing Load Nutzer");
        ArrayList<String> aUserIdToIgnore = new ArrayList<String>();
        aUserIdToIgnore.add("score");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfNutzer = new TrfHashMap(null);
        trfNutzer.setValue("firmaid", this.model.getFirmaId());
        trfNutzer.setValue("suchbegriff", searchString);
        trfNutzer.setValue("userids_to_ignore", aUserIdToIgnore);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfNutzer, Command.LOAD_MATCHING_NUTZER);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgNutzereinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfNutzer.getError() != null) {
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfNutzer.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfNutzer.getError().getMessage(), Resource.getInstance().getBenutzerverwaltung(), 0);
            return null;
        }
        ArrayList<String[]> treffer = new ArrayList<String[]>();
        List trefferListe = (List)trfNutzer.getValue("matchingNutzerLISTE");
        for (webetk.communication.Nutzer nutzer : trefferListe) {
            treffer.add(new String[]{nutzer.getNutzerId(), nutzer.getNutzerName()});
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return treffer;
    }

    private Nutzer ladeNutzer(String sUserId) {
        this.log.debug((Object)"Performing Load Nutzer");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfNutzer = new TrfHashMap(null);
        trfNutzer.setValue("firmaid", this.model.getFirmaId());
        trfNutzer.setValue("user_id", sUserId);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfNutzer, Command.LOAD_NUTZER);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgNutzereinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfNutzer.getError() != null) {
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfNutzer.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfNutzer.getError().getMessage(), Resource.getInstance().getBenutzerverwaltung(), 0);
            return null;
        }
        String sUserName = (String)trfNutzer.getValue("username");
        String sPasswort = (String)trfNutzer.getValue("pwd");
        String sDefaultFiliale = (String)trfNutzer.getValue("filiale");
        String sBearbeiterNr = (String)trfNutzer.getValue("bearbeiter_nummer");
        if (sUserName == null || sPasswort == null) {
            return null;
        }
        Nutzer nutzer = new Nutzer(sUserName, sUserId, sPasswort, sDefaultFiliale, sBearbeiterNr);
        nutzer.loadBerechtigungen(this.model.getFirmaId());
        nutzer.loadFunktionsrechte(this.model.getFirmaId());
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return nutzer;
    }
}

