/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.administration.nutzereinstellungen.suche;

import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.administration.nutzereinstellungen.suche.DlgNutzerSuchenController;
import webetk.javaclient.dialog.administration.nutzereinstellungen.suche.NutzerListCellRenderer;
import webetk.javaclient.dialog.administration.nutzereinstellungen.suche.NutzerListModel;
import webetk.resources.Resource;

public class DlgNutzerSuchenView
extends JDialog {
    private static final long serialVersionUID = 1L;
    Logger log = Logger.getLogger(DlgNutzerSuchenView.class);
    public static final Dimension DIALOG_PREFERRED_SIZE = new Dimension(500, 540);
    public static final Dimension BUTTONSIZE = new Dimension(130, 27);
    private DlgNutzerSuchenController controller;
    private NutzerListModel listModel;
    private TitledPanel panSuchkriterium;
    private TitledPanel panSuchergebnisse;
    private JPanel panButtons;
    private JLabel labSuchkriterium;
    private JTextField tfSuchkriterium;
    private JButtonEx butSuche;
    private JList lstNutzer;
    private JButtonEx butOk;
    private JButtonEx butAbbrechen;

    public DlgNutzerSuchenView(Frame owner) {
        super(owner, Resource.getInstance().getNutzerSuchen());
    }

    public void init(DialogViewController oController) {
        this.log.debug((Object)"init");
        this.controller = (DlgNutzerSuchenController)oController;
        this.initDialog();
    }

    private void initDialog() {
        this.labSuchkriterium = new JLabel(Resource.getInstance().getSuchkriterium() + ": ");
        this.tfSuchkriterium = new JTextField();
        this.tfSuchkriterium.setPreferredSize(new Dimension(150, this.tfSuchkriterium.getPreferredSize().height));
        this.tfSuchkriterium.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgNutzerSuchenView.this.controller.butSucheClicked();
            }
        });
        this.butSuche = new JButtonEx(Resource.getInstance().getSuchen(), ImageCache.getInstance().getIcon("search.gif"));
        this.butSuche.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgNutzerSuchenView.this.controller.butSucheClicked();
            }
        });
        this.panSuchkriterium = new TitledPanel(Resource.getInstance().getSuchkriterium());
        this.panSuchkriterium.setLayout(new BoxLayout(this.panSuchkriterium, 0));
        this.panSuchkriterium.add(this.labSuchkriterium);
        this.panSuchkriterium.add(this.tfSuchkriterium);
        this.panSuchkriterium.add(this.butSuche);
        this.lstNutzer = new JList();
        this.lstNutzer.setPreferredSize(new Dimension(DlgNutzerSuchenView.DIALOG_PREFERRED_SIZE.width, 20));
        this.lstNutzer.setCellRenderer(new NutzerListCellRenderer());
        this.lstNutzer.setListData(new String[]{"", ""});
        this.lstNutzer.setSelectionMode(0);
        this.lstNutzer.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && DlgNutzerSuchenView.this.listModel != null && e.getFirstIndex() >= 0 && e.getFirstIndex() < DlgNutzerSuchenView.this.listModel.getSize()) {
                    DlgNutzerSuchenView.this.butOk.setEnabled(true);
                }
            }
        });
        this.panSuchergebnisse = new TitledPanel(Resource.getInstance().getSuchergebnis());
        this.panSuchergebnisse.add(this.lstNutzer);
        this.butOk = new JButtonEx(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.butOk.setPreferredSize(BUTTONSIZE);
        this.butOk.setEnabled(false);
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String userId = ((String[])DlgNutzerSuchenView.this.lstNutzer.getSelectedValue())[0];
                DlgNutzerSuchenView.this.controller.butOkClicked(userId);
            }
        });
        this.butAbbrechen = new JButtonEx(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.butAbbrechen.setPreferredSize(BUTTONSIZE);
        this.butAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgNutzerSuchenView.this.dispose();
            }
        });
        this.panButtons = new JPanel();
        this.panButtons.setLayout(new GridBagLayout());
        GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 0, 17, new Insets(5, 10, 5, 10));
        this.panButtons.add((Component)this.butOk, gbc);
        gbc = this.setGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 0, 13, new Insets(5, 10, 5, 10));
        this.panButtons.add((Component)this.butAbbrechen, gbc);
        this.createLayout();
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.add((Component)this.panSuchkriterium, "North");
        this.add((Component)this.panSuchergebnisse, "Center");
        this.add((Component)this.panButtons, "South");
        this.setLocation();
    }

    private void setLocation() {
        Point locOwner = this.getOwner().getLocation();
        Dimension dimOwner = this.getOwner().getSize();
        int xDialog = dimOwner.width / 2 + locOwner.x - DlgNutzerSuchenView.DIALOG_PREFERRED_SIZE.width / 2;
        int yDialog = dimOwner.height / 2 + locOwner.y - DlgNutzerSuchenView.DIALOG_PREFERRED_SIZE.height / 2;
        this.setLocation(xDialog, yDialog);
        this.pack();
        this.setResizable(false);
    }

    public void updatePanel(NutzerListModel model) {
        this.listModel = model;
        this.lstNutzer.setModel(model);
        this.lstNutzer.setPreferredSize(new Dimension(DlgNutzerSuchenView.DIALOG_PREFERRED_SIZE.width, model.getSize() * 18));
        this.lstNutzer.setEnabled(true);
        if (model.getSize() == 1) {
            this.lstNutzer.setSelectedIndex(0);
            this.butOk.setEnabled(true);
            this.butOk.requestFocusInWindow();
        } else {
            this.butOk.setEnabled(false);
            this.tfSuchkriterium.requestFocusInWindow();
        }
        this.pack();
    }

    public void updatePanel(String[] text) {
        this.listModel = null;
        this.lstNutzer.setListData(text);
        this.lstNutzer.setPreferredSize(new Dimension(DlgNutzerSuchenView.DIALOG_PREFERRED_SIZE.width, text.length * 18));
        this.lstNutzer.setEnabled(false);
        this.butOk.setEnabled(false);
        this.tfSuchkriterium.requestFocusInWindow();
        this.pack();
    }

    public String getSearchString() {
        return this.tfSuchkriterium.getText();
    }

    protected GridBagConstraints setGridBagConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int fill, int anchor, Insets insets) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gridx;
        c.gridy = gridy;
        c.gridwidth = gridwidth;
        c.gridheight = gridheight;
        c.weightx = weightx;
        c.weighty = weighty;
        c.fill = fill;
        c.insets = insets;
        c.anchor = anchor;
        return c;
    }
}

