/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.bte;

import de.esg.commonclient.GlobalObjects;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.AttributedString;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.app.BTEBedingungsmenge;
import webetk.app.bteanzeige.AbstractZeile;
import webetk.app.bteanzeige.BTVerweisZeile;
import webetk.app.bteanzeige.KommZeile;
import webetk.app.bteanzeige.Textteil;
import webetk.app.bteanzeige.Zeile;
import webetk.communication.CommunicationException;
import webetk.communication.JavaSucheInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.bte.BTEModel;
import webetk.javaclient.dialog.bte.KommentarZeile;
import webetk.javaclient.dialog.bte.KomprimierungsZeile;
import webetk.javaclient.dialog.bte.TeilenummernZeile;
import webetk.javaclient.dialog.bte.VerweisZeile;
import webetk.javaclient.dialog.bte.bedingungen.BTEBedingungenTabelleModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.DreieckLabel;
import webetk.javaclient.generictable.DreieckTextAndTooltip;
import webetk.javaclient.generictable.GenericRow;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.resources.Resource;

public class BTEDruckansicht
implements Printable {
    private static Logger log = Logger.getLogger(BTEDruckansicht.class);
    private PrinterJob printJob;
    private PageFormat pageFormat;
    private BTEModel model;
    private Image image;
    private GenericTableModel teilelistentableModel = null;
    private BTEBedingungenTabelleModel bedingungenTableModel = null;
    private int nCurrentRow;
    private int nOldRow;
    private int nBedingungenCurrentRow;
    private int nBedingungenOldRow;
    private int nPrintLastPageIndex;
    private Vector<String> mcSelIds;
    private int captionPrinted;
    private int captionBedingungenPrinted;

    public BTEDruckansicht(BTEModel pModel, Image pImage, Vector<String> cSelIds) {
        this.model = pModel;
        this.image = pImage;
        this.mcSelIds = cSelIds;
        this.nCurrentRow = 0;
        this.nOldRow = 0;
        this.nPrintLastPageIndex = -1;
        this.captionPrinted = 0;
        this.captionBedingungenPrinted = 0;
        this.printJob = PrinterJob.getPrinterJob();
        this.pageFormat = this.printJob.defaultPage();
        this.pageFormat.setOrientation(0);
        this.loadData();
        this.printJob.setJobName("BTE");
        this.printJob.setPrintable(this, this.pageFormat);
    }

    public void printBTE() {
        try {
            this.printJob.print();
        }
        catch (PrinterException pe) {
            System.out.println("Error printing: " + pe);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int nOffset;
        String value;
        int i;
        int fontSize;
        if (this.nPrintLastPageIndex == pageIndex) {
            this.nCurrentRow = this.nOldRow;
            this.nBedingungenCurrentRow = this.nBedingungenOldRow;
        } else {
            this.nPrintLastPageIndex = pageIndex;
            this.nOldRow = this.nCurrentRow;
            this.nBedingungenOldRow = this.nBedingungenCurrentRow;
        }
        if (this.model.getDialogModus().equals("Accessoires") ? this.nCurrentRow >= this.teilelistentableModel.getRowCount() : (this.bedingungenTableModel.getRowCount() > 0 ? this.nBedingungenCurrentRow >= this.bedingungenTableModel.getRowCount() : this.nCurrentRow >= this.teilelistentableModel.getRowCount())) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int maxWidth = (int)pageFormat.getImageableWidth() - 1;
        int maxHeight = (int)pageFormat.getImageableHeight() - 2;
        Font headlinefont = UIHelper.getBoldFont().deriveFont(18.0f);
        Font tableheadlinefont = headlinefont.deriveFont(8.0f);
        Font textfont = UIHelper.getNormalFont().deriveFont(8.0f);
        int xPosition = 0;
        int yPosition = 0;
        if (pageIndex == 0) {
            g2d.setFont(headlinefont);
            fontSize = headlinefont.getSize();
            g2d.setColor(Color.black);
            yPosition = fontSize;
            String sUeberschrift = Resource.getInstance().getBildtafel();
            g2d.drawString(sUeberschrift, xPosition, yPosition);
            g2d.setColor(Color.gray);
            sUeberschrift = this.model.getBtNummerUeberschrift();
            g2d.drawString(sUeberschrift, xPosition, yPosition += fontSize);
            sUeberschrift = this.model.getFzgIdString();
            if (sUeberschrift != null) {
                g2d.drawString(sUeberschrift, xPosition, yPosition += fontSize);
            }
            yPosition += fontSize;
            if (this.image != null) {
                ImageObserver observer = new ImageIcon(this.image).getImageObserver();
                int imageHeight = this.image.getHeight(observer) * maxWidth / (2 * this.image.getWidth(observer));
                g2d.drawImage(this.image, xPosition, yPosition, maxWidth / 2, imageHeight, observer);
                yPosition += imageHeight;
            }
            yPosition += 20;
        }
        boolean left = false;
        boolean right = true;
        String[] tableHeaderStrings = null;
        String[] printHeaderStrings = null;
        String[] captionStrings = null;
        int[] columnBegin = null;
        int[] columnEnd = null;
        int[] columnFormat = null;
        if (this.model.getDialogModus().equals("Fahrzeugteile")) {
            printHeaderStrings = new String[]{"", Resource.getInstance().getNueNr(), Resource.getInstance().getTeilebenennung(), Resource.getInstance().getZusatz(), Resource.getInstance().getNueMe(), Resource.getInstance().getNueVon(), Resource.getInstance().getNueBis(), Resource.getInstance().getNueKat(), Resource.getInstance().getNueGe(), Resource.getInstance().getNueLe(), Resource.getInstance().getTeilenummer(), Resource.getInstance().getNueAe(), Resource.getInstance().getNueZi()};
            tableHeaderStrings = new String[]{"", Resource.getInstance().getNueNr(), Resource.getInstance().getTeilebenennung(), Resource.getInstance().getZusatz(), Resource.getInstance().getNueMe(), Resource.getInstance().getNueVon(), Resource.getInstance().getNueBis(), Resource.getInstance().getNueKat(), Resource.getInstance().getNueGe(), Resource.getInstance().getNueLe(), Resource.getInstance().getTeilenummer(), Resource.getInstance().getNueAe(), Resource.getInstance().getNueZi()};
            columnBegin = new int[]{0, 25, 60, 275, 350, 375, 400, 425, 450, 475, 500, 575, 600, 625};
            columnEnd = new int[]{15, 50, 265, 340, 365, 390, 415, 440, 465, 490, 565, 590, 615, 640};
            columnFormat = new int[]{1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1};
            captionStrings = new String[]{Resource.getInstance().getNueMe() + "\t" + Resource.getInstance().getMenge(), Resource.getInstance().getNueVon() + "\t" + Resource.getInstance().getEinsatzdatumTooltip(), Resource.getInstance().getNueBis() + "\t" + Resource.getInstance().getAuslaufdatumTooltip(), Resource.getInstance().getNueKat() + "\t" + Resource.getInstance().getKatalysator(), Resource.getInstance().getNueGe() + "\t" + Resource.getInstance().getGetriebe(), Resource.getInstance().getNueLe() + "\t" + Resource.getInstance().getLenkung(), Resource.getInstance().getNueAe() + "\t" + Resource.getInstance().getAustauschbarEntfallenKennzeichen(), Resource.getInstance().getNueZi() + "\t" + Resource.getInstance().getZusatzinformation()};
        } else {
            printHeaderStrings = new String[]{"", Resource.getInstance().getNueNr(), Resource.getInstance().getTeilebenennung(), Resource.getInstance().getZusatz(), Resource.getInstance().getMam(), Resource.getInstance().getVvm(), Resource.getInstance().getNueVon(), Resource.getInstance().getNueBis(), Resource.getInstance().getTeilenummer(), Resource.getInstance().getNueAe(), Resource.getInstance().getNueZi()};
            tableHeaderStrings = new String[]{"", Resource.getInstance().getNueNr(), Resource.getInstance().getTeilebenennung(), Resource.getInstance().getZusatz(), Resource.getInstance().getMam(), Resource.getInstance().getVvm(), Resource.getInstance().getNueVon(), Resource.getInstance().getNueBis(), Resource.getInstance().getTeilenummer(), Resource.getInstance().getNueAe(), Resource.getInstance().getNueZi()};
            columnBegin = new int[]{0, 25, 60, 275, 400, 425, 450, 475, 500, 575, 600};
            columnEnd = new int[]{15, 50, 265, 390, 415, 440, 465, 490, 565, 590, 615};
            columnFormat = new int[]{1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1};
            captionStrings = new String[]{Resource.getInstance().getNueMe() + "\t" + Resource.getInstance().getMenge(), Resource.getInstance().getNueMam() + "\t" + Resource.getInstance().getMindestabgabemenge(), Resource.getInstance().getNueVvm() + "\t" + Resource.getInstance().getVorverpackungsmenge(), Resource.getInstance().getNueVon() + "\t" + Resource.getInstance().getEinsatzdatum(), Resource.getInstance().getNueBis() + "\t" + Resource.getInstance().getAuslaufdatum(), Resource.getInstance().getNueAe() + "\t" + Resource.getInstance().getAustauschbarEntfallenKennzeichen(), Resource.getInstance().getNueZi() + "\t" + Resource.getInstance().getZusatzinformation()};
        }
        if (this.teilelistentableModel.getRowCount() > 0 && this.captionPrinted < 2) {
            ++this.captionPrinted;
            g2d.setFont(textfont);
            fontSize = textfont.getSize();
            g2d.setColor(Color.black);
            for (i = 0; i < captionStrings.length; ++i) {
                g2d.drawString(captionStrings[i].substring(0, captionStrings[i].indexOf("\t")), 25, yPosition += fontSize);
                g2d.drawString(captionStrings[i].substring(captionStrings[i].indexOf("\t") + 1, captionStrings[i].length()), 70, yPosition);
            }
        }
        if (this.nCurrentRow < this.teilelistentableModel.getRowCount()) {
            yPosition += 20;
            g2d.setFont(tableheadlinefont);
            fontSize = tableheadlinefont.getSize();
            g2d.setColor(Color.black);
            for (i = 0; i < printHeaderStrings.length; ++i) {
                if (columnFormat[i] == 0) {
                    g2d.drawString(printHeaderStrings[i], xPosition + columnBegin[i], yPosition);
                    continue;
                }
                value = printHeaderStrings[i];
                g2d.drawString(value, xPosition + this.getPosition(value, columnEnd[i], g2d, textfont), yPosition);
            }
        }
        g2d.setFont(textfont);
        fontSize = textfont.getSize();
        while (this.nCurrentRow < this.teilelistentableModel.getRowCount()) {
            nOffset = 0;
            if ((yPosition += fontSize + 3) + fontSize > maxHeight) {
                return 0;
            }
            GenericRow aktuelleZeile = this.teilelistentableModel.getRow(this.nCurrentRow);
            if (aktuelleZeile instanceof KomprimierungsZeile) {
                ImageObserver observer;
                Image img;
                KomprimierungsZeile aktuelleKomprimierungsZeile = (KomprimierungsZeile)aktuelleZeile;
                if (aktuelleKomprimierungsZeile.isKomprimiert()) {
                    img = ImageCache.getInstance().getImage("tree_plus.gif");
                    observer = new ImageIcon(img).getImageObserver();
                    g2d.drawImage(img, 30, yPosition - 7, 37, yPosition, 0, 0, img.getWidth(observer), img.getHeight(observer), observer);
                } else {
                    img = ImageCache.getInstance().getImage("tree_minus.gif");
                    observer = new ImageIcon(img).getImageObserver();
                    g2d.drawImage(img, 30, yPosition - 7, 37, yPosition, 0, 0, img.getWidth(observer), img.getHeight(observer), observer);
                }
            }
            for (int i2 = 1; i2 < this.teilelistentableModel.getColumnCount(); ++i2) {
                for (int j = 1; j < tableHeaderStrings.length; ++j) {
                    if (!this.teilelistentableModel.getConfiguration().getColumnName(i2).equals(tableHeaderStrings[j])) continue;
                    if (tableHeaderStrings[j].equals(Resource.getInstance().getTeilebenennung())) {
                        TextLayout layout;
                        String value2 = this.teilelistentableModel.getValueAt(this.nCurrentRow, i2).toString();
                        if (value2 == null || value2.equals("")) {
                            value2 = " ";
                        }
                        AttributedString cellText = new AttributedString(value2);
                        cellText.addAttribute(TextAttribute.FONT, textfont);
                        cellText.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
                        LineBreakMeasurer lineBreaker = new LineBreakMeasurer(cellText.getIterator(), g2d.getFontRenderContext());
                        boolean bFirstRow = true;
                        while ((layout = lineBreaker.nextLayout(columnEnd[j] - columnBegin[j])) != null) {
                            if (!bFirstRow) {
                                nOffset += fontSize;
                            }
                            bFirstRow = false;
                            layout.draw(g2d, xPosition + columnBegin[j], yPosition + nOffset);
                        }
                        continue;
                    }
                    Object oValue = this.teilelistentableModel.getValueAt(this.nCurrentRow, i2);
                    String sValue = "";
                    if (oValue != null) {
                        if (oValue instanceof DreieckTextAndTooltip) {
                            DreieckTextAndTooltip oTextAndTooltip = (DreieckTextAndTooltip)oValue;
                            sValue = oTextAndTooltip.getText();
                        } else {
                            sValue = oValue.toString();
                        }
                    }
                    if (columnFormat[j] == 0) {
                        g2d.drawString(sValue, xPosition + columnBegin[j], yPosition);
                        continue;
                    }
                    g2d.drawString(sValue.replace(',', '.'), xPosition + this.getPosition(sValue, columnEnd[j], g2d, textfont), yPosition);
                }
            }
            yPosition += nOffset;
            ++this.nCurrentRow;
        }
        if (this.model.getDialogModus().equals("Accessoires")) {
            return 0;
        }
        if (this.bedingungenTableModel.getRowCount() == 0) {
            return 0;
        }
        if (yPosition + 3 * fontSize + 20 > maxHeight) {
            return 0;
        }
        if (this.captionBedingungenPrinted < 2) {
            yPosition += 20;
            ++this.captionBedingungenPrinted;
            g2d.setFont(textfont);
            fontSize = textfont.getSize();
            g2d.setColor(Color.black);
            captionStrings = new String[]{Resource.getInstance().getJa() + "\t" + Resource.getInstance().getJaVorhanden(), Resource.getInstance().getNein() + "\t" + Resource.getInstance().getNeinNichtVorhanden(), Resource.getInstance().getNueFrage() + "\t" + Resource.getInstance().getNichtBekanntVorhanden()};
            for (i = 0; i < captionStrings.length; ++i) {
                g2d.drawString(captionStrings[i].substring(0, captionStrings[i].indexOf("\t")), 25, yPosition += fontSize);
                g2d.drawString(captionStrings[i].substring(captionStrings[i].indexOf("\t") + 1, captionStrings[i].length()), 70, yPosition);
            }
        }
        printHeaderStrings = new String[]{Resource.getInstance().getCode(), Resource.getInstance().getBenennung(), ""};
        tableHeaderStrings = new String[]{Resource.getInstance().getCode(), Resource.getInstance().getBenennung(), ""};
        columnBegin = new int[]{40, 75, 300};
        columnEnd = new int[]{65, 230, 350};
        columnFormat = new int[]{0, 0, 0};
        yPosition += 20;
        g2d.setFont(tableheadlinefont);
        fontSize = tableheadlinefont.getSize();
        g2d.setColor(Color.black);
        for (i = 0; i < printHeaderStrings.length; ++i) {
            if (columnFormat[i] == 0) {
                g2d.drawString(printHeaderStrings[i], xPosition + columnBegin[i], yPosition);
                continue;
            }
            value = printHeaderStrings[i];
            g2d.drawString(value, xPosition + this.getPosition(value, columnEnd[i], g2d, textfont), yPosition);
        }
        g2d.setFont(textfont);
        fontSize = textfont.getSize();
        while (this.nBedingungenCurrentRow < this.bedingungenTableModel.getRowCount()) {
            nOffset = 0;
            if ((yPosition += fontSize + 3) + fontSize > maxHeight) {
                return 0;
            }
            for (int i3 = 1; i3 < this.bedingungenTableModel.getColumnCount(); ++i3) {
                for (int j = 1; j < tableHeaderStrings.length; ++j) {
                    TextLayout layout;
                    if (!this.bedingungenTableModel.getColumnName(i3).equals(tableHeaderStrings[j]) || !tableHeaderStrings[j].equals(Resource.getInstance().getBenennung())) continue;
                    String value3 = this.bedingungenTableModel.getValueAt(this.nBedingungenCurrentRow, i3).toString();
                    if (value3 == null || value3.equals("")) {
                        value3 = " ";
                    }
                    AttributedString cellText = new AttributedString(value3);
                    cellText.addAttribute(TextAttribute.FONT, textfont);
                    cellText.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
                    LineBreakMeasurer lineBreaker = new LineBreakMeasurer(cellText.getIterator(), g2d.getFontRenderContext());
                    boolean bFirstRow = true;
                    while ((layout = lineBreaker.nextLayout(columnEnd[j] - columnBegin[j])) != null) {
                        if (!bFirstRow) {
                            nOffset += fontSize;
                        }
                        bFirstRow = false;
                        layout.draw(g2d, xPosition + columnBegin[j], yPosition + nOffset);
                    }
                }
            }
            BTEBedingungenTabelleModel.BedingungRow aktuelleBedingungsZeile = this.bedingungenTableModel.getRow(this.nBedingungenCurrentRow);
            String code = aktuelleBedingungsZeile.getCode();
            g2d.drawString(code, columnBegin[0], yPosition);
            String status = this.bedingungenTableModel.getStatusName(aktuelleBedingungsZeile.getStatus());
            g2d.drawString(status, columnBegin[2], yPosition);
            yPosition += nOffset;
            ++this.nBedingungenCurrentRow;
        }
        return 0;
    }

    private int getPosition(String value, int endPosition, Graphics2D g2d, Font textfont) {
        if (value == null || value.equals("")) {
            value = " ";
        }
        AttributedString cellText = new AttributedString(value);
        cellText.addAttribute(TextAttribute.FONT, textfont);
        cellText.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
        LineBreakMeasurer lineBreaker = new LineBreakMeasurer(cellText.getIterator(), g2d.getFontRenderContext());
        TextLayout layout = lineBreaker.nextLayout(1000.0f);
        float lText = layout.getAdvance();
        int pX = endPosition - (int)lText;
        return pX;
    }

    private void loadData() {
        TrfHashMap trfData = new TrfHashMap(null);
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addIconColumn("info.gif", Resource.getInstance().getTeileinformation());
        tableConfig.addIconColumn("tree_plus.gif", "");
        tableConfig.addColumn(Resource.getInstance().getNueNr(), 0, DreieckLabel.class, false, "00");
        tableConfig.setHeaderTooltip(2, Resource.getInstance().getNummer());
        tableConfig.addColumn(Resource.getInstance().getTeilebenennung(), 2, true, "0000000000000000000000000000000000000000");
        tableConfig.addColumn(Resource.getInstance().getZusatz(), 2, false, "000000000000000");
        if (this.model.getDialogModus().equals("Fahrzeugteile")) {
            tableConfig.addColumn(Resource.getInstance().getNueMe(), 0, false, "00");
            tableConfig.setHeaderTooltip(5, Resource.getInstance().getMenge());
            tableConfig.addColumn(Resource.getInstance().getNueVon(), 0, false, "00/00");
            tableConfig.setHeaderTooltip(6, Resource.getInstance().getEinsatzdatumTooltip());
            tableConfig.addColumn(Resource.getInstance().getNueBis(), 0, false, "00/00");
            tableConfig.setHeaderTooltip(7, Resource.getInstance().getAuslaufdatumTooltip());
            tableConfig.addColumn(Resource.getInstance().getNueKat(), 0, false, "0");
            tableConfig.setHeaderTooltip(8, Resource.getInstance().getKatalysator());
            tableConfig.addColumn(Resource.getInstance().getNueGe(), 0, false, "0");
            tableConfig.setHeaderTooltip(9, Resource.getInstance().getGetriebe());
            tableConfig.addColumn(Resource.getInstance().getNueLe(), 0, false, "0");
            tableConfig.setHeaderTooltip(10, Resource.getInstance().getLenkung());
            tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "00 00 0 000 000");
            tableConfig.addColumn(Resource.getInstance().getNueAe(), 0, false, "00");
            tableConfig.setHeaderTooltip(12, Resource.getInstance().getAustauschbarEntfallenKennzeichen());
            tableConfig.addColumn(Resource.getInstance().getNueZi(), 0, false, "00");
            tableConfig.setHeaderTooltip(13, Resource.getInstance().getZusatzinformation());
        } else {
            tableConfig.addColumn(Resource.getInstance().getMam(), 0, false, "000");
            tableConfig.setHeaderTooltip(5, Resource.getInstance().getMindestabgabemenge());
            tableConfig.addColumn(Resource.getInstance().getVvm(), 0, false, "000");
            tableConfig.setHeaderTooltip(6, Resource.getInstance().getVorverpackungsmenge());
            tableConfig.addColumn(Resource.getInstance().getNueVon(), 0, false, "00/00");
            tableConfig.setHeaderTooltip(7, Resource.getInstance().getEinsatzdatum());
            tableConfig.addColumn(Resource.getInstance().getNueBis(), 0, false, "00/00");
            tableConfig.setHeaderTooltip(8, Resource.getInstance().getAuslaufdatum());
            tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "00 00 0 000 000");
            tableConfig.addColumn(Resource.getInstance().getNueAe(), 0, false, "00");
            tableConfig.setHeaderTooltip(10, Resource.getInstance().getAustauschbarEntfallenKennzeichen());
            tableConfig.addColumn(Resource.getInstance().getNueZi(), 0, false, "00");
            tableConfig.setHeaderTooltip(11, Resource.getInstance().getZusatzinformation());
        }
        tableConfig.setUsePrototypeIcons(false);
        this.teilelistentableModel = new GenericTableModel(tableConfig);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        trfData.setValue("ids", this.mcSelIds);
        JavaSucheInfo oSucheInfo = GlobalObjects.getInstance().getEtkData().getSucheInfo();
        trfData.setValue("sucheinfo", oSucheInfo);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfData, Command.BT_GET_DRUCKANSICHT);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfData.getError() != null) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            log.error((Object)"Sonstiger Fehler", (Throwable)trfData.getError());
            JOptionPane.showMessageDialog(MainView.getInstance(), trfData.getError().getMessage(), Resource.getInstance().getDruckansicht(), 0);
            return;
        }
        Textteil oCurrentBTE = (Textteil)trfData.getValue("druckansicht");
        Vector<AbstractZeile> oZeilen = oCurrentBTE.getZeilen();
        for (AbstractZeile oZeile : oZeilen) {
            if (oZeile instanceof Zeile) {
                Zeile oZeileN = (Zeile)oZeile;
                if (oZeileN.isKomprimierungszeile()) {
                    int nKomprimierStatus = oZeileN.isKomprimiert() ? 1 : 0;
                    KomprimierungsZeile oZeileKomp = new KomprimierungsZeile(nKomprimierStatus, 1, oZeileN.getBildnummer(), 2, oZeileN.getTeilebenennung(), 3);
                    this.teilelistentableModel.addRow(oZeileKomp);
                } else if (this.model.getDialogModus().equals("Fahrzeugteile")) {
                    this.teilelistentableModel.addRow(new TeilenummernZeile(oZeileN.getId(), oZeileN.getSatzteilIndikator(), null, 1, oZeileN.getBildnummer(), null, 2, oZeileN.getTeilebenennung(), 3, oZeileN.getZusatz(), 4, oZeileN.getMenge(), 5, oZeileN.getEinsatzdatum(), 6, oZeileN.getAuslaufdatum(), 7, oZeileN.getKatalysator(), 8, oZeileN.getGetriebe(), 9, oZeileN.getLenkung(), 10, oZeileN.getTeilenummer(true), 11, oZeileN.getAustausch(), 12, oZeileN.getTechnischeInfo(), 14, oZeileN.isTeilASPG(), oZeileN.isTeilStecker(), new Integer(oZeileN.getPos()).toString(), 15, oZeileN.getAnkerPos()));
                } else {
                    this.teilelistentableModel.addRow(new TeilenummernZeile(oZeileN.getId(), oZeileN.getSatzteilIndikator(), null, 1, oZeileN.getBildnummer(), null, 2, oZeileN.getTeilebenennung(), 3, oZeileN.getZusatz(), 4, oZeileN.getMMG(), 5, oZeileN.getEMG(), 6, oZeileN.getEinsatzdatum(), 7, oZeileN.getAuslaufdatum(), 8, oZeileN.getTeilenummer(true), 9, oZeileN.getAustausch(), 10, oZeileN.getTechnischeInfo(), 11, oZeileN.isTeilASPG(), oZeileN.isTeilStecker(), new Integer(oZeileN.getPos()).toString(), 12, oZeileN.getAnkerPos()));
                }
            }
            if (oZeile instanceof KommZeile) {
                KommZeile oZeileK = (KommZeile)oZeile;
                this.teilelistentableModel.addRow(new KommentarZeile(oZeileK.getText(), 3, oZeileK.getZusatz(), 4, oZeileK.getDarstellung()));
            }
            if (!(oZeile instanceof BTVerweisZeile)) continue;
            BTVerweisZeile oZeileB = (BTVerweisZeile)oZeile;
            this.teilelistentableModel.addRow(new VerweisZeile(oZeileB.getBTENummer(), oZeileB.getText(), 3, "", 4));
        }
        if (this.model.getDialogModus().equals("Accessoires")) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        this.bedingungenTableModel = new BTEBedingungenTabelleModel(true);
        BTEBedingungsmenge oBedingungen = (BTEBedingungsmenge)trfData.getValue("bteBedingung");
        try {
            oBedingungen.goFirst();
            while (true) {
                Long lBedId = oBedingungen.getCurrentId();
                String sCode = oBedingungen.getCurrentCode();
                String sBenennung = oBedingungen.getCurrentBenennung();
                String sWert = oBedingungen.getCurrentWert();
                int nStatus = 3;
                if (sWert.equals("1")) {
                    nStatus = 1;
                } else if (sWert.equals("2")) {
                    nStatus = 2;
                }
                Color bedColor = null;
                boolean bBteBedingung = oBedingungen.isBteBedingung(oBedingungen.getCurrentId());
                boolean bExclusive = oBedingungen.isCurrentBedingungExclusive();
                if (bBteBedingung) {
                    bedColor = Color.blue;
                    if (!bExclusive || nStatus == 1) {
                        this.bedingungenTableModel.addBedingung(lBedId, sCode, sBenennung, nStatus, bedColor);
                    }
                }
                if (oBedingungen.hasNext()) {
                    oBedingungen.next();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

