/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.bte;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import rasterviewer.ImageViewerComponent;
import rasterviewer.event.HotspotEvent;
import rasterviewer.event.HotspotListener;
import rasterviewer.hotspot.HotspotManager;
import rasterviewer.hotspot.IHotspot;
import rasterviewer.hotspot.IHotspotManager;
import webetk.InvalidDataException;
import webetk.InvalidInitializationException;
import webetk.NoDataFoundException;
import webetk.app.BTEBedingungsmenge;
import webetk.app.Bedingungswert;
import webetk.app.aspg.Teil;
import webetk.app.bteanzeige.AbstractZeile;
import webetk.app.bteanzeige.BTVerweisZeile;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.app.bteanzeige.Hotspot;
import webetk.app.bteanzeige.KommZeile;
import webetk.app.bteanzeige.Zeile;
import webetk.app.cache.CBTEBedingungsmenge;
import webetk.app.etktext.ETKTextZeile;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.teileliste.Teileliste;
import webetk.communication.JavaFzgIdInfo;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.TrfHashMap;
import webetk.fix.Constants;
import webetk.javaclient.dialog.AbstractDlgMitTLView;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.HeaderString;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.bte.BTEController;
import webetk.javaclient.dialog.bte.BTEDruckansicht;
import webetk.javaclient.dialog.bte.BTEModel;
import webetk.javaclient.dialog.bte.ImageViewerToolbar;
import webetk.javaclient.dialog.bte.KleineTeilelistePanel;
import webetk.javaclient.dialog.bte.KommentarZeile;
import webetk.javaclient.dialog.bte.KommentarZeilenFettConfigurator;
import webetk.javaclient.dialog.bte.KomprimierungsZeile;
import webetk.javaclient.dialog.bte.MailAngaben;
import webetk.javaclient.dialog.bte.TeilenummernZeile;
import webetk.javaclient.dialog.bte.VerweisZeile;
import webetk.javaclient.dialog.bte.bedingungen.BTEBedingungenTabelleModel;
import webetk.javaclient.dialog.bte.bedingungen.BTETableCellRadiobuttonEditor;
import webetk.javaclient.dialog.bte.bedingungen.BTETableCellRadiobuttonRenderer;
import webetk.javaclient.dialog.btinfo.ETKText;
import webetk.javaclient.dialog.extras.teileliste.As2ClientScore;
import webetk.javaclient.dialog.extras.teileliste.DlgBestelllisteController;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteController;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.framework.TeilesucheZubehoer;
import webetk.javaclient.generictable.DreieckLabel;
import webetk.javaclient.generictable.DreieckTextAndTooltip;
import webetk.javaclient.generictable.GenericRow;
import webetk.javaclient.generictable.GenericRowAdapter;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.GenericTableMouseEventListener;
import webetk.javaclient.generictable.RealMultilineCellRenderer;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.javaclient.lookandfeel.WebETKTheme;
import webetk.javaclient.menuitem.MenuItemCopySachnummer;
import webetk.javaclient.menuitem.MenuItemEinzelteile;
import webetk.javaclient.menuitem.MenuItemInterpretation;
import webetk.javaclient.menuitem.MenuItemSteckerAnschlagteile;
import webetk.javaclient.menuitem.MenuItemTeileinformation;
import webetk.javaclient.menuitem.MenuItemTeileverwendungTeil;
import webetk.javaclient.utils.EmailTo;
import webetk.javaclient.workflow.MainWorkflowsteuerung;
import webetk.javaclient.workflow.WfTeilesucheFzg;
import webetk.javaclient.workflow.WfTeilesucheFzgGrafisch;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.javaclient.workflow.Workflowsteuerung;
import webetk.resources.Resource;

public class BTEView
extends AbstractDlgMitTLView {
    private static final long serialVersionUID = 1L;
    private final Logger log = Logger.getLogger(BTEView.class);
    private BTEModel model;
    private BTEController controller;
    private HeaderPanel panHeader;
    private JSplitPane verticalSplitPane;
    private JSplitPane horizontalSplitPane;
    private JSplitPane verticalSplitPane2;
    private JPanel panTextTeil = null;
    private ImageViewerComponent viewer;
    private final HotspotManager hotspotMgr = new HotspotManager();
    private final Collection<JComponent> menuEntries = new ArrayList<JComponent>();
    private final int mnVerticalLocation = 561;
    private final int mnHorizonalLocation = MainView.getInstance().getHeight() * 69 / 120 - 3;
    private final int mnHorizonalLocation2 = this.mnHorizonalLocation / 2;
    private final int mnVerticalLocationIPAC = 561;
    private final int mnHorizonalLocationIPAC = 421;
    private final int mnHorizonalLocation2IPAC = 210;
    private TableConfiguration tableConfig = null;
    private GenericTableModel tableModel = null;
    private GenericTable table = null;
    private TableConfiguration tableBedConfig = null;
    private BTEBedingungenTabelleModel tableBedModel = null;
    private GenericTable tableBed = null;
    private JScrollPane scTable = null;
    private BTETableCellRadiobuttonEditor radioEditor = null;
    private BTETableCellRadiobuttonRenderer radioRenderer = null;
    private KleineTeilelistePanel mKleineTeileliste = null;
    private boolean mbInitial = true;
    private boolean mbAnzeigenBedingungen = true;
    private JButtonEx buttonNVin = null;
    private JButtonEx buttonNext = null;
    private JButtonEx buttonPrev = null;
    private JButtonEx buttonHGNext = null;
    private JButtonEx buttonHGPrev = null;
    private JButtonEx buttonIpac = null;
    private JLabel labKeineZeilen = null;
    private JLabel labelNotAllCondValuesSet = null;
    private JPopupMenu menuPopup = null;
    private JMenuItem menuitemTeileinformation = null;
    private JMenuItem menuitemTeileverwendungTeil = null;
    private JMenuItem menuitemInterpretation = null;
    private JMenuItem menuitemEinzelteile = null;
    private JMenuItem menuitemCopySachnummer = null;
    private JMenuItem menuitemSteckerAnschlagteile = null;
    private JMenuItem menuitemAnsichtGrafik = null;
    private JMenuItem menuitemAnsichtText = null;
    private JMenuItem menuitemAnsichtNormal = null;
    private JMenuItem menuitemZurueckZuFI = null;
    private JMenuItem menuitemZurueckZuBtErgebnisse = null;
    private JMenuItem menuitemZurueckZuBtTnrErgebnisse = null;
    private JMenuItem menuitemZurueckZuTeilesuche = null;
    private JMenu menuBildtafel = null;
    private JMenuItem menuitemBedauswertungEin = null;
    private JMenuItem menuitemBedauswertungAus = null;
    private JMenuItem menuitemProduktionsdatumAnz = null;
    private JMenuItem menuitemTeilelisteAnz = null;
    private JMenuItem menuitemBildtafelDrucken = null;
    private boolean mbSuppressBedListener = true;
    private Image image;
    private boolean mbVerweisBildtafel = false;
    private int mnColTeileinfo = -1;
    private int mnColAufZuklappen = -1;
    private int mnColBildnummer = -1;
    private int mnColTeilebenennung = -1;
    private int mnColZusatz = -1;
    private int mnColMenge = -1;
    private int mnColEinsatzdatum = -1;
    private int mnColAuslaufdatum = -1;
    private int mnColKatalysator = -1;
    private int mnColGetriebe = -1;
    private int mnColLenkung = -1;
    private int mnColTeilenummer = -1;
    private int mnColAEKennzeichen = -1;
    private int mnColTechnischeInfo = -1;
    private int mnColMAM = -1;
    private int mnColVVM = -1;
    private int mnColPos = -1;
    private JButtonEx buttonHinweis;
    private JButtonEx buttonUsBedFilter = null;
    private JMenuBar filterMenuBar;
    private JMenu menuFilter;
    private JMenuItem filterItem;
    private JMenuItem resetItem;
    private JMenuItem onOffItem;
    private JButtonEx buttonTransfer;
    private JButtonEx buttonEigentAendern;

    @Override
    public void initMenus() {
        boolean bIsEmailButtonAvailable;
        boolean bUeberFgstnrIdenfifiziert;
        if (this.model.isIpacView()) {
            this.menuPopup = new JPopupMenu();
            this.menuitemTeileinformation = new MenuItemTeileinformation(this);
            this.menuPopup.add(this.menuitemTeileinformation);
            this.menuitemCopySachnummer = new MenuItemCopySachnummer(this);
            this.menuPopup.add(this.menuitemCopySachnummer);
            return;
        }
        final boolean bIsScoreTeilesuche = GlobalObjects.getInstance().getEtkData().isScoreTeilesuche();
        if (!bIsScoreTeilesuche) {
            this.menuPopup = new JPopupMenu();
            this.menuitemTeileinformation = new MenuItemTeileinformation(this);
            this.menuPopup.add(this.menuitemTeileinformation);
            if (this.model.getBildtafelType().equals("FZG") && !GlobalObjects.isScore()) {
                this.menuitemTeileverwendungTeil = new MenuItemTeileverwendungTeil("bt_anzeige", this.controller, this.model, this);
                this.menuPopup.add(this.menuitemTeileverwendungTeil);
            }
            this.menuitemInterpretation = new MenuItemInterpretation("bt_anzeige", this.controller, this.model, this);
            this.menuPopup.add(this.menuitemInterpretation);
            this.menuPopup.addSeparator();
            this.menuitemEinzelteile = new MenuItemEinzelteile("bt_anzeige", this.controller, this.model, this);
            this.menuPopup.add(this.menuitemEinzelteile);
            this.menuPopup.addSeparator();
            this.menuitemCopySachnummer = new MenuItemCopySachnummer(this);
            this.menuPopup.add(this.menuitemCopySachnummer);
            this.menuitemSteckerAnschlagteile = new MenuItemSteckerAnschlagteile(this);
            this.menuPopup.add(this.menuitemSteckerAnschlagteile);
        }
        this.menuEntries.clear();
        JMenu menuAnsicht = new JMenu(Resource.getInstance().getAnsicht());
        menuAnsicht.setBackground(UIHelper.getDarkerBackground());
        this.menuitemAnsichtGrafik = new JMenuItem(Resource.getInstance().getGrafikansicht());
        menuAnsicht.add(this.menuitemAnsichtGrafik);
        this.menuitemAnsichtText = new JMenuItem(Resource.getInstance().getTextansicht());
        menuAnsicht.add(this.menuitemAnsichtText);
        this.menuitemAnsichtNormal = new JMenuItem(Resource.getInstance().getNormalansicht());
        menuAnsicht.add(this.menuitemAnsichtNormal);
        this.menuEntries.add(menuAnsicht);
        this.menuitemAnsichtGrafik.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BTEView.this.controller.setAnsicht("grafik");
                BTEView.this.horizontalSplitPane.setDividerLocation(MainView.getInstance().getWidth());
                BTEView.this.verticalSplitPane.setDividerLocation(MainView.getInstance().getHeight());
                BTEView.this.repaint();
            }
        });
        this.menuitemAnsichtText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BTEView.this.controller.setAnsicht("text");
                BTEView.this.verticalSplitPane.setDividerLocation(0);
                BTEView.this.repaint();
            }
        });
        this.menuitemAnsichtNormal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BTEView.this.controller.setAnsicht("normal");
                BTEView.this.horizontalSplitPane.setDividerLocation(561);
                BTEView.this.verticalSplitPane.setDividerLocation(BTEView.this.mnHorizonalLocation);
                BTEView.this.repaint();
            }
        });
        this.menuBildtafel = new JMenu(Resource.getInstance().getBildtafel());
        this.menuBildtafel.setBackground(UIHelper.getDarkerBackground());
        boolean bSeparator = false;
        JavaFzgIdInfo oFzgIdInfo = GlobalObjects.getInstance().getFzgIdInfo();
        boolean bHasRechtProduktionsdatum = GlobalObjects.getInstance().getSessionInfo().hasRechtAnzeigeProddatum();
        Boolean bShowProddatumImmer = GlobalObjects.getInstance().getSessionInfo().getAlwaysDisplayProduktDate();
        boolean bl = bUeberFgstnrIdenfifiziert = oFzgIdInfo != null && oFzgIdInfo.getFahrgestellNr() != null && !oFzgIdInfo.getFahrgestellNr().equals("");
        if (bHasRechtProduktionsdatum && bUeberFgstnrIdenfifiziert && bShowProddatumImmer != null && !bShowProddatumImmer.booleanValue()) {
            this.menuitemProduktionsdatumAnz = new JMenuItem(Resource.getInstance().getAnzeigenDesProduktionsdatums());
            this.menuBildtafel.add(this.menuitemProduktionsdatumAnz);
            bSeparator = true;
        }
        if (bSeparator) {
            this.menuBildtafel.addSeparator();
        }
        if (!bIsScoreTeilesuche) {
            this.menuitemTeilelisteAnz = new JMenuItem(Resource.getInstance().getAnzeigenAusgewaehlteTeileliste());
            this.menuBildtafel.add(this.menuitemTeilelisteAnz);
            this.menuBildtafel.addSeparator();
        }
        this.menuitemBildtafelDrucken = new JMenuItem(Resource.getInstance().getDrucken());
        this.menuBildtafel.add(this.menuitemBildtafelDrucken);
        this.menuBildtafel.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                if (!bIsScoreTeilesuche) {
                    boolean bEnabled = false;
                    int nIndex = BTEView.this.comboTeileliste.getSelectedIndex();
                    if (nIndex > 0) {
                        ComboTeilelisteItem item = (ComboTeilelisteItem)BTEView.this.comboTeileliste.getItemAt(nIndex);
                        bEnabled = !item.isRrSapListe();
                    }
                    BTEView.this.menuitemTeilelisteAnz.setEnabled(bEnabled);
                }
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }
        });
        String mailServer = this.controller.getKonfiguration().getMailserver();
        if (mailServer != null && mailServer.trim().length() > 0) {
            this.menuBildtafel.addSeparator();
            this.menuBildtafel.add(this.createMenuItemMailDlg(Resource.getInstance().getAlsEMailVersenden() + "..."));
        }
        this.menuEntries.add(this.menuBildtafel);
        if (this.menuitemBedauswertungEin != null) {
            this.menuitemBedauswertungEin.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BTEView.this.applyBedAuswertung(true);
                }
            });
        }
        if (this.menuitemBedauswertungAus != null) {
            this.menuitemBedauswertungAus.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BTEView.this.applyBedAuswertung(false);
                }
            });
        }
        if (this.menuitemProduktionsdatumAnz != null) {
            this.menuitemProduktionsdatumAnz.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BTEView.this.showProduktionsdatum();
                }
            });
        }
        if (this.menuitemTeilelisteAnz != null) {
            this.menuitemTeilelisteAnz.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BTEView.this.showTeileliste();
                }
            });
        }
        if (this.menuitemBildtafelDrucken != null) {
            this.menuitemBildtafelDrucken.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BTEView.this.printDruckansicht();
                }
            });
        }
        boolean bSeperator = false;
        JMenu menuZurueck = new JMenu(Resource.getInstance().getZurueck());
        menuZurueck.setBackground(UIHelper.getDarkerBackground());
        if ((this.model.getDialogModus().equals("Fahrzeugteile") || this.model.getDialogModus().equals("ValueLine")) && !GlobalObjects.isScore()) {
            this.menuitemZurueckZuFI = new JMenuItem(Resource.getInstance().getZurFahrzeugidentifikation());
            this.menuitemZurueckZuFI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BTEView.this.zurueckZurFI();
                }
            });
            menuZurueck.add(this.menuitemZurueckZuFI);
            bSeperator = true;
        }
        if (!bIsScoreTeilesuche && this.model.isErlaubtZurueckZuTeilesuche()) {
            if (bSeperator) {
                menuZurueck.addSeparator();
            }
            this.menuitemZurueckZuTeilesuche = new JMenuItem(Resource.getInstance().getZurTeilesuche());
            this.menuitemZurueckZuTeilesuche.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BTEView.this.zurueckZurTeilesuche();
                }
            });
            menuZurueck.add(this.menuitemZurueckZuTeilesuche);
            bSeperator = true;
        }
        if (this.model.isVisibleZurueckZuTnrBtErgebnisse() || this.model.isVisibleZurueckZuBtErgebnisse()) {
            if (bSeperator) {
                menuZurueck.addSeparator();
            }
            if (this.model.isVisibleZurueckZuTnrBtErgebnisse()) {
                this.menuitemZurueckZuBtTnrErgebnisse = new JMenuItem(Resource.getInstance().getZurTnrBtUebersicht());
                this.menuitemZurueckZuBtTnrErgebnisse.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        BTEView.this.zurueckZuTnrBtErgebnissen();
                    }
                });
                if (!bIsScoreTeilesuche) {
                    menuZurueck.add(this.menuitemZurueckZuBtTnrErgebnisse);
                    this.menuitemZurueckZuBtTnrErgebnisse.setEnabled(this.model.isSensitivZurueckZuTnrBtErgebnisse());
                }
            }
            if (this.model.isVisibleZurueckZuBtErgebnisse()) {
                this.menuitemZurueckZuBtErgebnisse = new JMenuItem(Resource.getInstance().getZurBildtafelUebersicht());
                this.menuitemZurueckZuBtErgebnisse.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        BTEView.this.zurueckZuBtErgebnissen();
                    }
                });
                if (!bIsScoreTeilesuche) {
                    menuZurueck.add(this.menuitemZurueckZuBtErgebnisse);
                    this.menuitemZurueckZuBtErgebnisse.setEnabled(this.model.isSensitivZurueckZuBtErgebnisse());
                } else if (this.model.isSensitivZurueckZuBtErgebnisse()) {
                    menuZurueck.add(this.menuitemZurueckZuBtErgebnisse);
                    this.menuitemZurueckZuBtErgebnisse.setEnabled(true);
                }
            }
            bSeperator = true;
        }
        if (this.model.getDialogModus().equals("Fahrzeugteile") || this.model.getDialogModus().equals("ValueLine")) {
            Vector<String> oZurueckStrings = GlobalObjects.getInstance().getEtkData().getZurueckBezeichnungen();
            if (bSeperator && oZurueckStrings.size() > 0) {
                menuZurueck.addSeparator();
            }
            if (oZurueckStrings.size() > 0) {
                for (int i = 0; i < oZurueckStrings.size(); ++i) {
                    final String sBezeichnung = oZurueckStrings.get(i);
                    String sMenuitemText = GlobalObjects.getInstance().getEtkData().getZurueckMenuitemText(sBezeichnung);
                    JMenuItem menuitemZurueck = new JMenuItem(sMenuitemText);
                    menuitemZurueck.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AbstractDialogView oView = GlobalObjects.getInstance().getEtkData().getZurueckDialogView(sBezeichnung);
                            GlobalObjects.getInstance().getEtkData().removeZurueckDialog(sBezeichnung);
                            if (oView != null) {
                                oView.initMenus();
                                MainView.getInstance().displayDialogView(oView);
                            }
                        }
                    });
                    menuZurueck.add(menuitemZurueck);
                }
            }
        }
        if (menuZurueck.getSubElements().length > 0) {
            this.menuEntries.add(menuZurueck);
        }
        if (!GlobalObjects.isScore()) {
            ImageIcon icon = ImageCache.getInstance().getIcon("A_a_16x32.jpg");
            JButton buttonSchriftart = new JButton(icon);
            buttonSchriftart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean bSmallFont = BTEView.this.model.getSmallFont();
                    bSmallFont = !bSmallFont;
                    BTEView.this.model.setSmallFont(bSmallFont);
                    WebETKTheme.useGrosseSchriftart(!bSmallFont);
                    BTEView.this.controller.reinit();
                }
            });
            buttonSchriftart.setToolTipText(Resource.getInstance().getSchriftgroesseUmschalten());
            this.menuEntries.add(buttonSchriftart);
        }
        if (bIsEmailButtonAvailable = this.controller.isEmailButtonAvailable()) {
            JButton buttonEmail = new JButton("@");
            buttonEmail.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    BTEView.this.controller.sendMail(BTEView.this.model.getFzgIdString(), BTEView.this.model.getBtNummerUeberschrift());
                }
            });
            this.menuEntries.add(buttonEmail);
        }
    }

    protected JMenuItem createMenuItemMailDlg(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MailAngaben dlg = new MailAngaben();
                dlg.show();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    @Override
    protected void initComponents() {
        int i;
        super.initComponents();
        this.panHeader = this.model.getDialogModus().equals("Fahrzeugteile") || this.model.getDialogModus().equals("ValueLine") ? new HeaderPanel("", "", ImageCache.getInstance().getHeaderIcon("btfzg")) : new HeaderPanel("", "", ImageCache.getInstance().getHeaderIcon("btacc"));
        this.setBorder(UIHelper.getStandardBorder());
        this.initMenus();
        ImageViewerToolbar toolbar = new ImageViewerToolbar();
        this.viewer = new ImageViewerComponent((IHotspotManager)this.hotspotMgr, (JToolBar)toolbar, (JFrame)MainView.getInstance());
        toolbar.setPanel(this.viewer);
        this.viewer.setRenderQuality(3);
        this.viewer.moveMode();
        this.viewer.setImagePanelBackgroundColor(this.getBackground());
        this.hotspotMgr.setImageViewer(this.viewer);
        this.viewer.showHotspotRollover(false);
        this.viewer.showHotspots(false);
        this.viewer.setMinimumSize(new Dimension(100, 100));
        this.hotspotMgr.addHotspotListener(new HotspotListener(){
            Cursor oldCursor;

            public void mouseClicked(HotspotEvent e) {
                String id = e.getHotspot().getID();
                BTEView.this.log.debug((Object)("Clicked on " + id));
                BTEView.this.hightlightBildnummer(id, true);
            }

            public void mouseEntered(HotspotEvent e) {
                this.oldCursor = BTEView.this.viewer.getRenderer().getCursor();
                BTEView.this.viewer.getRenderer().setCursor(Cursor.getPredefinedCursor(12));
            }

            public void mouseExited(HotspotEvent e) {
                BTEView.this.viewer.getRenderer().setCursor(this.oldCursor);
            }

            public void mousePressed(HotspotEvent e) {
            }

            public void mouseReleased(HotspotEvent e) {
            }
        });
        this.horizontalSplitPane = new JSplitPane(1);
        this.horizontalSplitPane.setContinuousLayout(true);
        this.horizontalSplitPane.setTopComponent((Component)this.viewer);
        this.mKleineTeileliste = new KleineTeilelistePanel(this);
        if (this.model.getBildtafelType().equals("FZG")) {
            JPanel bedingungen = this.createBedingungenPanel();
            this.verticalSplitPane2 = new JSplitPane(0, bedingungen, this.mKleineTeileliste);
            this.verticalSplitPane2.setOneTouchExpandable(true);
            this.verticalSplitPane2.setContinuousLayout(true);
            if (this.model.isIpacView()) {
                this.verticalSplitPane2.setDividerLocation(210);
            } else {
                this.verticalSplitPane2.setDividerLocation(this.mnHorizonalLocation2);
            }
            this.horizontalSplitPane.setBottomComponent(this.verticalSplitPane2);
            this.mKleineTeileliste.setSplitPane(this.verticalSplitPane2);
        } else {
            this.horizontalSplitPane.setBottomComponent(this.mKleineTeileliste);
            this.mKleineTeileliste.setSplitPane(this.horizontalSplitPane);
        }
        this.horizontalSplitPane.setDividerLocation(561);
        this.horizontalSplitPane.setOneTouchExpandable(true);
        this.panTextTeil = this.createTextTeil();
        this.verticalSplitPane = new JSplitPane(0, this.horizontalSplitPane, this.panTextTeil);
        this.verticalSplitPane.setDividerLocation(this.mnHorizonalLocation);
        this.verticalSplitPane.setOneTouchExpandable(true);
        this.verticalSplitPane.setContinuousLayout(true);
        this.layoutAll();
        int index = -1;
        for (i = 0; i < this.horizontalSplitPane.getComponentCount(); ++i) {
            if (this.horizontalSplitPane.getComponent(i) == this.horizontalSplitPane.getLeftComponent() || this.horizontalSplitPane.getComponent(i) == this.horizontalSplitPane.getRightComponent() || this.horizontalSplitPane.getComponent(i) == null) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.horizontalSplitPane.getComponent(index).addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    BTEView.this.viewer.setIsCurrentlyResizingHint(true);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    BTEView.this.viewer.setIsCurrentlyResizingHint(false);
                    BTEView.this.viewer.repaint();
                }
            });
        }
        index = -1;
        for (i = 0; i < this.verticalSplitPane.getComponentCount(); ++i) {
            if (this.verticalSplitPane.getComponent(i) == this.verticalSplitPane.getLeftComponent() || this.verticalSplitPane.getComponent(i) == this.verticalSplitPane.getRightComponent() || this.verticalSplitPane.getComponent(i) == null) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.verticalSplitPane.getComponent(index).addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    BTEView.this.viewer.setIsCurrentlyResizingHint(true);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    BTEView.this.viewer.setIsCurrentlyResizingHint(false);
                    BTEView.this.viewer.repaint();
                }
            });
        }
    }

    private void hightlightBildnummer(String sBildnummer, boolean bMeldung) {
        if (sBildnummer == null) {
            return;
        }
        boolean kompZeile = false;
        CurrentBTE oCurrentBte = this.model.getCurrentBTE();
        if (oCurrentBte.hasKomprimierungszeile(sBildnummer)) {
            kompZeile = true;
            Collection<String> oExpandedBNBs = oCurrentBte.getExpandedZeilen();
            if (!oExpandedBNBs.contains(sBildnummer)) {
                this.controller.expandBildnummer(sBildnummer);
            } else {
                this.controller.collapseBildnummer(sBildnummer);
            }
            this.update();
        }
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            GenericRowAdapter oZeile;
            GenericRow row = this.tableModel.getRow(i);
            String sBildnummerComp = "";
            if (row instanceof TeilenummernZeile) {
                oZeile = (TeilenummernZeile)row;
                sBildnummerComp = ((TeilenummernZeile)oZeile).msBildnummer;
            } else if (row instanceof KomprimierungsZeile) {
                oZeile = (KomprimierungsZeile)row;
                sBildnummerComp = ((KomprimierungsZeile)oZeile).getBildnummer();
            }
            if (!sBildnummer.equals(sBildnummerComp)) continue;
            this.table.getTable().getSelectionModel().setSelectionInterval(i, i);
            this.table.getTable().setRowSelectionInterval(i, i);
            JScrollPane sc = this.table.getScrollPane();
            int nRowShowVisible = i <= 5 ? 0 : i - 5;
            Rectangle rect = this.table.getTable().getCellRect(nRowShowVisible, 0, true);
            Point p = rect.getLocation();
            p.y = i * this.table.getRowHeight();
            sc.getViewport().setViewPosition(p);
            sc.repaint();
            this.viewer.getRenderer().setCurrentHotspot(sBildnummer);
            this.viewer.getRenderer().repaint();
            sc.getViewport().setViewPosition(p);
            sc.repaint();
            return;
        }
        if (bMeldung) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getBtanzNoRowForHs(), Resource.getInstance().getProduktionsdatum(), 1);
        }
    }

    private void hightlightSachnummer(String sSachnummer) {
        if (sSachnummer == null) {
            return;
        }
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            TeilenummernZeile r;
            GenericRow row = this.tableModel.getRow(i);
            if (!(row instanceof TeilenummernZeile) || !sSachnummer.equals((r = (TeilenummernZeile)row).getSachnummer())) continue;
            this.table.getTable().addRowSelectionInterval(i, i);
            JScrollPane sc = this.table.getScrollPane();
            int nRowShowVisible = i <= 5 ? 0 : i - 5;
            Rectangle rect = this.table.getTable().getCellRect(nRowShowVisible, 0, true);
            sc.getViewport().setViewPosition(rect.getLocation());
        }
    }

    protected JPanel createTextTeil() {
        boolean bZeilenVorhandenAspg;
        Vector<AbstractZeile> oZeilen = this.model.getCurrentBTE().getZeilen();
        boolean bZeilenVorhanden = oZeilen != null && oZeilen.size() > 0;
        JPanel p = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(1, 1);
        l.setRowWeight(4, 1);
        p.setLayout(l);
        p.add((Component)this.createTeilelistePanel(), c.rc(2, 1));
        this.scTable = this.createTabelle();
        this.scTable.setMinimumSize(new Dimension(150, 30));
        p.add((Component)this.scTable, c.rc(4, 1));
        this.labKeineZeilen = new JLabel("  " + Resource.getInstance().getBtanzNoRowsFound());
        p.add((Component)this.labKeineZeilen, c.rc(4, 1, "lt"));
        this.labelNotAllCondValuesSet = new JLabel(" " + Resource.getInstance().getBteBooleanExpMsg());
        p.add((Component)this.labelNotAllCondValuesSet, c.rc(4, 1, "lt"));
        this.labelNotAllCondValuesSet.setVisible(false);
        if (this.model.getCurrentBTE().isMbBoolExpUsed() && !this.model.getCurrentBTE().getBedingungen().alleBedingungswerteEindeutig()) {
            this.scTable.setVisible(false);
            this.labKeineZeilen.setVisible(false);
            this.labelNotAllCondValuesSet.setVisible(true);
            p.repaint();
            return p;
        }
        boolean bl = bZeilenVorhandenAspg = this.model.getCurrentBTE().getZeilen() != null && this.model.getCurrentBTE().getZeilen().size() > 0;
        if (bZeilenVorhanden && bZeilenVorhandenAspg) {
            this.scTable.setVisible(true);
            this.labKeineZeilen.setVisible(false);
            p.repaint();
        } else {
            this.scTable.setVisible(false);
            this.labKeineZeilen.setVisible(true);
            p.repaint();
        }
        return p;
    }

    public void imageHasFinishedLoading(Image img) {
        System.out.println("Loading ended");
        this.viewer.setImage(img);
        this.image = img;
    }

    protected JScrollPane createTabelle() {
        int nCol = 0;
        KomprimierungsZeile.resetRenderer();
        this.tableConfig = new TableConfiguration();
        if (!GlobalObjects.getInstance().getEtkData().isScoreTeilesuche()) {
            this.tableConfig.addIconColumn("info.gif");
            this.mnColTeileinfo = nCol++;
        }
        this.tableConfig.addColumn(" ", 0, JLabel.class, false, KomprimierungsZeile.getAufklappenRenderer());
        this.mnColAufZuklappen = nCol++;
        this.tableConfig.addColumn(Resource.getInstance().getNueNr(), 0, DreieckLabel.class, false, "00");
        this.tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getNummer());
        this.mnColBildnummer = nCol++;
        this.tableConfig.addColumn(Resource.getInstance().getTeilebenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.mnColTeilebenennung = nCol++;
        this.tableConfig.addColumn(Resource.getInstance().getZusatz(), 2, true, "XXXXXXXXXXXXXXXX");
        this.mnColZusatz = nCol++;
        if (this.model.getBildtafelType().equals("FZG")) {
            this.tableConfig.addColumn(Resource.getInstance().getNueMe(), 0, false, "00");
            this.tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getMenge());
            this.mnColMenge = nCol++;
            this.tableConfig.addColumn(Resource.getInstance().getNueVon(), 0, false, "00/00");
            this.tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getEinsatzdatumTooltip());
            this.mnColEinsatzdatum = nCol++;
            this.tableConfig.addColumn(Resource.getInstance().getNueBis(), 0, false, "00/00");
            this.tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getAuslaufdatumTooltip());
            this.mnColAuslaufdatum = nCol++;
            this.tableConfig.addColumn(Resource.getInstance().getNueKat(), 0, false, "0");
            this.tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getKatalysator());
            this.mnColKatalysator = nCol++;
            this.tableConfig.addColumn(Resource.getInstance().getNueGe(), 0, false, "0");
            this.tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getGetriebe());
            this.mnColGetriebe = nCol++;
            this.tableConfig.addColumn(Resource.getInstance().getNueLe(), 0, false, "0");
            this.tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getLenkung());
            this.mnColLenkung = nCol++;
            this.tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, true, "00 00 0 000 0000");
            this.mnColTeilenummer = nCol++;
            this.tableConfig.addColumn(Resource.getInstance().getNueAe(), 0, false, "00");
            this.tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getAustauschbarEntfallenKennzeichen());
            this.mnColAEKennzeichen = nCol++;
            this.tableConfig.addColumn(Resource.getInstance().getNueZi(), 0, false, "00");
            this.tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getZusatzinformation());
            this.mnColTechnischeInfo = nCol++;
            if (System.getProperty("debugETK") != null && System.getProperty("debugETK").equals("true")) {
                this.tableConfig.addColumn("Debug Hilfe Pos", 0, false, "0000");
                this.mnColPos = nCol++;
            }
        } else {
            this.tableConfig.addColumn(Resource.getInstance().getNueMam(), 0, false, "000");
            this.tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getMindestabgabemenge());
            this.mnColMAM = nCol++;
            this.tableConfig.addColumn(Resource.getInstance().getNueVvm(), 0, false, "000");
            this.tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getVorverpackungsmenge());
            this.mnColVVM = nCol++;
            this.tableConfig.addColumn(Resource.getInstance().getNueVon(), 0, false, "00/00");
            this.tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getEinsatzdatum());
            this.mnColEinsatzdatum = nCol++;
            this.tableConfig.addColumn(Resource.getInstance().getNueBis(), 0, false, "00/00");
            this.tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getAuslaufdatum());
            this.mnColAuslaufdatum = nCol++;
            this.tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "00 00 0 000 0000");
            this.mnColTeilenummer = nCol++;
            this.tableConfig.addColumn(Resource.getInstance().getNueAe(), 0, false, "00");
            this.tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getAustauschbarEntfallenKennzeichen());
            this.mnColAEKennzeichen = nCol++;
            this.tableConfig.addColumn(Resource.getInstance().getNueZi(), 0, false, "00");
            this.tableConfig.setHeaderTooltip(nCol, Resource.getInstance().getZusatzinformation());
            this.mnColTechnischeInfo = nCol++;
            if (System.getProperty("debugETK") != null && System.getProperty("debugETK").equals("true")) {
                this.tableConfig.addColumn("Debug Hilfe Pos", 0, false, "0000");
                this.mnColPos = nCol++;
            }
        }
        RealMultilineCellRenderer teilebenennungsRenderer = new RealMultilineCellRenderer(new KommentarZeilenFettConfigurator());
        this.tableConfig.setRenderer(this.mnColTeilebenennung, (TableCellRenderer)teilebenennungsRenderer);
        this.tableConfig.setUsePrototypeIcons(false);
        this.tableModel = new GenericTableModel(this.tableConfig);
        this.table = new GenericTable(this.tableModel);
        this.table.getTable().setSelectionMode(2);
        if (this.mnColTeileinfo >= 0) {
            GenericTableMouseEventListener listenerTeileinfo = new GenericTableMouseEventListener(){

                @Override
                public void clickedOnCell(GenericTableMouseEvent e) {
                    if (BTEView.this.menuitemTeileinformation != null) {
                        ((MenuItemTeileinformation)BTEView.this.menuitemTeileinformation).showTeileinfo();
                    }
                }

                @Override
                public void clickedOnCellDouble(GenericTableMouseEvent evt) {
                }

                @Override
                public void popupOnCell(GenericTableMouseEvent evt) {
                }
            };
            this.table.addMouseListener(listenerTeileinfo, this.mnColTeileinfo);
        }
        if (this.mnColAufZuklappen >= 0) {
            GenericTableMouseEventListener listenerExpCol = new GenericTableMouseEventListener(){

                @Override
                public void clickedOnCell(GenericTableMouseEvent e) {
                    BTEView.this.expandOrCollapse(e.getRow());
                }

                @Override
                public void clickedOnCellDouble(GenericTableMouseEvent evt) {
                }

                @Override
                public void popupOnCell(GenericTableMouseEvent evt) {
                }
            };
            this.table.addMouseListener(listenerExpCol, this.mnColAufZuklappen);
        }
        GenericTableMouseEventListener listenerDoubleClick = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
                if (BTEView.this.tableModel.getRow(evt.getRow()) instanceof TeilenummernZeile) {
                    BTEView.this.uebernehmenInTeileliste();
                } else {
                    BTEView.this.pruefenEmailAdresseUndAufrufEmailProgramm((String)BTEView.this.tableModel.getRow(BTEView.this.table.getTable().getSelectedRow()).get(BTEView.this.mnColTeilebenennung));
                }
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        int nColCount = this.table.getTable().getColumnCount();
        for (int i = 2; i < nColCount; ++i) {
            this.table.addMouseListener(listenerDoubleClick, i);
        }
        this.table.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                String sId = null;
                if (BTEView.this.table.getTable().getSelectedRows().length == 1) {
                    GenericRow oZeile = BTEView.this.tableModel.getRow(BTEView.this.table.getTable().getSelectedRow());
                    if (oZeile.get(BTEView.this.mnColBildnummer) instanceof DreieckTextAndTooltip) {
                        DreieckTextAndTooltip oTextAndTooltip = (DreieckTextAndTooltip)oZeile.get(BTEView.this.mnColBildnummer);
                        sId = oTextAndTooltip.getText();
                    } else {
                        sId = (String)oZeile.get(BTEView.this.mnColBildnummer);
                    }
                    BTEView.this.log.info((Object)("Hotspot-Id:" + sId));
                    Iterator it = BTEView.this.hotspotMgr.getHotspotIterator();
                    int minX = 0;
                    int maxX = 0;
                    int minY = 0;
                    int maxY = 0;
                    boolean hotspotFound = false;
                    boolean firstHotspot = true;
                    if (!it.hasNext()) {
                        if (BTEView.this.viewer.getRenderer().getCurrentHotspot() != null) {
                            BTEView.this.viewer.getRenderer().setCurrentHotspot(null);
                            BTEView.this.viewer.getRenderer().repaint();
                        }
                        return;
                    }
                    while (it.hasNext()) {
                        IHotspot hs = (IHotspot)it.next();
                        if (!hs.getID().equals(sId)) continue;
                        hotspotFound = true;
                        int x = hs.getShape().x;
                        int y = hs.getShape().y;
                        int width = hs.getShape().width;
                        int height = hs.getShape().height;
                        if (firstHotspot) {
                            firstHotspot = false;
                            minX = x;
                            maxX = x + width;
                            minY = y;
                            maxY = y + height;
                            continue;
                        }
                        if (x + width > maxX) {
                            maxX = x + width;
                        }
                        if (x < minX) {
                            minX = x;
                        }
                        if (y + height > maxY) {
                            maxY = y + height;
                        }
                        if (y >= minY) continue;
                        minY = y;
                    }
                    BTEView.this.viewer.getRenderer().setCurrentHotspot(sId);
                    BTEView.this.viewer.getRenderer().repaint();
                    BTEView.this.viewer.getRenderer().revalidate();
                    int diffX = maxX - minX;
                    int diffY = maxY - minY;
                    Point2D.Float viewerStart = BTEView.this.viewer.getImageSpaceCoordinates((Point2D)new Point2D.Float(0.0f, 0.0f));
                    Point2D.Float viewerEnd = BTEView.this.viewer.getImageSpaceCoordinates((Point2D)new Point2D.Float(BTEView.this.viewer.getRenderer().getWidth(), BTEView.this.viewer.getRenderer().getHeight()));
                    BTEView.this.log.info((Object)viewerStart);
                    BTEView.this.log.info((Object)viewerEnd);
                    int viewerWidth = (int)(viewerEnd.getX() - viewerStart.getX());
                    int viewerHeight = (int)(viewerEnd.getY() - viewerStart.getY());
                    if (!((double)minX > viewerStart.getX() && (double)minX < viewerEnd.getX() && (double)maxX > viewerStart.getX() && (double)maxX < viewerEnd.getX() && (double)minY > viewerStart.getY() && (double)minY < viewerEnd.getY() && (double)maxY > viewerStart.getY() && (double)maxY < viewerEnd.getY())) {
                        if (diffX > viewerWidth || diffY > viewerHeight) {
                            BTEView.this.viewer.zoomFit();
                        } else {
                            int moveX = -(viewerWidth - diffX) / 2 + minX;
                            int moveY = -(viewerHeight - diffY) / 2 + minY;
                            if (hotspotFound) {
                                BTEView.this.viewer.moveImgSpace((float)moveX, (float)moveY);
                            }
                        }
                    }
                } else {
                    BTEView.this.viewer.getRenderer().setCurrentHotspot(null);
                    BTEView.this.viewer.getRenderer().repaint();
                    BTEView.this.viewer.getRenderer().revalidate();
                }
            }
        });
        GenericTableMouseEventListener listenerBtVerweis = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                BTEView.this.showVerweisBildtafel(e.getRow());
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerBtVerweis, this.mnColTeilebenennung);
        this.table.addMouseListener(listenerBtVerweis, this.mnColZusatz);
        this.table.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (BTEView.this.table.getTable().getSelectedRowCount() != 1) {
                    boolean bFound = false;
                    int[] aRows = BTEView.this.table.getTable().getSelectedRows();
                    for (int ii = 0; ii < aRows.length; ++ii) {
                        GenericRow oRow = BTEView.this.tableModel.getRow(aRows[ii]);
                        if (oRow == null || !(oRow instanceof TeilenummernZeile)) continue;
                        bFound = true;
                        break;
                    }
                    if (!bFound) {
                        return;
                    }
                    if (BTEView.this.menuitemInterpretation != null) {
                        BTEView.this.menuitemInterpretation.setEnabled(false);
                    }
                    if (BTEView.this.model.getBildtafelType().equals("FZG") && BTEView.this.menuitemTeileverwendungTeil != null) {
                        BTEView.this.menuitemTeileverwendungTeil.setEnabled(false);
                    }
                    if (BTEView.this.menuitemEinzelteile != null) {
                        BTEView.this.menuitemEinzelteile.setEnabled(false);
                    }
                    if (BTEView.this.menuitemCopySachnummer != null) {
                        BTEView.this.menuitemCopySachnummer.setEnabled(false);
                    }
                    if (BTEView.this.menuitemSteckerAnschlagteile != null) {
                        BTEView.this.menuitemSteckerAnschlagteile.setEnabled(false);
                    }
                } else {
                    int nSelectedRow = BTEView.this.table.getTable().getSelectedRow();
                    if (!(BTEView.this.tableModel.getRow(nSelectedRow) instanceof TeilenummernZeile)) {
                        return;
                    }
                    TeilenummernZeile oZeile = (TeilenummernZeile)BTEView.this.tableModel.getRow(nSelectedRow);
                    if (BTEView.this.menuitemEinzelteile != null) {
                        BTEView.this.menuitemEinzelteile.setEnabled(oZeile.isSatz());
                    }
                    if (BTEView.this.menuitemInterpretation != null) {
                        BTEView.this.menuitemInterpretation.setEnabled(((MenuItemInterpretation)BTEView.this.menuitemInterpretation).hatInterpretation());
                    }
                    if (BTEView.this.model.getBildtafelType().equals("FZG") && BTEView.this.menuitemTeileverwendungTeil != null) {
                        BTEView.this.menuitemTeileverwendungTeil.setEnabled(true);
                    }
                    if (BTEView.this.menuitemCopySachnummer != null) {
                        BTEView.this.menuitemCopySachnummer.setEnabled(true);
                    }
                    if (BTEView.this.menuitemSteckerAnschlagteile != null && BTEView.this.tableModel.getRow(BTEView.this.table.getSelectedRow()) instanceof TeilenummernZeile && ((TeilenummernZeile)BTEView.this.tableModel.getRow(BTEView.this.table.getSelectedRow())).isStecker()) {
                        BTEView.this.menuitemSteckerAnschlagteile.setEnabled(true);
                    } else if (BTEView.this.menuitemSteckerAnschlagteile != null) {
                        BTEView.this.menuitemSteckerAnschlagteile.setEnabled(false);
                    }
                }
                if (BTEView.this.menuPopup != null) {
                    BTEView.this.menuPopup.show(BTEView.this.table.getTable(), evt.getX(), evt.getY());
                }
            }
        });
        this.table.setAllowSizingSmallerThanMinimumWidth(false);
        if (this.mnColTeileinfo >= 0) {
            this.table.getTable().getColumnModel().getColumn(this.mnColTeileinfo).setMinWidth(20);
            this.table.getTable().getColumnModel().getColumn(this.mnColTeileinfo).setMaxWidth(20);
            this.table.getTable().getColumnModel().getColumn(this.mnColTeileinfo).setWidth(20);
        }
        if (this.mnColAufZuklappen >= 0) {
            this.table.getTable().getColumnModel().getColumn(this.mnColAufZuklappen).setMinWidth(20);
            this.table.getTable().getColumnModel().getColumn(this.mnColAufZuklappen).setMaxWidth(20);
            this.table.getTable().getColumnModel().getColumn(this.mnColAufZuklappen).setWidth(20);
        }
        return this.table.getScrollPane();
    }

    private JPanel createBedingungenPanel() {
        boolean bHasETKTexte;
        boolean bIsUsMarkt = this.model.isUSMarkt();
        boolean bIsAbBand = this.model.isAbBandVerbaut();
        boolean bIsIGDOM = this.model.isIGDOM();
        boolean bIsUS = bIsUsMarkt && bIsAbBand && bIsIGDOM;
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{0, 0, 0};
        int[] heights = new int[]{5, 0, 5, 0, 5};
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(2, 1);
        layout.setRowWeight(4, 1);
        panel.setLayout(layout);
        this.buttonUsBedFilter = new JButtonEx(Resource.getInstance().getUsFilterBedingungen());
        this.buttonUsBedFilter.setHorizontalAlignment(4);
        this.buttonUsBedFilter.setVisible(true);
        this.buttonUsBedFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BTEView.this.model.setUSMarkt(false);
                JPanel oBedingungenPanel = BTEView.this.createBedingungenPanel();
                BTEView.this.verticalSplitPane2 = new JSplitPane(0, oBedingungenPanel, BTEView.this.mKleineTeileliste);
                BTEView.this.verticalSplitPane2.setOneTouchExpandable(true);
                BTEView.this.verticalSplitPane2.setContinuousLayout(true);
                if (BTEView.this.model.isIpacView()) {
                    BTEView.this.verticalSplitPane2.setDividerLocation(210);
                } else {
                    BTEView.this.verticalSplitPane2.setDividerLocation(BTEView.this.mnHorizonalLocation2);
                }
                BTEView.this.horizontalSplitPane.setBottomComponent(BTEView.this.verticalSplitPane2);
                BTEView.this.mKleineTeileliste.setSplitPane(BTEView.this.verticalSplitPane2);
                BTEView.this.horizontalSplitPane.setDividerLocation(561);
                BTEView.this.horizontalSplitPane.setOneTouchExpandable(true);
                BTEView.this.repaint();
                BTEView.this.anzeigenBedingungen();
                boolean bHasETKTexte = BTEView.this.controller.hatETKTexte(true);
                BTEView.this.buttonHinweis.setVisible(bHasETKTexte);
            }
        });
        boolean bIsRotGefaerbt = this.model.isRotGefaerbt();
        this.filterMenuBar = new JMenuBar();
        this.filterItem = new JMenuItem(Resource.getInstance().getFilterAlleBedingungenEin());
        this.filterItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BTEView.this.changeBedingungFilter();
            }
        });
        this.menuFilter = new JMenu(Resource.getInstance().getFiltern());
        this.menuFilter.setBorderPainted(true);
        this.menuFilter.setBorder(BorderFactory.createEtchedBorder());
        if (bIsRotGefaerbt) {
            this.menuFilter.setIcon(ImageCache.getInstance().getIcon("aufklappen.gif"));
            this.menuFilter.setHorizontalTextPosition(2);
            this.filterItem.setText(Resource.getInstance().getFilterAlleBedingungenAus());
        } else {
            this.menuFilter.setIcon(ImageCache.getInstance().getIcon("aufklappen.gif"));
            this.menuFilter.setHorizontalTextPosition(2);
            this.filterItem.setText(Resource.getInstance().getFilterAlleBedingungenEin());
        }
        this.resetItem = new JMenuItem(Resource.getInstance().getUrspruenglicheBelegung());
        this.resetItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BTEView.this.resetBedingungen();
            }
        });
        this.onOffItem = new JMenuItem(Resource.getInstance().getBedingungsfilterAus());
        this.applyBooleanExpFlag(this.model.getCurrentBTE().isMbBoolExpUsed());
        this.onOffItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BTEView.this.model.getBedAuswertung()) {
                    BTEView.this.applyBedAuswertung(false);
                } else {
                    BTEView.this.applyBedAuswertung(true);
                }
            }
        });
        this.filterMenuBar.add(this.menuFilter);
        this.menuFilter.add(this.filterItem);
        this.menuFilter.add(this.resetItem);
        this.menuFilter.add(this.onOffItem);
        this.buttonHinweis = new JButtonEx("Hinweis...", ImageCache.getInstance().getIcon("info.gif"));
        this.buttonHinweis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                boolean bIgnoreAngezeigtFlag = true;
                boolean bSetAngezeigt = true;
                BTEView.this.anzeigenETKTexte(bIgnoreAngezeigtFlag, bSetAngezeigt);
            }
        });
        JPanel buttonPanel = new JPanel();
        int[] buttonPanelWidths = new int[]{5, -4, 0, -2, 5};
        int[] buttonPanelHeights = new int[]{0};
        HIGLayout buttonPanelLayout = new HIGLayout(buttonPanelWidths, buttonPanelHeights);
        buttonPanelLayout.setColumnWeight(2, 2);
        buttonPanel.setLayout(buttonPanelLayout);
        if (bIsUS) {
            buttonPanel.add((Component)this.buttonUsBedFilter, c.rc(1, 2, "l"));
        } else {
            buttonPanel.add((Component)this.filterMenuBar, c.rc(1, 2, "l"));
        }
        buttonPanel.add((Component)this.buttonHinweis, c.rc(1, 4, "r"));
        buttonPanel.setVisible(true);
        JScrollPane oBedingungenPanel = this.createBedingungenTabelle();
        if (bIsUS) {
            oBedingungenPanel.setVisible(false);
            CurrentBTE oCurrentBTE = this.model.getCurrentBTE();
            boolean bHasBedingungen = oCurrentBTE.hasBedingungen();
            if (bHasBedingungen) {
                this.buttonUsBedFilter.setVisible(true);
            } else {
                this.buttonUsBedFilter.setVisible(false);
            }
        }
        if (bHasETKTexte = this.controller.hatETKTexte(true)) {
            this.buttonHinweis.setVisible(true);
        } else {
            this.buttonHinweis.setVisible(false);
        }
        panel.add((Component)buttonPanel, c.rc(2, 2, "lr"));
        panel.add((Component)oBedingungenPanel, c.rc(4, 2));
        panel.setVisible(true);
        return panel;
    }

    protected JScrollPane createBedingungenTabelle() {
        this.tableBedConfig = new TableConfiguration();
        this.tableBedConfig.addColumn(Resource.getInstance().getJa(), 0, Object.class, false, 1);
        this.tableBedConfig.setHeaderTooltip(0, Resource.getInstance().getJaVorhanden());
        this.tableBedConfig.addColumn(Resource.getInstance().getNein(), 0, Object.class, false, 1);
        this.tableBedConfig.setHeaderTooltip(1, Resource.getInstance().getNeinNichtVorhanden());
        this.tableBedConfig.addColumn(Resource.getInstance().getFrage(), 0, Object.class, false, 1);
        this.tableBedConfig.setHeaderTooltip(2, Resource.getInstance().getNichtBekanntVorhanden());
        this.tableBedConfig.addColumn(Resource.getInstance().getCode(), 2, true, "XXXXX");
        this.tableBedConfig.addColumn(Resource.getInstance().getBenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        ColoredTableRenderer renderer = new ColoredTableRenderer();
        this.tableBedConfig.setRenderer(3, (TableCellRenderer)renderer);
        this.tableBedConfig.setRenderer(4, (TableCellRenderer)renderer);
        this.tableBedModel = new BTEBedingungenTabelleModel(true){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int rowIndex, int mColIndex) {
                return mColIndex < 3;
            }
        };
        this.tableBedModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (BTEView.this.mbSuppressBedListener) {
                    return;
                }
                if (e.getColumn() != 0) {
                    return;
                }
                BTEView.this.changeBedingung(e.getFirstRow());
            }
        });
        this.radioEditor = new BTETableCellRadiobuttonEditor();
        this.tableBedConfig.setEditor(Resource.getInstance().getJa(), (TableCellEditor)this.radioEditor);
        this.tableBedConfig.setEditor(Resource.getInstance().getNein(), (TableCellEditor)this.radioEditor);
        this.tableBedConfig.setEditor(Resource.getInstance().getFrage(), (TableCellEditor)this.radioEditor);
        this.radioRenderer = new BTETableCellRadiobuttonRenderer();
        this.tableBedConfig.setRenderer(Resource.getInstance().getJa(), (TableCellRenderer)this.radioRenderer);
        this.tableBedConfig.setRenderer(Resource.getInstance().getNein(), (TableCellRenderer)this.radioRenderer);
        this.tableBedConfig.setRenderer(Resource.getInstance().getFrage(), (TableCellRenderer)this.radioRenderer);
        this.tableBed = new GenericTable((TableModel)this.tableBedModel, this.tableBedConfig);
        this.tableBed.setAllowSizingSmallerThanMinimumWidth(false);
        this.tableBed.getTable().setSelectionMode(0);
        JScrollPane bedingungen = this.tableBed.getScrollPane();
        bedingungen.setVisible(true);
        CurrentBTE oCurrentBTE = this.model.getCurrentBTE();
        boolean bHasBedingungen = oCurrentBTE.hasBedingungen();
        bedingungen.setMinimumSize(new Dimension(150, 100));
        if (bHasBedingungen) {
            this.tableBed.setVisible(true);
            bedingungen.setVisible(true);
        } else {
            this.tableBed.setVisible(false);
            bedingungen.setVisible(false);
        }
        return bedingungen;
    }

    private void layoutAll() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panHeader, "North");
        this.add((Component)this.verticalSplitPane, "Center");
    }

    protected JPanel createTeilelistePanel() {
        int indxOfStretch;
        int[] w;
        if (!GlobalObjects.getInstance().getEtkData().isScoreTeilesuche()) {
            this.buttonUebernehmen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BTEView.this.uebernehmenInTeileliste();
                }
            });
        }
        this.buttonTransfer = new JButtonEx(Resource.getInstance().getTransfer());
        this.buttonTransfer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.getInstance().setVisible(false);
            }
        });
        this.buttonEigentAendern = new JButtonEx(Resource.getInstance().getEigentuemerAendern());
        this.buttonEigentAendern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int retVal = As2ClientScore.getInstance().eigentuemerAendern();
                if (retVal == 0) {
                    MainView.getInstance().setVisible(false);
                } else {
                    BTEView.this.log.debug((Object)"Eigent\u00fcmer \u00c4ndern abgebrochen");
                }
            }
        });
        this.buttonIpac = new JButtonEx(Resource.getInstance().getZubehoerprodukte());
        this.buttonIpac.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainView mainView = MainView.getInstance();
                TeilesucheZubehoer.callIpac(mainView, BTEView.this.model.getCurrentBTE().getBTENr());
            }
        });
        this.buttonNext = new JButtonEx(Resource.getInstance().getBt(), ImageCache.getInstance().getIcon("scrollend.gif"));
        this.buttonNext.setHorizontalTextPosition(2);
        this.buttonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BTEView.this.controller.ladenBildtafelNext(BTEView.this.mbVerweisBildtafel);
                if (BTEView.this.mbVerweisBildtafel) {
                    BTEView.this.controller.loadGrafik();
                    BTEView.this.mbVerweisBildtafel = false;
                    BTEView.this.mbInitial = true;
                    BTEView.this.update();
                }
            }
        });
        this.buttonPrev = new JButtonEx(Resource.getInstance().getBt(), ImageCache.getInstance().getIcon("scrollhome.gif"));
        this.buttonPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BTEView.this.controller.ladenBildtafelPrev(BTEView.this.mbVerweisBildtafel);
                if (BTEView.this.mbVerweisBildtafel) {
                    BTEView.this.controller.loadGrafik();
                    BTEView.this.mbVerweisBildtafel = false;
                    BTEView.this.mbInitial = true;
                    BTEView.this.update();
                }
            }
        });
        this.buttonHGPrev = new JButtonEx(Resource.getInstance().getHg(), ImageCache.getInstance().getIcon("scrollhome.gif"));
        this.buttonHGPrev.setEnabled(this.model.getIndexHGPrev() != -1);
        this.buttonHGPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BTEView.this.suchenHGPrev();
            }
        });
        this.buttonHGNext = new JButtonEx(Resource.getInstance().getHg(), ImageCache.getInstance().getIcon("scrollend.gif"));
        this.buttonHGNext.setHorizontalTextPosition(2);
        this.buttonHGNext.setEnabled(this.model.getIndexHGNext() != -1);
        this.buttonHGNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BTEView.this.suchenHGNext();
            }
        });
        this.buttonNVin = new JButtonEx(Resource.getInstance().getVinEingeben());
        this.buttonNVin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BTEView.this.nachtraeglicheEingabeVIN();
            }
        });
        JPanel p = new JPanel();
        boolean isScore = GlobalObjects.isScore();
        if (!isScore) {
            w = new int[]{10, 0, 5, 0, 5, 0, 10, 0, 5, 0, 10, 0, 10, -16, 5, -14, 10, -20, 5, -18, 10};
            indxOfStretch = 11;
        } else {
            w = new int[]{10, 0, 5, 0, 5, 0, 5, 0, 10, 0, 10, -14, 5, -12, 5, -18, 5, -16, 10, -20, 5, -18, 10};
            indxOfStretch = 13;
        }
        int[] h = new int[]{5, 0, 5};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(indxOfStretch, 1);
        HIGConstraints c = new HIGConstraints();
        int colIndx = 0;
        p.setLayout(hl);
        if (!GlobalObjects.getInstance().getEtkData().isScoreTeilesuche()) {
            if (this.model.isIpacView()) {
                colIndx += 8;
            } else {
                p.add((Component)this.labTeileliste, c.rc(2, colIndx += 2, "l"));
                p.add((Component)this.comboTeileliste, c.rc(2, colIndx += 2, "l"));
                p.add((Component)this.buttonUebernehmen, c.rc(2, colIndx += 2, "l"));
                if (isScore) {
                    p.add((Component)this.buttonTransfer, c.rc(2, colIndx += 2, "lr"));
                    p.add((Component)this.buttonEigentAendern, c.rc(2, colIndx += 2, "lr"));
                } else {
                    colIndx += 2;
                }
            }
        }
        p.add((Component)this.buttonNVin, c.rc(2, colIndx += 2));
        if (this.model.showNVinButton()) {
            this.buttonNVin.setVisible(true);
        } else {
            this.buttonNVin.setVisible(false);
        }
        colIndx += 2;
        p.add((Component)this.buttonHGPrev, c.rc(2, colIndx += 2));
        p.add((Component)this.buttonHGNext, c.rc(2, colIndx += 2));
        p.add((Component)this.buttonPrev, c.rc(2, colIndx += 2));
        p.add((Component)this.buttonNext, c.rc(2, colIndx += 2));
        return p;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Iterator<JComponent> getMenus() {
        return this.menuEntries.iterator();
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        super.init(oDlgModel, oDlgController);
        this.model = (BTEModel)oDlgModel;
        this.controller = (BTEController)oDlgController;
        if (this.model.getSmallFont()) {
            WebETKTheme.useGrosseSchriftart(false);
        }
        this.initComponents();
        if (this.model.isIpacView()) {
            this.horizontalSplitPane.setDividerLocation(561);
            this.verticalSplitPane.setDividerLocation(421);
        } else if (this.controller.getAnsicht().equals("grafik")) {
            this.horizontalSplitPane.setDividerLocation(MainView.getInstance().getWidth());
            this.verticalSplitPane.setDividerLocation(MainView.getInstance().getHeight());
        } else if (this.controller.getAnsicht().equals("text")) {
            this.verticalSplitPane.setDividerLocation(0);
        } else {
            this.horizontalSplitPane.setDividerLocation(561);
            this.verticalSplitPane.setDividerLocation(this.mnHorizonalLocation);
        }
        this.controller.loadTeilelistenIDs();
        this.controller.loadGrafik();
        this.update();
    }

    @Override
    public void update() {
        if (this.mbInitial) {
            HeaderString oHeaderString1;
            String sSmallTitle;
            String sBigTitel = this.model.getDialogTitel();
            String dlgModus = this.model.getDialogModus();
            if (!this.model.getNachruestungenRelevant() && dlgModus != null && !dlgModus.equals("Accessoires")) {
                sBigTitel = sBigTitel + " - " + Resource.getInstance().getNachruestungenNichtBeruecksichtigt();
            }
            if (this.model.getBildtafelType().equals("FZG") && this.model.getBedAuswertung()) {
                sBigTitel = sBigTitel + " - " + Resource.getInstance().getGefiltert();
            }
            if (dlgModus != null && dlgModus.equals("ValueLine")) {
                sBigTitel = sBigTitel + " - " + Resource.getInstance().getValueLine();
            }
            this.panHeader.setBigTitle(sBigTitel);
            Vector<HeaderString> cSmallTitles = new Vector<HeaderString>();
            if (dlgModus != null && (dlgModus.equals("Fahrzeugteile") || dlgModus.equals("ValueLine"))) {
                sSmallTitle = this.model.getFzgIdString() + ": ";
                oHeaderString1 = new HeaderString(sSmallTitle, false);
                cSmallTitles.add(oHeaderString1);
                String sSmallTitleBold = this.model.getBtNummerUeberschrift();
                if (sSmallTitle.length() + sSmallTitleBold.length() > BTEView.getMaxZeichenAnzahl()) {
                    if (sSmallTitle.length() > BTEView.getMaxZeichenAnzahl()) {
                        sSmallTitleBold = "...";
                    } else {
                        int anzZeichen = BTEView.getMaxZeichenAnzahl() - sSmallTitle.length() - 3;
                        if (anzZeichen < 0) {
                            anzZeichen = 0;
                        }
                        if (anzZeichen > sSmallTitleBold.length()) {
                            anzZeichen = sSmallTitleBold.length();
                        }
                        sSmallTitleBold = sSmallTitleBold.substring(0, anzZeichen) + "...";
                    }
                }
                HeaderString oHeaderString2 = new HeaderString(sSmallTitleBold, true);
                cSmallTitles.add(oHeaderString2);
                this.panHeader.setToolTipText(this.model.getBtNummerUeberschrift());
            } else {
                sSmallTitle = this.model.getBtNummerUeberschrift();
                oHeaderString1 = new HeaderString(sSmallTitle, true);
                cSmallTitles.add(oHeaderString1);
            }
            this.panHeader.setSmallTitles(cSmallTitles);
            this.panHeader.repaint();
            this.anzeigenGrafik();
            this.updateTeilelisten();
            this.model.getCurrentBTE().setBildZoomed(true);
            Collection<Hotspot> c = this.model.getCurrentBTE().getHotspots();
            for (Hotspot hs : c) {
                String id = hs.getPosNr();
                this.log.debug((Object)("Adding Hotspot posNr=" + id + ", left=" + hs.getTopLeftX() + ", top=" + hs.getTopLeftY() + ", right=" + hs.getBottomRightX() + " bottom=" + hs.getBottomRightY()));
                this.hotspotMgr.addHotspot(id, hs.getTopLeftX(), hs.getTopLeftY(), hs.getBottomRightX(), hs.getBottomRightY());
            }
        }
        if (this.mbAnzeigenBedingungen) {
            this.mbAnzeigenBedingungen = false;
            this.anzeigenBedingungen();
        }
        boolean isVisible = this.hasBedingungen();
        if (this.filterMenuBar != null) {
            this.filterMenuBar.setVisible(isVisible);
        }
        this.anzeigenZeilen();
        if (this.mbInitial) {
            this.hightlightSachnummer(this.model.getSachnummerSuch());
        }
        if (this.mbVerweisBildtafel) {
            if (this.buttonPrev != null) {
                this.buttonPrev.setEnabled(true);
            }
            if (this.buttonNext != null) {
                this.buttonNext.setVisible(false);
            }
        } else {
            if (this.buttonPrev != null) {
                this.buttonPrev.setEnabled(this.model.hasPrevBT());
            }
            if (this.buttonNext != null) {
                this.buttonNext.setVisible(true);
                this.buttonNext.setEnabled(this.model.hasNextBT());
            }
        }
        CBTEBedingungsmenge oBTECache = CBTEBedingungsmenge.getObject();
        CurrentBTE oCurrentBTE = this.model.getCurrentBTE();
        if (oCurrentBTE == null) {
            this.mbInitial = false;
            return;
        }
        BTEBedingungsmenge oBTEBedingungsmenge = oCurrentBTE.getBedingungen();
        if (oBTEBedingungsmenge == null) {
            this.mbInitial = false;
            return;
        }
        if (!oBTECache.exists(oBTEBedingungsmenge)) {
            String message;
            try {
                BTEBedingungsmenge copy = oBTEBedingungsmenge.copy();
                copy.goFirst();
                boolean bFinished = false;
                while (!bFinished) {
                    Long lCurrentBedID = copy.getCurrentId();
                    Iterator<BTEBedingungsmenge> itr = oBTECache.iterator();
                    boolean bFinishedCache = false;
                    while (itr.hasNext() && !bFinishedCache) {
                        BTEBedingungsmenge oCacheBed = itr.next();
                        boolean bFinishedCacheBedingungen = false;
                        oCacheBed.goFirst();
                        while (!bFinishedCacheBedingungen) {
                            Long lCacheBedID = oCacheBed.getCurrentId();
                            String sCacheBedWert = oCacheBed.getCurrentWert();
                            if (lCurrentBedID.equals(lCacheBedID)) {
                                bFinishedCacheBedingungen = true;
                                bFinishedCache = true;
                                copy.setBedWert(lCurrentBedID, new Bedingungswert(sCacheBedWert));
                            }
                            if (oCacheBed.hasNext()) {
                                oCacheBed.next();
                                continue;
                            }
                            bFinishedCacheBedingungen = true;
                        }
                    }
                    if (copy.hasNext()) {
                        copy.next();
                        continue;
                    }
                    bFinished = true;
                }
                oBTECache.add(copy);
                this.mbInitial = true;
                return;
            }
            catch (NoDataFoundException exc) {
                message = exc.getMessage();
                this.log.error((Object)("Error when trying to check all condition values of the current BTE: " + message));
            }
            catch (CloneNotSupportedException exc) {
                message = exc.getMessage();
                this.log.error((Object)("Error when trying to create a copy of the condition values for adding to the cache: " + message));
            }
            catch (InvalidInitializationException exc) {
                message = exc.getMessage();
                this.log.error((Object)("Error when trying to create a copy of the condition values for adding to the cache: " + message));
            }
            catch (InvalidDataException exc) {
                message = exc.getMessage();
                this.log.error((Object)("Error when trying to create a copy of the condition values for adding to the cache: " + message));
            }
        }
        this.mbInitial = false;
    }

    private boolean hasBedingungen() {
        CurrentBTE oCurrentBTE = this.model.getCurrentBTE();
        if (oCurrentBTE == null) {
            return false;
        }
        BTEBedingungsmenge oBTEBedingungen = oCurrentBTE.getBedingungen();
        if (oBTEBedingungen == null) {
            return false;
        }
        try {
            oBTEBedingungen.goFirst();
            while (true) {
                Long lBedId;
                if ((lBedId = oBTEBedingungen.getCurrentId()) == null) {
                    if (oBTEBedingungen.hasNext()) {
                        oBTEBedingungen.next();
                        continue;
                    }
                } else {
                    if (oBTEBedingungen.isBteBedingung(lBedId)) {
                        return true;
                    }
                    if (oBTEBedingungen.hasNext()) {
                        oBTEBedingungen.next();
                        continue;
                    }
                }
                break;
            }
        }
        catch (NoDataFoundException exc) {
            return false;
        }
        return false;
    }

    protected boolean ermittleSelTeile(Collection<Teil> cTeile, Collection<String> cMenge) {
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        boolean bVerbaumenge = oLoginInfo.getSettings().getVerbaumenge();
        GenericTable jTable = this.table.getTable();
        int nCountSelectedRows = jTable.getSelectedRowCount();
        if (nCountSelectedRows == 0) {
            return false;
        }
        boolean bKompZeilenSelektiert = false;
        ArrayList<String> sachnrList = new ArrayList<String>();
        int[] selectedRows = jTable.getSelectedRows();
        for (int i = 0; i < nCountSelectedRows; ++i) {
            TeilenummernZeile oZeile;
            Teil teil = new Teil();
            int nRow = selectedRows[i];
            if (this.tableModel.getRow(nRow) instanceof KomprimierungsZeile) {
                bKompZeilenSelektiert = true;
            }
            if (!(this.tableModel.getRow(nRow) instanceof TeilenummernZeile) || (oZeile = (TeilenummernZeile)this.tableModel.getRow(nRow)).getAnkerPos() != 0) continue;
            String sSachnummer = oZeile.getSachnummer();
            String sTeilenummer = oZeile.getTeilenummer();
            if (sTeilenummer.trim().length() == 0) continue;
            String HG = sTeilenummer.trim().substring(0, 2);
            String UG = sTeilenummer.trim().substring(3, 5);
            boolean bIsAspgTeil = oZeile.isAspgTeil();
            String sMenge = "1";
            if (bVerbaumenge && (sMenge = (String)oZeile.get(5)).equals("X")) {
                sMenge = "1";
            }
            teil.setSachnummer(sSachnummer);
            teil.setMenge(sMenge);
            teil.setHG(HG);
            teil.setUG(UG);
            teil.setBenennung(oZeile.getBenennung());
            teil.setZusatz(oZeile.getBenennungZusatz());
            if (sachnrList.contains(sSachnummer)) continue;
            sachnrList.add(sSachnummer);
            if (bIsAspgTeil) {
                teil.setKzgruppe("AS");
                teil.setAspgTyp("A");
                teil.setAspgRef(sSachnummer);
                teil.setAspgMenge(sMenge);
            }
            cTeile.add(teil);
            cMenge.add(sMenge);
        }
        return bKompZeilenSelektiert;
    }

    private Collection<Teil> ermittleAspgTeile(Collection<Teil> cTeile) {
        ArrayList<Teil> cAspgTeile = new ArrayList<Teil>();
        Iterator<Teil> iter = cTeile.iterator();
        while (iter.hasNext()) {
            Teil oTeil = iter.next();
            if (!oTeil.isAspg()) continue;
            cAspgTeile.add(oTeil);
            iter.remove();
        }
        if (!cAspgTeile.isEmpty()) {
            LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
            boolean bVerbaumenge = oLoginInfo.getSettings().getVerbaumenge();
            cAspgTeile = this.controller.getAspgTeilFromBTE(cAspgTeile, bVerbaumenge);
        }
        for (int i = 0; i < cAspgTeile.size(); ++i) {
            cTeile.add((Teil)cAspgTeile.get(i));
        }
        return cTeile;
    }

    private void uebernehmenInTeileliste() {
        int nRet;
        Vector<Teil> cTeile = new Vector<Teil>();
        Vector<String> cMengen = new Vector<String>();
        boolean bKompZeilenSelektiert = this.ermittleSelTeile(cTeile, cMengen);
        if (bKompZeilenSelektiert && (nRet = JOptionPane.showConfirmDialog(MainView.getInstance(), Resource.getInstance().getTlUebernehmenFrage(), Resource.getInstance().getAnzeigeBildtafel(), 0)) == 1) {
            return;
        }
        this.ermittleAspgTeile(cTeile);
        int nSelIndex = this.comboTeileliste.getSelectedIndex();
        ComboTeilelisteItem oTeilelisteItem = this.model.getTeileliste(nSelIndex);
        String sTeilelisteID = oTeilelisteItem.getID();
        String sEigentuemer = oTeilelisteItem.getEigentuemer();
        boolean bScrollToLastRow = true;
        if (this.mKleineTeileliste.getTeilelisteModel().getTLDaten() != null) {
            int nAnz = this.mKleineTeileliste.getTeilelisteModel().getTeile().size();
            DlgTeilelisteController ctrl = new DlgTeilelisteController();
            ctrl.uebernehmeTeile(this.mKleineTeileliste.getTeilelisteModel(), cTeile, true, true, true);
            bScrollToLastRow = this.mKleineTeileliste.getTeilelisteModel().getTeile().size() > nAnz;
        } else {
            DlgTeilelisteController ctrl = new DlgTeilelisteController();
            Teileliste oTL = ctrl.uebernehmeTeile(MainView.getInstance(), oTeilelisteItem, this.model.getMarke(), cTeile, true, true);
            if (!(oTeilelisteItem.getID() == null || sTeilelisteID.equals(oTeilelisteItem.getID()) && sEigentuemer.equals(oTeilelisteItem.getEigentuemer()))) {
                this.controller.loadTeilelistenIDs();
                this.updateTeilelisten();
            }
            this.mKleineTeileliste.setTeileliste(oTL);
        }
        this.mKleineTeileliste.update();
        if (bScrollToLastRow) {
            this.mKleineTeileliste.scrollToLastRow();
        }
    }

    private void pruefenEmailAdresseUndAufrufEmailProgramm(String pText) {
        this.log.debug((Object)("check Text auf Email Adresse " + pText));
        String sEmailAdr = EmailTo.extrahiereValidiereEmailAdresse(pText);
        if (sEmailAdr != null) {
            this.log.debug((Object)("extrahierte plausible Email Adresse gefunden: " + sEmailAdr));
            if (EmailTo.aufrufEmailClientNurMitAnEmailAdr(sEmailAdr)) {
                this.log.debug((Object)"Aufruf Email Client OK");
            } else {
                this.log.error((Object)"Aufruf Email Client nicht OK - siehe weitere Informationen im log");
            }
        } else {
            this.log.debug((Object)"keine plausible Email Adresse gefunden!");
        }
    }

    private void showVerweisBildtafel(int nRow) {
        if (!(this.tableModel.getRow(nRow) instanceof VerweisZeile)) {
            return;
        }
        VerweisZeile oZeile = (VerweisZeile)this.tableModel.getRow(nRow);
        String sBTNummerNach = oZeile.getBtNummerNach();
        this.controller.showVerweisBildtafel(sBTNummerNach);
        this.controller.loadGrafik();
        this.mbVerweisBildtafel = true;
        this.mbInitial = true;
        this.model.hasPrevBT(true);
        this.update();
    }

    private void expandOrCollapse(final int nRow) {
        boolean bAufklappen;
        if (!(this.tableModel.getRow(nRow) instanceof KomprimierungsZeile)) {
            return;
        }
        KomprimierungsZeile oZeile = (KomprimierungsZeile)this.tableModel.getRow(nRow);
        String sBildnummer = oZeile.getBildnummer();
        if (oZeile.isKomprimiert()) {
            bAufklappen = true;
            this.controller.expandBildnummer(sBildnummer);
        } else {
            bAufklappen = false;
            this.controller.collapseBildnummer(sBildnummer);
        }
        this.update();
        if (bAufklappen && this.tableModel != null && this.model.getCurrentBTE() != null && this.model.getCurrentBTE().getZeilen() != null && this.model.getCurrentBTE().getZeilen().size() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JScrollPane sc = BTEView.this.table.getScrollPane();
                    int iNewValue = ((BTEView)BTEView.this).table.getCellRect((int)nRow, (int)0, (boolean)true).y <= sc.getVerticalScrollBar().getMaximum() ? ((BTEView)BTEView.this).table.getCellRect((int)nRow, (int)0, (boolean)true).y : sc.getVerticalScrollBar().getMaximum();
                    sc.getVerticalScrollBar().setValue(iNewValue);
                }
            });
        }
    }

    private void applyBedAuswertung(boolean bBedAuswertung) {
        this.model.setBedAuswertung(bBedAuswertung);
        this.controller.applyBedAuswertung(bBedAuswertung);
        if (this.model.getBedAuswertung()) {
            this.onOffItem.setText(Resource.getInstance().getBedingungsfilterAus());
        } else {
            this.onOffItem.setText(Resource.getInstance().getBedingungsfilterEin());
        }
        String sBigTitel = this.model.getDialogTitel();
        String dlgModus = this.model.getDialogModus();
        if (!this.model.getNachruestungenRelevant() && dlgModus != null && !dlgModus.equals("Accessoires")) {
            sBigTitel = sBigTitel + " - " + Resource.getInstance().getNachruestungenNichtBeruecksichtigt();
        }
        if (this.model.getBedAuswertung()) {
            sBigTitel = sBigTitel + " - " + Resource.getInstance().getGefiltert();
        }
        this.panHeader.setBigTitle(sBigTitel);
        if (dlgModus != null && dlgModus.equals("ValueLine")) {
            sBigTitel = sBigTitel + " - " + Resource.getInstance().getValueLine();
        }
        this.panHeader.repaint();
        this.update();
    }

    private void applyBooleanExpFlag(boolean isBoolExp) {
        if (isBoolExp) {
            this.onOffItem.setEnabled(false);
        }
    }

    private void changeBedingung(int nRow) {
        String sBedWertOld;
        CurrentBTE oCurrentBTE = this.model.getCurrentBTE();
        if (oCurrentBTE == null) {
            return;
        }
        BTEBedingungenTabelleModel.BedingungRow oZeile = this.tableBedModel.getRow(nRow);
        Long lBedId = oZeile.getBedId();
        String sBedWertNew = null;
        if (oZeile.isJa()) {
            sBedWertNew = "1";
        }
        if (oZeile.isNein()) {
            sBedWertNew = "2";
        }
        if (oZeile.isUnbekannt()) {
            sBedWertNew = "0";
        }
        if ((sBedWertOld = this.model.getCurrentBTE().getBedingungen().getBedWert(lBedId)) != null && sBedWertOld.equals(sBedWertNew)) {
            return;
        }
        Bedingungswert oBedWertNew = null;
        try {
            oBedWertNew = new Bedingungswert(sBedWertNew);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (oCurrentBTE.isMbBoolExpUsed() && this.isRowUnbekannt()) {
            this.scTable.setVisible(false);
            this.labKeineZeilen.setVisible(false);
            this.labelNotAllCondValuesSet.setVisible(true);
            this.panTextTeil.repaint();
            this.controller.changeBedingung(lBedId, oBedWertNew);
            this.anzeigenBedingungen();
            if (this.tableModel != null) {
                this.tableModel.removeAllRows();
            }
            return;
        }
        this.controller.changeBedingung(lBedId, oBedWertNew);
        this.mbAnzeigenBedingungen = true;
        this.update();
        boolean bHasETKTexte = this.controller.hatETKTexte(true);
        this.buttonHinweis.setVisible(bHasETKTexte);
        if (oZeile.isJa()) {
            boolean bIgnoreAngezeigtFlag = true;
            boolean bSetAngezeigt = false;
            this.anzeigenETKTexte(bIgnoreAngezeigtFlag, bSetAngezeigt);
        }
    }

    private void resetBedingungen() {
        String sBTENr;
        CurrentBTE oCurrentBTE = this.model.getCurrentBTE();
        if (oCurrentBTE == null || oCurrentBTE.getBTENr() == null) {
            return;
        }
        CBTEBedingungsmenge oBTECache = CBTEBedingungsmenge.getObject();
        BTEBedingungsmenge oBTEBedingungsmenge = oBTECache.get(sBTENr = oCurrentBTE.getBTENr());
        if (oBTEBedingungsmenge == null) {
            return;
        }
        BTEBedingungsmenge oCurrentBTEBedingungen = oCurrentBTE.getBedingungen();
        try {
            oCurrentBTEBedingungen.goFirst();
            while (true) {
                String sNewWert;
                Long lBedId = oCurrentBTEBedingungen.getCurrentId();
                String sWert = oCurrentBTEBedingungen.getCurrentWert();
                if (oCurrentBTEBedingungen.isBteBedingung(lBedId) && !sWert.equals(sNewWert = oBTEBedingungsmenge.getBedWert(lBedId))) {
                    try {
                        oCurrentBTEBedingungen.setCurrentWert(sNewWert);
                        Bedingungswert oBedWert = new Bedingungswert(sNewWert);
                        this.controller.changeBedingung(lBedId, oBedWert);
                    }
                    catch (InvalidInitializationException exc) {
                        this.log.error((Object)"Initialization of current value failed!", (Throwable)exc);
                    }
                }
                if (oCurrentBTEBedingungen.hasNext()) {
                    oCurrentBTEBedingungen.next();
                    continue;
                }
                break;
            }
        }
        catch (NoDataFoundException exc) {
            this.log.error((Object)"No Data found", (Throwable)exc);
        }
        this.anzeigenBedingungen();
        this.mbAnzeigenBedingungen = true;
        this.update();
        boolean bHasETKTexte = this.controller.hatETKTexte(true);
        this.buttonHinweis.setVisible(bHasETKTexte);
        int nRows = this.tableBedModel.getRowCount();
        for (int nRowCount = 0; nRowCount < nRows; ++nRowCount) {
            BTEBedingungenTabelleModel.BedingungRow oRow = this.tableBedModel.getRow(nRowCount);
            if (!oRow.isJa()) continue;
            boolean bIgnoreAngezeigtFlag = true;
            boolean bSetAngezeigt = false;
            this.anzeigenETKTexte(bIgnoreAngezeigtFlag, bSetAngezeigt);
        }
    }

    public void changeBedingungFilter() {
        String sBedAnzeigeModus = this.model.getBedAnzeigeModus();
        if (sBedAnzeigeModus.equals("btanzeige_gefiltert")) {
            this.menuFilter.setIcon(ImageCache.getInstance().getIcon("aufklappen.gif"));
            this.menuFilter.setHorizontalTextPosition(2);
            this.filterItem.setText(Resource.getInstance().getFilterAlleBedingungenAus());
            sBedAnzeigeModus = "btanzeige_ungefiltert";
        } else {
            this.menuFilter.setIcon(ImageCache.getInstance().getIcon("aufklappen.gif"));
            this.menuFilter.setHorizontalTextPosition(2);
            this.filterItem.setText(Resource.getInstance().getFilterAlleBedingungenEin());
            sBedAnzeigeModus = "btanzeige_gefiltert";
        }
        this.model.setBedAnzeigeModus(sBedAnzeigeModus);
        this.mbAnzeigenBedingungen = true;
        this.update();
    }

    private void showProduktionsdatum() {
        JavaFzgIdInfo oFzgIdInfo = GlobalObjects.getInstance().getFzgIdInfo();
        if (oFzgIdInfo == null) {
            return;
        }
        if (oFzgIdInfo.getFahrgestellNr() != null && oFzgIdInfo.getFahrgestellNr().length() > 0) {
            String sBaujahr = oFzgIdInfo.getBaujahr();
            String sZulassungsmonat = oFzgIdInfo.getZulMonat();
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getProduktionsdatumHinweis() + " " + sZulassungsmonat + "/" + sBaujahr, Resource.getInstance().getProduktionsdatum(), 1);
        }
    }

    private void anzeigenZeilen() {
        CurrentBTE oCurrentBTE;
        if (this.tableModel != null) {
            this.tableModel.removeAllRows();
        }
        if ((oCurrentBTE = this.model.getCurrentBTE()) == null) {
            return;
        }
        if (oCurrentBTE.isMbBoolExpUsed() && !oCurrentBTE.getBedingungen().alleBedingungswerteEindeutig()) {
            this.scTable.setVisible(false);
            this.labKeineZeilen.setVisible(false);
            this.labelNotAllCondValuesSet.setVisible(true);
            this.panTextTeil.repaint();
            return;
        }
        Vector<AbstractZeile> oZeilen = this.model.getCurrentBTE().getZeilen();
        if (oZeilen != null && oZeilen.size() > 0 && !this.model.isVinButton()) {
            this.scTable.setVisible(true);
            this.labKeineZeilen.setVisible(false);
            this.labelNotAllCondValuesSet.setVisible(false);
        } else {
            this.scTable.setVisible(false);
            this.labKeineZeilen.setVisible(true);
            this.labelNotAllCondValuesSet.setVisible(false);
        }
        if (oZeilen == null || oZeilen.size() == 0) {
            return;
        }
        for (AbstractZeile oZeile : oZeilen) {
            if (oZeile instanceof Zeile) {
                Zeile oZeileN = (Zeile)oZeile;
                if (oZeileN.isKomprimierungszeile()) {
                    int nKomprimierStatus = oZeileN.isKomprimiert() ? 1 : 0;
                    KomprimierungsZeile oZeileHelp = new KomprimierungsZeile(nKomprimierStatus, this.mnColAufZuklappen, oZeileN.getBildnummer(), this.mnColBildnummer, oZeileN.getTeilebenennung(), this.mnColTeilebenennung);
                    this.tableModel.addRow(oZeileHelp);
                } else {
                    String sZeilenTooltip = this.generateZeilentooltip(oZeileN);
                    String sTooltipBenennungskommentar = this.generateTooltipBenennungskommentar(oZeileN);
                    if (this.model.getBildtafelType().equals("FZG")) {
                        this.tableModel.addRow(new TeilenummernZeile(oZeileN.getId(), oZeileN.getSatzteilIndikator(), sZeilenTooltip, this.mnColTeileinfo, oZeileN.getBildnummer(), sTooltipBenennungskommentar, this.mnColBildnummer, oZeileN.getTeilebenennung(), this.mnColTeilebenennung, oZeileN.getZusatz(), this.mnColZusatz, oZeileN.getMenge(), this.mnColMenge, oZeileN.getEinsatzdatum(), this.mnColEinsatzdatum, oZeileN.getAuslaufdatum(), this.mnColAuslaufdatum, oZeileN.getKatalysator(), this.mnColKatalysator, oZeileN.getGetriebe(), this.mnColGetriebe, oZeileN.getLenkung(), this.mnColLenkung, oZeileN.getTeilenummer(true), this.mnColTeilenummer, oZeileN.getAustausch(), this.mnColAEKennzeichen, oZeileN.getTechnischeInfo(), this.mnColTechnischeInfo, oZeileN.isTeilASPG(), oZeileN.isTeilStecker(), new Integer(oZeileN.getPos()).toString(), this.mnColPos, oZeileN.getAnkerPos()));
                    } else {
                        this.tableModel.addRow(new TeilenummernZeile(oZeileN.getId(), oZeileN.getSatzteilIndikator(), sZeilenTooltip, this.mnColTeileinfo, oZeileN.getBildnummer(), sTooltipBenennungskommentar, this.mnColBildnummer, oZeileN.getTeilebenennung(), this.mnColTeilebenennung, oZeileN.getZusatz(), this.mnColZusatz, oZeileN.getMMG(), this.mnColMAM, oZeileN.getEMG(), this.mnColVVM, oZeileN.getEinsatzdatum(), this.mnColEinsatzdatum, oZeileN.getAuslaufdatum(), this.mnColAuslaufdatum, oZeileN.getTeilenummer(true), this.mnColTeilenummer, oZeileN.getAustausch(), this.mnColAEKennzeichen, oZeileN.getTechnischeInfo(), this.mnColTechnischeInfo, oZeileN.isTeilASPG(), oZeileN.isTeilStecker(), new Integer(oZeileN.getPos()).toString(), this.mnColPos, oZeileN.getAnkerPos()));
                    }
                }
            }
            if (oZeile instanceof KommZeile) {
                KommZeile oZeileK = (KommZeile)oZeile;
                this.tableModel.addRow(new KommentarZeile(EmailTo.sucheErsteEmailAdresseImTextUndAufbereitenZuHref(oZeileK.getText()), this.mnColTeilebenennung, oZeileK.getZusatz(), this.mnColZusatz, oZeileK.getDarstellung()));
            }
            if (!(oZeile instanceof BTVerweisZeile)) continue;
            BTVerweisZeile oZeileB = (BTVerweisZeile)oZeile;
            this.tableModel.addRow(new VerweisZeile(oZeileB.getBTENummer(), oZeileB.getText(), this.mnColTeilebenennung, "", this.mnColZusatz));
        }
        if (oCurrentBTE.getHighlight() != null) {
            this.hightlightBildnummer(oCurrentBTE.getHighlight(), false);
        }
        this.table.calcRowHeights();
        this.table.getTable().repaint();
        this.table.getTable().revalidate();
    }

    private String generateZeilentooltip(Zeile zeile) {
        String sSIDokArten;
        String tinfo;
        StringBuilder sb = new StringBuilder("<html>");
        for (String oChangePoint : zeile.getChangepointString(Resource.getInstance().getCpVerbaubarAb(), Resource.getInstance().getCpVerbaubarBis(), Resource.getInstance().getGetriebenummer(), Resource.getInstance().getMotornummer())) {
            sb.append(oChangePoint);
            sb.append("<p>");
        }
        String sGRPLeitAWs = zeile.getGRPLeitAWs();
        if (sGRPLeitAWs != null) {
            String sGRPText = Resource.getInstance().getGrpInformation();
            sb.append(sGRPText + " " + sGRPLeitAWs);
            sb.append("<p>");
        }
        if (zeile.isTcVorhanden()) {
            sb.append(Resource.getInstance().getTeileclearingText1());
            sb.append("<p>");
        }
        if ((tinfo = zeile.getTechnischeInfo()) != null && tinfo.contains("#")) {
            sb.append(Resource.getInstance().getSteckerUndAnschlagteile());
            sb.append("<p>");
        }
        if (zeile.isTeilReach()) {
            sb.append("REACH");
            sb.append("<p>");
        }
        if (zeile.isPiVorhanden()) {
            sb.append(Resource.getInstance().getProduktinfo());
            sb.append("<p>");
        }
        if ((sSIDokArten = zeile.getSIDokArten()) != null) {
            sb.append(sSIDokArten);
            sb.append("<p>");
        }
        if (sb.toString().equals("<html>")) {
            return null;
        }
        sb.append("</html>");
        return sb.toString();
    }

    private String generateTooltipBenennungskommentar(Zeile zeile) {
        StringBuilder sb = new StringBuilder("<html>");
        String sBenKomm = zeile.getKommentarTeilebenennung();
        if (sBenKomm != null) {
            sb.append(zeile.getKommentarTeilebenennung());
        }
        if (sb.toString().equals("<html>")) {
            return null;
        }
        sb.append("</html>");
        return sb.toString();
    }

    private void anzeigenBedingungen() {
        if (this.model.getBildtafelType().equals("ASS")) {
            return;
        }
        this.mbSuppressBedListener = true;
        this.tableBedModel.removeAllRows();
        CurrentBTE oCurrentBTE = this.model.getCurrentBTE();
        if (oCurrentBTE == null) {
            return;
        }
        BTEBedingungsmenge oBedingungen = oCurrentBTE.getBedingungen();
        try {
            oBedingungen.goFirst();
            while (true) {
                Long lBedId = oBedingungen.getCurrentId();
                String sCode = oBedingungen.getCurrentCode();
                String sBenennung = oBedingungen.getCurrentBenennung();
                String sWert = oBedingungen.getCurrentWert();
                Boolean bNachruestungenAufNein = oBedingungen.getCurrentNachruestungAufNein();
                int nStatus = 3;
                if (sWert.equals("1")) {
                    nStatus = 1;
                } else if (sWert.equals("2")) {
                    nStatus = 2;
                }
                Color bedColor = null;
                if (oBedingungen.isBteBedingung(oBedingungen.getCurrentId())) {
                    bedColor = Color.blue;
                    if (bNachruestungenAufNein.booleanValue()) {
                        bedColor = new Color(171, 3, 3);
                    }
                }
                if (oBedingungen.showCurrentBed(this.model.getBedAnzeigeModus())) {
                    this.tableBedModel.addBedingung(lBedId, sCode, sBenennung, nStatus, bedColor);
                }
                if (oBedingungen.hasNext()) {
                    oBedingungen.next();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mbSuppressBedListener = false;
    }

    private void anzeigenGrafik() {
        Image img = this.model.getCurrentGrafikAsImage();
        if (img == null) {
            return;
        }
        this.imageHasFinishedLoading(img);
    }

    @Override
    public void updateTeilelisten() {
        if (this.comboTeileliste == null) {
            return;
        }
        this.mbSuppressComboActionListener = true;
        this.comboTeileliste.removeAllItems();
        TrfHashMap oTeilelistenids = this.model.getTeilelistenIDs();
        if (oTeilelistenids != null) {
            ComboTeilelisteItem oItem;
            int ii = 1;
            while ((oItem = (ComboTeilelisteItem)oTeilelistenids.getValue(ii + "teilelisteid")) != null) {
                this.comboTeileliste.addItem(oItem);
                ++ii;
            }
        }
        ComboTeilelisteItem oItem = DlgTeilelisteController.ermittleSelTL(this.model.getTeilelistenCollection(), true);
        this.comboTeileliste.setSelectedItem(oItem);
        this.moSelTeileliste = oItem;
        this.mKleineTeileliste.init(oItem.getID(), oItem.getEigentuemer(), false);
        this.mbSuppressComboActionListener = false;
    }

    public void refreshKleineTeileliste() {
        ComboTeilelisteItem oItem = (ComboTeilelisteItem)this.comboTeileliste.getSelectedItem();
        this.mKleineTeileliste.init(oItem.getID(), oItem.getEigentuemer(), true);
        if (this.model.getBildtafelType().equals("FZG")) {
            if (this.model.isIpacView()) {
                this.verticalSplitPane2.setDividerLocation(209);
                this.verticalSplitPane2.setDividerLocation(210);
            } else {
                this.verticalSplitPane2.setDividerLocation(this.mnHorizonalLocation2 - 1);
                this.verticalSplitPane2.setDividerLocation(this.mnHorizonalLocation2);
            }
        }
    }

    public void zurueckZurFI() {
        Workflowsteuerung oCurrentWF = MainWorkflowsteuerung.getInstance().getCurrentWorkflow();
        if (oCurrentWF == null || !(oCurrentWF instanceof WfTeilesucheFzg) && !(oCurrentWF instanceof WfTeilesucheFzgGrafisch)) {
            MainWorkflowsteuerung.getInstance().zurueckZurFI(true);
            MainWorkflowsteuerung.getInstance().startWorkflow("WfTeilesucheFzg");
        } else {
            this.model.setExitAction("zurueck_zu_fi");
            this.controller.notifyAllExitListeners();
        }
    }

    public void zurueckZuTnrBtErgebnissen() {
        this.model.setExitAction("zurueck_zu_tnrbt_ergebnisse");
        this.controller.notifyAllExitListeners();
    }

    public void zurueckZuBtErgebnissen() {
        this.model.setExitAction("zurueck_zu_bt_ergebnisse");
        this.controller.notifyAllExitListeners();
    }

    public void zurueckZurTeileverwendung() {
        JOptionPane.showMessageDialog(MainView.getInstance(), "Noch nicht implementiert", "Hinweis", 1);
    }

    public void showTeileliste() {
        WorkflowStateData oWsd = new WorkflowStateData();
        if (GlobalObjects.getInstance().getSessionInfo().getDMSVerwenden()) {
            oWsd.setWert("DMS", "DMS");
        }
        int nSelIndex = this.comboTeileliste.getSelectedIndex();
        ComboTeilelisteItem oTeilelisteItem = this.model.getTeileliste(nSelIndex);
        String sTeilelisteID = oTeilelisteItem.getID();
        String sEigentuemer = oTeilelisteItem.getEigentuemer();
        String sFiliale = oTeilelisteItem.getFiliale();
        oWsd.setWert("ID", sTeilelisteID);
        oWsd.setWert("EIGENTUEMER", sEigentuemer);
        oWsd.setWert("FILIALE", sFiliale);
        oWsd.setWert("zurueck_zu_bt_erlauben", "true");
        oWsd.setWert("aufruf_aus_workflow", this.model.isAufrufAusWorkflow() ? "true" : "false");
        if (this.model.isAufrufAusWorkflow()) {
            this.model.setExitAction("anzeige_teileliste");
            this.model.setWorkflowStateData(oWsd);
            this.controller.notifyAllExitListeners();
        } else {
            WorkflowStateData oBackToBT = new WorkflowStateData();
            oBackToBT.setWert("currentbte", this.model.getCurrentBTE());
            oBackToBT.setWert("sachnummersuch", this.model.getSachnummerSuch());
            boolean bZurueckZuTeileverwendung = this.model.isErlaubtZurueckZuTeileverwendung();
            String sZurueckZuTeileverwendung = bZurueckZuTeileverwendung ? "true" : "false";
            oBackToBT.setWert("zurueck_zu_teileverwendung_erlauben", sZurueckZuTeileverwendung);
            oBackToBT.setWert("zurueck_zu_bt_erlauben", "true");
            oBackToBT.setWert("aufruf_aus_workflow", "false");
            GlobalObjects.getInstance().getEtkData().appendBackInfo("backinfo_bt", oBackToBT);
            if (Constants.Bestellliste.isBestellliste(sTeilelisteID)) {
                MainView.getInstance().showDlg(DlgBestelllisteController.class, oWsd);
            } else {
                MainView.getInstance().showDlg(DlgTeilelisteController.class, oWsd);
            }
        }
    }

    public void printDruckansicht() {
        Vector<String> cSelIds = new Vector<String>();
        int nSelRowCount = this.table.getTable().getSelectedRowCount();
        int[] naSelRowCount = this.table.getTable().getSelectedRows();
        for (int i = 0; i < nSelRowCount; ++i) {
            int nIndex = naSelRowCount[i];
            GenericRow oZeile = this.tableModel.getRow(nIndex);
            if (!(oZeile instanceof TeilenummernZeile)) continue;
            TeilenummernZeile oZeileT = (TeilenummernZeile)oZeile;
            cSelIds.add(oZeileT.getId());
        }
        BTEDruckansicht druckansicht = new BTEDruckansicht(this.model, this.image, cSelIds);
        druckansicht.printBTE();
    }

    @Override
    public void onExit() {
        this.mKleineTeileliste.entsperreListe();
        this.controller.onExit();
    }

    public void suchenHGPrev() {
        this.model.setExitAction("search_hg_at_index");
        this.model.setIndexHGtoSearch(this.model.getIndexHGPrev());
        this.controller.notifyAllExitListeners();
    }

    public void suchenHGNext() {
        this.model.setExitAction("search_hg_at_index");
        this.model.setIndexHGtoSearch(this.model.getIndexHGNext());
        this.controller.notifyAllExitListeners();
    }

    public void nachtraeglicheEingabeVIN() {
        String sFgstnr = JOptionPane.showInputDialog(MainView.getInstance(), Resource.getInstance().getBitteFahrgestellnummerEingeben() + ": ", Resource.getInstance().getFahrzeugidentifikation(), 3);
        if (sFgstnr == null) {
            return;
        }
        if (sFgstnr.length() != 7) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFgstnrGenau7Stellen(), Resource.getInstance().getFahrzeugidentifikation(), 1);
            return;
        }
        String sachnummer = this.model.getSachnummerSuch();
        if (!this.controller.identifiziereFahrzeugByFgstnr(sFgstnr, sachnummer)) {
            return;
        }
        CBTEBedingungsmenge oBTECache = CBTEBedingungsmenge.getObject();
        oBTECache.reset();
        this.controller.ladenBildafelNochmals(true);
        this.mbInitial = true;
        this.mbAnzeigenBedingungen = true;
        this.update();
    }

    public void zurueckZurTeilesuche() {
        this.model.setExitAction("zurueckzuteilesuche");
        this.controller.notifyAllExitListeners();
    }

    public void changeBedingungenFilter() {
        String sBedAnzeigeModus = this.model.getBedAnzeigeModus();
        sBedAnzeigeModus = sBedAnzeigeModus.equals("btanzeige_gefiltert") ? "btanzeige_ungefiltert" : "btanzeige_gefiltert";
        this.model.setBedAnzeigeModus(sBedAnzeigeModus);
        this.mbAnzeigenBedingungen = true;
        this.update();
    }

    @Override
    protected void kannSelektierteTeilelisteWechseln() {
        if (this.mbSuppressComboActionListener) {
            return;
        }
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        ComboTeilelisteItem oAktTLOld = oLoginInfo.getAktuelleTeileliste();
        int nSelIndex = this.comboTeileliste.getSelectedIndex();
        ComboTeilelisteItem oTeilelisteItem = this.model.getTeileliste(nSelIndex);
        if (!DlgTeilelisteController.kannSelektionWechseln(oTeilelisteItem, this.moSelTeileliste)) {
            this.mbSuppressComboActionListener = true;
            this.comboTeileliste.setSelectedItem(this.moSelTeileliste);
            this.mbSuppressComboActionListener = false;
        } else {
            if (oAktTLOld != null && this.moSelTeileliste.getID().equals(oAktTLOld.getID()) && !oLoginInfo.getLogin().equals(oAktTLOld.getEigentuemer())) {
                DlgTeilelisteController.removeListe(this.moSelTeileliste, this.model.getTeilelistenIDs());
                this.updateTeilelisten();
            }
            this.moSelTeileliste = (ComboTeilelisteItem)this.comboTeileliste.getSelectedItem();
            this.mKleineTeileliste.init(this.moSelTeileliste.getID(), this.moSelTeileliste.getEigentuemer(), false);
            if (this.model.getBildtafelType().equals("FZG")) {
                if (this.model.isIpacView()) {
                    this.verticalSplitPane2.setDividerLocation(209);
                    this.verticalSplitPane2.setDividerLocation(210);
                } else {
                    this.verticalSplitPane2.setDividerLocation(this.mnHorizonalLocation2 - 1);
                    this.verticalSplitPane2.setDividerLocation(this.mnHorizonalLocation2);
                }
            }
        }
    }

    @Override
    public HashMap<String, Object> getInfoZurSachnummer() {
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        ArrayList<String> aSachnummern = new ArrayList<String>();
        int[] aRows = this.table.getTable().getSelectedRows();
        for (int ii = 0; ii < aRows.length; ++ii) {
            GenericRow oRow = this.tableModel.getRow(aRows[ii]);
            if (oRow == null || !(oRow instanceof TeilenummernZeile)) continue;
            TeilenummernZeile oZeile = (TeilenummernZeile)oRow;
            String sSachnummer = oZeile.getSachnummer();
            String sTeilenummer = oZeile.getTeilenummer();
            String sBenennungZusatz = oZeile.getBenennungZusatz();
            String sMarke = this.model.getMarke();
            String sProduktart = this.model.getProduktart();
            String sKatalogumfang = this.model.getKatalogumfang();
            if (aRows.length == 1) {
                oHashMap.put("sachnummer", sSachnummer);
                oHashMap.put("teilenummer", sTeilenummer);
                oHashMap.put("benennung_zusatz", sBenennungZusatz);
                oHashMap.put("marke", sMarke);
                oHashMap.put("produktart", sProduktart);
                oHashMap.put("katalogumfang", sKatalogumfang);
                continue;
            }
            aSachnummern.add(sSachnummer);
        }
        if (aRows.length > 1) {
            oHashMap.put("sachnummern", aSachnummern);
        }
        return oHashMap;
    }

    public void initETKTexte() {
        String sHGOld = GlobalObjects.getInstance().getAktuelleHG();
        sHGOld = sHGOld == null ? "" : sHGOld;
        String sHGNew = this.model.getCurrentBTE().getHG();
        String string = sHGNew = sHGNew == null ? "" : sHGNew;
        if (!sHGOld.equals(sHGNew)) {
            GlobalObjects.getInstance().resetETKTexte();
        }
        GlobalObjects.getInstance().setAktuelleHG(sHGNew);
        boolean bIgnoreAngezeigtFlag = false;
        boolean bSetAngezeigt = true;
        this.anzeigenETKTexte(bIgnoreAngezeigtFlag, bSetAngezeigt);
        if (this.buttonHinweis != null) {
            boolean bHasETKTexte = this.controller.hatETKTexte(true);
            this.buttonHinweis.setVisible(bHasETKTexte);
        }
    }

    public void anzeigenETKTexte(boolean bIngnoreAngezeigt, boolean bSetAngezeigt) {
        Collection<ETKTextZeile> cETKTextZeilen = this.controller.evalETKTexte(bIngnoreAngezeigt, bSetAngezeigt);
        if (cETKTextZeilen.size() == 0) {
            return;
        }
        ETKText dlgETKText = new ETKText((Frame)MainView.getInstance(), cETKTextZeilen);
        dlgETKText.setVisible(true);
    }

    public static int getMaxZeichenAnzahl() {
        int maxZeichenAnzahl = 115;
        if (GlobalObjects.getInstance().getLanguage().equals("ja") || GlobalObjects.getInstance().getLanguage().equals("zh") || GlobalObjects.getInstance().getLanguage().equals("ko")) {
            maxZeichenAnzahl = 85;
        } else if (GlobalObjects.getInstance().getLanguage().equals("el") || GlobalObjects.getInstance().getLanguage().equals("th")) {
            maxZeichenAnzahl = 105;
        }
        return maxZeichenAnzahl;
    }

    public boolean isRowUnbekannt() {
        ArrayList<BTEBedingungenTabelleModel.BedingungRow> bedingungRow = this.tableBedModel.getAllRows();
        if (bedingungRow != null && bedingungRow.size() > 0) {
            for (int i = 0; i < bedingungRow.size(); ++i) {
                BTEBedingungenTabelleModel.BedingungRow row = bedingungRow.get(i);
                if (row.getStatus() != 3) continue;
                return true;
            }
        }
        return false;
    }

    public class ColoredTableRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (row < BTEView.this.tableBedModel.getRowCount()) {
                BTEBedingungenTabelleModel.BedingungRow r = BTEView.this.tableBedModel.getRow(row);
                if (r.getRowColor() != null) {
                    c.setForeground(r.getRowColor());
                } else {
                    c.setForeground(Color.black);
                }
            }
            return c;
        }
    }
}

