/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.bte;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import webetk.javaclient.dialog.bte.KommentarZeile;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericRow;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.lookandfeel.UIHelper;

public class MultiLineCellRenderer
extends JTextArea
implements TableCellRenderer {
    private static final long serialVersionUID = -6090711739262543124L;
    private int horizontalSpacing = 10;
    private Font stdFont;
    private Font boldFont;

    public MultiLineCellRenderer() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.stdFont = UIHelper.getNormalFont();
        this.boldFont = this.stdFont.deriveFont(1);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setFont(table.getFont());
        this.setMargin(new Insets(0, 2, 0, 0));
        this.setText(value == null ? "" : value.toString());
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(table.getForeground());
            super.setBackground(table.getBackground());
        }
        this.setFont(table.getFont());
        this.setForeground(Color.black);
        TableModel model = table.getModel();
        if (model instanceof GenericTableModel) {
            GenericTableModel genmodel = (GenericTableModel)model;
            if (row >= 0 && row < genmodel.getRowCount()) {
                AbstractRow abstarctrow;
                Color color;
                GenericRow modelrow = genmodel.getRow(row);
                if (modelrow instanceof AbstractRow && (color = (abstarctrow = (AbstractRow)modelrow).getForeColor()) != null) {
                    this.setForeground(color);
                }
                if (modelrow instanceof KommentarZeile) {
                    KommentarZeile ZeileK = (KommentarZeile)modelrow;
                    if (ZeileK.isBold()) {
                        this.setFont(this.boldFont);
                    } else {
                        this.setFont(this.stdFont);
                    }
                }
            }
        }
        return this;
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        this.horizontalSpacing = horizontalSpacing;
    }

    public static class UIResource
    extends MultiLineCellRenderer
    implements javax.swing.plaf.UIResource {
        private static final long serialVersionUID = 7401100246653868041L;
    }
}

