/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.einstellungen;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import webetk.app.Markt;
import webetk.app.settings.EinstellungenBasis;
import webetk.communication.LoginInfo;
import webetk.javaclient.MarktDaten;
import webetk.javaclient.dialog.ChoicePanel;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledComponent;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.extras.einstellungen.DlgEinstellungenController;
import webetk.javaclient.dialog.extras.einstellungen.DlgEinstellungenModel;
import webetk.javaclient.dialog.extras.einstellungen.Sprache;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.javaclient.workflow.MainWorkflowsteuerung;
import webetk.mrkprd.Marke;
import webetk.mrkprd.Marken;
import webetk.mrkprd.MarkenProdukte;
import webetk.mrkprd.Produkt;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class DlgEinstellungenView
extends AbstractDialogView {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(DlgEinstellungenView.class);
    private DlgEinstellungenModel model;
    private DlgEinstellungenController controller;
    private JPanel panMarke;
    private JComboBox comboMarken;
    private Vector<Marke> vMarken = new Vector();
    private JPanel panProduktart;
    private Vector<Produkt> vProdukte = new Vector();
    private HashMap<Produkt, JRadioButton> hJrbProdukt = new HashMap();
    private ArrayList<String> moeglProdukteZuUserMarken = new ArrayList();
    private JPanel panKatalogumfang;
    private JRadioButton rbKatalogumfangVT;
    private JRadioButton rbKatalogumfangST;
    private ChoicePanel panProduktionsdatum;
    private JRadioButton rbProduktionsdatumImmer;
    private JRadioButton rbProduktionsdatumAnfrage;
    private ChoicePanel panDarstellungBNB;
    private JRadioButton rbDarstellungBNBKomprimiert;
    private JRadioButton rbDarstellungBNBAusfuehrlich;
    private ChoicePanel panSuchwegVerkuerzen;
    private JRadioButton rbSuchwegVerkuerzenJa;
    private JRadioButton rbSuchwegVerkuerzenNein;
    private ChoicePanel panBandVerbaut;
    private JRadioButton rbBandVerbautJa;
    private JRadioButton rbBandVerbautNein;
    private JRadioButton rbSuchraumLokal;
    private JRadioButton rbSuchraumZentral;
    private ChoicePanel panPreise;
    private JRadioButton rbPreisAnz;
    private JRadioButton rbPreisNichtAnz;
    private JRadioButton rbVerbauMenge;
    private JRadioButton rbMengeEins;
    private ChoicePanel panTippsTricks;
    private JRadioButton rbTippsTricksAnz;
    private JRadioButton rbTippsTricksNichtAnz;
    private JList listRegionen;
    private JComboBox comboLenkungen;
    private JComboBox comboSprachen;
    private JButtonEx buttonOK;
    private JButtonEx buttonUndo;
    private JComboBox comboMarktPrio;
    private boolean mbSuppressComboMarktPrioActionListener = false;
    private JList listMarktWeitere;
    private boolean mbSuppressListWeitereMarekteSelectionListener = false;
    private boolean marktWeitereExpanded = false;
    private JPanel panLokaleBtes;
    private JPanel panelAllgemein;
    private JCheckBox cbGrosseSchrift;
    private JCheckBox cbStreckeTabellen;
    private ChoicePanel panelVerbauMenge;

    @Override
    public void initMenus() {
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        HeaderPanel panHeader = new HeaderPanel(Resource.getInstance().getEinstellungen(), ImageCache.getInstance().getHeaderIcon("einstell"));
        this.add((Component)panHeader, "North");
        JScrollPane panContent = new JScrollPane(this.createContentPanel());
        this.add((Component)panContent, "Center");
    }

    private JComponent createContentPanel() {
        JPanel panel = new JPanel();
        int[] w1 = new int[]{0, 0, 0};
        int[] h1 = new int[]{0, 0, 2, 0, 2, 0, 0};
        HIGLayout l = new HIGLayout(w1, h1);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(3, 1);
        l.setRowWeight(7, 1);
        panel.setLayout(l);
        panel.add((Component)this.createAllgemeinPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createMiddlePanel(), c.rc(4, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(6, 2, "lrtb"));
        return panel;
    }

    private JPanel createMiddlePanel() {
        JPanel panmiddle = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{280, 220, 290};
        gridBagLayout.rowHeights = new int[]{70, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 1.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        panmiddle.setLayout(gridBagLayout);
        JPanel panlayout = (JPanel)this.createLayoutPanel();
        GridBagConstraints gbc_pantut = new GridBagConstraints();
        gbc_pantut.insets = new Insets(0, 0, 0, 5);
        gbc_pantut.fill = 1;
        gbc_pantut.gridx = 0;
        gbc_pantut.gridy = 0;
        panmiddle.add((Component)panlayout, gbc_pantut);
        GridBagConstraints gbc_panlayout = new GridBagConstraints();
        gbc_panlayout.insets = new Insets(0, 0, 0, 5);
        gbc_panlayout.fill = 1;
        gbc_panlayout.gridx = 1;
        gbc_panlayout.gridy = 0;
        panmiddle.add((Component)this.createTippsTricksPanel(), gbc_panlayout);
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 2;
        gbc_panel_1.gridy = 0;
        panmiddle.add((Component)new TitledPanel(" "), gbc_panel_1);
        return panmiddle;
    }

    private JComponent createAllgemeinPanel() {
        this.panelAllgemein = new TitledPanel(Resource.getInstance().getAllgemeineEinstellungen());
        int[] w1 = new int[]{2, 0, 4, 0, 4, 0, 4, 0, 4, 0, 1};
        int[] h1 = new int[]{6, 0, 2, 0, 2, 0, 2, 0, 2};
        HIGLayout l = new HIGLayout(w1, h1);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(9, 1);
        this.panelAllgemein.setLayout(l);
        this.panMarke = this.createMarkePanel();
        this.panelAllgemein.add((Component)this.panMarke, c.rc(2, 2));
        this.panProduktart = this.createProduktPanel();
        this.panelAllgemein.add((Component)this.panProduktart, c.rc(4, 2));
        this.panKatalogumfang = this.createKatalogumfangPanel(this.model.enableKatalogumfangChoice());
        this.panelAllgemein.add((Component)this.panKatalogumfang, c.rc(6, 2));
        this.panelAllgemein.add((Component)this.createLenkungPanel(), c.rc(8, 2, "tlrb"));
        this.panelAllgemein.add((Component)this.createDarstellungBNBPanel(), c.rc(2, 4));
        if (this.model.hatRechtAnzeigeProduktionsdatum()) {
            this.panelAllgemein.add((Component)this.createProduktionsdatumPanel(), c.rc(4, 4));
        }
        this.panelAllgemein.add((Component)this.createSuchraumPanel(), c.rc(6, 4, "tlrb"));
        this.panelAllgemein.add((Component)this.createSprachePanel(), c.rc(8, 4, "tlrb"));
        this.panelAllgemein.add((Component)this.createRegionenPanel(), c.rcwh(2, 6, 1, 7, "tlrb"));
        this.panelAllgemein.add((Component)this.createSuchwegVerkuerzenPanel(), c.rc(2, 8));
        this.panelAllgemein.add((Component)this.createBandVerbautPanel(), c.rc(4, 8));
        if (this.model.hatRechtAnzeigePreise()) {
            this.panelAllgemein.add((Component)this.createPreisePanel(), c.rc(6, 8, "tlrb"));
        }
        JPanel pLokaleBtesPanel = this.createLokaleBtesPanel();
        boolean bIsUSETK = this.controller.isUSETK();
        if (bIsUSETK) {
            pLokaleBtesPanel.setVisible(false);
        }
        this.panelAllgemein.add((Component)pLokaleBtesPanel, c.rc(2, 10));
        this.panelAllgemein.add((Component)new JLabel(), c.rc(3, 10));
        this.panelAllgemein.add((Component)this.createVerbauMengePanel(), c.rc(4, 10));
        this.panelAllgemein.add((Component)new JLabel(), c.rc(9, 10));
        return this.panelAllgemein;
    }

    private JPanel createLenkungPanel() {
        this.comboLenkungen = new JComboBox();
        TitledPanel panLenkung = new TitledPanel(Resource.getInstance().getLenkung(), new BorderLayout(5, 5));
        panLenkung.add((Component)this.comboLenkungen, "North");
        return panLenkung;
    }

    private JPanel createDarstellungBNBPanel() {
        this.rbDarstellungBNBKomprimiert = new JRadioButton(Resource.getInstance().getKomprimiert());
        this.rbDarstellungBNBAusfuehrlich = new JRadioButton(Resource.getInstance().getAusfuehrlich());
        this.panDarstellungBNB = new ChoicePanel(Resource.getInstance().getDarstellungBildnummernErsteZeile(), Resource.getInstance().getDarstellungBildnummernZweiteZeile(), new AbstractButton[]{this.rbDarstellungBNBKomprimiert, this.rbDarstellungBNBAusfuehrlich}, 0);
        return this.panDarstellungBNB;
    }

    private JPanel createProduktionsdatumPanel() {
        this.rbProduktionsdatumImmer = new JRadioButton(Resource.getInstance().getImmer());
        this.rbProduktionsdatumAnfrage = new JRadioButton(Resource.getInstance().getAufAnfrage());
        this.panProduktionsdatum = new ChoicePanel(Resource.getInstance().getAnzeigeProduktionsdatumErsteZeile(), Resource.getInstance().getAnzeigeProduktionsdatumZweiteZeile(), new AbstractButton[]{this.rbProduktionsdatumImmer, this.rbProduktionsdatumAnfrage}, 0);
        return this.panProduktionsdatum;
    }

    private JPanel createSprachePanel() {
        this.comboSprachen = new JComboBox();
        this.comboSprachen.setFont(UIHelper.getSprachenCbUnicodeFont());
        TitledPanel panSprache = new TitledPanel(Resource.getInstance().getSprache(), new BorderLayout(5, 5));
        panSprache.add((Component)this.comboSprachen, "North");
        return panSprache;
    }

    private JPanel createRegionenPanel() {
        this.listRegionen = new JList();
        this.listRegionen.setSelectionMode(2);
        JPanel panRegionen = new JPanel();
        int[] w2 = new int[]{0};
        int[] h2 = new int[]{0, 5, 0};
        panRegionen.setLayout(new HIGLayout(w2, h2));
        HIGConstraints c = new HIGConstraints();
        TitledBorder tb = new TitledBorder(UIHelper.getStandardBorder(), Resource.getInstance().getKatalogausfuehrungen() + " /");
        tb.setTitleFont(UIHelper.getBoldFont());
        panRegionen.setBorder(tb);
        JLabel labRegionen = new JLabel(" " + Resource.getInstance().getRegionen());
        labRegionen.setFont(UIHelper.getBoldFont());
        panRegionen.add((Component)labRegionen, c.rc(1, 1));
        panRegionen.add((Component)this.listRegionen, c.rc(3, 1));
        this.listRegionen.setPreferredSize(new Dimension(this.listRegionen.getPreferredSize().width + 180, this.listRegionen.getPreferredSize().height));
        return panRegionen;
    }

    private JPanel createSuchwegVerkuerzenPanel() {
        this.rbSuchwegVerkuerzenJa = new JRadioButton(Resource.getInstance().getJa());
        this.rbSuchwegVerkuerzenNein = new JRadioButton(Resource.getInstance().getNein());
        this.panSuchwegVerkuerzen = new ChoicePanel(Resource.getInstance().getSuchwegVerkuerzenErsteZeile(), Resource.getInstance().getSuchwegVerkuerzenZweiteZeile(), new AbstractButton[]{this.rbSuchwegVerkuerzenJa, this.rbSuchwegVerkuerzenNein}, 0);
        return this.panSuchwegVerkuerzen;
    }

    private JPanel createBandVerbautPanel() {
        this.rbBandVerbautJa = new JRadioButton(Resource.getInstance().getJa());
        this.rbBandVerbautNein = new JRadioButton(Resource.getInstance().getNein() + "*");
        this.panBandVerbaut = new ChoicePanel(Resource.getInstance().getBandVerbautErsteZeile(), Resource.getInstance().getBandVerbautZweiteZeile(), new AbstractButton[]{this.rbBandVerbautJa, this.rbBandVerbautNein}, 0, "* " + Resource.getInstance().getNachruestungenBeruecksichtigtErsteZeile() + " " + Resource.getInstance().getNachruestungenBeruecksichtigtZweiteZeile());
        return this.panBandVerbaut;
    }

    private JPanel createPreisePanel() {
        this.rbPreisAnz = new JRadioButton(Resource.getInstance().getJa());
        this.rbPreisNichtAnz = new JRadioButton(Resource.getInstance().getNein());
        this.panPreise = new ChoicePanel(Resource.getInstance().getAnzeigeSonderUndNettopreisErsteZeile(), Resource.getInstance().getAnzeigeSonderUndNettopreisZweiteZeile(), new AbstractButton[]{this.rbPreisAnz, this.rbPreisNichtAnz}, 0);
        return this.panPreise;
    }

    private JPanel createTippsTricksPanel() {
        this.rbTippsTricksAnz = new JRadioButton(Resource.getInstance().getJa());
        this.rbTippsTricksNichtAnz = new JRadioButton(Resource.getInstance().getNein());
        this.panTippsTricks = new ChoicePanel(Resource.getInstance().getTippsTricksAnzeigenErsteZeile(), Resource.getInstance().getTippsTricksAnzeigenZweiteZeile(), new AbstractButton[]{this.rbTippsTricksAnz, this.rbTippsTricksNichtAnz}, 0);
        return this.panTippsTricks;
    }

    private JPanel createLokaleBtesPanel() {
        JPanel panMarktPrio = this.createMarktPrioPanel();
        JPanel panMarktWeitere = this.createWeitereMaerktePanel();
        JPanel panMaerkte = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 4, 0};
        HIGLayout lo = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        panMaerkte.setLayout(lo);
        panMaerkte.add((Component)panMarktPrio, c.rc(1, 1));
        panMaerkte.add((Component)panMarktWeitere, c.rc(3, 1));
        this.panLokaleBtes = new TitledComponent(Resource.getInstance().getLokaleBildtafeln(), panMaerkte, 5, 0);
        return this.panLokaleBtes;
    }

    private JPanel createMarktPrioPanel() {
        this.comboMarktPrio = new JComboBox();
        this.comboMarktPrio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DlgEinstellungenView.this.mbSuppressComboMarktPrioActionListener) {
                    return;
                }
                Markt newPrioMarkt = (Markt)DlgEinstellungenView.this.comboMarktPrio.getSelectedItem();
                DlgEinstellungenView.this.model.getMarktDaten().changePrioMarkt(newPrioMarkt);
                DlgEinstellungenView.this.setMaerkte();
            }
        });
        TitledComponent panMarktPrio = new TitledComponent(Resource.getInstance().getFuerMarktPrio(), this.comboMarktPrio, 5, 0);
        return panMarktPrio;
    }

    private JPanel createVerbauMengePanel() {
        this.rbMengeEins = new JRadioButton(Resource.getInstance().getMengenEins());
        this.rbVerbauMenge = new JRadioButton(Resource.getInstance().getVerbauMenge());
        this.panelVerbauMenge = new ChoicePanel(Resource.getInstance().getMengenUebernahme(), new AbstractButton[]{this.rbMengeEins, this.rbVerbauMenge}, 0);
        return this.panelVerbauMenge;
    }

    private JPanel createWeitereMaerktePanel() {
        JPanel panMarktWeitere = new JPanel();
        int[] width = new int[]{5, 0, 5, 0, 11};
        int[] hNotExpanded = new int[]{0};
        int[] hExpanded = new int[]{0, 5, 0};
        HIGLayout lo = null;
        lo = this.marktWeitereExpanded ? new HIGLayout(width, hExpanded) : new HIGLayout(width, hNotExpanded);
        lo.setRowWeight(1, 2);
        lo.setColumnWeight(2, 2);
        HIGConstraints c = new HIGConstraints();
        panMarktWeitere.setLayout(lo);
        JLabel weitereMaerkte = new JLabel(Resource.getInstance().getWeitereMaerkte());
        weitereMaerkte.setFont(UIHelper.getBoldFont());
        panMarktWeitere.add((Component)weitereMaerkte, c.rc(1, 2));
        JLabel marktWeiterePfeilAuf = new JLabel(ImageCache.getInstance().getIcon("aufklappen.gif"));
        marktWeiterePfeilAuf.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                DlgEinstellungenView.this.showListMarktWeitere(true);
            }
        });
        if (!this.marktWeitereExpanded) {
            panMarktWeitere.add((Component)marktWeiterePfeilAuf, c.rc(1, 4));
        }
        JLabel marktWeiterePfeilZu = new JLabel(ImageCache.getInstance().getIcon("zuklappen.gif"));
        marktWeiterePfeilZu.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                DlgEinstellungenView.this.showListMarktWeitere(false);
            }
        });
        if (this.marktWeitereExpanded) {
            panMarktWeitere.add((Component)marktWeiterePfeilZu, c.rc(1, 4));
        }
        this.listMarktWeitere = new JList();
        this.listMarktWeitere.setSelectionMode(2);
        this.listMarktWeitere.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                if (DlgEinstellungenView.this.mbSuppressListWeitereMarekteSelectionListener) {
                    return;
                }
                int[] newSelInd = DlgEinstellungenView.this.listMarktWeitere.getSelectedIndices();
                DlgEinstellungenView.this.model.getMarktDaten().setSelSonstigeMaerkte(newSelInd);
            }
        });
        if (this.marktWeitereExpanded) {
            JScrollPane spMarktWeitere = new JScrollPane(this.listMarktWeitere);
            Dimension dimMarktPrio = this.comboMarktPrio.getPreferredSize();
            Dimension dimMarktWeitere = new Dimension(dimMarktPrio.width, 262);
            panMarktWeitere.setMinimumSize(dimMarktWeitere);
            spMarktWeitere.setPreferredSize(dimMarktWeitere);
            panMarktWeitere.add((Component)spMarktWeitere, c.rcwh(3, 2, 3, 1));
        }
        return panMarktWeitere;
    }

    private void showListMarktWeitere(boolean show) {
        this.marktWeitereExpanded = show;
        HIGConstraints c = new HIGConstraints();
        this.panelAllgemein.remove(this.panLokaleBtes);
        this.panelAllgemein.remove(this.panelVerbauMenge);
        if (show) {
            this.panelAllgemein.add((Component)this.createLokaleBtesPanel(), c.rcwh(2, 10, 1, 5));
            this.panelAllgemein.add((Component)this.panelVerbauMenge, c.rc(8, 10));
            this.panelVerbauMenge.invalidate();
        } else {
            this.panelAllgemein.add((Component)this.createLokaleBtesPanel(), c.rc(2, 10));
            this.panelAllgemein.add((Component)this.panelVerbauMenge, c.rc(4, 10));
            this.panelVerbauMenge.invalidate();
        }
        this.setMaerkte();
    }

    private JPanel createMarkePanel() {
        TitledPanel panelMarken = new TitledPanel(Resource.getInstance().getMarke(), new BorderLayout(5, 5));
        this.comboMarken = new JComboBox();
        for (String sMarke : this.model.getUserMarken()) {
            Marke oMarke = Marken.getInstance().getMarkeZurMarkeBerechtigung(sMarke);
            oMarke.setName(Resource.getInstance().getNameMarke(sMarke));
            this.vMarken.add(oMarke);
            this.comboMarken.addItem(oMarke);
            ArrayList<String> moeglProdukteZurMarke = MarkenProdukte.getInstance(1).getProdukteZurMarke(oMarke.getBerechtigung());
            for (String sProdukt : moeglProdukteZurMarke) {
                if (this.moeglProdukteZuUserMarken.contains(sProdukt)) continue;
                this.moeglProdukteZuUserMarken.add(sProdukt);
            }
        }
        if (this.vMarken.size() > 1) {
            panelMarken.add((Component)this.comboMarken, "North");
        } else {
            String sMarkeText = this.vMarken.get(0).toString();
            int[] w1 = new int[]{10, 0, 10};
            int[] h1 = new int[]{5, 0, 5};
            HIGLayout layout = new HIGLayout(w1, h1);
            HIGConstraints c = new HIGConstraints();
            panelMarken.setLayout(layout);
            panelMarken.add((Component)new JLabel(sMarkeText), c.rc(2, 2));
        }
        return panelMarken;
    }

    private JPanel createProduktPanel() {
        TitledPanel panelProdukte;
        Collection<String> userProdukteList = this.model.getUserProdukte();
        for (String sProdukt : userProdukteList) {
            if (!this.moeglProdukteZuUserMarken.contains(sProdukt)) continue;
            Produkt oProdukt = Produkte.getInstance().getProduktZurProduktBerechtigung(sProdukt);
            String sProduktName = Resource.getInstance().getNameProdukt(sProdukt);
            oProdukt.setName(sProduktName);
            this.vProdukte.add(oProdukt);
            this.hJrbProdukt.put(oProdukt, new JRadioButton(sProduktName));
        }
        if (this.vProdukte.size() > 1) {
            ArrayList<String> sortProdukteList = Produkte.getInstance().getEigenschaften("produkt.berechtigung");
            AbstractButton[] abProdukten = new AbstractButton[this.hJrbProdukt.size()];
            for (Produkt oProdukt : this.vProdukte) {
                int index = sortProdukteList.indexOf(oProdukt.getBerechtigung());
                abProdukten[index] = this.hJrbProdukt.get(oProdukt);
            }
            panelProdukte = new ChoicePanel(Resource.getInstance().getProduktart(), abProdukten, -1);
        } else {
            String sProduktartText = this.vProdukte.get(0).toString();
            panelProdukte = new TitledPanel(Resource.getInstance().getProduktart());
            int[] w1 = new int[]{10, 0, 10};
            int[] h1 = new int[]{5, 0, 5};
            HIGLayout layout = new HIGLayout(w1, h1);
            HIGConstraints c = new HIGConstraints();
            panelProdukte.setLayout(layout);
            panelProdukte.add((Component)new JLabel(sProduktartText), c.rc(2, 2));
        }
        return panelProdukte;
    }

    private JPanel createKatalogumfangPanel(boolean bEnable) {
        TitledPanel panel = null;
        if (bEnable) {
            this.rbKatalogumfangVT = new JRadioButton(Resource.getInstance().getHauptkatalog());
            this.rbKatalogumfangST = new JRadioButton(Resource.getInstance().getMobileTradition());
            panel = new ChoicePanel(Resource.getInstance().getKatalogumfang(), new AbstractButton[]{this.rbKatalogumfangVT, this.rbKatalogumfangST}, -1);
        } else {
            String sKatalogumfangText = "";
            sKatalogumfangText = this.model.getUserKatalogumfang().equals("VT") ? Resource.getInstance().getHauptkatalog() : Resource.getInstance().getMobileTradition();
            panel = new TitledPanel(Resource.getInstance().getKatalogumfang());
            int[] w1 = new int[]{10, 0, 10};
            int[] h1 = new int[]{5, 0, 5};
            HIGLayout l = new HIGLayout(w1, h1);
            HIGConstraints c = new HIGConstraints();
            panel.setLayout(l);
            panel.add((Component)new JLabel(sKatalogumfangText), c.rc(2, 2));
        }
        return panel;
    }

    private JPanel createSuchraumPanel() {
        TitledPanel panel = null;
        boolean bShowSuchraumAuswahl = this.model.showSuchraumAuswahl();
        if (bShowSuchraumAuswahl) {
            this.rbSuchraumLokal = new JRadioButton(Resource.getInstance().getLokalenKatalog());
            this.rbSuchraumZentral = new JRadioButton(Resource.getInstance().getZentralenKatalog());
            panel = new ChoicePanel(Resource.getInstance().getSucheIm(), new AbstractButton[]{this.rbSuchraumLokal, this.rbSuchraumZentral}, 0);
        } else {
            String sText = Resource.getInstance().getLokalenKatalog();
            panel = new TitledPanel(Resource.getInstance().getSucheIm());
            int[] w = new int[]{10, 0, 10};
            int[] h = new int[]{5, 0, 5};
            HIGLayout l = new HIGLayout(w, h);
            HIGConstraints c = new HIGConstraints();
            panel.setLayout(l);
            panel.add((Component)new JLabel(sText), c.rc(2, 2));
        }
        return panel;
    }

    private JComponent createLayoutPanel() {
        TitledPanel panel = new TitledPanel(Resource.getInstance().getLayoutEinstellungen());
        int[] w1 = new int[]{10, 0, 10};
        int[] h1 = new int[]{10, 0, 3, 0, 10};
        HIGLayout l = new HIGLayout(w1, h1);
        HIGConstraints c = new HIGConstraints();
        l.setRowWeight(2, 3);
        l.setRowWeight(4, 3);
        panel.setLayout(l);
        this.cbGrosseSchrift = new JCheckBox(Resource.getInstance().getGrosseSchriftartenVerwenden());
        panel.add((Component)this.cbGrosseSchrift, c.rc(2, 1, "lt"));
        this.cbStreckeTabellen = new JCheckBox(Resource.getInstance().getTabellenAufFenstergroesse());
        panel.add((Component)this.cbStreckeTabellen, c.rc(4, 1, "lt"));
        return panel;
    }

    private JComponent createButtonPanel() {
        JPanel panel = new JPanel();
        int[] w1 = new int[]{10, -4, 10, -2, 10};
        int[] h1 = new int[]{10, 0, 10};
        HIGLayout l = new HIGLayout(w1, h1);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(1, 1);
        l.setColumnWeight(5, 1);
        panel.setLayout(l);
        this.buttonOK = new JButtonEx(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgEinstellungenView.this.saveEinstellungen();
            }
        });
        panel.add((Component)this.buttonOK, c.rc(2, 2, "ltbr"));
        this.buttonUndo = new JButtonEx(Resource.getInstance().getZuruecksetzen(), ImageCache.getInstance().getIcon("delete.gif"));
        if (this.model.isFirstLogin()) {
            this.buttonUndo.setEnabled(false);
        }
        this.buttonUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
                DlgEinstellungenView.this.model.storeEinstellungen(oLoginInfo.getSettings());
                DlgEinstellungenView.this.model.getMarktDaten().fillAuswahlSonstigeMaerkte(null);
                DlgEinstellungenView.this.update();
            }
        });
        panel.add((Component)this.buttonUndo, c.rc(2, 4, "ltbr"));
        return panel;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Iterator<JComponent> getMenus() {
        return null;
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oController) {
        log.debug((Object)"init");
        this.model = (DlgEinstellungenModel)oDlgModel;
        this.controller = (DlgEinstellungenController)oController;
        this.createLayout();
        this.update();
    }

    @Override
    public void update() {
        boolean bShowSuchraumAuswahl;
        EinstellungenBasis oEinstellungen = this.model.getEinstellungen();
        boolean bNeuanlage = oEinstellungen.getSprache() == null;
        this.rbVerbauMenge.setSelected(oEinstellungen.getVerbaumenge());
        this.rbMengeEins.setSelected(!oEinstellungen.getVerbaumenge());
        if (bNeuanlage && this.vMarken.size() > 1) {
            this.comboMarken.setSelectedIndex(-1);
        } else {
            for (Marke oMarke : this.vMarken) {
                if (!oMarke.getBerechtigung().equals(oEinstellungen.getMarke())) continue;
                this.comboMarken.setSelectedItem(oMarke);
                break;
            }
        }
        if (bNeuanlage && this.vProdukte.size() > 1) {
            for (Produkt oProdukt : this.hJrbProdukt.keySet()) {
                this.hJrbProdukt.get(oProdukt).setSelected(false);
            }
        } else {
            for (Produkt oProdukt : this.hJrbProdukt.keySet()) {
                if (!oProdukt.getBerechtigung().equals(oEinstellungen.getProduktart())) continue;
                this.hJrbProdukt.get(oProdukt).setSelected(true);
                break;
            }
        }
        if (this.model.enableKatalogumfangChoice()) {
            if (!bNeuanlage) {
                String sKatalogumfang = oEinstellungen.getKatalogumfang();
                if (sKatalogumfang.equals("VT")) {
                    this.rbKatalogumfangVT.setSelected(true);
                } else if (sKatalogumfang.equals("ST")) {
                    this.rbKatalogumfangST.setSelected(true);
                }
            } else {
                ((ChoicePanel)this.panKatalogumfang).deselectAllButtons();
            }
        }
        this.comboSprachen.removeAllItems();
        for (Sprache sprache : this.model.getSprachen()) {
            this.comboSprachen.addItem(sprache.getBenennung());
        }
        if (!bNeuanlage) {
            String sSprache = oEinstellungen.getSprache();
            if (oEinstellungen.getSpracheRegion() != null) {
                sSprache = sSprache + oEinstellungen.getSpracheRegion();
            }
            this.comboSprachen.setSelectedIndex(this.model.getIndexSelSprache(sSprache));
        } else {
            this.comboSprachen.setSelectedIndex(-1);
        }
        this.comboLenkungen.removeAllItems();
        HashMap<String, String> oLenkungen = this.model.getLenkungen();
        if (oLenkungen != null) {
            String sBenennung;
            int i = 1;
            while ((sBenennung = oLenkungen.get(i + "benennung")) != null) {
                this.comboLenkungen.addItem(sBenennung);
                ++i;
            }
        }
        if (!bNeuanlage) {
            String sLenkung = oEinstellungen.getLenkung();
            int nSelIndex = this.model.getIndexSelLenkung(sLenkung);
            if (nSelIndex != -1) {
                this.comboLenkungen.setSelectedIndex(this.model.getIndexSelLenkung(sLenkung));
            } else {
                this.comboLenkungen.setSelectedIndex(0);
            }
        } else {
            this.comboLenkungen.setSelectedIndex(-1);
        }
        if (!bNeuanlage) {
            boolean bSuchwegVerk = oEinstellungen.getSuchwegVerkuerzen();
            if (bSuchwegVerk) {
                this.rbSuchwegVerkuerzenJa.setSelected(true);
            } else {
                this.rbSuchwegVerkuerzenNein.setSelected(true);
            }
        } else {
            this.panSuchwegVerkuerzen.deselectAllButtons();
        }
        if (!bNeuanlage) {
            boolean bDarstellungKomp = oEinstellungen.getDarstellungBN();
            if (bDarstellungKomp) {
                this.rbDarstellungBNBKomprimiert.setSelected(true);
            } else {
                this.rbDarstellungBNBAusfuehrlich.setSelected(true);
            }
        } else {
            this.panDarstellungBNB.deselectAllButtons();
        }
        this.listRegionen.setListData(this.model.getRegionenVector(true));
        if (!bNeuanlage && this.model.getSelRegionenIndizes() != null) {
            this.listRegionen.setSelectedIndices(this.model.getSelRegionenIndizes());
        }
        if (bShowSuchraumAuswahl = this.model.showSuchraumAuswahl()) {
            if (!bNeuanlage) {
                String sSuchraum = oEinstellungen.getSuchraum();
                if (sSuchraum.equals("L")) {
                    this.rbSuchraumLokal.setSelected(true);
                } else {
                    this.rbSuchraumZentral.setSelected(true);
                }
            } else {
                this.rbSuchraumLokal.setSelected(true);
            }
        }
        this.setMaerkte();
        boolean bCheckTA = false;
        if (!bNeuanlage && oEinstellungen.getTabellenanzeige().equals("V")) {
            bCheckTA = true;
        }
        this.cbStreckeTabellen.setSelected(bCheckTA);
        boolean bCheckSG = true;
        if (!bNeuanlage && oEinstellungen.getSchriftgroesse().equals("K")) {
            bCheckSG = false;
        }
        this.cbGrosseSchrift.setSelected(bCheckSG);
        if (this.model.hatRechtAnzeigeProduktionsdatum()) {
            if (!bNeuanlage) {
                Boolean bDisplayProdDate = this.model.getEinstellungen().getAlwaysDisplayProduktDate();
                if (bDisplayProdDate != null) {
                    boolean bAnzeigeImmer = bDisplayProdDate;
                    if (bAnzeigeImmer) {
                        this.rbProduktionsdatumImmer.setSelected(true);
                    } else {
                        this.rbProduktionsdatumAnfrage.setSelected(true);
                    }
                } else {
                    this.panProduktionsdatum.deselectAllButtons();
                }
            } else {
                this.panProduktionsdatum.deselectAllButtons();
            }
        }
        if (this.model.hatRechtAnzeigePreise()) {
            if (!bNeuanlage) {
                Boolean bDisplayPreise = this.model.getEinstellungen().getDisplayPreise();
                if (bDisplayPreise != null) {
                    boolean bAnzeige = bDisplayPreise;
                    if (bAnzeige) {
                        this.rbPreisAnz.setSelected(true);
                    } else {
                        this.rbPreisNichtAnz.setSelected(true);
                    }
                } else {
                    this.rbPreisAnz.setSelected(false);
                    this.rbPreisNichtAnz.setSelected(false);
                }
            } else {
                this.panPreise.deselectAllButtons();
            }
        }
        if (!bNeuanlage) {
            boolean bDisplayTippsTricks = this.model.getEinstellungen().displayTippsTricks();
            if (bDisplayTippsTricks) {
                this.rbTippsTricksAnz.setSelected(true);
            } else {
                this.rbTippsTricksNichtAnz.setSelected(true);
            }
        } else {
            this.panTippsTricks.deselectAllButtons();
        }
        if (!bNeuanlage) {
            boolean bDisplayNachruestungen = this.model.getEinstellungen().getNachruestungenRelevant();
            if (bDisplayNachruestungen) {
                this.rbBandVerbautNein.setSelected(true);
            } else {
                this.rbBandVerbautJa.setSelected(true);
            }
        }
    }

    private void setMaerkte() {
        this.mbSuppressComboMarktPrioActionListener = true;
        this.comboMarktPrio.removeAllItems();
        for (Markt markt : this.model.getMarktDaten().getAuswahlPrimaerMarkt()) {
            this.comboMarktPrio.addItem(markt);
        }
        boolean bIsUSETK = this.controller.isUSETK();
        if (bIsUSETK) {
            MarktDaten marktDaten = this.model.getMarktDaten();
            Collection<Markt> maerkte = marktDaten.getAuswahlPrimaerMarkt();
            for (Markt markt : maerkte) {
                if (!markt.isUSA()) continue;
                this.comboMarktPrio.setSelectedItem(markt);
            }
        } else {
            Markt selPrioMarkt = this.model.getMarktDaten().getSelPrimaerMarkt();
            if (selPrioMarkt != null) {
                this.comboMarktPrio.setSelectedItem(selPrioMarkt);
            } else {
                this.comboMarktPrio.setSelectedIndex(0);
            }
        }
        this.mbSuppressComboMarktPrioActionListener = false;
        this.mbSuppressListWeitereMarekteSelectionListener = true;
        this.listMarktWeitere.setListData(this.model.getMarktDaten().getAuswahlSonstigeMaerkte());
        int[] aSelIndizes = this.model.getMarktDaten().getIndicesSelSonstigeMaerkte();
        if (bIsUSETK) {
            aSelIndizes = new int[]{};
        }
        if (aSelIndizes != null) {
            this.listMarktWeitere.setSelectedIndices(aSelIndizes);
        }
        this.mbSuppressListWeitereMarekteSelectionListener = false;
    }

    private void saveEinstellungen() {
        if (!this.isComplete()) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSettingsNoSave(), Resource.getInstance().getEinstellungen(), 0);
            return;
        }
        EinstellungenBasis oEinstellungenSave = this.fillEinstellungen();
        if (!this.controller.checkEinstellungen(oEinstellungenSave)) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSaveEinstellungenNoData(), Resource.getInstance().getEinstellungen(), 0);
            return;
        }
        if (!this.controller.saveEinstellungen(oEinstellungenSave)) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSaveEinstellungenFailed(), Resource.getInstance().getEinstellungen(), 0);
        } else {
            this.controller.notifyAllExitListeners();
            MainWorkflowsteuerung.getInstance().displayDefaultDialog();
            MainView.getInstance().initMenus();
        }
    }

    private boolean isComplete() {
        if (this.comboMarken.getSelectedIndex() == -1) {
            return false;
        }
        boolean bEinProduktSelected = false;
        for (Produkt oProdukt : this.hJrbProdukt.keySet()) {
            if (!this.hJrbProdukt.get(oProdukt).isSelected()) continue;
            bEinProduktSelected = true;
            break;
        }
        if (!bEinProduktSelected) {
            return false;
        }
        if (this.model.enableKatalogumfangChoice() && !this.rbKatalogumfangVT.isSelected() && !this.rbKatalogumfangST.isSelected()) {
            return false;
        }
        if (this.listRegionen.getSelectedIndices().length == 0) {
            return false;
        }
        String sLenkung = (String)this.comboLenkungen.getSelectedItem();
        if (sLenkung == null) {
            return false;
        }
        String sSprache = (String)this.comboSprachen.getSelectedItem();
        if (sSprache == null) {
            return false;
        }
        if (!this.rbSuchwegVerkuerzenJa.isSelected() && !this.rbSuchwegVerkuerzenNein.isSelected()) {
            return false;
        }
        if (!this.rbBandVerbautJa.isSelected() && !this.rbBandVerbautNein.isSelected()) {
            return false;
        }
        if (!this.rbDarstellungBNBKomprimiert.isSelected() && !this.rbDarstellungBNBAusfuehrlich.isSelected()) {
            return false;
        }
        if (this.model.hatRechtAnzeigeProduktionsdatum() && !this.rbProduktionsdatumImmer.isSelected() && !this.rbProduktionsdatumAnfrage.isSelected()) {
            return false;
        }
        if (this.model.hatRechtAnzeigePreise() && !this.rbPreisAnz.isSelected() && !this.rbPreisNichtAnz.isSelected()) {
            return false;
        }
        return this.rbTippsTricksAnz.isSelected() || this.rbTippsTricksNichtAnz.isSelected();
    }

    private EinstellungenBasis fillEinstellungen() {
        int[] aSelIndexes;
        EinstellungenBasis oEinstellungenNeu = new EinstellungenBasis();
        oEinstellungenNeu.setVerbaumenge(this.rbVerbauMenge.isSelected());
        Object obj = this.comboMarken.getSelectedItem();
        if (obj instanceof Marke) {
            Marke oMarke = (Marke)obj;
            oEinstellungenNeu.setMarke(oMarke.getBerechtigung());
        }
        for (Produkt oProdukt : this.hJrbProdukt.keySet()) {
            if (!this.hJrbProdukt.get(oProdukt).isSelected()) continue;
            oEinstellungenNeu.setProduktart(oProdukt.getBerechtigung());
        }
        if (this.model.enableKatalogumfangChoice()) {
            if (this.rbKatalogumfangVT.isSelected()) {
                oEinstellungenNeu.setKatalogumfang("VT");
            }
            if (this.rbKatalogumfangST.isSelected()) {
                oEinstellungenNeu.setKatalogumfang("ST");
            }
        } else {
            oEinstellungenNeu.setKatalogumfang(this.model.getUserKatalogumfang());
        }
        if ((aSelIndexes = this.listRegionen.getSelectedIndices())[0] == 0) {
            Iterator<String> iterator = this.model.getRegionenVector(false).iterator();
            while (iterator.hasNext()) {
                oEinstellungenNeu.addRegion(iterator.next());
            }
        } else {
            for (int i = 0; i < aSelIndexes.length; ++i) {
                int nIndex = aSelIndexes[i];
                oEinstellungenNeu.addRegion(this.model.getRegionenVector(false).get(nIndex - 1));
            }
        }
        int nIndexLenkungInHashMap = this.comboLenkungen.getSelectedIndex() + 1;
        String sLenkung = this.model.getLenkungen().get(nIndexLenkungInHashMap + "lenkung");
        oEinstellungenNeu.setLenkung(sLenkung);
        String sSprache = (String)this.comboSprachen.getSelectedItem();
        for (Sprache sprache : this.model.getSprachen()) {
            if (!sprache.getBenennung().equals(sSprache)) continue;
            oEinstellungenNeu.setSprache(sprache.getIso());
            String spracheRegion = sprache.getRegIso();
            spracheRegion = "".equals(spracheRegion) ? null : spracheRegion;
            oEinstellungenNeu.setSpracheRegion(spracheRegion);
            break;
        }
        boolean bSuchwegVerk = this.rbSuchwegVerkuerzenJa.isSelected();
        oEinstellungenNeu.setSuchwegVerkuerzen(bSuchwegVerk);
        boolean bNachruest = !this.rbBandVerbautJa.isSelected();
        oEinstellungenNeu.setNachruestungenRelevant(bNachruest);
        boolean bDarstellungBNKomprimiert = this.rbDarstellungBNBKomprimiert.isSelected();
        oEinstellungenNeu.setDarstellungBN(bDarstellungBNKomprimiert);
        if (this.model.hatRechtAnzeigeProduktionsdatum()) {
            Boolean bProduktionsdatumImmer = null;
            if (this.rbProduktionsdatumImmer.isSelected()) {
                bProduktionsdatumImmer = true;
            }
            if (this.rbProduktionsdatumAnfrage.isSelected()) {
                bProduktionsdatumImmer = false;
            }
            oEinstellungenNeu.setAlwaysDisplayProduktDate(bProduktionsdatumImmer);
        } else {
            oEinstellungenNeu.setAlwaysDisplayProduktDate(null);
        }
        if (this.model.hatRechtAnzeigePreise()) {
            Boolean bAnzeigePreise = null;
            if (this.rbPreisAnz.isSelected()) {
                bAnzeigePreise = true;
            }
            if (this.rbPreisNichtAnz.isSelected()) {
                bAnzeigePreise = false;
            }
            oEinstellungenNeu.setDisplayPreise(bAnzeigePreise);
        } else {
            oEinstellungenNeu.setDisplayPreise(null);
        }
        boolean bAnzeigeTippsTricks = true;
        if (this.rbTippsTricksNichtAnz.isSelected()) {
            bAnzeigeTippsTricks = false;
        }
        oEinstellungenNeu.displayTrippsTricks(bAnzeigeTippsTricks);
        String sTabellenanzeige = this.cbStreckeTabellen.isSelected() ? "V" : "S";
        oEinstellungenNeu.setTabellenanzeige(sTabellenanzeige);
        String sSchriftgroesse = this.cbGrosseSchrift.isSelected() ? "G" : "K";
        oEinstellungenNeu.setSchriftgroesse(sSchriftgroesse);
        oEinstellungenNeu.setIPACMarkt(this.model.getEinstellungen().getIPACMarkt());
        boolean bShowSuchraumAuswahl = this.model.showSuchraumAuswahl();
        String sSuchraum = "L";
        if (bShowSuchraumAuswahl) {
            sSuchraum = this.rbSuchraumZentral.isSelected() ? "Z" : "L";
        }
        oEinstellungenNeu.setSuchraum(sSuchraum);
        Markt selPrimaerMarkt = (Markt)this.comboMarktPrio.getSelectedItem();
        oEinstellungenNeu.setEtkPrimaerMarkt(selPrimaerMarkt);
        ArrayList<Markt> weitereMaerkte = new ArrayList<Markt>();
        if (this.listMarktWeitere.isSelectedIndex(0)) {
            ListModel maerkteInList = this.listMarktWeitere.getModel();
            for (int ii = 1; ii < maerkteInList.getSize(); ++ii) {
                Markt selWeitererMarkt = (Markt)maerkteInList.getElementAt(ii);
                weitereMaerkte.add(selWeitererMarkt);
            }
        } else {
            Object[] maerkte = this.listMarktWeitere.getSelectedValues();
            for (int ii = 0; ii < maerkte.length; ++ii) {
                Markt selWeitererMarkt = (Markt)maerkte[ii];
                weitereMaerkte.add(selWeitererMarkt);
            }
        }
        oEinstellungenNeu.setEtkSonstigeMaerkte(weitereMaerkte);
        return oEinstellungenNeu;
    }
}

