/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.kommunikation;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import de.esg.commonclient.dialog.JButtonEx;
import de.esg.commonclient.dialog.LimitedTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.AbstractDlgMitTLController;
import webetk.javaclient.dialog.AbstractDlgMitTLView;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteModel;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteView;
import webetk.javaclient.dialog.extras.teileliste.TeilelistenUebersichtController;
import webetk.javaclient.dialog.extras.teileliste.TeilelistenUebersichtView;
import webetk.javaclient.framework.MainView;
import webetk.resources.Resource;

public class AskProperties
extends JDialog {
    private static final long serialVersionUID = -2216527974691268380L;
    private static Logger log = Logger.getLogger(AskProperties.class);
    private Container mContentPane;
    private HeaderPanel panHeader;
    private JButtonEx mButtonUebernehmen;
    private JButtonEx mButtonAbbrechen;
    private JLabel mZeile1;
    private JCheckBox mChkUSFile;
    private JLabel mNameUSFile;
    private JLabel mCommentUSFile;
    private JTextField mtfUSFile;
    private String msDefaultUSFile;
    DialogView moDlgView;
    private String mszClientPropertyFile;

    public AskProperties(DialogView oDlgView) {
        super(MainView.getInstance());
        this.moDlgView = oDlgView;
        this.mszClientPropertyFile = GlobalObjects.getInstance().getPropertyFile();
        this.setModal(true);
        this.setSize(580, 360);
        this.setLocation(150, 150);
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle(Resource.getInstance().getSchnittstellen());
        this.panHeader = new HeaderPanel(Resource.getInstance().getSchnittstellen(), null);
        this.mButtonUebernehmen = new JButtonEx(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.mButtonAbbrechen = new JButtonEx(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.mZeile1 = new JLabel(Resource.getInstance().getWerteFuerSchnittstellenAngeben());
        this.mNameUSFile = new JLabel("usdealer.filename");
        this.mCommentUSFile = new JLabel(Resource.getInstance().getUsfile());
        this.mtfUSFile = new LimitedTextField(256, 60);
        this.mChkUSFile = new JCheckBox(Resource.getInstance().getUsFileVerwenden());
        this.mChkUSFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AskProperties.this.mChkUSFile.isSelected()) {
                    AskProperties.this.mtfUSFile.setText("");
                    AskProperties.this.mtfUSFile.setEnabled(false);
                    AskProperties.this.mtfUSFile.setEditable(false);
                } else {
                    AskProperties.this.mtfUSFile.setEnabled(true);
                    AskProperties.this.mtfUSFile.setEditable(true);
                    AskProperties.this.mtfUSFile.setText(AskProperties.this.msDefaultUSFile);
                }
            }
        });
        this.loadProperties();
        this.layoutAll();
    }

    private void layoutAll() {
        this.mContentPane = this.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.mContentPane.setLayout(l);
        this.mContentPane.add((Component)this.panHeader, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        this.mContentPane.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    private JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{5, 0};
        int[] heights = new int[]{10, 0, 20, 0, 1};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.createCenterPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(4, 2, "lrtb"));
        return panel;
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{5, 0, 10, 0, 380, 0, 10};
        int[] heights = new int[]{10, 0, 15, 0, 2, 0, 5, 0, 15, 0, 2, 0, 5, 0, 5};
        HIGLayout layout = new HIGLayout(widths, heights);
        panel.setLayout(layout);
        panel.add((Component)this.mZeile1, c.rcwh(2, 2, 6, 1, "tlbr"));
        panel.add((Component)this.mChkUSFile, c.rcwh(4, 2, 6, 1, "tlbr"));
        panel.add((Component)this.mCommentUSFile, c.rcwh(6, 2, 6, 1, "tlbr"));
        panel.add((Component)this.mNameUSFile, c.rc(8, 2, "l"));
        panel.add((Component)this.mtfUSFile, c.rcwh(8, 4, 3, 1, "tlbr"));
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-5, -4, 10, -2, -1};
        int[] heights = new int[]{0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(1, 1);
        layoutPosTeileliste.setColumnWeight(5, 1);
        layoutPosTeileliste.setRowWeight(2, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.mButtonUebernehmen, c.rc(1, 2, "lrtb"));
        this.mButtonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AskProperties.this.doOkButtonAction();
            }
        });
        panel.add((Component)this.mButtonAbbrechen, c.rc(1, 4, "lrtb"));
        this.mButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AskProperties.this.dispose();
            }
        });
        return panel;
    }

    private void loadProperties() {
        try {
            Properties oProperties = new Properties();
            FileInputStream in = new FileInputStream(this.mszClientPropertyFile);
            oProperties.load(in);
            in.close();
            this.msDefaultUSFile = oProperties.getProperty("usdealer.filename.default");
            String sUSFile = oProperties.getProperty("usdealer.filename");
            if (sUSFile == null || sUSFile.length() < 1) {
                this.mChkUSFile.setSelected(false);
                this.mtfUSFile.setEnabled(false);
                this.mtfUSFile.setEditable(false);
                this.mtfUSFile.setText("");
            } else {
                this.mChkUSFile.setSelected(true);
                this.mtfUSFile.setEnabled(true);
                this.mtfUSFile.setEditable(true);
                this.mtfUSFile.setText(sUSFile);
            }
            System.out.println("Loaded Client-Properties from file" + this.mszClientPropertyFile);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private void saveProperties() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.saveClientProperties();
        GlobalObjects.getInstance().getEtkData().setUSDealerFilename(this.mtfUSFile.getText());
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void saveClientProperties() {
        try {
            Vector<String> aszZeilen = new Vector<String>();
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(this.mszClientPropertyFile)));
            String szLine = in.readLine();
            while (szLine != null) {
                if (szLine.indexOf("usdealer.filename") == 0 && szLine.indexOf("usdealer.filename.") < 0) {
                    szLine = "usdealer.filename=" + this.mtfUSFile.getText();
                }
                szLine = AskProperties.maskBackSlash(szLine);
                aszZeilen.add(szLine);
                szLine = in.readLine();
            }
            in.close();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.mszClientPropertyFile)));
            Iterator iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private static String maskBackSlash(String sSource) {
        if (sSource == null) {
            return sSource;
        }
        int nIndex = sSource.indexOf("\\");
        while (nIndex != -1) {
            String sNewString;
            if (nIndex < sSource.length() - 2 && sSource.charAt(nIndex + 1) == '\\') {
                nIndex = sSource.indexOf("\\", nIndex + 2);
                continue;
            }
            sSource = sNewString = sSource.substring(0, nIndex) + "\\\\" + sSource.substring(nIndex + 1, sSource.length());
            nIndex = sSource.indexOf("\\", nIndex + 2);
        }
        return sSource;
    }

    private void doOkButtonAction() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.saveProperties();
        if (this.mtfUSFile.getText().length() > 0) {
            this.createUSListen();
        }
        if (this.moDlgView instanceof DlgTeilelisteView) {
            DlgTeilelisteView view = (DlgTeilelisteView)this.moDlgView;
            DlgTeilelisteModel model = view.getModel();
            model.setUSSchnittstelleFilename(this.mtfUSFile.getText());
            model.setMustReload(true);
            this.moDlgView.update();
        } else if (this.moDlgView instanceof TeilelistenUebersichtView) {
            TeilelistenUebersichtView view = (TeilelistenUebersichtView)this.moDlgView;
            TeilelistenUebersichtController controller = view.getController();
            controller.loadTL();
            this.moDlgView.update();
        } else if (this.moDlgView instanceof AbstractDlgMitTLView) {
            AbstractDlgMitTLView view = (AbstractDlgMitTLView)this.moDlgView;
            AbstractDlgMitTLController controler = view.getController();
            controler.loadTeilelistenIDs();
            view.updateTeilelisten();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.dispose();
    }

    private void createUSListen() {
        TrfHashMap trf = new TrfHashMap(null);
        trf.setValue("us_filename", this.mtfUSFile.getText());
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.INSERT_US_LISTEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)"Error ", (Throwable)ex);
            this.setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trf.getError(), this.getTitle(), 0);
            return;
        }
        if (trf.getError() != null) {
            log.error((Object)"Error ", (Throwable)trf.getError());
            this.setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trf.getError(), this.getTitle(), 0);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }
}

