/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileinfo;

import com.bmw.tetis.psi.common.PsiCommunicationException;
import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.EnhancedTextDocument;
import de.esg.commonclient.dialog.JButtonEx;
import de.esg.commonclient.dialog.LimitedTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.apache.log4j.Logger;
import webetk.WebetkUtils;
import webetk.app.teileinfo.ServiceInfoTable;
import webetk.app.teileinfo.Teileclearing;
import webetk.app.teileinfo.Teileinfo;
import webetk.app.teileliste.Teil;
import webetk.communication.LoginInfo;
import webetk.javaclient.communication.asap.AsapAppletComCtrl;
import webetk.javaclient.dialog.AbstractDlgMitTLView;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.SachnummerField;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.extras.teileinfo.DlgReifenLabelPanel;
import webetk.javaclient.dialog.extras.teileinfo.DlgTechnischeInfoPanel;
import webetk.javaclient.dialog.extras.teileinfo.DlgTeileinfoController;
import webetk.javaclient.dialog.extras.teileinfo.DlgTeileinfoModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.javaclient.menuitem.MenuItemEinzelteile;
import webetk.javaclient.menuitem.MenuItemInterpretation;
import webetk.javaclient.menuitem.MenuItemTeileverwendungTeil;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class DlgTeileinfoView
extends AbstractDlgMitTLView {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(DlgTeileinfoView.class);
    protected DlgTeileinfoModel mModel;
    protected DlgTeileinfoController moController;
    protected JPanel mHeaderPanel;
    protected LimitedTextField mTfHgUg;
    protected SachnummerField mTfSachnummer;
    protected JButtonEx mButtonSuchenTeilenummer;
    protected JTextField mTeilenummerFremdeTN;
    protected JButtonEx mButtonSuchenAlternativ;
    protected Color mTextColor = new Color(14, 8, 104);
    protected Font mDescFont;
    protected Font mLabelFont;
    protected ArrayList<JComponent> mMenuArray = new ArrayList();
    protected JCheckBox mChkLokalteil;
    protected JLabel mTfTeilenummer;
    protected JLabel mTfBenennung;
    protected JLabel mTfBenennungskommentar;
    protected JLabel mTfZusatz;
    protected JTabbedPane mTabbedPane;
    protected JLabel mTfHaendlerpreis;
    protected JLabel mTfMWSt;
    protected JLabel mTfATSteuer;
    protected JLabel mTfGesamtpreis;
    protected JLabel mTfUPE;
    protected JLabel mTfRabattcode;
    protected JLabel mTfPreisaenderKZ;
    protected JLabel mTfSonderpreisKZ;
    protected JLabel mTfSonderpreis;
    protected JLabel mTfNettopreis;
    protected JLabel mTfPfandpauschale;
    protected JLabel mTfZolltarifnummer;
    protected JLabel mTfLagerort;
    protected JLabel mTfLagerbestand;
    protected JLabel mTfMinimalbestand;
    protected JPanel mPanelFilialInfo;
    protected DlgTechnischeInfoPanel mPanelTechnischeInfo = new DlgTechnischeInfoPanel();
    protected DlgReifenLabelPanel mPanelReifenInfo = new DlgReifenLabelPanel();
    protected JTextArea mTaZusatzinfo;
    protected JTextArea mTaReachinfo;
    protected JTextArea mTaZusatzinfoTCLand;
    protected JTextArea mTaZusatzinfoTCBaureiheMotor;
    protected JTextArea mTaZusatzinfoTCDatum;
    protected JPanel mPanelServiceinfo;
    protected JTextArea mTaNotiz;
    protected JTextArea mTaNotizOthers;
    protected JComboBox mCbMonate;
    protected JComboBox mCbJahre;
    protected JCheckBox mChkAllgemein;
    protected JButtonEx mButtonSpeichern;
    protected JButtonEx mButtonLoeschen;
    protected static final int TAB_TEILEINFO_IND = 0;
    protected static final int TAB_KOMINFO_IND = 1;
    protected static final int TAB_FILIALEN_IND = 2;
    protected static final int TAB_EU_LABEL_IND = 3;
    protected static final int TAB_ANZAHL = 4;
    protected static final int TAB_KOMINFO_LOK_IND = 0;
    protected static final int TAB_FILIALEN_LOK_IND = 1;
    protected static final int TAB_EU_LABEL_LOK_IND = 2;
    protected static final int TAB_ANZAHL_LOK = 3;
    protected JMenuItem mMenuItemTeileverwendung;
    protected JMenuItem mMenuItemInterpretation;
    protected JMenuItem mMenuItemEinzelteile;
    protected JMenuItem mMenuItemStammsatz;

    public DlgTeileinfoView() {
        log.debug((Object)"DlgTeileinfoView()");
    }

    @Override
    public void initMenus() {
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.mHeaderPanel = new HeaderPanel(Resource.getInstance().getTeileinformation(), ImageCache.getInstance().getHeaderIcon("teileinfo"));
        this.mChkLokalteil = new JCheckBox(Resource.getInstance().getLokalesTeil(), false);
        this.mTfHgUg = new LimitedTextField(4);
        Document doc = this.mTfHgUg.getDocument();
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent ev) {
                Document doc = ev.getDocument();
                if (doc.getLength() >= 4) {
                    DlgTeileinfoView.this.mTfSachnummer.requestFocus();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
            }

            @Override
            public void changedUpdate(DocumentEvent ev) {
            }
        });
        this.mTfSachnummer = new SachnummerField(false);
        this.mTeilenummerFremdeTN = new JTextField(35);
        EnhancedTextDocument ehDoc = new EnhancedTextDocument(35, 0);
        this.mTeilenummerFremdeTN.setDocument(ehDoc);
        this.buttonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeileinfoView.this.moController.handleUebernehmen(DlgTeileinfoView.this.comboTeileliste.getSelectedIndex());
                DlgTeileinfoView.this.update();
            }
        });
        this.layoutAll();
    }

    protected JPanel layoutSuchen() {
        TitledPanel suchenPanel = new TitledPanel(Resource.getInstance().getTeileinformationSuchen());
        int[] w = new int[]{10, 0, 30, 0, 10};
        int[] h = new int[]{0, 0, 10, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(2, 1);
        HIGConstraints c = new HIGConstraints();
        suchenPanel.setLayout(l);
        Border internalBorder = UIHelper.getLightBorder();
        ImageIcon sicon = ImageCache.getInstance().getIcon("search.gif");
        TitledPanel s1 = new TitledPanel(Resource.getInstance().getTeilenummer(), internalBorder);
        int[] w1 = new int[]{10, 0, 5, 0, 10, 0, 10};
        int[] h1 = new int[]{0, 0, 0, 0};
        HIGLayout l1 = new HIGLayout(w1, h1);
        s1.setLayout(l1);
        s1.add((Component)this.mChkLokalteil, c.rcwh(1, 2, 3, 1, "tl"));
        s1.add((Component)new JLabel(Resource.getInstance().getHgug()), c.rc(2, 2, "tl"));
        s1.add((Component)this.mTfHgUg, c.rc(3, 2, "l"));
        s1.add((Component)new JLabel("12 34"), c.rc(4, 2, "lt"));
        s1.add((Component)new JLabel(Resource.getInstance().getSachnummer()), c.rc(2, 4, "tl"));
        s1.add((Component)this.mTfSachnummer, c.rc(3, 4, "l"));
        s1.add((Component)new JLabel("1 234 567"), c.rc(4, 4, "lt"));
        this.mButtonSuchenTeilenummer = new JButtonEx(Resource.getInstance().getSuchen(), sicon);
        this.mButtonSuchenTeilenummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeileinfoView.this.moController.handleSuchen(DlgTeileinfoView.this.mTfHgUg.getText(), DlgTeileinfoView.this.mTfSachnummer.getText().toUpperCase(), DlgTeileinfoView.this.mChkLokalteil.isSelected(), DlgTeileinfoView.this.mTfSachnummer);
            }
        });
        this.mTfSachnummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeileinfoView.this.moController.handleSuchen(DlgTeileinfoView.this.mTfHgUg.getText(), DlgTeileinfoView.this.mTfSachnummer.getText().toUpperCase(), DlgTeileinfoView.this.mChkLokalteil.isSelected(), DlgTeileinfoView.this.mTfSachnummer);
            }
        });
        s1.add((Component)this.mButtonSuchenTeilenummer, c.rcwh(2, 6, 1, 3, "l"));
        TitledPanel s2 = new TitledPanel(Resource.getInstance().getAlternativ(), internalBorder);
        int[] w2 = new int[]{10, 0, 10, 0, 10};
        Font font = UIHelper.getNormalFont();
        int hz1 = font.getSize() + 8;
        int[] h2 = new int[]{hz1, 0, 0, 0};
        HIGLayout l2 = new HIGLayout(w2, h2);
        s2.setLayout(l2);
        s2.add((Component)new JLabel(Resource.getInstance().getFremdeTeilenummer()), c.rc(2, 2, "tlr"));
        s2.add((Component)this.mTeilenummerFremdeTN, c.rc(4, 2, "l"));
        this.mButtonSuchenAlternativ = new JButtonEx(Resource.getInstance().getSuchen(), sicon);
        this.mButtonSuchenAlternativ = new JButtonEx(Resource.getInstance().getSuchen(), sicon);
        this.mButtonSuchenAlternativ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeileinfoView.this.moController.handleSuchenFremdeTnr(DlgTeileinfoView.this.mTeilenummerFremdeTN.getText(), DlgTeileinfoView.this.mTeilenummerFremdeTN);
                if (DlgTeileinfoView.this.mModel.getTeileinfo().getSachnummer().length() > 0) {
                    DlgTeileinfoView.this.mTeilenummerFremdeTN.setText("");
                    DlgTeileinfoView.this.mChkLokalteil.setSelected(false);
                }
            }
        });
        this.mTeilenummerFremdeTN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeileinfoView.this.mChkLokalteil.setSelected(false);
                DlgTeileinfoView.this.moController.handleSuchenFremdeTnr(DlgTeileinfoView.this.mTeilenummerFremdeTN.getText(), DlgTeileinfoView.this.mTeilenummerFremdeTN);
                if (DlgTeileinfoView.this.mModel.getTeileinfo().getSachnummer().length() > 0) {
                    DlgTeileinfoView.this.mTeilenummerFremdeTN.setText("");
                    DlgTeileinfoView.this.mChkLokalteil.setSelected(false);
                }
            }
        });
        s2.add((Component)this.mButtonSuchenAlternativ, c.rc(4, 4, "l"));
        suchenPanel.add((Component)s1, c.rc(2, 2, "tlbr"));
        suchenPanel.add((Component)s2, c.rc(2, 4, "tlbr"));
        return suchenPanel;
    }

    protected JLabel createLabel(String s) {
        JLabel l = new JLabel(s);
        l.setFont(this.mLabelFont);
        l.setForeground(Color.black);
        return l;
    }

    protected JLabel createValue(String s) {
        JLabel l = new JLabel(s);
        l.setFont(this.mDescFont);
        l.setForeground(this.mTextColor);
        return l;
    }

    protected String getValue(String sValue) {
        if (sValue == null || sValue.trim().length() < 1) {
            return "-";
        }
        return sValue;
    }

    protected JPanel layoutDetails() {
        TitledPanel p = new TitledPanel(Resource.getInstance().getDetails());
        int[] w = new int[]{10, 0, 5, 0, 30, 0, 30, 0, 10};
        int[] h = new int[]{0, 10, 0, 0, 0, 0, 5, 0, 5};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(w.length - 1, 1);
        HIGConstraints c = new HIGConstraints();
        p.setLayout(l);
        int col = 2;
        int row = 1;
        p.add((Component)this.createLabel(Resource.getInstance().getInTeileliste()), c.rc(row, col, "l"));
        p.add((Component)this.comboTeileliste, c.rc(row, col + 2));
        p.add((Component)this.buttonUebernehmen, c.rc(row, col + 4, "l"));
        p.add((Component)this.buttonUeberpruefen, c.rc(row, col + 6, "l"));
        col = 2;
        row = 3;
        p.add((Component)this.createLabel(Resource.getInstance().getTeilenummer() + ":"), c.rc(row, col));
        this.mTfTeilenummer = this.createValue("");
        p.add((Component)this.mTfTeilenummer, c.rc(row++, col + 2));
        p.add((Component)this.createLabel(Resource.getInstance().getBenennung() + ":"), c.rc(row, col));
        this.mTfBenennung = this.createValue("");
        p.add((Component)this.mTfBenennung, c.rc(row++, col + 2));
        p.add((Component)this.createLabel(Resource.getInstance().getBenennungskommentar() + ":"), c.rc(row, col));
        this.mTfBenennungskommentar = this.createValue("");
        p.add((Component)this.mTfBenennungskommentar, c.rc(row++, col + 2));
        p.add((Component)this.createLabel(Resource.getInstance().getZusatz() + ":"), c.rc(row, col));
        this.mTfZusatz = this.createValue("");
        p.add((Component)this.mTfZusatz, c.rc(row++, col + 2));
        this.mTabbedPane = new JTabbedPane();
        this.mTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                JTabbedPane oTab = (JTabbedPane)ev.getSource();
                int nSelInd = oTab.getSelectedIndex();
                boolean bIsTabFilialInfo = DlgTeileinfoView.this.mModel.getFilialinfoAnzeigen();
                boolean bIsEuReifenLabel = DlgTeileinfoView.this.mModel.isEuReifenLabelAnzeigen();
                if (!DlgTeileinfoView.this.mModel.getLokalteil()) {
                    if (!bIsTabFilialInfo && bIsEuReifenLabel && nSelInd == 2) {
                        ++nSelInd;
                    }
                    switch (nSelInd) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            DlgTeileinfoView.this.moController.loadFilialinfo();
                            DlgTeileinfoView.this.updateFilialinfo();
                            break;
                        }
                    }
                } else {
                    if (!bIsTabFilialInfo && bIsEuReifenLabel && nSelInd == 1) {
                        ++nSelInd;
                    }
                    switch (nSelInd) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            DlgTeileinfoView.this.moController.loadFilialinfo();
                            DlgTeileinfoView.this.updateFilialinfo();
                            break;
                        }
                    }
                }
            }
        });
        this.mTabbedPane.add(Resource.getInstance().getTechnischeinfo(), this.mPanelTechnischeInfo);
        this.mTabbedPane.add(Resource.getInstance().getKommerzielleInfo(), this.layoutKommerzielleInfo());
        if (this.moController.ermittleKommerzielleInfoInitialSelektiert()) {
            this.mTabbedPane.setSelectedIndex(1);
        }
        p.add((Component)this.mTabbedPane, c.rcwh(8, 2, 7, 1, "tlbr"));
        if (this.mModel.getDMSVerwenden() && this.mModel.getFilialinfoAnzeigen()) {
            this.mPanelFilialInfo = new JPanel();
            this.mPanelFilialInfo.setBackground(UIHelper.getBrighterBackground());
            this.mPanelFilialInfo.setLayout(new GridBagLayout());
            this.mTabbedPane.add(Resource.getInstance().getBestandFilialen(), this.mPanelFilialInfo);
        }
        if (this.mModel.isEuReifenLabelAnzeigen()) {
            this.mPanelReifenInfo.setModel(this.mModel);
            this.mPanelReifenInfo.setVisible(true);
            this.mTabbedPane.add(Resource.getInstance().getEUReifenLabel(), this.mPanelReifenInfo);
        } else {
            this.mPanelReifenInfo.setVisible(false);
        }
        return p;
    }

    protected JPanel layoutKommerzielleInfo() {
        JPanel panelKommerzielleInfo = new JPanel();
        panelKommerzielleInfo.setBackground(UIHelper.getBrighterBackground());
        int[] kommerzielleInfo_w = new int[]{10, 0, 5, 0, 90, 0, 5, 0, 90, 0, 5, 0, 10};
        int[] kommerzielleInfo_h = new int[]{20, 0, 0, 0, 0, 0, 0, 0, 0, 10};
        HIGLayout kommerzielleInfo_layout = new HIGLayout(kommerzielleInfo_w, kommerzielleInfo_h);
        HIGConstraints c = new HIGConstraints();
        panelKommerzielleInfo.setLayout(kommerzielleInfo_layout);
        int col = 2;
        int row = 2;
        panelKommerzielleInfo.add((Component)this.createLabel(Resource.getInstance().getNueUpe() + ":"), c.rc(row, col));
        this.mTfUPE = new JLabel();
        panelKommerzielleInfo.add((Component)this.mTfUPE, c.rc(row++, col + 2, "r"));
        panelKommerzielleInfo.add((Component)this.createLabel(Resource.getInstance().getHaendlerpreis() + ":"), c.rc(row, col));
        this.mTfHaendlerpreis = new JLabel();
        panelKommerzielleInfo.add((Component)this.mTfHaendlerpreis, c.rc(row++, col + 2, "r"));
        panelKommerzielleInfo.add((Component)this.createLabel(Resource.getInstance().getMwst() + ":"), c.rc(row, col));
        this.mTfMWSt = new JLabel();
        panelKommerzielleInfo.add((Component)this.mTfMWSt, c.rc(row++, col + 2, "r"));
        panelKommerzielleInfo.add((Component)this.createLabel(Resource.getInstance().getAtSteuer() + ":"), c.rc(row, col));
        this.mTfATSteuer = new JLabel();
        panelKommerzielleInfo.add((Component)this.mTfATSteuer, c.rc(row++, col + 2, "r"));
        panelKommerzielleInfo.add((Component)this.createLabel(Resource.getInstance().getGesamtpreis() + ":"), c.rc(row, col));
        this.mTfGesamtpreis = new JLabel();
        panelKommerzielleInfo.add((Component)this.mTfGesamtpreis, c.rc(row++, col + 2, "r"));
        col = 6;
        row = 2;
        panelKommerzielleInfo.add((Component)this.createLabel(Resource.getInstance().getKodierungsstufe() + ":"), c.rc(row, col));
        this.mTfRabattcode = new JLabel();
        panelKommerzielleInfo.add((Component)this.mTfRabattcode, c.rc(row++, col + 2));
        panelKommerzielleInfo.add((Component)this.createLabel(Resource.getInstance().getPreisaenderKz() + ":"), c.rc(row, col));
        this.mTfPreisaenderKZ = new JLabel();
        panelKommerzielleInfo.add((Component)this.mTfPreisaenderKZ, c.rc(row++, col + 2));
        panelKommerzielleInfo.add((Component)this.createLabel(Resource.getInstance().getSonderpreisKz() + ":"), c.rc(row, col));
        this.mTfSonderpreisKZ = new JLabel();
        panelKommerzielleInfo.add((Component)this.mTfSonderpreisKZ, c.rc(row++, col + 2));
        this.mTfSonderpreis = new JLabel();
        this.mTfNettopreis = new JLabel();
        if (GlobalObjects.getInstance().getSessionInfo().hatRecht("R_WEBETK_PREISE_ANZEIGEN") && GlobalObjects.getInstance().getSessionInfo().getSettings().getDisplayPreise() != null && GlobalObjects.getInstance().getSessionInfo().getSettings().getDisplayPreise().booleanValue()) {
            panelKommerzielleInfo.add((Component)this.createLabel(Resource.getInstance().getSonderpreis() + ":"), c.rc(row, col));
            this.mTfSonderpreis = new JLabel();
            panelKommerzielleInfo.add((Component)this.mTfSonderpreis, c.rc(row++, col + 2, "r"));
            panelKommerzielleInfo.add((Component)this.createLabel(Resource.getInstance().getNettopreis() + ":"), c.rc(row, col));
            panelKommerzielleInfo.add((Component)this.mTfNettopreis, c.rc(row++, col + 2, "r"));
        }
        col = 10;
        row = 2;
        panelKommerzielleInfo.add((Component)this.createLabel(Resource.getInstance().getPfandpauschale() + ":"), c.rc(row, col));
        this.mTfPfandpauschale = new JLabel();
        panelKommerzielleInfo.add((Component)this.mTfPfandpauschale, c.rc(row++, col + 2));
        panelKommerzielleInfo.add((Component)this.createLabel(Resource.getInstance().getZolltarifnummer() + ":"), c.rc(row, col));
        this.mTfZolltarifnummer = new JLabel();
        panelKommerzielleInfo.add((Component)this.mTfZolltarifnummer, c.rc(row++, col + 2));
        panelKommerzielleInfo.add((Component)this.createLabel(Resource.getInstance().getLagerort() + ":"), c.rc(++row, col));
        this.mTfLagerort = new JLabel();
        panelKommerzielleInfo.add((Component)this.mTfLagerort, c.rc(row++, col + 2));
        panelKommerzielleInfo.add((Component)this.createLabel(Resource.getInstance().getLagerbestand() + ":"), c.rc(row, col));
        this.mTfLagerbestand = new JLabel();
        panelKommerzielleInfo.add((Component)this.mTfLagerbestand, c.rc(row++, col + 2));
        panelKommerzielleInfo.add((Component)this.createLabel(Resource.getInstance().getMinimalbestand() + ":"), c.rc(row, col));
        this.mTfMinimalbestand = new JLabel();
        panelKommerzielleInfo.add((Component)this.mTfMinimalbestand, c.rc(row++, col + 2));
        return panelKommerzielleInfo;
    }

    protected JComponent zusatzInfoPanel() {
        JPanel p = new JPanel();
        int[] w1 = new int[]{0, 5, 0, 5, 0};
        int[] h1 = new int[]{0, 0};
        HIGLayout l = new HIGLayout(w1, h1);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(2, 1);
        l.setColumnWeight(3, 2);
        l.setColumnWeight(5, 1);
        p.setLayout(l);
        this.mTaZusatzinfo = this.createTextAreaZI(false, false);
        this.mTaZusatzinfoTCLand = this.createTextAreaZI(false, false);
        this.mTaZusatzinfoTCBaureiheMotor = this.createTextAreaZI(false, false);
        this.mTaZusatzinfoTCDatum = this.createTextAreaZI(false, false);
        p.add((Component)this.mTaZusatzinfo, c.rc(1, 1, "tlr"));
        p.add((Component)this.mTaZusatzinfoTCLand, c.rc(2, 1, "tlr"));
        p.add((Component)this.mTaZusatzinfoTCBaureiheMotor, c.rc(2, 3, "tlr"));
        p.add((Component)this.mTaZusatzinfoTCDatum, c.rc(2, 5, "tlr"));
        this.mTaZusatzinfo.setFont(new Font("monospaced", 0, 12));
        this.mTaZusatzinfoTCLand.setFont(new Font("monospaced", 0, 12));
        this.mTaZusatzinfoTCBaureiheMotor.setFont(new Font("monospaced", 0, 12));
        this.mTaZusatzinfoTCDatum.setFont(new Font("monospaced", 0, 12));
        JScrollPane sc = new JScrollPane(p);
        sc.setPreferredSize(new Dimension(50, 100));
        this.mTaZusatzinfo.setCaretPosition(0);
        sc.setBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 2), UIHelper.getStandardBorder()));
        return sc;
    }

    protected JComponent serviceInfoPanel() {
        this.mPanelServiceinfo = new JPanel();
        this.updateServiceInfo();
        JScrollPane sc = new JScrollPane(this.mPanelServiceinfo);
        sc.setBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 2), UIHelper.getStandardBorder()));
        return sc;
    }

    protected void updateServiceInfo() {
        Teileinfo oTI = this.mModel.getTeileinfo();
        Collection<ServiceInfoTable> cSILi = null;
        Collection<ServiceInfoTable> cSIRe = null;
        if (oTI != null) {
            cSILi = oTI.getServiceInfoLinks();
            cSIRe = oTI.getServiceInfoRechts();
        }
        this.mPanelServiceinfo.removeAll();
        int[] w = new int[]{10, 0, 15, 0, 10};
        int nHoehe = 0;
        if (cSILi != null) {
            nHoehe = cSILi.size();
        }
        int[] h = new int[nHoehe + 2];
        h[nHoehe + 1] = 10;
        h[0] = 10;
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(5, 1);
        l.setRowWeight(nHoehe + 1, 1);
        HIGConstraints c = new HIGConstraints();
        this.mPanelServiceinfo.setLayout(l);
        if (oTI != null) {
            String sSachnummer = oTI.getSachnummer();
            int startRow = 2;
            if (cSILi != null) {
                Iterator<ServiceInfoTable> iLi = cSILi.iterator();
                Iterator<ServiceInfoTable> iRe = null;
                if (cSIRe != null) {
                    iRe = cSIRe.iterator();
                }
                for (int y = 0; y < nHoehe; ++y) {
                    JLabel label;
                    String sDokNr;
                    String sDokArt;
                    ServiceInfoTable oSI;
                    if (iLi.hasNext()) {
                        oSI = iLi.next();
                        sDokArt = oSI.get("DokArt");
                        sDokNr = oSI.get("DokNr");
                        label = this.createValue(sDokArt + " " + sDokNr);
                        this.initASAPLabel(sDokArt, label, sSachnummer, sDokNr);
                        this.mPanelServiceinfo.add((Component)label, c.rc(2 + y, 2, "tl"));
                    }
                    if (iRe == null || !iRe.hasNext()) continue;
                    oSI = iRe.next();
                    sDokArt = oSI.get("DokArt");
                    sDokNr = oSI.get("DokNr");
                    label = this.createValue(sDokArt + " " + sDokNr);
                    this.initASAPLabel(sDokArt, label, sSachnummer, sDokNr);
                    this.mPanelServiceinfo.add((Component)label, c.rc(2 + y, 4, "tl"));
                }
            }
        }
        this.mPanelServiceinfo.invalidate();
        this.mPanelServiceinfo.revalidate();
        this.mPanelServiceinfo.repaint();
    }

    protected JPanel layoutZusatzInformationen() {
        TitledPanel zusatzInformationen = new TitledPanel(Resource.getInstance().getZusatzinformation() + " ");
        int[] zusatzInformationen_w = new int[]{-2, -1};
        int[] zusatzInformationen_h = new int[]{0};
        HIGLayout zusatzInformationen_layout = new HIGLayout(zusatzInformationen_w, zusatzInformationen_h);
        HIGConstraints c = new HIGConstraints();
        zusatzInformationen_layout.setColumnWeight(1, 3);
        zusatzInformationen_layout.setColumnWeight(2, 2);
        zusatzInformationen_layout.setRowWeight(1, 1);
        zusatzInformationen.setLayout(zusatzInformationen_layout);
        JComponent zusatz = this.zusatzInfoPanel();
        zusatz.setAutoscrolls(true);
        zusatzInformationen.add((Component)zusatz, c.rc(1, 1, "tlbr"));
        JComponent service = this.serviceInfoPanel();
        zusatzInformationen.add((Component)service, c.rc(1, 2, "tlbr"));
        return zusatzInformationen;
    }

    protected JPanel layoutNotiz() {
        TitledPanel p = new TitledPanel(Resource.getInstance().getNotiz());
        int[] w1 = new int[]{0, -2, 0, -4};
        int[] h1 = new int[]{0, 0, 5};
        HIGLayout l = new HIGLayout(w1, h1);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(2, 1);
        l.setColumnWeight(4, 1);
        p.setLayout(l);
        JPanel pNotizEigen = this.layoutNotizEigen();
        p.add((Component)pNotizEigen, c.rc(2, 2, "lt"));
        int nHeight = pNotizEigen.getPreferredSize().height;
        int nWidth = pNotizEigen.getPreferredSize().width;
        JPanel pNotizOthers = this.layoutNotizOthers(new Dimension(nWidth, nHeight));
        p.add((Component)pNotizOthers, c.rc(2, 4, "lt"));
        return p;
    }

    protected JPanel layoutNotizEigen() {
        TitledPanel p = new TitledPanel(Resource.getInstance().getEigeneNotiz() + ":");
        int[] w1 = new int[]{5, 0, 10, -6, 10, -4, 5};
        int[] h1 = new int[]{0, 0, 5, 0, 2, 0, 10, 0, 5};
        HIGLayout l = new HIGLayout(w1, h1);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(2, 1);
        p.setLayout(l);
        this.mTaNotiz = new JTextArea();
        this.mTaNotiz.setLineWrap(true);
        this.mTaNotiz.setWrapStyleWord(true);
        this.mTaNotiz.setFont(this.mLabelFont);
        this.mTaNotiz.setForeground(Color.black);
        EnhancedTextDocument ehDoc = new EnhancedTextDocument(1958, 0, 1958);
        this.mTaNotiz.setDocument(ehDoc);
        JScrollPane sc = new JScrollPane(this.mTaNotiz);
        sc.setPreferredSize(new Dimension(209, 100));
        p.add((Component)sc, c.rcwh(2, 2, 1, 7, "tlrb"));
        this.mChkAllgemein = new JCheckBox(Resource.getInstance().getAllgemein(), false);
        p.add((Component)this.mChkAllgemein, c.rc(2, 4, "lb"));
        JLabel g\u00fcltig = new JLabel(Resource.getInstance().getGueltigBis() + ":");
        p.add((Component)g\u00fcltig, c.rcwh(4, 4, 3, 1, "tl"));
        this.mCbMonate = new JComboBox();
        Collection<String> cMonate = this.mModel.getMonateNamen();
        if (cMonate != null) {
            Iterator<String> iter = cMonate.iterator();
            while (iter.hasNext()) {
                this.mCbMonate.addItem(iter.next());
            }
        }
        p.add((Component)this.mCbMonate, c.rc(6, 4, "tlr"));
        Collection<String> cJahre = this.mModel.getJahreNamen();
        this.mCbJahre = new JComboBox();
        if (cJahre != null) {
            Iterator<String> iter = cJahre.iterator();
            while (iter.hasNext()) {
                this.mCbJahre.addItem(iter.next());
            }
        }
        this.mCbJahre.setPreferredSize(new Dimension(60, this.mCbJahre.getPreferredSize().height));
        p.add((Component)this.mCbJahre, c.rc(6, 6, "tl"));
        this.mButtonSpeichern = new JButtonEx(Resource.getInstance().getSpeichern(), ImageCache.getInstance().getIcon("save.gif"));
        this.mButtonSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sText = DlgTeileinfoView.this.mTaNotiz.getText();
                String sJahrName = (String)DlgTeileinfoView.this.mCbJahre.getSelectedItem();
                String sJahr = DlgTeileinfoView.this.mModel.getJahrIDZuName(sJahrName);
                String sMonatName = (String)DlgTeileinfoView.this.mCbMonate.getSelectedItem();
                String sMonat = DlgTeileinfoView.this.mModel.getMonatIDZuName(sMonatName);
                boolean bAllgemein = DlgTeileinfoView.this.mChkAllgemein.isSelected();
                DlgTeileinfoView.this.moController.handleNotizSpeichern(sText, bAllgemein, sJahr, sMonat);
            }
        });
        this.mButtonLoeschen = new JButtonEx(Resource.getInstance().getLoeschen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.mButtonLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeileinfoView.this.moController.handleNotizLoeschen();
                DlgTeileinfoView.this.update();
            }
        });
        p.add((Component)this.mButtonLoeschen, c.rc(8, 4, "bl"));
        p.add((Component)this.mButtonSpeichern, c.rc(8, 6, "bl"));
        return p;
    }

    protected JPanel layoutNotizOthers(Dimension dim) {
        TitledPanel p = new TitledPanel(Resource.getInstance().getAlleNotizen() + ":");
        p.setPreferredSize(dim);
        int[] w1 = new int[]{5, dim.width - 40, 5};
        int[] h1 = new int[]{5, dim.height - 40, 5};
        HIGLayout l = new HIGLayout(w1, h1);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(2, 1);
        p.setLayout(l);
        this.mTaNotizOthers = new JTextArea();
        this.mTaNotizOthers.setBackground(this.getBackground());
        this.mTaNotizOthers.setEditable(false);
        this.mTaNotizOthers.setLineWrap(true);
        this.mTaNotizOthers.setWrapStyleWord(true);
        this.mTaNotizOthers.setFont(this.mDescFont);
        this.mTaNotizOthers.setForeground(Color.black);
        this.mTaNotizOthers.setEnabled(false);
        this.mTaNotizOthers.setDisabledTextColor(Color.black);
        JScrollPane scOthers = new JScrollPane(this.mTaNotizOthers);
        scOthers.setBorder(null);
        p.add((Component)scOthers, c.rc(2, 2, "tlrb"));
        return p;
    }

    protected void updateNotiz() {
        Teileinfo oTI = this.mModel.getTeileinfo();
        if (oTI == null) {
            return;
        }
        String sNotiz = oTI.getNotizText();
        this.mTaNotiz.setText(sNotiz);
        this.mTaNotiz.setCaretPosition(0);
        String sMonat = oTI.getNotizBisMonatAlsString();
        String sMonatName = this.mModel.getMonatNameZuID(sMonat);
        if (sMonatName == null) {
            sMonatName = "";
        }
        this.mCbMonate.setSelectedItem(sMonatName);
        this.mChkAllgemein.setSelected(oTI.getNotizAllgemein());
        String sJahr = oTI.getNotizBisJahrAlsString();
        String sJahrName = this.mModel.getJahrNameZuID(sJahr);
        if (sJahrName == null) {
            sJahrName = "";
        }
        this.mCbJahre.setSelectedItem(sJahrName);
        String sNotizenOthers = "";
        Collection<String> cNotizen = oTI.getNotizTexteOthers();
        Collection<String> cNotizenGueltigBis = oTI.getNotizTexteOthersGueltigBis();
        if (cNotizen != null && cNotizenGueltigBis != null) {
            Iterator<String> iter = cNotizen.iterator();
            Iterator<String> iter2 = cNotizenGueltigBis.iterator();
            while (iter.hasNext() && iter2.hasNext()) {
                if (sNotizenOthers.length() > 0) {
                    sNotizenOthers = sNotizenOthers + "\n\n";
                }
                sNotizenOthers = sNotizenOthers + Resource.getInstance().getGueltigBis() + " " + iter2.next() + ":\n";
                sNotizenOthers = sNotizenOthers + iter.next();
            }
        }
        this.mTaNotizOthers.setText(sNotizenOthers);
        this.mTaNotizOthers.setCaretPosition(0);
    }

    protected void layoutAll() {
        JPanel panel = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        panel.setLayout(l);
        panel.add((Component)this.mHeaderPanel, c.rc(1, 1, "tlbr"));
        JPanel suche = this.layoutSuchen();
        panel.add((Component)suche, c.rc(2, 1, "tlbr"));
        JPanel info = this.layoutDetails();
        panel.add((Component)info, c.rc(3, 1, "tlbr"));
        panel.add((Component)this.layoutZusatzInformationen(), c.rc(4, 1, "tlbr"));
        JPanel pNotiz = this.layoutNotiz();
        panel.add((Component)pNotiz, c.rc(5, 1, "tlbr"));
        JScrollPane sc = new JScrollPane(panel);
        this.setLayout(new BorderLayout());
        this.add(sc);
    }

    @Override
    public Iterator<JComponent> getMenus() {
        return this.mMenuArray.iterator();
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oController) {
        super.init(oDlgModel, oController);
        this.mLabelFont = UIHelper.getNormalFont();
        this.mDescFont = UIHelper.getNormalFont();
        this.mModel = (DlgTeileinfoModel)oDlgModel;
        this.moController = (DlgTeileinfoController)oController;
        this.initComponents();
        this.createMenues();
        this.update();
    }

    protected void createMenues() {
        JMenu menu = new JMenu(Resource.getInstance().getTeileinformation());
        menu.setBackground(UIHelper.getDarkerBackground());
        this.mMenuItemTeileverwendung = new MenuItemTeileverwendungTeil("teileinfo", this.moController, this.mModel, this);
        menu.add(this.mMenuItemTeileverwendung);
        this.mMenuItemInterpretation = new MenuItemInterpretation("teileinfo", this.moController, this.mModel, this);
        menu.add(this.mMenuItemInterpretation);
        this.mMenuItemEinzelteile = new MenuItemEinzelteile("teileinfo", this.moController, this.mModel, this);
        menu.add(this.mMenuItemEinzelteile);
        LoginInfo loginInfo = GlobalObjects.getInstance().getSessionInfo();
        if (this.mModel.getDMSVerwenden() && loginInfo.hatRecht("R_WEBETK_STAMMSATZ")) {
            menu.addSeparator();
            this.mMenuItemStammsatz = this.createMenuItemStammsatz(Resource.getInstance().getAnlageStammsatz());
            menu.add(this.mMenuItemStammsatz);
        }
        this.mMenuArray.add(menu);
    }

    private JMenuItem createMenuItemStammsatz(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){
            private static final long serialVersionUID = 4902118128774756467L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTeileinfoView.this.moController.handleStammsatz();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    @Override
    public void update() {
        Teileinfo oTI = this.mModel.getTeileinfo();
        if (this.mModel.isEuReifenLabelAnzeigen()) {
            this.addReifeninfoTab();
        } else {
            this.removeReifeninfoTab();
        }
        if (oTI == null || oTI.getSachnummer().length() < 1) {
            this.mbSuppressComboActionListener = true;
            this.comboTeileliste.removeAllItems();
            this.mbSuppressComboActionListener = false;
            this.mTfTeilenummer.setText("-");
            this.mTfBenennung.setText("-");
            this.mTfBenennungskommentar.setText("-");
            this.mTfZusatz.setText("-");
            this.mPanelTechnischeInfo.setInfo(oTI);
            this.mTaZusatzinfo.setText("");
            this.mTaZusatzinfoTCLand.setText("");
            this.mTaZusatzinfoTCBaureiheMotor.setText("");
            this.mTaZusatzinfoTCDatum.setText("");
            this.updateServiceInfo();
            this.mTaNotiz.setText("");
            this.mMenuItemTeileverwendung.setEnabled(false);
            this.mMenuItemTeileverwendung.repaint();
            this.mMenuItemInterpretation.setEnabled(false);
            this.mMenuItemInterpretation.repaint();
            this.mMenuItemEinzelteile.setEnabled(false);
            this.mMenuItemEinzelteile.repaint();
            if (this.mMenuItemStammsatz != null) {
                this.mMenuItemStammsatz.setEnabled(false);
                this.mMenuItemStammsatz.repaint();
            }
        } else {
            boolean bHatTC;
            this.mTfHgUg.setText(oTI.getHg() + oTI.getUg());
            this.mTfSachnummer.setText(oTI.getSachnummer().toUpperCase());
            this.updateTeilelisten();
            this.mTfTeilenummer.setText(this.getValue(oTI.getTeilenummerGespreizt()));
            this.mTfBenennung.setText(this.getValue(oTI.getBenennung()));
            Teil oKI = this.mModel.getKommerzielleInfo();
            if (oKI != null && oKI.getBenennung() != null && oKI.getBenennung().length() > 0) {
                this.mTfBenennung.setText(oKI.getBenennung());
            }
            this.mTfBenennungskommentar.setText(this.getValue(oTI.getBenennungskommentar()));
            this.mTfZusatz.setText(this.getValue(oTI.getZusatz()));
            if (this.mModel.getLokalteil()) {
                if (this.mModel.getFilialinfoAnzeigen() && this.mModel.isEuReifenLabelAnzeigen() && this.mTabbedPane.getTabCount() == 4 || !this.mModel.getFilialinfoAnzeigen() && this.mModel.isEuReifenLabelAnzeigen() && this.mTabbedPane.getTabCount() == 3 || this.mModel.getFilialinfoAnzeigen() && !this.mModel.isEuReifenLabelAnzeigen() && this.mTabbedPane.getTabCount() == 3 || !this.mModel.getFilialinfoAnzeigen() && !this.mModel.isEuReifenLabelAnzeigen() && this.mTabbedPane.getTabCount() == 2) {
                    int nSelIndex = this.mTabbedPane.getSelectedIndex();
                    if (nSelIndex > 0) {
                        --nSelIndex;
                    }
                    this.mTabbedPane.setSelectedIndex(nSelIndex);
                    this.mTabbedPane.remove(0);
                }
            } else if (this.mModel.getFilialinfoAnzeigen() && this.mModel.isEuReifenLabelAnzeigen() && this.mTabbedPane.getTabCount() == 3 || !this.mModel.getFilialinfoAnzeigen() && this.mModel.isEuReifenLabelAnzeigen() && this.mTabbedPane.getTabCount() == 2 || this.mModel.getFilialinfoAnzeigen() && !this.mModel.isEuReifenLabelAnzeigen() && this.mTabbedPane.getTabCount() == 2 || !this.mModel.getFilialinfoAnzeigen() && !this.mModel.isEuReifenLabelAnzeigen() && this.mTabbedPane.getTabCount() == 1) {
                this.mTabbedPane.add((Component)this.mPanelTechnischeInfo, 0);
                this.mTabbedPane.setTitleAt(0, Resource.getInstance().getTechnischeinfo());
                this.mTabbedPane.setSelectedIndex(this.mTabbedPane.getSelectedIndex() + 1);
            }
            this.mPanelTechnischeInfo.setInfo(oTI);
            this.mTaZusatzinfo.setText("");
            this.mTaZusatzinfoTCLand.setText("");
            this.mTaZusatzinfoTCBaureiheMotor.setText("");
            this.mTaZusatzinfoTCDatum.setText("");
            String szZusatzinfo = "";
            if (oTI.getReachInformationList() != null && oTI.getReachInformationList().size() > 0) {
                int i;
                int lengthCheckForCASNrHeader;
                ArrayList<String> listCASNr = new ArrayList<String>();
                ArrayList<String> listCASName = new ArrayList<String>();
                ArrayList<String> listSubKomponent = new ArrayList<String>();
                for (int i2 = 1; i2 <= oTI.getReachInformationList().size(); ++i2) {
                    listCASNr.add(oTI.getReachInformationHashMap().get("casNr" + i2));
                    listCASName.add(oTI.getReachInformationHashMap().get("casName" + i2));
                    listSubKomponent.add(oTI.getReachInformationHashMap().get("subKomponent" + i2));
                }
                int lengthCheckForCASNameHeader = DlgTeileinfoView.maxValue(listCASName).length() + 2;
                int lengthCheckForSubKomponent = DlgTeileinfoView.maxValue(listSubKomponent).length() + 2;
                int lengthCheckForSpace = lengthCheckForCASNrHeader + lengthCheckForCASNameHeader + lengthCheckForSubKomponent;
                szZusatzinfo = szZusatzinfo + Resource.getInstance().getReachAnfangtext() + "\n\n";
                szZusatzinfo = szZusatzinfo + Resource.getInstance().getCASNr();
                for (lengthCheckForCASNrHeader = DlgTeileinfoView.maxValue(listCASNr).length() + 2; Resource.getInstance().getCASNr().length() < lengthCheckForCASNrHeader; --lengthCheckForCASNrHeader) {
                    szZusatzinfo = szZusatzinfo + " ";
                }
                szZusatzinfo = szZusatzinfo + Resource.getInstance().getCASName();
                while (Resource.getInstance().getCASName().length() < lengthCheckForCASNameHeader) {
                    szZusatzinfo = szZusatzinfo + " ";
                    --lengthCheckForCASNameHeader;
                }
                szZusatzinfo = szZusatzinfo + Resource.getInstance().getSubKomponent() + "\n";
                for (i = 1; i < lengthCheckForSpace; ++i) {
                    szZusatzinfo = szZusatzinfo + "-";
                }
                szZusatzinfo = szZusatzinfo + "\n";
                for (i = 1; i <= oTI.getReachInformationList().size(); ++i) {
                    int lengthCheckForCASNameValue = DlgTeileinfoView.maxValue(listCASName).length() + 2;
                    szZusatzinfo = szZusatzinfo + oTI.getReachInformationHashMap().get("casNr" + i);
                    for (int lengthCheckForCASNrValue = DlgTeileinfoView.maxValue(listCASNr).length() + 2; oTI.getReachInformationHashMap().get("casNr" + i).length() < lengthCheckForCASNrValue; --lengthCheckForCASNrValue) {
                        szZusatzinfo = szZusatzinfo + " ";
                    }
                    szZusatzinfo = szZusatzinfo + oTI.getReachInformationHashMap().get("casName" + i);
                    while (oTI.getReachInformationHashMap().get("casName" + i).length() < lengthCheckForCASNameValue) {
                        szZusatzinfo = szZusatzinfo + " ";
                        --lengthCheckForCASNameValue;
                    }
                    szZusatzinfo = szZusatzinfo + oTI.getReachInformationHashMap().get("subKomponent" + i);
                    szZusatzinfo = szZusatzinfo + "\n";
                }
            }
            if (!oTI.getZusatzinfo().equals("")) {
                szZusatzinfo = szZusatzinfo + "I: " + oTI.getZusatzinfo();
            }
            boolean bl = bHatTC = oTI.getTeileclearingInfo().size() > 0;
            if (bHatTC) {
                String sTCText = "C:" + Resource.getInstance().getTeileclearingText1().toUpperCase() + "\n" + Resource.getInstance().getTeileclearingText2().toUpperCase();
                szZusatzinfo = !szZusatzinfo.equals("") ? szZusatzinfo + "\n" + sTCText : sTCText;
                String sTCLaender = Resource.getInstance().getLand().toUpperCase();
                String sTCBaureiheMotor = Resource.getInstance().getBaureiheMotor().toUpperCase();
                String sTCDatum = Resource.getInstance().getProduktionsdatum().toUpperCase();
                Collection<Teileclearing> cTC = oTI.getTeileclearingInfo();
                for (Teileclearing oTC : cTC) {
                    sTCLaender = sTCLaender + "\n" + oTC.getLand();
                    sTCDatum = sTCDatum + "\n";
                    String sDatum = null;
                    String sDatumVon = oTC.getDatumVon();
                    String sDatumBis = oTC.getDatumBis();
                    sDatum = sDatumVon != null ? Resource.getInstance().getAb().toUpperCase() + " " + sDatumVon : Resource.getInstance().getFortlaufend().toUpperCase();
                    if (sDatumBis != null) {
                        sDatum = sDatum + " " + Resource.getInstance().getBis().toUpperCase() + " " + sDatumBis;
                    }
                    sTCDatum = sTCDatum + sDatum;
                    String sBaureiheMotor = oTC.getBaureihenMotor();
                    if (sBaureiheMotor.equals("ALLE")) {
                        sBaureiheMotor = Resource.getInstance().getAlle().toUpperCase();
                    }
                    while (sBaureiheMotor.length() > 47) {
                        sTCBaureiheMotor = sTCBaureiheMotor + "\n" + sBaureiheMotor.substring(0, 48);
                        sTCLaender = sTCLaender + "\n";
                        sTCDatum = sTCDatum + "\n";
                        sBaureiheMotor = sBaureiheMotor.substring(48);
                    }
                    sTCBaureiheMotor = sTCBaureiheMotor + "\n" + sBaureiheMotor;
                }
                this.mTaZusatzinfoTCLand.setText(sTCLaender);
                this.mTaZusatzinfoTCBaureiheMotor.setText(sTCBaureiheMotor);
                this.mTaZusatzinfoTCDatum.setText(sTCDatum);
            }
            this.mTaZusatzinfo.setText(szZusatzinfo);
            this.mTaZusatzinfo.setCaretPosition(0);
            this.updateServiceInfo();
            this.updateNotiz();
            LoginInfo LoginInfo2 = GlobalObjects.getInstance().getSessionInfo();
            this.mMenuItemTeileverwendung.setEnabled(LoginInfo2.hatRecht("R_WEBETK_TEILEVERWENDUNG_TEIL"));
            this.mMenuItemTeileverwendung.repaint();
            this.mMenuItemInterpretation.setEnabled(LoginInfo2.hatRecht("R_WEBETK_INTERPRETATION") && oTI.getHatInterpretation());
            this.mMenuItemInterpretation.repaint();
            this.mMenuItemEinzelteile.setEnabled(LoginInfo2.hatRecht("R_WEBETK_SATZ_EINZELTEILE") && oTI.getHatEinzelteile());
            this.mMenuItemEinzelteile.repaint();
            if (this.mMenuItemStammsatz != null) {
                this.mMenuItemStammsatz.setEnabled(true);
                this.mMenuItemStammsatz.repaint();
            }
            this.mButtonSpeichern.setEnabled(!this.mModel.getLokalteil());
            this.mButtonLoeschen.setEnabled(!this.mModel.getLokalteil());
            this.mTaNotiz.setEnabled(!this.mModel.getLokalteil());
            this.mCbJahre.setEnabled(!this.mModel.getLokalteil());
            this.mCbMonate.setEnabled(!this.mModel.getLokalteil());
            this.mChkAllgemein.setEnabled(!this.mModel.getLokalteil());
            this.mMenuItemTeileverwendung.setEnabled(!this.mModel.getLokalteil());
            this.mMenuItemInterpretation.setEnabled(!this.mModel.getLokalteil());
            this.mMenuItemEinzelteile.setEnabled(!this.mModel.getLokalteil());
            if (this.mMenuItemStammsatz != null) {
                this.mMenuItemStammsatz.setEnabled(!this.mModel.getLokalteil());
                this.mMenuItemStammsatz.repaint();
            }
        }
        if (this.mModel.getDMSVerwenden() && this.mModel.getFilialinfoAnzeigen()) {
            this.updateFilialinfo();
        }
        this.updateKommerzielleinfo();
        this.buttonUeberpruefen.setEnabled(this.moSelTeileliste != null && this.moSelTeileliste.getID() != null && this.moSelTeileliste.getID().length() > 0 && !this.moSelTeileliste.getID().equals(Resource.getInstance().getNeueListe()));
    }

    protected void updateFilialinfo() {
        int col = 0;
        int row = 1;
        Vector<String> cFilialBez = this.mModel.getFilialBez();
        Vector<String> cFilialBestand = this.mModel.getFilialBestand();
        GridBagConstraints gbc = new GridBagConstraints();
        this.mPanelFilialInfo.removeAll();
        if (cFilialBez != null && cFilialBestand != null) {
            int maxRow;
            gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 0, 0, 0));
            this.mPanelFilialInfo.add(Box.createRigidArea(new Dimension(0, 20)));
            if (cFilialBez.size() <= 20) {
                maxRow = 5;
            } else {
                int ds_gesamt = cFilialBez.size();
                maxRow = ds_gesamt / 4 + 1;
            }
            Iterator iFilialBez = cFilialBez.iterator();
            Iterator iFilialBestand = cFilialBestand.iterator();
            while (iFilialBez.hasNext() && iFilialBestand.hasNext()) {
                gbc = this.setGridBagConstraints(col, row, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 10, 0, 0));
                this.mPanelFilialInfo.add((Component)this.createLabel(Resource.getInstance().getFiliale() + ":"), gbc);
                String sFilialBez = (String)iFilialBez.next();
                gbc = this.setGridBagConstraints(col + 1, row, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 5, 0, 0));
                this.mPanelFilialInfo.add((Component)this.createValue(sFilialBez), gbc);
                gbc = this.setGridBagConstraints(col + 2, row, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 5, 0, 0));
                this.mPanelFilialInfo.add((Component)this.createLabel(Resource.getInstance().getBestand() + ":"), gbc);
                String sFilialBestand = (String)iFilialBestand.next();
                gbc = this.setGridBagConstraints(col + 3, row, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 5, 0, 0));
                this.mPanelFilialInfo.add((Component)this.createValue(sFilialBestand), gbc);
                if (++row <= maxRow) continue;
                gbc = this.setGridBagConstraints(col + 4, row, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 0, 0, 0));
                this.mPanelFilialInfo.add(Box.createRigidArea(new Dimension(40, 10)), gbc);
                col += 5;
                row = 1;
            }
            gbc = this.setGridBagConstraints(col + 4, row, 1, 1, 1.0, 0.0, 2, 14, new Insets(0, 0, 0, 0));
            this.mPanelFilialInfo.add(Box.createHorizontalGlue(), gbc);
            gbc = this.setGridBagConstraints(0, maxRow + 1, 1, 1, 0.0, 1.0, 3, 16, new Insets(0, 0, 0, 0));
            this.mPanelFilialInfo.add(Box.createVerticalGlue(), gbc);
        }
        this.mPanelFilialInfo.repaint();
    }

    protected void updateKommerzielleinfo() {
        Teil oTeil = this.mModel.getKommerzielleInfo();
        if (oTeil != null) {
            this.mTfHaendlerpreis.setText(this.getValue(WebetkUtils.getPriceString(oTeil.getHaendlerpreis())));
            String sMwSt = null;
            sMwSt = oTeil.getMwStDouble() == null ? "-" : WebetkUtils.getPriceString(oTeil.ermittleMwStOhneAT());
            this.mTfMWSt.setText(this.getValue(sMwSt));
            String sATSt = null;
            sATSt = oTeil.getAtStDouble() == null ? "-" : WebetkUtils.getPriceString(oTeil.ermittleAtSt());
            this.mTfATSteuer.setText(this.getValue(sATSt));
            this.mTfGesamtpreis.setText(this.getValue(WebetkUtils.getPriceString(oTeil.ermittleBrutto())));
            this.mTfUPE.setText(this.getValue(WebetkUtils.getPriceString(oTeil.getUPE())));
            this.mTfRabattcode.setText(this.getValue(oTeil.getRabattSchluessel()));
            this.mTfPreisaenderKZ.setText(this.getValue(oTeil.getPreisaenderKZ()));
            this.mTfSonderpreisKZ.setText(this.getValue(oTeil.getSonderpreisKZ()));
            this.mTfSonderpreis.setText(WebetkUtils.getPriceString(oTeil.getSonderpreis()));
            this.mTfNettopreis.setText(WebetkUtils.getPriceString(oTeil.getNettoPreisDatei()));
            this.mTfPfandpauschale.setText(this.getValue(WebetkUtils.getPriceString(oTeil.getNachbelastungspauschale())));
            this.mTfZolltarifnummer.setText(this.getValue(oTeil.getZolltarifnummer()));
            this.mTfLagerort.setText(this.getValue(oTeil.getLagerort()));
            if (oTeil.getLagerbestand() != null) {
                this.mTfLagerbestand.setText(this.getValue(oTeil.getLagerbestand().toString()));
            } else {
                this.mTfLagerbestand.setText("-");
            }
            if (oTeil.getMinimalbestand() != null) {
                this.mTfMinimalbestand.setText(this.getValue(oTeil.getMinimalbestand().toString()));
            } else {
                this.mTfMinimalbestand.setText("-");
            }
        } else {
            this.mTfHaendlerpreis.setText("-");
            this.mTfMWSt.setText("-");
            this.mTfATSteuer.setText("-");
            this.mTfGesamtpreis.setText("-");
            this.mTfUPE.setText("-");
            this.mTfRabattcode.setText("-");
            this.mTfPreisaenderKZ.setText("-");
            this.mTfSonderpreisKZ.setText("-");
            this.mTfSonderpreis.setText("-");
            this.mTfNettopreis.setText("-");
            this.mTfPfandpauschale.setText("-");
            this.mTfZolltarifnummer.setText("-");
            this.mTfLagerort.setText("-");
            this.mTfLagerbestand.setText("-");
            this.mTfMinimalbestand.setText("-");
        }
    }

    public boolean getAktuellerReiterIstFilialinfo() {
        if (!this.mModel.getFilialinfoAnzeigen()) {
            return false;
        }
        if (!this.mModel.getLokalteil()) {
            return this.mTabbedPane.getSelectedIndex() == 2;
        }
        return this.mTabbedPane.getSelectedIndex() == 1;
    }

    private void showEBA(String sSachnummer) {
        try {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            AsapAppletComCtrl.getInstance().invokeEba(sSachnummer);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (PsiCommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerVerbindungAsap(), Resource.getInstance().getTeileinfo(), 0);
        }
    }

    private void showSDB(String sSachnummer) {
        try {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            AsapAppletComCtrl.getInstance().invokeSdb(sSachnummer);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (PsiCommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerVerbindungAsap(), Resource.getInstance().getTeileinfo(), 0);
        }
    }

    private void showPI(String sSachnummer, String sPINummer) {
        try {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            AsapAppletComCtrl.getInstance().invokePi(sSachnummer, sPINummer);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (PsiCommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerVerbindungAsap(), Resource.getInstance().getTeileinfo(), 0);
        }
    }

    private void initASAPLabel(final String sDokArt, JLabel label, final String sSachnummer, final String sDokNr) {
        if (sDokArt.equals("EBA") || sDokArt.equals("SDB") || sDokArt.equals("PI")) {
            label.setForeground(Color.blue);
            label.setText("<html><u>" + label.getText() + "</u></html>");
        }
        label.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent ev) {
                if (sDokArt.equals("EBA")) {
                    DlgTeileinfoView.this.showEBA(sDokNr);
                }
                if (sDokArt.equals("SDB")) {
                    DlgTeileinfoView.this.showSDB(sSachnummer);
                }
                if (sDokArt.equals("PI")) {
                    DlgTeileinfoView.this.showPI(sSachnummer, sDokNr);
                }
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
            }

            @Override
            public void mouseClicked(MouseEvent ev) {
            }

            @Override
            public void mouseEntered(MouseEvent ev) {
                if (sDokArt.equals("EBA") || sDokArt.equals("SDB") || sDokArt.equals("PI")) {
                    MainView.getInstance().setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent ev) {
                if (sDokArt.equals("EBA") || sDokArt.equals("SDB") || sDokArt.equals("PI")) {
                    MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    @Override
    public void setFocus() {
        if (this.mTfSachnummer != null) {
            this.mTfSachnummer.requestFocus();
        }
    }

    @Override
    public HashMap<String, Object> getInfoZurSachnummer() {
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        String sSachnummer = this.mModel.getTeileinfo().getSachnummer();
        String sTeilenummer = this.mModel.getTeileinfo().getTeilenummerGespreizt();
        String sBenennungZusatz = this.mModel.getTeileinfo().getBenennung();
        String sZusatz = this.mModel.getTeileinfo().getZusatz();
        if (sZusatz != null && !sZusatz.equals("")) {
            sBenennungZusatz = sBenennungZusatz + "/" + sZusatz;
        }
        Vector<String> aMarke = this.mModel.getTeileinfo().getMarken();
        String sMarkeVorgabe = GlobalObjects.getInstance().getSessionInfo().getMarke();
        String sMarke = GlobalObjects.getInstance().getEtkData().getMarkeTeilRepraesentant(aMarke, sMarkeVorgabe);
        if (sMarke == null) {
            JOptionPane.showMessageDialog(MainView.getInstance(), "es konnte keine Marke ermittelt werden. Die Funktion wird nicht ausgef\u00fchrt", Resource.getInstance().getTeileinformation(), 0);
            return null;
        }
        String sProduktart = this.mModel.getTeileinfo().getProduktart();
        if (sProduktart.equals(Produkte.getInstance().getProdukt("ALLE").getDbValue())) {
            sProduktart = GlobalObjects.getInstance().getSessionInfo().getProdukart();
        }
        String sKatalogumfang = GlobalObjects.getInstance().getSessionInfo().getKatalogUmfang();
        oHashMap.put("sachnummer", sSachnummer);
        oHashMap.put("teilenummer", sTeilenummer);
        oHashMap.put("benennung_zusatz", sBenennungZusatz);
        oHashMap.put("marke", sMarke);
        oHashMap.put("produktart", sProduktart);
        oHashMap.put("katalogumfang", sKatalogumfang);
        return oHashMap;
    }

    public JTextArea createTextAreaZI(boolean bLineWrap, boolean bWrapStyleWord) {
        JTextArea oTextArea = new JTextArea();
        oTextArea.setBackground(this.getBackground());
        oTextArea.setAutoscrolls(true);
        oTextArea.setEditable(false);
        oTextArea.setLineWrap(bLineWrap);
        oTextArea.setWrapStyleWord(bWrapStyleWord);
        oTextArea.setFont(this.mDescFont);
        oTextArea.setForeground(this.mTextColor);
        oTextArea.setEnabled(false);
        oTextArea.setDisabledTextColor(this.mTextColor);
        return oTextArea;
    }

    public void addReifeninfoTab() {
        this.mTabbedPane.add(Resource.getInstance().getEUReifenLabel(), this.mPanelReifenInfo);
        this.mPanelReifenInfo.setModel(this.mModel);
    }

    public void removeReifeninfoTab() {
        this.mTabbedPane.remove(this.mPanelReifenInfo);
    }

    public static String maxValue(ArrayList<String> list) {
        String str = "";
        for (String string : list) {
            if (string.length() < str.length()) continue;
            str = string;
        }
        return str;
    }
}

