/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileinfo;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.app.teileinfo.Notiz;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfString;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.framework.MainView;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class Teilenotiz
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(Teilenotiz.class);
    private String msTeilenummer;
    private String msText;
    private String msTextOthers;

    public Teilenotiz(JFrame oFrame, String sTeilenummer) {
        super((Frame)oFrame, true);
        this.msTeilenummer = sTeilenummer;
        this.setTitle(Resource.getInstance().getNotiz());
        this.loadNotiz();
        this.initComponents();
    }

    private void initComponents() {
        HeaderPanel panHeader = new HeaderPanel(Resource.getInstance().getNotizFuerTeilenummer() + "  " + this.msTeilenummer, null);
        JPanel panContent = this.createContentPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panHeader, "North");
        this.getContentPane().add((Component)panContent, "Center");
        this.setSize(600, 600);
    }

    private JPanel createContentPanel() {
        JPanel panGesamt = new JPanel();
        HIGConstraints c = new HIGConstraints();
        TitledPanel panEigen = new TitledPanel(Resource.getInstance().getEigeneNotiz() + ":");
        JTextArea txtNotiz = new JTextArea(this.msText);
        txtNotiz.setAutoscrolls(false);
        txtNotiz.setLineWrap(true);
        txtNotiz.setWrapStyleWord(true);
        txtNotiz.setEnabled(true);
        txtNotiz.setFont(this.getFont());
        txtNotiz.setEditable(true);
        txtNotiz.addKeyListener(new TextareaKeyListener());
        JButtonEx buttonSchliessen = new JButtonEx(Resource.getInstance().getSchlieszen());
        JButtonEx buttonLoeschen = new JButtonEx(Resource.getInstance().getLoeschen(), ImageCache.getInstance().getIcon("delete.gif"));
        buttonSchliessen.addActionListener(new CloseButtonActionListener());
        buttonLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Teilenotiz.this.deleteNotiz();
                Teilenotiz.this.dispose();
            }
        });
        JScrollPane scEigen = new JScrollPane(txtNotiz);
        int[] w_Eigen = new int[]{10, 0, 10};
        int[] h_Eigen = new int[]{10, 0, 10, 0, 10};
        HIGLayout layoutEigen = new HIGLayout(w_Eigen, h_Eigen);
        layoutEigen.setColumnWeight(2, 1);
        layoutEigen.setRowWeight(2, 1);
        panEigen.setLayout(layoutEigen);
        panEigen.add((Component)scEigen, c.rc(2, 2));
        panEigen.add((Component)buttonLoeschen, c.rc(4, 2, "tb"));
        TitledPanel panOthers = new TitledPanel(Resource.getInstance().getAlleNotizen() + ":");
        JTextArea txtNotizOthers = new JTextArea(this.msTextOthers);
        txtNotizOthers.setAutoscrolls(false);
        txtNotizOthers.setLineWrap(true);
        txtNotizOthers.setWrapStyleWord(true);
        txtNotizOthers.setEnabled(true);
        txtNotizOthers.setFont(this.getFont());
        txtNotizOthers.setEditable(true);
        txtNotizOthers.addKeyListener(new TextareaKeyListener());
        int[] w_Others = new int[]{10, 0, 10};
        int[] h_Others = new int[]{10, 0, 10};
        HIGLayout layoutOthers = new HIGLayout(w_Others, h_Others);
        layoutOthers.setColumnWeight(2, 1);
        layoutOthers.setRowWeight(2, 1);
        panOthers.setLayout(layoutOthers);
        JScrollPane scOthers = new JScrollPane(txtNotizOthers);
        panOthers.add((Component)scOthers, c.rc(2, 2));
        int[] w_gesamt = new int[]{10, 0, 10};
        int[] h_gesamt = new int[]{10, -4, 15, -2, 15, 0, 10};
        HIGLayout layoutGesamt = new HIGLayout(w_gesamt, h_gesamt);
        layoutGesamt.setColumnWeight(2, 1);
        layoutGesamt.setRowWeight(2, 1);
        layoutGesamt.setRowWeight(4, 1);
        panGesamt.setLayout(layoutGesamt);
        panGesamt.add((Component)panEigen, c.rc(2, 2));
        panGesamt.add((Component)panOthers, c.rc(4, 2));
        panGesamt.add((Component)buttonSchliessen, c.rc(6, 2, "tb"));
        return panGesamt;
    }

    private void loadNotiz() {
        log.debug((Object)"Performing Load Notiz");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfNotiz = new TrfHashMap(null);
        String sSachnummer = StringUtils.substituteStringStraight(this.msTeilenummer, " ", "").substring(4);
        trfNotiz.setValue("sachnummer", sSachnummer);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfNotiz, Command.LOAD_NOTIZ);
        }
        catch (CommunicationException ex) {
            log.error((Object)("Teilenotiz: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        this.msText = "";
        if (trfNotiz.getError() != null) {
            if (trfNotiz.getError() instanceof NoDataFoundException) {
                log.error((Object)"keine Daten gefunden!", (Throwable)trfNotiz.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getNotiz(), 1);
                return;
            }
            log.error((Object)"Sonstiger Fehler", (Throwable)trfNotiz.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + trfNotiz.getError().getMessage(), Resource.getInstance().getNotiz(), 0);
            return;
        }
        this.msText = "";
        Notiz oNotiz = (Notiz)trfNotiz.getValue("notiz_objekt");
        if (oNotiz.getGueltigBis() != null && oNotiz.getGueltigBis().length() > 0) {
            this.msText = this.msText + Resource.getInstance().getGueltigBis() + " " + oNotiz.getGueltigBis() + ":\n";
        }
        this.msText = this.msText + oNotiz.getNotiz();
        this.msTextOthers = "";
        Collection<String> cNotizenOthers = oNotiz.getNotizenOthers();
        Collection<String> cNotizenOthersGueltigBis = oNotiz.getNotizenOthersGueltigBis();
        if (cNotizenOthers != null && cNotizenOthersGueltigBis != null) {
            Iterator<String> iter = cNotizenOthers.iterator();
            Iterator<String> iter2 = cNotizenOthersGueltigBis.iterator();
            while (iter.hasNext() && iter2.hasNext()) {
                if (this.msTextOthers.length() > 0) {
                    this.msTextOthers = this.msTextOthers + "\n\n";
                }
                this.msTextOthers = this.msTextOthers + Resource.getInstance().getGueltigBis() + " " + iter2.next() + ":\n";
                this.msTextOthers = this.msTextOthers + iter.next();
            }
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    private void deleteNotiz() {
        log.debug((Object)"Performing Delete Notiz");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfString trfNotiz = new TrfString(null);
        String sSachnummer = StringUtils.substituteStringStraight(this.msTeilenummer, " ", "").substring(4);
        trfNotiz.setString(sSachnummer);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfNotiz, Command.DELETE_NOTIZ);
        }
        catch (CommunicationException ex) {
            log.error((Object)("Teilenotiz: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfNotiz.getError() != null) {
            log.error((Object)"Sonstiger Fehler", (Throwable)trfNotiz.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + trfNotiz.getError().getMessage(), Resource.getInstance().getNotiz(), 0);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected class TextareaKeyListener
    extends KeyAdapter {
        protected TextareaKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            if (ev.getKeyCode() == 10) {
                Teilenotiz.this.dispose();
                ev.consume();
            } else if (!(ev.getKeyCode() == 37 || ev.getKeyCode() == 39 || ev.getKeyCode() == 38 || ev.getKeyCode() == 40 || ev.getKeyCode() == 9 && ev.isControlDown() || ev.getKeyCode() == 67 && ev.isControlDown())) {
                ev.consume();
            }
        }

        @Override
        public void keyTyped(KeyEvent ev) {
            ev.consume();
        }
    }

    protected class CloseButtonActionListener
    implements ActionListener {
        protected CloseButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Teilenotiz.this.dispose();
        }
    }
}

