/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.JButtonEx;
import de.esg.commonclient.dialog.LimitedNumberField;
import de.esg.commonclient.dialog.LimitedTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.framework.MainView;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class AuftragsNr
extends JDialog {
    private static final long serialVersionUID = 1L;
    private HashMap<String, Object> mMapReturnValues;
    public static final String RET = "ret";
    public static final String AUFTRAGSNR = "AuftragsNr";
    public static final String KUNDENNR = "KundenNr";
    private HeaderPanel mHeaderPanel;
    private JLabel mTxtAuftragsNr;
    private JTextField mTfAuftragsNr;
    private JLabel mTxtOder;
    private JLabel mTxtKundenNr;
    private JTextField mTfKundenNr;
    private JButtonEx mButtonUebernehmen;
    private JButtonEx mButtonAbbrechen;

    public AuftragsNr(HashMap<String, Object> mapReturnValues) {
        super((Frame)MainView.getInstance(), true);
        this.mMapReturnValues = mapReturnValues;
        this.mHeaderPanel = new HeaderPanel(Resource.getInstance().getDatenabgleich(), null);
        this.setSize(290, 250);
        this.setLocation(50, 10);
        this.initComponents();
    }

    protected void initComponents() {
        this.setTitle(Resource.getInstance().getDatenabgleich());
        this.mTxtAuftragsNr = new JLabel(Resource.getInstance().getAuftragsnummer());
        this.mTfAuftragsNr = new LimitedTextField(10);
        this.mTfAuftragsNr.addActionListener(new OkButtonActionListener());
        this.mTxtOder = new JLabel(Resource.getInstance().getOder());
        this.mTxtKundenNr = new JLabel(Resource.getInstance().getKundennummer());
        this.mTfKundenNr = new LimitedNumberField(7, 10);
        this.mTfKundenNr.addActionListener(new OkButtonActionListener());
        if (GlobalObjects.getInstance().getSessionInfo().getDMSVerwenden()) {
            this.mTfAuftragsNr.setText(GlobalObjects.getInstance().getConfig().getStandardAuftragsNummer());
            this.mTfKundenNr.setText(GlobalObjects.getInstance().getConfig().getStandardKundenNummer());
        }
        this.mButtonUebernehmen = new JButtonEx(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.mButtonUebernehmen.addActionListener(new OkButtonActionListener());
        this.mButtonAbbrechen = new JButtonEx(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.mButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuftragsNr.this.mMapReturnValues.put(AuftragsNr.RET, 2);
                AuftragsNr.this.dispose();
            }
        });
        this.layoutAll();
    }

    protected void layoutAll() {
        Container oContentPane = this.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        oContentPane.setLayout(l);
        oContentPane.add((Component)this.mHeaderPanel, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        oContentPane.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    protected JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0};
        int[] heights = new int[]{10, 0, 10, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.createCenterPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(4, 2, "lrtb"));
        return panel;
    }

    protected JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10, 0, 10};
        int[] heights = new int[]{10, 0, 10, 0, 10, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.mTxtAuftragsNr, c.rc(2, 2));
        panel.add((Component)this.mTfAuftragsNr, c.rc(2, 4));
        panel.add((Component)this.mTxtOder, c.rc(4, 2));
        panel.add((Component)this.mTxtKundenNr, c.rc(6, 2));
        panel.add((Component)this.mTfKundenNr, c.rc(6, 4));
        return panel;
    }

    protected JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-5, -4, 10, -2, -1};
        int[] heights = new int[]{0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(1, 1);
        layoutPosTeileliste.setColumnWeight(5, 1);
        layoutPosTeileliste.setRowWeight(2, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.mButtonUebernehmen, c.rc(1, 2, "lrtb"));
        panel.add((Component)this.mButtonAbbrechen, c.rc(1, 4, "lrtb"));
        return panel;
    }

    protected class OkButtonActionListener
    implements ActionListener {
        protected OkButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String sAuftragsNr = AuftragsNr.this.mTfAuftragsNr.getText();
            String sKundenNr = AuftragsNr.this.mTfKundenNr.getText();
            if (sAuftragsNr.length() < 1 && sKundenNr.length() < 1) {
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getMsgNoAuftragsnrKundennr(), AuftragsNr.this.getTitle(), 0);
                return;
            }
            if (!StringUtils.isNMToken(sAuftragsNr)) {
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getWrongFormatNmtoken(), Resource.getInstance().getAuftragsnummer(), 0);
                return;
            }
            if (sAuftragsNr.length() > 0) {
                AuftragsNr.this.mMapReturnValues.put(AuftragsNr.AUFTRAGSNR, sAuftragsNr);
            }
            if (sKundenNr.length() > 0) {
                AuftragsNr.this.mMapReturnValues.put(AuftragsNr.KUNDENNR, sKundenNr);
            }
            AuftragsNr.this.mMapReturnValues.put(AuftragsNr.RET, 0);
            AuftragsNr.this.dispose();
        }
    }
}

