/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import de.esg.commonclient.dialog.tableconfig.DlgTableConfigController;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.DMSException;
import webetk.DuplicateValueException;
import webetk.InvalidDataException;
import webetk.ListLockedException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.GenericTeil;
import webetk.app.aspg.TeilHelper;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.app.fzgid.Auftrag;
import webetk.app.konfiguration.Konfiguration;
import webetk.app.teileinfo.Teileinfo;
import webetk.app.teileliste.Bestellliste;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.teileliste.Scoreliste;
import webetk.app.teileliste.ScorelisteJob;
import webetk.app.teileliste.ScorelisteSrp;
import webetk.app.teileliste.Teileliste;
import webetk.app.teilevwdgfzg.Teil;
import webetk.communication.CommunicationException;
import webetk.communication.JavaFzgIdInfo;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.JavaSucheInfo;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfTeileliste;
import webetk.fix.Constants;
import webetk.javaclient.dialog.GlassPane;
import webetk.javaclient.dialog.SwingWorker;
import webetk.javaclient.dialog.bte.BTEController;
import webetk.javaclient.dialog.defaultdialog.DlgDefaultController;
import webetk.javaclient.dialog.extras.teileliste.AbstractListeController;
import webetk.javaclient.dialog.extras.teileliste.As2ClientScore;
import webetk.javaclient.dialog.extras.teileliste.AuftragsNr;
import webetk.javaclient.dialog.extras.teileliste.Barverkauf;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteModel;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteView;
import webetk.javaclient.dialog.extras.teileliste.EditTeil;
import webetk.javaclient.dialog.extras.teileliste.JobSrp;
import webetk.javaclient.dialog.extras.teileliste.KleineListe;
import webetk.javaclient.dialog.extras.teileliste.Kostenvoranschlag;
import webetk.javaclient.dialog.extras.teileliste.NewListe;
import webetk.javaclient.dialog.extras.teileliste.TeilelistenUebersichtController;
import webetk.javaclient.dialog.extras.teileliste.TeilelistenUebersichtKleinDlg;
import webetk.javaclient.dialog.extras.teileliste.Werkstattauftrag;
import webetk.javaclient.dialog.fzgid.DlgFzgIdController;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.utils.DirectoryChooserDialog;
import webetk.javaclient.utils.DmsUtils;
import webetk.javaclient.workflow.WfFILoeschen;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.mrkprd.Marken;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class DlgTeilelisteController
extends AbstractListeController {
    public static final String RET = "ret";
    public static final int RET_OK = 0;
    public static final int RET_CANCEL = 1;
    public static final int RET_DMS_ERROR = 2;
    public static final int RET_TRY_AGAIN = 3;
    public static final String WIEDER_VERWENDEN = "wieder_verwenden";
    private static Logger log = Logger.getLogger(DlgTeilelisteController.class);
    private DlgTeilelisteView view = new DlgTeilelisteView();
    private DlgTeilelisteModel model = new DlgTeilelisteModel();
    protected static final int ANZ_FZG_KEINES = 0;
    protected static final int ANZ_FZG_EINS = 1;
    protected static final int ANZ_FZG_EINS_UND_LEERSTRING = 2;
    protected static final int ANZ_FZG_MEHR = 3;
    protected static final int NEUANL_OK = 0;
    protected static final int NEUANL_ID_EXISTS = 1;
    protected static final int NEUANL_ERROR = 2;
    protected static final String[] ALL_COLUMNS = new String[]{"Position", "TeileNummer", "TeileBenennung", "Zusatz", "Menge", "Bestand", "Lagerort", "MinimalBestand", "BedarfsHinweis", "AusstehendeMenge", "Preis", "Rabatt", "Splittkennzeichen", "RechnungsTransparenz", "DispoCode", "Suffix", "Netto", "Brutto", "Mwst", "Ruecksendepflicht", "Bemerkung", "Fahrzeug"};
    protected static final String[] DMS_ONLY_COLUMNS = new String[]{"Bestand", "Lagerort", "MinimalBestand", "BedarfsHinweis", "AusstehendeMenge", "Splittkennzeichen", "RechnungsTransparenz", "DispoCode", "Suffix"};
    private static final int LINE_WIDTH = 70;

    public static ArrayList<String> getColumnsMitDMS() {
        ArrayList<String> list = new ArrayList<String>();
        for (int col = 0; col < ALL_COLUMNS.length; ++col) {
            list.add(ALL_COLUMNS[col]);
        }
        return list;
    }

    public static ArrayList<String> getColumnsOhneDMS() {
        ArrayList<String> list = DlgTeilelisteController.getColumnsMitDMS();
        for (int col = 0; col < DMS_ONLY_COLUMNS.length; ++col) {
            list.remove(DMS_ONLY_COLUMNS[col]);
        }
        return list;
    }

    public DlgTeilelisteController() {
        super.setModel(this.model);
    }

    public void setDialogView(DlgTeilelisteView view) {
        this.view = view;
    }

    @Override
    public DialogView getDialogView() {
        log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void updateView() {
        if (this.view != null) {
            this.view.update();
        }
    }

    public void setModel(DlgTeilelisteModel model) {
        super.setModel(model);
        this.model = model;
    }

    protected DlgTeilelisteModel getModel() {
        return this.model;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        this.initBedingt(oWFStateData);
    }

    public boolean initBedingt(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        this.model.init(oWFStateData);
        this.model.setDMSVerwenden(GlobalObjects.getInstance().getSessionInfo().getDMSVerwenden());
        String sFilename = GlobalObjects.getInstance().getEtkData().getUSDealerFilename();
        this.model.setUSSchnittstelleFilename(sFilename);
        this.model.setEpcAction(GlobalObjects.getInstance().getEtkData().getEpcAction());
        this.model.setEpcFile(GlobalObjects.getInstance().getEtkData().getEpcFile());
        String sID = (String)oWFStateData.getWert("ID");
        String sEigentuemer = (String)oWFStateData.getWert("EIGENTUEMER");
        String sFiliale = (String)oWFStateData.getWert("FILIALE");
        String sMarke = (String)oWFStateData.getWert("MARKE");
        this.model.setSelTL(new ComboTeilelisteItem(sID, sID, sEigentuemer, sFiliale, sMarke));
        if (GlobalObjects.isScore()) {
            sID = GlobalObjects.getInstance().getEtkData().getScoreListenID();
            sEigentuemer = GlobalObjects.getInstance().getSessionInfo().getLogin();
            sFiliale = GlobalObjects.getInstance().getSessionInfo().getFilialeId();
            this.model.setSelTL(new ComboTeilelisteItem(sID, sID, sEigentuemer, sFiliale, sMarke));
        }
        this.loadTLZurAuswahl();
        if (sID == null) {
            ComboTeilelisteItem oItem = DlgTeilelisteController.ermittleSelTL(this.model.getTLZurAuswahl(), true);
            sID = oItem.getID();
            sEigentuemer = oItem.getEigentuemer();
            this.model.setSelTL(oItem);
        }
        if (!this.loadTeileliste(sID, sEigentuemer, sFiliale) && sID != null && sID.length() > 0) {
            return false;
        }
        this.loadTLZumUebernehmen();
        String sZurueckZurBildtafelErlauben = (String)oWFStateData.getWert("zurueck_zu_bt_erlauben");
        boolean bZurueckZurBildtafelErlauben = sZurueckZurBildtafelErlauben != null && sZurueckZurBildtafelErlauben.equalsIgnoreCase("true");
        this.model.isZurueckZurBildtafelErlaubt(bZurueckZurBildtafelErlauben);
        String sAufrufAusWorklow = (String)oWFStateData.getWert("aufruf_aus_workflow");
        boolean bAufrufAusWorklow = sAufrufAusWorklow != null && !sAufrufAusWorklow.equals("false");
        this.model.isAufrufAusWorkflow(bAufrufAusWorklow);
        String sGesperrt = (String)oWFStateData.getWert("GESPERRT");
        this.model.setGesperrt(sGesperrt != null);
        if (this.model.getGesperrt()) {
            this.ladeSendeinfo();
        }
        this.view.init(this.model, this);
        return true;
    }

    @Override
    public WorkflowStateData getExitData() {
        WorkflowStateData exitData = new WorkflowStateData();
        exitData.setWert("exitaction", this.model.getExitAction());
        return exitData;
    }

    protected void loadTLZurAuswahl() {
        ComboTeilelisteItem oItem;
        int ii;
        log.debug((Object)"Performing loadTLZurAuswahl");
        this.model.setTLZurAuswahl(new Vector<ComboTeilelisteItem>());
        Vector<String> aMarke = new Vector<String>();
        JavaSucheInfo objSucheInfo = GlobalObjects.getInstance().getEtkData().getSucheInfo();
        if (objSucheInfo != null) {
            aMarke.add(objSucheInfo.getMarke());
        } else {
            LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
            aMarke.add(oLoginInfo.getSettings().getMarke());
        }
        TrfHashMap trfTeilelistenIDs = DlgTeilelisteController.loadTeilelistenIDs(aMarke, false, false);
        if (trfTeilelistenIDs == null) {
            return;
        }
        ComboTeilelisteItem oAktTL = this.model.getSelTL();
        int nMaxInd = 0;
        if (oAktTL != null && oAktTL.getID() != null) {
            boolean bFound = false;
            ii = 1;
            while ((oItem = (ComboTeilelisteItem)trfTeilelistenIDs.getValue(ii + "teilelisteid")) != null) {
                ++nMaxInd;
                if (oItem.getID().equals(oAktTL.getID()) && oItem.getEigentuemer().equals(oAktTL.getEigentuemer())) {
                    bFound = true;
                    break;
                }
                ++ii;
            }
            if (!bFound) {
                trfTeilelistenIDs.setValue(++nMaxInd + "teilelisteid", new ComboTeilelisteItem(oAktTL.getID(), oAktTL.getName(), oAktTL.getEigentuemer(), oAktTL.getFiliale(), oAktTL.getMarke()));
            }
        }
        Vector<ComboTeilelisteItem> aTL = new Vector<ComboTeilelisteItem>();
        if (trfTeilelistenIDs != null) {
            ii = 1;
            while ((oItem = (ComboTeilelisteItem)trfTeilelistenIDs.getValue(ii + "teilelisteid")) != null) {
                if (!oItem.isRrSapListe()) {
                    aTL.add(oItem);
                }
                ++ii;
            }
        }
        this.model.setTLZurAuswahl(aTL);
        if (aMarke.size() == 1) {
            this.model.setNeuanlageMarke((String)aMarke.toArray()[0]);
        } else {
            this.model.setNeuanlageMarke(null);
        }
    }

    protected void loadTLZumUebernehmen() {
        log.debug((Object)"Performing loadTLZumUebernehmen");
        this.model.setTLZumUebernehmen(new Vector<ComboTeilelisteItem>());
        String sSelTLID = this.model.getSelTLID();
        if (sSelTLID == null) {
            return;
        }
        Vector<String> aMarke = new Vector<String>();
        aMarke.add(this.model.getTLDaten().getMarke());
        TrfHashMap trfTeilelistenIDs = DlgTeilelisteController.loadTeilelistenIDs(aMarke, true);
        if (trfTeilelistenIDs == null) {
            return;
        }
        Vector<ComboTeilelisteItem> aTL = new Vector<ComboTeilelisteItem>();
        if (trfTeilelistenIDs != null) {
            ComboTeilelisteItem oItem;
            int ii = 1;
            while ((oItem = (ComboTeilelisteItem)trfTeilelistenIDs.getValue(ii + "teilelisteid")) != null) {
                if (!oItem.getID().equals(sSelTLID)) {
                    aTL.add(oItem);
                }
                ++ii;
            }
        }
        this.model.setTLZumUebernehmen(aTL);
    }

    public static TrfHashMap loadTeilelistenIDs(Collection<String> aMarke, boolean bMitBestelllisten) {
        return DlgTeilelisteController.loadTeilelistenIDs(aMarke, bMitBestelllisten, true);
    }

    protected static TrfHashMap loadTeilelistenIDs(Collection<String> aMarke, boolean bMitBestelllisten, boolean bMitAnderen) {
        ComboTeilelisteItem oItem;
        ComboTeilelisteItem oItem2;
        TrfHashMap trfTeilelistenIDs = new TrfHashMap(null);
        if (GlobalObjects.isScore()) {
            String sID = GlobalObjects.getInstance().getEtkData().getScoreListenID();
            String sEigentuemer = GlobalObjects.getInstance().getSessionInfo().getLogin();
            String sFiliale = GlobalObjects.getInstance().getSessionInfo().getFilialeId();
            String sMarke = aMarke.iterator().next();
            ComboTeilelisteItem oItem3 = new ComboTeilelisteItem(sID, sID, sEigentuemer, sFiliale, sMarke);
            trfTeilelistenIDs.setValue("1teilelisteid", oItem3);
            return trfTeilelistenIDs;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        trfTeilelistenIDs.setValue("marken", aMarke);
        if (!bMitBestelllisten) {
            trfTeilelistenIDs.setValue("ohnebestelllisten", "J");
        }
        String sUSDirect = GlobalObjects.getInstance().getEtkData().getUSDealerFilename();
        trfTeilelistenIDs.setValue("us_filename", sUSDirect);
        if (sUSDirect == null || sUSDirect.length() < 1) {
            ComboTeilelisteItem oAktTL;
            LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
            if (oLoginInfo.getFirmaId() == null) {
                oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
            }
            if ((oAktTL = oLoginInfo.getAktuelleTeileliste()) != null && Marken.getInstance().getEigenschaften("marke.usListenIds").contains(oAktTL.getID())) {
                oLoginInfo.setAktuelleTeileliste(null);
            }
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTeilelistenIDs, Command.LOAD_TEILELISTEN_IDS);
        }
        catch (CommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLadeTeilelistenIds() + ": " + ex.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
            return null;
        }
        if (trfTeilelistenIDs.getError() != null) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLadeTeilelistenIds() + ": " + trfTeilelistenIDs.getError().getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
            return null;
        }
        Vector value = (Vector)trfTeilelistenIDs.getValue("Combo_teilelisteid");
        for (int i = 1; i < value.size() + 1; ++i) {
            trfTeilelistenIDs.setValue(i + "teilelisteid", value.get(i - 1));
        }
        int nMaxInd = 0;
        int ii = 1;
        while ((oItem2 = (ComboTeilelisteItem)trfTeilelistenIDs.getValue(ii + "teilelisteid")) != null) {
            ++nMaxInd;
            ++ii;
        }
        for (ii = nMaxInd; ii > 0; --ii) {
            trfTeilelistenIDs.setValue(ii + 1 + "teilelisteid", trfTeilelistenIDs.getValue(ii + "teilelisteid"));
        }
        if (aMarke == null || aMarke.size() == 1) {
            trfTeilelistenIDs.setValue("1teilelisteid", new ComboTeilelisteItem(Resource.getInstance().getNeueListe()));
            ++nMaxInd;
        } else {
            trfTeilelistenIDs.setValue("1teilelisteid", new ComboTeilelisteItem(""));
            ++nMaxInd;
        }
        String sNutzer = GlobalObjects.getInstance().getSessionInfo().getLogin();
        int ii2 = 1;
        while ((oItem = (ComboTeilelisteItem)trfTeilelistenIDs.getValue(ii2 + "teilelisteid")) != null) {
            oItem.setEigentuemer(sNutzer);
            ++ii2;
        }
        if (bMitAnderen) {
            LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
            ComboTeilelisteItem oAktTL = oLoginInfo.getAktuelleTeileliste();
            if (oAktTL != null) {
                ComboTeilelisteItem oItem4;
                boolean bFound = false;
                int ii3 = 1;
                while ((oItem4 = (ComboTeilelisteItem)trfTeilelistenIDs.getValue(ii3 + "teilelisteid")) != null) {
                    if (oItem4.getID().equals(oAktTL.getID()) && oItem4.getEigentuemer().equals(oAktTL.getEigentuemer())) {
                        bFound = true;
                        break;
                    }
                    ++ii3;
                }
                if (!bFound && DlgTeilelisteController.checkKannTeileUebernehmen(oAktTL.getID(), oAktTL.getEigentuemer())) {
                    trfTeilelistenIDs.setValue(++nMaxInd + "teilelisteid", new ComboTeilelisteItem(oAktTL.getID(), oAktTL.getName(), oAktTL.getEigentuemer(), oAktTL.getFiliale(), oAktTL.getMarke()));
                }
            }
            trfTeilelistenIDs.setValue(++nMaxInd + "teilelisteid", new ComboTeilelisteItem(Resource.getInstance().getAndereListe()));
        }
        ii = 1;
        while ((oItem = (ComboTeilelisteItem)trfTeilelistenIDs.getValue(ii + "teilelisteid")) != null) {
            if (oItem.getID().equals("EILAUFTRAGSLISTE")) {
                oItem.setName(Resource.getInstance().getEilauftragsliste());
            } else if (oItem.getID().equals("NORMALAUFTRAGSLISTE")) {
                oItem.setName(Resource.getInstance().getNormalauftragsliste());
            } else if ("_RRSAPLIST".equals(oItem.getID())) {
                oItem.setName(Resource.getInstance().getRrSap());
            } else {
                oItem.setName(oItem.getID());
            }
            ++ii;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return trfTeilelistenIDs;
    }

    protected String getListenIDZuIndex(int nInd) {
        ComboTeilelisteItem oItem = this.model.getTLZumUebernehmen().get(nInd);
        if (oItem != null) {
            return oItem.getID();
        }
        return null;
    }

    protected boolean loadTeileliste(String sID, String sEigentuemer, String sFiliale) {
        log.debug((Object)("Performing loadTeileliste for ID " + sID));
        this.model.setKopfdatenGeaendert(false);
        this.model.setMustReload(false);
        this.model.setTLDaten(null);
        this.model.setSelTL(null);
        if (sID == null || sID.length() < 1 || sID.equals("null")) {
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        if (sID.equals(Resource.getInstance().getNeueListe())) {
            trfTL.setValue("teilelistenewid", sID);
            String sMarke = this.model.getNeuanlageMarke();
            trfTL.setValue("marke", sMarke);
        } else {
            trfTL.setValue("teilelisteid", sID);
        }
        trfTL.setValue("eigentuemer", sEigentuemer);
        if (sFiliale != null && sFiliale.length() > 0) {
            trfTL.setValue("filialid", sFiliale);
        }
        trfTL.setValue("lock", true);
        if (GlobalObjects.isScore()) {
            trfTL.setValue("score", true);
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.LOAD_TEILELISTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgTeilelisteController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfTL.getError() != null) {
            Exception ex = trfTL.getError();
            if (ex instanceof ListLockedException) {
                Teileliste oTeileliste = (Teileliste)trfTL.getValue("teileliste");
                if (oTeileliste.getGesperrtVon() != null) {
                    String sMsg = null;
                    String sVon = oTeileliste.getGesperrtVon();
                    String sVonName = (String)trfTL.getValue("username");
                    Object[] arguments = new Object[]{sVon, sVonName};
                    sMsg = MessageFormat.format(Resource.getInstance().getTeilelisteGesperrtNutzer(), arguments);
                    log.info((Object)("Liste gesperrt von " + sVon));
                    MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                    JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeilelisteBearbeiten(), 0);
                    return false;
                }
                this.model.setGesperrt(true);
            } else if (ex instanceof DMSException) {
                int nStatus = Integer.parseInt(ex.getMessage());
                String sMsg = Resource.getInstance().getFehlerDmsAbgleich() + ": " + Resource.getInstance().getDmsFehlerText(nStatus);
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeilelisteBearbeiten(), 0);
            } else {
                log.error((Object)(Resource.getInstance().getFehlerLadenTeileliste() + ": "), (Throwable)ex);
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLadenTeileliste() + ": " + ex.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
                return false;
            }
        }
        Teileliste oTeileliste = null;
        oTeileliste = (Teileliste)trfTL.getValue("teileliste");
        if (oTeileliste == null) {
            oTeileliste = (Scoreliste)trfTL.getValue("scoreliste");
        }
        this.model.setTLDaten(oTeileliste);
        this.model.setSelTL(new ComboTeilelisteItem(sID, sID, sEigentuemer, sFiliale, oTeileliste.getMarke()));
        this.model.setSelTLMarke(oTeileliste.getMarke());
        this.model.setFzgDlfId(oTeileliste.getFzgDlfId());
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        this.doDatenAbgleich(false);
        if (this.model.istDMSAngeschlossen() && sID.equals(Resource.getInstance().getNeueListe())) {
            oTeileliste.setAuftragsNrLokal(this.getKonfiguration().getStandardAuftragsNummer());
            oTeileliste.setKundenNrLokal(Long.parseLong(this.getKonfiguration().getStandardKundenNummer()));
        }
        if (oTeileliste.getAuftrag() != null) {
            GlobalObjects.getInstance().getEtkData().resetSucheInfo();
            WfFILoeschen.resetFahrzeugidentifikation();
            Auftrag oAuftrag = oTeileliste.getAuftrag();
            String sFgstNr = oAuftrag.getFgstNr();
            DlgFzgIdController.doFIByFahrgestellnummer(sFgstNr);
        }
        return true;
    }

    public static Scoreliste loadScoreliste(String sID, String sEigentuemer, String sFiliale, boolean bLoadTcFlags) {
        log.debug((Object)("Performing loadScoreliste for ID " + sID));
        if (sID == null || sID.length() < 1 || sID.equals("null")) {
            return null;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teilelisteid", sID);
        trfTL.setValue("eigentuemer", sEigentuemer);
        trfTL.setValue("filialid", sFiliale);
        trfTL.setValue("score", true);
        trfTL.setValue("tc", bLoadTcFlags);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.LOAD_TEILELISTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("CommunicationException: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfTL.getError() != null) {
            Exception ex = trfTL.getError();
            log.error((Object)(Resource.getInstance().getFehlerLadenTeileliste() + ": "), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLadenTeileliste() + ": " + ex.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return null;
        }
        Scoreliste oScoreliste = (Scoreliste)trfTL.getValue("scoreliste");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return oScoreliste;
    }

    public static ComboTeilelisteItem ermittleSelTL(Collection<ComboTeilelisteItem> cTeilelisten, boolean bMitAktuellerListe) {
        String sID = null;
        String sEigentuemer = null;
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        ComboTeilelisteItem oAktTL = oLoginInfo.getAktuelleTeileliste();
        if (bMitAktuellerListe && oAktTL != null) {
            sID = oAktTL.getID();
            sEigentuemer = oAktTL.getEigentuemer();
        } else {
            sID = Resource.getInstance().getEilauftragsliste();
            sEigentuemer = "";
        }
        for (ComboTeilelisteItem item : cTeilelisten) {
            if (item == null || item.getID() == null || item.getEigentuemer() == null || !item.getID().equals(sID) || !item.getEigentuemer().equals(sEigentuemer)) continue;
            return item;
        }
        if (cTeilelisten.size() > 0) {
            Iterator<ComboTeilelisteItem> iter = cTeilelisten.iterator();
            return iter.next();
        }
        return null;
    }

    protected boolean saveTeileliste(String sNewID, String sBemerkung, String sAuftragsnummer, String sKundennummer, boolean bPrivat) {
        log.debug((Object)"Performing saveTeileliste");
        Teileliste oTeileliste = this.model.getTLDaten();
        if (oTeileliste == null) {
            return false;
        }
        if (!StringUtils.isNMToken(sAuftragsnummer)) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getWrongFormatNmtoken(), Resource.getInstance().getAuftragsnummer(), 0);
            return false;
        }
        TrfTeileliste trfTL = new TrfTeileliste(null);
        if (sNewID != null) {
            if (sNewID.length() < 1) {
                if (sAuftragsnummer.length() > 0) {
                    sNewID = sAuftragsnummer;
                } else if (sKundennummer.length() > 0) {
                    sNewID = sKundennummer;
                } else {
                    MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getTeilelisteNoBezeichner(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
                    return false;
                }
                Konfiguration oKonfig = this.getKonfiguration();
                sNewID = DlgTeilelisteController.getNextTeilelistenId(oKonfig, sNewID);
            }
            trfTL.setValue("teilelistenewid", sNewID);
        } else {
            trfTL.setValue("teilelisteid", oTeileliste.getID());
            trfTL.setValue("teilelisteerstellt", oTeileliste.getDatErstellung());
            trfTL.setValue("eigentuemer", oTeileliste.getNutzerID());
            trfTL.setValue("filialid", oTeileliste.getFiliale());
        }
        trfTL.setValue("marke", oTeileliste.getMarke());
        trfTL.setValue("teilelistebemerkung", sBemerkung);
        oTeileliste.setBemerkung(sBemerkung);
        trfTL.setValue("auftrag", oTeileliste.getAuftrag());
        trfTL.setValue("auftragsnr", sAuftragsnummer);
        trfTL.setValue("kundennr", sKundennummer);
        trfTL.setValue("privat", bPrivat);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.SAVE_TEILELISTE_KOPFDATEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgTeilelisteController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfTL.getError() != null) {
            Exception ex = trfTL.getError();
            String sMsg = null;
            sMsg = trfTL.getError() instanceof DuplicateValueException ? Resource.getInstance().getTeilelisteDoppelteId() : Resource.getInstance().getFehlerSpeichernTeileliste() + ": " + ex.getMessage();
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return false;
        }
        this.model.setKopfdatenGeaendert(false);
        String sID = (String)trfTL.getValue("teilelisteid");
        Teileliste oTL = this.model.getTLDaten();
        if (oTL != null) {
            this.model.setSelTL(new ComboTeilelisteItem(sID, sID, oTL.getNutzerID(), oTL.getFiliale(), oTL.getMarke()));
            oTL.setID(sID);
            oTL.setNewID((String)trfTL.getValue("teilelistenewid"));
            oTL.setDatErstellung((Date)trfTL.getValue("teilelisteerstellt"));
            oTL.setDatAenderung((Date)trfTL.getValue("teilelistegeaendert"));
            oTL.setBemerkung(sBemerkung);
            oTL.setAuftragsNrLokal(sAuftragsnummer);
            Long lKundennummer = null;
            if (sKundennummer != null && sKundennummer.length() > 0) {
                lKundennummer = Long.valueOf(sKundennummer);
            }
            oTL.setKundenNrLokal(lKundennummer);
            oTL.setPrivat(bPrivat);
            this.model.setTLDaten(oTL);
        }
        if (sNewID != null) {
            Vector<webetk.app.teileliste.Teil> cTeile = this.model.getTeile();
            if (cTeile == null) {
                cTeile = new Vector();
                this.model.setTeile(cTeile);
            }
            Vector<ComboTeilelisteItem> aTL = this.model.getTLZurAuswahl();
            aTL.add(this.model.getSelTL());
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    protected void deleteTeileliste() {
        log.debug((Object)"Performing deleteTeileliste");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        Teileliste oTL = this.model.getTLDaten();
        trfTL.setValue("teilelisteid", oTL.getID());
        trfTL.setValue("eigentuemer", oTL.getNutzerID());
        trfTL.setValue("filialid", oTL.getFiliale());
        trfTL.setValue("auftragsnr", oTL.getAuftragsNr());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.DELETE_TEILELISTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgTeilelisteController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTL.getError() != null) {
            log.error((Object)(Resource.getInstance().getFehlerLoeschenTeileliste() + ": "), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLoeschenTeileliste() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return;
        }
        if (oTL.getID().equals(this.model.getSelTLID())) {
            this.model.removeTL(this.model.getSelTL());
        }
        this.model.setTLDaten(null);
        this.model.setSelTL(null);
        this.model.setSelTLMarke(null);
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        oLoginInfo.setAktuelleTeileliste(null);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void deleteTeile(String sListenID, String sEigentuemer, String sFiliale, Collection<webetk.app.teileliste.Teil> cTeile) {
        Vector<webetk.app.teileliste.Teil> delTeile = new Vector<webetk.app.teileliste.Teil>();
        Vector<webetk.app.teileliste.Teil> sortListe = this.model.getTLDaten().getTeileSortiert(0, true);
        for (webetk.app.teileliste.Teil teil : sortListe) {
            if (this.isTeilInListe(cTeile, teil)) {
                delTeile.add(teil);
                continue;
            }
            if (!this.existAnkerTeilForKoppelTeil(cTeile, teil)) continue;
            delTeile.add(teil);
        }
        cTeile = delTeile;
        log.debug((Object)"Performing deleteTeil");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teilelisteid", sListenID);
        trfTL.setValue("eigentuemer", sEigentuemer);
        trfTL.setValue("filialid", sFiliale);
        trfTL.setValue("teile", cTeile);
        trfTL.setValue("score", GlobalObjects.isScore());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.TEILELISTE_DELETE_TEIL);
        }
        catch (CommunicationException e) {
            log.error((Object)("DlgTeilelisteController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return;
        }
        if (trfTL.getError() != null) {
            log.error((Object)(Resource.getInstance().getFehlerLoeschenTeile() + ": "), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLoeschenTeile() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return;
        }
        if (!GlobalObjects.isScore()) {
            if (cTeile == this.model.getTLDaten().getTeile()) {
                cTeile.clear();
            } else {
                for (webetk.app.teileliste.Teil oTeil : cTeile) {
                    Vector<webetk.app.teileliste.Teil> aTeile = this.model.getTLDaten().getTeile();
                    aTeile.remove(oTeil.getPosInt() - 1);
                    for (webetk.app.teileliste.Teil oTeil2 : aTeile) {
                        if (oTeil2.getPosInt() <= oTeil.getPosInt()) continue;
                        oTeil2.setPos(oTeil2.getPosInt() - 1);
                    }
                }
            }
        } else if (this.model.getTLDaten() != null && this.model.getTLDaten() instanceof Scoreliste) {
            for (webetk.app.teileliste.Teil oTeil : cTeile) {
                if (oTeil.isTeilVonScore()) {
                    oTeil.setScoreAenderung(4);
                    continue;
                }
                Scoreliste scoreliste = (Scoreliste)this.model.getTLDaten();
                Collection<ScorelisteJob> cJobs = scoreliste.getJobs();
                for (ScorelisteJob job : cJobs) {
                    Collection<ScorelisteSrp> cSrps = job.getSrps();
                    for (ScorelisteSrp srp : cSrps) {
                        Vector aTeile = (Vector)srp.getTeile();
                        aTeile.remove(oTeil);
                    }
                }
            }
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void handleSelChangeCbTeilelisten(final String sNewID, final String sEigentuemer) {
        GlassPane glassPane = new GlassPane();
        MainView.getInstance().setGlassPane(glassPane);
        glassPane.setVisible(true);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                log.debug((Object)("handleSelChangeCbTeilelisten for new ID " + sNewID));
                DlgTeilelisteController.this.entsperreListe();
                DlgTeilelisteController.this.loadTeileliste(sNewID, sEigentuemer, null);
                DlgTeilelisteController.this.loadTLZumUebernehmen();
                if (DlgTeilelisteController.this.view != null) {
                    DlgTeilelisteController.this.view.update();
                }
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                MainView.getInstance().getGlassPane().setVisible(false);
                if (DlgTeilelisteController.this.view != null) {
                    DlgTeilelisteController.this.view.requestFocusCbTeilelisten();
                }
                return null;
            }
        };
        worker.start();
    }

    protected void handleDeleteTeileliste() {
        log.debug((Object)"handleDeleteTeileliste");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        int nRet = JOptionPane.showConfirmDialog(MainView.getInstance(), Resource.getInstance().getAskTeilelisteLoeschen(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
        if (nRet == 0) {
            this.deleteTeileliste();
            if (this.model.getGesperrt()) {
                WorkflowStateData oWsd = new WorkflowStateData();
                MainView.getInstance().showDlg(TeilelistenUebersichtController.class, oWsd);
            }
            ComboTeilelisteItem oItem = DlgTeilelisteController.ermittleSelTL(this.model.getTLZurAuswahl(), true);
            String sID = oItem.getID();
            this.model.setSelTL(oItem);
            this.loadTeileliste(sID, null, null);
            if (this.view != null) {
                this.view.update();
            }
        }
    }

    protected boolean handleSaveTeileliste(String sNewID, String sBemerkung, String sAuftragsnummer, String sKundennummer, boolean bPrivat) {
        log.debug((Object)"handleSaveTeileliste");
        if (!this.saveTeileliste(sNewID, sBemerkung, sAuftragsnummer, sKundennummer, bPrivat)) {
            return false;
        }
        if (this.view != null) {
            this.view.update();
        }
        return true;
    }

    public void handleNewTeil() {
        log.debug((Object)"handleNewTeil");
        EditTeil editTeil = new EditTeil((Frame)MainView.getInstance(), false);
        editTeil.setModel(this.model);
        editTeil.setController(this);
        editTeil.setNeuanlage(true);
        Teileliste oTL = this.model.getTLDaten();
        if (oTL instanceof Scoreliste) {
            GlobalObjects glob = GlobalObjects.getInstance();
            editTeil.setJobSrp(glob.getEtkData().getScoreJobId(), glob.getEtkData().getScoreSrpId());
        }
        editTeil.initComponents();
        editTeil.setVisible(true);
        if (GlobalObjects.isScore()) {
            this.model.setMustReload(true);
        }
        if (this.view != null) {
            this.view.update();
        }
    }

    protected void handleStammsatzDMS(Collection<webetk.app.teileliste.Teil> cTeile) {
        log.debug((Object)"handleStammsatzDMS");
        for (webetk.app.teileliste.Teil oTeil : cTeile) {
            if (this.checkPflichtfelderStammsatzDMS(oTeil)) continue;
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teile", cTeile);
        trfTL.setValue("marke", this.model.getSelTLMarke());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.DO_DMS_STAMMSATZ);
        }
        catch (CommunicationException e) {
            log.error((Object)("DlgTeilelisteController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return;
        }
        Collection cMsgTxts = (Collection)trfTL.getValue("msgtxtlist");
        Collection cRetCodes = (Collection)trfTL.getValue("returncodesliste");
        if (!DmsUtils.showMsgTxt(cMsgTxts, cRetCodes, cTeile)) {
            return;
        }
        if (trfTL.getError() != null) {
            String sMsg = Resource.getInstance().getSonstigerFehler() + ": " + trfTL.getError().getMessage();
            log.error((Object)sMsg);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        this.model.setNewParts(cTeile);
        this.doDatenAbgleich(true);
        cTeile = this.model.getNewParts();
        Vector<webetk.app.teileliste.Teil> cToSave = new Vector<webetk.app.teileliste.Teil>();
        for (webetk.app.teileliste.Teil oTeil : cTeile) {
            oTeil.setUpdate(true);
            cToSave.add(oTeil);
        }
        DlgTeilelisteController.saveTeile(this.model.getSelTLID(), cToSave);
        Vector<webetk.app.teileliste.Teil> cTeileOld = this.model.getTeile();
        Vector<webetk.app.teileliste.Teil> cTeileNew = new Vector<webetk.app.teileliste.Teil>(cTeileOld);
        for (webetk.app.teileliste.Teil oTeil : cTeile) {
            cTeileNew.setElementAt(oTeil, oTeil.getPosInt() - 1);
        }
        this.model.setTeile(cTeileNew);
        this.model.setNewParts(null);
        if (this.view != null) {
            this.view.update();
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void handleEditTeile(Collection<webetk.app.teileliste.Teil> aTeile) {
        log.debug((Object)"handleEditTeil");
        this.model.setSelTeile(aTeile);
        EditTeil editTeil = new EditTeil();
        editTeil.setModel(this.model);
        editTeil.setNeuanlage(false);
        Teileliste oTL = this.model.getTLDaten();
        if (oTL instanceof Scoreliste && aTeile.size() > 0) {
            Iterator<webetk.app.teileliste.Teil> iter = aTeile.iterator();
            webetk.app.teileliste.Teil oTeil = iter.next();
            editTeil.setJobSrp(oTeil.getJobId(), oTeil.getSrpId());
        }
        editTeil.initComponents();
        editTeil.setVisible(true);
        if (GlobalObjects.isScore()) {
            this.model.setMustReload(true);
        }
        if (this.view != null) {
            this.view.update();
        }
    }

    public void handleDeleteTeile(Collection<webetk.app.teileliste.Teil> cTeile) {
        log.debug((Object)"handleDeleteTeil");
        ComboTeilelisteItem oItem = this.model.getSelTL();
        this.deleteTeile(oItem.getID(), oItem.getEigentuemer(), oItem.getFiliale(), cTeile);
        if (this.view != null) {
            this.view.update();
        }
    }

    protected void handleWerkstattauftrag() {
        log.debug((Object)"handleWerkstattauftrag");
        if (!this.checkPflichtfelderDMSSenden()) {
            return;
        }
        HashMap<String, Object> mapRetVal = new HashMap<String, Object>();
        Werkstattauftrag werkstattauftrag = new Werkstattauftrag(mapRetVal);
        werkstattauftrag.setController(this);
        werkstattauftrag.initComponents();
        werkstattauftrag.show();
        this.handleNachDMSSenden(mapRetVal);
    }

    protected void handleKostenvoranschlag() {
        log.debug((Object)"handleKostenvoranschlag");
        if (!this.checkPflichtfelderDMSSenden()) {
            return;
        }
        HashMap<String, Object> mapRetVal = new HashMap<String, Object>();
        Kostenvoranschlag kostenvoranschlag = new Kostenvoranschlag(mapRetVal);
        kostenvoranschlag.setController(this);
        kostenvoranschlag.initComponents();
        kostenvoranschlag.show();
        this.handleNachDMSSenden(mapRetVal);
    }

    protected void handleBarverkauf() {
        log.debug((Object)"handleBarverkauf");
        if (!this.checkPflichtfelderDMSSenden()) {
            return;
        }
        HashMap<String, Object> mapRetVal = new HashMap<String, Object>();
        Barverkauf barverkauf = new Barverkauf(mapRetVal);
        barverkauf.setController(this);
        barverkauf.initComponents();
        barverkauf.show();
        this.handleNachDMSSenden(mapRetVal);
    }

    protected webetk.app.teileliste.Teil[] getTeile(int[] aRetCodes) {
        webetk.app.teileliste.Teil[] aTeile = new webetk.app.teileliste.Teil[aRetCodes.length];
        for (int ii = 0; ii < aRetCodes.length; ++ii) {
            webetk.app.teileliste.Teil oTeil;
            aTeile[ii] = oTeil = this.model.getTeil(ii + 1);
        }
        return aTeile;
    }

    protected void handleNachDMSSenden(HashMap<String, Object> mapRetVal) {
        Integer nRetVal = (Integer)mapRetVal.get(RET);
        int nRet = 1;
        if (nRetVal != null) {
            nRet = nRetVal;
        }
        if (nRet == 0) {
            String sFgstNr = null;
            Auftrag oAuftrag = this.model.getTLDaten().getAuftrag();
            if (oAuftrag != null) {
                sFgstNr = oAuftrag.getFgstNr();
            }
            this.deleteTeileliste();
            JavaSucheInfo objSucheInfo = GlobalObjects.getInstance().getEtkData().getSucheInfo();
            String sAktFgstNr = "";
            if (objSucheInfo != null && objSucheInfo instanceof JavaFzgSucheInfo) {
                JavaFzgSucheInfo objFzgSucheInfo = (JavaFzgSucheInfo)objSucheInfo;
                sAktFgstNr = objFzgSucheInfo.getFahrgestellnummer();
            }
            if (sFgstNr != null && !sFgstNr.equals("") && sFgstNr.equals(sAktFgstNr)) {
                GlobalObjects.getInstance().getEtkData().resetSucheInfo();
                GlobalObjects.getInstance().resetFzgIdInfo();
                WfFILoeschen.resetFahrzeugidentifikation();
                WorkflowStateData oWsd = new WorkflowStateData();
                MainView.getInstance().showDlg(DlgDefaultController.class, oWsd);
                return;
            }
            ComboTeilelisteItem oItem = DlgTeilelisteController.ermittleSelTL(this.model.getTLZurAuswahl(), true);
            String sSelID = oItem.getID();
            this.model.setSelTL(oItem);
            this.loadTeileliste(sSelID, null, null);
            if (this.view != null) {
                this.view.update();
            }
        } else if (nRet == 2) {
            Teileliste oTL = this.model.getTLDaten();
            WorkflowStateData oWsd = new WorkflowStateData();
            oWsd.setWert("DMS", "DMS");
            oWsd.setWert("ID", oTL.getID());
            oWsd.setWert("EIGENTUEMER", oTL.getNutzerID());
            oWsd.setWert("FILIALE", oTL.getFiliale());
            oWsd.setWert("GESPERRT", "J");
            MainView.getInstance().showDlg(DlgTeilelisteController.class, oWsd);
        }
    }

    protected static String copyTeileliste(String sOldID, String sNutzerID, String sFiliale) {
        String sNewID = DlgTeilelisteController.ermittleIDFuerKopie(sOldID, false);
        int nRetCopy = DlgTeilelisteController.copyTeileliste(sNewID, sOldID, sNutzerID, sFiliale);
        while (nRetCopy == 3) {
            sNewID = DlgTeilelisteController.ermittleIDFuerKopie(sNewID, true);
            nRetCopy = DlgTeilelisteController.copyTeileliste(sNewID, sOldID, sNutzerID, sFiliale);
        }
        if (nRetCopy == 0) {
            return sNewID;
        }
        return null;
    }

    protected static int copyTeileliste(String sNewID, String sOldID, String sNutzerID, String sFiliale) {
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teilelistenewid", sNewID);
        trfTL.setValue("teilelisteid", sOldID);
        trfTL.setValue("eigentuemer", sNutzerID);
        trfTL.setValue("filialid_alt", sFiliale);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.COPY_TEILELISTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return 1;
        }
        if (trfTL.getError() != null) {
            Exception ex = trfTL.getError();
            String sMsg = null;
            if (trfTL.getError() instanceof DuplicateValueException) {
                return 3;
            }
            sMsg = Resource.getInstance().getFehlerSpeichernTeileliste() + ": " + ex.getMessage();
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return 1;
        }
        return 0;
    }

    protected static String ermittleIDFuerKopie(String sOldID, boolean bNextInd) {
        String sInd = "1";
        if (bNextInd) {
            int nPos = sOldID.lastIndexOf("@");
            sInd = sOldID.substring(nPos + 1);
            long lInd = Long.parseLong(sInd);
            sInd = Long.toString(++lInd);
        }
        StringBuffer sNewID = new StringBuffer("");
        int nLengthErsterTeil = 19 - sInd.length();
        if (sOldID.length() <= nLengthErsterTeil) {
            sNewID.append(sOldID);
        } else {
            sNewID.append(sOldID.substring(0, nLengthErsterTeil));
        }
        while (sNewID.length() < nLengthErsterTeil) {
            sNewID.append(" ");
        }
        sNewID.append("@");
        sNewID.append(sInd);
        return sNewID.toString();
    }

    public Teileliste uebernehmeTeile(Frame oOwner, ComboTeilelisteItem oItem, String sMarke, Collection<?> cTeile, boolean bFzgIdString) {
        return this.uebernehmeTeile(oOwner, oItem, sMarke, cTeile, null, false, false, bFzgIdString, false);
    }

    public Teileliste uebernehmeTeile(Frame oOwner, ComboTeilelisteItem oItem, String sMarke, Collection<?> cTeile, boolean bLoadAnzNotizen, boolean bFzgIdString) {
        return this.uebernehmeTeile(oOwner, oItem, sMarke, cTeile, null, bLoadAnzNotizen, false, bFzgIdString, true);
    }

    protected Teileliste uebernehmeTeile(Frame oOwner, ComboTeilelisteItem oItem, String sMarke, Collection<?> cTeile, Auftrag oAuftrag, boolean bLoadAnzNotizen, boolean bShowauftragsMsg, boolean bFzgIdString, boolean bReplaceMenge) {
        String sNewFIString;
        JDialog dlg;
        HashMap<String, Object> mapRetVal;
        String sID = oItem.getID();
        String sEigentuemer = oItem.getEigentuemer();
        String sFiliale = oItem.getFiliale();
        if (sID == null || sID.length() < 1 || cTeile == null || cTeile.size() == 0) {
            return null;
        }
        boolean bBestellliste = Constants.Bestellliste.isBestellliste(sID);
        if (!bBestellliste && sID.equals(Resource.getInstance().getNeueListe())) {
            if (sMarke == null) {
                return null;
            }
            mapRetVal = new HashMap();
            dlg = new NewListe(oOwner, sMarke, mapRetVal);
            dlg.setVisible(true);
            Integer nRet = (Integer)mapRetVal.get(RET);
            if (nRet == null || nRet != 0) {
                return null;
            }
            sID = (String)mapRetVal.get("id");
        }
        if (sID.equals(Resource.getInstance().getAndereListe())) {
            mapRetVal = new HashMap<String, Object>();
            dlg = new TeilelistenUebersichtKleinDlg(mapRetVal);
            dlg.setVisible(true);
            Teileliste selListe = null;
            Integer nRet = (Integer)mapRetVal.get(RET);
            if (nRet == null || nRet != 0) {
                return null;
            }
            selListe = (Teileliste)mapRetVal.get("liste");
            if (selListe == null) {
                log.error((Object)"selListe == null");
                return null;
            }
            sID = selListe.getID();
            sEigentuemer = selListe.getNutzerID();
        }
        if (bShowauftragsMsg && (sNewFIString = DlgTeilelisteController.ermittleFIStringZuAuftragZugeordnet(oItem)) != null) {
            Object[] arguments = new Object[]{sNewFIString};
            String sMsg = MessageFormat.format(Resource.getInstance().getAskTeilelisteUebernehmenMitAuftrag(), arguments);
            oOwner.setCursor(Cursor.getPredefinedCursor(0));
            int nRet = JOptionPane.showConfirmDialog(oOwner, sMsg, Resource.getInstance().getTeileliste(), 0);
            if (nRet != 0) {
                return null;
            }
        }
        StringBuffer sbJobId = new StringBuffer();
        StringBuffer sbSrpId = new StringBuffer();
        if (GlobalObjects.isScore()) {
            Scoreliste oSL = DlgTeilelisteController.loadScoreliste(sID, sEigentuemer, sFiliale, false);
            JobSrp dlg2 = new JobSrp(oSL, sbJobId, sbSrpId);
            if (sbJobId.length() < 1 || sbSrpId.length() < 1) {
                dlg2.setVisible(true);
            }
            if (sbJobId.toString().length() == 0 || sbSrpId.toString().length() == 0) {
                return null;
            }
        }
        oOwner.setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teilelisteid", sID);
        if (bBestellliste) {
            trfTL.setValue("istbestellliste", "J");
            if (oAuftrag != null) {
                trfTL.setValue("auftrag", oAuftrag);
            }
        } else {
            trfTL.setValue("eigentuemer", sEigentuemer);
        }
        trfTL.setValue(this.getTeileKey(cTeile), cTeile);
        trfTL.setValue("fzgidstring", bFzgIdString);
        if (bLoadAnzNotizen) {
            trfTL.setValue("notiz", true);
        }
        trfTL.setValue("menge", bReplaceMenge);
        if (sbJobId.toString().length() > 0) {
            trfTL.setValue("jobid", sbJobId.toString());
        }
        if (sbSrpId.toString().length() > 0) {
            trfTL.setValue("srpid", sbSrpId.toString());
        }
        if (GlobalObjects.isScore()) {
            trfTL.setValue("score", true);
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.TEILELISTE_INSERT_TEILE);
        }
        catch (CommunicationException ex) {
            oOwner.setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(oOwner, ex.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return null;
        }
        if (trfTL.getError() != null) {
            Exception e = trfTL.getError();
            String sMsg = null;
            if (e instanceof ListLockedException) {
                Teileliste oTL = this.getTeileliste(trfTL);
                if (oTL instanceof Bestellliste) {
                    sMsg = Resource.getInstance().getUebernehmenListeGesperrt();
                } else if (oTL.getGesperrt()) {
                    sMsg = Resource.getInstance().getTeilelisteGesperrtDms();
                } else {
                    String sVon = oTL.getGesperrtVon();
                    String sVonName = (String)trfTL.getValue("username");
                    Object[] arguments = new Object[]{sVon, sVonName};
                    sMsg = MessageFormat.format(Resource.getInstance().getTeilelisteGesperrtNutzer(), arguments);
                }
            } else {
                sMsg = e instanceof NoDataFoundException ? Resource.getInstance().getTeilNichtGefundenZuSachnummer() : (e instanceof InvalidDataException ? Resource.getInstance().getTeilFalscheMarke() : Resource.getInstance().getFehlerUebernehmenTeile() + ": " + trfTL.getError().getMessage());
            }
            oOwner.setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(oOwner, sMsg, Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return null;
        }
        oOwner.setCursor(Cursor.getPredefinedCursor(0));
        if (sID != null) {
            GlobalObjects.getInstance().getSessionInfo().setAktuelleTeileliste(new ComboTeilelisteItem(sID, sID, sEigentuemer, sFiliale, sMarke));
        }
        oItem.setID(sID);
        oItem.setEigentuemer(sEigentuemer);
        Teileliste res = (Teileliste)trfTL.getValue("teileliste");
        if (res == null) {
            res = (Scoreliste)trfTL.getValue("scoreliste");
        }
        if (res != null) {
            ArrayList<webetk.app.teileliste.Teil> diebstahlrelevants = this.findDiebstahlrelevants(res.getTeile(), cTeile);
            this.showDiebstahlrelevantWarning(diebstahlrelevants);
        }
        return res;
    }

    private String getTeileKey(Collection<?> cTeile) {
        Iterator<?> i$ = cTeile.iterator();
        if (i$.hasNext()) {
            Object o = i$.next();
            if (o instanceof webetk.app.teileliste.Teil) {
                return "teile";
            }
            if (o instanceof webetk.app.aspg.Teil) {
                return "teileaspg";
            }
            if (o instanceof webetk.app.normteile.Teil) {
                return "teile_norm";
            }
            if (o instanceof webetk.app.notizuebersicht.Teil) {
                return "teilenotiz";
            }
            if (o instanceof webetk.app.teileersetzung.Teil) {
                return "teile_ersetzung";
            }
            if (o instanceof Teil) {
                return "teile_verwendung";
            }
            return "genericteile";
        }
        return "teile";
    }

    public static Collection<GenericTeil> convertTeile(Collection cTeile) {
        ArrayList<GenericTeil> output = new ArrayList<GenericTeil>();
        for (Object object : cTeile) {
            webetk.app.teileliste.Teil t = new webetk.app.teileliste.Teil();
            if (object instanceof webetk.app.teileliste.Teil) {
                output.add((GenericTeil)object);
                continue;
            }
            if (object instanceof GenericTeil) {
                output.add((GenericTeil)object);
                continue;
            }
            if (object instanceof String) {
                String sSachnummer = (String)object;
                t.setSachnummer(sSachnummer);
                output.add(t);
                continue;
            }
            if (!(object instanceof webetk.app.aspg.Teil)) continue;
            webetk.app.aspg.Teil teil = (webetk.app.aspg.Teil)object;
            output.add(teil);
        }
        return output;
    }

    public void uebernehmeTeile(DlgTeilelisteModel oTLModel, Collection<webetk.app.aspg.Teil> cTeile, boolean bLoadAnzNotizen, boolean bFzgIdString, boolean bReplaceMenge) {
        if (oTLModel == null || cTeile == null || cTeile.size() == 0) {
            return;
        }
        Teileliste oTL = oTLModel.getTLDaten();
        if (oTL == null) {
            return;
        }
        TrfTeileliste trfTL = new TrfTeileliste(null);
        StringBuffer sbJobId = new StringBuffer();
        StringBuffer sbSrpId = new StringBuffer();
        if (oTL instanceof Scoreliste) {
            Scoreliste oSL = (Scoreliste)oTL;
            trfTL.setValue("scoreliste", oTL);
            JobSrp dlg = new JobSrp(oSL, sbJobId, sbSrpId);
            if (sbJobId.length() < 1 || sbSrpId.length() < 1) {
                dlg.setVisible(true);
            }
            if (sbJobId.toString().length() == 0 || sbSrpId.toString().length() == 0) {
                return;
            }
        } else {
            trfTL.setValue("teileliste", oTL);
        }
        trfTL.setValue("teilelisteid", oTL.getMsID());
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        trfTL.setValue("teileaspg", TeilHelper.toVector(cTeile));
        trfTL.setValue("menge", bReplaceMenge);
        if (bLoadAnzNotizen) {
            trfTL.setValue("notiz", true);
        }
        trfTL.setValue("fzgidstring", bFzgIdString);
        if (sbJobId.toString().length() > 0) {
            trfTL.setValue("jobid", sbJobId.toString());
        }
        if (sbSrpId.toString().length() > 0) {
            trfTL.setValue("srpid", sbSrpId.toString());
        }
        if (GlobalObjects.isScore()) {
            trfTL.setValue("score", true);
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.TEILELISTE_INSERT_TEILE);
        }
        catch (CommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), ex.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return;
        }
        if (trfTL.getError() != null) {
            Exception e = trfTL.getError();
            String sMsg = null;
            sMsg = e instanceof ListLockedException ? ((oTL = this.getTeileliste(trfTL)) instanceof Bestellliste ? Resource.getInstance().getUebernehmenListeGesperrt() : (oTL.getGesperrt() ? Resource.getInstance().getTeilelisteGesperrtDms() : Resource.getInstance().getTeilelisteGesperrtNutzer())) : (e instanceof NoDataFoundException ? Resource.getInstance().getTeilNichtGefundenZuSachnummer() : (e instanceof InvalidDataException ? Resource.getInstance().getTeilFalscheMarke() : Resource.getInstance().getFehlerUebernehmenTeile() + ": " + trfTL.getError().getMessage()));
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        if (oTL.getID() != null) {
            GlobalObjects.getInstance().getSessionInfo().setAktuelleTeileliste(new ComboTeilelisteItem(oTL.getID(), oTL.getID(), oTL.getNutzerID(), oTL.getFiliale(), oTL.getMarke()));
        }
        if ((oTL = (Teileliste)trfTL.getValue("teileliste")) == null) {
            oTL = (Scoreliste)trfTL.getValue("scoreliste");
        }
        oTLModel.setTLDaten(oTL);
        ArrayList<webetk.app.teileliste.Teil> diebstahlrelevants = this.findDiebstahlrelevants(oTL.getTeile(), cTeile);
        this.showDiebstahlrelevantWarning(diebstahlrelevants);
    }

    private Teileliste getTeileliste(TrfTeileliste trfTL) {
        if (trfTL.getValue("teileliste") != null) {
            return (Teileliste)trfTL.getValue("teileliste");
        }
        if (trfTL.getValue("bestellliste") != null) {
            return (Bestellliste)trfTL.getValue("bestellliste");
        }
        return (Scoreliste)trfTL.getValue("scoreliste");
    }

    protected void handleUebernehmeTeile(int nInd, Collection<webetk.app.teileliste.Teil> cTeile, String sAuftragsnr, String sKundennr) {
        String sMarke = null;
        String sID = this.getListenIDZuIndex(nInd);
        ComboTeilelisteItem oItem = this.model.getTLZumUebernehmen().get(nInd);
        if (sID.equals(Resource.getInstance().getNeueListe())) {
            sMarke = this.model.getSelTLMarke();
        }
        Vector<webetk.app.teileliste.Teil> aTeile = new Vector<webetk.app.teileliste.Teil>();
        for (webetk.app.teileliste.Teil oTeil : cTeile) {
            aTeile.add(oTeil);
        }
        Auftrag oAuftrag = this.model.getTLDaten().getAuftrag();
        if (oAuftrag == null && (sAuftragsnr != null && sAuftragsnr.length() > 0 || sKundennr != null && sKundennr.length() > 0)) {
            Long lKundenNr = null;
            if (sKundennr != null && sKundennr.length() > 0) {
                lKundenNr = Long.valueOf(sKundennr);
            }
            oAuftrag = new Auftrag(null, null, sAuftragsnr, lKundenNr, null, null);
        }
        if (oItem.getID() != null && oItem.getName().equals(Resource.getInstance().getNeueListe())) {
            ComboTeilelisteItem oNewItem = new ComboTeilelisteItem(oItem.getID(), oItem.getName(), oItem.getEigentuemer(), oItem.getFiliale(), oItem.getMarke());
            Teileliste newTl = this.uebernehmeTeile(MainView.getInstance(), oNewItem, sMarke, aTeile, oAuftrag, false, true, false, true);
            if (newTl != null) {
                oNewItem.setName(oNewItem.getID());
                Vector<ComboTeilelisteItem> aTL = this.model.getTLZurAuswahl();
                aTL.add(oNewItem);
                this.model.setTLZurAuswahl(aTL);
                aTL = this.model.getTLZumUebernehmen();
                aTL.add(oNewItem);
                this.model.setTLZumUebernehmen(aTL);
                if (this.view != null) {
                    this.view.update();
                }
            }
        } else {
            this.uebernehmeTeile(MainView.getInstance(), oItem, sMarke, aTeile, oAuftrag, false, true, false, true);
        }
    }

    public static boolean kannSelektionWechseln(ComboTeilelisteItem oNewItem, ComboTeilelisteItem oOldItem) {
        String sID = oNewItem.getID();
        String sEigentuemer = oNewItem.getEigentuemer();
        String sFiliale = oNewItem.getFiliale();
        String sMarke = oNewItem.getMarke();
        if (!GlobalObjects.getInstance().getSessionInfo().getDMSVerwenden()) {
            return true;
        }
        if (sID != null && sID.equals(Resource.getInstance().getAndereListe())) {
            return true;
        }
        String sNewFIString = DlgTeilelisteController.ermittleFIStringZuAuftragZugeordnet(oNewItem);
        String sMsg = "";
        if (sNewFIString != null) {
            Object[] arguments = new Object[]{sNewFIString};
            sMsg = MessageFormat.format(Resource.getInstance().getAskTeilelisteWechselnMitAuftrag(), arguments);
        } else {
            sMsg = Resource.getInstance().getAskTeilelisteWechselnOhneAuftrag();
            String sOldFIString = DlgTeilelisteController.ermittleFIStringZuAuftragZugeordnet(oOldItem);
            if (sOldFIString != null) {
                sMsg = Resource.getInstance().getAskTeilelisteWechselnOhneAuftrag();
            } else {
                LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
                oLoginInfo.setAktuelleTeileliste(new ComboTeilelisteItem(sID, sID, sEigentuemer, sFiliale, sMarke));
                return true;
            }
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        int nRet = JOptionPane.showConfirmDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeileliste(), 0);
        if (nRet == 0) {
            LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
            oLoginInfo.setAktuelleTeileliste(new ComboTeilelisteItem(sID, sID, sEigentuemer, sFiliale, sMarke));
            return true;
        }
        return false;
    }

    protected static String ermittleFIStringZuAuftragZugeordnet(ComboTeilelisteItem oItem) {
        String sID = oItem.getID();
        String sEigentuemer = oItem.getEigentuemer();
        if (sID == null || sID.length() < 1 || sID.equals(Resource.getInstance().getNeueListe()) || sID.equals(Resource.getInstance().getAndereListe()) || Constants.Bestellliste.isBestellliste(sID)) {
            return null;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teilelisteid", sID);
        trfTL.setValue("eigentuemer", sEigentuemer);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.LOAD_TEILELISTE);
        }
        catch (CommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLadenTeileliste() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getTeileliste(), 0);
            return null;
        }
        if (trfTL.getError() != null) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLadenTeileliste() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getTeileliste(), 0);
            return null;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        Teileliste oTeileliste = (Teileliste)trfTL.getValue("teileliste");
        Auftrag oAuftrag = oTeileliste.getAuftrag();
        if (oAuftrag != null) {
            return oTeileliste.getFzgIdString();
        }
        return null;
    }

    protected void handleRabatt(String sRabatt) {
        if (sRabatt.length() > 0) {
            Teileliste oTL = this.model.getTLDaten();
            if (oTL == null) {
                return;
            }
            Vector<webetk.app.teileliste.Teil> cTeile = oTL.getTeile();
            if (cTeile == null) {
                return;
            }
            for (webetk.app.teileliste.Teil oTeil : cTeile) {
                oTeil.setRabatt(sRabatt);
                oTeil.setUpdate(true);
            }
            DlgTeilelisteController.saveTeile(this.model.getSelTLID(), cTeile);
            if (this.view != null) {
                this.view.update();
            }
        }
    }

    protected static void saveTeile(String sListenID, Collection<webetk.app.teileliste.Teil> cTeile) {
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teilelisteid", sListenID);
        trfTL.setValue("teile", cTeile);
        try {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.TEILELISTE_SAVE_TEIL);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (CommunicationException e) {
            log.error((Object)("EditTeileliste: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return;
        }
        if (trfTL.getError() != null) {
            String sMsg = "";
            Exception e = trfTL.getError();
            sMsg = e instanceof NoDataFoundException ? Resource.getInstance().getTeilNichtGefundenZuSachnummer() : Resource.getInstance().getSonstigerFehler() + ": " + trfTL.getError().getMessage();
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTL.getError());
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeilelisteBearbeiten(), 0);
        }
    }

    protected void handleDatenAbgleich() {
        this.doDatenAbgleich(true);
        if (this.view != null) {
            this.view.update();
        }
    }

    protected void doDatenAbgleich(boolean bFull) {
        Collection cNewParts = this.model.getNewParts();
        if (!(cNewParts != null && cNewParts.size() <= 1 || this.model.getTeile() != null && !this.model.getTeile().isEmpty())) {
            return;
        }
        String sAuftragsNr = null;
        String sKundenNr = null;
        boolean bDms = bFull;
        if (!bDms) {
            bDms = this.ermittleDatenabgleichImmer();
        }
        if (bDms && this.model.istDMSAngeschlossen()) {
            if (this.model.getTLDaten().getAuftrag() != null) {
                sAuftragsNr = this.model.getTLDaten().getAuftragsNr();
            } else {
                if (this.model.getTLDaten().getAuftragsNrLokal() != null && this.model.getTLDaten().getAuftragsNrLokal().length() > 0) {
                    sAuftragsNr = this.model.getTLDaten().getAuftragsNrLokal();
                }
                if (this.model.getTLDaten().getKundenNrLokal() != null) {
                    sKundenNr = this.model.getTLDaten().getKundenNrLokal().toString();
                }
                if (!(sAuftragsNr != null && !this.model.getTLDaten().getAuftragsNrLokal().equals("0") || sKundenNr != null && this.model.getTLDaten().getKundenNrLokal() != 0L)) {
                    HashMap<String, Object> mapRetVal = new HashMap<String, Object>();
                    AuftragsNr dlg = new AuftragsNr(mapRetVal);
                    dlg.setVisible(true);
                    Integer nRet = (Integer)mapRetVal.get(RET);
                    if (nRet != 0) {
                        return;
                    }
                    sAuftragsNr = (String)mapRetVal.get("AuftragsNr");
                    this.model.getTLDaten().setAuftragsNrLokal(sAuftragsNr);
                    sKundenNr = (String)mapRetVal.get("KundenNr");
                    if (sKundenNr != null && sKundenNr.length() > 0) {
                        this.model.getTLDaten().setKundenNrLokal(Long.valueOf(sKundenNr));
                    } else {
                        this.model.getTLDaten().setKundenNrLokal(null);
                    }
                    this.model.setKopfdatenGeaendert(true);
                }
            }
        }
        if (sAuftragsNr != null && !StringUtils.isNMToken(sAuftragsNr)) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getWrongFormatNmtoken(), Resource.getInstance().getAuftragsnummer(), 0);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("eigentuemer", this.model.getTLDaten().getNutzerID());
        trfTL.setValue("filialid", this.model.getTLDaten().getFiliale());
        if (cNewParts != null) {
            trfTL.setValue("teile", cNewParts);
            trfTL.setValue("marke", this.model.getTLDaten().getMarke());
        } else {
            trfTL.setValue("teileliste", this.model.getTLDaten());
        }
        if (sAuftragsNr != null) {
            trfTL.setValue("auftragsnr", sAuftragsNr);
        }
        if (sKundenNr != null) {
            trfTL.setValue("kundennr", sKundenNr);
        }
        trfTL.setValue("datenabgleich_full", bFull);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.DO_DATENABGLEICH);
        }
        catch (CommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), ex.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return;
        }
        if (!DmsUtils.showMsgTxt((String)trfTL.getValue("msgtxt"), trfTL.getError())) {
            return;
        }
        if (cNewParts == null) {
            Teileliste oTL = (Teileliste)trfTL.getValue("teileliste");
            String sAuftragsNrOld = this.model.getTLDaten().getAuftragsNrLokal();
            String sAuftragsNrNew = oTL.getAuftragsNrLokal();
            if (sAuftragsNrOld == null) {
                sAuftragsNrOld = "";
            }
            if (sAuftragsNrNew == null) {
                sAuftragsNrNew = "";
            }
            Long lKundenNrOld = this.model.getTLDaten().getKundenNrLokal();
            Long lKundenNrNew = oTL.getKundenNrLokal();
            if (lKundenNrOld == null) {
                lKundenNrOld = 0L;
            }
            if (lKundenNrNew == null) {
                lKundenNrNew = 0L;
            }
            if (!sAuftragsNrOld.equals(sAuftragsNrNew) || !lKundenNrOld.equals(lKundenNrNew)) {
                this.model.setKopfdatenGeaendert(true);
            }
            this.model.setTLDaten(oTL);
        } else {
            cNewParts = (Collection)trfTL.getValue("teile");
            this.model.setNewParts(cNewParts);
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected static Scoreliste doDatenAbgleich(Scoreliste liste) {
        if (liste == null || liste.getTeile() == null || liste.getTeile().isEmpty()) {
            return liste;
        }
        Long lKundenNr = liste.getKundenNrLokal();
        String sKundenNr = null;
        if (lKundenNr != null) {
            sKundenNr = lKundenNr.toString();
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("eigentuemer", liste.getNutzerID());
        trfTL.setValue("filialid", liste.getFiliale());
        trfTL.setValue("scoreliste", liste);
        if (sKundenNr != null) {
            trfTL.setValue("kundennr", sKundenNr);
        }
        trfTL.setValue("datenabgleich_full", true);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.DO_DATENABGLEICH);
        }
        catch (CommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), ex.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return liste;
        }
        if (trfTL.getError() != null) {
            Exception ex = trfTL.getError();
            if (ex instanceof DMSException) {
                StringBuffer sMsg = new StringBuffer(Resource.getInstance().getFehlerDmsAbgleich() + ".\n");
                sMsg.append(Resource.getInstance().getMsgPosOhneDatenabgleich() + "\n");
                DMSException exDms = (DMSException)ex;
                Collection aTeilenummern = exDms.getTeilenummern();
                Collection aPos = exDms.getPositionen();
                Collection aRetcodes = exDms.getRetCodes();
                if (aTeilenummern != null && aRetcodes != null) {
                    Iterator iTeilenummern = aTeilenummern.iterator();
                    Iterator iPos = aPos.iterator();
                    Iterator iRetcodes = aRetcodes.iterator();
                    while (iTeilenummern.hasNext() && iRetcodes.hasNext()) {
                        String sTeilenummer = (String)iTeilenummern.next();
                        String sPos = ((Integer)iPos.next()).toString();
                        int nStatus = (Integer)iRetcodes.next();
                        sMsg.append(sPos + ":    " + sTeilenummer + ":    " + Resource.getInstance().getDmsFehlerText(nStatus) + "\n");
                    }
                } else {
                    int nStatus = Integer.parseInt(ex.getMessage());
                    sMsg.append(Resource.getInstance().getDmsFehlerText(nStatus));
                }
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), sMsg.toString(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            } else {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + ex.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
                return liste;
            }
        }
        liste = (Scoreliste)trfTL.getValue("scoreliste");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return liste;
    }

    protected boolean ermittleDatenabgleichImmer() {
        Konfiguration oKonfig = this.getKonfiguration();
        return oKonfig.getDatenabgleich() != null && oKonfig.getDatenabgleich().equals("I");
    }

    protected boolean checkPflichtfelderDMSSenden() {
        if (this.model.getTeile().isEmpty()) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getEmptyListNoSend(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return false;
        }
        return true;
    }

    protected boolean checkPflichtfelderStammsatzDMS(webetk.app.teileliste.Teil oTeil) {
        if (oTeil.getTeilenummer().length() < 1) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getNoTeilenummer(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return false;
        }
        if (oTeil.getBenennung().length() < 1) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getNoBenennung(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return false;
        }
        return true;
    }

    protected String getHaendlernummer() {
        String sProduktart = GlobalObjects.getInstance().getSessionInfo().getProdukart();
        if (sProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            return this.getKonfiguration().getHaendlernummerPKW();
        }
        return this.getKonfiguration().getHaendlernummerMotorrad();
    }

    protected String incrementRechungsnummer() {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.INCREMENT_RECHUNGSNUMMER);
        }
        catch (CommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), ex.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return "";
        }
        if (trfTL.getError() != null) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerRechnungsnummer() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return "";
        }
        String sRechungsnummer = (String)trfTL.getValue("rechnungsnummer");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return sRechungsnummer;
    }

    protected void handleExportDateischnittstelle() {
        String sFileName = null;
        String sHeaderDatenRead = null;
        if (this.model.getEpcAction() != null && (this.model.getEpcAction().equals("SEARCH_1") || this.model.getEpcAction().equals("NO_DATA"))) {
            sFileName = this.model.getEpcFile();
        }
        if (!(sFileName != null || this.model.getEpcAction() != null && this.model.getEpcAction().equals("NO_FILE"))) {
            sFileName = GlobalObjects.getInstance().getEtkData().getDateischnittstelleDefaultFilename();
        }
        if (this.model.getEpcAction() != null && this.model.getEpcAction().equals("SEARCH_1")) {
            try {
                FileReader filereader = new FileReader(sFileName);
                char[] cBuff = new char[324];
                filereader.read(cBuff);
                filereader.close();
                sHeaderDatenRead = new String(cBuff);
                sFileName = sHeaderDatenRead.substring(24, 152).trim();
            }
            catch (Exception ex) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + " EPC Export" + ex.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
                return;
            }
        }
        if ((sFileName = (String)JOptionPane.showInputDialog(MainView.getInstance(), Resource.getInstance().getAskAusgabedateiName(), Resource.getInstance().getTeileliste(), 3, null, null, sFileName)) == null) {
            return;
        }
        try {
            FileWriter filewriter = new FileWriter(sFileName);
            String sHeaderDatenWrite = this.formatiereHeaderDatenDateischnittstelle(sHeaderDatenRead, sFileName);
            filewriter.write(sHeaderDatenWrite);
            Vector<webetk.app.teileliste.Teil> cTeile = this.model.getTeile();
            Teileliste oTeileliste = this.model.getTLDaten();
            String sMarkeTeileliste = null;
            if (oTeileliste != null) {
                sMarkeTeileliste = oTeileliste.getMarke();
            }
            String sDaten = DlgTeilelisteController.formatiereDatenDateischnittstelle(sMarkeTeileliste, cTeile);
            filewriter.write(sDaten);
            filewriter.close();
        }
        catch (Exception ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + " " + ex.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
        }
    }

    protected void handleExport() {
        Teileliste oTeileliste = this.model.getTLDaten();
        String sFileName = null;
        String sTitle = Resource.getInstance().getSpeichernAlsTxtFile();
        DirectoryChooserDialog dirDlg = new DirectoryChooserDialog(MainView.getInstance(), sTitle, null, false);
        dirDlg.setVisible(true);
        int returnVal = dirDlg.getRetVal();
        if (returnVal != 0) {
            return;
        }
        sFileName = dirDlg.getDirectory();
        String sListeId = oTeileliste.getID();
        sListeId = StringUtils.substituteStringStraight(sListeId, "/", "_");
        sListeId = StringUtils.substituteStringStraight(sListeId, "\\", "_");
        sFileName = sFileName + File.separator + sListeId + ".txt";
        try {
            int nRet;
            File fileTest = new File(sFileName);
            if (fileTest.exists() && (nRet = JOptionPane.showConfirmDialog(null, Resource.getInstance().getMsgAskDateiUeberschreiben(), sTitle, 0)) != 0) {
                return;
            }
            FileOutputStream fos = new FileOutputStream(sFileName);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            BufferedWriter filewriter = new BufferedWriter(osw);
            this.writeHeaderDatenExport(filewriter, oTeileliste);
            Vector<webetk.app.teileliste.Teil> cTeile = this.model.getTeile();
            DlgTeilelisteController.writeDatenExport(filewriter, cTeile);
            filewriter.close();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + " " + ex.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
        }
    }

    protected void handleImport() {
        String sFileName = null;
        String sTitle = Resource.getInstance().getOeffnenAlsTxtFile();
        DirectoryChooserDialog dirDlg = new DirectoryChooserDialog(MainView.getInstance(), sTitle, null, true);
        dirDlg.setVisible(true);
        int returnVal = dirDlg.getRetVal();
        if (returnVal != 0) {
            return;
        }
        sFileName = dirDlg.getDirectory();
        try {
            FileInputStream fis = new FileInputStream(sFileName);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader in = new BufferedReader(isr);
            Teileliste oTL = this.readHeaderDatenImport(in);
            this.model.setTLDaten(oTL);
            Vector<webetk.app.teileliste.Teil> cTeile = DlgTeilelisteController.readDatenImport(in);
            oTL.setTeile(cTeile);
            in.close();
            int nRetVal = this.saveNewTeileliste(oTL);
            if (nRetVal == 1) {
                HashMap<String, Object> mapRetVal = new HashMap<String, Object>();
                NewListe dlg = new NewListe(MainView.getInstance(), oTL.getMarke(), oTL.getID(), oTL.getBemerkung(), oTL.getPrivat(), mapRetVal);
                dlg.setVisible(true);
                Integer nRet = (Integer)mapRetVal.get(RET);
                if (nRet == null || nRet != 0) {
                    return;
                }
                Teileliste oNewTL = (Teileliste)mapRetVal.get("tl");
                oTL.setID(oNewTL.getID());
                oTL.setLanguage(oNewTL.getLanguage());
                oTL.setPrivat(oNewTL.getPrivat());
                oTL.setBemerkung(oNewTL.getBemerkung());
                oTL.setAuftragsNrLokal(oNewTL.getAuftragsNrLokal());
                oTL.setKundenNrLokal(oNewTL.getKundenNrLokal());
                oTL.setDatErstellung(oNewTL.getDatErstellung());
                oTL.setDatAenderung(oNewTL.getDatErstellung());
            } else if (nRetVal == 2) {
                return;
            }
            LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
            oTL.setNutzerID(oLoginInfo.getLogin());
            oTL.setFiliale(oLoginInfo.getFilialeId());
            ComboTeilelisteItem item = new ComboTeilelisteItem(oTL.getID(), oTL.getID(), oTL.getNutzerID(), oTL.getFiliale(), oTL.getMarke());
            Vector<ComboTeilelisteItem> aTL = this.model.getTLZurAuswahl();
            aTL.add(item);
            this.model.setSelTL(item);
            DlgTeilelisteController.saveTeile(oTL.getID(), cTeile);
            this.view.update();
        }
        catch (StringIndexOutOfBoundsException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getMsgNoTeilelisteDatei(), Resource.getInstance().getSonstigerFehler(), 0);
        }
        catch (Exception ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + " " + ex.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
        }
    }

    protected int saveNewTeileliste(Teileliste oTL) {
        log.debug((Object)"Performing saveTeileliste");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teilelistenewid", oTL.getID());
        trfTL.setValue("marke", oTL.getMarke());
        trfTL.setValue("teilelistebemerkung", oTL.getBemerkung());
        trfTL.setValue("privat", oTL.getPrivat());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.SAVE_TEILELISTE_KOPFDATEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("NewTeileliste: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), ex.getMessage(), Resource.getInstance().getOeffnenAlsTxtFile(), 0);
            return 2;
        }
        if (trfTL.getError() != null) {
            int nRet = 2;
            Exception e = trfTL.getError();
            String sMsg = null;
            if (trfTL.getError() instanceof DuplicateValueException) {
                sMsg = Resource.getInstance().getTeilelisteDoppelteId();
                nRet = 1;
            } else {
                sMsg = Resource.getInstance().getSonstigerFehler() + ": " + e.getMessage();
            }
            log.error((Object)sMsg);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getOeffnenAlsTxtFile(), 0);
            return nRet;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        Teileliste oNewTL = (Teileliste)trfTL.getValue("teileliste");
        oTL.setID(oNewTL.getID());
        oTL.setLanguage(oNewTL.getLanguage());
        oTL.setPrivat(oNewTL.getPrivat());
        oTL.setBemerkung(oNewTL.getBemerkung());
        oTL.setAuftragsNrLokal(oNewTL.getAuftragsNrLokal());
        oTL.setKundenNrLokal(oNewTL.getKundenNrLokal());
        oTL.setDatErstellung(oNewTL.getDatErstellung());
        oTL.setDatAenderung(oNewTL.getDatErstellung());
        return 0;
    }

    public void handleDMSDirect() {
        try {
            String sDirname;
            File dir;
            int nInd;
            String sFilename = this.model.getUSSchnittstelleFilename();
            if (sFilename != null && (nInd = sFilename.lastIndexOf(File.separator)) > 0 && !(dir = new File(sDirname = sFilename.substring(0, nInd))).exists() && !dir.mkdirs()) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + " mkdirs returned false", Resource.getInstance().getSonstigerFehler(), 0);
            }
            FileWriter filewriter = new FileWriter(sFilename);
            Vector<webetk.app.teileliste.Teil> cTeile = this.model.getTeile();
            String sMarke = this.model.getSelTLMarke();
            String sDaten = this.formatiereDatenUSSchnittstelle(sMarke, cTeile);
            filewriter.write(sDaten);
            filewriter.close();
            if (Marken.getInstance().getEigenschaften("marke.usListenIds").contains(this.model.getSelTLID())) {
                this.handleDeleteTeile(cTeile);
            }
        }
        catch (Exception ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + " " + ex.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
        }
    }

    public void handleSendAs2() {
        log.debug((Object)("sendAs2: " + this.model.getSelTLID()));
        As2ClientScore.getInstance().sendAs2(this.model.getSelTLID());
    }

    protected static String formatiereDatenDateischnittstelle(String sMarkeTeileliste, Collection<webetk.app.teileliste.Teil> cTeile) {
        String sRet = "";
        for (webetk.app.teileliste.Teil objTeil : cTeile) {
            Teileinfo oTI = DlgTeilelisteController.ladeTeileinfo(objTeil.getSachnummer());
            webetk.app.teileliste.Teil oKI = DlgTeilelisteController.loadKommerzielleInfo(oTI);
            sRet = sRet + DlgTeilelisteController.addSpaces(objTeil.getTeilenummer(), 11);
            sRet = sRet + DlgTeilelisteController.addSpaces(objTeil.getBenennung(), 50);
            sRet = sRet + DlgTeilelisteController.addSpaces(objTeil.getZusatz(), 15);
            sRet = sRet + DlgTeilelisteController.addSpaces(oTI.getAustausch(), 11);
            sRet = sRet + DlgTeilelisteController.addSpaces(WebetkUtils.getPriceString(oKI.getNachbelastungspauschale()), 12);
            String sTNrAltGespreizt = oTI.getTeilenrAlt();
            String sTNrAlt = "";
            for (int ii = 0; ii < sTNrAltGespreizt.length(); ++ii) {
                if (sTNrAltGespreizt.charAt(ii) == ' ') continue;
                sTNrAlt = sTNrAlt + sTNrAltGespreizt.charAt(ii);
            }
            sRet = sRet + DlgTeilelisteController.addSpaces(sTNrAlt, 11);
            sRet = sRet + DlgTeilelisteController.addSpaces(oTI.getAustauschbar(), 5);
            sRet = sRet + DlgTeilelisteController.addSpaces(objTeil.getTeileart(), 5);
            sRet = sRet + DlgTeilelisteController.addSpaces(objTeil.getMenge(), 8);
            sRet = sRet + DlgTeilelisteController.addSpaces(objTeil.getMengenEinheit(), 5);
            sRet = sRet + DlgTeilelisteController.addSpaces(oTI.getProduktklasse(), 5);
            sRet = sRet + DlgTeilelisteController.addSpaces(oTI.getRundungsKZ(), 5);
            sRet = sRet + DlgTeilelisteController.addSpaces(objTeil.getRuecksendepflicht(), 5);
            sRet = sRet + DlgTeilelisteController.addSpaces(WebetkUtils.getPriceString(objTeil.ermittleNetto()), 12);
            sRet = sRet + DlgTeilelisteController.addSpaces(WebetkUtils.getPriceString(objTeil.ermittleMwStOhneAT()), 12);
            sRet = sRet + DlgTeilelisteController.addSpaces(WebetkUtils.getPriceString(objTeil.getPreis()), 15);
            sRet = sRet + DlgTeilelisteController.addSpaces(objTeil.getRabattSchluessel(), 5);
            sRet = sRet + DlgTeilelisteController.addSpaces(objTeil.getPreisaenderKZ(), 5);
            sRet = sRet + DlgTeilelisteController.addSpaces(objTeil.getSonderpreisKZ(), 5);
            sRet = sRet + DlgTeilelisteController.addSpaces("", 5);
            sRet = sRet + DlgTeilelisteController.addSpaces(Integer.toString(objTeil.getVVM()), 10);
            sRet = sRet + DlgTeilelisteController.addSpaces(Integer.toString(objTeil.getLVM()), 10);
            sRet = sRet + DlgTeilelisteController.addSpaces(Integer.toString(objTeil.getBVM()), 10);
            sRet = sRet + DlgTeilelisteController.addSpaces(oTI.getGewicht(), 11);
            sRet = sRet + DlgTeilelisteController.addSpaces("", 22);
            Vector<String> aMarke = oTI.getMarken();
            String sMarke = GlobalObjects.getInstance().getEtkData().getMarkeTeilRepraesentant(aMarke, sMarkeTeileliste);
            sMarke = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sMarke, "marke.dateiSchnittstelle", null);
            sRet = sRet + DlgTeilelisteController.addSpaces(sMarke, 3);
        }
        return sRet;
    }

    protected String formatiereHeaderDatenDateischnittstelle(String sHeaderDatenRead, String sFileName) {
        String sRet = "";
        sRet = sRet + DlgTeilelisteController.addSpaces("BMW-DOS-ETK-Transferfile", 24);
        sRet = sRet + DlgTeilelisteController.addSpaces(sFileName, 128);
        sRet = sRet + DlgTeilelisteController.addSpaces("3.0", 3);
        sRet = sRet + DlgTeilelisteController.addNullen(Integer.toString(this.model.getTeile().size()), 7);
        sRet = sHeaderDatenRead != null ? sRet + sHeaderDatenRead.substring(162, 192) : sRet + DlgTeilelisteController.addSpaces(null, 30);
        JavaFzgIdInfo oFI = GlobalObjects.getInstance().getFzgIdInfo();
        if (oFI != null) {
            sRet = sRet + DlgTeilelisteController.addSpaces(oFI.getFahrgestellNr(), 7);
            sRet = oFI.getProduktart().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung()) ? sRet + DlgTeilelisteController.addSpaces("E", 10) : sRet + DlgTeilelisteController.addSpaces("R", 10);
            sRet = sRet + DlgTeilelisteController.addSpaces(oFI.getRegion().substring(0, 1), 10);
            sRet = sRet + DlgTeilelisteController.addSpaces(oFI.getBaureihe(), 30);
            sRet = sRet + DlgTeilelisteController.addSpaces(oFI.getModell(), 10);
            sRet = oFI.getBaujahr().equals("AlleWerte") ? sRet + DlgTeilelisteController.addSpaces(null, 10) : sRet + DlgTeilelisteController.addSpaces(oFI.getBaujahr(), 10);
            sRet = oFI.getZulMonat().equals("AlleWerte") ? sRet + DlgTeilelisteController.addSpaces(null, 10) : sRet + DlgTeilelisteController.addSpaces(oFI.getZulMonat(), 10);
            sRet = oFI.getGetriebe() == null || oFI.getGetriebe().equals("AlleWerte") ? sRet + DlgTeilelisteController.addSpaces(null, 10) : sRet + DlgTeilelisteController.addSpaces(oFI.getGetriebe(), 10);
            sRet = oFI.getLenkung() == null || oFI.getLenkung().equals("AlleWerte") ? sRet + DlgTeilelisteController.addSpaces(null, 10) : sRet + DlgTeilelisteController.addSpaces(oFI.getLenkung(), 10);
        } else {
            sRet = sRet + DlgTeilelisteController.addSpaces(null, 107);
        }
        sRet = sHeaderDatenRead != null ? sRet + sHeaderDatenRead.substring(299, 321) : sRet + DlgTeilelisteController.addSpaces(null, 22);
        String sMarke = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", this.model.getTLDaten().getMarke(), "marke.dateiSchnittstelle", null);
        sRet = sRet + DlgTeilelisteController.addSpaces(sMarke, 3);
        return sRet;
    }

    protected void writeHeaderDatenExport(BufferedWriter filewriter, Teileliste oTL) throws IOException {
        String sRet = "";
        sRet = sRet + oTL.getID() + ";";
        sRet = sRet + oTL.getMarke() + ";";
        sRet = sRet + oTL.getBemerkung() + ";";
        sRet = oTL.getPrivat() ? sRet + "J;" : sRet + "N;";
        sRet = sRet + "\r\n";
        filewriter.write(sRet);
    }

    protected Teileliste readHeaderDatenImport(BufferedReader in) throws IOException {
        Teileliste oTL = new Teileliste();
        String szLine = in.readLine();
        if (szLine != null) {
            StringBuffer sLineBuffer = new StringBuffer(szLine);
            oTL.setID(DlgTeilelisteController.parseLine(sLineBuffer));
            oTL.setMarke(DlgTeilelisteController.parseLine(sLineBuffer));
            oTL.setBemerkung(DlgTeilelisteController.parseLine(sLineBuffer));
            String sValue = DlgTeilelisteController.parseLine(sLineBuffer);
            oTL.setPrivat(sValue.equals("J"));
        }
        return oTL;
    }

    protected static String parseLine(StringBuffer szLine) {
        return DlgTeilelisteController.parseLine(szLine, ";");
    }

    protected static String parseLine(StringBuffer szLine, String szSeparator) {
        String sRet = null;
        String sRest = null;
        int nInd = szLine.indexOf(szSeparator);
        sRet = szLine.substring(0, nInd);
        sRest = szLine.substring(nInd + 1);
        szLine.delete(0, szLine.length());
        szLine.append(sRest);
        return sRet;
    }

    protected static void writeDatenExport(BufferedWriter filewriter, Collection<webetk.app.teileliste.Teil> cTeile) throws IOException {
        Iterator<webetk.app.teileliste.Teil> iteratorTeile = cTeile.iterator();
        while (iteratorTeile.hasNext()) {
            String sRet = "";
            webetk.app.teileliste.Teil objTeil = iteratorTeile.next();
            sRet = sRet + objTeil.getPos() + ";";
            sRet = objTeil.getLokalteil() ? sRet + "J;" : sRet + "N;";
            sRet = sRet + objTeil.getTeilenummer() + ";";
            Vector<String> cMarken = objTeil.getMarken();
            Iterator iter = cMarken.iterator();
            String sValue = (String)iter.next();
            sRet = sRet + sValue + ";";
            sRet = sRet + objTeil.getBenennung() + ";";
            sRet = sRet + objTeil.getZusatz() + ";";
            sRet = sRet + objTeil.getMenge() + ";";
            sRet = sRet + objTeil.getPreis() + ";";
            sValue = objTeil.getBemerkung();
            if (sValue == null) {
                sValue = "";
            }
            sRet = sRet + sValue + ";";
            sValue = objTeil.getRuecksendepflicht();
            if (sValue == null) {
                sValue = "";
            }
            sRet = sRet + sValue.trim() + ";";
            sValue = objTeil.getFertigungshinweis();
            if (sValue == null) {
                sValue = "";
            }
            sRet = sRet + sValue + ";";
            sValue = objTeil.getFIString();
            if (sValue == null) {
                sValue = "";
            }
            sRet = sRet + sValue + ";";
            sRet = sRet + "\r\n";
            filewriter.write(sRet);
        }
    }

    protected static Vector<webetk.app.teileliste.Teil> readDatenImport(BufferedReader in) throws IOException {
        Vector<webetk.app.teileliste.Teil> cTeile = new Vector<webetk.app.teileliste.Teil>();
        String szLine = in.readLine();
        while (szLine != null) {
            StringBuffer sLineBuffer = new StringBuffer(szLine);
            webetk.app.teileliste.Teil objTeil = new webetk.app.teileliste.Teil();
            objTeil.setPos(Integer.parseInt(DlgTeilelisteController.parseLine(sLineBuffer)));
            String sValue = DlgTeilelisteController.parseLine(sLineBuffer);
            objTeil.setLokalteil(sValue.equals("J"));
            String sTeilenummer = DlgTeilelisteController.parseLine(sLineBuffer);
            objTeil.setHG(sTeilenummer.substring(0, 2));
            objTeil.setUG(sTeilenummer.substring(2, 4));
            objTeil.setSachnummer(sTeilenummer.substring(4, 11));
            sValue = DlgTeilelisteController.parseLine(sLineBuffer);
            Vector<String> aMarken = new Vector<String>();
            aMarken.add(sValue);
            objTeil.setMarken(aMarken);
            objTeil.setBenennung(DlgTeilelisteController.parseLine(sLineBuffer));
            objTeil.setZusatz(DlgTeilelisteController.parseLine(sLineBuffer));
            objTeil.setMenge(DlgTeilelisteController.parseLine(sLineBuffer));
            objTeil.setPreis(Double.parseDouble(DlgTeilelisteController.parseLine(sLineBuffer)));
            objTeil.setBemerkung(DlgTeilelisteController.parseLine(sLineBuffer));
            objTeil.setRuecksendepflicht(DlgTeilelisteController.parseLine(sLineBuffer));
            objTeil.setFertigungshinweis(DlgTeilelisteController.parseLine(sLineBuffer));
            sValue = DlgTeilelisteController.parseLine(sLineBuffer);
            if (sValue.length() == 0) {
                sValue = null;
            }
            objTeil.setFIString(sValue);
            objTeil.setInsert(true);
            cTeile.add(objTeil);
            szLine = in.readLine();
        }
        return cTeile;
    }

    protected String formatiereDatenUSSchnittstelle(String sMarke, Collection<webetk.app.teileliste.Teil> cTeile) {
        String sRet = "";
        sRet = sRet + "PP.IDENT:";
        sRet = sRet + Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sMarke, "marke.USDMSSchnittstelle", Marken.getInstance().getMarke("BMW").getUSDMS()) + ",";
        sRet = sRet + "\"GROUP EPC 1.0\",";
        sRet = sRet + "BM1.2,";
        Calendar rightNow = Calendar.getInstance();
        Date datToday = rightNow.getTime();
        long lDate = WebetkUtils.getLongFromDate(datToday);
        sRet = sRet + Long.toString(lDate) + ",";
        long lTime = WebetkUtils.getLongFromTime(datToday);
        sRet = sRet + Long.toString(lTime) + ",";
        sRet = sRet + this.getHaendlernummer() + ",";
        sRet = sRet + ",";
        sRet = sRet + ",";
        sRet = sRet + ",";
        sRet = sRet + ",";
        sRet = sRet + "";
        sRet = sRet + "\r\n";
        for (webetk.app.teileliste.Teil objTeil : cTeile) {
            sRet = sRet + "PP.LINEITEM:";
            sRet = sRet + objTeil.getTeilenummer() + ",";
            String sMenge = objTeil.getMenge();
            int nIndKomma = sMenge.indexOf(".");
            if (nIndKomma > -1) {
                sMenge = sMenge.substring(0, nIndKomma);
            }
            if ((nIndKomma = sMenge.indexOf(",")) > -1) {
                sMenge = sMenge.substring(0, nIndKomma);
            }
            sRet = sRet + sMenge + ",";
            sRet = sRet + ",";
            sRet = sRet + "\"" + objTeil.getBenennung() + "\"" + ",";
            sRet = sRet + ",";
            sRet = sRet + "";
            sRet = sRet + "\r\n";
        }
        return sRet;
    }

    protected static Teileinfo ladeTeileinfo(String sSachnummer) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfHashMap = new TrfHashMap(null);
        trfHashMap.setValue("sachnummer", sSachnummer);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHashMap, Command.LOAD_TEILEINFO);
        }
        catch (CommunicationException ex) {
            log.error((Object)("loadTeileinfo: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return new Teileinfo();
        }
        if (trfHashMap.getError() != null) {
            String sMsg = "";
            if (trfHashMap.getError() instanceof NoDataFoundException) {
                sMsg = Resource.getInstance().getTeilNichtGefundenZuSuchkriterium();
                log.info((Object)sMsg);
            } else {
                sMsg = Resource.getInstance().getFehlerLadeTeileinfo() + ": " + trfHashMap.getError().getMessage();
                log.error((Object)sMsg);
            }
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeilelisteBearbeiten(), 0);
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return (Teileinfo)trfHashMap.getValue("teileinfo");
    }

    protected static webetk.app.teileliste.Teil loadKommerzielleInfo(Teileinfo oTI) {
        if (oTI.getSachnummer().length() < 1) {
            return new webetk.app.teileliste.Teil();
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfHashMap = new TrfHashMap(null);
        webetk.app.teileliste.Teil oTeil = new webetk.app.teileliste.Teil(oTI.getSachnummer());
        oTeil.setHG(oTI.getHg());
        oTeil.setUG(oTI.getUg());
        oTeil.setMarken(oTI.getMarken());
        oTeil.setTeileart(oTI.getTeileart());
        trfHashMap.setValue("teil", oTeil);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHashMap, Command.LOAD_KOMMERZIELLE_INFO);
        }
        catch (CommunicationException ex) {
            log.error((Object)("loadKommerzielleInfo: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return oTeil;
        }
        if (trfHashMap.getError() != null) {
            String sMsg = "";
            sMsg = Resource.getInstance().getFehlerLadeTeileinfo() + ": " + trfHashMap.getError().getMessage();
            log.error((Object)sMsg);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeilelisteBearbeiten(), 0);
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        oTeil = (webetk.app.teileliste.Teil)trfHashMap.getValue("teil");
        return oTeil;
    }

    protected static String addSpaces(String sOldString, int nFeldlaenge) {
        int nStart;
        String sNewString = sOldString;
        if (sNewString == null) {
            sNewString = "";
        }
        for (int ii = nStart = sNewString.length(); ii < nFeldlaenge; ++ii) {
            sNewString = sNewString + " ";
        }
        if (sNewString.length() > nFeldlaenge) {
            sNewString = sNewString.substring(0, nFeldlaenge);
        }
        return sNewString;
    }

    protected static String addNullen(String sOldString, int nFeldlaenge) {
        int nStart;
        String sNewString = "";
        if (sOldString == null) {
            for (int ii = 0; ii < nFeldlaenge; ++ii) {
                sNewString = sNewString + "0";
            }
            return sNewString;
        }
        for (int ii = nStart = sOldString.length(); ii < nFeldlaenge; ++ii) {
            sNewString = sNewString + "0";
        }
        if ((sNewString = sNewString + sOldString).length() > nFeldlaenge) {
            sNewString = sNewString.substring(0, nFeldlaenge);
        }
        return sNewString;
    }

    protected void ladeSendeinfo() {
        Teileliste oTL = this.model.getTLDaten();
        if (oTL == null) {
            return;
        }
        TrfTeileliste trf = new TrfTeileliste(null);
        trf.setValue("teilelisteid", oTL.getID());
        trf.setValue("eigentuemer", oTL.getNutzerID());
        trf.setValue("filialid", oTL.getFiliale());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.LOAD_SENDEINFO);
        }
        catch (CommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + ex.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
            return;
        }
        if (trf.getError() != null) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + trf.getError().getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
            return;
        }
        this.model.setSendeArt((String)trf.getValue("art"));
        this.model.setAuftragsNr((String)trf.getValue("auftragsnr"));
        this.model.setKundenNr((String)trf.getValue("kundennr"));
        this.model.setMitarbeiterNr((String)trf.getValue("bearbeiter"));
        String sGreiferschein = (String)trf.getValue("greiferschein");
        this.model.setGreiferschein(sGreiferschein != null && sGreiferschein.equals("J"));
        String sRechnung = (String)trf.getValue("rechnung");
        this.model.setRechnung(sRechnung != null && sRechnung.equals("J"));
        String sLieferschein = (String)trf.getValue("lieferschein");
        this.model.setLieferschein(sLieferschein != null && sLieferschein.equals("J"));
        this.model.setFreitext((String)trf.getValue("freitext"));
        this.model.setPasswort((String)trf.getValue("pwd"));
        this.model.setSondersteuerung((String)trf.getValue("sondersteuerung"));
        this.model.setBar((String)trf.getValue("bar"));
        this.model.setUnbar((String)trf.getValue("unbar"));
    }

    public void zurueckZurBildtafel() {
        boolean bAufrufAusWorkflow = this.model.isAufrufAusWorkflow();
        if (bAufrufAusWorkflow) {
            this.model.setExitAction("zurueckzubildtafel");
            this.notifyAllExitListeners();
        } else {
            WorkflowStateData oBackToBT = GlobalObjects.getInstance().getEtkData().getBackInfo("backinfo_bt");
            if (oBackToBT == null) {
                log.error((Object)"backToBildtafel: keine Bildtafelinfo vorhanden");
                return;
            }
            CurrentBTE oCurrentBTE = (CurrentBTE)oBackToBT.getWert("currentbte");
            String sZurueckZuTeileverwendung = (String)oBackToBT.getWert("zurueck_zu_teileverwendung_erlauben");
            WorkflowStateData oWFStateData = new WorkflowStateData();
            oWFStateData.setWert("modus", "Fahrzeugteile");
            oWFStateData.setWert("currentbte", oCurrentBTE);
            oWFStateData.setWert("hasnextbt", "false");
            oWFStateData.setWert("hasprevbt", "false");
            oWFStateData.setWert("zurueck_zu_teileverwendung_erlauben", sZurueckZuTeileverwendung);
            oWFStateData.setWert("aufruf_aus_workflow", "false");
            MainView.getInstance().showDlg(BTEController.class, oWFStateData);
        }
    }

    public static void showKleineListe(ComboTeilelisteItem oItem) {
        if (oItem == null || oItem.getID() == null) {
            log.error((Object)"ID == null");
            return;
        }
        if (oItem == null || oItem.getEigentuemer() == null) {
            log.error((Object)"Eigentuemer == null");
            return;
        }
        String sID = oItem.getID();
        String sEigentuemer = oItem.getEigentuemer();
        String sFiliale = oItem.getFiliale();
        String sMarke = oItem.getMarke();
        if (sID.equals(Resource.getInstance().getAndereListe())) {
            HashMap<String, Object> mapRetVal = new HashMap<String, Object>();
            TeilelistenUebersichtKleinDlg dlg = new TeilelistenUebersichtKleinDlg(mapRetVal);
            dlg.setVisible(true);
            Teileliste selListe = null;
            Integer nRet = (Integer)mapRetVal.get(RET);
            if (nRet == null || nRet != 0) {
                return;
            }
            selListe = (Teileliste)mapRetVal.get("liste");
            if (selListe == null) {
                log.error((Object)"selListe == null");
                return;
            }
            sID = selListe.getID();
            sEigentuemer = selListe.getNutzerID();
        }
        KleineListe dlg = new KleineListe();
        boolean bRet = dlg.show(sID, sEigentuemer);
        if (sID != null && bRet) {
            GlobalObjects.getInstance().getSessionInfo().setAktuelleTeileliste(new ComboTeilelisteItem(sID, sID, sEigentuemer, sFiliale, sMarke));
        }
        oItem.setID(sID);
        oItem.setEigentuemer(sEigentuemer);
        oItem.setFiliale(sFiliale);
        oItem.setMarke(sMarke);
    }

    public void handleExit() {
        this.entsperreListe();
    }

    public void entsperreListe() {
        if (this.model.getTLDaten() == null || this.model.getTLDaten() instanceof Scoreliste) {
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teileliste", this.model.getTLDaten());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.UNLOCK_BESTELLLISTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgTeilelisteController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTL.getError() != null) {
            log.error((Object)(Resource.getInstance().getFehlerBestelllisteEntsperren() + ": "), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerBestelllisteEntsperren() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected static boolean checkKannTeileUebernehmen(String sListenID, String sEigentuemer) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        Teileliste oTL = new Teileliste(sListenID, sEigentuemer, GlobalObjects.getInstance().getLanguage());
        trfTL.setValue("teileliste", oTL);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.CHECK_KANN_TEILE_UEBERNEHMEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgTeilelisteController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfTL.getError() != null) {
            log.error((Object)(Resource.getInstance().getFehlerLadeTeilelistenIds() + ": "), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        Boolean bErgebnis = (Boolean)trfTL.getValue("boolean");
        return bErgebnis;
    }

    public static void removeListe(ComboTeilelisteItem oItemDel, TrfHashMap oTeilelisten) {
        ComboTeilelisteItem oItem;
        if (oItemDel == null || oTeilelisten == null) {
            return;
        }
        int ii = 1;
        while ((oItem = (ComboTeilelisteItem)oTeilelisten.getValue(ii + "teilelisteid")) != null) {
            if (oItemDel == oItem) {
                oTeilelisten.getHashMap().remove(ii + "teilelisteid");
                int kk = ii + 1;
                while ((oItem = (ComboTeilelisteItem)oTeilelisten.getValue(kk + "teilelisteid")) != null) {
                    oTeilelisten.setValue(kk - 1 + "teilelisteid", oItem);
                    oTeilelisten.getHashMap().remove(kk + "teilelisteid");
                    ++kk;
                }
                break;
            }
            ++ii;
        }
    }

    public static String getNextTeilelistenId(Konfiguration oKonfig, String sAnfang) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.GET_NEXT_TEILELISTEN_ID);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgTeilelisteController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfTL.getError() != null) {
            log.error((Object)(Resource.getInstance().getFehlerLadeTeilelistenIds() + ": "), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        String sID = (String)trfTL.getValue("teilelisteid");
        if (sAnfang == null) {
            if (oKonfig == null) {
                oKonfig = GlobalObjects.getInstance().getConfig();
            }
            if (oKonfig == null) {
                return null;
            }
            String sBarverkaufsnummer = oKonfig.getStandardBarVerkaufsNummer();
            if (sBarverkaufsnummer == null || sBarverkaufsnummer.length() < 1) {
                sBarverkaufsnummer = "0";
            }
            return sBarverkaufsnummer + "/" + sID;
        }
        return sAnfang + "/" + sID;
    }

    public static String getStandardAuftragsnummer(Konfiguration oKonfig) {
        if (oKonfig == null) {
            oKonfig = GlobalObjects.getInstance().getConfig();
        }
        if (oKonfig == null) {
            return null;
        }
        String sAuftragsnummer = oKonfig.getStandardAuftragsNummer();
        return sAuftragsnummer;
    }

    public static String getStandardKundennummer(Konfiguration oKonfig) {
        if (oKonfig == null) {
            oKonfig = GlobalObjects.getInstance().getConfig();
        }
        if (oKonfig == null) {
            return null;
        }
        String sKundennummer = oKonfig.getStandardKundenNummer();
        return sKundennummer;
    }

    protected static String loadBearbeiterNr() {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trf = new TrfTeileliste(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.LOAD_BEARBEITERNR);
        }
        catch (CommunicationException e) {
            log.error((Object)("loadBearbeiterNr: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return "";
        }
        if (trf.getError() != null) {
            log.error((Object)trf.getError().getMessage());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trf.getError().getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return "";
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        Integer nBearbeiterNr = (Integer)trf.getValue("bearbeiter_nummer");
        if (nBearbeiterNr == null) {
            return "";
        }
        return nBearbeiterNr.toString();
    }

    public static Scoreliste createScoreListe(Scoreliste objScoreliste) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTeileliste = new TrfTeileliste(null);
        trfTeileliste.setValue("scoreliste", objScoreliste);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTeileliste, Command.INSERT_SCORE_LISTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            return objScoreliste;
        }
        if (trfTeileliste.getError() != null) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSaveTeilelistendatenFailed(), Resource.getInstance().getFahrzeugidentifikation(), 0);
            return objScoreliste;
        }
        String sID = (String)trfTeileliste.getValue("id");
        objScoreliste.setID(sID);
        Vector cTeile = objScoreliste.getTeile();
        Vector<webetk.app.teileliste.Teil> cTeileOld = new Vector<webetk.app.teileliste.Teil>(cTeile.size());
        for (webetk.app.teileliste.Teil oTeil : cTeile) {
            webetk.app.teileliste.Teil oTeilOld = new webetk.app.teileliste.Teil(oTeil);
            cTeileOld.add(oTeilOld);
            if (oTeil.getLokalteil()) continue;
            oTeil.setHG(null);
            oTeil.setUG(null);
        }
        objScoreliste = DlgTeilelisteController.doDatenAbgleich(objScoreliste);
        StringBuffer sUnbekannteTeile = new StringBuffer();
        cTeile = objScoreliste.getTeile();
        Iterator iter = cTeile.iterator();
        Iterator iterOld = cTeileOld.iterator();
        while (iter.hasNext()) {
            webetk.app.teileliste.Teil oTeil = (webetk.app.teileliste.Teil)iter.next();
            webetk.app.teileliste.Teil oTeilOld = (webetk.app.teileliste.Teil)iterOld.next();
            if (oTeil.getHG() != null && oTeil.getHG().length() >= 1 || oTeil.getLokalteil()) continue;
            oTeil.setLokalteil(true);
            oTeil.setHG(oTeilOld.getHG());
            oTeil.setUG(oTeilOld.getUG());
            oTeil.setUpdate(true);
            sUnbekannteTeile.append(oTeil.getSachnummer() + "\n");
        }
        if (sUnbekannteTeile.length() > 0) {
            Object[] arguments = new Object[]{sUnbekannteTeile.toString()};
            String sMsg = MessageFormat.format(Resource.getInstance().getMsgTeileNichtImTeilestamm(), arguments);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeileliste(), 0);
            DlgTeilelisteController.saveTeile(sID, cTeile);
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return objScoreliste;
    }

    public static void deleteScoreListe(String sID, String sEigentuemer, String sFiliale) {
        log.debug((Object)"Performing deleteScoreListe");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teilelisteid", sID);
        trfTL.setValue("eigentuemer", sEigentuemer);
        trfTL.setValue("filialid", sFiliale);
        trfTL.setValue("score", true);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.DELETE_TEILELISTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTL.getError() != null) {
            log.error((Object)(Resource.getInstance().getFehlerLoeschenTeileliste() + ": "), (Throwable)trfTL.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLoeschenTeileliste() + ": " + trfTL.getError().getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
            return;
        }
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        oLoginInfo.setAktuelleTeileliste(null);
        GlobalObjects.getInstance().getEtkData().setScoreListenID(null);
        GlobalObjects.getInstance().getEtkData().setScoreListe(null);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected int ermittleAnzahlFahrzeuge() {
        Vector<webetk.app.teileliste.Teil> cTeile = this.model.getTeile();
        if (cTeile == null || cTeile.size() < 1) {
            return 0;
        }
        int nAnz = 0;
        boolean bMitLeerString = false;
        String sFiLast = null;
        for (webetk.app.teileliste.Teil oTeil : cTeile) {
            String sFiAkt = oTeil.getFIString();
            if (sFiAkt == null) {
                bMitLeerString = true;
                sFiAkt = "";
            }
            if (nAnz == 0) {
                sFiLast = sFiAkt;
                nAnz = 1;
                continue;
            }
            if (sFiAkt.equals(sFiLast)) continue;
            ++nAnz;
            sFiLast = sFiAkt;
            if (bMitLeerString) continue;
            break;
        }
        if (nAnz == 0 || nAnz == 1 && bMitLeerString) {
            return 0;
        }
        if (nAnz == 1 && !bMitLeerString) {
            return 1;
        }
        if (nAnz == 2 && bMitLeerString) {
            return 2;
        }
        return 3;
    }

    @Override
    protected void handleTeileinfo(webetk.app.teileliste.Teil oTeil) {
        super.handleTeileinfo(oTeil);
        this.loadTLZumUebernehmen();
        this.loadTLZurAuswahl();
        this.updateView();
    }

    protected ArrayList<String> loadTableConfiguration() {
        log.debug((Object)"Performing loadTableConfiguration");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        String sUserId = GlobalObjects.getInstance().getSessionInfo().getLogin();
        String sTabellenname = "Teileliste";
        String sZusatz = this.model.istDMSAngeschlossen() ? "DMS" : "kein DMS";
        TrfHashMap trfHashMap = new TrfHashMap(null);
        trfHashMap.setValue("firmaid", sFirmaId);
        trfHashMap.setValue("user_id", sUserId);
        trfHashMap.setValue("TabellenName", sTabellenname);
        trfHashMap.setValue("zusatz", sZusatz);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHashMap, Command.LOAD_TABELLENKONFIGURATION);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfHashMap.getError() != null) {
            log.error((Object)("loadTableConfiguration " + trfHashMap.getError()));
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        ArrayList result = (ArrayList)trfHashMap.getValue("TabellenKonfiguration");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return result;
    }

    protected void saveTableConfiguration(ArrayList<String> oConfig) {
        log.debug((Object)"Performing saveTableConfiguration");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        String sUserId = GlobalObjects.getInstance().getSessionInfo().getLogin();
        String sTabellenname = "Teileliste";
        String sZusatz = this.model.istDMSAngeschlossen() ? "DMS" : "kein DMS";
        TrfHashMap trfHashMap = new TrfHashMap(null);
        trfHashMap.setValue("TabellenKonfiguration", oConfig);
        trfHashMap.setValue("firmaid", sFirmaId);
        trfHashMap.setValue("user_id", sUserId);
        trfHashMap.setValue("TabellenName", sTabellenname);
        trfHashMap.setValue("zusatz", sZusatz);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHashMap, Command.SAVE_TABELLENKONFIGURATION);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        }
        if (trfHashMap.getError() != null) {
            log.error((Object)("saveTableConfiguration " + trfHashMap.getError()));
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void configureTable() {
        DlgTableConfigController dlg = this.model.istDMSAngeschlossen() ? new DlgTableConfigController(Resource.getInstance().getTeileliste(), "DMS", DlgTeilelisteController.getColumnNames(DlgTeilelisteController.getColumnsMitDMS()), DlgTeilelisteController.getColumnNames(this.view.getColumnConfig())) : new DlgTableConfigController(Resource.getInstance().getTeileliste(), "kein DMS", DlgTeilelisteController.getColumnNames(DlgTeilelisteController.getColumnsOhneDMS()), DlgTeilelisteController.getColumnNames(this.view.getColumnConfig()));
        if (dlg.getResult() != null) {
            ArrayList<String> selectedColumns = DlgTeilelisteController.getInternalColumnNames(dlg.getResult());
            this.saveTableConfiguration(selectedColumns);
            this.view.updateTable(selectedColumns);
        }
    }

    private static ArrayList<String> getColumnNames(ArrayList<String> internalColNames) {
        ArrayList<String> colNames = new ArrayList<String>();
        for (String col : internalColNames) {
            String name = DlgTeilelisteController.getColname(col);
            if (col == null || colNames.contains(name)) continue;
            colNames.add(name);
        }
        return colNames;
    }

    private static String getColname(String key) {
        if (key.equals("TeileInformation")) {
            return null;
        }
        if (key.equals("TeilBearbeiten")) {
            return null;
        }
        if (key.equals("TeilLoeschen")) {
            return null;
        }
        if (key.equals("Position")) {
            return Resource.getInstance().getPosition();
        }
        if (key.equals("TeileNummer")) {
            return Resource.getInstance().getTeilenummer();
        }
        if (key.equals("TeileBenennung")) {
            return Resource.getInstance().getTeilebenennung();
        }
        if (key.equals("Zusatz")) {
            return Resource.getInstance().getZusatz();
        }
        if (key.equals("Menge")) {
            return Resource.getInstance().getMenge();
        }
        if (key.equals("Bestand")) {
            return Resource.getInstance().getLagerbestand();
        }
        if (key.equals("Lagerort")) {
            return Resource.getInstance().getLagerort();
        }
        if (key.equals("MinimalBestand")) {
            return Resource.getInstance().getMinimalbestand();
        }
        if (key.equals("BedarfsHinweis")) {
            return Resource.getInstance().getBedarfshinweis();
        }
        if (key.equals("AusstehendeMenge")) {
            return Resource.getInstance().getAusstehendeMenge();
        }
        if (key.equals("Preis")) {
            return Resource.getInstance().getPreis();
        }
        if (key.equals("Rabatt")) {
            return Resource.getInstance().getRabatt();
        }
        if (key.equals("Splittkennzeichen")) {
            return Resource.getInstance().getSplittKennzeichen();
        }
        if (key.equals("RechnungsTransparenz")) {
            return Resource.getInstance().getRechnungstransparenz();
        }
        if (key.equals("DispoCode")) {
            return Resource.getInstance().getDispocode();
        }
        if (key.equals("Suffix")) {
            return Resource.getInstance().getSuffix();
        }
        if (key.equals("Netto")) {
            return Resource.getInstance().getBetragNetto();
        }
        if (key.equals("Brutto")) {
            return Resource.getInstance().getBetragBrutto();
        }
        if (key.equals("Mwst")) {
            return Resource.getInstance().getMehrwertsteuer();
        }
        if (key.equals("Ruecksendepflicht")) {
            return Resource.getInstance().getRuecksendepflicht();
        }
        if (key.equals("Bemerkung")) {
            return Resource.getInstance().getBemerkung();
        }
        if (key.equals("Fahrzeug")) {
            return Resource.getInstance().getFahrzeug();
        }
        return null;
    }

    private static ArrayList<String> getInternalColumnNames(ArrayList<String> colNames) {
        ArrayList<String> internalColNames = new ArrayList<String>();
        for (String col : colNames) {
            String name = DlgTeilelisteController.getInternalColname(col);
            if (col == null || internalColNames.contains(name)) continue;
            internalColNames.add(name);
        }
        return internalColNames;
    }

    private static String getInternalColname(String key) {
        if (key.equals(Resource.getInstance().getPosition())) {
            return "Position";
        }
        if (key.equals(Resource.getInstance().getTeilenummer())) {
            return "TeileNummer";
        }
        if (key.equals(Resource.getInstance().getTeilebenennung())) {
            return "TeileBenennung";
        }
        if (key.equals(Resource.getInstance().getZusatz())) {
            return "Zusatz";
        }
        if (key.equals(Resource.getInstance().getMenge())) {
            return "Menge";
        }
        if (key.equals(Resource.getInstance().getLagerbestand())) {
            return "Bestand";
        }
        if (key.equals(Resource.getInstance().getLagerort())) {
            return "Lagerort";
        }
        if (key.equals(Resource.getInstance().getMinimalbestand())) {
            return "MinimalBestand";
        }
        if (key.equals(Resource.getInstance().getBedarfshinweis())) {
            return "BedarfsHinweis";
        }
        if (key.equals(Resource.getInstance().getAusstehendeMenge())) {
            return "AusstehendeMenge";
        }
        if (key.equals(Resource.getInstance().getPreis())) {
            return "Preis";
        }
        if (key.equals(Resource.getInstance().getRabatt())) {
            return "Rabatt";
        }
        if (key.equals(Resource.getInstance().getSplittKennzeichen())) {
            return "Splittkennzeichen";
        }
        if (key.equals(Resource.getInstance().getRechnungstransparenz())) {
            return "RechnungsTransparenz";
        }
        if (key.equals(Resource.getInstance().getDispocode())) {
            return "DispoCode";
        }
        if (key.equals(Resource.getInstance().getSuffix())) {
            return "Suffix";
        }
        if (key.equals(Resource.getInstance().getBetragNetto())) {
            return "Netto";
        }
        if (key.equals(Resource.getInstance().getBetragBrutto())) {
            return "Brutto";
        }
        if (key.equals(Resource.getInstance().getMehrwertsteuer())) {
            return "Mwst";
        }
        if (key.equals(Resource.getInstance().getRuecksendepflicht())) {
            return "Ruecksendepflicht";
        }
        if (key.equals(Resource.getInstance().getBemerkung())) {
            return "Bemerkung";
        }
        if (key.equals(Resource.getInstance().getFahrzeug())) {
            return "Fahrzeug";
        }
        return null;
    }

    private ArrayList<webetk.app.teileliste.Teil> findDiebstahlrelevants(Collection<webetk.app.teileliste.Teil> allTeile, Collection<?> newTeile) {
        ArrayList<webetk.app.teileliste.Teil> res = new ArrayList<webetk.app.teileliste.Teil>();
        Collection<webetk.app.teileliste.Teil> dbListe = allTeile;
        for (Object object : newTeile) {
            Object teil;
            Object sSachnummer = "";
            if (object instanceof webetk.app.teileliste.Teil) {
                teil = (webetk.app.teileliste.Teil)object;
                sSachnummer = ((GenericTeil)teil).getSachnummer();
            }
            if (object instanceof String) {
                sSachnummer = teil = (String)object;
            }
            if (object instanceof webetk.app.aspg.Teil) {
                teil = (webetk.app.aspg.Teil)object;
                sSachnummer = ((GenericTeil)teil).getSachnummer();
            }
            if ((teil = DlgTeilelisteController.findDiebstahlrelevantBySachnummer(dbListe, (String)sSachnummer)) == null) continue;
            res.add((webetk.app.teileliste.Teil)teil);
        }
        return res;
    }

    private static webetk.app.teileliste.Teil findDiebstahlrelevantBySachnummer(Collection<webetk.app.teileliste.Teil> dbListe, String sSachnummer) {
        for (webetk.app.teileliste.Teil teil : dbListe) {
            if (!teil.getSachnummer().equals(sSachnummer) || !teil.isTeilDiebstahlrelevant()) continue;
            return teil;
        }
        return null;
    }

    private void showDiebstahlrelevantWarning(ArrayList<webetk.app.teileliste.Teil> list) {
        if (list.size() < 1) {
            return;
        }
        String hinweis = Resource.getInstance().getHinweisDiebstahlrelevant();
        String hinweisMitSeparator = "";
        while (hinweis.length() > 0) {
            int pos = hinweis.indexOf(" ", 70);
            if (pos > -1) {
                hinweisMitSeparator = hinweisMitSeparator + hinweis.substring(0, pos) + System.getProperty("line.separator");
                hinweis = hinweis.substring(pos + 1);
                continue;
            }
            hinweisMitSeparator = hinweisMitSeparator + hinweis + System.getProperty("line.separator");
            hinweis = "";
        }
        String teileInfo = "";
        for (webetk.app.teileliste.Teil teil : list) {
            teileInfo = teileInfo + System.getProperty("line.separator") + teil.getTeilenummer() + " - " + teil.getBenennung();
        }
        String sMsg = hinweisMitSeparator + System.getProperty("line.separator") + Resource.getInstance().getBetroffeneTeilenummern() + teileInfo;
        JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getHinweis(), 2);
    }

    private boolean existAnkerTeilForKoppelTeil(Collection<webetk.app.teileliste.Teil> cTeile, webetk.app.teileliste.Teil kTeil) {
        for (webetk.app.teileliste.Teil teil : cTeile) {
            if (!teil.getAspgTyp().equals("A") || !teil.getAspgRef().equals(kTeil.getAspgRef()) || !teil.getFIString().equals(kTeil.getFIString())) continue;
            return true;
        }
        return false;
    }

    private boolean isTeilInListe(Collection<webetk.app.teileliste.Teil> cTeile, webetk.app.teileliste.Teil teil) {
        for (webetk.app.teileliste.Teil cTeil : cTeile) {
            if (cTeil.getPosInt() != teil.getPosInt()) continue;
            return true;
        }
        return false;
    }
}

