/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import webetk.javaclient.dialog.ChoicePanel;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.framework.MainView;
import webetk.resources.Resource;

public class Druckausgabe {
    private JDialog dlg;
    protected JPanel headerPanel;
    private Container contentPane;
    private JRadioButton rbHochformat;
    private JRadioButton rbQuerformat;
    private JRadioButton rbFIBlockbildung;
    private JRadioButton rbFISpalte;
    private JPanel panFormat;
    private JPanel panFI;
    private JButtonEx buttonUebernehmen;
    private JButtonEx buttonAbbrechen;
    private HashMap<String, Object> mMapReturnValues;
    public static final String RET = "ret";
    public static final String QUERFORMAT = "querformat";
    public static final String FISPALTE = "fispalte";

    public Druckausgabe(HashMap<String, Object> mapReturnValues) {
        this.mMapReturnValues = mapReturnValues;
        this.dlg = new JDialog((Frame)MainView.getInstance(), false);
        this.dlg.setModal(true);
        this.dlg.setTitle(Resource.getInstance().getDruckausgabe());
        this.dlg.setSize(480, 360);
        this.dlg.setLocation(50, 10);
        this.initComponents();
    }

    public void initComponents() {
        this.headerPanel = new HeaderPanel(Resource.getInstance().getDruckausgabe(), null);
        this.rbHochformat = new JRadioButton(Resource.getInstance().getHochformat());
        this.rbQuerformat = new JRadioButton(Resource.getInstance().getQuerformat());
        this.panFormat = new ChoicePanel(Resource.getInstance().getOrientierung(), new AbstractButton[]{this.rbHochformat, this.rbQuerformat}, 0);
        this.rbFIBlockbildung = new JRadioButton(Resource.getInstance().getMitBlockbildungFahrzeugdaten());
        this.rbFISpalte = new JRadioButton(Resource.getInstance().getMitEigenerSpalteFahrzeugdaten());
        this.panFI = new ChoicePanel(Resource.getInstance().getDarstellungFahrzeugdaten(), new AbstractButton[]{this.rbFIBlockbildung, this.rbFISpalte}, 0);
        this.buttonUebernehmen = new JButtonEx(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.buttonAbbrechen = new JButtonEx(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.layoutAll();
    }

    protected void layoutAll() {
        this.contentPane = this.dlg.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.contentPane.setLayout(l);
        this.contentPane.add((Component)this.headerPanel, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        this.contentPane.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    public JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0};
        int[] heights = new int[]{10, 0, 0};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.createCenterPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(3, 2, "lrtb"));
        return panel;
    }

    public JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10};
        int[] heights = new int[]{10, 0, 10, 0, 10};
        HIGLayout layout = new HIGLayout(widths, heights);
        panel.setLayout(layout);
        panel.add((Component)this.panFormat, c.rc(2, 2, "lt"));
        panel.add((Component)this.panFI, c.rc(4, 2, "lt"));
        return panel;
    }

    public JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-5, -4, 10, -2, -1};
        int[] heights = new int[]{20, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(1, 1);
        layoutPosTeileliste.setColumnWeight(5, 1);
        layoutPosTeileliste.setRowWeight(3, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.buttonUebernehmen, c.rc(2, 2, "lrtb"));
        panel.add((Component)this.buttonAbbrechen, c.rc(2, 4, "lrtb"));
        this.buttonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Druckausgabe.this.mMapReturnValues.put(Druckausgabe.QUERFORMAT, Druckausgabe.this.rbQuerformat.isSelected());
                Druckausgabe.this.mMapReturnValues.put(Druckausgabe.FISPALTE, Druckausgabe.this.rbFISpalte.isSelected());
                Druckausgabe.this.mMapReturnValues.put(Druckausgabe.RET, 0);
                Druckausgabe.this.dlg.dispose();
            }
        });
        this.buttonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Druckausgabe.this.mMapReturnValues.put(Druckausgabe.RET, 2);
                Druckausgabe.this.dlg.dispose();
            }
        });
        return panel;
    }

    public void show() {
        this.dlg.setVisible(true);
    }
}

