/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.JButtonEx;
import de.esg.commonclient.dialog.LimitedNumberField;
import de.esg.commonclient.dialog.LimitedTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.teileliste.Scoreliste;
import webetk.app.teileliste.ScorelisteJob;
import webetk.app.teileliste.ScorelisteSrp;
import webetk.app.teileliste.Teil;
import webetk.app.teileliste.Teileliste;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfTeileliste;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.LineBreakPanel;
import webetk.javaclient.dialog.SachnummerField;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.extras.teileliste.AbstractListeController;
import webetk.javaclient.dialog.extras.teileliste.AbstractListeModel;
import webetk.javaclient.dialog.extras.teileliste.DlgBestelllisteModel;
import webetk.javaclient.dialog.extras.teileliste.DlgSapRrListeModel;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteController;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteModel;
import webetk.javaclient.framework.MainView;
import webetk.mrkprd.Marken;
import webetk.resources.Resource;

public class EditTeil
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(EditTeil.class);
    private AbstractListeModel model;
    private AbstractListeController controller;
    private boolean mbIstBestellliste = false;
    private boolean mbIstRrSapListe = false;
    private HeaderPanel headerPanel;
    private JLabel txtTeilenummer_1_4;
    private JLabel txtTeilenummer_5_11;
    private JLabel txtHgUg;
    private JLabel txtHgUgWert;
    private JTextField tfHgUg;
    private JLabel txtSachnummer;
    private JLabel txtSachnummerWert;
    private SachnummerField tfSachnummer;
    private LineBreakPanel mHinweis;
    private JLabel txtMenge;
    private JTextField tfMenge;
    private JLabel txtBemerkungPos;
    private JTextField tfBemerkungPos;
    private JLabel txtAuftragsnr;
    private JTextField tfAuftragsnr;
    private JLabel txtKundennr;
    private JTextField tfKundennr;
    private JButtonEx buttonUebernehmen;
    private JButtonEx buttonAbbrechen;
    private JLabel txtSplit;
    private JLabel txtReTr;
    private JLabel txtPreis;
    private JLabel txtRabatt;
    private JLabel txtBenennung;
    private JLabel txtBenennungWert;
    private JLabel txtSuffix;
    private JTextField tfSplit;
    private JTextField tfReTr;
    private JTextField tfPreis;
    private JTextField tfRabatt;
    private JTextField tfBenennung;
    private JTextField tfSuffix;
    private JCheckBox chkLokalteil;
    private JLabel txtJob;
    private JComboBox cbJob;
    private JLabel txtSrp;
    private JComboBox cbSrp;
    private boolean mbNeuanlage;
    private boolean mbMultiParts = false;
    private boolean mbTeilVonScore = false;
    private boolean mbAddToIpac = false;
    private int mDialogResult;
    public static final int DIALOG_OK = 1;
    public static final int DIALOG_ABBRECHEN = -1;
    private String msJob = null;
    private String msSrp = null;
    private boolean mbDataChanged = false;
    private Teil moTeilBasisDaten = null;

    public EditTeil() {
        this((Frame)MainView.getInstance(), false);
    }

    public EditTeil(Frame oOwner, boolean addToIpac) {
        super(oOwner, true);
        this.mbAddToIpac = addToIpac;
        this.headerPanel = new HeaderPanel(Resource.getInstance().getTeilHinzufuegen(), null);
    }

    public void setModel(AbstractListeModel model) {
        this.model = model;
        this.mbIstBestellliste = model instanceof DlgBestelllisteModel;
        this.mbIstRrSapListe = model instanceof DlgSapRrListeModel;
    }

    public void setController(AbstractListeController controller) {
        this.controller = controller;
    }

    public void setNeuanlage(boolean bNeuanlage) {
        this.mbNeuanlage = bNeuanlage;
    }

    public void setJobSrp(String sJob, String sSrp) {
        this.msJob = sJob;
        this.msSrp = sSrp;
    }

    public void initComponents() {
        DlgTeilelisteModel oTlModel;
        Teileliste oTl;
        if (GlobalObjects.isScore() && this.ermittleShowJobSrpCombos()) {
            this.setSize(600, 460);
        } else {
            this.setSize(550, 430);
        }
        this.setLocation(50, 10);
        if (this.mbNeuanlage) {
            this.setTitle(Resource.getInstance().getTeilHinzufuegen());
            this.headerPanel.setBigTitle(Resource.getInstance().getTeilHinzufuegen());
            this.mbTeilVonScore = false;
            this.mbMultiParts = false;
        } else {
            this.setTitle(Resource.getInstance().getTeilBearbeiten());
            this.headerPanel.setBigTitle(Resource.getInstance().getTeilBearbeiten());
            Collection<Teil> cTeile = this.model.getSelTeile();
            this.mbMultiParts = cTeile != null && cTeile.size() > 1;
            this.mbTeilVonScore = false;
            if (GlobalObjects.isScore()) {
                for (Teil oTeil : cTeile) {
                    if (!oTeil.isTeilVonScore()) continue;
                    this.mbTeilVonScore = true;
                    break;
                }
            }
        }
        this.mHinweis = new LineBreakPanel(Resource.getInstance().getHinweisEditTeilMultiSel());
        Dimension size = new Dimension(this.getWidth(), 50);
        this.mHinweis.setMinimumSize(size);
        this.txtHgUg = new JLabel(Resource.getInstance().getHgug());
        this.txtHgUgWert = new JLabel("");
        this.tfHgUg = new LimitedTextField(4);
        this.tfHgUg.addActionListener(new OkButtonActionListener());
        Document doc = this.tfHgUg.getDocument();
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent ev) {
                EditTeil.this.mbDataChanged = true;
                Document doc = ev.getDocument();
                if (doc.getLength() >= 4) {
                    EditTeil.this.tfSachnummer.requestFocus();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                EditTeil.this.mbDataChanged = true;
            }

            @Override
            public void changedUpdate(DocumentEvent ev) {
            }
        });
        this.txtSachnummer = new JLabel(Resource.getInstance().getSachnummer());
        this.tfSachnummer = new SachnummerField(false);
        this.tfSachnummer.addActionListener(new OkButtonActionListener());
        this.tfSachnummer.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                if (EditTeil.this.mbNeuanlage) {
                    EditTeil.this.tfMenge.setText("1");
                }
                return true;
            }
        });
        Document docSachnummer = this.tfSachnummer.getDocument();
        docSachnummer.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent ev) {
                EditTeil.this.mbDataChanged = true;
                Document doc = ev.getDocument();
                if (doc.getLength() >= 7) {
                    if (!EditTeil.this.chkLokalteil.isSelected()) {
                        try {
                            String sSachnummer = doc.getText(0, 7);
                            Teil oTeil = EditTeil.this.loadTeilBasisdaten(sSachnummer);
                            if (oTeil != null) {
                                EditTeil.this.tfHgUg.setText(oTeil.getHG() + oTeil.getUG());
                                EditTeil.this.tfBenennung.setText(oTeil.getBenennung());
                                EditTeil.this.txtBenennungWert.setText(oTeil.getBenennung());
                            } else {
                                EditTeil.this.tfBenennung.setText("");
                                EditTeil.this.txtBenennungWert.setText("");
                            }
                        }
                        catch (Exception ex) {
                            log.error((Object)ex);
                        }
                    }
                    EditTeil.this.tfMenge.requestFocus();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                EditTeil.this.mbDataChanged = true;
            }

            @Override
            public void changedUpdate(DocumentEvent ev) {
            }
        });
        this.txtSachnummerWert = new JLabel("");
        this.txtTeilenummer_1_4 = new JLabel("12 34");
        this.txtTeilenummer_5_11 = new JLabel("1 234 567");
        this.txtMenge = new JLabel(Resource.getInstance().getMenge());
        this.tfMenge = this.mbAddToIpac ? new LimitedNumberField(8, 10, true, true) : new LimitedNumberField(9, 10, true, true);
        this.addDataChangedListener(this.tfMenge);
        this.tfMenge.addActionListener(new OkButtonActionListener());
        this.txtBemerkungPos = new JLabel(Resource.getInstance().getBemerkung());
        this.tfBemerkungPos = new LimitedTextField(15, 21);
        this.addDataChangedListener(this.tfBemerkungPos);
        this.tfBemerkungPos.addActionListener(new OkButtonActionListener());
        this.txtAuftragsnr = new JLabel(Resource.getInstance().getAuftragsnummer());
        this.tfAuftragsnr = new LimitedTextField(10);
        this.addDataChangedListener(this.tfAuftragsnr);
        this.tfAuftragsnr.addActionListener(new OkButtonActionListener());
        this.txtKundennr = new JLabel(Resource.getInstance().getKundennummer());
        this.tfKundennr = new LimitedNumberField(7);
        this.addDataChangedListener(this.tfKundennr);
        this.tfKundennr.addActionListener(new OkButtonActionListener());
        this.txtSplit = new JLabel(Resource.getInstance().getSplittKennzeichen());
        this.txtReTr = new JLabel(Resource.getInstance().getRechnungstransparenz());
        this.txtPreis = new JLabel(Resource.getInstance().getPreis());
        this.txtRabatt = new JLabel(Resource.getInstance().getRabatt());
        this.txtBenennung = new JLabel(Resource.getInstance().getBenennung());
        this.txtBenennungWert = new JLabel();
        this.txtSuffix = new JLabel(Resource.getInstance().getSuffix());
        this.tfSplit = new LimitedNumberField(2);
        this.addDataChangedListener(this.tfSplit);
        this.tfSplit.addActionListener(new OkButtonActionListener());
        this.tfReTr = new LimitedTextField(4);
        this.addDataChangedListener(this.tfReTr);
        this.tfReTr.addActionListener(new OkButtonActionListener());
        this.tfPreis = new LimitedNumberField(12, true, false);
        this.addDataChangedListener(this.tfPreis);
        this.tfPreis.addActionListener(new OkButtonActionListener());
        this.tfRabatt = new LimitedNumberField(6, true, true);
        this.addDataChangedListener(this.tfRabatt);
        this.tfRabatt.addActionListener(new OkButtonActionListener());
        this.tfBenennung = new LimitedTextField(40);
        this.addDataChangedListener(this.tfBenennung);
        this.tfBenennung.addActionListener(new OkButtonActionListener());
        this.tfSuffix = new LimitedNumberField(1);
        this.addDataChangedListener(this.tfSuffix);
        this.tfSuffix.addActionListener(new OkButtonActionListener());
        this.chkLokalteil = new JCheckBox(Resource.getInstance().getLokalesTeil(), false);
        this.chkLokalteil.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditTeil.this.mbDataChanged = true;
                EditTeil.this.leereFelder();
            }
        });
        this.chkLokalteil.addKeyListener(new EnterKeyListener());
        this.txtJob = new JLabel(Resource.getInstance().getJob());
        this.cbJob = new JComboBox();
        this.cbJob.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditTeil.this.cbSrp.removeAllItems();
                ScorelisteJob job = (ScorelisteJob)EditTeil.this.cbJob.getSelectedItem();
                Collection<ScorelisteSrp> srps = job.getSrps();
                for (ScorelisteSrp srp : srps) {
                    if (!srp.isLock()) {
                        EditTeil.this.cbSrp.addItem(srp);
                    }
                    if (EditTeil.this.msSrp == null || !srp.getId().equals(EditTeil.this.msSrp)) continue;
                    EditTeil.this.cbSrp.setSelectedItem(srp);
                }
            }
        });
        this.txtSrp = new JLabel(Resource.getInstance().getSrp());
        this.cbSrp = new JComboBox();
        if (this.mbNeuanlage) {
            this.tfHgUg.requestFocus();
        }
        if (this.mbNeuanlage) {
            this.buttonUebernehmen = new JButtonEx(Resource.getInstance().getUebernehmen(), ImageCache.getInstance().getIcon("ok.gif"));
            this.buttonAbbrechen = new JButtonEx(Resource.getInstance().getSchlieszen(), ImageCache.getInstance().getIcon("delete.gif"));
        } else {
            this.buttonUebernehmen = new JButtonEx(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
            this.buttonAbbrechen = new JButtonEx(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        }
        if (!this.mbNeuanlage) {
            Iterator<Teil> iter;
            Collection<Teil> cTeile = this.model.getSelTeile();
            if (cTeile != null && !this.mbMultiParts && (iter = cTeile.iterator()).hasNext()) {
                Teil oTeil = iter.next();
                this.initEditTeil(oTeil);
            }
            this.chkLokalteil.setEnabled(false);
        }
        if (this.model instanceof DlgTeilelisteModel && (oTl = (oTlModel = (DlgTeilelisteModel)this.model).getTLDaten()) instanceof Scoreliste) {
            Scoreliste oSl = (Scoreliste)oTl;
            Collection<ScorelisteJob> jobs = oSl.getJobs();
            for (ScorelisteJob job : jobs) {
                if (!job.isLock()) {
                    this.cbJob.addItem(job);
                }
                if (this.msJob == null || !job.getId().equals(this.msJob)) continue;
                this.cbJob.setSelectedItem(job);
            }
        }
        this.layoutAll();
    }

    protected void initEditTeil(Teil oTeil) {
        if (!this.mbMultiParts) {
            this.txtSachnummerWert.setText(oTeil.getSachnummerGespreizt());
            this.tfSachnummer.setText(oTeil.getSachnummer());
            this.txtHgUgWert.setText(oTeil.getHG() + " " + oTeil.getUG());
            this.tfMenge.setText(oTeil.getMenge());
            this.tfBemerkungPos.setText(oTeil.getBemerkung());
            this.tfSplit.setText(oTeil.getSplitt());
            this.tfReTr.setText(oTeil.getTransparenz());
            this.tfPreis.setText(WebetkUtils.getPriceString(oTeil.getPreis()));
            this.tfRabatt.setText(oTeil.getRabattString());
            this.tfBenennung.setText(oTeil.getBenennung());
            this.txtBenennungWert.setText(oTeil.getBenennung());
            this.tfSuffix.setText(oTeil.getSuffix());
            this.chkLokalteil.setSelected(oTeil.getLokalteil());
            this.tfAuftragsnr.setText(oTeil.getAuftragsnummer());
            Long lKundennummer = oTeil.getKundennummer();
            String sKundennummer = "";
            if (lKundennummer != null) {
                sKundennummer = lKundennummer.toString();
            }
            this.tfKundennr.setText(sKundennummer);
        }
    }

    protected void layoutAll() {
        Container contentPane = this.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        contentPane.setLayout(l);
        contentPane.add((Component)this.headerPanel, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        contentPane.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    protected JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10};
        int[] heights = new int[]{10, 0, 20, 0, 10, 0, 0};
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(2, 1);
        panel.setLayout(layout);
        if (!this.mbMultiParts) {
            panel.add((Component)this.createTopPanel(), c.rc(2, 2, "lrtb"));
            JSeparator separator = new JSeparator(0);
            panel.add((Component)separator, c.rc(3, 2, "lrtb"));
            panel.add((Component)this.createTeilenummerPanel(), c.rc(4, 2, "lrtb"));
        } else {
            panel.add((Component)this.mHinweis, c.rc(4, 2, "lrtb"));
        }
        panel.add((Component)this.createCenterPanel(), c.rc(6, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(7, 2, "lrtb"));
        return panel;
    }

    protected JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{1, 0, 10, 0, 10, 0, 10, 0, 10, 0, 10, 0};
        int[] heights = new int[]{0, 10, 0, 10, 0, 10, 0, 10, 0, 10, 0, 10, 0};
        int[] widths_sore = new int[]{1, 0, 10, 0, 1};
        HIGLayout layout = null;
        if (!GlobalObjects.isScore()) {
            layout = new HIGLayout(widths, heights);
        } else {
            layout = new HIGLayout(widths_sore, heights);
            layout.setColumnWeight(4, 1);
        }
        panel.setLayout(layout);
        int nRow = 1;
        if (!this.mbMultiParts) {
            panel.add((Component)this.txtBenennung, c.rc(nRow, 2, "l"));
            if (!GlobalObjects.isScore()) {
                panel.add((Component)this.tfBenennung, c.rcwh(nRow, 4, 5, 1, "lr"));
            } else if (this.mbTeilVonScore) {
                panel.add((Component)this.txtBenennungWert, c.rc(nRow, 4, "lr"));
            } else {
                panel.add((Component)this.tfBenennung, c.rc(nRow, 4, "lr"));
            }
            nRow += 2;
        }
        panel.add((Component)this.txtMenge, c.rc(nRow, 2, "l"));
        if (!GlobalObjects.isScore()) {
            panel.add((Component)this.txtBemerkungPos, c.rc(nRow, 6, "l"));
        }
        panel.add((Component)this.tfMenge, c.rc(nRow, 4, "l"));
        if (!GlobalObjects.isScore()) {
            panel.add((Component)this.tfBemerkungPos, c.rc(nRow, 8, "l"));
        }
        if (!this.mbIstBestellliste && !this.mbIstRrSapListe) {
            if (!GlobalObjects.isScore()) {
                panel.add((Component)this.txtPreis, c.rc(nRow += 2, 2, "l"));
                panel.add((Component)this.tfPreis, c.rc(nRow, 4, "l"));
                if (!this.mbAddToIpac) {
                    panel.add((Component)this.txtRabatt, c.rc(nRow, 6, "l"));
                    panel.add((Component)this.tfRabatt, c.rc(nRow, 8, "l"));
                }
                if (this.model != null && this.model.istDMSAngeschlossen()) {
                    panel.add((Component)this.txtSplit, c.rc(nRow += 2, 2, "ltb"));
                    panel.add((Component)this.createSplitReTrSxPanel(), c.rcwh(nRow, 4, 3, 1, "ltb"));
                }
            } else if (this.ermittleShowJobSrpCombos()) {
                panel.add((Component)this.txtJob, c.rc(nRow += 2, 2, "l"));
                panel.add((Component)this.cbJob, c.rc(nRow, 4, "l"));
                panel.add((Component)this.txtSrp, c.rc(nRow += 2, 2, "l"));
                panel.add((Component)this.cbSrp, c.rc(nRow, 4, "l"));
                if (this.mbTeilVonScore) {
                    this.cbJob.setEnabled(false);
                    this.cbSrp.setEnabled(false);
                }
            }
        } else if (this.mbIstBestellliste) {
            panel.add((Component)this.txtAuftragsnr, c.rc(nRow += 2, 2, "l"));
            panel.add((Component)this.tfAuftragsnr, c.rc(nRow, 4, "l"));
            panel.add((Component)this.txtKundennr, c.rc(nRow, 6, "l"));
            panel.add((Component)this.tfKundennr, c.rc(nRow, 8, "l"));
        }
        return panel;
    }

    protected JPanel createTopPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.chkLokalteil);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    protected JPanel createTeilenummerPanel() {
        TitledPanel panel = new TitledPanel(Resource.getInstance().getTeilenummer());
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{1, 0, 10, 0, 10, 0, 10, 0};
        int[] heights = new int[]{10, 0, 10, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.txtHgUg, c.rc(2, 2, "lt"));
        panel.add((Component)this.txtSachnummer, c.rc(2, 4, "lt"));
        if (this.mbNeuanlage) {
            panel.add((Component)this.tfHgUg, c.rc(2, 6, "lt"));
            panel.add((Component)this.tfSachnummer, c.rc(2, 8, "lt"));
            panel.add((Component)this.txtTeilenummer_1_4, c.rc(4, 6, "lt"));
            panel.add((Component)this.txtTeilenummer_5_11, c.rc(4, 8, "lt"));
        } else {
            panel.add((Component)this.txtHgUgWert, c.rc(2, 6, "lt"));
            panel.add((Component)this.txtSachnummerWert, c.rc(2, 8, "lt"));
        }
        return panel;
    }

    protected JPanel createSplitReTrSxPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{0, 10, 0, 10, 0, 10, 0, 10, 0, 10, 0};
        int[] heights = new int[]{0};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.tfSplit, c.rc(1, 1, "ltb"));
        panel.add((Component)this.txtReTr, c.rc(1, 3, "ltb"));
        panel.add((Component)this.tfReTr, c.rc(1, 5, "ltb"));
        panel.add((Component)this.txtSuffix, c.rc(1, 7, "ltb"));
        panel.add((Component)this.tfSuffix, c.rc(1, 9, "ltb"));
        return panel;
    }

    protected JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-5, -4, 10, -2, -1};
        int[] heights = new int[]{0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(1, 1);
        layoutPosTeileliste.setColumnWeight(5, 1);
        layoutPosTeileliste.setRowWeight(2, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.buttonUebernehmen, c.rc(1, 2, "lrtb"));
        panel.add((Component)this.buttonAbbrechen, c.rc(1, 4, "lrtb"));
        this.buttonUebernehmen.setVerifyInputWhenFocusTarget(false);
        this.buttonUebernehmen.addActionListener(new OkButtonActionListener());
        this.buttonAbbrechen.setVerifyInputWhenFocusTarget(false);
        if (this.mbNeuanlage) {
            this.buttonAbbrechen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!EditTeil.this.mbAddToIpac && EditTeil.this.mbDataChanged) {
                        int nRet = JOptionPane.showConfirmDialog(MainView.getInstance(), Resource.getInstance().getAskAenderungenUebernehmen(), EditTeil.this.getTitle(), 1);
                        if (nRet == 2) {
                            return;
                        }
                        if (nRet == 0 && !EditTeil.this.addTeil()) {
                            return;
                        }
                    }
                    EditTeil.this.mDialogResult = -1;
                    EditTeil.this.dispose();
                }
            });
        } else {
            this.buttonAbbrechen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditTeil.this.dispose();
                }
            });
        }
        return panel;
    }

    protected void leereFelder() {
        this.tfAuftragsnr.setText("");
        this.tfBemerkungPos.setText("");
        this.tfBenennung.setText("");
        this.txtBenennungWert.setText("");
        this.tfHgUg.setText("");
        this.tfKundennr.setText("");
        this.tfMenge.setText("");
        this.tfPreis.setText("");
        this.tfRabatt.setText("");
        this.tfReTr.setText("");
        this.tfSachnummer.setText("");
        this.tfSplit.setText("");
        this.tfSuffix.setText("");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.mbNeuanlage) {
            this.tfHgUg.requestFocus();
        }
    }

    protected boolean addTeil() {
        if (!this.checkEingaben()) {
            return false;
        }
        Collection<Teil> cSelTeile = null;
        if (this.mbNeuanlage) {
            this.tfHgUg.requestFocus();
            Teil oTeil = this.erzeugeNeuesTeil();
            cSelTeile = new Vector<Teil>();
            cSelTeile.add(oTeil);
        } else {
            cSelTeile = this.model.getSelTeile();
            Vector kTeile = new Vector();
            String newSMenge = this.tfMenge.getText();
            if (newSMenge.length() > 0) {
                double newDMenge = Double.parseDouble(newSMenge);
                newSMenge = WebetkUtils.getPriceString(newDMenge);
                if (newDMenge <= 0.0) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getErrorTeilMengeNull(), Resource.getInstance().getTeilBearbeiten(), 0);
                    return false;
                }
                for (Teil aTeil : cSelTeile) {
                    if (!aTeil.getAspgTyp().equals("A")) continue;
                }
            }
            for (Teil oTeil : cSelTeile) {
                this.setzeDlgFelderBeimTeil(oTeil);
            }
            cSelTeile.addAll(kTeile);
        }
        return this.save(cSelTeile);
    }

    protected boolean checkEingaben() {
        int nSplit;
        boolean bLokalteil = this.chkLokalteil.isSelected();
        Teil oTeil = null;
        String sSachnummer = this.tfSachnummer.getText();
        if (this.mbNeuanlage) {
            if (!bLokalteil) {
                if (sSachnummer.length() != 7) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getWrongLengthSachnummer(), this.getTitle(), 0);
                    return false;
                }
                oTeil = this.loadTeilBasisdaten(sSachnummer);
                if (oTeil == null) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getLokalteilOnly(), this.getTitle(), 0);
                    return false;
                }
            } else if (sSachnummer.length() < 1) {
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getNoSachnummer(), this.getTitle(), 0);
                return false;
            }
        }
        String sMenge = this.tfMenge.getText();
        if (!this.mbMultiParts && sMenge.length() < 1) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getNoMenge(), this.getTitle(), 0);
            return false;
        }
        String sSplit = this.tfSplit.getText();
        if (sSplit != null && sSplit.length() > 0 && (nSplit = Integer.parseInt(sSplit)) == 0) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getNegativeSplittKennzeichen(), this.getTitle(), 0);
            return false;
        }
        if (GlobalObjects.isScore()) {
            ScorelisteJob job = (ScorelisteJob)this.cbJob.getSelectedItem();
            if (job.getId().length() < 1) {
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getMsgNoJob(), this.getTitle(), 0);
                return false;
            }
            ScorelisteSrp srp = (ScorelisteSrp)this.cbSrp.getSelectedItem();
            if (srp.getId().length() < 1) {
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getMsgNoSrp(), this.getTitle(), 0);
                return false;
            }
        }
        return true;
    }

    public Teil getTeil() {
        Teil teil = null;
        try {
            teil = this.erzeugeNeuesTeil();
        }
        catch (Exception e) {
            return null;
        }
        return teil;
    }

    protected Teil erzeugeNeuesTeil() {
        String sHgUG;
        String sSachnummer = this.tfSachnummer.getText().trim();
        Teil oTeil = this.loadTeilBasisdaten(sSachnummer);
        if (oTeil == null) {
            String sBemerkung = this.tfBemerkungPos.getText();
            String sMenge = this.tfMenge.getText();
            oTeil = new Teil(sSachnummer, sMenge, sBemerkung);
        }
        if ((sHgUG = this.tfHgUg.getText()).length() == 4) {
            oTeil.setHG(sHgUG.substring(0, 2));
            oTeil.setUG(sHgUG.substring(2, 4));
        } else if (sHgUG.length() > 2) {
            oTeil.setHG(sHgUG.substring(0, 2));
            oTeil.setUG(sHgUG.substring(2));
        } else {
            oTeil.setHG(sHgUG);
        }
        this.setzeDlgFelderBeimTeil(oTeil);
        if (this.mbAddToIpac) {
            return oTeil;
        }
        Vector<Teil> cTeile = this.model.getTeile();
        if (cTeile == null) {
            cTeile = new Vector();
            this.model.setTeile(cTeile);
        }
        int nPos = cTeile.size() + 1;
        oTeil.setPos(nPos);
        if (this.controller != null && this.controller instanceof DlgTeilelisteController) {
            Vector<Teil> vNewParts = new Vector<Teil>();
            vNewParts.add(oTeil);
            ((DlgTeilelisteModel)this.model).setNewParts(vNewParts);
            ((DlgTeilelisteController)this.controller).doDatenAbgleich(false);
            Collection<Teil> cNewParts = ((DlgTeilelisteModel)this.model).getNewParts();
            Iterator<Teil> iter = cNewParts.iterator();
            if (iter.hasNext()) {
                oTeil = iter.next();
            }
            ((DlgTeilelisteModel)this.model).setNewParts(null);
        }
        if (!GlobalObjects.isScore()) {
            cTeile.add(oTeil);
        } else {
            oTeil.setScoreLock(false);
            ScorelisteJob seljob = (ScorelisteJob)this.cbJob.getSelectedItem();
            String sJobId = seljob.getId();
            ScorelisteSrp selsrp = (ScorelisteSrp)this.cbSrp.getSelectedItem();
            String sSrpId = selsrp.getId();
            DlgTeilelisteModel oTLModel = (DlgTeilelisteModel)this.model;
            Scoreliste oSL = (Scoreliste)oTLModel.getTLDaten();
            oSL.addTeil(oTeil, sJobId, sSrpId);
        }
        return oTeil;
    }

    protected void setzeDlgFelderBeimTeil(Teil oTeil) {
        String sBemerkung;
        String sMenge;
        if (!this.mbMultiParts) {
            oTeil.setLokalteil(this.chkLokalteil.isSelected());
            oTeil.setBenennung(this.tfBenennung.getText());
        }
        if ((sMenge = this.tfMenge.getText()).length() > 0 || !this.mbMultiParts) {
            double dMenge = Double.parseDouble(sMenge);
            sMenge = WebetkUtils.getPriceString(dMenge);
            oTeil.setMenge(sMenge);
        }
        if ((sBemerkung = this.tfBemerkungPos.getText()).length() > 0 || !this.mbMultiParts) {
            oTeil.setBemerkung(sBemerkung);
        }
        if (!this.mbIstBestellliste && !this.mbIstRrSapListe) {
            String sSuffix;
            String sRabatt;
            String sPreis;
            String sReTr;
            String sSplit = this.tfSplit.getText();
            if (sSplit.length() > 0 || !this.mbMultiParts) {
                oTeil.setSplitt(sSplit);
            }
            if ((sReTr = this.tfReTr.getText()).length() > 0 || !this.mbMultiParts) {
                oTeil.setTransparenz(sReTr);
            }
            if ((sPreis = this.tfPreis.getText()).length() > 0) {
                oTeil.setPreis(new Double(sPreis));
            }
            if ((sRabatt = this.tfRabatt.getText()).length() > 0 || !this.mbMultiParts) {
                oTeil.setRabatt(sRabatt);
            }
            if ((sSuffix = this.tfSuffix.getText()).length() > 0 || !this.mbMultiParts) {
                oTeil.setSuffix(sSuffix);
            }
        } else if (this.mbIstBestellliste) {
            String sAuftragsnummer = this.tfAuftragsnr.getText();
            if (sAuftragsnummer.length() > 0 || !this.mbMultiParts) {
                oTeil.setAuftragsnummer(sAuftragsnummer);
            }
            Long lKundennummer = null;
            if (this.tfKundennr.getText().length() > 0) {
                lKundennummer = new Long(this.tfKundennr.getText());
            }
            if (lKundennummer != null || !this.mbMultiParts) {
                oTeil.setKundennummer(lKundennummer);
            }
        }
        oTeil.setUpdate(true);
    }

    protected boolean save(Collection<Teil> cTeile) {
        if (GlobalObjects.isScore()) {
            for (Teil oTeil : cTeile) {
                if (this.mbNeuanlage) {
                    oTeil.setScoreAenderung(2);
                    continue;
                }
                oTeil.setScoreAenderung(3);
            }
        }
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("teilelisteid", this.model.getSelTLID());
        if (this.model instanceof DlgTeilelisteModel) {
            DlgTeilelisteModel oTLModel = (DlgTeilelisteModel)this.model;
            trfTL.setValue("eigentuemer", oTLModel.getTLDaten().getNutzerID());
            trfTL.setValue("filialid", oTLModel.getTLDaten().getFiliale());
        }
        if (this.mbIstBestellliste) {
            trfTL.setValue("istbestellliste", "J");
        }
        if (GlobalObjects.isScore()) {
            ScorelisteJob seljob = (ScorelisteJob)this.cbJob.getSelectedItem();
            String sJobId = seljob.getId();
            ScorelisteSrp selsrp = (ScorelisteSrp)this.cbSrp.getSelectedItem();
            String sSrpId = selsrp.getId();
            Iterator<Teil> iTeile = cTeile.iterator();
            String sJobIdAlt = null;
            String sSrpIdAlt = null;
            while (iTeile.hasNext()) {
                Teil oTeil = iTeile.next();
                sJobIdAlt = oTeil.getJobId();
                if (sJobIdAlt == null || sJobIdAlt.length() < 1) {
                    sJobIdAlt = sJobId;
                }
                oTeil.setJobId(sJobId);
                sSrpIdAlt = oTeil.getSrpId();
                if (sSrpIdAlt == null || sSrpIdAlt.length() < 1) {
                    sSrpIdAlt = sSrpId;
                }
                oTeil.setSrpId(sSrpId);
            }
            trfTL.setValue("jobid", sJobIdAlt);
            trfTL.setValue("srpid", sSrpIdAlt);
            trfTL.setValue("score", true);
            GlobalObjects.getInstance().getEtkData().setScoreJobId(sJobId);
            GlobalObjects.getInstance().getEtkData().setScoreSrpId(sSrpId);
        }
        trfTL.setValue("teile", cTeile);
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (GlobalObjects.isScore() && this.mbNeuanlage) {
                GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.TEILELISTE_INSERT_TEILE);
            } else {
                GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.TEILELISTE_SAVE_TEIL);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (CommunicationException e) {
            log.error((Object)("EditTeileliste: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            this.setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), this.getTitle(), 0);
            return false;
        }
        if (trfTL.getError() != null) {
            String sMsg = "";
            Exception e = trfTL.getError();
            sMsg = e instanceof NoDataFoundException ? Resource.getInstance().getTeilNichtGefundenZuSachnummer() : Resource.getInstance().getSonstigerFehler() + ": " + trfTL.getError().getMessage();
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTL.getError());
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, this.getTitle(), 0);
            return false;
        }
        return true;
    }

    protected Teil loadTeilBasisdaten(String sSachnummer) {
        if (this.moTeilBasisDaten != null && this.moTeilBasisDaten.getSachnummer().equals(sSachnummer)) {
            return this.moTeilBasisDaten;
        }
        if (sSachnummer.length() < 1) {
            this.moTeilBasisDaten = new Teil();
            return this.moTeilBasisDaten;
        }
        TrfTeileliste trfTL = new TrfTeileliste(null);
        trfTL.setValue("sachnummer", sSachnummer);
        if (!(this.mbIstBestellliste || this.mbIstRrSapListe || this.mbAddToIpac)) {
            String sMarke = null;
            sMarke = ((DlgTeilelisteModel)this.model).getTLDaten() != null ? ((DlgTeilelisteModel)this.model).getTLDaten().getMarke() : ((DlgTeilelisteModel)this.model).getNeuanlageMarke();
            trfTL.setValue("marke", sMarke);
        } else if (this.mbIstRrSapListe) {
            trfTL.setValue("marke", Marken.getInstance().getMarke("RR").getBerechtigung());
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.LOAD_TEIL_BASISDATEN);
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (CommunicationException e) {
            log.error((Object)("EditTeileliste: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            this.setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), this.getTitle(), 0);
            return null;
        }
        if (trfTL.getError() != null) {
            if (trfTL.getError().getClass() == NoDataFoundException.class) {
                log.debug((Object)("EditTeileliste: Teil " + sSachnummer + " nicht gefunden."));
                return null;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTL.getError());
            JOptionPane.showMessageDialog(MainView.getInstance(), trfTL.getError().getMessage(), this.getTitle(), 0);
            return null;
        }
        log.debug((Object)("EditTeileliste: Teil " + sSachnummer + " gefunden."));
        this.moTeilBasisDaten = (Teil)trfTL.getValue("teil");
        return this.moTeilBasisDaten;
    }

    protected void addDataChangedListener(JTextField fld) {
        Document doc = fld.getDocument();
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent ev) {
                EditTeil.this.mbDataChanged = true;
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                EditTeil.this.mbDataChanged = true;
            }

            @Override
            public void changedUpdate(DocumentEvent ev) {
            }
        });
    }

    protected void doOkButtonAction() {
        if (this.mbAddToIpac) {
            this.mDialogResult = 1;
            this.dispose();
        } else if (this.mbNeuanlage) {
            if (!this.addTeil()) {
                return;
            }
            this.chkLokalteil.setSelected(false);
            this.leereFelder();
            this.mbDataChanged = false;
            this.controller.updateView();
        } else {
            if (!this.addTeil()) {
                return;
            }
            this.dispose();
        }
    }

    public int getDialogResult() {
        return this.mDialogResult;
    }

    protected boolean ermittleShowJobSrpCombos() {
        int nCountJobs = 0;
        int nCountSrps = 0;
        DlgTeilelisteModel oTlModel = (DlgTeilelisteModel)this.model;
        Teileliste oTl = oTlModel.getTLDaten();
        if (oTl instanceof Scoreliste) {
            Scoreliste oSl = (Scoreliste)oTl;
            Collection<ScorelisteJob> jobs = oSl.getJobs();
            for (ScorelisteJob job : jobs) {
                ++nCountJobs;
                Collection<ScorelisteSrp> srps = job.getSrps();
                nCountSrps += srps.size();
            }
        }
        return nCountJobs > 1 || nCountSrps > 1;
    }

    private class EnterKeyListener
    extends KeyAdapter {
        private EnterKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            if (ev.getKeyCode() == 10) {
                EditTeil.this.doOkButtonAction();
            }
        }
    }

    private class OkButtonActionListener
    implements ActionListener {
        private OkButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            EditTeil.this.doOkButtonAction();
        }
    }
}

