/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.JButtonEx;
import de.esg.commonclient.dialog.LimitedNumberField;
import de.esg.commonclient.dialog.LimitedTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.teileliste.Teil;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfTeileliste;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.extras.teileliste.AbstractListeModel;
import webetk.javaclient.framework.MainView;
import webetk.resources.Resource;

public class EditTeilKlein
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(EditTeilKlein.class);
    private AbstractListeModel mModel;
    private String msMenge;
    private String msJob = null;
    private String msSrp = null;
    private HeaderPanel headerPanel;
    private JLabel txtHgUg;
    private JLabel txtHgUgWert;
    private JLabel txtSachnummer;
    private JLabel txtSachnummerWert;
    private JLabel txtMenge;
    private JTextField tfMenge;
    private JButtonEx buttonUebernehmen;
    private JButtonEx buttonAbbrechen;
    private JLabel txtSplit;
    private JLabel txtReTr;
    private JTextField tfSplit;
    private JTextField tfReTr;

    public EditTeilKlein(AbstractListeModel model, String sMenge) {
        super((Frame)MainView.getInstance(), true);
        this.mModel = model;
        this.msMenge = sMenge;
        this.headerPanel = new HeaderPanel(Resource.getInstance().getTeilHinzufuegen(), null);
        if (this.mModel.istDMSAngeschlossen()) {
            this.setSize(550, 280);
        } else {
            this.setSize(285, 280);
        }
        this.setLocation(50, 10);
        this.initComponents();
        int nLength = this.tfMenge.getText().length();
        this.tfMenge.setSelectionStart(0);
        this.tfMenge.setSelectionEnd(nLength);
    }

    public EditTeilKlein(AbstractListeModel model) {
        super((Frame)MainView.getInstance(), true);
        this.mModel = model;
        this.headerPanel = new HeaderPanel(Resource.getInstance().getTeilHinzufuegen(), null);
        this.setMinimumSize(new Dimension(420, 400));
        this.setPreferredSize(this.getMinimumSize());
        this.setSize(this.getMinimumSize());
        this.setLocation(new Point(50, 10));
        this.initComponentsMultiSelect();
        int nLength = this.tfSplit.getText().length();
        this.tfSplit.setSelectionStart(0);
        this.tfSplit.setSelectionEnd(nLength);
    }

    public void setJobSrp(String sJob, String sSrp) {
        this.msJob = sJob;
        this.msSrp = sSrp;
    }

    private void initComponents() {
        Iterator<Teil> iter;
        this.setTitle(Resource.getInstance().getTeilBearbeiten());
        this.headerPanel.setBigTitle(Resource.getInstance().getTeilBearbeiten());
        this.txtHgUg = new JLabel(Resource.getInstance().getHgug());
        this.txtHgUgWert = new JLabel("52 20");
        this.txtSachnummer = new JLabel(Resource.getInstance().getSachnummer());
        this.txtSachnummerWert = new JLabel("8 219 115");
        this.txtMenge = new JLabel(Resource.getInstance().getMenge());
        this.tfMenge = new LimitedNumberField(9, true, true);
        this.tfMenge.addActionListener(new OkButtonActionListener());
        this.txtSplit = new JLabel(Resource.getInstance().getSplittKennzeichen());
        this.txtReTr = new JLabel(Resource.getInstance().getRechnungstransparenz());
        this.tfSplit = new LimitedNumberField(2);
        this.tfSplit.addActionListener(new OkButtonActionListener());
        this.tfReTr = new LimitedTextField(4);
        this.tfReTr.addActionListener(new OkButtonActionListener());
        this.buttonUebernehmen = new JButtonEx(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.buttonUebernehmen.addActionListener(new OkButtonActionListener());
        this.buttonAbbrechen = new JButtonEx(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.buttonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditTeilKlein.this.dispose();
            }
        });
        Collection<Teil> cTeile = this.mModel.getSelTeile();
        if (cTeile != null && (iter = cTeile.iterator()).hasNext()) {
            Teil oTeil = iter.next();
            this.txtSachnummerWert.setText(oTeil.getSachnummerGespreizt());
            this.txtHgUgWert.setText(oTeil.getHG() + " " + oTeil.getUG());
            if (this.msMenge == null) {
                this.msMenge = oTeil.getMenge();
            }
            this.tfMenge.setText(this.msMenge);
            this.tfSplit.setText(oTeil.getSplitt());
            this.tfReTr.setText(oTeil.getTransparenz());
        }
        this.layoutAll();
    }

    private void initComponentsMultiSelect() {
        this.setTitle(Resource.getInstance().getTeilBearbeiten());
        this.headerPanel.setBigTitle(Resource.getInstance().getTeilBearbeiten());
        this.txtSplit = new JLabel(Resource.getInstance().getSplittKennzeichen());
        this.tfSplit = new LimitedNumberField(2);
        this.tfSplit.addActionListener(new OkButtonActionListener());
        this.txtReTr = new JLabel(Resource.getInstance().getRechnungstransparenz());
        this.tfReTr = new LimitedTextField(4);
        this.tfReTr.addActionListener(new OkButtonActionListener());
        this.buttonUebernehmen = new JButtonEx(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.buttonUebernehmen.addActionListener(new OkButtonActionListenerMultiSelection());
        this.buttonAbbrechen = new JButtonEx(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.buttonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditTeilKlein.this.dispose();
            }
        });
        Collection<Teil> cTeile = this.mModel.getSelTeile();
        if (cTeile != null) {
            HashMap<String, String> hmCheckIdentSplitt = new HashMap<String, String>();
            HashMap<String, String> hmCheckIdentTransp = new HashMap<String, String>();
            Iterator<Teil> iter = cTeile.iterator();
            Teil oTeil = null;
            while (iter.hasNext()) {
                oTeil = iter.next();
                hmCheckIdentSplitt.put(oTeil.getSplitt(), oTeil.getSplitt());
                hmCheckIdentTransp.put(oTeil.getTransparenz(), oTeil.getTransparenz());
            }
            if (!hmCheckIdentSplitt.isEmpty() && hmCheckIdentSplitt.size() == 1) {
                this.tfSplit.setText(oTeil.getSplitt());
            } else {
                this.tfSplit.setText("");
            }
            if (!hmCheckIdentTransp.isEmpty() && hmCheckIdentTransp.size() == 1) {
                this.tfReTr.setText(oTeil.getTransparenz());
            } else {
                this.tfReTr.setText("");
            }
        } else {
            this.tfSplit.setText("");
            this.tfReTr.setText("");
        }
        this.layoutAllMultiSelection();
    }

    private void layoutAll() {
        Container contentPane = this.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        contentPane.setLayout(l);
        contentPane.add((Component)this.headerPanel, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        contentPane.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    private void layoutAllMultiSelection() {
        Container contentPane = this.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        contentPane.setLayout(l);
        contentPane.add((Component)this.headerPanel, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContentMultiSelection();
        contentPane.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    private JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0};
        int[] heights = new int[]{10, 0, 20, 0, 10, 0};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.createTeilenummerPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createCenterPanel(), c.rc(4, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(6, 2, "lrtb"));
        return panel;
    }

    private JPanel createContentMultiSelection() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0};
        int[] heights = new int[]{10, 0, 20, 0, 10, 0};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.createTeilenummerPanelMultiSelection(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createCenterPanelMultiSelection(), c.rc(4, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(6, 2, "lrtb"));
        return panel;
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{1, 0, 10, 0, 10, 0, 10, 0, 10, 0, 10, 0};
        int[] heights = new int[]{0, 10};
        HIGLayout layout = new HIGLayout(widths, heights);
        panel.setLayout(layout);
        panel.add((Component)this.txtMenge, c.rc(1, 2, "l"));
        panel.add((Component)this.tfMenge, c.rc(1, 4, "l"));
        if (this.mModel.istDMSAngeschlossen()) {
            panel.add((Component)this.txtSplit, c.rc(1, 6, "ltb"));
            panel.add((Component)this.tfSplit, c.rc(1, 8, "ltb"));
            panel.add((Component)this.txtReTr, c.rc(1, 10, "ltb"));
            panel.add((Component)this.tfReTr, c.rc(1, 12, "ltb"));
        }
        return panel;
    }

    private JPanel createCenterPanelMultiSelection() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{1, 0, 10, 0, 10, 0, 10, 0, 10, 0, 10, 0};
        int[] heights = new int[]{0, 10};
        HIGLayout layout = new HIGLayout(widths, heights);
        panel.setLayout(layout);
        panel.add((Component)this.txtSplit, c.rc(1, 6, "ltb"));
        panel.add((Component)this.tfSplit, c.rc(1, 8, "ltb"));
        panel.add((Component)this.txtReTr, c.rc(1, 10, "ltb"));
        panel.add((Component)this.tfReTr, c.rc(1, 12, "ltb"));
        return panel;
    }

    private JPanel createTeilenummerPanel() {
        TitledPanel panel = new TitledPanel(Resource.getInstance().getTeilenummer());
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{1, 0, 10, 0, 10, 0, 10, 0};
        int[] heights = new int[]{10, 0, 10, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.txtHgUg, c.rc(2, 2, "lt"));
        panel.add((Component)this.txtSachnummer, c.rc(2, 4, "lt"));
        panel.add((Component)this.txtHgUgWert, c.rc(2, 6, "lt"));
        panel.add((Component)this.txtSachnummerWert, c.rc(2, 8, "lt"));
        return panel;
    }

    private JPanel createTeilenummerPanelMultiSelection() {
        HIGConstraints c = new HIGConstraints();
        TitledPanel panel = new TitledPanel(Resource.getInstance().getTeilenummer());
        int[] widthsPanel = new int[]{10, 0, 10, 0, 10, 0};
        int[] heightsPanel = new int[]{10, 0};
        HIGLayout layoutPosTeilelistePanel = new HIGLayout(widthsPanel, heightsPanel);
        panel.setLayout(layoutPosTeilelistePanel);
        this.txtHgUg = new JLabel(Resource.getInstance().getHgug());
        panel.add((Component)this.txtHgUg, c.rc(2, 2, "lt"));
        this.txtSachnummer = new JLabel(Resource.getInstance().getSachnummer());
        panel.add((Component)this.txtSachnummer, c.rc(2, 4, "lt"));
        panel.add((Component)this.createTeilenummerPanelMultiSelectionTextArea(this.txtHgUg.getFont()), c.rc(2, 6, "lt"));
        return panel;
    }

    private JScrollPane createTeilenummerPanelMultiSelectionTextArea(Font pFont) {
        Collection<Teil> cTeile = this.mModel.getSelTeile();
        String text = "";
        if (cTeile != null) {
            for (Teil oTeil : cTeile) {
                text = text + oTeil.getHG() + " " + oTeil.getUG() + " " + oTeil.getSachnummerGespreizt() + "\n";
            }
        }
        JTextArea txtArea = new JTextArea(text);
        txtArea.setAutoscrolls(true);
        txtArea.setEditable(false);
        txtArea.setLineWrap(true);
        txtArea.setWrapStyleWord(true);
        txtArea.setBackground(this.getBackground());
        txtArea.setFont(pFont);
        txtArea.setForeground(this.getForeground());
        JScrollPane scrollPane = new JScrollPane(txtArea);
        scrollPane.setPreferredSize(new Dimension(150, 150));
        return scrollPane;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-5, -4, 10, -2, -1};
        int[] heights = new int[]{0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(1, 1);
        layoutPosTeileliste.setColumnWeight(5, 1);
        layoutPosTeileliste.setRowWeight(2, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.buttonUebernehmen, c.rc(1, 2, "lrtb"));
        panel.add((Component)this.buttonAbbrechen, c.rc(1, 4, "lrtb"));
        return panel;
    }

    private boolean addTeil() {
        if (!this.checkEingaben()) {
            return false;
        }
        Collection<Teil> cSelTeile = null;
        cSelTeile = this.mModel.getSelTeile();
        String newSMenge = this.tfMenge.getText();
        double newDMenge = Double.parseDouble(newSMenge);
        newSMenge = WebetkUtils.getPriceString(newDMenge);
        if (newDMenge <= 0.0) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getErrorTeilMengeNull(), Resource.getInstance().getTeilBearbeiten(), 0);
            return false;
        }
        for (Teil oTeil : cSelTeile) {
            String sMenge = this.tfMenge.getText();
            double dMenge = Double.parseDouble(sMenge);
            sMenge = WebetkUtils.getPriceString(dMenge);
            oTeil.setMenge(sMenge);
            String sSplit = this.tfSplit.getText();
            oTeil.setSplitt(sSplit);
            String sReTr = this.tfReTr.getText();
            oTeil.setTransparenz(sReTr);
            oTeil.setUpdate(true);
            oTeil.setScoreAenderung(3);
        }
        return this.save(cSelTeile);
    }

    private boolean addTeilMultiSelection() {
        if (!this.checkEingabenMultiSelection()) {
            return false;
        }
        Collection<Teil> cSelTeile = null;
        cSelTeile = this.mModel.getSelTeile();
        for (Teil oTeil : cSelTeile) {
            String sSplit = this.tfSplit.getText();
            oTeil.setSplitt(sSplit);
            String sReTr = this.tfReTr.getText();
            oTeil.setTransparenz(sReTr);
            oTeil.setUpdate(true);
            oTeil.setScoreAenderung(3);
        }
        return this.save(cSelTeile);
    }

    private boolean checkEingaben() {
        return this.checkEingabeMenge() && this.checkEingabeSplitt();
    }

    private boolean checkEingabenMultiSelection() {
        return this.checkEingabeSplitt();
    }

    private boolean checkEingabeMenge() {
        String sMenge = this.tfMenge.getText();
        if (sMenge.length() < 1) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getNoMenge(), this.getTitle(), 0);
            return false;
        }
        return true;
    }

    private boolean checkEingabeSplitt() {
        int nSplit;
        String sSplit = this.tfSplit.getText();
        if (sSplit != null && sSplit.length() > 0 && (nSplit = Integer.parseInt(sSplit)) == 0) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getNegativeSplittKennzeichen(), this.getTitle(), 0);
            return false;
        }
        return true;
    }

    private boolean save(Collection<Teil> cTeile) {
        TrfTeileliste trfTL = new TrfTeileliste(null);
        String sListenID = this.mModel.getSelTLID();
        trfTL.setValue("teilelisteid", sListenID);
        trfTL.setValue("teile", cTeile);
        if (this.msJob != null) {
            trfTL.setValue("jobid", this.msJob);
        }
        if (this.msSrp != null) {
            trfTL.setValue("srpid", this.msSrp);
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTL, Command.TEILELISTE_SAVE_TEIL);
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (CommunicationException e) {
            log.error((Object)("EditTeilKleineliste: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            this.setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), this.getTitle(), 0);
            return false;
        }
        if (trfTL.getError() != null) {
            String sMsg = "";
            Exception e = trfTL.getError();
            sMsg = e instanceof NoDataFoundException ? Resource.getInstance().getTeilNichtGefundenZuSachnummer() : Resource.getInstance().getSonstigerFehler() + ": " + trfTL.getError().getMessage();
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTL.getError());
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, this.getTitle(), 0);
            return false;
        }
        return true;
    }

    private void doOkButtonAction() {
        if (!this.addTeil()) {
            return;
        }
        this.dispose();
    }

    private void doOkButtonActionMultiSelection() {
        if (!this.addTeilMultiSelection()) {
            return;
        }
        this.dispose();
    }

    private class OkButtonActionListenerMultiSelection
    implements ActionListener {
        private OkButtonActionListenerMultiSelection() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            EditTeilKlein.this.doOkButtonActionMultiSelection();
        }
    }

    private class OkButtonActionListener
    implements ActionListener {
        private OkButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            EditTeilKlein.this.doOkButtonAction();
        }
    }
}

