/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import webetk.app.konfiguration.Nutzer;
import webetk.communication.CommunicationException;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.resources.Resource;

public class EigentuemerAendern
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(EigentuemerAendern.class);
    private HashMap<String, Object> mMapReturnValues;
    public static final String RET = "ret";
    public static final String ID_NEW_USER = "idNewUser";
    public static final String NAME_NEW_USER = "nameNewUser";
    private HeaderPanel mHeaderPanel;
    private GenericTable table;
    private GenericTableModel tabmodel;
    private ArrayList<String> maIDs;
    private ArrayList<String> maNamen;
    private String msFilialId;
    private JButtonEx mButtonUebernehmen;
    private JButtonEx mButtonAbbrechen;

    public EigentuemerAendern(String sFilialId, HashMap<String, Object> mapReturnValues) {
        super((Frame)MainView.getInstance(), true);
        this.msFilialId = sFilialId;
        this.mMapReturnValues = mapReturnValues;
        this.mHeaderPanel = new HeaderPanel(Resource.getInstance().getEigentuemerAendern(), null);
        this.setSize(290, 380);
        this.setLocation(50, 10);
        this.initComponents();
        this.loadNutzer();
        this.update();
    }

    private void initComponents() {
        this.setTitle(Resource.getInstance().getEigentuemerAendern());
        this.mButtonUebernehmen = new JButtonEx(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.mButtonAbbrechen = new JButtonEx(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.maIDs = new ArrayList();
        this.maNamen = new ArrayList();
        this.layoutAll();
    }

    private JComponent createTabelle() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn(Resource.getInstance().getNeuerEigentuemer(), 2, false, "XXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        tableConfig.setUsePrototypeIcons(true);
        this.tabmodel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tabmodel);
        this.table.setAllowSizingSmallerThanMinimumWidth(false);
        this.table.getTable().setSelectionMode(0);
        this.table.getTable().getSelectionModel().addListSelectionListener(new TableListSelectionListener());
        this.table.getTable().addKeyListener(new EnterKeyListener());
        InputMap im = this.table.getTable().getInputMap(1);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        im.put(enter, "none");
        return this.table.getScrollPane();
    }

    private void layoutAll() {
        Container contentPane = this.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        contentPane.setLayout(l);
        contentPane.add((Component)this.mHeaderPanel, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        contentPane.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    private JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0};
        int[] heights = new int[]{10, 0, 10, 0, 10};
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(2, 1);
        layout.setRowWeight(2, 1);
        panel.setLayout(layout);
        panel.add((Component)this.createCenterPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(4, 2, "lrtb"));
        return panel;
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10};
        int[] heights = new int[]{10, 0, 10};
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(2, 1);
        layout.setRowWeight(2, 1);
        panel.setLayout(layout);
        panel.add((Component)this.createTabelle(), c.rc(2, 2));
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-5, -4, 10, -2, -1};
        int[] heights = new int[]{0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(1, 1);
        layoutPosTeileliste.setColumnWeight(5, 1);
        layoutPosTeileliste.setRowWeight(2, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.mButtonUebernehmen, c.rc(1, 2, "lrtb"));
        this.mButtonUebernehmen.setEnabled(false);
        panel.add((Component)this.mButtonAbbrechen, c.rc(1, 4, "lrtb"));
        this.mButtonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EigentuemerAendern.this.doUebernehmenButtonAction();
            }
        });
        this.mButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EigentuemerAendern.this.mMapReturnValues.put(EigentuemerAendern.RET, 2);
                EigentuemerAendern.this.dispose();
            }
        });
        return panel;
    }

    private void update() {
        for (int ii = 0; ii < this.maIDs.size(); ++ii) {
            String sName = this.maNamen.get(ii);
            AbstractRow oRow = new AbstractRow(new Object[]{sName});
            this.tabmodel.addRow(oRow);
        }
    }

    private void loadNutzer() {
        log.debug((Object)"Performing loadNutzer");
        this.maIDs.clear();
        this.maNamen.clear();
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trf = new TrfHashMap(null);
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        trf.setValue("filialid", this.msFilialId);
        trf.setValue("firmaid", oLoginInfo.getFirmaId());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.LOAD_USER_BY_FILIALID);
        }
        catch (CommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ex.getMessage(), Resource.getInstance().getEigentuemerAendern(), 0);
            return;
        }
        if (trf.getError() != null) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + trf.getError().getMessage(), Resource.getInstance().getEigentuemerAendern(), 0);
            return;
        }
        List nutzerList = (List)trf.getValue("nutzer_list");
        if (nutzerList != null) {
            for (Nutzer nutzer : nutzerList) {
                String userID = nutzer.getUserId();
                if (userID.equals("score")) continue;
                this.maIDs.add(userID);
                this.maNamen.add(nutzer.getUserName());
            }
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    private void doUebernehmenButtonAction() {
        int nRow = this.table.getTable().getSelectedRow();
        String sID = this.maIDs.get(nRow);
        String sName = this.maNamen.get(nRow);
        this.mMapReturnValues.put(ID_NEW_USER, sID);
        this.mMapReturnValues.put(NAME_NEW_USER, sName);
        this.mMapReturnValues.put(RET, 0);
        this.dispose();
    }

    private class TableListSelectionListener
    implements ListSelectionListener {
        private TableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            EigentuemerAendern.this.mButtonUebernehmen.setEnabled(EigentuemerAendern.this.table.getTable().getSelectedRow() > -1);
        }
    }

    private class EnterKeyListener
    extends KeyAdapter {
        private EnterKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            if (ev.getKeyCode() == 10 && EigentuemerAendern.this.mButtonUebernehmen.isEnabled()) {
                EigentuemerAendern.this.doUebernehmenButtonAction();
            }
        }
    }
}

