/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import webetk.app.teileliste.Teil;
import webetk.app.teileliste.Teileliste;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.resources.Resource;

public class FZZuordnung {
    private JDialog mDlg = new JDialog((Frame)MainView.getInstance(), true);
    private DlgTeilelisteModel mModel;
    private HeaderPanel mHeaderPanel;
    private JButtonEx mButtonSchliessen;
    private GenericTable mtable;
    private GenericTableModel mtabmodel;

    public FZZuordnung(DlgTeilelisteModel model) {
        this.mDlg.setSize(590, 400);
        this.mDlg.setLocation(50, 10);
        this.mModel = model;
    }

    public boolean show() {
        this.mHeaderPanel = new HeaderPanel(Resource.getInstance().getFahrzeugumfang(), null);
        this.initComponents();
        this.mDlg.setVisible(true);
        return true;
    }

    private void initComponents() {
        this.mDlg.setTitle(Resource.getInstance().getFahrzeugumfang());
        this.mButtonSchliessen = new JButtonEx(Resource.getInstance().getSchlieszen(), ImageCache.getInstance().getIcon("ok.gif"));
        this.mButtonSchliessen.addActionListener(new CloseButtonActionListener());
        this.layoutAll();
        this.update();
    }

    private void layoutAll() {
        Container contentPane = this.mDlg.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        contentPane.setLayout(l);
        contentPane.add((Component)this.mHeaderPanel, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        contentPane.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    private JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0};
        int[] heights = new int[]{10, 0, 10, 0, 10};
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setRowWeight(2, 1);
        panel.setLayout(layout);
        panel.add((Component)this.createCenterPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(4, 2, "lrtb"));
        return panel;
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10};
        int[] heights = new int[]{10, 0, 10, 0, 10};
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setRowWeight(4, 1);
        panel.setLayout(layout);
        panel.add((Component)this.createTabelle(), c.rc(4, 2));
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-3, 0, -1};
        int[] heights = new int[]{0, 10};
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(1, 1);
        layout.setColumnWeight(3, 1);
        layout.setRowWeight(2, 1);
        panel.setLayout(layout);
        panel.add((Component)this.mButtonSchliessen, c.rc(1, 2, "lrtb"));
        return panel;
    }

    private JComponent createTabelle() {
        TableConfiguration tableConfig = new TableConfiguration();
        int nCol = 0;
        tableConfig.addColumn("", 0, false, "X");
        ++nCol;
        tableConfig.addColumn("", 2, false, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        ++nCol;
        tableConfig.setUsePrototypeIcons(true);
        this.mtabmodel = new GenericTableModel(tableConfig);
        this.mtable = new GenericTable(this.mtabmodel);
        this.mtable.getTable().setSelectionMode(0);
        this.mtable.setAllowSizingSmallerThanMinimumWidth(false);
        this.mtable.getTable().addKeyListener(new EnterKeyListener());
        return this.mtable.getScrollPane();
    }

    private void update() {
        Teileliste oTLDaten = this.mModel.getTLDaten();
        this.mtabmodel.removeAllRows();
        Vector<Teil> aTeile = oTLDaten.getTeile();
        String sLastKuerzel = "";
        if (aTeile != null) {
            Iterator iterator = aTeile.iterator();
            Iterator<String> iterKuerzel = oTLDaten.ermittleFIKuerzel(true);
            while (iterator.hasNext()) {
                Teil oTeil = (Teil)iterator.next();
                String sFIKuerzel = iterKuerzel.next();
                if (sFIKuerzel.compareTo(sLastKuerzel) <= 0) continue;
                this.mtabmodel.addRow(new AbstractRow(new Object[]{sFIKuerzel, oTeil.getFIString()}));
                sLastKuerzel = sFIKuerzel;
            }
        }
    }

    protected class EnterKeyListener
    extends KeyAdapter {
        protected EnterKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            if (ev.getKeyCode() == 10) {
                FZZuordnung.this.mDlg.dispose();
            }
        }
    }

    protected class CloseButtonActionListener
    implements ActionListener {
        protected CloseButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            FZZuordnung.this.mDlg.dispose();
        }
    }
}

