/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.AttributedString;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.resources.Resource;

public class FaxAngaben
implements Printable {
    private JDialog dlg;
    protected JPanel headerPanel;
    private Container contentPane;
    private JLabel txtAn;
    private JLabel txtVon;
    private JLabel txtAnFax;
    private JLabel txtVonFax;
    private JLabel txtVonTel;
    private JLabel txtBetreff;
    private JTextField tfAn;
    private JTextField tfAn2;
    private JTextField tfAn3;
    private JTextField tfAnFax;
    private JTextField tfVon;
    private JTextField tfVon2;
    private JTextField tfVon3;
    private JTextField tfVonFax;
    private JTextField tfVonTel;
    private JTextField tfBetreff;
    private JButtonEx buttonUebernehmen;
    private JButtonEx buttonAbbrechen;
    private int nInd;
    private int oInd;
    private int lastPageIndex;
    private DlgTeilelisteView view;

    public FaxAngaben(DlgTeilelisteView dialogView) {
        this.view = dialogView;
        this.dlg = new JDialog((Frame)MainView.getInstance(), false);
        this.dlg.setModal(true);
        this.dlg.setTitle(Resource.getInstance().getTeilelisteAlsFaxAusdrucken());
        this.dlg.setSize(620, 510);
        this.dlg.setLocation(50, 10);
        this.initComponents();
    }

    public void initComponents() {
        this.headerPanel = new HeaderPanel(Resource.getInstance().getTeilelisteAlsFaxAusdrucken(), null);
        this.txtAn = new JLabel(Resource.getInstance().getAn());
        this.tfAn = new JTextField(40);
        this.tfAn2 = new JTextField(40);
        this.tfAn3 = new JTextField(40);
        this.tfAnFax = new JTextField(40);
        this.txtVon = new JLabel(Resource.getInstance().getVon());
        this.tfVon = new JTextField(40);
        this.tfVon2 = new JTextField(40);
        this.tfVon3 = new JTextField(40);
        this.tfVonFax = new JTextField(40);
        this.tfVonTel = new JTextField(40);
        this.tfVon = new JTextField(40);
        this.txtAnFax = new JLabel(Resource.getInstance().getFax());
        this.txtVonFax = new JLabel(Resource.getInstance().getFax());
        this.txtVonTel = new JLabel(Resource.getInstance().getTelefon());
        this.txtBetreff = new JLabel(Resource.getInstance().getBetreff());
        this.tfBetreff = new JTextField(40);
        this.buttonUebernehmen = new JButtonEx("", ImageCache.getInstance().getIcon("arrw04_10b.gif"));
        this.buttonAbbrechen = new JButtonEx(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.layoutAll();
    }

    protected void layoutAll() {
        this.contentPane = this.dlg.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.contentPane.setLayout(l);
        this.contentPane.add((Component)this.headerPanel, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        this.contentPane.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    public JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0};
        int[] heights = new int[]{10, 0, 0};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.createCenterPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(3, 2, "lrtb"));
        return panel;
    }

    public JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10, 0, 10};
        int[] heights = new int[]{10, 0, 10, 0, 10, 0, 10, 0, 25, 0, 10, 0, 10, 0, 10, 0, 10, 0, 25, 0};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.txtAn, c.rc(2, 2, "lt"));
        panel.add((Component)this.tfAn, c.rc(2, 4, "lt"));
        panel.add((Component)this.tfAn2, c.rc(4, 4, "lt"));
        panel.add((Component)this.tfAn3, c.rc(6, 4, "lt"));
        panel.add((Component)this.txtAnFax, c.rc(8, 2, "lt"));
        panel.add((Component)this.tfAnFax, c.rc(8, 4, "lt"));
        panel.add((Component)this.txtVon, c.rc(10, 2, "lt"));
        panel.add((Component)this.tfVon, c.rc(10, 4, "lt"));
        panel.add((Component)this.tfVon2, c.rc(12, 4, "lt"));
        panel.add((Component)this.tfVon3, c.rc(14, 4, "lt"));
        panel.add((Component)this.txtVonFax, c.rc(16, 2, "lt"));
        panel.add((Component)this.tfVonFax, c.rc(16, 4, "lt"));
        panel.add((Component)this.txtVonTel, c.rc(18, 2, "lt"));
        panel.add((Component)this.tfVonTel, c.rc(18, 4, "lt"));
        panel.add((Component)this.txtBetreff, c.rc(20, 2, "lt"));
        panel.add((Component)this.tfBetreff, c.rc(20, 4, "lt"));
        return panel;
    }

    public JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-5, -4, 10, -2, -1};
        int[] heights = new int[]{20, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(1, 1);
        layoutPosTeileliste.setColumnWeight(5, 1);
        layoutPosTeileliste.setRowWeight(3, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.buttonUebernehmen, c.rc(2, 2, "lrtb"));
        panel.add((Component)this.buttonAbbrechen, c.rc(2, 4, "lrtb"));
        this.buttonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FaxAngaben.this.tfAn.getText().length() < 1 || FaxAngaben.this.tfAnFax.getText().length() < 1 || FaxAngaben.this.tfVon.getText().length() < 1) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getTeilelisteNoFaxangaben(), FaxAngaben.this.dlg.getTitle(), 0);
                    return;
                }
                FaxAngaben.this.print();
                FaxAngaben.this.dlg.dispose();
            }
        });
        this.buttonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaxAngaben.this.dlg.dispose();
            }
        });
        return panel;
    }

    public void show() {
        this.dlg.setVisible(true);
    }

    protected void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printJob.defaultPage();
        Paper paper = new Paper();
        paper.setSize(pageFormat.getWidth(), pageFormat.getHeight());
        paper.setImageableArea(pageFormat.getImageableX() - 30.0, pageFormat.getImageableY() - 20.0, pageFormat.getImageableWidth() + 60.0, pageFormat.getImageableHeight() + 40.0);
        pageFormat.setPaper(paper);
        printJob.setPrintable(this, pageFormat);
        printJob.setJobName(Resource.getInstance().getTeilelisteFaxansicht());
        this.oInd = 0;
        this.nInd = 0;
        this.lastPageIndex = -1;
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.lastPageIndex == pageIndex) {
            this.nInd = this.oInd;
        } else {
            this.lastPageIndex = pageIndex;
            this.oInd = this.nInd;
        }
        GenericTableModel tabmodel = this.view.getTableModel();
        if (this.nInd >= tabmodel.getRowCount()) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int maxWidth = (int)pageFormat.getImageableWidth() - 1;
        int maxHeight = (int)pageFormat.getImageableHeight() - 2;
        Font headlinefont = UIHelper.getFaxBigTitleFont();
        Font textfont = UIHelper.getFaxSmallTitleFont();
        Font tablefont = UIHelper.getFaxFont();
        int xPosition = 0;
        int yPosition = 0;
        int secondColumnPosition = 100;
        g2d.setFont(textfont);
        int fontSize = textfont.getSize() + 2;
        if (pageIndex == 0) {
            yPosition = fontSize;
            g2d.drawString(Resource.getInstance().getAn() + ":", xPosition, yPosition);
            g2d.drawString(this.tfAn.getText(), secondColumnPosition, yPosition);
            g2d.drawString(this.tfAn2.getText(), secondColumnPosition, yPosition += fontSize);
            g2d.drawString(this.tfAn3.getText(), secondColumnPosition, yPosition += fontSize);
            g2d.drawString(Resource.getInstance().getFax() + ":", xPosition, yPosition += fontSize);
            g2d.drawString(this.tfAnFax.getText(), secondColumnPosition, yPosition);
            yPosition += fontSize;
            g2d.drawString(Resource.getInstance().getVon() + ":", xPosition, yPosition += fontSize);
            g2d.drawString(this.tfVon.getText(), secondColumnPosition, yPosition);
            g2d.drawString(this.tfVon2.getText(), secondColumnPosition, yPosition += fontSize);
            g2d.drawString(this.tfVon3.getText(), secondColumnPosition, yPosition += fontSize);
            g2d.drawString(Resource.getInstance().getFax() + ":", xPosition, yPosition += fontSize);
            g2d.drawString(this.tfVonFax.getText(), secondColumnPosition, yPosition);
            g2d.drawString(Resource.getInstance().getTelefon() + ":", xPosition, yPosition += fontSize);
            g2d.drawString(this.tfVonTel.getText(), secondColumnPosition, yPosition);
            yPosition += fontSize;
            g2d.drawString(Resource.getInstance().getBetreff() + ":", xPosition, yPosition += fontSize);
            g2d.drawString(this.tfBetreff.getText(), secondColumnPosition, yPosition);
            g2d.drawString(Resource.getInstance().getAnzahlSeiten() + ":", xPosition, yPosition += fontSize);
            g2d.setFont(headlinefont);
            g2d.drawString(Resource.getInstance().getBmwTeileliste(), xPosition, yPosition += 4 * fontSize);
            yPosition += fontSize;
            g2d.setFont(textfont);
            fontSize = textfont.getSize() + 2;
            g2d.drawString(Resource.getInstance().getTeileliste() + ":", xPosition, yPosition += fontSize);
            g2d.drawString(this.view.getListenID(), secondColumnPosition, yPosition);
            g2d.drawString(Resource.getInstance().getBemerkung() + ":", xPosition, yPosition += fontSize);
            g2d.drawString(this.view.getBemerkung(), secondColumnPosition, yPosition);
            g2d.drawString(Resource.getInstance().getErstelltAm() + ":", xPosition, yPosition += fontSize);
            g2d.drawString(this.view.getErstelltAm(), secondColumnPosition, yPosition);
            g2d.drawString(Resource.getInstance().getLetztmalsGeaendertAm() + ":", xPosition, yPosition += fontSize);
            g2d.drawString(this.view.getLetztmalsGeaendertAm(), secondColumnPosition, yPosition);
            g2d.drawString(Resource.getInstance().getAuftragsnummer() + ":", xPosition, yPosition += fontSize);
            g2d.drawString(this.view.getAuftragsnummer(), secondColumnPosition, yPosition);
            g2d.drawString(Resource.getInstance().getKundennummer() + ":", xPosition, yPosition += fontSize);
            g2d.drawString(this.view.getKundennummer(), secondColumnPosition, yPosition);
            g2d.drawString(Resource.getInstance().getKundenname() + ":", xPosition, yPosition += fontSize);
            g2d.drawString(this.view.getKundenname(), secondColumnPosition, yPosition);
            yPosition += 2 * fontSize;
        }
        if (this.nInd < tabmodel.getRowCount()) {
            boolean left = false;
            boolean right = true;
            String[] tableHeaderStrings = new String[]{Resource.getInstance().getPos(), Resource.getInstance().getTeilenummer(), Resource.getInstance().getMe(), Resource.getInstance().getTeilebenennung(), Resource.getInstance().getZusatz(), Resource.getInstance().getBemerkung()};
            String[] tableHeaderStrings2 = new String[]{Resource.getInstance().getPos(), Resource.getInstance().getTeilenummer(), Resource.getInstance().getMenge(), Resource.getInstance().getTeilebenennung(), Resource.getInstance().getZusatz(), Resource.getInstance().getBemerkung()};
            int[] columnBegin = new int[]{0, 30, 90, 140, 320, 402};
            int[] columnEnd = new int[]{19, 79, 129, 319, 399, maxWidth - 5};
            int[] columnFormat = new int[]{1, 0, 1, 0, 0, 0};
            yPosition += fontSize;
            for (int i = 0; i < tableHeaderStrings.length; ++i) {
                if (columnFormat[i] == 0) {
                    g2d.drawString(tableHeaderStrings2[i], xPosition + columnBegin[i], yPosition);
                    continue;
                }
                String value = tableHeaderStrings2[i];
                g2d.drawString(value, xPosition + this.getPosition(value, columnEnd[i], g2d, textfont), yPosition);
            }
            yPosition += fontSize;
            g2d.setFont(tablefont);
            fontSize = tablefont.getSize() + 2;
            while (this.nInd < tabmodel.getRowCount()) {
                if ((yPosition += fontSize) + fontSize > maxHeight) {
                    return 0;
                }
                int yOffset = -fontSize;
                for (int i = 0; i < tabmodel.getColumnCount(); ++i) {
                    for (int j = 0; j < tableHeaderStrings.length; ++j) {
                        CharSequence value;
                        if (!tabmodel.getConfiguration().getColumnName(i).equals(tableHeaderStrings[j])) continue;
                        if (tableHeaderStrings[j].equals(Resource.getInstance().getTeilenummer())) {
                            value = new StringBuffer(tabmodel.getValueAt(this.nInd, i).toString());
                            g2d.drawString(((StringBuffer)value).toString(), xPosition + columnBegin[j], yPosition);
                            continue;
                        }
                        if (tableHeaderStrings[j].equals(Resource.getInstance().getTeilebenennung())) {
                            TextLayout layout;
                            value = tabmodel.getValueAt(this.nInd, i).toString();
                            if (((String)value).equals("") || value == null) {
                                value = " ";
                            }
                            AttributedString cellText = new AttributedString((String)value);
                            cellText.addAttribute(TextAttribute.FONT, tablefont);
                            cellText.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
                            LineBreakMeasurer lineBreaker = new LineBreakMeasurer(cellText.getIterator(), g2d.getFontRenderContext());
                            while ((layout = lineBreaker.nextLayout(columnEnd[j] - columnBegin[j])) != null) {
                                layout.draw(g2d, xPosition + columnBegin[j], yPosition + (yOffset += fontSize));
                            }
                            continue;
                        }
                        if (columnFormat[j] == 0) {
                            g2d.drawString(tabmodel.getValueAt(this.nInd, i).toString(), xPosition + columnBegin[j], yPosition);
                            continue;
                        }
                        value = tabmodel.getValueAt(this.nInd, i).toString();
                        g2d.drawString(((String)value).replace(',', '.'), xPosition + this.getPosition((String)value, columnEnd[j], g2d, tablefont), yPosition);
                    }
                }
                yPosition += yOffset;
                ++this.nInd;
            }
        }
        return 0;
    }

    private int getPosition(String value, int endPosition, Graphics2D g2d, Font textfont) {
        if (value == null || value.equals("")) {
            value = " ";
        }
        AttributedString cellText = new AttributedString(value);
        cellText.addAttribute(TextAttribute.FONT, textfont);
        cellText.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
        LineBreakMeasurer lineBreaker = new LineBreakMeasurer(cellText.getIterator(), g2d.getFontRenderContext());
        TextLayout layout = lineBreaker.nextLayout(1000.0f);
        float lText = layout.getAdvance();
        int pX = endPosition - (int)lText;
        return pX;
    }
}

