/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.teileliste;

import java.util.Comparator;
import java.util.Date;
import webetk.app.teileliste.Teileliste;

public class UebersichtComparator
implements Comparator<Teileliste> {
    public static final int DEFAULT = 0;
    public static final int AUFTRAGSNUMMER = 1;
    public static final int KUNDENNUMMER = 2;
    public static final int ERSTELLTAM = 3;
    public static final int TEILELISTE = 4;
    public static final int BEMERKUNG = 5;
    public static final int EIGENTUEMER = 6;
    public static final int FILIALE = 7;
    private int feld;
    private boolean bAsc;

    UebersichtComparator(int feld, boolean bAsc) {
        this.feld = feld;
        this.bAsc = bAsc;
    }

    @Override
    public int compare(Teileliste t1, Teileliste t2) {
        switch (this.feld) {
            case 1: {
                return this.compareStrings(t1.getAuftragsNr(), t2.getAuftragsNr());
            }
            case 2: {
                return this.compareStrings(t1.getKundenNr(), t2.getKundenNr());
            }
            case 3: {
                return this.compareDates(t1.getDatErstellung(), t2.getDatErstellung());
            }
            case 4: {
                return this.compareStrings(t1.getID(), t2.getID());
            }
            case 5: {
                return this.compareStrings(t1.getBemerkung(), t2.getBemerkung());
            }
            case 6: {
                return this.compareStrings(t1.getNutzerName(), t2.getNutzerName());
            }
            case 7: {
                return this.compareStrings(t1.getFiliale(), t2.getFiliale());
            }
        }
        return 0;
    }

    private int compareStrings(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            if (this.bAsc) {
                return -1;
            }
            return 1;
        }
        if (s2 == null) {
            if (this.bAsc) {
                return 1;
            }
            return -1;
        }
        if (this.bAsc) {
            return s1.compareTo(s2);
        }
        return s2.compareTo(s1);
    }

    private int compareDates(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return 0;
        }
        if (d1 == null) {
            if (this.bAsc) {
                return -1;
            }
            return 1;
        }
        if (d2 == null) {
            if (this.bAsc) {
                return 1;
            }
            return -1;
        }
        if (this.bAsc) {
            return d1.compareTo(d2);
        }
        return d2.compareTo(d1);
    }
}

