/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.verbautesala;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.AttributedString;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.resources.Resource;

public class AusstattungDruckansicht
implements Printable {
    private PrinterJob printJob;
    private String msFzgIdString = null;
    private GenericTableModel mtmFahrzeugdaten = null;
    private GenericTableModel mtmSerienausstattung = null;
    private GenericTableModel mtmInformation = null;
    private GenericTableModel mtmSonderausstattung = null;
    private GenericTableModel mtmIndividualfahrzeugdaten = null;
    private Vector<PageInfo> maPageInfo = new Vector();
    private PageFormat pageFormat = null;
    private int xPosition = 0;
    private int yPosition = 0;
    private int fontSize = 0;
    private int maxHeight = 0;
    private static final int left = 0;

    public AusstattungDruckansicht(String sFzgIdString, GenericTableModel tmFahrzeugdaten, GenericTableModel tmSonderausstattung, GenericTableModel tmSerienausstattung, GenericTableModel tmInformation, GenericTableModel tmIndividualfahrzeugdaten) {
        this.msFzgIdString = sFzgIdString;
        this.mtmFahrzeugdaten = tmFahrzeugdaten;
        this.mtmSonderausstattung = tmSonderausstattung;
        this.mtmSerienausstattung = tmSerienausstattung;
        this.mtmInformation = tmInformation;
        this.mtmIndividualfahrzeugdaten = tmIndividualfahrzeugdaten;
        this.printJob = PrinterJob.getPrinterJob();
        this.pageFormat = this.printJob.defaultPage();
        this.pageFormat.setOrientation(1);
        this.printJob.setJobName("Ausstattungsinfo");
        this.printJob.setPrintable(this, this.pageFormat);
        PageInfo oSeite = new PageInfo(0, true, true, 0, true, 0, true, 0, true, 0, true, 0);
        this.maPageInfo.ensureCapacity(1);
        this.maPageInfo.insertElementAt(oSeite, 0);
        this.maxHeight = (int)this.pageFormat.getImageableHeight() - 2;
    }

    public void printAusstattungsinfo() {
        try {
            this.printJob.print();
        }
        catch (PrinterException pe) {
            System.out.println("Error printing: " + pe);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        PageInfo oSeitenInfoCurrentPage = this.maPageInfo.get(pageIndex);
        if (!(oSeitenInfoCurrentPage.druckenHeader() || oSeitenInfoCurrentPage.druckenFahrzeugdaten() || oSeitenInfoCurrentPage.druckenSonderausstattung() || oSeitenInfoCurrentPage.druckenSonderausstattung() || oSeitenInfoCurrentPage.druckenIndividualfahrzeugdaten())) {
            return 1;
        }
        this.yPosition = 0;
        this.xPosition = 0;
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        PageInfo oSeiteninfoNextPage = new PageInfo(pageIndex + 1, true, true, 0, true, 0, true, 0, true, 0, true, 0);
        this.maPageInfo.ensureCapacity(pageIndex + 1);
        this.maPageInfo.insertElementAt(oSeiteninfoNextPage, pageIndex + 1);
        this.printHeader(g2d, oSeitenInfoCurrentPage, oSeiteninfoNextPage);
        int nPrintable = this.printFahrzeugdaten(g2d, oSeitenInfoCurrentPage, oSeiteninfoNextPage);
        if (nPrintable == 0) {
            return nPrintable;
        }
        nPrintable = this.printSonderausstattungen(g2d, oSeitenInfoCurrentPage, oSeiteninfoNextPage);
        if (nPrintable == 0) {
            return nPrintable;
        }
        nPrintable = this.printSerienausstattungen(g2d, oSeitenInfoCurrentPage, oSeiteninfoNextPage);
        if (nPrintable == 0) {
            return nPrintable;
        }
        nPrintable = this.printInformationen(g2d, oSeitenInfoCurrentPage, oSeiteninfoNextPage);
        if (nPrintable == 0) {
            return nPrintable;
        }
        nPrintable = this.printIndividualfahrzeugdaten(g2d, oSeitenInfoCurrentPage, oSeiteninfoNextPage);
        if (nPrintable == 0) {
            return nPrintable;
        }
        return 0;
    }

    private int getPosition(String value, int endPosition, Graphics2D g2d, Font textfont) {
        if (value == null || value.equals("")) {
            value = " ";
        }
        AttributedString cellText = new AttributedString(value);
        cellText.addAttribute(TextAttribute.FONT, textfont);
        cellText.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
        LineBreakMeasurer lineBreaker = new LineBreakMeasurer(cellText.getIterator(), g2d.getFontRenderContext());
        TextLayout layout = lineBreaker.nextLayout(1000.0f);
        float lText = layout.getAdvance();
        int pX = endPosition - (int)lText;
        return pX;
    }

    private Collection<String> getTeilstrings(String sValue) {
        Vector<String> aResult = new Vector<String>();
        if (sValue == null) {
            return aResult;
        }
        sValue = sValue.trim();
        int nPos = sValue.indexOf(10);
        while (nPos != -1) {
            String sLeft = sValue.substring(0, nPos);
            aResult.add(sLeft);
            sValue = sValue.substring(nPos + 1);
            nPos = sValue.indexOf(10);
        }
        if (!sValue.equals("")) {
            aResult.add(sValue);
        }
        return aResult;
    }

    private void printHeader(Graphics2D g2d, PageInfo oSeitenInfoCurrentPage, PageInfo oSeitenInfoNextPage) {
        if (!oSeitenInfoCurrentPage.druckenHeader()) {
            oSeitenInfoNextPage.druckenHeader(false);
            return;
        }
        Font headlinefont = UIHelper.getBoldFont().deriveFont(18.0f);
        Font headline2font = UIHelper.getBoldFont().deriveFont(14.0f);
        String sUeberschrift = Resource.getInstance().getAusstattung();
        this.fontSize = headlinefont.getSize();
        g2d.setFont(headlinefont);
        this.yPosition += this.fontSize;
        g2d.drawString(sUeberschrift, this.xPosition, this.yPosition);
        sUeberschrift = this.msFzgIdString;
        this.fontSize = headline2font.getSize();
        g2d.setFont(headline2font);
        this.yPosition += this.fontSize;
        g2d.drawString(sUeberschrift, this.xPosition, this.yPosition);
        oSeitenInfoNextPage.druckenHeader(false);
    }

    private int printFahrzeugdaten(Graphics2D g2d, PageInfo oSeitenInfoCurrentPage, PageInfo oSeitenInfoNextPage) {
        if (!oSeitenInfoCurrentPage.druckenFahrzeugdaten()) {
            oSeitenInfoNextPage.druckenFahrzeugdaten(false);
            oSeitenInfoNextPage.setAbZeileFahrzeugdatenAbZeile(-1);
            return -1;
        }
        if (this.mtmFahrzeugdaten.getRowCount() == 0) {
            oSeitenInfoNextPage.druckenFahrzeugdaten(false);
            oSeitenInfoNextPage.setAbZeileFahrzeugdatenAbZeile(-1);
            return -1;
        }
        Font headlinefont = UIHelper.getBoldFont().deriveFont(18.0f);
        Font headline2font = UIHelper.getBoldFont().deriveFont(12.0f);
        Font tableheadlinefont = headlinefont.deriveFont(8.0f);
        Font textfont = UIHelper.getNormalFont().deriveFont(8.0f);
        int[] columnBegin = new int[]{0, 90};
        int[] columnEnd = new int[]{80, 400};
        int[] columnFormat = new int[]{0, 0};
        this.yPosition += 20;
        this.fontSize = headline2font.getSize();
        g2d.setFont(headline2font);
        String sText = Resource.getInstance().getFahrzeugangaben();
        g2d.drawString(sText, this.xPosition + columnBegin[0], this.yPosition);
        this.yPosition += this.fontSize + 3;
        this.fontSize = tableheadlinefont.getSize();
        g2d.setFont(tableheadlinefont);
        String[] printHeaderStrings = new String[]{Resource.getInstance().getArt(), Resource.getInstance().getWert()};
        for (int i = 0; i < printHeaderStrings.length; ++i) {
            if (columnFormat[i] == 0) {
                g2d.drawString(printHeaderStrings[i], this.xPosition + columnBegin[i], this.yPosition);
                continue;
            }
            g2d.drawString(printHeaderStrings[i], this.xPosition + this.getPosition(printHeaderStrings[i], columnEnd[i], g2d, textfont), this.yPosition);
        }
        g2d.setFont(textfont);
        this.fontSize = textfont.getSize();
        for (int nFromRow = oSeitenInfoCurrentPage.getAbZeileFahrzeugdatenAbZeile(); nFromRow < this.mtmFahrzeugdaten.getRowCount(); ++nFromRow) {
            this.yPosition += this.fontSize + 3;
            int nOffset = 0;
            if (this.yPosition + this.fontSize > this.maxHeight) {
                oSeitenInfoNextPage.druckenFahrzeugdaten(true);
                oSeitenInfoNextPage.setAbZeileFahrzeugdatenAbZeile(nFromRow);
                return 0;
            }
            AbstractRow aktuelleZeile = (AbstractRow)this.mtmFahrzeugdaten.getRow(nFromRow);
            for (int j = 0; j < 2; ++j) {
                String sValue = (String)aktuelleZeile.get(j);
                if (columnFormat[j] == 0) {
                    g2d.drawString(sValue, this.xPosition + columnBegin[j], this.yPosition);
                    continue;
                }
                g2d.drawString(sValue, this.xPosition + this.getPosition(sValue, columnEnd[j], g2d, textfont), this.yPosition);
            }
            this.yPosition += nOffset;
        }
        oSeitenInfoNextPage.druckenFahrzeugdaten(false);
        oSeitenInfoNextPage.setAbZeileFahrzeugdatenAbZeile(-1);
        return -1;
    }

    private int printSonderausstattungen(Graphics2D g2d, PageInfo oSeitenInfoCurrentPage, PageInfo oSeitenInfoNextPage) {
        if (!oSeitenInfoCurrentPage.druckenSonderausstattung()) {
            oSeitenInfoNextPage.druckenSonderausstattung(false);
            oSeitenInfoNextPage.setAbZeileSonderausstattungAbZeile(-1);
            return -1;
        }
        if (this.mtmSonderausstattung.getRowCount() == 0) {
            oSeitenInfoNextPage.druckenSonderausstattung(false);
            oSeitenInfoNextPage.setAbZeileSonderausstattungAbZeile(-1);
            return -1;
        }
        Font headlinefont = UIHelper.getBoldFont().deriveFont(18.0f);
        Font headline2font = UIHelper.getBoldFont().deriveFont(12.0f);
        Font tableheadlinefont = headlinefont.deriveFont(8.0f);
        Font textfont = UIHelper.getNormalFont().deriveFont(8.0f);
        int[] columnBegin = new int[]{0, 50, 250};
        int[] columnEnd = new int[]{45, 245, 445};
        int[] columnFormat = new int[]{0, 0, 0};
        this.yPosition += 20;
        this.fontSize = headline2font.getSize();
        g2d.setFont(headline2font);
        String sText = Resource.getInstance().getSonderausstattung();
        g2d.drawString(sText, this.xPosition + columnBegin[0], this.yPosition);
        this.yPosition += this.fontSize + 3;
        this.fontSize = tableheadlinefont.getSize();
        g2d.setFont(tableheadlinefont);
        String sCode = Resource.getInstance().getCode();
        String sBenennungSchnittstelle = Resource.getInstance().getBenennungSchnittstelle();
        String sBenennungETK = Resource.getInstance().getBenennungEtk();
        String[] printHeaderStrings = new String[]{sCode, sBenennungSchnittstelle, sBenennungETK};
        for (int i = 0; i < printHeaderStrings.length; ++i) {
            if (columnFormat[i] == 0) {
                g2d.drawString(printHeaderStrings[i], this.xPosition + columnBegin[i], this.yPosition);
                continue;
            }
            g2d.drawString(printHeaderStrings[i], this.xPosition + this.getPosition(printHeaderStrings[i], columnEnd[i], g2d, textfont), this.yPosition);
        }
        g2d.setFont(textfont);
        this.fontSize = textfont.getSize();
        for (int nRow = oSeitenInfoCurrentPage.getAbZeileSonderausstattungAbZeile(); nRow < this.mtmSonderausstattung.getRowCount(); ++nRow) {
            this.yPosition += this.fontSize + 3;
            int nOffset = 0;
            if (this.yPosition + this.fontSize > this.maxHeight) {
                oSeitenInfoNextPage.druckenSonderausstattung(true);
                oSeitenInfoNextPage.setAbZeileSonderausstattungAbZeile(nRow);
                return 0;
            }
            AbstractRow aktuelleZeile = (AbstractRow)this.mtmSonderausstattung.getRow(nRow);
            for (int j = 0; j < 3; ++j) {
                String sValue = (String)aktuelleZeile.get(j);
                if (columnFormat[j] == 0) {
                    g2d.drawString(sValue, this.xPosition + columnBegin[j], this.yPosition);
                    continue;
                }
                g2d.drawString(sValue, this.xPosition + this.getPosition(sValue, columnEnd[j], g2d, textfont), this.yPosition);
            }
            this.yPosition += nOffset;
        }
        oSeitenInfoNextPage.druckenSonderausstattung(false);
        oSeitenInfoNextPage.setAbZeileSonderausstattungAbZeile(-1);
        return -1;
    }

    private int printSerienausstattungen(Graphics2D g2d, PageInfo oSeitenInfoCurrentPage, PageInfo oSeitenInfoNextPage) {
        if (!oSeitenInfoCurrentPage.druckenSerienausstattung()) {
            oSeitenInfoNextPage.druckenSerienausstattung(false);
            oSeitenInfoNextPage.setAbZeileSerienausstattungAbZeile(-1);
            return -1;
        }
        if (this.mtmSerienausstattung.getRowCount() == 0) {
            oSeitenInfoNextPage.druckenSerienausstattung(false);
            oSeitenInfoNextPage.setAbZeileSerienausstattungAbZeile(-1);
            return -1;
        }
        Font headlinefont = UIHelper.getBoldFont().deriveFont(18.0f);
        Font headline2font = UIHelper.getBoldFont().deriveFont(12.0f);
        Font tableheadlinefont = headlinefont.deriveFont(8.0f);
        Font textfont = UIHelper.getNormalFont().deriveFont(8.0f);
        int[] columnBegin = new int[]{0, 50, 250};
        int[] columnEnd = new int[]{45, 245, 445};
        int[] columnFormat = new int[]{0, 0, 0};
        this.yPosition += 20;
        this.fontSize = headline2font.getSize();
        g2d.setFont(headline2font);
        String sText = Resource.getInstance().getSerienausstattung();
        g2d.drawString(sText, this.xPosition + columnBegin[0], this.yPosition);
        this.yPosition += this.fontSize + 3;
        this.fontSize = tableheadlinefont.getSize();
        g2d.setFont(tableheadlinefont);
        String sCode = Resource.getInstance().getCode();
        String sBenennungSchnittstelle = Resource.getInstance().getBenennungSchnittstelle();
        String sBenennungETK = Resource.getInstance().getBenennungEtk();
        String[] printHeaderStrings = new String[]{sCode, sBenennungSchnittstelle, sBenennungETK};
        for (int i = 0; i < printHeaderStrings.length; ++i) {
            if (columnFormat[i] == 0) {
                g2d.drawString(printHeaderStrings[i], this.xPosition + columnBegin[i], this.yPosition);
                continue;
            }
            g2d.drawString(printHeaderStrings[i], this.xPosition + this.getPosition(printHeaderStrings[i], columnEnd[i], g2d, textfont), this.yPosition);
        }
        g2d.setFont(textfont);
        this.fontSize = textfont.getSize();
        for (int nRow = oSeitenInfoCurrentPage.getAbZeileSerienausstattungAbZeile(); nRow < this.mtmSerienausstattung.getRowCount(); ++nRow) {
            this.yPosition += this.fontSize + 3;
            int nOffset = 0;
            if (this.yPosition + this.fontSize > this.maxHeight) {
                oSeitenInfoNextPage.druckenSerienausstattung(true);
                oSeitenInfoNextPage.setAbZeileSerienausstattungAbZeile(nRow);
                return 0;
            }
            AbstractRow aktuelleZeile = (AbstractRow)this.mtmSerienausstattung.getRow(nRow);
            for (int j = 0; j < 3; ++j) {
                String sValue = (String)aktuelleZeile.get(j);
                if (columnFormat[j] == 0) {
                    g2d.drawString(sValue, this.xPosition + columnBegin[j], this.yPosition);
                    continue;
                }
                g2d.drawString(sValue, this.xPosition + this.getPosition(sValue, columnEnd[j], g2d, textfont), this.yPosition);
            }
            this.yPosition += nOffset;
        }
        oSeitenInfoNextPage.druckenSerienausstattung(false);
        oSeitenInfoNextPage.setAbZeileSerienausstattungAbZeile(-1);
        return -1;
    }

    private int printInformationen(Graphics2D g2d, PageInfo oSeitenInfoCurrentPage, PageInfo oSeitenInfoNextPage) {
        if (!oSeitenInfoCurrentPage.druckenInformation()) {
            oSeitenInfoNextPage.druckenInformation(false);
            oSeitenInfoNextPage.setAbZeileInformationAbZeile(-1);
            return -1;
        }
        if (this.mtmInformation.getRowCount() == 0) {
            oSeitenInfoNextPage.druckenInformation(false);
            oSeitenInfoNextPage.setAbZeileInformationAbZeile(-1);
            return -1;
        }
        Font headlinefont = UIHelper.getBoldFont().deriveFont(18.0f);
        Font headline2font = UIHelper.getBoldFont().deriveFont(12.0f);
        Font tableheadlinefont = headlinefont.deriveFont(8.0f);
        Font textfont = UIHelper.getNormalFont().deriveFont(8.0f);
        int[] columnBegin = new int[]{0, 50, 250};
        int[] columnEnd = new int[]{45, 245, 445};
        int[] columnFormat = new int[]{0, 0, 0};
        this.yPosition += 20;
        this.fontSize = headline2font.getSize();
        g2d.setFont(headline2font);
        String sText = "Information";
        g2d.drawString(sText, this.xPosition + columnBegin[0], this.yPosition);
        this.yPosition += this.fontSize + 3;
        this.fontSize = tableheadlinefont.getSize();
        g2d.setFont(tableheadlinefont);
        String sCode = Resource.getInstance().getCode();
        String sBenennungSchnittstelle = Resource.getInstance().getBenennungSchnittstelle();
        String sBenennungETK = Resource.getInstance().getBenennungEtk();
        String[] printHeaderStrings = new String[]{sCode, sBenennungSchnittstelle, sBenennungETK};
        for (int i = 0; i < printHeaderStrings.length; ++i) {
            if (columnFormat[i] == 0) {
                g2d.drawString(printHeaderStrings[i], this.xPosition + columnBegin[i], this.yPosition);
                continue;
            }
            g2d.drawString(printHeaderStrings[i], this.xPosition + this.getPosition(printHeaderStrings[i], columnEnd[i], g2d, textfont), this.yPosition);
        }
        g2d.setFont(textfont);
        this.fontSize = textfont.getSize();
        for (int nRow = oSeitenInfoCurrentPage.getAbZeileInformationAbZeile(); nRow < this.mtmInformation.getRowCount(); ++nRow) {
            this.yPosition += this.fontSize + 3;
            int nOffset = 0;
            if (this.yPosition + this.fontSize > this.maxHeight) {
                oSeitenInfoNextPage.druckenInformation(true);
                oSeitenInfoNextPage.setAbZeileInformationAbZeile(nRow);
                return 0;
            }
            AbstractRow aktuelleZeile = (AbstractRow)this.mtmInformation.getRow(nRow);
            for (int j = 0; j < 3; ++j) {
                String sValue = (String)aktuelleZeile.get(j);
                if (columnFormat[j] == 0) {
                    g2d.drawString(sValue, this.xPosition + columnBegin[j], this.yPosition);
                    continue;
                }
                g2d.drawString(sValue, this.xPosition + this.getPosition(sValue, columnEnd[j], g2d, textfont), this.yPosition);
            }
            this.yPosition += nOffset;
        }
        oSeitenInfoNextPage.druckenInformation(false);
        oSeitenInfoNextPage.setAbZeileInformationAbZeile(-1);
        return -1;
    }

    private int printIndividualfahrzeugdaten(Graphics2D g2d, PageInfo oSeitenInfoCurrentPage, PageInfo oSeitenInfoNextPage) {
        if (!oSeitenInfoCurrentPage.druckenIndividualfahrzeugdaten()) {
            oSeitenInfoNextPage.druckenIndividualfahrzeugdaten(false);
            oSeitenInfoNextPage.setAbZeileIndividualfahrzeugdatenAbZeile(-1);
            return -1;
        }
        if (this.mtmIndividualfahrzeugdaten.getRowCount() == 0) {
            oSeitenInfoNextPage.druckenIndividualfahrzeugdaten(false);
            oSeitenInfoNextPage.setAbZeileIndividualfahrzeugdatenAbZeile(-1);
            return -1;
        }
        Font headline2font = UIHelper.getBoldFont().deriveFont(12.0f);
        Font textfont = UIHelper.getNormalFont().deriveFont(8.0f);
        int[] columnBegin = new int[]{0};
        int[] columnEnd = new int[]{400};
        int[] columnFormat = new int[]{0};
        this.yPosition += 20;
        this.fontSize = headline2font.getSize();
        g2d.setFont(headline2font);
        String sText = Resource.getInstance().getIndividualfahrzeugdaten();
        g2d.drawString(sText, this.xPosition + columnBegin[0], this.yPosition);
        this.yPosition += this.fontSize + 3;
        g2d.setFont(textfont);
        this.fontSize = textfont.getSize();
        for (int nRow = oSeitenInfoCurrentPage.getAbZeileIndividualfahrzeugdatenAbZeile(); nRow < this.mtmIndividualfahrzeugdaten.getRowCount(); ++nRow) {
            AbstractRow aktuelleZeile = (AbstractRow)this.mtmIndividualfahrzeugdaten.getRow(nRow);
            String sValue = (String)aktuelleZeile.get(0);
            Collection<String> aTeilStrings = this.getTeilstrings(sValue);
            if (this.yPosition + this.fontSize * aTeilStrings.size() > this.maxHeight) {
                oSeitenInfoNextPage.druckenIndividualfahrzeugdaten(true);
                oSeitenInfoNextPage.setAbZeileIndividualfahrzeugdatenAbZeile(nRow);
                return 0;
            }
            Iterator<String> iter = aTeilStrings.iterator();
            while (iter.hasNext()) {
                this.yPosition += this.fontSize + 3;
                String sTeilstring = iter.next();
                if (columnFormat[0] == 0) {
                    g2d.drawString(sTeilstring, this.xPosition + columnBegin[0], this.yPosition);
                    continue;
                }
                g2d.drawString(sTeilstring, this.xPosition + this.getPosition(sValue, columnEnd[0], g2d, textfont), this.yPosition);
            }
        }
        oSeitenInfoNextPage.druckenIndividualfahrzeugdaten(false);
        oSeitenInfoNextPage.setAbZeileIndividualfahrzeugdatenAbZeile(-1);
        return -1;
    }

    private static class PageInfo {
        private boolean mbDruckenHeader = true;
        private boolean mbDruckenFahrzeugdaten = true;
        private int mnFahrzeugdatenFromRow = 0;
        private boolean mbDruckenSonderausstattung = true;
        private int mnSonderausstattungFromRow = 0;
        private boolean mbDruckenSerienausstattung = true;
        private int mnSerienausstattungFromRow = 0;
        private boolean mbDruckenInformation = true;
        private int mnInformationFromRow = 0;
        private boolean mbDruckenIndividualfahrzeugdaten = true;
        private int mnIndividualfahrzeugdatenFromRow = 0;

        public PageInfo(int nPageIndex, boolean bDruckenHeader, boolean bDruckenFahrzeugdaten, int nFahrzeugdatenFromRow, boolean bDruckenSonderausstattung, int nSonderausstattungFromRow, boolean bDruckenSerienausstattung, int nSerienausstattungFromRow, boolean bDruckenInformation, int nInformationFromRow, boolean bDruckenIndividualfahrzeugdaten, int nIndividualfahrzeugdatenFromRow) {
            this.mbDruckenHeader = bDruckenHeader;
            this.mbDruckenFahrzeugdaten = bDruckenFahrzeugdaten;
            this.mnFahrzeugdatenFromRow = nFahrzeugdatenFromRow;
            this.mbDruckenSonderausstattung = bDruckenSonderausstattung;
            this.mnSonderausstattungFromRow = nSonderausstattungFromRow;
            this.mbDruckenSerienausstattung = bDruckenSerienausstattung;
            this.mnSerienausstattungFromRow = nSerienausstattungFromRow;
            this.mbDruckenInformation = bDruckenInformation;
            this.mnInformationFromRow = nInformationFromRow;
            this.mbDruckenIndividualfahrzeugdaten = bDruckenIndividualfahrzeugdaten;
            this.mnIndividualfahrzeugdatenFromRow = nIndividualfahrzeugdatenFromRow;
        }

        public boolean druckenHeader() {
            return this.mbDruckenHeader;
        }

        public void druckenHeader(boolean bDruckenHeader) {
            this.mbDruckenHeader = bDruckenHeader;
        }

        public boolean druckenFahrzeugdaten() {
            return this.mbDruckenFahrzeugdaten;
        }

        public void druckenFahrzeugdaten(boolean bDrucken) {
            this.mbDruckenFahrzeugdaten = bDrucken;
        }

        public int getAbZeileFahrzeugdatenAbZeile() {
            return this.mnFahrzeugdatenFromRow;
        }

        public void setAbZeileFahrzeugdatenAbZeile(int nFromRow) {
            this.mnFahrzeugdatenFromRow = nFromRow;
        }

        public boolean druckenSonderausstattung() {
            return this.mbDruckenSonderausstattung;
        }

        public void druckenSonderausstattung(boolean bDrucken) {
            this.mbDruckenSonderausstattung = bDrucken;
        }

        public int getAbZeileSonderausstattungAbZeile() {
            return this.mnSonderausstattungFromRow;
        }

        public void setAbZeileSonderausstattungAbZeile(int nFromRow) {
            this.mnSonderausstattungFromRow = nFromRow;
        }

        public boolean druckenSerienausstattung() {
            return this.mbDruckenSerienausstattung;
        }

        public void druckenSerienausstattung(boolean bDrucken) {
            this.mbDruckenSerienausstattung = bDrucken;
        }

        public int getAbZeileSerienausstattungAbZeile() {
            return this.mnSerienausstattungFromRow;
        }

        public void setAbZeileSerienausstattungAbZeile(int nFromRow) {
            this.mnSerienausstattungFromRow = nFromRow;
        }

        public boolean druckenInformation() {
            return this.mbDruckenInformation;
        }

        public void druckenInformation(boolean bDrucken) {
            this.mbDruckenInformation = bDrucken;
        }

        public int getAbZeileInformationAbZeile() {
            return this.mnInformationFromRow;
        }

        public void setAbZeileInformationAbZeile(int nFromRow) {
            this.mnInformationFromRow = nFromRow;
        }

        public boolean druckenIndividualfahrzeugdaten() {
            return this.mbDruckenIndividualfahrzeugdaten;
        }

        public void druckenIndividualfahrzeugdaten(boolean bDrucken) {
            this.mbDruckenIndividualfahrzeugdaten = bDrucken;
        }

        public int getAbZeileIndividualfahrzeugdatenAbZeile() {
            return this.mnIndividualfahrzeugdatenFromRow;
        }

        public void setAbZeileIndividualfahrzeugdatenAbZeile(int nFromRow) {
            this.mnIndividualfahrzeugdatenFromRow = nFromRow;
        }
    }
}

