/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.extras.verbautesala;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;
import webetk.app.Bedingung;
import webetk.app.ausstattung.Ausstattung;
import webetk.communication.JavaFzgSucheInfo;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.extras.verbautesala.AusstattungDruckansicht;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.RealMultilineCellRenderer;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.resources.Resource;

public class DlgAusstattung {
    private static Logger log = Logger.getLogger(DlgAusstattung.class);
    private static final int FAHRZEUGANGABEN = 1;
    private static final int SONDERAUSSTATTUNG = 2;
    private static final int SERIENAUSSTATTUNG = 3;
    private static final int INFORMATION = 4;
    private static final int INDIVIDUALFAHRZEUGDATEN = 5;
    private static DlgAusstattung instance = null;
    private JDialog dlg = new JDialog((Frame)MainView.getInstance(), false);
    private Container contGesamt = null;
    private JPanel panHeader = null;
    private JPanel panInhalt = null;
    private HIGLayout layoutInhalt = null;
    private HIGLayout mlayoutFahrzeugangaben = null;
    private JPanel mpanFahrzeugangaben = null;
    private JLabel mlabIconPlusFahrzeugangaben = null;
    private JLabel mlabIconMinusFahrzeugangaben = null;
    private JComponent mpanTabelleFahrzeugangaben = null;
    private GenericTableModel mtmFahrzeugangaben = null;
    private double mdHeightTabelleFahrzeugangaben = 0.0;
    private double mdHeightUeberschriftFahrzeugangaben = 0.0;
    private HIGLayout mlayoutSonderausstattung = null;
    private JPanel mpanSonderausstattung = null;
    private JLabel mlabIconPlusSonderausstattung = null;
    private JLabel mlabIconMinusSonderausstattung = null;
    private JComponent mpanTabelleSonderausstattung = null;
    private GenericTableModel mtmSonderausstattung = null;
    private double mdHeightTabelleSonderausstattung = 0.0;
    private double mdHeightUeberschriftSonderausstattung = 0.0;
    private HIGLayout mlayoutSerienausstattung = null;
    private JPanel mpanSerienausstattung = null;
    private JLabel mlabIconPlusSerienausstattung = null;
    private JLabel mlabIconMinusSerienausstattung = null;
    private JComponent mpanTabelleSerienausstattung = null;
    private GenericTableModel mtmSerienausstattung = null;
    private double mdHeightTabelleSerienausstattung = 0.0;
    private double mdHeightUeberschriftSerienausstattung = 0.0;
    private HIGLayout mlayoutInformation = null;
    private JPanel mpanInformation = null;
    private JLabel mlabIconPlusInformation = null;
    private JLabel mlabIconMinusInformation = null;
    private JComponent mpanTabelleInformation = null;
    private GenericTableModel mtmInformation = null;
    private double mdHeightTabelleInformation = 0.0;
    private double mdHeightUeberschriftInformation = 0.0;
    private HIGLayout mlayoutIndividualfahrzeugdaten = null;
    private JPanel mpanIndividualfahrzeugdaten = null;
    private JLabel mlabIconPlusIndividualfahrzeugdaten = null;
    private JLabel mlabIconMinusIndividualfahrzeugdaten = null;
    private JComponent mpanTabelleIndividualfahrzeugdaten = null;
    private GenericTableModel mtmIndividualfahrzeugdaten = null;
    private double mdHeightTabelleIndividualfahrzeugdaten = 0.0;
    private double mdHeightUeberschriftIndividualfahrzeugdaten = 0.0;

    private DlgAusstattung() {
        this.dlg.setTitle(Resource.getInstance().getAusstattung());
        this.dlg.setSize(900, 800);
        this.dlg.setLocation(50, 10);
        this.initComponents();
        this.zuklappen(1);
        this.aufklappen(2);
        this.aufklappen(3);
        this.aufklappen(4);
        this.aufklappen(5);
    }

    public void show() {
        this.dlg.setVisible(true);
    }

    public static DlgAusstattung getInstance() {
        if (instance == null) {
            instance = new DlgAusstattung();
        }
        return instance;
    }

    public static void resetInstance() {
        if (instance != null) {
            DlgAusstattung.instance.dlg.dispose();
            instance = null;
        }
    }

    public void initComponents() {
        JavaFzgSucheInfo oFzgSucheInfo = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo();
        if (oFzgSucheInfo == null) {
            log.error((Object)"Keine Fahrzeugidentifikation vorhanden => Dialog beenden");
            return;
        }
        String sFzgIdString = oFzgSucheInfo.getFzgIdString();
        this.panHeader = new HeaderPanel(Resource.getInstance().getAusstattung(), sFzgIdString, ImageCache.getInstance().getHeaderIcon("saverb"));
        this.layoutAll();
    }

    protected void layoutAll() {
        this.contGesamt = this.dlg.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.contGesamt.setLayout(l);
        this.contGesamt.add((Component)this.panHeader, c.rc(1, 1, "tlbr"));
        this.panInhalt = this.createInhaltPanel();
        JScrollPane scInhalt = new JScrollPane(this.panInhalt, 20, 30);
        this.contGesamt.add((Component)scInhalt, c.rc(3, 1, "tlbr"));
    }

    public static boolean hatAusstattung() {
        JavaFzgSucheInfo oFzgSucheInfo = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo();
        if (oFzgSucheInfo == null) {
            return false;
        }
        Ausstattung oAusstattung = oFzgSucheInfo.getAusstattung();
        if (oAusstattung == null) {
            return false;
        }
        return oAusstattung.hatFahrzeugdaten() || oAusstattung.hatSonderausstattung() || oAusstattung.hatSerienausstattung() || oAusstattung.hatInformation() || oAusstattung.hatIndividualFahrzeugdaten();
    }

    public JPanel createInhaltPanel() {
        JPanel panel = new JPanel();
        panel.setAutoscrolls(true);
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0, 0, 0, 0, 0};
        this.layoutInhalt = new HIGLayout(w, h);
        this.layoutInhalt.setColumnWeight(1, 1);
        HIGConstraints c = new HIGConstraints();
        panel.setLayout(this.layoutInhalt);
        JavaFzgSucheInfo oFzgSucheInfo = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo();
        Ausstattung oAusstattung = oFzgSucheInfo.getAusstattung();
        boolean bHatFahrzeugdaten = false;
        boolean bHatSonderausstattung = false;
        boolean bHatSerienausstattung = false;
        boolean bHatInformation = false;
        boolean bHatIndividualfahrzeugdaten = false;
        if (oAusstattung != null) {
            bHatFahrzeugdaten = oAusstattung.hatFahrzeugdaten();
            bHatSonderausstattung = oAusstattung.hatSonderausstattung();
            bHatSerienausstattung = oAusstattung.hatSerienausstattung();
            bHatInformation = oAusstattung.hatInformation();
            bHatIndividualfahrzeugdaten = oAusstattung.hatIndividualFahrzeugdaten();
        }
        JPanel panButtonsOben = this.createPanelButtonsOben(bHatIndividualfahrzeugdaten);
        JPanel panFahrzeugangaben = this.createPanelFahrzeugangaben();
        JPanel panSonderausstattung = this.createPanelSonderausstattung();
        JPanel panSerienausstattung = this.createPanelSerienausstattung();
        JPanel panInformation = this.createPanelInformation();
        JPanel panIndividualfahrzeugdaten = this.createPanelIndividualfahrzeugdaten();
        panel.add((Component)panButtonsOben, c.rc(1, 1));
        if (bHatFahrzeugdaten) {
            panel.add((Component)panFahrzeugangaben, c.rc(2, 1));
        }
        if (bHatSonderausstattung) {
            panel.add((Component)panSonderausstattung, c.rc(3, 1));
        }
        if (bHatSerienausstattung) {
            panel.add((Component)panSerienausstattung, c.rc(4, 1));
        }
        if (bHatInformation) {
            panel.add((Component)panInformation, c.rc(5, 1));
        }
        if (bHatIndividualfahrzeugdaten) {
            panel.add((Component)panIndividualfahrzeugdaten, c.rc(6, 1));
        }
        return panel;
    }

    private JPanel createPanelButtonsOben(boolean bHatIndividualfahrzeugdaten) {
        int[] w = new int[]{2, 0, 0, 0, 2};
        int[] h = new int[]{2, 0, 2};
        HIGLayout layout = new HIGLayout(w, h);
        layout.setColumnWeight(3, 1);
        layout.setRowWeight(2, 1);
        HIGConstraints c = new HIGConstraints();
        JPanel panButtonsOben = new JPanel();
        panButtonsOben.setLayout(layout);
        JLabel labIndividualdatenVorhanden = new JLabel(Resource.getInstance().getIndividualdatenVorhanden());
        labIndividualdatenVorhanden.setFont(UIHelper.getBoldFont());
        labIndividualdatenVorhanden.setForeground(new Color(255, 0, 0));
        JButtonEx buttonAnzeigen = new JButtonEx(Resource.getInstance().getAnzeigen(), ImageCache.getInstance().getIcon("visualisierung.gif"));
        buttonAnzeigen.setHorizontalTextPosition(4);
        JButtonEx buttonDrucken = new JButtonEx(Resource.getInstance().getDrucken(), ImageCache.getInstance().getIcon("drucken.gif"));
        buttonDrucken.setHorizontalTextPosition(4);
        if (bHatIndividualfahrzeugdaten) {
            JPanel panIndividualdatenVorhanden = new JPanel();
            panIndividualdatenVorhanden.add(labIndividualdatenVorhanden);
            panIndividualdatenVorhanden.add(buttonAnzeigen);
            panButtonsOben.add((Component)panIndividualdatenVorhanden, c.rc(2, 2));
        }
        panButtonsOben.add((Component)buttonDrucken, c.rc(2, 4, "l"));
        buttonAnzeigen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgAusstattung.this.showIndividualdatenVisible();
                DlgAusstattung.this.showIndividualdatenVisible();
            }
        });
        buttonDrucken.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgAusstattung.this.printAusstattungsinfo();
            }
        });
        return panButtonsOben;
    }

    private JPanel createPanelFahrzeugangaben() {
        int[] w = new int[]{2, 0, 2};
        int[] h = new int[]{2, 0, 3, 0, 2};
        this.mlayoutFahrzeugangaben = new HIGLayout(w, h);
        this.mlayoutFahrzeugangaben.setColumnWeight(2, 1);
        this.mlayoutFahrzeugangaben.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        this.mpanFahrzeugangaben = new JPanel();
        this.mpanFahrzeugangaben.setLayout(this.mlayoutFahrzeugangaben);
        Icon iconPlusFahrzeugangaben = UIHelper.getPlusIcon();
        this.mlabIconPlusFahrzeugangaben = new JLabel(iconPlusFahrzeugangaben);
        Icon iconMinusFahrzeugangaben = UIHelper.getMinusIcon();
        this.mlabIconMinusFahrzeugangaben = new JLabel(iconMinusFahrzeugangaben);
        JPanel panel = new JPanel();
        JLabel labFahrzeugangaben = new JLabel(Resource.getInstance().getFahrzeugangaben());
        labFahrzeugangaben.setFont(UIHelper.getBoldFont());
        panel.add(this.mlabIconPlusFahrzeugangaben);
        panel.add(this.mlabIconMinusFahrzeugangaben);
        panel.add(labFahrzeugangaben);
        this.mdHeightUeberschriftFahrzeugangaben = panel.getPreferredSize().getHeight();
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (DlgAusstattung.this.mlabIconPlusFahrzeugangaben.isVisible()) {
                    DlgAusstattung.this.aufklappen(1);
                } else {
                    DlgAusstattung.this.zuklappen(1);
                }
            }
        });
        this.mpanFahrzeugangaben.add((Component)panel, c.rc(2, 2, "l"));
        this.mpanTabelleFahrzeugangaben = this.createTabelleFahrzeugangaben();
        this.mpanFahrzeugangaben.add((Component)this.mpanTabelleFahrzeugangaben, c.rc(4, 2, "lrbt"));
        return this.mpanFahrzeugangaben;
    }

    private JPanel createPanelSonderausstattung() {
        int[] w = new int[]{2, 0, 2};
        int[] h = new int[]{2, 0, 3, 0, 2};
        this.mlayoutSonderausstattung = new HIGLayout(w, h);
        this.mlayoutSonderausstattung.setColumnWeight(2, 1);
        this.mlayoutSonderausstattung.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        this.mpanSonderausstattung = new JPanel();
        this.mpanSonderausstattung.setLayout(this.mlayoutSonderausstattung);
        Icon iconPlusSonderausstattung = UIHelper.getPlusIcon();
        this.mlabIconPlusSonderausstattung = new JLabel(iconPlusSonderausstattung);
        Icon iconMinusSonderausstattung = UIHelper.getMinusIcon();
        this.mlabIconMinusSonderausstattung = new JLabel(iconMinusSonderausstattung);
        JPanel panel = new JPanel();
        JLabel labSonderausstattung = new JLabel(Resource.getInstance().getSonderausstattung());
        labSonderausstattung.setFont(UIHelper.getBoldFont());
        panel.add(this.mlabIconPlusSonderausstattung);
        panel.add(this.mlabIconMinusSonderausstattung);
        panel.add(labSonderausstattung);
        this.mdHeightUeberschriftSonderausstattung = panel.getPreferredSize().getHeight();
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (DlgAusstattung.this.mlabIconPlusSonderausstattung.isVisible()) {
                    DlgAusstattung.this.aufklappen(2);
                } else {
                    DlgAusstattung.this.zuklappen(2);
                }
            }
        });
        this.mpanSonderausstattung.add((Component)panel, c.rc(2, 2, "l"));
        this.mpanTabelleSonderausstattung = this.createTabelleSonderausstattung();
        this.mpanSonderausstattung.add((Component)this.mpanTabelleSonderausstattung, c.rc(4, 2, "lrbt"));
        return this.mpanSonderausstattung;
    }

    private JPanel createPanelSerienausstattung() {
        int[] w = new int[]{2, 0, 2};
        int[] h = new int[]{2, 0, 3, 0, 2};
        this.mlayoutSerienausstattung = new HIGLayout(w, h);
        this.mlayoutSerienausstattung.setColumnWeight(2, 1);
        this.mlayoutSerienausstattung.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        this.mpanSerienausstattung = new JPanel();
        this.mpanSerienausstattung.setLayout(this.mlayoutSerienausstattung);
        Icon iconPlusSerienausstattung = UIHelper.getPlusIcon();
        this.mlabIconPlusSerienausstattung = new JLabel(iconPlusSerienausstattung);
        Icon iconMinusSerienausstattung = UIHelper.getMinusIcon();
        this.mlabIconMinusSerienausstattung = new JLabel(iconMinusSerienausstattung);
        JPanel panel = new JPanel();
        JLabel labSerienausstattung = new JLabel(Resource.getInstance().getSerienausstattung());
        labSerienausstattung.setFont(UIHelper.getBoldFont());
        panel.add(this.mlabIconPlusSerienausstattung);
        panel.add(this.mlabIconMinusSerienausstattung);
        panel.add(labSerienausstattung);
        this.mdHeightUeberschriftSerienausstattung = panel.getPreferredSize().getHeight();
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (DlgAusstattung.this.mlabIconPlusSerienausstattung.isVisible()) {
                    DlgAusstattung.this.aufklappen(3);
                } else {
                    DlgAusstattung.this.zuklappen(3);
                }
            }
        });
        this.mpanSerienausstattung.add((Component)panel, c.rc(2, 2, "l"));
        this.mpanTabelleSerienausstattung = this.createTabelleSerienausstattung();
        this.mpanSerienausstattung.add((Component)this.mpanTabelleSerienausstattung, c.rc(4, 2, "lrbt"));
        return this.mpanSerienausstattung;
    }

    private JPanel createPanelInformation() {
        int[] w = new int[]{2, 0, 2};
        int[] h = new int[]{2, 0, 3, 0, 2};
        this.mlayoutInformation = new HIGLayout(w, h);
        this.mlayoutInformation.setColumnWeight(2, 1);
        this.mlayoutInformation.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        this.mpanInformation = new JPanel();
        this.mpanInformation.setLayout(this.mlayoutInformation);
        Icon iconPlusInformation = UIHelper.getPlusIcon();
        this.mlabIconPlusInformation = new JLabel(iconPlusInformation);
        Icon iconMinusInformation = UIHelper.getMinusIcon();
        this.mlabIconMinusInformation = new JLabel(iconMinusInformation);
        JPanel panel = new JPanel();
        JLabel labInformation = new JLabel(Resource.getInstance().getInformation());
        labInformation.setFont(UIHelper.getBoldFont());
        panel.add(this.mlabIconPlusInformation);
        panel.add(this.mlabIconMinusInformation);
        panel.add(labInformation);
        this.mdHeightUeberschriftInformation = panel.getPreferredSize().getHeight();
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (DlgAusstattung.this.mlabIconPlusInformation.isVisible()) {
                    DlgAusstattung.this.aufklappen(4);
                } else {
                    DlgAusstattung.this.zuklappen(4);
                }
            }
        });
        this.mpanInformation.add((Component)panel, c.rc(2, 2, "l"));
        this.mpanTabelleInformation = this.createTabelleInformation();
        this.mpanInformation.add((Component)this.mpanTabelleInformation, c.rc(4, 2, "lrbt"));
        return this.mpanInformation;
    }

    private JPanel createPanelIndividualfahrzeugdaten() {
        int[] w = new int[]{2, 0, 2};
        int[] h = new int[]{2, 0, 3, 0, 2};
        this.mlayoutIndividualfahrzeugdaten = new HIGLayout(w, h);
        this.mlayoutIndividualfahrzeugdaten.setColumnWeight(2, 1);
        this.mlayoutIndividualfahrzeugdaten.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        this.mpanIndividualfahrzeugdaten = new JPanel();
        this.mpanIndividualfahrzeugdaten.setLayout(this.mlayoutIndividualfahrzeugdaten);
        Icon iconPlusIndividualfahrzeugdaten = UIHelper.getPlusIcon();
        this.mlabIconPlusIndividualfahrzeugdaten = new JLabel(iconPlusIndividualfahrzeugdaten);
        Icon iconMinusIndividualfahrzeugdaten = UIHelper.getMinusIcon();
        this.mlabIconMinusIndividualfahrzeugdaten = new JLabel(iconMinusIndividualfahrzeugdaten);
        JPanel panel = new JPanel();
        JLabel labIndividualfahrzeugdaten = new JLabel(Resource.getInstance().getIndividualfahrzeugdaten());
        labIndividualfahrzeugdaten.setFont(UIHelper.getBoldFont());
        panel.add(this.mlabIconPlusIndividualfahrzeugdaten);
        panel.add(this.mlabIconMinusIndividualfahrzeugdaten);
        panel.add(labIndividualfahrzeugdaten);
        this.mdHeightUeberschriftIndividualfahrzeugdaten = panel.getPreferredSize().getHeight();
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (DlgAusstattung.this.mlabIconPlusIndividualfahrzeugdaten.isVisible()) {
                    DlgAusstattung.this.aufklappen(5);
                } else {
                    DlgAusstattung.this.zuklappen(5);
                }
            }
        });
        this.mpanIndividualfahrzeugdaten.add((Component)panel, c.rc(2, 2, "l"));
        this.mpanTabelleIndividualfahrzeugdaten = this.createTabelleIndividualfahrzeugdaten();
        this.mpanIndividualfahrzeugdaten.add((Component)this.mpanTabelleIndividualfahrzeugdaten, c.rc(4, 2, "lrbt"));
        return this.mpanIndividualfahrzeugdaten;
    }

    private JComponent createTabelleFahrzeugangaben() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn(Resource.getInstance().getArt(), 2, true, "XXXXXXXXXXXXXXXXXXX");
        tableConfig.addColumn(Resource.getInstance().getWert(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.mtmFahrzeugangaben = new GenericTableModel(tableConfig);
        JavaFzgSucheInfo oFzgSucheInfo = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo();
        if (oFzgSucheInfo == null) {
            return null;
        }
        Ausstattung oAusstattung = oFzgSucheInfo.getAusstattung();
        if (oAusstattung == null) {
            return null;
        }
        if (oAusstattung.getFgstnrKomplett() != null) {
            this.mtmFahrzeugangaben.addRow(new AbstractRow(new Object[]{Resource.getInstance().getFahrgestellnummer(), oAusstattung.getFgstnrKomplett()}));
        }
        if (oAusstattung.getTypCode() != null) {
            this.mtmFahrzeugangaben.addRow(new AbstractRow(new Object[]{Resource.getInstance().getTypCode(), oAusstattung.getTypCode()}));
        }
        if (oAusstattung.getMarketSalesDesc() != null) {
            this.mtmFahrzeugangaben.addRow(new AbstractRow(new Object[]{Resource.getInstance().getTyp(), oAusstattung.getMarketSalesDesc()}));
        } else if (oAusstattung.getTyp() != null) {
            this.mtmFahrzeugangaben.addRow(new AbstractRow(new Object[]{Resource.getInstance().getTyp(), oAusstattung.getTyp()}));
        }
        if (oAusstattung.getEBaureihe() != null) {
            this.mtmFahrzeugangaben.addRow(new AbstractRow(new Object[]{Resource.getInstance().getEBaureihe(), oAusstattung.getEBaureihe()}));
        }
        if (oAusstattung.getBaureihe() != null) {
            this.mtmFahrzeugangaben.addRow(new AbstractRow(new Object[]{Resource.getInstance().getBaureihe(), oAusstattung.getBaureihe()}));
        }
        if (oAusstattung.getBauart() != null) {
            this.mtmFahrzeugangaben.addRow(new AbstractRow(new Object[]{Resource.getInstance().getBauart(), oAusstattung.getBauart()}));
        }
        if (oAusstattung.getLenkung() != null) {
            this.mtmFahrzeugangaben.addRow(new AbstractRow(new Object[]{Resource.getInstance().getLenkung(), oAusstattung.getLenkung()}));
        }
        if (oAusstattung.getTueren() != null) {
            this.mtmFahrzeugangaben.addRow(new AbstractRow(new Object[]{Resource.getInstance().getTueren(), oAusstattung.getTueren()}));
        }
        if (oAusstattung.getMotor() != null) {
            this.mtmFahrzeugangaben.addRow(new AbstractRow(new Object[]{Resource.getInstance().getMotor(), oAusstattung.getMotor()}));
        }
        if (oAusstattung.getHubraum() != null) {
            this.mtmFahrzeugangaben.addRow(new AbstractRow(new Object[]{Resource.getInstance().getHubraum(), oAusstattung.getHubraum()}));
        }
        if (oAusstattung.getLeistung() != null) {
            this.mtmFahrzeugangaben.addRow(new AbstractRow(new Object[]{Resource.getInstance().getLeistung(), oAusstattung.getLeistung()}));
        }
        if (oAusstattung.getAntrieb() != null) {
            this.mtmFahrzeugangaben.addRow(new AbstractRow(new Object[]{Resource.getInstance().getAntrieb(), oAusstattung.getAntrieb()}));
        }
        if (oAusstattung.getGetriebe() != null) {
            this.mtmFahrzeugangaben.addRow(new AbstractRow(new Object[]{Resource.getInstance().getGetriebe(), oAusstattung.getGetriebe()}));
        }
        if (oAusstattung.getFarbe() != null) {
            this.mtmFahrzeugangaben.addRow(new AbstractRow(new Object[]{Resource.getInstance().getFarbe(), oAusstattung.getFarbe()}));
        }
        if (oAusstattung.getPolsterung() != null) {
            this.mtmFahrzeugangaben.addRow(new AbstractRow(new Object[]{Resource.getInstance().getPolsterung(), oAusstattung.getPolsterung()}));
        }
        if (oAusstattung.getProdDatum() != null) {
            this.mtmFahrzeugangaben.addRow(new AbstractRow(new Object[]{Resource.getInstance().getProdDatum(), oAusstattung.getProdDatum()}));
        }
        GenericTable table = new GenericTable(this.mtmFahrzeugangaben);
        table.setAllowSizingSmallerThanMinimumWidth(false);
        table.calcRowHeights();
        this.mdHeightTabelleFahrzeugangaben = table.getTable().getPreferredSize().getHeight();
        return table.getScrollPane();
    }

    private JComponent createTabelleSonderausstattung() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn(Resource.getInstance().getCode(), 0, false, "XXXXXXXX");
        tableConfig.addColumn(Resource.getInstance().getBenennungSchnittstelle(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        tableConfig.addColumn(Resource.getInstance().getBenennungEtk(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.mtmSonderausstattung = new GenericTableModel(tableConfig);
        JavaFzgSucheInfo oFzgSucheInfo = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo();
        if (oFzgSucheInfo == null) {
            return null;
        }
        Ausstattung oAusstattung = oFzgSucheInfo.getAusstattung();
        if (oAusstattung == null) {
            return null;
        }
        Collection<Bedingung> cSonderausstattungen = oAusstattung.getSonderausstattung();
        if (cSonderausstattungen == null) {
            return null;
        }
        for (Bedingung oBedingung : cSonderausstattungen) {
            String sCode = oBedingung.getCode();
            String sBenennung = oBedingung.getName();
            String sBenennungSS = oBedingung.getNameSS();
            sBenennungSS = sBenennungSS == null ? "" : sBenennungSS;
            this.mtmSonderausstattung.addRow(new AbstractRow(new Object[]{sCode, sBenennungSS, sBenennung}));
        }
        GenericTable table = new GenericTable(this.mtmSonderausstattung);
        table.setAllowSizingSmallerThanMinimumWidth(false);
        table.calcRowHeights();
        this.mdHeightTabelleSonderausstattung = table.getTable().getPreferredSize().getHeight();
        return table.getScrollPane();
    }

    private JComponent createTabelleSerienausstattung() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn(Resource.getInstance().getCode(), 0, false, "XXXXXXXX");
        tableConfig.addColumn(Resource.getInstance().getBenennungSchnittstelle(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        tableConfig.addColumn(Resource.getInstance().getBenennungEtk(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.mtmSerienausstattung = new GenericTableModel(tableConfig);
        JavaFzgSucheInfo oFzgSucheInfo = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo();
        if (oFzgSucheInfo == null) {
            return null;
        }
        Ausstattung oAusstattung = oFzgSucheInfo.getAusstattung();
        if (oAusstattung == null) {
            return null;
        }
        Collection<Bedingung> cSerienausstattungen = oAusstattung.getSerienausstattung();
        if (cSerienausstattungen == null) {
            return null;
        }
        for (Bedingung oBedingung : cSerienausstattungen) {
            String sCode = oBedingung.getCode();
            String sBenennung = oBedingung.getName();
            String sBenennungSS = oBedingung.getNameSS();
            sBenennungSS = sBenennungSS == null ? "" : sBenennungSS;
            this.mtmSerienausstattung.addRow(new AbstractRow(new Object[]{sCode, sBenennungSS, sBenennung}));
        }
        GenericTable table = new GenericTable(this.mtmSerienausstattung);
        table.setAllowSizingSmallerThanMinimumWidth(false);
        table.calcRowHeights();
        this.mdHeightTabelleSerienausstattung = table.getTable().getPreferredSize().getHeight();
        return table.getScrollPane();
    }

    private JComponent createTabelleInformation() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn(Resource.getInstance().getCode(), 0, false, "XXXXXXXX");
        tableConfig.addColumn(Resource.getInstance().getBenennungSchnittstelle(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        tableConfig.addColumn(Resource.getInstance().getBenennungEtk(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.mtmInformation = new GenericTableModel(tableConfig);
        JavaFzgSucheInfo oFzgSucheInfo = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo();
        if (oFzgSucheInfo == null) {
            return null;
        }
        Ausstattung oAusstattung = oFzgSucheInfo.getAusstattung();
        if (oAusstattung == null) {
            return null;
        }
        Collection<Bedingung> cInformationen = oAusstattung.getInformationen();
        if (cInformationen == null) {
            return null;
        }
        for (Bedingung oBedingung : cInformationen) {
            String sCode = oBedingung.getCode();
            String sBenennung = oBedingung.getName();
            String sBenennungSS = oBedingung.getNameSS();
            sBenennungSS = sBenennungSS == null ? "" : sBenennungSS;
            this.mtmInformation.addRow(new AbstractRow(new Object[]{sCode, sBenennungSS, sBenennung}));
        }
        GenericTable table = new GenericTable(this.mtmInformation);
        table.setAllowSizingSmallerThanMinimumWidth(false);
        table.calcRowHeights();
        this.mdHeightTabelleInformation = table.getTable().getPreferredSize().getHeight();
        return table.getScrollPane();
    }

    private JComponent createTabelleIndividualfahrzeugdaten() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn(Resource.getInstance().getText(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        RealMultilineCellRenderer textRenderer = new RealMultilineCellRenderer();
        tableConfig.setRenderer(0, (TableCellRenderer)textRenderer);
        this.mtmIndividualfahrzeugdaten = new GenericTableModel(tableConfig);
        JavaFzgSucheInfo oFzgSucheInfo = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo();
        if (oFzgSucheInfo == null) {
            return null;
        }
        Ausstattung oAusstattung = oFzgSucheInfo.getAusstattung();
        if (oAusstattung == null) {
            return null;
        }
        Collection<String> cIndividualFahrzeugdaten = oAusstattung.getIndividualFahrzeugdaten();
        if (cIndividualFahrzeugdaten == null) {
            return null;
        }
        String sInterieur = oAusstattung.getIndividualInterieurCode();
        if (sInterieur != null && sInterieur.length() > 0) {
            String sText = Resource.getInstance().getRestlicheInnenausstattung() + ": " + sInterieur;
            this.mtmIndividualfahrzeugdaten.addRow(new AbstractRow(new Object[]{sText}));
            this.mtmIndividualfahrzeugdaten.addRow(new AbstractRow(new Object[]{""}));
        }
        for (String sText : cIndividualFahrzeugdaten) {
            this.mtmIndividualfahrzeugdaten.addRow(new AbstractRow(new Object[]{sText}));
        }
        GenericTable table = new GenericTable(this.mtmIndividualfahrzeugdaten);
        table.setAllowSizingSmallerThanMinimumWidth(false);
        table.calcRowHeights();
        this.mdHeightTabelleIndividualfahrzeugdaten = table.getTable().getPreferredSize().getHeight();
        return table.getScrollPane();
    }

    public void aufklappen(int nWas) {
        Dimension dim = new Dimension();
        switch (nWas) {
            case 1: {
                this.mlabIconPlusFahrzeugangaben.setVisible(false);
                this.mlabIconMinusFahrzeugangaben.setVisible(true);
                this.mpanTabelleFahrzeugangaben.setVisible(true);
                dim.setSize((double)this.mpanTabelleFahrzeugangaben.getWidth(), this.calcPanelHeight(1));
                this.mpanTabelleFahrzeugangaben.setPreferredSize(dim);
                break;
            }
            case 2: {
                this.mlabIconPlusSonderausstattung.setVisible(false);
                this.mlabIconMinusSonderausstattung.setVisible(true);
                this.mpanTabelleSonderausstattung.setVisible(true);
                dim.setSize((double)this.mpanTabelleSonderausstattung.getWidth(), this.calcPanelHeight(2));
                this.mpanTabelleSonderausstattung.setPreferredSize(dim);
                break;
            }
            case 3: {
                this.mlabIconPlusSerienausstattung.setVisible(false);
                this.mlabIconMinusSerienausstattung.setVisible(true);
                this.mpanTabelleSerienausstattung.setVisible(true);
                dim.setSize((double)this.mpanTabelleSerienausstattung.getWidth(), this.calcPanelHeight(3));
                this.mpanTabelleSerienausstattung.setPreferredSize(dim);
                break;
            }
            case 4: {
                this.mlabIconPlusInformation.setVisible(false);
                this.mlabIconMinusInformation.setVisible(true);
                this.mpanTabelleInformation.setVisible(true);
                dim.setSize((double)this.mpanTabelleInformation.getWidth(), this.calcPanelHeight(4));
                this.mpanTabelleInformation.setPreferredSize(dim);
                break;
            }
            case 5: {
                this.mlabIconPlusIndividualfahrzeugdaten.setVisible(false);
                this.mlabIconMinusIndividualfahrzeugdaten.setVisible(true);
                this.mpanTabelleIndividualfahrzeugdaten.setVisible(true);
                dim.setSize((double)this.mpanTabelleIndividualfahrzeugdaten.getWidth(), this.calcPanelHeight(5));
                this.mpanTabelleIndividualfahrzeugdaten.setPreferredSize(dim);
                break;
            }
        }
        this.contGesamt.repaint();
    }

    public void zuklappen(int nWas) {
        switch (nWas) {
            case 1: {
                this.mlabIconPlusFahrzeugangaben.setVisible(true);
                this.mlabIconMinusFahrzeugangaben.setVisible(false);
                this.mpanTabelleFahrzeugangaben.setVisible(false);
                break;
            }
            case 2: {
                this.mlabIconPlusSonderausstattung.setVisible(true);
                this.mlabIconMinusSonderausstattung.setVisible(false);
                this.mpanTabelleSonderausstattung.setVisible(false);
                break;
            }
            case 3: {
                this.mlabIconPlusSerienausstattung.setVisible(true);
                this.mlabIconMinusSerienausstattung.setVisible(false);
                this.mpanTabelleSerienausstattung.setVisible(false);
                break;
            }
            case 4: {
                this.mlabIconPlusInformation.setVisible(true);
                this.mlabIconMinusInformation.setVisible(false);
                this.mpanTabelleInformation.setVisible(false);
                break;
            }
            case 5: {
                this.mlabIconPlusIndividualfahrzeugdaten.setVisible(true);
                this.mlabIconMinusIndividualfahrzeugdaten.setVisible(false);
                this.mpanTabelleIndividualfahrzeugdaten.setVisible(false);
                break;
            }
        }
        this.contGesamt.repaint();
    }

    private double calcPanelHeight(int nWas) {
        switch (nWas) {
            case 1: {
                return this.mdHeightUeberschriftFahrzeugangaben + this.mdHeightTabelleFahrzeugangaben - 7.0;
            }
            case 2: {
                return this.mdHeightUeberschriftSonderausstattung + this.mdHeightTabelleSonderausstattung - 7.0;
            }
            case 3: {
                return this.mdHeightUeberschriftSerienausstattung + this.mdHeightTabelleSerienausstattung - 7.0;
            }
            case 4: {
                return this.mdHeightUeberschriftInformation + this.mdHeightTabelleInformation - 7.0;
            }
            case 5: {
                return this.mdHeightUeberschriftIndividualfahrzeugdaten + this.mdHeightTabelleIndividualfahrzeugdaten - 7.0;
            }
        }
        return 0.0;
    }

    private void showIndividualdatenVisible() {
        if (this.mlabIconPlusIndividualfahrzeugdaten.isVisible()) {
            this.aufklappen(5);
        }
        Rectangle rect = this.mpanIndividualfahrzeugdaten.getBounds();
        rect.x = 0;
        rect.y = 0;
        this.mpanIndividualfahrzeugdaten.scrollRectToVisible(rect);
    }

    private void printAusstattungsinfo() {
        JavaFzgSucheInfo oFzgSucheInfo = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo();
        String sFzgIdString = oFzgSucheInfo.getFzgIdString();
        AusstattungDruckansicht druckansicht = new AusstattungDruckansicht(sFzgIdString, this.mtmFahrzeugangaben, this.mtmSonderausstattung, this.mtmSerienausstattung, this.mtmInformation, this.mtmIndividualfahrzeugdaten);
        druckansicht.printAusstattungsinfo();
    }
}

