/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.fzgid;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoBrandAuthorizationException;
import webetk.NoDataFoundException;
import webetk.app.fzgid.Auftrag;
import webetk.app.fzgid.BedZusatzInfo;
import webetk.app.fzgid.FzgIdInfo;
import webetk.app.fzgid.ZusatzInfoMarke;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.teileliste.TeilelisteTO;
import webetk.communication.CommunicationException;
import webetk.communication.JavaFzgIdInfo;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfFahrzeugId;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfImage;
import webetk.communication.transferables.TrfTeileliste;
import webetk.javaclient.dialog.fzgid.DlgFzgIdModel;
import webetk.javaclient.dialog.fzgid.DlgFzgIdView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.utils.BooleanWrapper;
import webetk.javaclient.utils.DmsUtils;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.mrkprd.Marken;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class DlgFzgIdController
extends AbstractDialogViewController {
    private static Logger log = Logger.getLogger(DlgFzgIdController.class);
    protected DlgFzgIdView view = new DlgFzgIdView();
    protected DlgFzgIdModel model = new DlgFzgIdModel();
    protected String selectedTypeCode = null;

    public String getSelectedTypeCode() {
        return this.selectedTypeCode;
    }

    public void setSelectedTypeCode(String selectedTypeCode) {
        this.selectedTypeCode = selectedTypeCode;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    @Override
    public DialogView getDialogView() {
        log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public WorkflowStateData getExitData() {
        WorkflowStateData exitData = new WorkflowStateData();
        exitData.setWert("exitaction", "fzgermitteln");
        exitData.setWert("sachnummer", this.model.getSuchSachnummer());
        exitData.setWert("zusatz_info", this.model.getZusatzInfo());
        return exitData;
    }

    public void initFahrzeugidentifikation() {
        log.debug((Object)"Performing Init FzgId");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfFahrzeugId trfFI = new TrfFahrzeugId(null);
        String sVollstaendigeFI = this.model.isVollstaendigeFI() ? "true" : "false";
        trfFI.setValue("isvollstaendigefi", sVollstaendigeFI);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.START_FAHRZEUGIDENTIFIKATION);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFzgIdController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfFI.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFI.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFI.getError().getMessage(), Resource.getInstance().getFahrzeugidentifikation(), 0);
            return;
        }
        JavaFzgIdInfo oFzgIdInfo = (JavaFzgIdInfo)trfFI.getValue("fzgidinfo_java");
        this.model.storeFzgIdInfo(oFzgIdInfo);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void changeFahrzeugidentifikation() {
        log.debug((Object)"Performing Change FzgId");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfFahrzeugId trfFI = new TrfFahrzeugId(null);
        String sVollstaendigeFI = this.model.isVollstaendigeFI() ? "true" : "false";
        trfFI.setValue("isvollstaendigefi", sVollstaendigeFI);
        trfFI.setValue("marke", this.model.getMarke());
        trfFI.setValue("produktart", this.model.getProduktart());
        trfFI.setValue("katalogumfang", this.model.getKatalogumfang());
        if (this.model.getProduktart().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            trfFI.setValue("baureihe", this.model.getSelBaureihe());
            trfFI.setValue("karosserie", this.model.getSelKarosserie());
            trfFI.setValue("modell", this.model.getSelModell());
            trfFI.setValue("region", this.model.getSelRegion());
            trfFI.setValue("lenkung", this.model.getSelLenkung());
            trfFI.setValue("getriebe", this.model.getSelGetriebe());
            trfFI.setValue("baujahr", this.model.getSelBaujahr());
            trfFI.setValue("zulmonat", this.model.getSelZulMonat());
        } else {
            trfFI.setValue("bauart", this.model.getSelBauart());
            trfFI.setValue("baureihe", this.model.getSelBaureihe());
            trfFI.setValue("modell", this.model.getSelModell());
            trfFI.setValue("region", this.model.getSelRegion());
            trfFI.setValue("baujahr", this.model.getSelBaujahr());
            trfFI.setValue("zulmonat", this.model.getSelZulMonat());
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.CHANGE_FAHRZEUGIDENTIFIKATION);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFzgIdController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfFI.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFI.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFI.getError().getMessage(), Resource.getInstance().getFahrzeugidentifikation(), 0);
            return;
        }
        JavaFzgIdInfo oFzgIdInfo = (JavaFzgIdInfo)trfFI.getValue("fzgidinfo_java");
        this.model.storeFzgIdInfo(oFzgIdInfo);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public Map<Object, Object> getVehicleBasicInfo(String sFgstnr, boolean bIGDOM, boolean isVinUnique) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        HashMap vinBasicInfo = new HashMap();
        TrfFahrzeugId trfFI = new TrfFahrzeugId(null);
        trfFI.setIgdom(bIGDOM);
        trfFI.setValue("fgstnr", sFgstnr);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.GET_VIN_BASIC_INFO);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFzgIdController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        }
        Object vehicleBasicInfo = trfFI.getValue("vinBasic");
        vinBasicInfo = (HashMap)vehicleBasicInfo;
        return vinBasicInfo;
    }

    public Map<Object, Object> doFIByFahrgestellnummerVIN17(String sFgstnr, boolean bIGDOM) throws Exception {
        log.debug((Object)"Performing FI by FahrgestellnummerVIN17 ");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfFahrzeugId trfFI = new TrfFahrzeugId(null);
        trfFI.setIgdom(bIGDOM);
        trfFI.setValue("fgstnr", sFgstnr);
        boolean bIGDOMAngeschlossen = GlobalObjects.getInstance().getSessionInfo().getIGDOMAngeschlossen();
        boolean bIGDOMVerwenden = GlobalObjects.getInstance().getSessionInfo().getIGDOMVerwenden();
        boolean bIGDOMVerwendenUser = bIGDOM;
        if (bIGDOMVerwendenUser) {
            GlobalObjects.getInstance().getSessionInfo().setAktuelleSchnittstelle("igdom");
        } else {
            GlobalObjects.getInstance().getSessionInfo().setAktuelleSchnittstelle("keine");
        }
        String sIGDOMKontaktieren = bIGDOMAngeschlossen && bIGDOMVerwenden && bIGDOMVerwendenUser ? "true" : "false";
        GlobalObjects.getInstance().getSessionInfo().setIGDOMKontaktieren(Boolean.parseBoolean(sIGDOMKontaktieren));
        if (bIGDOM && sFgstnr.length() == 7) {
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.GET_VIN_RESOLVER_VIN17);
            }
            catch (CommunicationException ex) {
                log.error((Object)("DlgFzgIdController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        if (trfFI.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFI.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSuchanfrageKeineDaten(), Resource.getInstance().getFahrzeugidentifikation(), 1);
        }
        HashMap vin17DatenInfo = new HashMap();
        Object vin17DatenInfoObject = trfFI.getValue("vin17daten");
        vin17DatenInfo = (HashMap)vin17DatenInfoObject;
        log.debug((Object)("vin17DatenInfo data are:---" + vin17DatenInfo));
        return vin17DatenInfo;
    }

    public Map<Object, Object> doFIByFahrgestellnummerDuplicateVIN7(String sFgstnr, boolean bIGDOM) {
        log.debug((Object)"Performing FI by FahrgestellnummerDuplicateVIN7 ");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfFahrzeugId trfFI = new TrfFahrzeugId(null);
        trfFI.setIgdom(bIGDOM);
        trfFI.setValue("fgstnr", sFgstnr);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.FINALIZE_FAHRZEUGIDENTIFIKATION_WITH_FGSTNR);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFzgIdController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        }
        if (trfFI.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFI.getError());
            if (trfFI.getError() instanceof NoDataFoundException) {
                log.error((Object)("Vin not available for specified vin: " + sFgstnr));
            } else {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSuchanfrageKeineDaten(), Resource.getInstance().getFahrzeugidentifikation(), 1);
            }
        }
        HashMap vin17DatenInfo = new HashMap();
        if ("vin17daten" != null) {
            this.resetFzId();
        }
        Object vin17DatenInfoObject = trfFI.getValue("vin17daten");
        vin17DatenInfo = (HashMap)vin17DatenInfoObject;
        log.debug((Object)("vin17DatenInfo data are:---" + vin17DatenInfo));
        return vin17DatenInfo;
    }

    public boolean doFIByFahrgestellnummer(String sFgstnr, boolean bIGDOM, Object vehicleBasicInfo, String marketSalesSpecDesc) throws Exception {
        log.debug((Object)"Performing FI by Fahrgestellnummer ");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfFahrzeugId trfFI = new TrfFahrzeugId(null);
        trfFI.setIgdom(bIGDOM);
        String typeCode = this.getSelectedTypeCode();
        String sVollstaendigeFI = this.model.isVollstaendigeFI() ? "true" : "false";
        trfFI.setValue("isvollstaendigefi", sVollstaendigeFI);
        trfFI.setValue("marke", this.model.getMarke());
        trfFI.setValue("produktart", this.model.getProduktart());
        trfFI.setValue("katalogumfang", this.model.getKatalogumfang());
        trfFI.setValue("fgstnr", sFgstnr);
        trfFI.setValue("typ", typeCode);
        boolean bIGDOMAngeschlossen = GlobalObjects.getInstance().getSessionInfo().getIGDOMAngeschlossen();
        boolean bIGDOMVerwenden = GlobalObjects.getInstance().getSessionInfo().getIGDOMVerwenden();
        boolean bIGDOMVerwendenUser = bIGDOM;
        if (bIGDOMVerwendenUser) {
            GlobalObjects.getInstance().getSessionInfo().setAktuelleSchnittstelle("igdom");
        } else {
            GlobalObjects.getInstance().getSessionInfo().setAktuelleSchnittstelle("keine");
        }
        String sIGDOMKontaktieren = bIGDOMAngeschlossen && bIGDOMVerwenden && bIGDOMVerwendenUser ? "true" : "false";
        GlobalObjects.getInstance().getSessionInfo().setIGDOMKontaktieren(Boolean.parseBoolean(sIGDOMKontaktieren));
        trfFI.setValue("igdom_schnittstelle_kontaktieren", sIGDOMKontaktieren);
        trfFI.setValue("sowu_schnittstelle_kontaktieren", sIGDOMKontaktieren);
        trfFI.setValue("lackcode", this.model.getLackCode());
        trfFI.setValue("afcode", this.model.getAFCode());
        trfFI.setValue("vinBasic", vehicleBasicInfo);
        trfFI.setValue("marketSalesSpecDesc", marketSalesSpecDesc);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.FINALIZE_FAHRZEUGIDENTIFIKATION_WITH_FGSTNR);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFzgIdController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfFI.getError() != null) {
            if (trfFI.getError() instanceof CommunicationException) {
                log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFI.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getZentraleSucheConnectionFehler(), Resource.getInstance().getFahrzeugidentifikation(), 0);
                throw (CommunicationException)trfFI.getError();
            }
            if (trfFI.getError() instanceof NoDataFoundException) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                throw (NoDataFoundException)trfFI.getError();
            }
            if (trfFI.getError() instanceof NoBrandAuthorizationException) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                throw (NoBrandAuthorizationException)trfFI.getError();
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFI.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFI.getError().getMessage(), Resource.getInstance().getFahrzeugidentifikation(), 0);
            throw trfFI.getError();
        }
        JavaFzgSucheInfo oFzgSucheInfo = (JavaFzgSucheInfo)trfFI.getValue("fzgsucheinfo_java");
        JavaFzgIdInfo oFzgIdInfo = (JavaFzgIdInfo)trfFI.getValue("fzgidinfo_java");
        GlobalObjects.getInstance().getEtkData().setSucheInfo(oFzgSucheInfo);
        GlobalObjects.getInstance().setFzgIdInfo(oFzgIdInfo);
        if (oFzgIdInfo != null) {
            StringBuffer vinUndAttribute = new StringBuffer(sFgstnr);
            vinUndAttribute.append(" ");
            if (oFzgIdInfo.getProduktart().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                vinUndAttribute.append(oFzgIdInfo.getBaureiheBezeichnung());
                vinUndAttribute.append(" ");
                vinUndAttribute.append(oFzgIdInfo.getKarosserieBezeichnung());
            } else if (oFzgIdInfo.getProduktart().equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                vinUndAttribute.append(oFzgIdInfo.getBauartBezeichnung());
                vinUndAttribute.append(" ");
                vinUndAttribute.append(oFzgIdInfo.getBaureiheBezeichnung());
            }
            vinUndAttribute.append(" ");
            vinUndAttribute.append(oFzgIdInfo.getModell());
            GlobalObjects.getInstance().getEtkData().addVin(vinUndAttribute.toString());
        }
        if (oFzgSucheInfo != null && (oFzgSucheInfo.getIGDOMFehler() || oFzgSucheInfo.getVINSpecFehler())) {
            String sMessage = null;
            sMessage = oFzgSucheInfo.getIGDOMFehler() ? Resource.getInstance().getFehlerIgdomJava() : (oFzgSucheInfo.getVINSpecFehler() ? Resource.getInstance().getFehlerVinspecJava() : Resource.getInstance().getFehlerIgdomJava());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMessage, Resource.getInstance().getFahrzeugidentifikation(), 1);
        }
        if (oFzgSucheInfo != null) {
            this.model.setMarke(oFzgSucheInfo.getMarke());
            this.model.setProduktart(oFzgSucheInfo.getProduktart());
            this.model.setKatalogumfang(oFzgSucheInfo.getKatalogumfang());
        }
        BedZusatzInfo oBedZusatzInfo = (BedZusatzInfo)trfFI.getValue("bed_zusatz_info");
        this.model.setZusatzInfo(oBedZusatzInfo);
        if (this.model.getMarke().equals(Marken.getInstance().getMarke("BMWi").getBerechtigung()) && (oBedZusatzInfo == null || !oBedZusatzInfo.hatInfotexte())) {
            this.model.setZusatzInfo(null);
            this.model.setZusatzInfo(this.ladeZusatzInfoMarke());
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        GlobalObjects.getInstance().resetETKTexte();
        GlobalObjects.getInstance().setAktuelleHG(null);
        return true;
    }

    public static boolean doFIByFahrgestellnummer(String sFgstnr) {
        return DlgFzgIdController.doFIByFahrgestellnummer(sFgstnr, false, null);
    }

    public static boolean doFIByFahrgestellnummer(String sFgstnr, boolean bTemporaer, Collection<Object> cFzgInfo) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        BooleanWrapper bIGDOMAngeschlossen = new BooleanWrapper(false);
        BooleanWrapper bIGDOMVerwendenUser = new BooleanWrapper(false);
        DlgFzgIdController.ermitteleAusstattungUeber(bIGDOMAngeschlossen, bIGDOMVerwendenUser);
        boolean bIGDOMKontaktieren = bIGDOMAngeschlossen.getValue() && bIGDOMVerwendenUser.getValue();
        String sIGDOMKontaktieren = bIGDOMKontaktieren ? "true" : "false";
        TrfFahrzeugId trfFI = new TrfFahrzeugId(null);
        trfFI.setIgdom(bIGDOMKontaktieren);
        trfFI.setValue("isvollstaendigefi", "false");
        trfFI.setValue("fgstnr", sFgstnr);
        trfFI.setValue("igdom_schnittstelle_kontaktieren", sIGDOMKontaktieren);
        Boolean bIsTemporaer = bTemporaer;
        trfFI.setValue("is_temporaer", bIsTemporaer);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.FINALIZE_FAHRZEUGIDENTIFIKATION_WITH_FGSTNR);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFzgIdController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfFI.getError() != null) {
            if (trfFI.getError() instanceof NoDataFoundException) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFahrgestellnummerNoData(), Resource.getInstance().getFahrzeugidentifikation(), 0);
                return false;
            }
            if (trfFI.getError() instanceof NoBrandAuthorizationException) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineMarkenberechtigung(), Resource.getInstance().getFahrzeugidentifikation(), 0);
                return false;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFI.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFI.getError().getMessage(), Resource.getInstance().getFahrzeugidentifikation(), 0);
            return false;
        }
        JavaFzgSucheInfo oFzgSucheInfoClient = (JavaFzgSucheInfo)trfFI.getValue("fzgsucheinfo_java");
        JavaFzgIdInfo oFzgIdInfoClient = (JavaFzgIdInfo)trfFI.getValue("fzgidinfo_java");
        FzgSucheInfo oFzgSucheInfoServer = (FzgSucheInfo)trfFI.getValue("fzgsucheinfo_app");
        FzgIdInfo oFzgIdInfoServer = (FzgIdInfo)trfFI.getValue("fzgidinfo_app");
        if (!bTemporaer) {
            GlobalObjects.getInstance().getEtkData().setSucheInfo(oFzgSucheInfoClient);
            GlobalObjects.getInstance().setFzgIdInfo(oFzgIdInfoClient);
        } else {
            cFzgInfo.add(oFzgSucheInfoClient);
            cFzgInfo.add(oFzgIdInfoClient);
            cFzgInfo.add(oFzgSucheInfoServer);
            cFzgInfo.add(oFzgIdInfoServer);
        }
        if (oFzgSucheInfoClient != null && (oFzgSucheInfoClient.getIGDOMFehler() || oFzgSucheInfoClient.getVINSpecFehler())) {
            String sMessage = null;
            sMessage = oFzgSucheInfoClient.getIGDOMFehler() ? Resource.getInstance().getFehlerIgdomJava() : Resource.getInstance().getFehlerVinspecJava();
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMessage, Resource.getInstance().getFahrzeugidentifikation(), 1);
        }
        GlobalObjects.getInstance().resetETKTexte();
        GlobalObjects.getInstance().setAktuelleHG(null);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    public static void ermitteleAusstattungUeber(BooleanWrapper bIGDOMAngeschlossen, BooleanWrapper bIGDOMGewaehlt) {
        bIGDOMAngeschlossen.setValue(GlobalObjects.getInstance().hasNetz());
        String sAktuelleSchnittstelle = GlobalObjects.getInstance().getSessionInfo().getAktuelleSchnittstelle();
        if (bIGDOMAngeschlossen.getValue()) {
            if (sAktuelleSchnittstelle.equals("keine")) {
                bIGDOMGewaehlt.setValue(false);
            } else if (sAktuelleSchnittstelle.equals("igdom") && bIGDOMAngeschlossen.getValue()) {
                bIGDOMGewaehlt.setValue(true);
            } else if (bIGDOMAngeschlossen.getValue()) {
                bIGDOMGewaehlt.setValue(true);
            } else {
                bIGDOMGewaehlt.setValue(false);
            }
        } else {
            bIGDOMGewaehlt.setValue(false);
        }
    }

    public static boolean doFIByTypAttribute(JavaFzgIdInfo oFzgIdInfo) throws Exception {
        log.debug((Object)"Performing FI by Attributes with FzgIdInfo..");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        boolean bIsCompletelyIdentified = oFzgIdInfo.isCompletelyIdentified();
        String sIsVollstaendigeFI = bIsCompletelyIdentified ? "true" : "false";
        String sMarke = oFzgIdInfo.getMarke();
        String sProduktart = oFzgIdInfo.getProduktart();
        String sKatalogumfang = oFzgIdInfo.getKatalogumfang();
        String sSelBaureihe = oFzgIdInfo.getBaureihe();
        String sSelKarosserie = oFzgIdInfo.getKarosserie();
        String sSelModell = oFzgIdInfo.getModell();
        String sSelRegion = oFzgIdInfo.getRegion();
        String sSelLenkung = oFzgIdInfo.getLenkung();
        String sSelGetriebe = oFzgIdInfo.getGetriebe();
        String sSelBaujahr = oFzgIdInfo.getBaujahr();
        String sSelZulMonat = oFzgIdInfo.getZulMonat();
        String sSelBauart = oFzgIdInfo.getBauart();
        TrfFahrzeugId trfFI = new TrfFahrzeugId(null);
        trfFI.setValue("isvollstaendigefi", sIsVollstaendigeFI);
        trfFI.setValue("marke", sMarke);
        trfFI.setValue("produktart", sProduktart);
        trfFI.setValue("katalogumfang", sKatalogumfang);
        trfFI.setValue("baureihe", sSelBaureihe);
        trfFI.setValue("modell", sSelModell);
        trfFI.setValue("region", sSelRegion);
        trfFI.setValue("baujahr", sSelBaujahr);
        trfFI.setValue("zulmonat", sSelZulMonat);
        if (sProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            trfFI.setValue("karosserie", sSelKarosserie);
            trfFI.setValue("lenkung", sSelLenkung);
            trfFI.setValue("getriebe", sSelGetriebe);
        } else {
            trfFI.setValue("bauart", sSelBauart);
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.FINALIZE_FAHRZEUGIDENTIFIKATION_WITH_ATTR);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFzgIdController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfFI.getError() != null) {
            if (trfFI.getError() instanceof NoDataFoundException) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                throw (NoDataFoundException)trfFI.getError();
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFI.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFI.getError().getMessage(), Resource.getInstance().getFahrzeugidentifikation(), 0);
            throw trfFI.getError();
        }
        JavaFzgSucheInfo oFzgSucheInfo = (JavaFzgSucheInfo)trfFI.getValue("fzgsucheinfo_java");
        JavaFzgIdInfo oNewFzgIdInfo = (JavaFzgIdInfo)trfFI.getValue("fzgidinfo_java");
        GlobalObjects.getInstance().getEtkData().setSucheInfo(oFzgSucheInfo);
        GlobalObjects.getInstance().setFzgIdInfo(oNewFzgIdInfo);
        GlobalObjects.getInstance().getSessionInfo().setIGDOMKontaktieren(false);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    public void doFIByTypAttribute() throws NoDataFoundException, Exception {
        log.debug((Object)"Performing FI by Attributes ");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfFahrzeugId trfFI = new TrfFahrzeugId(null);
        String sVollstaendigeFI = this.model.isVollstaendigeFI() ? "true" : "false";
        trfFI.setValue("isvollstaendigefi", sVollstaendigeFI);
        trfFI.setValue("marke", this.model.getMarke());
        trfFI.setValue("produktart", this.model.getProduktart());
        trfFI.setValue("katalogumfang", this.model.getKatalogumfang());
        if (this.model.getProduktart().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            trfFI.setValue("baureihe", this.model.getSelBaureihe());
            trfFI.setValue("karosserie", this.model.getSelKarosserie());
            trfFI.setValue("modell", this.model.getSelModell());
            trfFI.setValue("region", this.model.getSelRegion());
            trfFI.setValue("lenkung", this.model.getSelLenkung());
            trfFI.setValue("getriebe", this.model.getSelGetriebe());
            trfFI.setValue("baujahr", this.model.getSelBaujahr());
            trfFI.setValue("zulmonat", this.model.getSelZulMonat());
        } else {
            trfFI.setValue("bauart", this.model.getSelBauart());
            trfFI.setValue("baureihe", this.model.getSelBaureihe());
            trfFI.setValue("modell", this.model.getSelModell());
            trfFI.setValue("region", this.model.getSelRegion());
            trfFI.setValue("baujahr", this.model.getSelBaujahr());
            trfFI.setValue("zulmonat", this.model.getSelZulMonat());
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.FINALIZE_FAHRZEUGIDENTIFIKATION_WITH_ATTR);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFzgIdController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfFI.getError() != null) {
            if (trfFI.getError() instanceof NoDataFoundException) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                throw (NoDataFoundException)trfFI.getError();
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFI.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFI.getError().getMessage(), Resource.getInstance().getFahrzeugidentifikation(), 0);
            throw trfFI.getError();
        }
        JavaFzgSucheInfo oFzgSucheInfo = (JavaFzgSucheInfo)trfFI.getValue("fzgsucheinfo_java");
        JavaFzgIdInfo oFzgIdInfo = (JavaFzgIdInfo)trfFI.getValue("fzgidinfo_java");
        GlobalObjects.getInstance().getEtkData().setSucheInfo(oFzgSucheInfo);
        GlobalObjects.getInstance().setFzgIdInfo(oFzgIdInfo);
        GlobalObjects.getInstance().getSessionInfo().setIGDOMKontaktieren(false);
        this.model.setZusatzInfo(null);
        if (this.model.getMarke().equals(Marken.getInstance().getMarke("BMWi").getBerechtigung())) {
            this.model.setZusatzInfo(this.ladeZusatzInfoMarke());
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public byte[] ladeGrafik(String sGrafikId, String sGrafikTimestamp) {
        log.debug((Object)"Performing Load Grafik");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfImage trfImage = new TrfImage(null);
        trfImage.setImageID(sGrafikId);
        trfImage.setTimestamp(sGrafikTimestamp);
        trfImage.setFormFactor("T");
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfImage, Command.GET_IMAGE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFzgIdController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfImage.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfImage.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfImage.getError().getMessage(), Resource.getInstance().getFahrzeugidentifikation(), 0);
            return null;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return trfImage.toByteArray();
    }

    public ZusatzInfoMarke ladeZusatzInfoMarke() {
        log.debug((Object)"Performing Load ZusatzInfoMarke");
        TrfFahrzeugId trfFIZI = new TrfFahrzeugId(null);
        trfFIZI.setValue("marke", this.model.getMarke());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFIZI, Command.LOAD_ZUSATZINFO_MARKE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFzgIdController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfFIZI.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFIZI.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFIZI.getError().getMessage(), Resource.getInstance().getFahrzeugidentifikation(), 0);
            return null;
        }
        return (ZusatzInfoMarke)trfFIZI.getValue("zusatz_info_marke");
    }

    public TeilelisteTO holenAuftrag(String sAuftragsnummer) throws NoDataFoundException {
        log.debug((Object)"Performing get Teileliste by Auftragsnummer ");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfAuftragsnummer = new TrfHashMap(null);
        trfAuftragsnummer.setValue("auftragsnr", sAuftragsnummer);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfAuftragsnummer, Command.FI_LOAD_TL_ZU_AUFTRAG);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFzgIdController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfAuftragsnummer.getError() != null) {
            if (trfAuftragsnummer.getError() instanceof NoDataFoundException) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                throw (NoDataFoundException)trfAuftragsnummer.getError();
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfAuftragsnummer.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfAuftragsnummer.getError().getMessage(), Resource.getInstance().getFahrzeugidentifikation(), 0);
            return null;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        TeilelisteTO oAuftrag = (TeilelisteTO)trfAuftragsnummer.getValue("teileliste_TO");
        this.model.setAuftragsnummer(oAuftrag.getAuftragsnummer());
        this.model.setTeilelisteAuftrag(oAuftrag.getTeilelistenId());
        this.model.setKundenname(oAuftrag.getKundenname());
        this.model.setKundennummer(oAuftrag.getKundennummer());
        this.model.setFahrgestellnummer(oAuftrag.getFahrgestellnummer(), 3);
        return oAuftrag;
    }

    protected void holenAuftragVonDMSByAuftragsnummer(String sAuftragsnummer) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfAuftrag = new TrfHashMap(null);
        trfAuftrag.setValue("auftragsnr", sAuftragsnummer);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfAuftrag, Command.DO_DMS_AUFTRAG);
        }
        catch (CommunicationException ex) {
            log.error((Object)("holenAuftragVonDMS: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        Integer nStatus = (Integer)trfAuftrag.getValue("returncode");
        if (!DmsUtils.showMsgTxt((String)trfAuftrag.getValue("msgtxt"), nStatus)) {
            return;
        }
        if (trfAuftrag.getError() != null) {
            String sMsg = Resource.getInstance().getGetAuftragsdatenDmsFailed() + " " + trfAuftrag.getError().getMessage();
            log.error((Object)sMsg);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getFahrzeugidentifikation(), 0);
            return;
        }
        String sKundennummer = (String)trfAuftrag.getValue("kundennr");
        this.model.setKundennummer(sKundennummer);
        String sKundenname = (String)trfAuftrag.getValue("kundenname");
        this.model.setKundenname(sKundenname);
        String sFahrgestellnummer = (String)trfAuftrag.getValue("fgstnr");
        this.model.setFahrgestellnummer(sFahrgestellnummer, 3);
        this.model.setAuftragsnummer(sAuftragsnummer);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void holenAuftragVonDMSByKfzKennzeichen(String sKfzKennezeichen) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfAuftrag = new TrfHashMap(null);
        trfAuftrag.setValue("kfz-kennezeichen", sKfzKennezeichen);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfAuftrag, Command.DO_DMS_AUFTRAG_KFZ_KENNZEICHEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("holenAuftragVonDMS: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        Integer nStatus = (Integer)trfAuftrag.getValue("returncode");
        if (!DmsUtils.showMsgTxt((String)trfAuftrag.getValue("msgtxt"), nStatus)) {
            return;
        }
        if (trfAuftrag.getError() != null) {
            String sMsg = Resource.getInstance().getGetAuftragsdatenDmsFailed() + trfAuftrag.getError().getMessage();
            log.error((Object)sMsg);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getFahrzeugidentifikation(), 0);
            return;
        }
        String sAuftragsnummer = (String)trfAuftrag.getValue("auftragsnr");
        this.model.setAuftragsnummer(sAuftragsnummer);
        String sKundennummer = (String)trfAuftrag.getValue("kundennr");
        this.model.setKundennummer(sKundennummer);
        String sKundenname = (String)trfAuftrag.getValue("kundenname");
        this.model.setKundenname(sKundenname);
        String sFahrgestellnummer = (String)trfAuftrag.getValue("fgstnr");
        this.model.setFahrgestellnummer(sFahrgestellnummer, 4);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected String saveTeileliste(Auftrag oAuftrag) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfTeileliste = new TrfTeileliste(null);
        trfTeileliste.setValue("marke", this.model.getMarke());
        trfTeileliste.setValue("teilelistenewid", this.model.getAuftragsnummer());
        trfTeileliste.setValue("teilelistebemerkung", this.model.getKundenname());
        trfTeileliste.setValue("auftrag", oAuftrag);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTeileliste, Command.SAVE_TEILELISTE_KOPFDATEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("saveTeileliste: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfTeileliste.getError() != null) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSaveTeilelistendatenFailed(), Resource.getInstance().getFahrzeugidentifikation(), 0);
            return null;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return this.model.getAuftragsnummer();
    }

    protected Auftrag saveAuftrag(boolean bInsert) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeileliste trfAuftrag = new TrfTeileliste(null);
        trfAuftrag.setValue("auftragsnr", this.model.getAuftragsnummer());
        trfAuftrag.setValue("kundennr", this.model.getKundennummer());
        trfAuftrag.setValue("kundenname", this.model.getKundenname());
        trfAuftrag.setValue("fgstnr", this.model.getFahrgestellnummer());
        trfAuftrag.setValue("fgstnr", this.model.getFahrgestellnummer());
        String sModus = bInsert ? "insert" : "update";
        trfAuftrag.setValue("modus", sModus);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfAuftrag, Command.SAVE_AUFTRAG);
        }
        catch (CommunicationException ex) {
            log.error((Object)("saveAuftrag: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfAuftrag.getError() != null) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSaveAuftragsdatenFailed(), Resource.getInstance().getFahrzeugidentifikation(), 0);
            return null;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        Auftrag oAuftrag = (Auftrag)trfAuftrag.getValue("auftrag");
        return oAuftrag;
    }

    public void resetFzId() {
        TrfFahrzeugId trfFI = new TrfFahrzeugId(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFI, Command.RESET_FAHRZEUGIDENTIFIKATION);
        }
        catch (CommunicationException e) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), Resource.getInstance().getFahrzeugidentifikation(), 0);
        }
    }

    public static class ExitActions {
        public static final String FZG_ERMITTELN = "fzgermitteln";
    }
}

