/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.fzgid;

import de.esg.commonclient.GkiZugriffException;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import java.awt.Cursor;
import java.io.FileReader;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.app.ValueAndNameSupport;
import webetk.app.fzgid.ZusatzInfo;
import webetk.communication.JavaFzgIdInfo;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.LoginInfo;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class DlgFzgIdModel
extends AbstractDialogModel {
    public static final int MOD_FGSTNR_UNDEF = 0;
    public static final int MOD_FGSTNR_PER_HAND = 1;
    public static final int MOD_FGSTNR_KEYREADER = 2;
    public static final int MOD_FGSTNR_AUFTRAG = 3;
    public static final int MOD_FGSTNR_KFZ_KEZ = 4;
    public static final int MOD_FGSTNR_DATEI = 5;
    private static Logger log = Logger.getLogger(DlgFzgIdModel.class);
    private String msDialogModus = null;
    private boolean mbNoChangeToProduktartKrad = false;
    private boolean mbShowProduktartMeldung = false;
    private String msProduktartMeldung = null;
    private boolean mbIsUpdate = false;
    JavaFzgIdInfo moFzgIdInfo = null;
    private boolean mbVollstaendigeFI = false;
    private String msMarke = null;
    private String msProduktart = null;
    private String msKatalogumfang = null;
    private String msFahrgestellnummer = null;
    private String msFahrgestellnummerAuftrag = null;
    private int mnFahrgestellnummerModus = 0;
    private String msSelSerie = null;
    private String msSelBauart = null;
    private String msSelBaureihe = null;
    private String msSelKarosserie = null;
    private String msSelModell = null;
    private String msSelRegion = null;
    private String msSelLenkung = null;
    private String msSelGetriebe = null;
    private String msSelBaujahr = null;
    private String msSelZulMonat = null;
    private String msCodeLack = null;
    private String msCodeAF = null;
    private String msTeilelisteAuftrag = null;
    private String msKundennummer = null;
    private String msKundenname = null;
    private String msAuftragsnummer = null;
    private String msSuchSachnummer = null;
    private ZusatzInfo moZusatzInfo = null;
    private boolean mbIGDOM = true;

    public boolean isIGDOM() {
        return this.mbIGDOM;
    }

    public void setIGDOM(boolean bIGDOM) {
        this.mbIGDOM = bIGDOM;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        super.init(oWFStateData);
        this.msDialogModus = (String)oWFStateData.getWert("modus");
        String sVollstaendigeFI = (String)oWFStateData.getWert("isvollstaendigefi");
        this.mbVollstaendigeFI = sVollstaendigeFI != null && sVollstaendigeFI.equals("true");
        String sIsUpdate = (String)oWFStateData.getWert("isupdate");
        this.mbIsUpdate = sIsUpdate != null && sIsUpdate.equals("true");
        JavaFzgSucheInfo oFzgSucheInfo = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo();
        if (oFzgSucheInfo != null) {
            this.msMarke = oFzgSucheInfo.getMarke();
            this.msProduktart = oFzgSucheInfo.getProduktart();
            this.msKatalogumfang = oFzgSucheInfo.getKatalogumfang();
        } else {
            LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
            this.msMarke = oLoginInfo.getMarke();
            this.msProduktart = oLoginInfo.getProdukart();
            this.msKatalogumfang = oLoginInfo.getKatalogUmfang();
        }
        this.mbNoChangeToProduktartKrad = false;
        if (this.msDialogModus.equals("FI_Federtabelle") || this.msDialogModus.equals("FI_Fuellmengen")) {
            this.mbNoChangeToProduktartKrad = true;
            if (this.msDialogModus.equals("FI_Federtabelle")) {
                this.msProduktartMeldung = Resource.getInstance().getHinweisFedertabelleMotorrad();
            }
            if (this.msDialogModus.equals("FI_Fuellmengen")) {
                this.msProduktartMeldung = Resource.getInstance().getHinweisFuellmengenMotorrad();
            }
            if (this.msProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                this.mbShowProduktartMeldung = true;
                this.msProduktart = Produkte.getInstance().getProdukt("AUTO").getBerechtigung();
            }
        }
    }

    public String getSelBauart() {
        return this.msSelBauart;
    }

    public int getIndexSelBauart(String sBauart) {
        Vector<ValueAndNameSupport> aBauarten = this.moFzgIdInfo.getBauarten();
        for (int i = 0; i < aBauarten.size(); ++i) {
            ValueAndNameSupport oObject = aBauarten.get(i);
            if (!oObject.getValue().equals(sBauart)) continue;
            return i;
        }
        return -1;
    }

    public void storeSelBauart(int nIndex) {
        Vector<ValueAndNameSupport> aBauarten = this.moFzgIdInfo.getBauarten();
        ValueAndNameSupport oObject = aBauarten.get(nIndex);
        this.msSelBauart = oObject.getValue();
    }

    public void resetSelBauart() {
        this.msSelBauart = null;
    }

    public Vector<String> getBauartenAsStringVector() {
        Vector<String> aBauarten = new Vector<String>();
        if (this.moFzgIdInfo.getBauarten().isEmpty()) {
            return aBauarten;
        }
        for (ValueAndNameSupport oObj : this.moFzgIdInfo.getBauarten()) {
            aBauarten.add(oObj.getName());
        }
        return aBauarten;
    }

    public Vector<String> getSerieAsStringVector() {
        Vector<String> aSerie = new Vector<String>();
        if (this.moFzgIdInfo.getBaureihen().isEmpty()) {
            return aSerie;
        }
        for (ValueAndNameSupport oObj : this.moFzgIdInfo.getBaureihen()) {
            if (aSerie.contains(oObj.getName().substring(0, 2))) continue;
            aSerie.add(oObj.getName().substring(0, 2));
        }
        return aSerie;
    }

    public String getSelSerie() {
        return this.msSelSerie;
    }

    public int getIndexSelSerie(String sSerie) {
        for (int i = 0; i < this.getSerieAsStringVector().size(); ++i) {
            String serie = this.getSerieAsStringVector().get(i);
            if (!serie.equals(sSerie)) continue;
            return i;
        }
        return -1;
    }

    public void storeSelSerie(int nIndex) {
        this.msSelSerie = this.getSerieAsStringVector().get(nIndex);
    }

    public void resetSelSerie() {
        this.msSelSerie = null;
    }

    public String getSelBaureihe() {
        return this.msSelBaureihe;
    }

    public int getIndexSelBaureiheSerie(String sBaureihe) {
        ValueAndNameSupport oObject;
        int i;
        Vector<ValueAndNameSupport> aBaureihen = this.moFzgIdInfo.getBaureihen();
        Vector<ValueAndNameSupport> aBaureihenSerie = new Vector<ValueAndNameSupport>();
        for (i = 0; i < aBaureihen.size(); ++i) {
            oObject = aBaureihen.get(i);
            if (!oObject.getName().contains(this.msSelSerie)) continue;
            aBaureihenSerie.add(oObject);
        }
        for (i = 0; i < aBaureihenSerie.size(); ++i) {
            oObject = (ValueAndNameSupport)aBaureihenSerie.get(i);
            if (!oObject.getValue().equals(sBaureihe)) continue;
            return i;
        }
        return -1;
    }

    public void storeSelBaureiheSerie(int nIndex) {
        Vector<ValueAndNameSupport> aBaureihen = this.moFzgIdInfo.getBaureihen();
        Vector<ValueAndNameSupport> aBaureihenSerie = new Vector<ValueAndNameSupport>();
        for (int i = 0; i < aBaureihen.size(); ++i) {
            ValueAndNameSupport oObject = aBaureihen.get(i);
            if (!oObject.getName().contains(this.msSelSerie)) continue;
            aBaureihenSerie.add(oObject);
        }
        ValueAndNameSupport oObject = (ValueAndNameSupport)aBaureihenSerie.get(nIndex);
        this.msSelBaureihe = oObject.getValue();
    }

    public int getIndexSelBaureihe(String sBaureihe) {
        Vector<ValueAndNameSupport> aBaureihen = this.moFzgIdInfo.getBaureihen();
        for (int i = 0; i < aBaureihen.size(); ++i) {
            ValueAndNameSupport oObject = aBaureihen.get(i);
            if (!oObject.getValue().equals(sBaureihe)) continue;
            return i;
        }
        return -1;
    }

    public void storeSelBaureihe(int nIndex) {
        Vector<ValueAndNameSupport> aBaureihen = this.moFzgIdInfo.getBaureihen();
        ValueAndNameSupport oObject = aBaureihen.get(nIndex);
        this.msSelBaureihe = oObject.getValue();
    }

    public void resetSelBaureihe() {
        this.msSelBaureihe = null;
    }

    public Vector<String> getBaureihenPlainAsStringVector() {
        Vector<String> aBaureihen = new Vector<String>();
        if (this.moFzgIdInfo.getBaureihen().isEmpty()) {
            return aBaureihen;
        }
        if (this.msSelSerie == null) {
            return aBaureihen;
        }
        for (ValueAndNameSupport oObj : this.moFzgIdInfo.getBaureihen()) {
            if (!oObj.getName().contains(this.msSelSerie)) continue;
            aBaureihen.add(oObj.getName().substring(3, oObj.getName().length()));
        }
        return aBaureihen;
    }

    public Vector<String> getBaureihenAsStringVector() {
        Vector<String> aBaureihen = new Vector<String>();
        if (this.moFzgIdInfo.getBaureihen().isEmpty()) {
            return aBaureihen;
        }
        for (ValueAndNameSupport oObj : this.moFzgIdInfo.getBaureihen()) {
            aBaureihen.add(oObj.getName());
        }
        return aBaureihen;
    }

    public String getSelKarosserie() {
        return this.msSelKarosserie;
    }

    public int getIndexSelKarosserie(String sKarosserie) {
        Vector<ValueAndNameSupport> aKarosserien = this.moFzgIdInfo.getKarosserien();
        for (int i = 0; i < aKarosserien.size(); ++i) {
            ValueAndNameSupport oObject = aKarosserien.get(i);
            if (!oObject.getValue().equals(sKarosserie)) continue;
            return i;
        }
        return -1;
    }

    public void storeSelKarosserie(int nIndex) {
        Vector<ValueAndNameSupport> aKarosserien = this.moFzgIdInfo.getKarosserien();
        ValueAndNameSupport oObject = aKarosserien.get(nIndex);
        this.msSelKarosserie = oObject.getValue();
    }

    public void resetSelKarosserie() {
        this.msSelKarosserie = null;
    }

    public Vector<String> getKarosserienAsStringVector() {
        Vector<String> aKarosserien = new Vector<String>();
        if (this.moFzgIdInfo.getKarosserien().isEmpty()) {
            return aKarosserien;
        }
        for (ValueAndNameSupport oObj : this.moFzgIdInfo.getKarosserien()) {
            aKarosserien.add(oObj.getName());
        }
        return aKarosserien;
    }

    public String getSelModell() {
        return this.msSelModell;
    }

    public void storeSelModell(String sModell) {
        this.msSelModell = sModell;
    }

    public void resetSelModell() {
        this.msSelModell = null;
    }

    public Vector<String> getModelleAsStringVector() {
        return this.moFzgIdInfo.getModelle();
    }

    public String getSelRegion() {
        return this.msSelRegion;
    }

    public void storeSelRegion(String sRegion) {
        this.msSelRegion = sRegion;
    }

    public void resetSelRegion() {
        this.msSelRegion = null;
    }

    public Vector<String> getRegionenAsStringVector() {
        return this.moFzgIdInfo.getRegionen();
    }

    public String getSelLenkung() {
        return this.msSelLenkung;
    }

    public int getIndexSelLenkung(String sLenkung) {
        Vector<ValueAndNameSupport> aLenkungen = this.moFzgIdInfo.getLenkungen();
        for (int i = 0; i < aLenkungen.size(); ++i) {
            ValueAndNameSupport oObject = aLenkungen.get(i);
            if (!oObject.getValue().equals(sLenkung)) continue;
            return i;
        }
        return -1;
    }

    public void storeSelLenkung(int nIndex) {
        if (nIndex == -1) {
            return;
        }
        Vector<ValueAndNameSupport> aLenkungen = this.moFzgIdInfo.getLenkungen();
        ValueAndNameSupport oObject = aLenkungen.get(nIndex);
        this.msSelLenkung = oObject.getValue();
    }

    public void resetSelLenkung() {
        this.msSelLenkung = null;
    }

    public Vector<String> getLenkungenAsStringVector() {
        Vector<String> aLenkungen = new Vector<String>();
        if (this.moFzgIdInfo.getLenkungen().isEmpty()) {
            return aLenkungen;
        }
        for (ValueAndNameSupport oObj : this.moFzgIdInfo.getLenkungen()) {
            String sName = oObj.getName();
            if (oObj.getValue().equals("AlleWerte")) {
                sName = Resource.getInstance().getAlleWerte();
            }
            if (oObj.getValue().equals("kA")) {
                sName = Resource.getInstance().getKeineEinschraenkung();
            }
            aLenkungen.add(sName);
        }
        return aLenkungen;
    }

    public String getSelGetriebe() {
        return this.msSelGetriebe;
    }

    public int getIndexSelGetriebe(String sGetriebe) {
        Vector<ValueAndNameSupport> aGetriebe = this.moFzgIdInfo.getGetriebeC();
        for (int i = 0; i < aGetriebe.size(); ++i) {
            ValueAndNameSupport oObject = aGetriebe.get(i);
            if (!oObject.getValue().equals(sGetriebe)) continue;
            return i;
        }
        return -1;
    }

    public void storeSelGetriebe(int nIndex) {
        Vector<ValueAndNameSupport> aGetriebe = this.moFzgIdInfo.getGetriebeC();
        ValueAndNameSupport oObject = aGetriebe.get(nIndex);
        this.msSelGetriebe = oObject.getValue();
    }

    public void resetSelGetriebe() {
        this.msSelGetriebe = null;
    }

    public Vector<String> getGetriebeAsStringVector() {
        Vector<String> aGetriebe = new Vector<String>();
        if (this.moFzgIdInfo.getGetriebeC().isEmpty()) {
            return aGetriebe;
        }
        for (ValueAndNameSupport oObj : this.moFzgIdInfo.getGetriebeC()) {
            String sName = oObj.getName();
            if (oObj.getValue().equals("AlleWerte")) {
                sName = Resource.getInstance().getAlleWerte();
            }
            if (oObj.getValue().equals("kA")) {
                sName = Resource.getInstance().getKeineEinschraenkung();
            }
            aGetriebe.add(sName);
        }
        return aGetriebe;
    }

    public String getSelBaujahr() {
        return this.msSelBaujahr;
    }

    public int getIndexSelBaujahr(String sBaujahr) {
        Vector<ValueAndNameSupport> aBaujahre = this.moFzgIdInfo.getBaujahre();
        for (int i = 0; i < aBaujahre.size(); ++i) {
            String sValue;
            ValueAndNameSupport oObject = aBaujahre.get(i);
            String string = sValue = oObject instanceof ValueAndNameSupport ? oObject.getValue() : (String)((Object)oObject);
            if (!sValue.equals(sBaujahr)) continue;
            return i;
        }
        return -1;
    }

    public void storeSelBaujahr(int nIndex) {
        Vector<ValueAndNameSupport> aBaujahre = this.moFzgIdInfo.getBaujahre();
        ValueAndNameSupport oObject = aBaujahre.get(nIndex);
        this.msSelBaujahr = oObject instanceof ValueAndNameSupport ? oObject.getValue() : (String)((Object)oObject);
    }

    public void resetSelBaujahr() {
        this.msSelBaujahr = null;
    }

    public Vector<String> getBaujahreAsStringVector() {
        Vector<String> aBaujahre = new Vector<String>();
        if (this.moFzgIdInfo.getBaujahre().isEmpty()) {
            return aBaujahre;
        }
        for (ValueAndNameSupport oObject : this.moFzgIdInfo.getBaujahre()) {
            String sName = null;
            if (oObject instanceof ValueAndNameSupport) {
                ValueAndNameSupport oObj = oObject;
                sName = oObj.getName();
                if (oObj.getValue().equals("AlleWerte")) {
                    sName = Resource.getInstance().getAlleWerte();
                }
                if (oObj.getValue().equals("kA")) {
                    sName = Resource.getInstance().getKeineEinschraenkung();
                }
            } else {
                sName = (String)((Object)oObject);
            }
            aBaujahre.add(sName);
        }
        return aBaujahre;
    }

    public String getSelZulMonat() {
        return this.msSelZulMonat;
    }

    public int getIndexSelZulMonat(String sZulMonat) {
        Vector<ValueAndNameSupport> aZulMonate = this.moFzgIdInfo.getZulMonate();
        for (int i = 0; i < aZulMonate.size(); ++i) {
            ValueAndNameSupport oObject = aZulMonate.get(i);
            if (!oObject.getValue().equals(sZulMonat)) continue;
            return i;
        }
        return -1;
    }

    public void storeSelZulMonat(int nIndex) {
        Vector<ValueAndNameSupport> aZulMonate = this.moFzgIdInfo.getZulMonate();
        ValueAndNameSupport oObject = aZulMonate.get(nIndex);
        this.msSelZulMonat = oObject.getValue();
    }

    public void resetSelZulMonat() {
        this.msSelZulMonat = null;
    }

    public Vector<String> getZulMonateAsStringVector() {
        Vector<String> aZulMonate = new Vector<String>();
        if (this.moFzgIdInfo.getZulMonate().isEmpty()) {
            return aZulMonate;
        }
        for (ValueAndNameSupport oObj : this.moFzgIdInfo.getZulMonate()) {
            String sName = oObj.getName();
            if (oObj.getValue().equals("AlleWerte")) {
                sName = Resource.getInstance().getAlleWerte();
            }
            if (oObj.getValue().equals("kA")) {
                sName = Resource.getInstance().getKeineEinschraenkung();
            }
            aZulMonate.add(sName);
        }
        return aZulMonate;
    }

    public String getDialogModus() {
        return this.msDialogModus;
    }

    public String getSuchSachnummer() {
        return this.msSuchSachnummer;
    }

    public String getFahrgestellnummer() {
        return this.msFahrgestellnummer;
    }

    public String getFahrgestellnummerAuftrag() {
        return this.msFahrgestellnummerAuftrag;
    }

    public int getFahrgestellnummerModus() {
        return this.mnFahrgestellnummerModus;
    }

    public void setFahrgestellnummer(String sFahrgestellnummer, int nModusNeu) {
        int nModusAlt = this.mnFahrgestellnummerModus;
        this.msFahrgestellnummer = sFahrgestellnummer;
        if (nModusNeu == 3) {
            this.msFahrgestellnummerAuftrag = sFahrgestellnummer;
        } else if (nModusAlt == 3 && nModusNeu == 1) {
            nModusNeu = nModusAlt;
        } else {
            this.msFahrgestellnummerAuftrag = null;
            this.msTeilelisteAuftrag = null;
            this.msCodeAF = null;
            this.msCodeLack = null;
        }
        this.mnFahrgestellnummerModus = nModusNeu;
    }

    public boolean isFahrgestellnummerChanged() {
        return !this.msFahrgestellnummerAuftrag.equals(this.msFahrgestellnummer);
    }

    public String getTeilelisteAuftrag() {
        return this.msTeilelisteAuftrag;
    }

    public void setTeilelisteAuftrag(String sTeilelisteAuftrag) {
        this.msTeilelisteAuftrag = sTeilelisteAuftrag;
    }

    public String getMarke() {
        return this.msMarke;
    }

    public void setMarke(String sMarke) {
        this.msMarke = sMarke;
    }

    public String getProduktart() {
        return this.msProduktart;
    }

    public boolean isPKW() {
        return this.getProduktart().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung());
    }

    public void setProduktart(String sProduktart) {
        this.msProduktart = sProduktart;
    }

    public String getKatalogumfang() {
        return this.msKatalogumfang;
    }

    public void setKatalogumfang(String sKatalogumfang) {
        this.msKatalogumfang = sKatalogumfang;
    }

    public boolean isVollstaendigeFI() {
        return this.mbVollstaendigeFI;
    }

    public boolean isUpdate() {
        return this.mbIsUpdate;
    }

    public String getLackCode() {
        return this.msCodeLack;
    }

    public String getAFCode() {
        return this.msCodeAF;
    }

    public JavaFzgIdInfo getFzgIdInfo() {
        return this.moFzgIdInfo;
    }

    public void storeFzgIdInfo(JavaFzgIdInfo oFzgIdInfo) {
        this.moFzgIdInfo = oFzgIdInfo;
    }

    public boolean isNoChangeToProduktartKrad() {
        return this.mbNoChangeToProduktartKrad;
    }

    public boolean showProduktartMeldung() {
        return this.mbShowProduktartMeldung;
    }

    public String getProduktartMeldung() {
        return this.msProduktartMeldung;
    }

    public String getKundennummer() {
        return this.msKundennummer;
    }

    public void setKundennummer(String sKundennummer) {
        this.msKundennummer = sKundennummer;
    }

    public String getKundenname() {
        return this.msKundenname;
    }

    public void setKundenname(String sKundenname) {
        this.msKundenname = sKundenname;
    }

    public String getAuftragsnummer() {
        return this.msAuftragsnummer;
    }

    public void setAuftragsnummer(String sAuftragsnummer) {
        this.msAuftragsnummer = sAuftragsnummer;
    }

    public void einlesenKeyReaderDatei() {
        try {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            StringBuffer codeLack = new StringBuffer();
            StringBuffer codeAF = new StringBuffer();
            this.msFahrgestellnummer = GlobalObjects.getInstance().retrieveVinFromKeyReader(codeLack, codeAF);
            this.msCodeLack = codeLack.toString();
            this.msCodeAF = codeAF.toString();
            log.debug((Object)("VIN " + this.msFahrgestellnummer + "Code Lack " + this.msCodeLack + "Code AF " + this.msCodeAF));
            this.mnFahrgestellnummerModus = 2;
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (GkiZugriffException ex) {
            log.error((Object)("Der Zugriff auf den Keyreader ist fehlgeschlagen. " + ex.getMessage()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getGetFahrgestellnummerKeyreaderFailed() + "\r\n" + ex.getMessage(), Resource.getInstance().getFahrzeugidentifikation(), 0);
            this.msFahrgestellnummer = null;
            this.mnFahrgestellnummerModus = 0;
        }
    }

    public void einlesenDatei() {
        String sFilename = GlobalObjects.getInstance().getEtkData().getEpcFile();
        try {
            String sSachnummer;
            FileReader filereader = new FileReader(sFilename);
            char[] cBuffH = new char[324];
            filereader.read(cBuffH);
            String sHeaderDatenRead = new String(cBuffH);
            this.msFahrgestellnummer = sHeaderDatenRead.substring(192, 199).trim();
            if (this.msFahrgestellnummer == null || this.msFahrgestellnummer.trim().equals("")) {
                this.msFahrgestellnummer = null;
                this.mnFahrgestellnummerModus = 0;
                filereader.close();
                return;
            }
            char[] cBuffT = new char[248];
            filereader.read(cBuffT);
            String sTeileDatenRead = new String(cBuffT);
            if (sTeileDatenRead != null && (sSachnummer = sTeileDatenRead.substring(4, 11).trim()).length() >= 3) {
                this.msSuchSachnummer = sSachnummer;
            }
            filereader.close();
        }
        catch (Exception ex) {
            this.msFahrgestellnummer = null;
            this.mnFahrgestellnummerModus = 0;
        }
    }

    public void setZusatzInfo(ZusatzInfo oZusatzInfo) {
        this.moZusatzInfo = oZusatzInfo;
    }

    public ZusatzInfo getZusatzInfo() {
        return this.moZusatzInfo;
    }
}

