/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.fzgid;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import webetk.app.fzgid.BedZusatzInfo;
import webetk.app.fzgid.ZusatzInfoMarke;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.fzgid.DlgZusatzInfoController;
import webetk.javaclient.dialog.fzgid.DlgZusatzInfoModel;
import webetk.resources.Resource;

public class DlgZusatzInfoView
extends AbstractDialogView {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(DlgZusatzInfoView.class);
    private DlgZusatzInfoController controller = null;
    private DlgZusatzInfoModel model = null;
    private JPanel mPanHeader = null;
    private JTextArea mTaInfoTexte = null;
    private JButtonEx mButtonWeiter = null;

    @Override
    public void initMenus() {
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        String sFzgIdString = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo().getFzgIdString();
        this.mPanHeader = new HeaderPanel(Resource.getInstance().getHinweis(), sFzgIdString, ImageCache.getInstance().getHeaderIcon("fi"));
        this.mButtonWeiter = new JButtonEx(null, ImageCache.getInstance().getIcon("arrw04_10b.gif"));
        this.mButtonWeiter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgZusatzInfoView.this.controller.notifyAllExitListeners();
            }
        });
        this.createLayout();
    }

    private void createLayout() {
        JPanel panel = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(2, 1);
        HIGConstraints c = new HIGConstraints();
        panel.setLayout(l);
        panel.add((Component)this.mPanHeader, c.rc(1, 1, "tlbr"));
        panel.add((Component)this.createCenterPanel(), c.rc(2, 1, "tlbr"));
        panel.add((Component)this.createButtonPanel(), c.rc(3, 1, "tbr"));
        JScrollPane sc = new JScrollPane(panel);
        this.setLayout(new BorderLayout());
        this.add(sc);
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        int[] w = new int[]{10, 0, 10};
        int[] h = new int[]{10, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(2, 1);
        l.setRowWeight(2, 1);
        HIGConstraints c = new HIGConstraints();
        panel.setLayout(l);
        panel.add((Component)this.createZusatzinfoPanel(), c.rc(2, 2, "tlrb"));
        return panel;
    }

    private JPanel createZusatzinfoPanel() {
        TitledPanel panel = new TitledPanel(Resource.getInstance().getHinweis());
        int[] w = new int[]{10, 0, 10};
        int[] h = new int[]{10, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(2, 1);
        l.setRowWeight(2, 1);
        HIGConstraints c = new HIGConstraints();
        panel.setLayout(l);
        this.mTaInfoTexte = new JTextArea();
        this.mTaInfoTexte.setBackground(this.getBackground());
        this.mTaInfoTexte.setEditable(false);
        this.mTaInfoTexte.setLineWrap(true);
        this.mTaInfoTexte.setWrapStyleWord(true);
        this.mTaInfoTexte.setForeground(Color.black);
        this.mTaInfoTexte.setEnabled(false);
        this.mTaInfoTexte.setDisabledTextColor(Color.black);
        JScrollPane scInfoTexte = new JScrollPane(this.mTaInfoTexte);
        scInfoTexte.setBorder(null);
        panel.add((Component)scInfoTexte, c.rc(2, 2, "tlrb"));
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        int[] w = new int[]{10, 0, 10};
        int[] h = new int[]{10, 0, 10};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        panel.setLayout(l);
        panel.add((Component)this.mButtonWeiter, c.rc(2, 2, "trb"));
        return panel;
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        log.debug((Object)"init");
        this.model = (DlgZusatzInfoModel)oDlgModel;
        this.controller = (DlgZusatzInfoController)oDlgController;
        this.initComponents();
        this.update();
    }

    @Override
    public void update() {
        String sInfoTexte = "";
        if (this.model.getZusatzInfo() instanceof BedZusatzInfo) {
            sInfoTexte = this.updateBedZusatzInfo((BedZusatzInfo)this.model.getZusatzInfo());
        } else if (this.model.getZusatzInfo() instanceof ZusatzInfoMarke) {
            sInfoTexte = this.updateZusatzInfoMarke((ZusatzInfoMarke)this.model.getZusatzInfo());
        }
        this.mTaInfoTexte.setText(sInfoTexte);
    }

    private String updateBedZusatzInfo(BedZusatzInfo oBedZusatzInfo) {
        String sInfoTexte = "";
        Collection<Vector<String>> cKommentare = oBedZusatzInfo.getKommentare();
        Iterator<Vector<String>> iter = cKommentare.iterator();
        while (iter.hasNext()) {
            if (sInfoTexte.length() > 0) {
                sInfoTexte = sInfoTexte + "\n";
            }
            Collection cZeilen = iter.next();
            Iterator iterZeilen = cZeilen.iterator();
            while (iterZeilen.hasNext()) {
                sInfoTexte = sInfoTexte + (String)iterZeilen.next() + "\n";
            }
        }
        return sInfoTexte;
    }

    private String updateZusatzInfoMarke(ZusatzInfoMarke oZusatzInfoMarke) {
        String sInfoTexte = "";
        Collection<String> cKommentare = oZusatzInfoMarke.getZusatzInfo(false);
        for (String sKommentar : cKommentare) {
            sInfoTexte = sInfoTexte + sKommentar;
        }
        return sInfoTexte;
    }
}

