/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.grafischeteilesuche.suchehg;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import webetk.app.FGs;
import webetk.app.FunktionsgruppeTO;
import webetk.app.HauptgruppeTO;
import webetk.app.Markt;
import webetk.app.SearchBTETeile;
import webetk.app.StringKomparator;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.communication.JavaSucheInfo;
import webetk.communication.LoginInfo;
import webetk.javaclient.MarktDaten;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class GrafischeSucheBTModel
extends AbstractDialogModel {
    private String msDialogModus = "";
    private String msDialogTitel = "";
    private Collection<SearchBTETeile.PartOrBTE> moBildtafelCache = null;
    private Collection<SearchBTETeile.PartOrBTE> moBildtafeln = null;
    private Collection<SearchBTETeile.PartOrBTE> moBildtafelnBlaettern = null;
    private String msMarke = null;
    private String msExitAction = null;
    private String msSelBtNummer = null;
    private String msSelBtNummerInit = null;
    private int mnIndexHGNext = -1;
    private int mnIndexHGPrev = -1;
    private int mnIndexHGtoSearch = -1;
    private int mnIndexFGNext = -1;
    private int mnIndexFGPrev = -1;
    private int mnIndexFGtoSearch = -1;
    private String msSuchkriterienString = null;
    private String msSuchkriterienStringCompl = null;
    private boolean bBedFilter;
    private boolean bAbBandVerbaut;
    private MarktDaten mMarktDaten = null;
    private List<HauptgruppeTO> hgfgList;
    private FGs fGs;

    @Override
    public void init(WorkflowStateData oWFStateData) {
        super.init(oWFStateData);
        this.hgfgList = (List)oWFStateData.getWert("HGFG_BENENNUNG");
        this.fGs = (FGs)oWFStateData.getWert("FG_OBJECT");
        this.msDialogModus = (String)oWFStateData.getWert("modus");
        if (this.msDialogModus.equals("Fahrzeugteile")) {
            this.msDialogTitel = Resource.getInstance().getSuchergebnisseFahrzeugteile();
            this.msMarke = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo().getMarke();
        }
        if (this.msDialogModus.equals("Accessoires")) {
            this.msDialogTitel = Resource.getInstance().getSuchergebnisseZubehoerAccessoires();
            this.msMarke = GlobalObjects.getInstance().getEtkData().getAssSucheInfo().getMarke();
        }
        CurrentBTE oCurrentBteSel = (CurrentBTE)oWFStateData.getWert("bildtafel_sel");
        this.msSelBtNummerInit = "";
        if (oCurrentBteSel != null) {
            this.msSelBtNummerInit = oCurrentBteSel.getBTENr();
        }
        this.moBildtafeln = (List)oWFStateData.getWert("daten");
        this.moBildtafelCache = null;
        this.moBildtafelnBlaettern = null;
        String sIndexHGNext = (String)oWFStateData.getWert("index_next_hg");
        this.mnIndexHGNext = sIndexHGNext == null ? -1 : Integer.parseInt(sIndexHGNext);
        String sIndexHGPrev = (String)oWFStateData.getWert("index_prev_hg");
        this.mnIndexHGPrev = sIndexHGPrev == null ? -1 : Integer.parseInt(sIndexHGPrev);
        String sIndexFGNext = (String)oWFStateData.getWert("index_next_fg");
        this.mnIndexFGNext = sIndexFGNext == null ? -1 : Integer.parseInt(sIndexFGNext);
        String sIndexFGPrev = (String)oWFStateData.getWert("index_prev_fg");
        this.mnIndexFGPrev = sIndexFGPrev == null ? -1 : Integer.parseInt(sIndexFGPrev);
        String sBedFilter = (String)oWFStateData.getWert("bed_filter");
        this.setBedFilter(sBedFilter != null && sBedFilter.equals("true"));
        this.mMarktDaten = new MarktDaten();
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        this.mMarktDaten.setSelPrimaerMarkt(oLoginInfo.getSettings().getEtkPrimaerMarkt());
        this.mMarktDaten.setSelSonstigeMaerkte(oLoginInfo.getSettings().getEtkSonstigeMaerkte());
        this.mMarktDaten.loadMaerkteandFillListen();
        this.bAbBandVerbaut = !oLoginInfo.getNachruestungenRelevant();
        String filter = (String)oWFStateData.getWert("filter");
        if (this.bAbBandVerbaut) {
            if (filter != null && filter.equals("true")) {
                this.bBedFilter = true;
            } else if (filter != null && filter.equals("false")) {
                this.bBedFilter = false;
            }
        }
    }

    public String getDialogModus() {
        return this.msDialogModus;
    }

    public void setDialogModus(String sDialogModus) {
        this.msDialogModus = sDialogModus;
    }

    public String getDialogTitel() {
        return this.msDialogTitel;
    }

    public void setDialogTitel(String sDialogTitel) {
        this.msDialogTitel = sDialogTitel;
    }

    public String getMarke() {
        return this.msMarke;
    }

    public void setMarke(String sMarke) {
        this.msMarke = sMarke;
    }

    public Collection<SearchBTETeile.PartOrBTE> getBildtafeln() {
        return this.moBildtafeln;
    }

    public void setBildtafeln(Collection<SearchBTETeile.PartOrBTE> oBildtafeln) {
        this.moBildtafeln = oBildtafeln;
    }

    public Collection<SearchBTETeile.PartOrBTE> getBildtafelCache() {
        return this.moBildtafelCache;
    }

    public void setBildtafelCache(Collection<SearchBTETeile.PartOrBTE> oBildtafelCache) {
        this.moBildtafelCache = oBildtafelCache;
    }

    public void setBildTafelnBlaettern(Collection<SearchBTETeile.PartOrBTE> oBildatfeln) {
        this.moBildtafelnBlaettern = oBildatfeln;
    }

    public Collection<SearchBTETeile.PartOrBTE> getBildtafelnBlaettern() {
        return this.moBildtafelnBlaettern;
    }

    public Vector<SearchBTETeile.PartOrBTE> getBildtafelnSortiertNachMarkt() {
        String isoPrimaerMarkt = null;
        Markt selPrioMarkt = this.getMarktDaten().getSelPrimaerMarkt();
        if (selPrioMarkt != null) {
            isoPrimaerMarkt = selPrioMarkt.getKuerzel();
        }
        Vector<SearchBTETeile.PartOrBTE> bildTafelnPrimaerMarkt = new Vector<SearchBTETeile.PartOrBTE>();
        Vector<SearchBTETeile.PartOrBTE> bildTafelnNoMarkt = new Vector<SearchBTETeile.PartOrBTE>();
        Vector<SearchBTETeile.PartOrBTE> bildTafelnWeitererMarkt = new Vector<SearchBTETeile.PartOrBTE>();
        if (this.moBildtafeln != null) {
            for (SearchBTETeile.PartOrBTE bte : this.moBildtafeln) {
                if (bte.getMarktIso() == null || bte.getMarktIso().length() == 0) {
                    bildTafelnNoMarkt.add(bte);
                    continue;
                }
                if ((isoPrimaerMarkt == null || isoPrimaerMarkt.length() < 1) && this.getMarktDaten().getIndicesSelSonstigeMaerkte().length == 0) {
                    bildTafelnWeitererMarkt.add(bte);
                    continue;
                }
                if (bte.getMarktIso().equals(isoPrimaerMarkt)) {
                    bildTafelnPrimaerMarkt.add(bte);
                    continue;
                }
                if (!this.getMarktDaten().containSelSonstigeMaerkteMarktIso(bte.getMarktIso())) continue;
                bildTafelnWeitererMarkt.add(bte);
            }
        }
        bildTafelnPrimaerMarkt.addAll(bildTafelnNoMarkt);
        bildTafelnPrimaerMarkt.addAll(bildTafelnWeitererMarkt);
        return bildTafelnPrimaerMarkt;
    }

    public boolean habenBildtafelnLokaleMaerkte() {
        Collection<SearchBTETeile.PartOrBTE> lcBildtafeln = null;
        lcBildtafeln = this.getBildtafelCache() == null || this.getBildtafelCache().isEmpty() ? this.moBildtafeln : this.getBildtafelCache();
        if (lcBildtafeln != null) {
            for (SearchBTETeile.PartOrBTE bte : lcBildtafeln) {
                if (bte.getMarktIso() == null || bte.getMarktIso().length() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean habenBildtafelnNachruestungsRelevanteBedingungen() {
        if (this.getAnzBildtafeln() > 0) {
            for (SearchBTETeile.PartOrBTE oBte : this.moBildtafeln) {
                if (!oBte.isBTE() || oBte.isBteBedingungRelevant3() || !oBte.hatNachruestenRelevantBTEBedingung3()) continue;
                return true;
            }
        }
        return false;
    }

    public String getExitAction() {
        return this.msExitAction;
    }

    public void setExitAction(String sExitAction) {
        this.msExitAction = sExitAction;
    }

    public String getSelBtNummer() {
        return this.msSelBtNummer;
    }

    public String getSelBtNummerInit() {
        return this.msSelBtNummerInit;
    }

    public void setSelBtNummer(String sSelBtNummer) {
        this.msSelBtNummer = sSelBtNummer;
    }

    public int getAnzBildtafeln() {
        if (this.moBildtafeln == null) {
            return 0;
        }
        return this.moBildtafeln.size();
    }

    public Collection<String> getBildtafelNummern() {
        Vector<String> cBildtafeln = new Vector<String>();
        if (this.moBildtafelnBlaettern == null) {
            return cBildtafeln;
        }
        for (SearchBTETeile.PartOrBTE bte : this.moBildtafelnBlaettern) {
            String sBtNummer = bte.getIdNummer();
            cBildtafeln.add(sBtNummer);
        }
        return cBildtafeln;
    }

    public int getIndexHGNext() {
        return this.mnIndexHGNext;
    }

    public int getIndexHGPrev() {
        return this.mnIndexHGPrev;
    }

    public void setIndexHGtoSearch(int nIndexHGtoSearch) {
        this.mnIndexHGtoSearch = nIndexHGtoSearch;
    }

    public int getIndexHGtoSearch() {
        return this.mnIndexHGtoSearch;
    }

    public int getIndexFGNext() {
        return this.mnIndexFGNext;
    }

    public int getIndexFGPrev() {
        return this.mnIndexFGPrev;
    }

    public void setIndexFGtoSearch(int nIndexFGtoSearch) {
        this.mnIndexFGtoSearch = nIndexFGtoSearch;
    }

    public int getIndexFGtoSearch() {
        return this.mnIndexFGtoSearch;
    }

    public boolean isBedFilter() {
        return this.bBedFilter;
    }

    public void setBedFilter(boolean filter) {
        this.bBedFilter = filter;
    }

    public boolean isAbBandVerbaut() {
        return this.bAbBandVerbaut;
    }

    public void setAbBandVerbaut(boolean bAbBandVerbaut) {
        this.bAbBandVerbaut = bAbBandVerbaut;
    }

    public String getSuchkriterienString(JavaSucheInfo oSucheInfo, boolean bComplete) {
        if (this.msSuchkriterienStringCompl == null) {
            this.evalSuchkriterienString(oSucheInfo);
        }
        if (bComplete) {
            return this.msSuchkriterienStringCompl;
        }
        return this.msSuchkriterienString != null ? this.msSuchkriterienString : this.msSuchkriterienStringCompl;
    }

    public boolean isSuchkriterienStringTootipNoetig(JavaSucheInfo oSucheInfo) {
        if (this.msSuchkriterienStringCompl == null) {
            this.evalSuchkriterienString(oSucheInfo);
        }
        return this.msSuchkriterienString != null;
    }

    public void evalSuchkriterienString(JavaSucheInfo oSucheInfo) {
        if (oSucheInfo == null) {
            this.msSuchkriterienStringCompl = "";
            return;
        }
        this.msSuchkriterienStringCompl = Resource.getInstance().getSuchkriterium() + ": ";
        String sSuchHG = oSucheInfo.getSuchHG();
        String sSuchFG = oSucheInfo.getSuchFG();
        if (sSuchHG != null && sSuchFG == null) {
            this.msSuchkriterienStringCompl = this.msSuchkriterienStringCompl + sSuchHG + this.getHgFgAnzeige(sSuchHG);
            return;
        }
        if (sSuchHG != null && sSuchFG != null) {
            this.msSuchkriterienStringCompl = this.msSuchkriterienStringCompl + sSuchHG + sSuchFG + this.getHgFgAnzeige(sSuchHG + sSuchFG);
            return;
        }
        String sSuchSachnummer = oSucheInfo.getSuchSachnummer();
        if (sSuchSachnummer != null) {
            this.msSuchkriterienStringCompl = this.msSuchkriterienStringCompl + sSuchSachnummer;
            return;
        }
        String sSuchBenennung = oSucheInfo.getSuchBenennung();
        if (sSuchBenennung != null) {
            this.msSuchkriterienStringCompl = this.msSuchkriterienStringCompl + sSuchBenennung;
            return;
        }
        String sSuchSuchbegriff = oSucheInfo.getSuchSuchbegriff();
        if (sSuchSuchbegriff != null) {
            this.msSuchkriterienStringCompl = this.msSuchkriterienStringCompl + sSuchSuchbegriff;
            return;
        }
        String sSuchFremdeSachnummer = oSucheInfo.getSuchFremdeSachnummer();
        if (sSuchFremdeSachnummer != null) {
            return;
        }
        String[] aHgFg = oSucheInfo.getSuchHgFgs();
        if (aHgFg != null) {
            TreeSet<String> oSortedHgFgs = new TreeSet<String>(new StringKomparator());
            Vector<String> cHelp = new Vector<String>();
            for (int i = 0; i < aHgFg.length; ++i) {
                cHelp.add(aHgFg[i]);
            }
            oSortedHgFgs.addAll(cHelp);
            int nIndex = 0;
            for (String sHgFg : oSortedHgFgs) {
                if (nIndex == 0) {
                    this.msSuchkriterienStringCompl = oSortedHgFgs.size() == 1 ? this.msSuchkriterienStringCompl + sHgFg + this.getHgFgAnzeige(sHgFg) : this.msSuchkriterienStringCompl + sHgFg + this.getHgFgAnzeige(sHgFg);
                } else {
                    if (this.getDialogModus() == "Fahrzeugteile" && nIndex == 9) {
                        this.msSuchkriterienString = this.msSuchkriterienStringCompl;
                        this.msSuchkriterienString = this.msSuchkriterienString + " >>";
                    }
                    this.msSuchkriterienStringCompl = this.msSuchkriterienStringCompl + ", " + sHgFg + this.getHgFgAnzeige(sHgFg);
                }
                ++nIndex;
            }
        }
    }

    public String getHgFgAnzeige(String sHgFg) {
        if (this.hgfgList != null) {
            for (HauptgruppeTO hauptgruppeTO : this.hgfgList) {
                if (sHgFg.length() == 2) {
                    if (!hauptgruppeTO.getHG().equals(sHgFg)) continue;
                    return " " + hauptgruppeTO.getBenennung();
                }
                String fghgbenennung = "";
                if (!hauptgruppeTO.getHG().equals(sHgFg.substring(0, 2))) continue;
                fghgbenennung = fghgbenennung + " " + hauptgruppeTO.getBenennung();
                if (hauptgruppeTO.getFunktionsgruppen().isEmpty()) {
                    if (this.fGs != null) {
                        return " " + this.fGs.getFGBen().get(this.fGs.getFGs().indexOf(sHgFg.substring(2, 4)));
                    }
                    return "";
                }
                for (FunktionsgruppeTO funktionsgruppeTO : hauptgruppeTO.getFunktionsgruppen()) {
                    if (!funktionsgruppeTO.getFg().equals(sHgFg.substring(2, 4))) continue;
                    fghgbenennung = fghgbenennung + " " + funktionsgruppeTO.getBenennung();
                }
                return fghgbenennung;
            }
        }
        return "";
    }

    public MarktDaten getMarktDaten() {
        return this.mMarktDaten;
    }

    public List<HauptgruppeTO> getHgfgList() {
        return this.hgfgList;
    }

    public void setHgfgList(List<HauptgruppeTO> hgfgList) {
        this.hgfgList = hgfgList;
    }

    public FGs getFGs() {
        return this.fGs;
    }

    public void setFGs(FGs fGs) {
        this.fGs = fGs;
    }
}

