/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.grafischeteilesuche.suchehg;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import webetk.app.FGs;
import webetk.app.FunktionsgruppeTO;
import webetk.app.HauptgruppeTO;
import webetk.communication.JavaSucheInfo;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class GrafischeSucheFGModel
extends AbstractDialogModel {
    private String msDialogModus = "";
    private String msDialogTitel = "";
    private TrfHashMap moAnzeigedaten = null;
    private String msMarke = null;
    private String msProduktart = null;
    private String msKatalogumfang = null;
    private String msHg = null;
    private String msFg = null;
    private Collection<String> mcHGs;
    private String msSuchkriterienStringCompl = null;
    private boolean mbAusweisungenElementeErmitteln = false;
    private List<HauptgruppeTO> hgfgList;
    private FGs fGs;

    @Override
    public void init(WorkflowStateData oWFStateData) {
        super.init(oWFStateData);
        this.hgfgList = (List)oWFStateData.getWert("HGFG_BENENNUNG");
        this.fGs = (FGs)oWFStateData.getWert("FG_OBJECT");
        this.mcHGs = (Collection)oWFStateData.getWert("hgfg");
        this.msDialogModus = (String)oWFStateData.getWert("modus");
        if (this.msDialogModus.equals("Fahrzeugteile")) {
            this.msDialogTitel = Resource.getInstance().getTeilesucheFahrzeugteile();
            this.msMarke = GlobalObjects.getInstance().getFzgIdInfo().getMarke();
            this.msHg = (String)oWFStateData.getWert("hg");
        }
        if (this.msDialogModus.equals("Accessoires")) {
            this.msDialogTitel = Resource.getInstance().getTeilesucheZubehoerAccessoires();
            this.msMarke = (String)oWFStateData.getWert("marke");
            this.msProduktart = (String)oWFStateData.getWert("produktart");
            this.msKatalogumfang = (String)oWFStateData.getWert("katalogumfang");
            this.msHg = (String)oWFStateData.getWert("hg");
        }
    }

    public String getSuchkriterienString(JavaSucheInfo oSucheInfo, boolean bComplete) {
        if (this.msSuchkriterienStringCompl == null) {
            this.evalSuchkriterienString(oSucheInfo);
        }
        if (bComplete) {
            return this.msSuchkriterienStringCompl;
        }
        return this.msSuchkriterienStringCompl;
    }

    public void evalSuchkriterienString(JavaSucheInfo oSucheInfo) {
        this.msSuchkriterienStringCompl = Resource.getInstance().getSuchkriterium() + ": " + this.msHg + this.getHgFgAnzeige(this.msHg);
    }

    public String getDialogModus() {
        return this.msDialogModus;
    }

    public void setDialogModus(String sDialogModus) {
        this.msDialogModus = sDialogModus;
    }

    public String getDialogTitel() {
        return this.msDialogTitel;
    }

    public void setDialogTitel(String sDialogTitel) {
        this.msDialogTitel = sDialogTitel;
    }

    public String getMarke() {
        return this.msMarke;
    }

    public void setMarke(String sMarke) {
        this.msMarke = sMarke;
    }

    public String getProduktart() {
        return this.msProduktart;
    }

    public void setProduktart(String sProduktart) {
        this.msProduktart = sProduktart;
    }

    public String getKatalogumfang() {
        return this.msKatalogumfang;
    }

    public void setKatalogumfang(String sKatalogumfang) {
        this.msKatalogumfang = sKatalogumfang;
    }

    public String getHg() {
        return this.msHg;
    }

    public void setHg(String sHg) {
        this.msHg = sHg;
    }

    public void resetAnzeigedaten() {
        this.moAnzeigedaten = null;
    }

    public TrfHashMap getAnzeigedaten() {
        return this.moAnzeigedaten;
    }

    public void storeAnzeigedaten(TrfHashMap oTrfAnzeigedaten) {
        this.moAnzeigedaten = oTrfAnzeigedaten;
    }

    public Collection<String> getHGs() {
        Vector<String> cHGs = new Vector<String>();
        for (String hg : this.mcHGs) {
            if (hg.contains(this.msHg)) {
                cHGs.add(this.msHg + this.msFg);
                continue;
            }
            cHGs.add(hg);
        }
        return cHGs;
    }

    public String getFg() {
        return this.msFg;
    }

    public void setFg(String msFg) {
        this.msFg = msFg;
    }

    public Collection<String> getFGs() {
        Vector<String> cFGs = new Vector<String>();
        TrfHashMap oGrafiken = this.getAnzeigedaten();
        int i = 0;
        while (true) {
            String sFg = (String)oGrafiken.getValue(i + "fg");
            String sBenennung = (String)oGrafiken.getValue(i + "benennung");
            if (sBenennung == null) break;
            cFGs.add(sFg);
            ++i;
        }
        return cFGs;
    }

    public void setAusweisungenElementeErmitteln(boolean mbAusweisungenElementeErmitteln) {
        this.mbAusweisungenElementeErmitteln = mbAusweisungenElementeErmitteln;
    }

    public boolean isAusweisungenElementeErmitteln() {
        return this.mbAusweisungenElementeErmitteln;
    }

    public String getHgFgAnzeige(String sHgFg) {
        if (this.hgfgList != null) {
            for (HauptgruppeTO hauptgruppeTO : this.hgfgList) {
                if (sHgFg.length() == 2) {
                    if (!hauptgruppeTO.getHG().equals(sHgFg)) continue;
                    return " " + hauptgruppeTO.getBenennung();
                }
                String fghgbenennung = "";
                if (!hauptgruppeTO.getHG().equals(sHgFg.substring(0, 2))) continue;
                fghgbenennung = fghgbenennung + " " + hauptgruppeTO.getBenennung();
                if (hauptgruppeTO.getFunktionsgruppen().isEmpty()) {
                    if (this.fGs != null) {
                        return this.fGs.getFGBen().get(this.fGs.getFGs().indexOf(sHgFg.substring(2, 4)));
                    }
                    return "";
                }
                for (FunktionsgruppeTO funktionsgruppeTO : hauptgruppeTO.getFunktionsgruppen()) {
                    if (!funktionsgruppeTO.getFg().equals(sHgFg.substring(2, 4))) continue;
                    fghgbenennung = fghgbenennung + " " + funktionsgruppeTO.getBenennung();
                }
                return fghgbenennung;
            }
        }
        return "";
    }

    public List<HauptgruppeTO> getHgfgList() {
        return this.hgfgList;
    }

    public void setHgfgList(List<HauptgruppeTO> hgfgList) {
        this.hgfgList = hgfgList;
    }

    public FGs getFGsObject() {
        return this.fGs;
    }

    public void setFGsObject(FGs fGs) {
        this.fGs = fGs;
    }
}

