/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.grafischeteilesuche.suchehg;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.app.FGs;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.grafischeteilesuche.suchehg.GrafischeSucheHGModel;
import webetk.javaclient.dialog.grafischeteilesuche.suchehg.GrafischeSucheHGView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class GrafischeSucheHGController
extends AbstractDialogViewController {
    Logger log = Logger.getLogger(GrafischeSucheHGController.class);
    GrafischeSucheHGView view = new GrafischeSucheHGView();
    GrafischeSucheHGModel model = new GrafischeSucheHGModel();
    boolean noFG = true;

    @Override
    public DialogView getDialogView() {
        this.log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        this.log.debug((Object)"init");
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        WorkflowStateData exitData = new WorkflowStateData();
        if (this.noFG) {
            exitData.setWert("exitaction", "anzbildtafeln_graf");
            exitData.setWert("fgsuche", "false");
        } else {
            exitData.setWert("exitaction", "anzfg_graf");
        }
        exitData.setWert("marke", this.model.getMarke());
        exitData.setWert("produktart", this.model.getProduktart());
        exitData.setWert("katalogumfang", this.model.getKatalogumfang());
        exitData.setWert("hg", this.model.getHg());
        exitData.setWert("hgfg", this.model.getHGs());
        exitData.setWert("HGFG_BENENNUNG", this.model.getAnzeigedaten());
        exitData.setWert("FG_OBJECT", this.model.getFGs());
        return exitData;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    protected void ladeHauptgruppenGrafiken() {
        this.log.debug((Object)"Performing Teilesuche Acc Grafisch: Hauptgruppen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfHgGrafiken = new TrfHashMap(null);
        String sIsFahrzeug = this.model.getDialogModus().equals("Fahrzeugteile") ? "true" : "false";
        trfHgGrafiken.setValue("isfzg", sIsFahrzeug);
        trfHgGrafiken.setValue("marke", this.model.getMarke());
        trfHgGrafiken.setValue("produktart", this.model.getProduktart());
        trfHgGrafiken.setValue("katalogumfang", this.model.getKatalogumfang());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHgGrafiken, Command.LOAD_TEILESUCHE_GRAF_HG);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("GrafischeSucheHGController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfHgGrafiken.getError() != null) {
            if (trfHgGrafiken.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"keine Hauptgruppen gefunden!", (Throwable)trfHgGrafiken.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), this.model.getDialogTitel(), 0);
                this.model.storeAnzeigedaten(null);
                return;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfHgGrafiken.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfHgGrafiken.getError().getMessage(), this.model.getDialogTitel(), 0);
            this.model.storeAnzeigedaten(null);
            return;
        }
        this.model.storeAnzeigedaten((List)trfHgGrafiken.getValue("hgfgs"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean checkSucheResult() {
        this.log.debug((Object)"Performing Check Suche");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfSuche = new TrfHashMap(null);
        if (this.model.getDialogModus().equals("Fahrzeugteile")) {
            trfSuche.setValue("isfzg", "true");
        } else {
            trfSuche.setValue("marke", this.model.getMarke());
            trfSuche.setValue("produktart", this.model.getProduktart());
            trfSuche.setValue("katalogumfang", this.model.getKatalogumfang());
            trfSuche.setValue("isfzg", "false");
        }
        Vector<String> aHgFg = new Vector<String>();
        aHgFg.add(this.model.getHg());
        trfSuche.setValue("hgfg", aHgFg);
        trfSuche.setValue("hg", this.model.getHg());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfSuche, Command.LOAD_TEILESUCHE_GRAF_FG);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgFzgUmfangController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        FGs fGs = (FGs)trfSuche.getValue("FGOBJECT");
        if (fGs != null) {
            this.model.setFGs(fGs);
            for (int i = 0; i < fGs.getFGs().size(); ++i) {
                trfSuche.setValue(i + "fg", fGs.getFGs().get(i));
                trfSuche.setValue(i + "benennung", fGs.getFGBen().get(i));
                trfSuche.setValue(i + "bild", fGs.getFGGraf().get(i));
            }
        }
        this.noFG = !this.model.getDialogModus().equals("Fahrzeugteile") && this.model.getMarke().equals("BMW") && this.model.getProduktart().equals("M") && this.model.getHg().equals("76") ? false : trfSuche.getValue("0bild") == null;
        return true;
    }
}

