/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.hilfe.polstercode;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.EnhancedTextDocument;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.app.polstercode.neu.PolsterCodeAusstattungFarbeZeile;
import webetk.app.polstercode.neu.PolsterCodeAusstattungZeile;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.resources.Resource;

public class PolsterCode {
    private static PolsterCode instance;
    private static Logger log;
    private List<PolsterCodeAusstattungZeile> mPolsterCodeAusstattungZeilen = null;
    private Map<String, PolsterCodeAusstattungZeile> mPolsterCodeAusstattungZeilenMap;
    private JDialog dlg = new JDialog((Frame)MainView.getInstance(), false);
    private GenericTableModel tableModel;
    private GenericTable table;
    private JLabel labHinweis;
    private JLabel labHinweis2;
    private JLabel labCombo;
    private JLabel labOder;
    private JLabel labPolstercode;
    private JButtonEx buttonSuchen;
    protected JPanel panHeader;
    private Container panContent;
    private JComboBox combo;
    private boolean suppressComboActionListener = false;
    private JTextField tfPolstercode;

    private PolsterCode() {
        this.dlg.setTitle(Resource.getInstance().getPolstercodeUmschluesselung());
        this.dlg.setSize(850, 400);
        this.dlg.setLocation(100, 100);
        this.initComponents();
        this.mPolsterCodeAusstattungZeilen = this.loadPolstercode();
        this.initAustattungsMap();
        this.fillComboAusstattung();
        this.tfPolstercode.requestFocus();
    }

    private void initAustattungsMap() {
        this.mPolsterCodeAusstattungZeilenMap = new HashMap<String, PolsterCodeAusstattungZeile>(this.mPolsterCodeAusstattungZeilen.size());
        for (PolsterCodeAusstattungZeile zeile : this.mPolsterCodeAusstattungZeilen) {
            this.mPolsterCodeAusstattungZeilenMap.put(zeile.getCode(), zeile);
        }
    }

    public void initComponents() {
        this.panHeader = new HeaderPanel(Resource.getInstance().getPolstercodeUmschluesselung(), null);
        this.labHinweis = new JLabel(Resource.getInstance().getHinweis() + ":");
        this.labHinweis.setFont(UIHelper.getBoldFont());
        this.labHinweis2 = new JLabel(Resource.getInstance().getPolstercodeRelevanz());
        this.labHinweis2.setFont(UIHelper.getBoldFont());
        this.buttonSuchen = new JButtonEx(Resource.getInstance().getSuchen(), ImageCache.getInstance().getIcon("search.gif"));
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn(Resource.getInstance().getPolstercode(), 2, false, "0406");
        tableConfig.addColumn(Resource.getInstance().getBenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableConfig.addColumn(Resource.getInstance().getAfCode(), 2, false, "B9EG");
        tableConfig.addColumn(Resource.getInstance().getGueltig(), 2, false, "ab 10.01.2003 bis 09.01.2001xxx");
        this.tableModel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tableModel);
        this.table.getTable().getSelectionModel().setSelectionMode(2);
        this.table.getTable().setColumnSelectionAllowed(false);
        this.table.getTable().setRowSelectionAllowed(true);
        this.labCombo = new JLabel(Resource.getInstance().getAusstattungWaehlen() + ":");
        this.combo = new JComboBox();
        this.labOder = new JLabel(Resource.getInstance().getOder());
        this.labOder.setFont(UIHelper.getBoldFont());
        this.labPolstercode = new JLabel(Resource.getInstance().getSucheNachPolstercode() + ":");
        this.tfPolstercode = new JTextField(4);
        this.tfPolstercode.setDocument(new EnhancedTextDocument(4, 1));
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PolsterCode.this.suppressComboActionListener) {
                    PolsterCode.this.showAFsForA(((String)PolsterCode.this.combo.getSelectedItem()).substring(0, 2));
                }
            }
        });
        this.tfPolstercode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolsterCode.this.suppressComboActionListener = true;
                PolsterCode.this.showAFsForPolstercode(PolsterCode.this.tfPolstercode.getText());
                PolsterCode.this.suppressComboActionListener = false;
            }
        });
        this.buttonSuchen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolsterCode.this.suppressComboActionListener = true;
                PolsterCode.this.showAFsForPolstercode(PolsterCode.this.tfPolstercode.getText());
                PolsterCode.this.suppressComboActionListener = false;
            }
        });
        this.createLayout();
    }

    protected void createLayout() {
        this.panContent = this.dlg.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.panContent.setLayout(l);
        this.panContent.add((Component)this.panHeader, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        this.panContent.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    public JPanel createContent() {
        JPanel p = new JPanel();
        int[] w = new int[]{10, 0, 5, 0, 5, 0, 20, 0, 10};
        int[] h = new int[]{10, 0, 5, 0, 20, 0, 10, 0, 10, 0, 10};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(6, 1);
        l.setRowWeight(10, 1);
        p.setLayout(l);
        p.add((Component)this.labHinweis, c.rcwh(2, 2, 7, 1));
        p.add((Component)this.labHinweis2, c.rcwh(4, 2, 7, 1));
        p.add((Component)this.labCombo, c.rc(6, 2, "l"));
        p.add((Component)this.combo, c.rcwh(6, 4, 3, 1, "lr"));
        p.add((Component)this.labOder, c.rc(6, 8, "l"));
        p.add((Component)this.labPolstercode, c.rc(8, 2, "l"));
        p.add((Component)this.tfPolstercode, c.rc(8, 4, "l"));
        p.add((Component)this.buttonSuchen, c.rc(8, 6, "l"));
        p.add((Component)this.table.getScrollPane(), c.rcwh(10, 2, 7, 1));
        return p;
    }

    public void show() {
        this.dlg.setVisible(true);
    }

    public static PolsterCode getInstance() {
        if (instance == null) {
            instance = new PolsterCode();
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    private List<PolsterCodeAusstattungZeile> loadPolstercode() {
        log.debug((Object)"Performing Load Polstercode");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfPolstercode = new TrfHashMap(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfPolstercode, Command.LOAD_POLSTERCODE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("Polstercode: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfPolstercode.getError() != null) {
            if (trfPolstercode.getError() instanceof NoDataFoundException) {
                log.error((Object)"keine Daten gefunden!", (Throwable)trfPolstercode.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getPolstercodeUmschluesselung(), 0);
                return null;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfPolstercode.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfPolstercode.getError().getMessage(), Resource.getInstance().getPolstercodeUmschluesselung(), 0);
            return null;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return (List)trfPolstercode.getValue("poster_ausstattungen");
    }

    private void fillComboAusstattung() {
        this.suppressComboActionListener = true;
        this.combo.removeAllItems();
        this.suppressComboActionListener = false;
        for (PolsterCodeAusstattungZeile zeile : this.mPolsterCodeAusstattungZeilen) {
            this.combo.addItem(zeile.getCode() + ' ' + zeile.getBenennung() + ' ' + this.constructStringGueltigkeitszeitraum(zeile.getGueltigVon(), zeile.getGueltigBis()));
        }
        if (!this.mPolsterCodeAusstattungZeilen.isEmpty()) {
            this.combo.setSelectedIndex(0);
        }
    }

    private String constructStringGueltigkeitszeitraum(String pGueltigVon, String pGueltigBis) {
        StringBuilder sb = new StringBuilder();
        if (!pGueltigVon.equals("") || !pGueltigBis.equals("")) {
            sb.append("(");
            if (!pGueltigVon.equals("")) {
                sb.append(Resource.getInstance().getGueltig().toLowerCase()).append(' ').append(Resource.getInstance().getAb()).append(' ').append(pGueltigVon);
                if (!pGueltigBis.equals("")) {
                    sb.append(' ');
                }
            }
            if (!pGueltigBis.equals("")) {
                sb.append(Resource.getInstance().getGueltigBis().toLowerCase()).append(' ').append(pGueltigBis);
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private void showAFsForA(String sKeyAusstattung) {
        this.tableModel.removeAllRows();
        this.table.getTable().clearSelection();
        this.tfPolstercode.setText("");
        PolsterCodeAusstattungZeile zeile = this.mPolsterCodeAusstattungZeilenMap.get(sKeyAusstattung);
        for (PolsterCodeAusstattungFarbeZeile ausstattungFarbeZeile : zeile.getPolsterCodeAusstattungFarbeZeilen()) {
            this.addAFRowToTable(ausstattungFarbeZeile);
        }
    }

    private void showAFsForPolstercode(String sPolstercodeSuche) {
        if (sPolstercodeSuche == null || sPolstercodeSuche.length() < 1) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getPolstercodeMin1zeichen(), Resource.getInstance().getPolstercodeUmschluesselung(), 1);
            this.tfPolstercode.requestFocus();
            return;
        }
        this.tableModel.removeAllRows();
        this.table.getTable().clearSelection();
        this.suppressComboActionListener = true;
        this.combo.setSelectedIndex(-1);
        this.suppressComboActionListener = false;
        for (PolsterCodeAusstattungZeile zeile : this.mPolsterCodeAusstattungZeilen) {
            for (PolsterCodeAusstattungFarbeZeile ausstattungFarbeZeile : zeile.getPolsterCodeAusstattungFarbeZeilen()) {
                if (!ausstattungFarbeZeile.getPCode().contains(sPolstercodeSuche)) continue;
                this.addAFRowToTable(ausstattungFarbeZeile);
            }
        }
        Rectangle rect = this.table.getTable().getCellRect(0, 0, true);
        this.table.getScrollPane().getViewport().setViewPosition(rect.getLocation());
        this.panContent.repaint();
    }

    private void addAFRowToTable(PolsterCodeAusstattungFarbeZeile pAusstattungFarbZeile) {
        this.tableModel.addRow(new AbstractRow(new Object[]{pAusstattungFarbZeile.getPCode(), pAusstattungFarbZeile.getBenennung(), pAusstattungFarbZeile.getCode(), this.constructStringGueltigkeitszeitraum(pAusstattungFarbZeile.getGueltigVon(), pAusstattungFarbZeile.getGueltigBis())}));
    }

    static {
        log = Logger.getLogger(PolsterCode.class);
    }
}

