/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.hilfe.tfattribute;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import webetk.app.hilfe.Teileart;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.resources.Resource;

public class TFAttribute {
    private static Logger log = Logger.getLogger(TFAttribute.class);
    private static TFAttribute instance;
    private JDialog dlg = new JDialog((Frame)MainView.getInstance(), false);
    private GenericTableModel tableModelTA;
    private GenericTable tableTA;
    private JPanel panHeader;
    private JPanel panTeileart;
    private Container paneContent;
    private List<Teileart> mTeilearten = null;

    private TFAttribute() {
        this.dlg.setTitle(Resource.getInstance().getTeileart());
        this.dlg.setSize(800, 580);
        this.dlg.setLocation(100, 100);
        this.initComponents();
        this.loadTFAttribute();
        this.update();
    }

    public void initComponents() {
        this.panHeader = new HeaderPanel(Resource.getInstance().getTeileart(), null);
        this.panTeileart = new TitledPanel(Resource.getInstance().getTeileart());
        TableConfiguration configTA = new TableConfiguration();
        configTA.addColumn(Resource.getInstance().getWert(), 0, false, "X");
        configTA.addColumn(Resource.getInstance().getBedeutung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.tableModelTA = new GenericTableModel(configTA);
        this.tableTA = new GenericTable(this.tableModelTA);
        this.layoutAll();
    }

    protected void layoutAll() {
        this.paneContent = this.dlg.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.paneContent.setLayout(l);
        this.paneContent.add((Component)this.panHeader, c.rc(1, 1, "tlbr"));
        JPanel panContent = this.createContent();
        this.paneContent.add((Component)panContent, c.rc(3, 1, "tlbr"));
    }

    public JPanel createContent() {
        JPanel p = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(1, 1);
        l.setRowWeight(2, 1);
        p.setLayout(l);
        p.add((Component)this.createTeileartPanel(), c.rc(2, 1));
        return p;
    }

    public JPanel createTeileartPanel() {
        int[] w = new int[]{10, 0, 10};
        int[] h = new int[]{10, 0, 10};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(2, 1);
        l.setRowWeight(2, 1);
        this.panTeileart.setLayout(l);
        this.panTeileart.add((Component)this.tableTA.getScrollPane(), c.rc(2, 2));
        return this.panTeileart;
    }

    public void show() {
        this.dlg.setVisible(true);
    }

    public static TFAttribute getInstance() {
        if (instance == null) {
            instance = new TFAttribute();
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    private void update() {
        if (this.mTeilearten == null) {
            return;
        }
        for (Teileart teileart : this.mTeilearten) {
            this.tableModelTA.addRow(new AbstractRow(new Object[]{teileart.getWert(), teileart.getBedeutung()}));
        }
    }

    private void loadTFAttribute() {
        log.debug((Object)"Performing Load TF-Attribute");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfTFAttribute = new TrfHashMap(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTFAttribute, Command.LOAD_TF_ATTRIBUTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("Version: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTFAttribute.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTFAttribute.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfTFAttribute.getError().getMessage(), Resource.getInstance().getTeileart(), 0);
            return;
        }
        this.mTeilearten = (List)trfTFAttribute.getValue("teilearten");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

