/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.hilfe.version;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.resources.Resource;

public class Version {
    private static Logger log = Logger.getLogger(Version.class);
    private static Version instance = null;
    private JDialog dlg = new JDialog((Frame)MainView.getInstance(), false);
    private JPanel panHeader;
    private JPanel panVersion;
    private JLabel labCDVersion;
    private JLabel labCDVersionAnz;
    private JLabel labWebETKVersion;
    private JLabel labWebETKVersionAnz;
    private JLabel labDBVersion;
    private JLabel labDBVersionAnz;
    private JLabel labDatenVom;
    private JLabel labDatenVomAnz;
    private JLabel labServer;
    private JLabel labServerAnz;
    private TrfHashMap oAnzeigedaten = null;

    private Version() {
        this.dlg.setTitle(Resource.getInstance().getVersion());
        if (GlobalObjects.getInstance().getIstStandalone()) {
            this.dlg.setSize(380, 240);
        } else {
            this.dlg.setSize(380, 260);
        }
        this.dlg.setLocation(100, 100);
        this.initComponents();
        this.loadVersionsinformation();
        this.update();
    }

    private void initComponents() {
        this.panHeader = new HeaderPanel(Resource.getInstance().getEtkInformation(), null);
        this.panVersion = new TitledPanel(Resource.getInstance().getInformation());
        this.labCDVersion = new JLabel(Resource.getInstance().getCdVersion() + ":");
        this.labWebETKVersion = new JLabel(Resource.getInstance().getEtkVersion() + ":");
        this.labDBVersion = new JLabel(Resource.getInstance().getDatenbankVersion());
        this.labDatenVom = new JLabel(Resource.getInstance().getDatenVom());
        this.labCDVersionAnz = new JLabel();
        this.labCDVersionAnz.setFont(UIHelper.getBoldFont());
        this.labWebETKVersionAnz = new JLabel();
        this.labWebETKVersionAnz.setFont(UIHelper.getBoldFont());
        this.labDBVersionAnz = new JLabel();
        this.labDBVersionAnz.setFont(UIHelper.getBoldFont());
        this.labDatenVomAnz = new JLabel();
        this.labDatenVomAnz.setFont(UIHelper.getBoldFont());
        if (!GlobalObjects.getInstance().getIstStandalone()) {
            this.labServer = new JLabel(Resource.getInstance().getServer() + ":");
            this.labServerAnz = new JLabel();
            this.labServerAnz.setFont(UIHelper.getBoldFont());
        }
        this.layoutAll();
    }

    protected void layoutAll() {
        Container paneContent = this.dlg.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        paneContent.setLayout(l);
        paneContent.add((Component)this.panHeader, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        paneContent.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    private JPanel createContent() {
        JPanel p = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(1, 1);
        l.setRowWeight(2, 1);
        p.setLayout(l);
        p.add((Component)this.createVersionPanel(), c.rc(2, 1));
        return p;
    }

    private JPanel createVersionPanel() {
        int[] w = new int[]{10, 0, 10, 0, 10};
        int[] h = null;
        h = GlobalObjects.getInstance().getIstStandalone() ? new int[]{10, 0, 10, 0, 10, 0, 10, 0, 10} : new int[]{10, 0, 10, 0, 10, 0, 10, 0, 10, 0, 10};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(5, 1);
        l.setRowWeight(9, 1);
        this.panVersion.setLayout(l);
        this.panVersion.add((Component)this.labCDVersion, c.rc(2, 2));
        this.panVersion.add((Component)this.labCDVersionAnz, c.rc(2, 4));
        this.panVersion.add((Component)this.labWebETKVersion, c.rc(4, 2));
        this.panVersion.add((Component)this.labWebETKVersionAnz, c.rc(4, 4));
        this.panVersion.add((Component)this.labDBVersion, c.rc(6, 2));
        this.panVersion.add((Component)this.labDBVersionAnz, c.rc(6, 4));
        this.panVersion.add((Component)this.labDatenVom, c.rc(8, 2));
        this.panVersion.add((Component)this.labDatenVomAnz, c.rc(8, 4));
        if (!GlobalObjects.getInstance().getIstStandalone()) {
            this.panVersion.add((Component)this.labServer, c.rc(10, 2));
            this.panVersion.add((Component)this.labServerAnz, c.rc(10, 4));
        }
        return this.panVersion;
    }

    public void show() {
        this.dlg.setVisible(true);
    }

    public static Version getInstance() {
        if (instance == null) {
            instance = new Version();
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    private void update() {
        String sCDVersion = (String)this.oAnzeigedaten.getValue("cdversion");
        String sWebETKVersion = (String)this.oAnzeigedaten.getValue("webetkversion");
        String sDBVersion = (String)this.oAnzeigedaten.getValue("dbversion");
        String sDatenVom = (String)this.oAnzeigedaten.getValue("datenvom");
        this.labCDVersionAnz.setText(sCDVersion);
        this.labWebETKVersionAnz.setText(sWebETKVersion);
        this.labDBVersionAnz.setText(sDBVersion);
        this.labDatenVomAnz.setText(sDatenVom);
        if (!GlobalObjects.getInstance().getIstStandalone()) {
            int nInd = GlobalObjects.getInstance().getServerUrl().indexOf("/javaserver");
            String sUrlAnfang = GlobalObjects.getInstance().getServerUrl().substring(0, nInd);
            this.labServerAnz.setText(sUrlAnfang);
        }
    }

    public static TrfHashMap loadVersionsinformation_external(boolean pForceLocal) {
        TrfHashMap trfVersionsinfo = new TrfHashMap(null);
        trfVersionsinfo.setForceLocalServerOnly(pForceLocal);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfVersionsinfo, Command.LOAD_VERSIONSINFO);
        }
        catch (CommunicationException ex) {
            log.error((Object)("Version: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfVersionsinfo.getError() != null) {
            if (trfVersionsinfo.getError() instanceof CommunicationException) {
                CommunicationException error = (CommunicationException)trfVersionsinfo.getError();
                log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfVersionsinfo.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getZentraleSucheConnectionFehler(), Resource.getInstance().getVersion(), 0);
                return null;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfVersionsinfo.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfVersionsinfo.getError().getMessage(), Resource.getInstance().getVersion(), 0);
            return null;
        }
        return trfVersionsinfo;
    }

    private void loadVersionsinformation() {
        log.debug((Object)"Performing Load Versioninfo");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfVersionsinfo = new TrfHashMap(null);
        trfVersionsinfo.setForceLocalServerOnly(false);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfVersionsinfo, Command.LOAD_VERSIONSINFO);
        }
        catch (CommunicationException ex) {
            log.error((Object)("Version: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfVersionsinfo.getError() != null) {
            if (trfVersionsinfo.getError() instanceof CommunicationException) {
                CommunicationException error = (CommunicationException)trfVersionsinfo.getError();
                log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfVersionsinfo.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getZentraleSucheConnectionFehler(), Resource.getInstance().getVersion(), 0);
                return;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfVersionsinfo.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfVersionsinfo.getError().getMessage(), Resource.getInstance().getVersion(), 0);
            return;
        }
        this.oAnzeigedaten = trfVersionsinfo;
        this.setVersionInfosAsCommonProperties();
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    private void setVersionInfosAsCommonProperties() {
        GlobalObjects.getInstance().getCommonProperties().put("cdversion", this.oAnzeigedaten.getValue("cdversion"));
        GlobalObjects.getInstance().getCommonProperties().put("webetkversion", this.oAnzeigedaten.getValue("webetkversion"));
        GlobalObjects.getInstance().getCommonProperties().put("dbversion", this.oAnzeigedaten.getValue("dbversion"));
        GlobalObjects.getInstance().getCommonProperties().put("datenvom", this.oAnzeigedaten.getValue("datenvom"));
    }

    public String getCDVersion() {
        return GlobalObjects.getInstance().getCommonProperties().getProperty("cdversion", "");
    }

    public String getWebETKVersion() {
        return GlobalObjects.getInstance().getCommonProperties().getProperty("webetkversion", "");
    }

    public String getDBVersion() {
        return GlobalObjects.getInstance().getCommonProperties().getProperty("dbversion", "");
    }

    public String getDatumDatenVom() {
        return GlobalObjects.getInstance().getCommonProperties().getProperty("datenvom", "");
    }
}

