/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.login.view;

import de.esg.commonclient.dialog.JButtonEx;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.login.model.Context;
import webetk.javaclient.dialog.login.model.ContextDcs;
import webetk.javaclient.dialog.login.model.ContextDealer;
import webetk.javaclient.dialog.login.model.ContextInternet;
import webetk.javaclient.dialog.login.model.ContextRrDealer;
import webetk.javaclient.dialog.login.model.ContextSGate;
import webetk.javaclient.dialog.login.model.LoginModel;
import webetk.javaclient.dialog.login.view.ContextRenderer;
import webetk.javaclient.dialog.login.view.ILoginData;

public class LoginView {
    private JDialog mDlg;
    private JComboBox comboBox;
    private ILoginData activeComponent;
    private GridBagConstraints gbc_panel;
    private LoginModel model;
    private JButtonEx btnLogin;
    private JButtonEx btnCancel;
    private JLabel lblContext;
    private JPanel panel_loginData;
    private JPanel panel_buttons;

    public LoginView(JFrame mainView, LoginModel model, String sTitle) {
        this.model = model;
        this.mDlg = new JDialog((Frame)mainView, false);
        this.mDlg.setModal(true);
        if (sTitle != null && sTitle.length() > 0) {
            this.mDlg.setTitle(sTitle);
        } else {
            this.mDlg.setTitle("TODO Internationalisierung -> Login BMW AG");
        }
        this.mDlg.setSize(430, 330);
        this.mDlg.setLocationRelativeTo(mainView);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{1, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        this.mDlg.getContentPane().setLayout(gridBagLayout);
        this.panel_loginData = new JPanel();
        GridBagConstraints gbc_panel1 = new GridBagConstraints();
        gbc_panel1.fill = 1;
        gbc_panel1.insets = new Insets(0, 0, 5, 0);
        gbc_panel1.gridx = 0;
        gbc_panel1.gridy = 0;
        this.mDlg.getContentPane().add((Component)this.panel_loginData, gbc_panel1);
        GridBagLayout gridBagLayout_panel1 = new GridBagLayout();
        gridBagLayout_panel1.columnWidths = new int[]{10, 100, 100, 10, 0};
        gridBagLayout_panel1.rowHeights = new int[]{1, 0, 60, 0, 0};
        gridBagLayout_panel1.columnWeights = new double[]{1.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout_panel1.rowWeights = new double[]{1.0, 0.0, 2.0, 1.0, Double.MIN_VALUE};
        this.panel_loginData.setLayout(gridBagLayout_panel1);
        this.lblContext = new JLabel("TODO Internationalisierung -> Context:");
        GridBagConstraints gbc_lblContext = new GridBagConstraints();
        gbc_lblContext.weightx = 1.0;
        gbc_lblContext.fill = 2;
        gbc_lblContext.insets = new Insets(20, 0, 5, 5);
        gbc_lblContext.gridx = 1;
        gbc_lblContext.gridy = 1;
        this.panel_loginData.add((Component)this.lblContext, gbc_lblContext);
        this.comboBox = new JComboBox();
        GridBagConstraints gbc_comboBox = new GridBagConstraints();
        gbc_comboBox.weightx = 1.0;
        gbc_comboBox.insets = new Insets(20, 0, 5, 5);
        gbc_comboBox.fill = 2;
        gbc_comboBox.gridx = 2;
        gbc_comboBox.gridy = 1;
        this.panel_loginData.add((Component)this.comboBox, gbc_comboBox);
        this.panel_buttons = new JPanel();
        GridBagConstraints gbc_panel2 = new GridBagConstraints();
        gbc_panel2.fill = 1;
        gbc_panel2.gridx = 0;
        gbc_panel2.gridy = 1;
        this.mDlg.getContentPane().add((Component)this.panel_buttons, gbc_panel2);
        GridBagLayout gridBagLayout_panel2 = new GridBagLayout();
        gridBagLayout_panel2.columnWidths = new int[]{10, 1, 0, 100, 100, 0, 10, 0};
        gridBagLayout_panel2.rowHeights = new int[]{1, 0, 0, 0};
        gridBagLayout_panel2.columnWeights = new double[]{1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout_panel2.rowWeights = new double[]{1.0, 1.0, 1.0, Double.MIN_VALUE};
        this.panel_buttons.setLayout(gridBagLayout_panel2);
        this.btnLogin = new JButtonEx("TODO Internationalisierung -> Login", ImageCache.getInstance().getIcon("ok.gif"));
        GridBagConstraints gbc_btnLogin = new GridBagConstraints();
        gbc_btnLogin.fill = 2;
        gbc_btnLogin.weightx = 1.0;
        gbc_btnLogin.insets = new Insets(0, 0, 20, 5);
        gbc_btnLogin.gridx = 3;
        gbc_btnLogin.gridy = 1;
        this.panel_buttons.add((Component)this.btnLogin, gbc_btnLogin);
        this.mDlg.getRootPane().setDefaultButton(this.btnLogin);
        this.btnCancel = new JButtonEx("TODO Internationalisierung -> Cancel", ImageCache.getInstance().getIcon("delete.gif"));
        GridBagConstraints gbc_btnCancel = new GridBagConstraints();
        gbc_btnCancel.fill = 2;
        gbc_btnCancel.weightx = 1.0;
        gbc_btnCancel.insets = new Insets(0, 0, 20, 5);
        gbc_btnCancel.gridx = 4;
        gbc_btnCancel.gridy = 1;
        this.panel_buttons.add((Component)this.btnCancel, gbc_btnCancel);
        this.gbc_panel = new GridBagConstraints();
        this.gbc_panel.fill = 1;
        this.gbc_panel.gridwidth = 2;
        this.gbc_panel.weightx = 1.0;
        this.gbc_panel.weighty = 1.0;
        this.gbc_panel.insets = new Insets(5, 5, 5, 5);
        this.gbc_panel.gridx = 1;
        this.gbc_panel.gridy = 2;
        this.initCombobox();
        this.disableBtnLogin();
    }

    private void initCombobox() {
        ContextSGate cSgate;
        ContextDcs cDcs;
        ContextRrDealer cRrDlr;
        ContextDealer cDlr;
        ContextInternet cInter = new ContextInternet();
        if (cInter.getContextUrl() != null) {
            this.comboBox.addItem(cInter);
        }
        if ((cDlr = new ContextDealer()).getContextUrl() != null) {
            this.comboBox.addItem(cDlr);
        }
        if ((cRrDlr = new ContextRrDealer()).getContextUrl() != null) {
            this.comboBox.addItem(cRrDlr);
        }
        if ((cDcs = new ContextDcs()).getContextUrl() != null) {
            this.comboBox.addItem(cDcs);
        }
        if ((cSgate = new ContextSGate()).getContextUrl() != null) {
            this.comboBox.addItem(cSgate);
        }
        this.comboBox.setSelectedIndex(-1);
        this.comboBox.setRenderer(new ContextRenderer());
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public void setComboBox(JComboBox comboBox) {
        this.comboBox = comboBox;
    }

    public void addContextChangeListener(ActionListener al) {
        this.comboBox.addActionListener(al);
    }

    public void addLoginButtonListener(ActionListener al) {
        this.btnLogin.addActionListener(al);
    }

    public void addCancelButtonListener(ActionListener al) {
        this.btnCancel.addActionListener(al);
    }

    public ILoginData getActiveComponent() {
        return this.activeComponent;
    }

    public void setActiveComponent(ILoginData activeComponent) {
        this.activeComponent = activeComponent;
        this.panel_loginData.add((Component)((Object)activeComponent), this.gbc_panel);
        this.model.setLoginData(activeComponent);
    }

    public void setLblContext(String slblContext) {
        this.lblContext.setText(slblContext);
    }

    public void setLblBtnLogin(String sbtnLogin) {
        this.btnLogin.setText(sbtnLogin);
    }

    public void enableBtnLogin() {
        this.btnLogin.setEnabled(true);
    }

    public void disableBtnLogin() {
        this.btnLogin.setEnabled(false);
    }

    public void setLblBtnCancel(String sbtnCancel) {
        this.btnCancel.setText(sbtnCancel);
    }

    public void preSelectContext() {
        int cbItemToBeSelected = -1;
        for (int cbItems = 0; cbItems < this.comboBox.getItemCount(); ++cbItems) {
            Context cntxt;
            if (!(this.comboBox.getItemAt(cbItems) instanceof Context) || !(cntxt = (Context)this.comboBox.getItemAt(cbItems)).isContextToBeSelected()) continue;
            cbItemToBeSelected = cbItems;
            this.comboBox.setSelectedItem(cntxt);
            break;
        }
        this.comboBox.setSelectedIndex(cbItemToBeSelected);
        if (cbItemToBeSelected != -1) {
            this.comboBox.setEnabled(false);
        }
        this.disableBtnLogin();
    }

    public void removeComponent(Component comp) {
        this.mDlg.remove(comp);
    }

    public void validateMe() {
        this.mDlg.validate();
    }

    public void disposeMe() {
        this.mDlg.dispose();
    }

    public void show() {
        this.mDlg.setVisible(true);
    }

    public void setCursorToWait() {
        this.mDlg.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setCursorToDefault() {
        this.mDlg.setCursor(Cursor.getPredefinedCursor(0));
    }

    public JPanel getPanel_loginData() {
        return this.panel_loginData;
    }
}

