/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.reduzierteBTE;

import de.esg.commonclient.GlobalObjects;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import rasterviewer.ImageViewerComponent;
import rasterviewer.hotspot.HotspotManager;
import rasterviewer.hotspot.IHotspotManager;
import rasterviewer.imageloaders.ImageLoader;
import webetk.NoDataFoundException;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfImage;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventListener;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.resources.Resource;

public class ReduzierteBTE
extends JDialog {
    private static final long serialVersionUID = 1L;
    Logger log = Logger.getLogger(ReduzierteBTE.class);
    private String msMarke = null;
    private String msProduktart = null;
    private String msSachnummer = null;
    private String msHeader2 = null;
    private String msGrafikId = null;
    private int mnGrafikFormat = 0;
    private String msGrafikTimestamp = null;
    private byte[] maBild = null;
    private String msBildnummer = null;
    private String msTeilenummer = null;
    private String msTeilebenennung = null;
    private String msZusatz = null;
    private GenericTableModel tableModel;
    private GenericTable table;
    private JPopupMenu menuPopup = null;
    private JMenuItem menuitemCopySachnummer = null;
    private ImageViewerComponent imagePanel;

    public ReduzierteBTE(JFrame oFrame, String sMarke, String sProduktart, String sSachnummer) {
        super((Frame)oFrame, true);
        this.msMarke = sMarke;
        this.msProduktart = sProduktart;
        this.msSachnummer = sSachnummer;
        this.setTitle(Resource.getInstance().getVisualisierungDesTeils());
        this.loadVisualisierung();
        this.initMenus();
        this.initComponents();
    }

    protected void initMenus() {
        this.menuPopup = new JPopupMenu();
        this.menuitemCopySachnummer = new JMenuItem(Resource.getInstance().getSachnummerKopieren());
        this.menuPopup.add(this.menuitemCopySachnummer);
        this.menuitemCopySachnummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalObjects.getInstance().getEtkData().copySachnummerIntoClipboard(ReduzierteBTE.this.msSachnummer);
            }
        });
    }

    void initComponents() {
        HeaderPanel panHeader = new HeaderPanel(Resource.getInstance().getVisualisierungDesTeils() + " " + this.msTeilenummer, this.msHeader2, null);
        HotspotManager hotspotMgr = new HotspotManager();
        JToolBar emptyToolBar = new JToolBar();
        emptyToolBar.setVisible(false);
        this.imagePanel = new ImageViewerComponent((IHotspotManager)hotspotMgr, emptyToolBar, (JFrame)MainView.getInstance());
        hotspotMgr.setImageViewer(this.imagePanel);
        this.imagePanel.showHotspotRollover(false);
        this.imagePanel.showHotspots(false);
        this.imagePanel.getRenderer().setBackgroundColor(Color.white);
        JPanel panContent = new JPanel(new BorderLayout(0, 0));
        panContent.setBorder(new EmptyBorder(10, 10, 10, 10));
        panContent.add((Component)this.imagePanel, "Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panHeader, "North");
        this.getContentPane().add((Component)panContent, "Center");
        this.getContentPane().add((Component)this.createTabelle(), "South");
        this.setSize(700, 480);
        ImageLoader loader = new ImageLoader();
        try {
            this.imagePanel.setImage(loader.loadImage(this.maBild, this.mnGrafikFormat, 0));
        }
        catch (Exception ex) {
            this.log.error((Object)("Fehler beim Laden der Grafik (Id: " + this.msGrafikId + " Format: " + this.mnGrafikFormat + ")"), (Throwable)ex);
        }
    }

    protected JScrollPane createTabelle() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn(Resource.getInstance().getNueNr(), 0, false, "0000");
        tableConfig.setHeaderTooltip(0, Resource.getInstance().getNummer());
        tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "11 11 1 743 118");
        tableConfig.addColumn(Resource.getInstance().getTeilebenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableConfig.addColumn(Resource.getInstance().getZusatz(), 2, true, "XXXXXXXXXXXXXXXYYYY");
        this.tableModel = new GenericTableModel(tableConfig);
        this.tableModel.addRow(new AbstractRow(new Object[]{this.msBildnummer, this.msTeilenummer, this.msTeilebenennung, this.msZusatz}));
        this.table = new GenericTable(this.tableModel);
        this.table.setResizeMode(1);
        this.table.setAllowSizingSmallerThanMinimumWidth(false);
        GenericTableMouseEventListener listenerCopySachnummer = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent evt) {
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                ReduzierteBTE.this.menuPopup.show(ReduzierteBTE.this.table.getTable(), evt.getX(), evt.getY());
            }
        };
        this.table.addMouseListener(listenerCopySachnummer, 0);
        this.table.addMouseListener(listenerCopySachnummer, 1);
        this.table.addMouseListener(listenerCopySachnummer, 2);
        this.table.addMouseListener(listenerCopySachnummer, 3);
        return this.table.getScrollPane();
    }

    void loadVisualisierung() {
        this.log.debug((Object)"Performing Search Visualisierung");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfDaten = new TrfHashMap(null);
        trfDaten.setValue("marke", this.msMarke);
        trfDaten.setValue("produktart", this.msProduktart);
        trfDaten.setValue("sachnummer", this.msSachnummer);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfDaten, Command.LOAD_VISUALISIERUNG);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfDaten.getError() != null) {
            if (trfDaten.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"keine Daten gefunden!", (Throwable)trfDaten.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getVisualisierungDesTeils(), 1);
                return;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfDaten.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfDaten.getError().getMessage(), Resource.getInstance().getVisualisierungDesTeils(), 0);
            return;
        }
        this.msBildnummer = (String)trfDaten.getValue("nummer");
        this.msTeilenummer = (String)trfDaten.getValue("teilenummer");
        this.msTeilebenennung = (String)trfDaten.getValue("benennung");
        if (this.msTeilebenennung == null) {
            this.msTeilebenennung = "";
        }
        this.msTeilebenennung = this.msTeilebenennung.trim();
        this.msZusatz = (String)trfDaten.getValue("zusatz");
        if (this.msZusatz == null) {
            this.msZusatz = "";
        }
        this.msZusatz = this.msZusatz.trim();
        this.msHeader2 = this.msTeilebenennung;
        if (!this.msZusatz.equals("")) {
            this.msHeader2 = this.msTeilebenennung + "/" + this.msZusatz;
        }
        this.msGrafikId = (String)trfDaten.getValue("imgid");
        String sHelp = (String)trfDaten.getValue("imgformat");
        if (sHelp.toUpperCase().equals("PNG")) {
            this.mnGrafikFormat = 2;
        }
        if (sHelp.toUpperCase().equals("JPEG") || sHelp.toUpperCase().equals("JPG")) {
            this.mnGrafikFormat = 1;
        }
        if (sHelp.toUpperCase().equals("TIFF") || sHelp.toUpperCase().equals("TIF")) {
            this.mnGrafikFormat = 3;
        }
        this.msGrafikId = (String)trfDaten.getValue("imgid");
        this.msGrafikTimestamp = (String)trfDaten.getValue("imgts");
        TrfImage bild = new TrfImage(null);
        bild.setImageID(this.msGrafikId);
        bild.setFormFactor("Z");
        bild.setTimestamp(this.msGrafikTimestamp);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(bild, Command.GET_IMAGE);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)"Communication Layer is not initialised!", (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (bild.getError() != null) {
            this.log.error((Object)"Login Failed!", (Throwable)bild.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        this.maBild = bild.cloneData();
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

