/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.spezifteilesuche.bedingungsauswertung;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.app.Bedingungswert;
import webetk.app.SearchBTETeile;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.spezifteilesuche.bedingungsauswertung.BedingungsauswertungModel;
import webetk.javaclient.dialog.spezifteilesuche.bedingungsauswertung.BedingungsauswertungView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class BedingungsauswertungController
extends AbstractDialogViewController {
    Logger log = Logger.getLogger(BedingungsauswertungController.class);
    BedingungsauswertungView view = new BedingungsauswertungView();
    BedingungsauswertungModel model = new BedingungsauswertungModel();

    @Override
    public DialogView getDialogView() {
        this.log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        this.log.debug((Object)"init");
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        WorkflowStateData exitData = new WorkflowStateData();
        exitData.setWert("HGFG_BENENNUNG", this.model.getHgFgList());
        if (this.model.getBildtafeln() != null && !this.model.getBildtafeln().isEmpty()) {
            exitData.setWert("bildtafeln_bed_aend", this.model.getBildtafeln());
        } else if (exitData.getWert("bildtafeln_bed_aend") != null) {
            exitData.setWert("bildtafeln_bed_aend", exitData.getWert("bildtafeln_bed_aend"));
        }
        exitData.setWert("exitaction", this.model.getExitAction());
        exitData.setWert("bildtafeln_sel", this.model.getMoAnzeigedaten());
        exitData.setWert("bildtafeln", this.model.getBildtafelnBlaettern());
        return exitData;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    void changeBedingung(Long lBedId, Bedingungswert oBedWert) {
        this.log.debug((Object)"Performing Change Bedingung");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfChangeBed = new TrfHashMap(null);
        trfChangeBed.setValue("id", lBedId);
        trfChangeBed.setValue("wert", oBedWert);
        trfChangeBed.setValue("aktualisieren", "true");
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfChangeBed, Command.BT_CHANGE_BED);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfChangeBed.getError() != null) {
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfChangeBed.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfChangeBed.getError().getMessage(), Resource.getInstance().getAnzeigeBildtafel(), 0);
            return;
        }
        this.model.storeCurrentBTE((CurrentBTE)trfChangeBed.getValue("currentbte"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        SearchBTETeile oSearchBTETeile = (SearchBTETeile)trfChangeBed.getValue("searchbteteile");
        if (oSearchBTETeile != null && oSearchBTETeile.getBTEs() != null) {
            if (this.model.getBildtafeln() != null) {
                this.model.getBildtafeln().clear();
            }
            this.model.setBildtafeln(oSearchBTETeile.getBTEs());
        }
    }

    void resetBedingungen() {
        this.log.debug((Object)"Performing Reset Bedingungen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfReset = new TrfHashMap(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfReset, Command.BT_RESET_BEDINGUNGEN);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfReset.getError() != null) {
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfReset.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfReset.getError().getMessage(), Resource.getInstance().getAnzeigeBildtafel(), 0);
            return;
        }
        this.model.storeCurrentBTE((CurrentBTE)trfReset.getValue("currentbte"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        SearchBTETeile oSearchBTETeile = (SearchBTETeile)trfReset.getValue("searchbteteile");
        if (oSearchBTETeile != null && oSearchBTETeile.getBTEs() != null) {
            if (this.model.getBildtafeln() != null) {
                this.model.getBildtafeln().clear();
            }
            this.model.setBildtafeln(oSearchBTETeile.getBTEs());
        }
    }

    public static class ExitActions {
        public static final String ANZEIGEN_BT = "anzeigen_bt";
    }
}

