/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.spezifteilesuche.federtabelle;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.table.DefaultTableModel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.CellSelectionAllowed;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.FedertabelleDlgView;

public class FedernTabelleModell
extends DefaultTableModel
implements CellSelectionAllowed {
    private static final long serialVersionUID = 1L;
    protected int nLayout;
    protected int columnCount;
    protected String[] columnNames;
    protected Object[] prototypes;
    protected boolean[] resizeable;
    protected ArrayList<Zeile> data = new ArrayList();
    Icon infoSymbol = ImageCache.getInstance().getIcon("info.gif");

    public FedernTabelleModell(int nLayout, int columnCount, String[] columnNames, Object[] prototypes, boolean[] resizeable) {
        this.nLayout = nLayout;
        this.columnCount = columnCount;
        this.columnNames = columnNames;
        this.prototypes = prototypes;
        this.resizeable = resizeable;
        if (prototypes.length != this.getColumnCount() || resizeable.length != this.getColumnCount()) {
            throw new IllegalStateException("Fehler in FedernTabelleModel: Anzahl Prototypen oder Resizeables stimmt mit Anzahl Spalten nicht \u00fcberein. (" + prototypes.length + " Prototypen, " + resizeable.length + " Resizeables, " + this.getColumnCount() + " Spalten)");
        }
    }

    public void removeAllRows() {
        this.data = new ArrayList();
        this.fireTableDataChanged();
    }

    public void addZeile(String typ, String teilenrVAlinks, String teilenrVArechts, String teilenrHAlinks, String teilenrHArechts) {
        this.data.add(new Zeile(this.nLayout, typ, teilenrVAlinks, teilenrVArechts, teilenrHAlinks, teilenrHArechts));
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        Zeile z = this.data.get(row);
        switch (column) {
            case 0: {
                return z.getTyp();
            }
            case 1: {
                return z.isIconVAlinks() ? this.infoSymbol : null;
            }
            case 2: {
                return z.getMarkVAlinks();
            }
            case 3: {
                if (this.nLayout == FedertabelleDlgView.VIER_FEDERN || this.nLayout == FedertabelleDlgView.DREI_FEDERN_VA_2FEDERN || this.nLayout == FedertabelleDlgView.DREI_FEDERN_HA_2FEDERN || this.nLayout == FedertabelleDlgView.ZWEI_FEDERN) {
                    return z.getTeilenrVAlinks();
                }
                throw new IllegalArgumentException("getValueAt can not be called with column=" + column);
            }
            case 4: {
                if (this.nLayout == FedertabelleDlgView.VIER_FEDERN || this.nLayout == FedertabelleDlgView.DREI_FEDERN_VA_2FEDERN) {
                    return z.isIconVArechts() ? this.infoSymbol : null;
                }
                return z.isIconHAlinks() ? this.infoSymbol : null;
            }
            case 5: {
                if (this.nLayout == FedertabelleDlgView.VIER_FEDERN || this.nLayout == FedertabelleDlgView.DREI_FEDERN_VA_2FEDERN) {
                    return z.getMarkVArechts();
                }
                return z.getMarkHAlinks();
            }
            case 6: {
                if (this.nLayout == FedertabelleDlgView.VIER_FEDERN) {
                    return z.getTeilenrVArechts();
                }
                if (this.nLayout == FedertabelleDlgView.DREI_FEDERN_VA_2FEDERN) {
                    return z.getTeilenrVArechts();
                }
                if (this.nLayout == FedertabelleDlgView.DREI_FEDERN_HA_2FEDERN) {
                    return z.getTeilenrHAlinks();
                }
                if (this.nLayout == FedertabelleDlgView.ZWEI_FEDERN) {
                    return z.getTeilenrHAlinks();
                }
                throw new IllegalArgumentException("getValueAt can not be called with column=" + column);
            }
            case 7: {
                if (this.nLayout == FedertabelleDlgView.VIER_FEDERN || this.nLayout == FedertabelleDlgView.DREI_FEDERN_VA_2FEDERN) {
                    return z.isIconHAlinks() ? this.infoSymbol : null;
                }
                return z.isIconHArechts() ? this.infoSymbol : null;
            }
            case 8: {
                if (this.nLayout == FedertabelleDlgView.VIER_FEDERN || this.nLayout == FedertabelleDlgView.DREI_FEDERN_VA_2FEDERN) {
                    return z.getMarkHAlinks();
                }
                return z.getMarkHArechts();
            }
            case 9: {
                if (this.nLayout == FedertabelleDlgView.VIER_FEDERN) {
                    return z.getTeilenrHAlinks();
                }
                if (this.nLayout == FedertabelleDlgView.DREI_FEDERN_VA_2FEDERN) {
                    return z.getTeilenrHAlinks();
                }
                if (this.nLayout == FedertabelleDlgView.DREI_FEDERN_HA_2FEDERN) {
                    return z.getTeilenrHArechts();
                }
                throw new IllegalArgumentException("getValueAt can not be called with column=" + column);
            }
            case 10: {
                return z.isIconHArechts() ? this.infoSymbol : null;
            }
            case 11: {
                return z.getMarkHArechts();
            }
            case 12: {
                if (this.nLayout == FedertabelleDlgView.VIER_FEDERN) {
                    return z.getTeilenrHArechts();
                }
                throw new IllegalArgumentException("getValueAt can not be called with column=" + column);
            }
        }
        throw new IllegalArgumentException("getValueAt can not be called with column=" + column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public boolean isCellSelectable(int row, int column) {
        Zeile z = this.data.get(row);
        String typ = z.typ;
        Object val = this.getValueAt(row, column);
        return typ != null && (typ.equals("--") || typ.length() == 4) && val != null && val instanceof String && val.toString().length() == 15;
    }

    public boolean isColumnResizable(int columnIndex) {
        return this.resizeable[columnIndex];
    }

    public Object getPrototype(int columnIndex) {
        return this.prototypes[columnIndex];
    }

    public static class Zeile {
        private String typ = null;
        private String teilenrVAlinks = null;
        private String teilenrVArechts = null;
        private String teilenrHAlinks = null;
        private String teilenrHArechts = null;

        public Zeile(int nLayout, String typ, String teilenrVAlinks, String teilenrVArechts, String teilenrHAlinks, String teilenrHArechts) {
            this.typ = typ;
            this.teilenrVAlinks = teilenrVAlinks;
            this.teilenrVArechts = teilenrVArechts;
            this.teilenrHAlinks = teilenrHAlinks;
            this.teilenrHArechts = teilenrHArechts;
        }

        public String getTeilenrVAlinks() {
            return this.teilenrVAlinks;
        }

        public String getTeilenrVArechts() {
            return this.teilenrVArechts;
        }

        public String getTeilenrHAlinks() {
            return this.teilenrHAlinks;
        }

        public String getTeilenrHArechts() {
            return this.teilenrHArechts;
        }

        public String getTyp() {
            if (this.typ != null && this.typ.equals("--")) {
                return "";
            }
            return this.typ;
        }

        public String getMarkVAlinks() {
            if (this.typ != null && this.typ.equals("--") && this.teilenrVAlinks != null && this.teilenrVAlinks.length() == 15) {
                return "--";
            }
            return "";
        }

        public String getMarkVArechts() {
            if (this.typ != null && this.typ.equals("--") && this.teilenrVArechts != null && this.teilenrVArechts.length() == 15) {
                return "--";
            }
            return "";
        }

        public String getMarkHAlinks() {
            if (this.typ != null && this.typ.equals("--") && this.teilenrHAlinks != null && this.teilenrHAlinks.length() == 15) {
                return "--";
            }
            return "";
        }

        public String getMarkHArechts() {
            if (this.typ != null && this.typ.equals("--") && this.teilenrHArechts != null && this.teilenrHArechts.length() == 15) {
                return "--";
            }
            return "";
        }

        public boolean isIconVAlinks() {
            return this.typ != null && !this.typ.equals("") && this.teilenrVAlinks != null && this.teilenrVAlinks.length() == 15;
        }

        public boolean isIconVArechts() {
            return this.typ != null && !this.typ.equals("") && this.teilenrVArechts != null && this.teilenrVArechts.length() == 15;
        }

        public boolean isIconHAlinks() {
            return this.typ != null && !this.typ.equals("") && this.teilenrHAlinks != null && this.teilenrHAlinks.length() == 15;
        }

        public boolean isIconHArechts() {
            return this.typ != null && !this.typ.equals("") && this.teilenrHArechts != null && this.teilenrHArechts.length() == 15;
        }
    }
}

