/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.spezifteilesuche.federtabelle;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.app.federtabelle.FTZeile;
import webetk.app.federtabelle.FTZeilen;
import webetk.app.federtabelle.SalaZeilen;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.AbstractDlgMitTLController;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.FedertabelleDlgModel;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.FedertabelleDlgView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class FedertabelleDlgController
extends AbstractDlgMitTLController {
    private static Logger log = Logger.getLogger(FedertabelleDlgController.class);
    private FedertabelleDlgView view = new FedertabelleDlgView();
    private FedertabelleDlgModel model = new FedertabelleDlgModel();

    @Override
    public DialogView getDialogView() {
        log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        super.init(this.model);
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        return null;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    public void loadSonderausstattungen() {
        log.debug((Object)"Performing Load Sonderausstattungen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfSonderausstattungen = new TrfHashMap(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfSonderausstattungen, Command.LOAD_FT_SONDERAUSSTATTUNGEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("FedertabelleDlgController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfSonderausstattungen.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfSonderausstattungen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfSonderausstattungen.getError().getMessage(), Resource.getInstance().getFedertabelle(), 0);
            return;
        }
        this.model.storeSonderausstattungenLinks((SalaZeilen)trfSonderausstattungen.getValue("sala_zeilen_links"));
        this.model.storeSonderausstattungenRechts((SalaZeilen)trfSonderausstattungen.getValue("sala_zeilen_rechts"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void loadFedern(Collection<String> cSalaIds, int hackDelay) {
        log.debug((Object)"Performing Load Federn");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        final TrfHashMap trfFedern = new TrfHashMap(null);
        trfFedern.setValue("salaids", cSalaIds);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFedern, Command.LOAD_FT_FEDERN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("FedertabelleDlgController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfFedern.getError() != null) {
            if (trfFedern.getError() instanceof NoDataFoundException) {
                Timer t = new Timer(hackDelay, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFedern.getError());
                        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                        JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSftKeineDaten(), Resource.getInstance().getFedertabelle(), 0);
                    }
                });
                t.setRepeats(false);
                t.start();
            } else {
                log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFedern.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), trfFedern.getError().getMessage(), Resource.getInstance().getFedertabelle(), 0);
            }
            return;
        }
        this.model.storeFedern((FTZeilen)trfFedern.getValue("ft_zeilen"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean isAspgFedern() {
        FTZeilen ftZeilen = this.model.getFedern();
        for (FTZeile ftZeile : ftZeilen.getZeilen()) {
            if (!"--".equals(ftZeile.getTyp())) continue;
            return true;
        }
        return false;
    }
}

