/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.spezifteilesuche.suchergebnisse;

import de.esg.commonclient.GlobalObjects;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.app.FunktionsgruppeTO;
import webetk.app.HauptgruppeTO;
import webetk.app.Markt;
import webetk.app.SearchBTETeile;
import webetk.app.StringKomparator;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.JavaSucheInfo;
import webetk.communication.LoginInfo;
import webetk.javaclient.MarktDaten;
import webetk.javaclient.dialog.AbstractDlgMitTLModel;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class SuchergebnisseModel
extends AbstractDlgMitTLModel {
    Logger log = Logger.getLogger(SuchergebnisseModel.class);
    private String msDialogModus = "";
    private String msDialogTitel = "";
    private String msProduktart = null;
    private String msKatalogumfang = null;
    private String msFzgIdString = null;
    private Collection<SearchBTETeile.PartOrBTE> moBildtafelCache = null;
    private Collection<SearchBTETeile.PartOrBTE> moBildtafeln = null;
    private Collection<SearchBTETeile.PartOrBTE> moBildtafelnBlaettern = null;
    private Collection<SearchBTETeile.PartOrBTE> moTeilenummern = null;
    private String msExitAction = null;
    private Collection<SearchBTETeile.PartOrBTE> mcSelBildtafelnInit = null;
    private Collection<SearchBTETeile.PartOrBTE> mcSelBildtafeln = null;
    private Collection<String> moSelSachnummernInit = null;
    private Collection<String> moSelSachnummern = null;
    private int mnIndexHGNext = -1;
    private int mnIndexHGPrev = -1;
    private int mnIndexHGtoSearch = -1;
    private String msSuchkriterienString = null;
    private String msSuchkriterienStringCompl = null;
    private int mAnzahlSuchHgFgs = 0;
    private boolean bBedFilter;
    private boolean bAbBandVerbaut;
    private MarktDaten mMarktDaten = null;
    private List<HauptgruppeTO> hgfgList;

    @Override
    public void init(WorkflowStateData oWFStateData) {
        String sIndexHGNext;
        super.init(oWFStateData);
        this.hgfgList = (List)oWFStateData.getWert("HGFG_BENENNUNG");
        this.msDialogModus = (String)oWFStateData.getWert("modus");
        if (this.msDialogModus.equals("Teileinfo")) {
            this.initFromTeileinfo(oWFStateData);
            return;
        }
        if (this.msDialogModus.equals("Fahrzeugteile") || this.msDialogModus.equals("ValueLine")) {
            this.msDialogTitel = Resource.getInstance().getSuchergebnisseFahrzeugteile();
            if (this.msDialogModus.equals("ValueLine")) {
                this.msDialogTitel = this.msDialogTitel + " - " + Resource.getInstance().getValueLine();
            }
        } else {
            this.msDialogTitel = Resource.getInstance().getSuchergebnisseZubehoerAccessoires();
        }
        this.moBildtafeln = (Collection)oWFStateData.getWert("bildtafeln");
        this.moBildtafelCache = null;
        this.moBildtafelnBlaettern = null;
        this.mcSelBildtafelnInit = (Collection)oWFStateData.getWert("bildtafeln_sel");
        this.moTeilenummern = (Collection)oWFStateData.getWert("teilenummern");
        this.moSelSachnummernInit = (Collection)oWFStateData.getWert("sachnummern");
        JavaSucheInfo oSucheInfo = GlobalObjects.getInstance().getEtkData().getSucheInfo();
        this.setMarke(oSucheInfo == null ? null : oSucheInfo.getMarke());
        this.msProduktart = oSucheInfo == null ? null : oSucheInfo.getProduktart();
        String string = this.msKatalogumfang = oSucheInfo == null ? null : oSucheInfo.getKatalogumfang();
        if (this.msDialogModus.equals("Fahrzeugteile") || this.msDialogModus.equals("ValueLine")) {
            this.msFzgIdString = oSucheInfo == null ? null : ((JavaFzgSucheInfo)oSucheInfo).getFzgIdString();
        }
        this.mnIndexHGNext = (sIndexHGNext = (String)oWFStateData.getWert("index_next_hg")) == null ? -1 : Integer.parseInt(sIndexHGNext);
        String sIndexHGPrev = (String)oWFStateData.getWert("index_prev_hg");
        this.mnIndexHGPrev = sIndexHGPrev == null ? -1 : Integer.parseInt(sIndexHGPrev);
        String sBedFilter = (String)oWFStateData.getWert("bed_filter");
        this.setBedFilter(sBedFilter != null && sBedFilter.equals("true"));
        this.mMarktDaten = new MarktDaten();
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        this.mMarktDaten.setSelPrimaerMarkt(oLoginInfo.getSettings().getEtkPrimaerMarkt());
        this.mMarktDaten.setSelSonstigeMaerkte(oLoginInfo.getSettings().getEtkSonstigeMaerkte());
        this.mMarktDaten.loadMaerkteandFillListen();
        this.bAbBandVerbaut = !oLoginInfo.getNachruestungenRelevant();
        String filter = (String)oWFStateData.getWert("filter");
        if (this.bAbBandVerbaut) {
            if (filter != null && filter.equals("true")) {
                this.bBedFilter = true;
            } else if (filter != null && filter.equals("false")) {
                this.bBedFilter = false;
            }
        }
    }

    private void initFromTeileinfo(WorkflowStateData oWFStateData) {
        this.msDialogTitel = Resource.getInstance().getSuchergebnisse();
        this.moBildtafeln = null;
        this.moBildtafelCache = null;
        this.moBildtafelnBlaettern = null;
        this.mcSelBildtafelnInit = null;
        this.moTeilenummern = (Collection)oWFStateData.getWert("teilenummern");
        this.moSelSachnummernInit = null;
        Vector<String> aMarken = new Vector<String>();
        for (SearchBTETeile.PartOrBTE part : this.moTeilenummern) {
            Vector<String> aMarkenTeil = part.getMarken();
            for (String marke : aMarkenTeil) {
                if (aMarken.contains(marke)) continue;
                aMarken.add(marke);
            }
        }
        this.setMarken(aMarken);
        this.msProduktart = GlobalObjects.getInstance().getSessionInfo().getProdukart();
        this.msKatalogumfang = GlobalObjects.getInstance().getSessionInfo().getKatalogUmfang();
    }

    public String getDialogModus() {
        return this.msDialogModus;
    }

    public String getDialogTitel() {
        return this.msDialogTitel;
    }

    public Collection<SearchBTETeile.PartOrBTE> getBildtafelCache() {
        return this.moBildtafelCache;
    }

    public void setBildtafelCache(Collection<SearchBTETeile.PartOrBTE> oBildatfeln) {
        this.moBildtafelCache = oBildatfeln;
    }

    public void setBildTafelnBlaettern(Collection<SearchBTETeile.PartOrBTE> oBildatfeln) {
        this.moBildtafelnBlaettern = oBildatfeln;
    }

    public Collection<SearchBTETeile.PartOrBTE> getBildtafelnBlaettern() {
        return this.moBildtafelnBlaettern;
    }

    public void setBildtafeln(Collection<SearchBTETeile.PartOrBTE> oBildatfeln) {
        this.moBildtafeln = oBildatfeln;
    }

    public Collection<SearchBTETeile.PartOrBTE> getBildtafeln() {
        return this.moBildtafeln;
    }

    public Collection<SearchBTETeile.PartOrBTE> getBildtafelnSortiertNachMarkt() {
        String isoPrimaerMarkt = null;
        Markt selPrioMarkt = this.getMarktDaten().getSelPrimaerMarkt();
        if (selPrioMarkt != null) {
            isoPrimaerMarkt = selPrioMarkt.getKuerzel();
        }
        Vector<SearchBTETeile.PartOrBTE> bildTafelnPrimaerMarkt = new Vector<SearchBTETeile.PartOrBTE>();
        Vector<SearchBTETeile.PartOrBTE> bildTafelnNoMarkt = new Vector<SearchBTETeile.PartOrBTE>();
        Vector<SearchBTETeile.PartOrBTE> bildTafelnWeitererMarkt = new Vector<SearchBTETeile.PartOrBTE>();
        for (SearchBTETeile.PartOrBTE bte : this.moBildtafeln) {
            if (bte.getMarktIso() == null || bte.getMarktIso().length() == 0) {
                bildTafelnNoMarkt.add(bte);
                continue;
            }
            if ((isoPrimaerMarkt == null || isoPrimaerMarkt.length() < 1) && this.getMarktDaten().getIndicesSelSonstigeMaerkte().length == 0) {
                bildTafelnWeitererMarkt.add(bte);
                continue;
            }
            if (bte.getMarktIso().equals(isoPrimaerMarkt)) {
                bildTafelnPrimaerMarkt.add(bte);
                continue;
            }
            if (this.getMarktDaten().containSelSonstigeMaerkteMarktIso(bte.getMarktIso())) {
                bildTafelnWeitererMarkt.add(bte);
                continue;
            }
            this.log.debug((Object)"*********************************************************");
            this.log.debug((Object)("*** ATTENTION-> BTE-NR.: " + bte.getIdNummer()));
            this.log.debug((Object)("*** isoPrimaerMarkt: " + isoPrimaerMarkt));
            this.log.debug((Object)("*** IndicesSelSonstigeMaerkte: " + Integer.toString(this.getMarktDaten().getIndicesSelSonstigeMaerkte().length)));
            this.log.debug((Object)("*** bte.getMarktIso(): " + bte.getMarktIso()));
            this.log.debug((Object)("*** Sonstige: " + Boolean.toString(this.getMarktDaten().containSelSonstigeMaerkteMarktIso(bte.getMarktIso()))));
            this.log.debug((Object)"*********************************************************");
        }
        bildTafelnPrimaerMarkt.addAll(bildTafelnNoMarkt);
        bildTafelnPrimaerMarkt.addAll(bildTafelnWeitererMarkt);
        return bildTafelnPrimaerMarkt;
    }

    public boolean habenBildtafelnLokaleMaerkte() {
        Collection<SearchBTETeile.PartOrBTE> lcBildtafeln = null;
        lcBildtafeln = this.getBildtafelCache() == null || this.getBildtafelCache().isEmpty() ? this.moBildtafeln : this.getBildtafelCache();
        for (SearchBTETeile.PartOrBTE bte : lcBildtafeln) {
            if (bte.getMarktIso() == null || bte.getMarktIso().length() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean habenBildtafelnNachruestungsRelevanteBedingungen() {
        if (this.getAnzBildtafeln() > 0) {
            for (SearchBTETeile.PartOrBTE oBte : this.moBildtafeln) {
                if (!oBte.isBTE() || oBte.isBteBedingungRelevant3() || !oBte.hatNachruestenRelevantBTEBedingung3()) continue;
                return true;
            }
        }
        return false;
    }

    public int getAnzBildtafeln() {
        return this.moBildtafeln == null ? 0 : this.moBildtafeln.size();
    }

    public void storeTeilenummern(Collection<SearchBTETeile.PartOrBTE> oTeilenummern) {
        this.moTeilenummern = oTeilenummern;
    }

    public Collection<SearchBTETeile.PartOrBTE> getTeilenummern() {
        return this.moTeilenummern;
    }

    public int getAnzTeilenummern() {
        return this.moTeilenummern == null ? 0 : this.moTeilenummern.size();
    }

    @Override
    public String getMarke() {
        String sMarke = super.getMarke();
        if (sMarke == null) {
            return "";
        }
        return sMarke;
    }

    public String getProduktart() {
        if (this.msProduktart == null) {
            return "";
        }
        return this.msProduktart;
    }

    public String getKatalogumfang() {
        if (this.msKatalogumfang == null) {
            return "";
        }
        return this.msKatalogumfang;
    }

    public String getFzgIdString() {
        if (this.msFzgIdString == null) {
            return "";
        }
        return this.msFzgIdString;
    }

    public String getExitAction() {
        return this.msExitAction;
    }

    public void setExitAction(String sExitAction) {
        this.msExitAction = sExitAction;
    }

    public Collection<SearchBTETeile.PartOrBTE> getSelBildtafeln() {
        return this.mcSelBildtafeln;
    }

    public void setSelBildafeln(Collection<SearchBTETeile.PartOrBTE> oSelBildtafeln) {
        this.mcSelBildtafeln = oSelBildtafeln;
    }

    public Collection<String> getSelSachnummern() {
        return this.moSelSachnummern;
    }

    public void setSelSachnummern(Collection<String> oSelSachnummern) {
        this.moSelSachnummern = oSelSachnummern;
    }

    public boolean findBildtafel(String sBtNummer) {
        if (this.mcSelBildtafelnInit == null) {
            return false;
        }
        for (SearchBTETeile.PartOrBTE oPartOrBTE : this.mcSelBildtafelnInit) {
            String sBteComp = oPartOrBTE.getIdNummer();
            if (!sBteComp.equals(sBtNummer)) continue;
            return true;
        }
        return false;
    }

    public boolean findSachnummer(String sSachnummer) {
        if (this.moSelSachnummernInit == null) {
            return false;
        }
        for (String sSachnummerComp : this.moSelSachnummernInit) {
            if (!sSachnummerComp.equals(sSachnummer)) continue;
            return true;
        }
        return false;
    }

    public int getIndexHGNext() {
        return this.mnIndexHGNext;
    }

    public int getIndexHGPrev() {
        return this.mnIndexHGPrev;
    }

    public void setIndexHGtoSearch(int nIndexHGtoSearch) {
        this.mnIndexHGtoSearch = nIndexHGtoSearch;
    }

    public int getIndexHGtoSearch() {
        return this.mnIndexHGtoSearch;
    }

    public boolean isBedFilter() {
        return this.bBedFilter;
    }

    public void setBedFilter(boolean filter) {
        this.bBedFilter = filter;
    }

    public boolean isAbBandVerbaut() {
        return this.bAbBandVerbaut;
    }

    public void setAbBandVerbaut(boolean bAbBandVerbaut) {
        this.bAbBandVerbaut = bAbBandVerbaut;
    }

    public String getSuchkriterienString(JavaSucheInfo oSucheInfo, boolean bComplete) {
        if (this.msSuchkriterienStringCompl == null) {
            this.evalSuchkriterienString(oSucheInfo);
        }
        if (bComplete) {
            return this.msSuchkriterienStringCompl;
        }
        return this.msSuchkriterienString != null ? this.msSuchkriterienString : this.msSuchkriterienStringCompl;
    }

    public String getCompleteSuchkriterienstring(JavaSucheInfo oSucheInfo) {
        if (this.msSuchkriterienStringCompl == null) {
            this.evalSuchkriterienString(oSucheInfo);
        }
        return this.msSuchkriterienStringCompl;
    }

    public boolean isSuchkriterienStringTootipNoetig(JavaSucheInfo oSucheInfo) {
        if (this.msSuchkriterienStringCompl == null) {
            this.evalSuchkriterienString(oSucheInfo);
        }
        return this.msSuchkriterienString != null;
    }

    public void evalSuchkriterienString(JavaSucheInfo oSucheInfo) {
        if (oSucheInfo == null) {
            this.msSuchkriterienStringCompl = "";
            return;
        }
        this.msSuchkriterienStringCompl = Resource.getInstance().getSuchkriterium() + ": ";
        String sSuchHG = oSucheInfo.getSuchHG();
        String sSuchFG = oSucheInfo.getSuchFG();
        if (sSuchHG != null && sSuchFG == null) {
            this.msSuchkriterienStringCompl = this.msSuchkriterienStringCompl + sSuchHG + this.getHgFgAnzeige(sSuchHG);
            return;
        }
        if (sSuchHG != null && sSuchFG != null) {
            this.msSuchkriterienStringCompl = this.msSuchkriterienStringCompl + sSuchHG + sSuchFG + this.getHgFgAnzeige(sSuchHG + sSuchFG);
            return;
        }
        String sSuchFremdeSachnummer = oSucheInfo.getSuchFremdeSachnummer();
        if (sSuchFremdeSachnummer != null) {
            return;
        }
        String sSuchSachnummer = oSucheInfo.getSuchSachnummer();
        if (sSuchSachnummer != null) {
            this.msSuchkriterienStringCompl = this.msSuchkriterienStringCompl + sSuchSachnummer;
            return;
        }
        String sSuchBenennung = oSucheInfo.getSuchBenennung();
        if (sSuchBenennung != null) {
            this.msSuchkriterienStringCompl = this.msSuchkriterienStringCompl + sSuchBenennung;
            return;
        }
        String sSuchSuchbegriff = oSucheInfo.getSuchSuchbegriff();
        if (sSuchSuchbegriff != null) {
            this.msSuchkriterienStringCompl = this.msSuchkriterienStringCompl + sSuchSuchbegriff;
            return;
        }
        String[] aHgFg = oSucheInfo.getSuchHgFgs();
        if (aHgFg != null) {
            TreeSet<String> oSortedHgFgs = new TreeSet<String>(new StringKomparator());
            Vector<String> cHelp = new Vector<String>();
            for (int i = 0; i < aHgFg.length; ++i) {
                cHelp.add(aHgFg[i]);
            }
            oSortedHgFgs.addAll(cHelp);
            int nIndex = 0;
            for (String sHgFg : oSortedHgFgs) {
                if (nIndex == 0) {
                    this.msSuchkriterienStringCompl = oSortedHgFgs.size() == 1 ? this.msSuchkriterienStringCompl + sHgFg + this.getHgFgAnzeige(sHgFg) : this.msSuchkriterienStringCompl + sHgFg + this.getHgFgAnzeige(sHgFg);
                } else {
                    if (this.getDialogModus() == "Fahrzeugteile" && nIndex == 9) {
                        this.msSuchkriterienString = this.msSuchkriterienStringCompl;
                        this.msSuchkriterienString = this.msSuchkriterienString + " >>";
                    }
                    this.msSuchkriterienStringCompl = this.msSuchkriterienStringCompl + ", " + sHgFg + this.getHgFgAnzeige(sHgFg);
                }
                ++nIndex;
            }
            this.mAnzahlSuchHgFgs = nIndex;
        }
    }

    public String getHgFgAnzeige(String sHgFg) {
        if (this.hgfgList != null) {
            for (HauptgruppeTO hauptgruppeTO : this.hgfgList) {
                if (sHgFg.length() == 2) {
                    if (!hauptgruppeTO.getHG().equals(sHgFg)) continue;
                    return " " + hauptgruppeTO.getBenennung();
                }
                String fghgbenennung = "";
                if (!hauptgruppeTO.getHG().equals(sHgFg.substring(0, 2))) continue;
                fghgbenennung = fghgbenennung + " " + hauptgruppeTO.getBenennung();
                for (FunktionsgruppeTO funktionsgruppeTO : hauptgruppeTO.getFunktionsgruppen()) {
                    if (!funktionsgruppeTO.getFg().equals(sHgFg.substring(2, 4))) continue;
                    fghgbenennung = fghgbenennung + " " + funktionsgruppeTO.getBenennung();
                }
                return fghgbenennung;
            }
        }
        return "";
    }

    public List<HauptgruppeTO> getHgFgList() {
        return this.hgfgList;
    }

    public void setHgfgList(List<HauptgruppeTO> hgfgList) {
        this.hgfgList = hgfgList;
    }

    public int getAnzahlSuchHgFgs() {
        return this.mAnzahlSuchHgFgs;
    }

    public void setAnzahlSuchHgFgs(int anzahlSuchHgFgs) {
        this.mAnzahlSuchHgFgs = anzahlSuchHgFgs;
    }

    public MarktDaten getMarktDaten() {
        return this.mMarktDaten;
    }
}

