/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.spezifteilesuche.suchergebnisse;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import webetk.app.GenericTeil;
import webetk.app.Markt;
import webetk.app.SearchBTETeile;
import webetk.communication.CommunicationException;
import webetk.communication.JavaSucheInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfMisc;
import webetk.javaclient.dialog.AbstractDlgMitTLView;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.btinfo.Bildtafelinfo;
import webetk.javaclient.dialog.extras.teileinfo.DlgTeileinfoController;
import webetk.javaclient.dialog.spezifteilesuche.suchergebnisse.BildtafelnZeile;
import webetk.javaclient.dialog.spezifteilesuche.suchergebnisse.SuchergebnisseController;
import webetk.javaclient.dialog.spezifteilesuche.suchergebnisse.SuchergebnisseModel;
import webetk.javaclient.dialog.spezifteilesuche.suchergebnisse.TeilenummernZeile;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.javaclient.menuitem.MenuItemCopySachnummer;
import webetk.javaclient.menuitem.MenuItemEinzelteile;
import webetk.javaclient.menuitem.MenuItemInterpretation;
import webetk.javaclient.menuitem.MenuItemTeileinformation;
import webetk.javaclient.menuitem.MenuItemTeileverwendungTeil;
import webetk.resources.Resource;

public class SuchergebnisseView
extends AbstractDlgMitTLView {
    private static final long serialVersionUID = -6795560641215460924L;
    private static Logger log = Logger.getLogger(SuchergebnisseView.class);
    private SuchergebnisseController controller;
    private SuchergebnisseModel model;
    private JPanel panHeader;
    private GenericTableModel tableBildtafelnModel;
    private GenericTable tableBildtafeln;
    private GenericTableModel tableTeilenummernModel;
    private GenericTable tableTeilenummern;
    private JComponent panErgebnisBildtafeln = null;
    private JPanel panErgebnisBildtafelnButton = null;
    private JPanel panErgebnisTeilenummern = null;
    private JButtonEx buttonWeiterBildtafeln = null;
    private JButtonEx buttonWeiterTeilenummern = null;
    private JButtonEx buttonHGNext = null;
    private JButtonEx buttonHGPrev = null;
    private JButtonEx buttonFiltern = null;
    private JComboBox comboMarktPrio;
    private JLabel fuerMarktPrio;
    private JPanel pHinweisZuBTE = null;
    private JTextArea taHinweisZuBTE = null;
    private boolean mbSuppressComboMarktPrioActionListener = false;
    private JList listMarktWeitere;
    private JScrollPane spMarktWeitere;
    private boolean mbSuppressListWeitereMaerkteSelectionListener = false;
    private boolean marktWeitereExpanded = false;
    private Collection<JComponent> menuEntries = new ArrayList<JComponent>();
    private JPopupMenu menuPopup = null;
    private JMenuItem menuitemTeileinformation = null;
    private JMenuItem menuitemTeileverwendungTeil = null;
    private JMenuItem menuitemInterpretation = null;
    private JMenuItem menuitemEinzelteile = null;
    private JMenuItem menuitemCopySachnummer = null;
    private boolean isHinweistextOn = false;

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    @Override
    public void initMenus() {
        this.menuPopup = new JPopupMenu();
        String sZurueckZu = null;
        if (this.model.getAnzTeilenummern() == 0 || this.model.getAnzBildtafeln() > 0) {
            sZurueckZu = "suchergebnisse_bt";
        }
        if (this.model.getAnzTeilenummern() > 0) {
            sZurueckZu = "suchergebnisse_bt_tnr";
        }
        this.menuitemTeileinformation = new MenuItemTeileinformation(this);
        this.menuPopup.add(this.menuitemTeileinformation);
        this.menuitemTeileverwendungTeil = new MenuItemTeileverwendungTeil(sZurueckZu, this.controller, this.model, this);
        if (!GlobalObjects.isScore()) {
            this.menuPopup.add(this.menuitemTeileverwendungTeil);
        }
        this.menuitemInterpretation = new MenuItemInterpretation(sZurueckZu, this.controller, this.model, this);
        this.menuPopup.add(this.menuitemInterpretation);
        this.menuitemEinzelteile = new MenuItemEinzelteile(sZurueckZu, this.controller, this.model, this);
        this.menuPopup.add(this.menuitemEinzelteile);
        this.menuPopup.addSeparator();
        this.menuitemCopySachnummer = new MenuItemCopySachnummer(this);
        this.menuPopup.add(this.menuitemCopySachnummer);
        this.menuEntries.clear();
        if (!this.model.getDialogModus().equals("ValueLine")) {
            JMenu menuZurueck = new JMenu(Resource.getInstance().getZurueck());
            menuZurueck.setBackground(UIHelper.getDarkerBackground());
            if (this.model.getDialogModus().equals("Teileinfo")) {
                AbstractAction showTeileinfoDlg = new AbstractAction(Resource.getInstance().getTeileinformation()){
                    private static final long serialVersionUID = -1041261429391377927L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        GlobalObjects.getInstance().getEtkData().resetZurueckDialoge();
                        MainView.getInstance().showDlg(DlgTeileinfoController.class, null);
                    }
                };
                JMenuItem menuTeileinfo = new JMenuItem(showTeileinfoDlg);
                menuZurueck.add(menuTeileinfo);
            } else {
                JMenuItem menuitemZurueckZuTeilesuche = new JMenuItem(Resource.getInstance().getZurTeilesuche());
                menuitemZurueckZuTeilesuche.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SuchergebnisseView.this.zurueckZurTeilesuche();
                    }
                });
                menuZurueck.add(menuitemZurueckZuTeilesuche);
            }
            this.menuEntries.add(menuZurueck);
        }
    }

    @Override
    protected void initComponents() {
        HIGConstraints c;
        super.initComponents();
        this.panHeader = this.createHeaderPanel();
        if (!GlobalObjects.getInstance().getEtkData().isScoreTeilesuche()) {
            this.initMenus();
        }
        if (this.model.habenBildtafelnNachruestungsRelevanteBedingungen()) {
            this.setHinweistextOn(true);
        } else {
            this.setHinweistextOn(false);
        }
        if (this.model.getAnzTeilenummern() == 0 || this.model.getAnzBildtafeln() > 0) {
            this.panErgebnisBildtafeln = this.createErgebnisBildtafeln(this.model.getAnzTeilenummern() > 0);
        }
        if (this.model.getAnzTeilenummern() > 0) {
            this.panErgebnisTeilenummern = this.createErgebnisTeilenummern();
        }
        if (this.isHinweistextOn()) {
            String lsHinweistext = null;
            if (this.model.isBedFilter() && this.model.isAbBandVerbaut()) {
                lsHinweistext = Resource.getInstance().getHinweisAbBand();
            } else if (!this.model.isBedFilter() && this.model.isAbBandVerbaut()) {
                lsHinweistext = Resource.getInstance().getHinweisNachruestung();
            }
            this.pHinweisZuBTE = new JPanel();
            int[] w = new int[]{20, 900, 20};
            int[] h = new int[]{5, 0, 5};
            HIGLayout layout = new HIGLayout(w, h);
            c = new HIGConstraints();
            this.pHinweisZuBTE.setLayout(layout);
            this.taHinweisZuBTE = new JTextArea(lsHinweistext);
            this.taHinweisZuBTE.setFont(UIHelper.getNormalFont());
            this.taHinweisZuBTE.setForeground(Color.red);
            this.taHinweisZuBTE.setBackground(UIHelper.getBackground());
            this.taHinweisZuBTE.setLineWrap(true);
            this.taHinweisZuBTE.setWrapStyleWord(true);
            this.pHinweisZuBTE.add((Component)this.taHinweisZuBTE, c.rc(2, 2, "tlbr"));
            this.pHinweisZuBTE.setMaximumSize(new Dimension(900, 50));
            if (this.model.isBedFilter() && this.model.habenBildtafelnNachruestungsRelevanteBedingungen()) {
                this.taHinweisZuBTE.setVisible(true);
            } else {
                this.taHinweisZuBTE.setVisible(false);
            }
        }
        int[] w = new int[]{0, 0, 0};
        int[] h = this.model.getAnzBildtafeln() > 0 && this.model.getAnzTeilenummern() > 0 ? (this.taHinweisZuBTE != null ? new int[]{0, 0, 0, 1, 0, 10, 0, 10} : new int[]{0, 0, 0, 10, 0, 10}) : (this.taHinweisZuBTE != null ? new int[]{0, 0, 0, 1, 0, 10} : new int[]{0, 0, 0, 10});
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(2, 1);
        if (this.model.getAnzBildtafeln() > 0 && this.model.getAnzTeilenummern() > 0) {
            if (this.taHinweisZuBTE != null) {
                hl.setRowWeight(3, 1);
                hl.setRowWeight(7, 1);
            } else {
                hl.setRowWeight(3, 1);
                hl.setRowWeight(5, 1);
            }
        } else {
            hl.setRowWeight(3, 1);
        }
        JPanel panel = new JPanel();
        panel.setLayout(hl);
        c = new HIGConstraints();
        panel.add((Component)this.panHeader, c.rcwh(1, 1, 3, 1, "tlbr"));
        if (this.model.getAnzBildtafeln() > 0 && this.model.getAnzTeilenummern() > 0) {
            panel.add((Component)this.panErgebnisBildtafeln, c.rc(3, 2, "tlrb"));
            if (this.taHinweisZuBTE != null) {
                panel.add((Component)this.pHinweisZuBTE, c.rc(5, 2, "tlbr"));
                panel.add((Component)this.panErgebnisTeilenummern, c.rc(7, 2, "tlbr"));
            } else {
                panel.add((Component)this.panErgebnisTeilenummern, c.rc(5, 2, "tlbr"));
            }
        }
        if (this.model.getAnzTeilenummern() == 0) {
            panel.add((Component)this.panErgebnisBildtafeln, c.rc(3, 2, "tlrb"));
            if (this.taHinweisZuBTE != null) {
                panel.add((Component)this.pHinweisZuBTE, c.rc(5, 2, "tlbr"));
            }
        }
        if (this.model.getAnzBildtafeln() == 0 && this.model.getAnzTeilenummern() > 0) {
            panel.add((Component)this.panErgebnisTeilenummern, c.rc(3, 2, "tlrb"));
        }
        JScrollPane sc = new JScrollPane(panel);
        this.setLayout(new BorderLayout());
        this.add(sc);
    }

    private HeaderPanel createHeaderPanel() {
        JavaSucheInfo oSucheInfo = GlobalObjects.getInstance().getEtkData().getSucheInfo();
        String sSuchkriterien = "";
        if (!this.model.getDialogModus().equals("ValueLine")) {
            sSuchkriterien = this.model.getCompleteSuchkriterienstring(oSucheInfo);
        }
        String smallTitle = null;
        boolean isTooltipNoetig = false;
        if (this.model.getDialogModus().equals("Fahrzeugteile") || this.model.getDialogModus().equals("ValueLine")) {
            String sFzgIdString = this.model.getFzgIdString();
            smallTitle = sFzgIdString + "   " + sSuchkriterien;
            GlobalObjects.getInstance().getLanguage().equals("ja");
            if (smallTitle.length() > SuchergebnisseView.getMaxZeichenAnzahl()) {
                smallTitle = sFzgIdString.length() > SuchergebnisseView.getMaxZeichenAnzahl() ? sFzgIdString + "..." : smallTitle.substring(0, SuchergebnisseView.getMaxZeichenAnzahl() - 3) + "...";
                isTooltipNoetig = true;
            }
        } else {
            smallTitle = sSuchkriterien;
            if (smallTitle.length() > SuchergebnisseView.getMaxZeichenAnzahl()) {
                smallTitle = smallTitle.substring(0, SuchergebnisseView.getMaxZeichenAnzahl() - 3) + "...";
                isTooltipNoetig = true;
            }
        }
        String sMarke = this.model.getMarke();
        HeaderPanel panel = new HeaderPanel(this.model.getDialogTitel(), smallTitle, ImageCache.getInstance().getHeaderIcon("tsfzgse"));
        if (isTooltipNoetig) {
            panel.setToolTipText(this.model.getCompleteSuchkriterienstring(oSucheInfo));
        }
        return panel;
    }

    private JLayeredPane createErgebnisBildtafeln(boolean teilenummernFound) {
        JLayeredPane panel = new JLayeredPane();
        TitledBorder tb = new TitledBorder(UIHelper.getStandardBorder(), Resource.getInstance().getErgebnisBildtafeln());
        tb.setTitleFont(UIHelper.getBoldFont());
        panel.setBorder(tb);
        panel.setLayout(null);
        this.listMarktWeitere = new JList();
        this.spMarktWeitere = new JScrollPane(this.listMarktWeitere);
        this.panErgebnisBildtafelnButton = this.createErgebnisBildtafelnButtons();
        panel.add((Component)this.panErgebnisBildtafelnButton, JLayeredPane.DEFAULT_LAYER);
        this.spMarktWeitere.setVisible(false);
        panel.add((Component)this.spMarktWeitere, JLayeredPane.PALETTE_LAYER);
        if (this.model.getAnzBildtafeln() > 0) {
            JScrollPane panTabelleBildtafeln = this.createTabelleBildtafeln();
            panel.add((Component)panTabelleBildtafeln, JLayeredPane.DEFAULT_LAYER);
            if (!teilenummernFound && !this.isHinweistextOn) {
                panTabelleBildtafeln.setBounds(16, 62, 986, 540);
            } else if (!teilenummernFound && this.isHinweistextOn) {
                panTabelleBildtafeln.setBounds(16, 62, 986, 500);
            } else if (teilenummernFound && !this.isHinweistextOn) {
                panTabelleBildtafeln.setBounds(16, 62, 986, 158);
            } else if (teilenummernFound && this.isHinweistextOn) {
                panTabelleBildtafeln.setBounds(16, 62, 986, 135);
            } else {
                panTabelleBildtafeln.setBounds(16, 62, 986, 500);
            }
        } else {
            JLabel lHinweis = new JLabel();
            if (this.model.getDialogModus().equals("ValueLine")) {
                lHinweis.setText(Resource.getInstance().getSucheNoResultValueLine());
            } else {
                lHinweis.setText(Resource.getInstance().getKeineDatenGefunden());
            }
            panel.add((Component)lHinweis, JLayeredPane.DEFAULT_LAYER);
            if (teilenummernFound) {
                lHinweis.setBounds(16, 62, 986, 158);
            } else {
                lHinweis.setBounds(16, 62, 986, 540);
            }
        }
        return panel;
    }

    private JPanel createErgebnisBildtafelnButtons() {
        boolean bKeineBildtafeln;
        JPanel panel = new JPanel();
        boolean bl = bKeineBildtafeln = this.model.getAnzBildtafeln() == 0;
        if (!bKeineBildtafeln) {
            this.buttonWeiterBildtafeln = new JButtonEx();
            this.buttonWeiterBildtafeln.setIcon(ImageCache.getInstance().getIcon("arrw04_10b.gif"));
            this.buttonWeiterBildtafeln.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SuchergebnisseView.this.anzeigenBildtafeln();
                }
            });
        }
        this.buttonHGPrev = new JButtonEx(Resource.getInstance().getHg(), ImageCache.getInstance().getIcon("scrollhome.gif"));
        this.buttonHGPrev.setEnabled(this.model.getIndexHGPrev() != -1);
        this.buttonHGPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SuchergebnisseView.this.suchenHGPrev();
            }
        });
        this.buttonHGNext = new JButtonEx(Resource.getInstance().getHg(), ImageCache.getInstance().getIcon("scrollend.gif"));
        this.buttonHGNext.setHorizontalTextPosition(2);
        this.buttonHGNext.setEnabled(this.model.getIndexHGNext() != -1);
        this.buttonHGNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SuchergebnisseView.this.suchenHGNext();
            }
        });
        this.buttonFiltern = new JButtonEx(ImageCache.getInstance().getIcon("filtern_BteBed_dis.gif"));
        this.buttonFiltern.setText(Resource.getInstance().getFiltern());
        this.buttonFiltern.setHorizontalTextPosition(2);
        this.setButtonFilternStatus();
        this.buttonFiltern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SuchergebnisseView.this.filternHG();
            }
        });
        if (this.isHinweistextOn() && this.model.isBedFilter() && this.model.isAbBandVerbaut()) {
            this.buttonFiltern.setVisible(true);
        } else if (this.isHinweistextOn() && !this.model.isBedFilter() && this.model.isAbBandVerbaut()) {
            this.buttonFiltern.setVisible(true);
        } else {
            this.buttonFiltern.setVisible(false);
        }
        int[] w = new int[]{0, 5, 0, 5, 0, 5, 0, 5, 0};
        int[] h = new int[]{0};
        HIGLayout layout = new HIGLayout(w, h);
        layout.setColumnWeight(9, 1);
        HIGConstraints c = new HIGConstraints();
        panel.setLayout(layout);
        panel.add((Component)this.buttonHGPrev, c.rc(1, 1, "lt"));
        panel.add((Component)this.buttonHGNext, c.rc(1, 3, "lt"));
        panel.add((Component)this.buttonFiltern, c.rc(1, 5, "lt"));
        if (this.model.habenBildtafelnLokaleMaerkte()) {
            JPanel cMaerkte = this.createMarktAuswahl();
            panel.add((Component)cMaerkte, c.rc(1, 7, "lt"));
        }
        if (!bKeineBildtafeln) {
            panel.add((Component)this.buttonWeiterBildtafeln, c.rc(1, 9, "rt"));
        }
        panel.setBounds(16, 27, 985, 35);
        return panel;
    }

    private JPanel createMarktAuswahl() {
        this.fuerMarktPrio = new JLabel(Resource.getInstance().getFuerMarktPrio());
        this.comboMarktPrio = new JComboBox();
        this.comboMarktPrio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SuchergebnisseView.this.mbSuppressComboMarktPrioActionListener) {
                    return;
                }
                Markt newPrioMarkt = (Markt)SuchergebnisseView.this.comboMarktPrio.getSelectedItem();
                SuchergebnisseView.this.model.getMarktDaten().changePrioMarkt(newPrioMarkt);
                SuchergebnisseView.this.updateMaerkte();
                SuchergebnisseView.this.setButtonFilternLayout();
                Collection<SearchBTETeile.PartOrBTE> cCache = SuchergebnisseView.this.model.getBildtafelCache();
                if (cCache != null && cCache.size() > 0) {
                    SuchergebnisseView.this.model.setBildtafeln(cCache);
                }
                SuchergebnisseView.this.updateBildtafeln();
            }
        });
        JLabel weitereMaerkte = new JLabel(Resource.getInstance().getWeitereMaerkte());
        JLabel marktWeiterePfeilAuf = new JLabel(ImageCache.getInstance().getIcon("aufklappen.gif"));
        marktWeiterePfeilAuf.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                SuchergebnisseView.this.showListMarktWeitere(true);
            }
        });
        JLabel marktWeiterePfeilZu = new JLabel(ImageCache.getInstance().getIcon("zuklappen.gif"));
        marktWeiterePfeilZu.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                SuchergebnisseView.this.showListMarktWeitere(false);
            }
        });
        this.listMarktWeitere.setSelectionMode(2);
        this.listMarktWeitere.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                if (SuchergebnisseView.this.mbSuppressListWeitereMaerkteSelectionListener) {
                    return;
                }
                int[] newSelInd = SuchergebnisseView.this.listMarktWeitere.getSelectedIndices();
                SuchergebnisseView.this.model.getMarktDaten().setSelSonstigeMaerkte(newSelInd);
                SuchergebnisseView.this.setButtonFilternLayout();
                SuchergebnisseView.this.updateBildtafeln();
            }
        });
        JPanel panel = new JPanel();
        int[] w = new int[]{0, 5, 0, 52, 0, 5, 0};
        int[] h = new int[]{0, 0};
        HIGLayout layout = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        layout.setColumnWeight(7, 1);
        panel.setLayout(layout);
        panel.add((Component)this.fuerMarktPrio, c.rc(1, 1, "l"));
        panel.add((Component)this.comboMarktPrio, c.rc(1, 3, "l"));
        panel.add((Component)weitereMaerkte, c.rc(1, 5, "l"));
        if (this.marktWeitereExpanded) {
            this.spMarktWeitere.setVisible(true);
            this.listMarktWeitere.setVisible(true);
            panel.add((Component)marktWeiterePfeilZu, c.rc(1, 7, "l"));
        } else {
            this.spMarktWeitere.setVisible(false);
            this.listMarktWeitere.setVisible(false);
            panel.add((Component)marktWeiterePfeilAuf, c.rc(1, 7, "l"));
        }
        boolean isUSETK = this.controller.isUSETK();
        if (isUSETK) {
            panel.setVisible(false);
        }
        return panel;
    }

    private void showListMarktWeitere(boolean show) {
        this.marktWeitereExpanded = show;
        Collection<SearchBTETeile.PartOrBTE> cBildtafeln = this.model.getBildtafelCache();
        this.model.setBildtafeln(cBildtafeln);
        this.panErgebnisBildtafeln.remove(this.panErgebnisBildtafelnButton);
        this.panErgebnisBildtafelnButton = this.createErgebnisBildtafelnButtons();
        this.panErgebnisBildtafeln.add((Component)this.panErgebnisBildtafelnButton, JLayeredPane.DEFAULT_LAYER);
        this.update();
    }

    private JPanel createErgebnisTeilenummern() {
        TitledPanel panel = new TitledPanel(Resource.getInstance().getErgebnisTeilenummern(), new BorderLayout());
        this.buttonWeiterTeilenummern = new JButtonEx();
        this.buttonWeiterTeilenummern.setIcon(ImageCache.getInstance().getIcon("arrw04_10b.gif"));
        this.buttonWeiterTeilenummern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SuchergebnisseView.this.suchenTeilenummern();
            }
        });
        this.buttonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuchergebnisseView.this.uebernehmenInTeileliste();
            }
        });
        JPanel panTeileliste = new JPanel();
        int[] w_teilelistePanel = new int[]{0, 0, 10, 0, 10, 0, 10, 0, 10, 0};
        int[] h_teilelistePanel = new int[]{5, 0, 5};
        HIGLayout layout_teilelistePanel = new HIGLayout(w_teilelistePanel, h_teilelistePanel);
        layout_teilelistePanel.setColumnWeight(9, 1);
        HIGConstraints c = new HIGConstraints();
        panTeileliste.setLayout(layout_teilelistePanel);
        panTeileliste.add((Component)this.labTeileliste, c.rc(2, 2, "r"));
        panTeileliste.add((Component)this.comboTeileliste, c.rc(2, 4));
        panTeileliste.add((Component)this.buttonUebernehmen, c.rc(2, 6, "l"));
        panTeileliste.add((Component)this.buttonUeberpruefen, c.rc(2, 8, "l"));
        if (!this.model.getDialogModus().equals("Teileinfo")) {
            panTeileliste.add((Component)this.buttonWeiterTeilenummern, c.rc(2, 10, "r"));
        }
        int[] w = new int[]{5, 0, 5};
        int[] h = new int[]{5, 0, 5, 0, 5};
        HIGLayout layout = new HIGLayout(w, h);
        layout.setColumnWeight(2, 1);
        layout.setRowWeight(4, 1);
        panel.setLayout(layout);
        panel.add((Component)panTeileliste, c.rc(2, 2, "lr"));
        panel.add((Component)this.createTabelleTeilenummern(), c.rc(4, 2));
        return panel;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Iterator<JComponent> getMenus() {
        return this.menuEntries.iterator();
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        super.init(oDlgModel, oDlgController);
        this.model = (SuchergebnisseModel)oDlgModel;
        this.controller = (SuchergebnisseController)oDlgController;
        this.initComponents();
        if (this.model.getAnzTeilenummern() > 0) {
            this.controller.loadTeilelistenIDs();
        }
        this.update();
    }

    private JScrollPane createTabelleBildtafeln() {
        TableConfiguration tableBildtafelnConfig = new TableConfiguration();
        tableBildtafelnConfig.addColumn("", 0, JLabel.class, false, BildtafelnZeile.getHasInfoRenderer());
        tableBildtafelnConfig.addColumn(Resource.getInstance().getBtNummer(), 0, false, "XX_XXXXYY");
        tableBildtafelnConfig.addColumn(Resource.getInstance().getBtUeberschrift(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableBildtafelnConfig.addColumn("", 0, true, "XXX");
        tableBildtafelnConfig.setUsePrototypeIcons(false);
        this.tableBildtafelnModel = new GenericTableModel(tableBildtafelnConfig);
        this.tableBildtafeln = new GenericTable(this.tableBildtafelnModel);
        this.tableBildtafeln.getTable().getColumnModel().getColumn(0).setMinWidth(20);
        this.tableBildtafeln.getTable().getColumnModel().getColumn(0).setMaxWidth(20);
        this.tableBildtafeln.getTable().getColumnModel().getColumn(0).setWidth(20);
        GenericTableMouseEventAdapter listenerBtInfo = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                SuchergebnisseView.this.showBildtafelinfo(SuchergebnisseView.this.tableBildtafeln.getTable().getSelectedRow());
            }
        };
        this.tableBildtafeln.addMouseListener(listenerBtInfo, 0);
        GenericTableMouseEventAdapter listenerTable = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
                SuchergebnisseView.this.anzeigenBildtafeln();
            }
        };
        this.tableBildtafeln.addMouseListener(listenerTable, 1);
        this.tableBildtafeln.addMouseListener(listenerTable, 2);
        JScrollPane scrollPane = this.tableBildtafeln.getScrollPane();
        return scrollPane;
    }

    private JScrollPane createTabelleTeilenummern() {
        TableConfiguration tableTeilenummernConfig = new TableConfiguration();
        tableTeilenummernConfig.addIconColumn("info.gif", Resource.getInstance().getTeileinformation());
        tableTeilenummernConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "52 10 1 942 724YY");
        tableTeilenummernConfig.addColumn(Resource.getInstance().getTeilebenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableTeilenummernConfig.addColumn(Resource.getInstance().getZusatz(), 2, true, "XXXXXXXXXXXXXXXYYYY");
        tableTeilenummernConfig.addColumn(Resource.getInstance().getKommentar(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableTeilenummernConfig.setUsePrototypeIcons(true);
        this.tableTeilenummernModel = new GenericTableModel(tableTeilenummernConfig);
        this.tableTeilenummern = new GenericTable(this.tableTeilenummernModel);
        this.tableTeilenummern.getTable().getColumnModel().getColumn(0).setMinWidth(20);
        this.tableTeilenummern.getTable().getColumnModel().getColumn(0).setMaxWidth(20);
        this.tableTeilenummern.getTable().getColumnModel().getColumn(0).setWidth(20);
        GenericTableMouseEventAdapter listenerTeileInfo = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                ((MenuItemTeileinformation)SuchergebnisseView.this.menuitemTeileinformation).showTeileinfo();
            }
        };
        this.tableTeilenummern.addMouseListener(listenerTeileInfo, 0);
        GenericTableMouseEventAdapter listenerTable = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
                SuchergebnisseView.this.suchenTeilenummern();
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (SuchergebnisseView.this.tableTeilenummern.getTable().getSelectedRowCount() != 1) {
                    return;
                }
                SuchergebnisseView.this.menuitemTeileverwendungTeil.setEnabled(true);
                SuchergebnisseView.this.menuitemEinzelteile.setEnabled(((MenuItemEinzelteile)SuchergebnisseView.this.menuitemEinzelteile).hatEinzelteile());
                SuchergebnisseView.this.menuitemInterpretation.setEnabled(((MenuItemInterpretation)SuchergebnisseView.this.menuitemInterpretation).hatInterpretation());
                SuchergebnisseView.this.menuPopup.show(SuchergebnisseView.this.tableTeilenummern.getTable(), evt.getX(), evt.getY());
            }
        };
        this.tableTeilenummern.addMouseListener(listenerTable, 1);
        this.tableTeilenummern.addMouseListener(listenerTable, 2);
        this.tableTeilenummern.addMouseListener(listenerTable, 3);
        this.tableTeilenummern.addMouseListener(listenerTable, 4);
        JScrollPane scrollPane = this.tableTeilenummern.getScrollPane();
        return scrollPane;
    }

    @Override
    public void update() {
        this.updateMaerkte();
        this.updateBildtafeln();
        this.updateTeilenummern();
    }

    private void updateMaerkte() {
        if (this.model.getMarktDaten() == null) {
            return;
        }
        if (this.comboMarktPrio != null) {
            this.mbSuppressComboMarktPrioActionListener = true;
            this.comboMarktPrio.removeAllItems();
            for (Markt markt : this.model.getMarktDaten().getAuswahlPrimaerMarkt()) {
                this.comboMarktPrio.addItem(markt);
            }
            Markt selPrioMarkt = this.model.getMarktDaten().getSelPrimaerMarkt();
            if (selPrioMarkt != null) {
                this.comboMarktPrio.setSelectedItem(selPrioMarkt);
            } else {
                this.comboMarktPrio.setSelectedIndex(0);
            }
            this.mbSuppressComboMarktPrioActionListener = false;
        }
        if (this.listMarktWeitere != null) {
            this.mbSuppressListWeitereMaerkteSelectionListener = true;
            this.listMarktWeitere.setListData(this.model.getMarktDaten().getAuswahlSonstigeMaerkte());
            int[] aSelIndizes = this.model.getMarktDaten().getIndicesSelSonstigeMaerkte();
            if (aSelIndizes != null) {
                this.listMarktWeitere.setSelectedIndices(aSelIndizes);
            }
            this.mbSuppressListWeitereMaerkteSelectionListener = false;
        }
        if (this.comboMarktPrio != null && this.spMarktWeitere != null) {
            Dimension dimMarktPrio = this.comboMarktPrio.getPreferredSize();
            Dimension dimLabel = this.fuerMarktPrio.getPreferredSize();
            int xMarktWeitere = 292 + dimLabel.width + dimMarktPrio.width;
            this.spMarktWeitere.setBounds(xMarktWeitere, 52, dimMarktPrio.width, 160);
        }
    }

    private void updateBildtafeln() {
        log.info((Object)"updateBildtafeln");
        if (this.tableBildtafelnModel != null) {
            this.tableBildtafelnModel.removeAllRows();
        }
        int nIndexBildtafelSelMin = -1;
        if (this.model.getAnzBildtafeln() > 0) {
            boolean bIsCacheToFill;
            String dialogModus = this.model.getDialogModus();
            boolean bIsBedFilter = this.model.isBedFilter();
            boolean bIsAbBandVerbaut = this.model.isAbBandVerbaut();
            boolean bIsIGDOM = GlobalObjects.getInstance().getSessionInfo().getIGDOMVerwenden();
            boolean bIsContinue = false;
            Vector<SearchBTETeile.PartOrBTE> lBildtafeln = new Vector<SearchBTETeile.PartOrBTE>();
            Vector<SearchBTETeile.PartOrBTE> lBildtafelnBlaettern = new Vector<SearchBTETeile.PartOrBTE>();
            Collection<SearchBTETeile.PartOrBTE> cBildtafeln = this.model.getBildtafelnSortiertNachMarkt();
            Iterator<SearchBTETeile.PartOrBTE> iterator = cBildtafeln.iterator();
            boolean bl = bIsCacheToFill = this.model.getBildtafelCache() == null;
            if (bIsCacheToFill) {
                this.model.setBildtafelCache(this.model.getBildtafeln());
            }
            int nIndex = 0;
            while (iterator.hasNext()) {
                SearchBTETeile.PartOrBTE oBte = iterator.next();
                String sBtNummer = oBte.getIdNummer();
                String sBenennung = oBte.getBenennung();
                String sMarkt = oBte.getMarktIso();
                if (sMarkt == null) {
                    sMarkt = "";
                }
                boolean bHasBtInfo = oBte.hasInfo();
                boolean bIsBteRelevant = oBte.getBteBedingungRelevant();
                boolean bIsBteRelevant3 = oBte.isBteBedingungRelevant3();
                boolean bHatBteNachruestungsRelevant3 = oBte.hatNachruestenRelevantBTEBedingung3();
                log.debug((Object)("*** model.isBedFilter()\t: " + this.model.isBedFilter()));
                log.debug((Object)("*** Filter anwenden    \t: " + Boolean.toString(bIsBedFilter)));
                log.debug((Object)("*** IGD-DOM aktiv      \t: " + Boolean.toString(bIsIGDOM)));
                log.debug((Object)("*** Dialog-Modus \t\t\t\t: " + dialogModus));
                log.debug((Object)("*** BTE-Nr.: " + sBtNummer + " oBte.getBteBedingungRelevant(): " + Boolean.toString(bIsBteRelevant) + " oBte.getBteBedingungRelevant3(): " + Boolean.toString(bIsBteRelevant3)));
                log.debug((Object)("*** BTE-Nr.: " + sBtNummer + " oBte.hatNachruestenRelevantBedingung3(): " + oBte.hatNachruestenRelevantBTEBedingung3()));
                if (System.getProperty("debugETK") != null && System.getProperty("debugETK").equals("true")) {
                    log.debug((Object)("*** BTE Bedingung: " + (oBte.getBteBedingung() != null ? oBte.getBteBedingung().toString() : "null")));
                    log.debug((Object)("*** Ergebnis: " + (oBte.getErgebnis() != null ? oBte.getErgebnis().toString() : "null")));
                    log.debug((Object)("*** BTE Bedingung3: " + (oBte.getBedingungen3() != null ? oBte.getBedingungen3().toString() : "null")));
                    log.debug((Object)("*** BTE \u00dcberBedingung3: " + (oBte.getUeberBedingungen3() != null ? oBte.getUeberBedingungen3().toString() : "null")));
                    log.debug((Object)("*** Ergebnis3: " + (oBte.getErgebnis3() != null ? oBte.getErgebnis3().toString() : "null")));
                }
                if (bIsBedFilter && !bIsBteRelevant3 && bHatBteNachruestungsRelevant3) {
                    log.debug((Object)("===>>> BTE-Nr.: " + sBtNummer + "<<<=== oBte.getBteBedingungRelevant3(): " + Boolean.toString(bIsBteRelevant3) + " oBte.hatNachruestenRelevantBedingung3(): " + Boolean.toString(bHatBteNachruestungsRelevant3)));
                }
                if (bIsBedFilter && (!bIsBedFilter || !bIsBteRelevant3) && (!bIsBedFilter || bIsBteRelevant3 || !bHatBteNachruestungsRelevant3)) continue;
                boolean bRotMarkieren = false;
                if (this.buttonFiltern != null) {
                    boolean bl2 = bRotMarkieren = !bIsBteRelevant3 && bHatBteNachruestungsRelevant3;
                    if (this.taHinweisZuBTE != null && bRotMarkieren) {
                        this.taHinweisZuBTE.setVisible(true);
                    }
                }
                oBte.setIsRotMarkiert(bRotMarkieren);
                if (bIsIGDOM && bIsAbBandVerbaut && !bIsBedFilter && !bIsBteRelevant3 && !bHatBteNachruestungsRelevant3) continue;
                if (bIsAbBandVerbaut && bRotMarkieren && bIsBedFilter) {
                    this.taHinweisZuBTE.setText(Resource.getInstance().getHinweisAbBand());
                    this.taHinweisZuBTE.setForeground(Color.red);
                    this.taHinweisZuBTE.setVisible(true);
                    bIsContinue = true;
                    continue;
                }
                if (!bIsContinue && this.taHinweisZuBTE != null) {
                    this.taHinweisZuBTE.setText(Resource.getInstance().getHinweisNachruestung());
                    this.taHinweisZuBTE.setForeground(Color.red);
                    this.taHinweisZuBTE.setVisible(true);
                }
                lBildtafelnBlaettern.add(oBte);
                this.tableBildtafelnModel.addRow(new BildtafelnZeile(bHasBtInfo, sBtNummer, sBenennung, sMarkt, oBte, bRotMarkieren));
                if (this.model.findBildtafel(sBtNummer)) {
                    log.info((Object)("sBtNummer" + sBtNummer));
                    this.tableBildtafeln.getTable().addRowSelectionInterval(nIndex, nIndex);
                    if (nIndexBildtafelSelMin == -1 || nIndex < nIndexBildtafelSelMin) {
                        nIndexBildtafelSelMin = nIndex;
                    }
                }
                ++nIndex;
                lBildtafeln.add(oBte);
            }
            this.panErgebnisBildtafeln.repaint();
            this.model.setBildtafeln(lBildtafeln);
            this.model.setBildTafelnBlaettern(lBildtafelnBlaettern);
        }
        if (nIndexBildtafelSelMin != -1) {
            JScrollPane sc = this.tableBildtafeln.getScrollPane();
            int nBildtafelRowShowVisible = nIndexBildtafelSelMin <= 2 ? 0 : nIndexBildtafelSelMin - 2;
            Rectangle rect = this.tableBildtafeln.getTable().getCellRect(nBildtafelRowShowVisible, 0, true);
            sc.getViewport().setViewPosition(rect.getLocation());
        }
    }

    private void updateTeilenummern() {
        if (this.tableTeilenummernModel != null) {
            this.tableTeilenummernModel.removeAllRows();
        }
        int nIndexTeilenummerSelMin = -1;
        Collection<SearchBTETeile.PartOrBTE> cTeilenummern = this.model.getTeilenummern();
        if (cTeilenummern != null && cTeilenummern.size() > 0) {
            Iterator<SearchBTETeile.PartOrBTE> iterator = cTeilenummern.iterator();
            int nIndex = 0;
            while (iterator.hasNext()) {
                SearchBTETeile.PartOrBTE oTeil = iterator.next();
                String sTeilenummer = oTeil.getIdNummer();
                String sBenennung = oTeil.getBenennung();
                String sZusatz = oTeil.getZusatz();
                String sBenennungKommentar = oTeil.getBenennungKommentar();
                String sSachnummer = "";
                if (sTeilenummer.length() == 11) {
                    sSachnummer = sTeilenummer.substring(4, 11);
                    sTeilenummer = sTeilenummer.substring(0, 2) + " " + sTeilenummer.substring(2, 4) + " " + sTeilenummer.substring(4, 5) + " " + sTeilenummer.substring(5, 8) + " " + sTeilenummer.substring(8, 11);
                }
                this.tableTeilenummernModel.addRow(new TeilenummernZeile(sTeilenummer, sBenennung, sZusatz, sBenennungKommentar));
                if (this.model.findSachnummer(sSachnummer)) {
                    this.tableTeilenummern.getTable().addRowSelectionInterval(nIndex, nIndex);
                    if (nIndexTeilenummerSelMin == -1 || nIndex < nIndexTeilenummerSelMin) {
                        nIndexTeilenummerSelMin = nIndex;
                    }
                }
                ++nIndex;
            }
            if (nIndexTeilenummerSelMin != -1) {
                JScrollPane sc = this.tableTeilenummern.getScrollPane();
                int nTeilenummerRowShowVisible = nIndexTeilenummerSelMin <= 2 ? 0 : nIndexTeilenummerSelMin - 2;
                Rectangle rect = this.tableTeilenummern.getTable().getCellRect(nTeilenummerRowShowVisible, 0, true);
                sc.getViewport().setViewPosition(rect.getLocation());
            }
            this.updateTeilelisten();
            this.panErgebnisTeilenummern.repaint();
        }
    }

    private void uebernehmenInTeileliste() {
        Vector<GenericTeil> cTeile = new Vector<GenericTeil>();
        GenericTable jTable = this.tableTeilenummern.getTable();
        int nCountSelectedRows = jTable.getSelectedRowCount();
        if (nCountSelectedRows == 0) {
            return;
        }
        int[] selectedRows = jTable.getSelectedRows();
        for (int i = 0; i < nCountSelectedRows; ++i) {
            int nRow = selectedRows[i];
            GenericTeil t = new GenericTeil();
            TeilenummernZeile oZeile = (TeilenummernZeile)this.tableTeilenummernModel.getRow(nRow);
            t.setSachnummer(oZeile.getSachnummer());
            String HGUG = oZeile.getTeilenummer().trim().replaceAll(" +", "").substring(0, 4);
            t.setHG(HGUG.substring(0, 2));
            t.setUG(HGUG.substring(2, 4));
            t.setBenennung(oZeile.getBenennung());
            cTeile.add(t);
        }
        this.uebernehmenInTeileliste(cTeile, false);
    }

    private void showBildtafelinfo(int nRow) {
        BildtafelnZeile oZeile = (BildtafelnZeile)this.tableBildtafelnModel.getRow(nRow);
        if (!oZeile.hasInfo()) {
            return;
        }
        String sBildtafelnummer = (String)this.tableBildtafelnModel.getValueAt(nRow, 1);
        String sProduktart = GlobalObjects.getInstance().getEtkData().getSucheInfo().getProduktart();
        Bildtafelinfo dlgBildtafelinfo = new Bildtafelinfo((Frame)MainView.getInstance(), sBildtafelnummer, sProduktart);
        dlgBildtafelinfo.setVisible(true);
    }

    private void anzeigenBildtafeln() {
        Vector<SearchBTETeile.PartOrBTE> cBildtafeln = new Vector<SearchBTETeile.PartOrBTE>();
        GenericTable jTable = this.tableBildtafeln.getTable();
        int nCountSelectedRows = jTable.getSelectedRowCount();
        if (nCountSelectedRows == 0) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getHinweisKeineBtes(), this.model.getDialogTitel(), 0);
            return;
        }
        int[] selectedRows = jTable.getSelectedRows();
        BildtafelnZeile oZeile = null;
        for (int i = 0; i < nCountSelectedRows; ++i) {
            int nRow = selectedRows[i];
            oZeile = (BildtafelnZeile)this.tableBildtafelnModel.getRow(nRow);
            SearchBTETeile.PartOrBTE oBte = oZeile.getBte();
            cBildtafeln.add(oBte);
        }
        this.model.setSelBildafeln(cBildtafeln);
        if (this.model.getAnzTeilenummern() > 0) {
            this.model.setExitAction("weiterbildtafeln_step1");
        } else {
            this.model.setExitAction("weiterbildtafeln_step2");
        }
        this.controller.notifyAllExitListeners();
    }

    private void suchenTeilenummern() {
        ArrayList<String> cSachnummern = new ArrayList<String>();
        GenericTable jTable = this.tableTeilenummern.getTable();
        int nCountSelectedRows = jTable.getSelectedRowCount();
        if (nCountSelectedRows == 0) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getHinweisKeineTeile(), this.model.getDialogTitel(), 0);
            return;
        }
        int[] selectedRows = jTable.getSelectedRows();
        for (int i = 0; i < nCountSelectedRows; ++i) {
            int nRow = selectedRows[i];
            TeilenummernZeile oZeile = (TeilenummernZeile)this.tableTeilenummernModel.getRow(nRow);
            String sSachnummer = oZeile.getSachnummer();
            cSachnummern.add(sSachnummer);
        }
        if (!this.controller.performSearchSachnummern(cSachnummern)) {
            return;
        }
        this.model.setSelSachnummern(cSachnummern);
        this.model.setExitAction("weitersachnummern_step1");
        this.controller.notifyAllExitListeners();
    }

    public void zurueckZurTeilesuche() {
        this.model.setExitAction("zurueckzuteilesuche");
        this.controller.notifyAllExitListeners();
    }

    public void suchenHGPrev() {
        this.model.setExitAction("search_hg_at_index");
        this.model.setIndexHGtoSearch(this.model.getIndexHGPrev());
        boolean isBedFilter = this.model.isBedFilter();
        boolean isAbBandVerbaut = this.model.isAbBandVerbaut();
        if (isAbBandVerbaut && !isBedFilter) {
            this.model.setBedFilter(true);
        }
        this.controller.notifyAllExitListeners();
    }

    public void suchenHGNext() {
        this.model.setExitAction("search_hg_at_index");
        this.model.setIndexHGtoSearch(this.model.getIndexHGNext());
        boolean isBedFilter = this.model.isBedFilter();
        boolean isAbBandVerbaut = this.model.isAbBandVerbaut();
        if (isAbBandVerbaut && !isBedFilter) {
            this.model.setBedFilter(true);
        }
        this.controller.notifyAllExitListeners();
    }

    public void filternHG() {
        this.model.setBedFilter(!this.model.isBedFilter());
        Collection<SearchBTETeile.PartOrBTE> cache = this.model.getBildtafelCache();
        Vector<SearchBTETeile.PartOrBTE> bildtafeln = new Vector<SearchBTETeile.PartOrBTE>();
        for (SearchBTETeile.PartOrBTE bte : cache) {
            bildtafeln.add(bte);
        }
        this.model.setBildtafeln(bildtafeln);
        this.setButtonFilternLayout();
        this.update();
    }

    public void setButtonFilternLayout() {
        if (this.model.isBedFilter()) {
            this.buttonFiltern.setIcon(ImageCache.getInstance().getIcon("filtern_BteBed_dis.gif"));
            this.buttonFiltern.updateUI();
        } else {
            this.buttonFiltern.setIcon(ImageCache.getInstance().getIcon("filtern_BteBed_en.gif"));
            this.buttonFiltern.updateUI();
        }
    }

    private void setButtonFilternStatus() {
        if (GlobalObjects.getInstance().isIGDOMAktiv() && GlobalObjects.getInstance().getSessionInfo().getIGDOMVerwenden() && GlobalObjects.getInstance().getSessionInfo().getAktuelleSchnittstelle().equals("igdom") && GlobalObjects.getInstance().getFzgIdInfo() != null && GlobalObjects.getInstance().getFzgIdInfo().getFahrgestellNr() != null && GlobalObjects.getInstance().getEtkData().getFzgSucheInfo() != null && GlobalObjects.getInstance().getEtkData().getFzgSucheInfo().getBedingungsMenge().hatSchnittstellenBedingungen()) {
            if (this.model.getDialogModus().equals("Fahrzeugteile")) {
                if (this.getAusweisungenElementeErmitteln()) {
                    this.model.setBedFilter(this.model.isBedFilter());
                    if (this.model.isAbBandVerbaut() && this.model.isBedFilter() && this.model.habenBildtafelnNachruestungsRelevanteBedingungen()) {
                        this.buttonFiltern.setEnabled(true);
                        this.buttonFiltern.setVisible(true);
                    } else if (this.model.isAbBandVerbaut() && this.model.isBedFilter() && !this.model.habenBildtafelnNachruestungsRelevanteBedingungen()) {
                        this.buttonFiltern.setEnabled(true);
                        this.buttonFiltern.setVisible(false);
                    } else if (this.model.isAbBandVerbaut() && !this.model.isBedFilter() && this.model.habenBildtafelnNachruestungsRelevanteBedingungen()) {
                        this.buttonFiltern.setEnabled(true);
                        this.buttonFiltern.setVisible(true);
                    } else {
                        this.buttonFiltern.setEnabled(false);
                        this.buttonFiltern.setVisible(false);
                    }
                } else {
                    this.model.setBedFilter(false);
                    this.buttonFiltern.setEnabled(true);
                    this.buttonFiltern.setVisible(false);
                }
            } else {
                this.model.setBedFilter(false);
                this.buttonFiltern.setEnabled(false);
                this.buttonFiltern.setVisible(false);
            }
        } else {
            this.model.setBedFilter(false);
            this.buttonFiltern.setEnabled(false);
            this.buttonFiltern.setVisible(false);
        }
        this.setButtonFilternLayout();
    }

    private boolean getAusweisungenElementeErmitteln() {
        TrfMisc misc = new TrfMisc(null);
        boolean bAusweisungenElemente = false;
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(misc, Command.HOLEN_FLAG_AUSWEISUNG_ELEMENTE);
            String sAusweisungenElemente = (String)misc.getValue("flagAusweisungElementeErmitteln");
            bAusweisungenElemente = sAusweisungenElemente.equals("true");
        }
        catch (CommunicationException e) {
            log.error((Object)"Kommunikationsfehler beim HOLEN_FLAG_AUSWEISUNG_ELEMENTE am Server!", (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage());
        }
        if (misc.getError() != null) {
            log.error((Object)"Sonstiger Fehler beim HOLEN_FLAG_AUSWEISUNG_ELEMENTE Server!", (Throwable)misc.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), misc.getError().getMessage());
        }
        return bAusweisungenElemente;
    }

    @Override
    public HashMap<String, Object> getInfoZurSachnummer() {
        int nRow = this.tableTeilenummern.getTable().getSelectedRow();
        if (!(this.tableTeilenummernModel.getRow(nRow) instanceof TeilenummernZeile)) {
            return null;
        }
        TeilenummernZeile oZeile = (TeilenummernZeile)this.tableTeilenummernModel.getRow(nRow);
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        String sSachnummer = oZeile.getSachnummer();
        String sTeilenummer = oZeile.getTeilenummer();
        String sBenennungZusatz = oZeile.getBenennungZusatz();
        String sMarke = this.model.getMarke();
        String sProduktart = this.model.getProduktart();
        String sKatalogumfang = this.model.getKatalogumfang();
        oHashMap.put("sachnummer", sSachnummer);
        oHashMap.put("teilenummer", sTeilenummer);
        oHashMap.put("benennung_zusatz", sBenennungZusatz);
        oHashMap.put("marke", sMarke);
        oHashMap.put("produktart", sProduktart);
        oHashMap.put("katalogumfang", sKatalogumfang);
        return oHashMap;
    }

    public static int getMaxZeichenAnzahl() {
        int maxZeichenAnzahl = 115;
        if (GlobalObjects.getInstance().getLanguage().equals("ja") || GlobalObjects.getInstance().getLanguage().equals("zh")) {
            maxZeichenAnzahl = 95;
        } else if (GlobalObjects.getInstance().getLanguage().equals("ko") || GlobalObjects.getInstance().getLanguage().equals("el") || GlobalObjects.getInstance().getLanguage().equals("th")) {
            maxZeichenAnzahl = 105;
        }
        return maxZeichenAnzahl;
    }

    public void setHinweistextOn(boolean isHinweistextOn) {
        this.isHinweistextOn = isHinweistextOn;
    }

    public boolean isHinweistextOn() {
        return this.isHinweistextOn;
    }
}

