/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.steckerAnschlagteile;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogView;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.app.SearchBTETeile;
import webetk.app.aspg.Teil;
import webetk.app.aspg.TeilHelper;
import webetk.app.teileinfo.Teileinfo;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.communication.CommunicationException;
import webetk.communication.JavaSucheInfo;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.AbstractDlgMitTLController;
import webetk.javaclient.dialog.AbstractDlgMitTLView;
import webetk.javaclient.dialog.bte.BTEView;
import webetk.javaclient.dialog.extras.teileinfo.DlgTeileinfoKleinController;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteController;
import webetk.javaclient.dialog.spezifteilesuche.suchergebnisse.SuchergebnisseController;
import webetk.javaclient.dialog.steckerAnschlagteile.DlgSteckerAnschlagteile;
import webetk.javaclient.dialog.steckerAnschlagteile.DlgSteckerAnschlagteileModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class DlgSteckerAnschlagteileController
extends AbstractDlgMitTLController {
    private static Logger log = Logger.getLogger(DlgTeileinfoKleinController.class);
    private DlgSteckerAnschlagteile dlg;
    protected DlgSteckerAnschlagteileModel model;
    private AbstractDialogView parent;

    public DlgSteckerAnschlagteileController() {
        this.model = new DlgSteckerAnschlagteileModel();
        super.init(this.model);
    }

    public DlgSteckerAnschlagteileController(Frame oOwner, String sSachnummer, AbstractDialogView parent) {
        ArrayList<String> aSachnummern = new ArrayList<String>();
        aSachnummern.add(sSachnummer);
        this.parent = parent;
        this.init(oOwner, aSachnummern);
    }

    public DlgSteckerAnschlagteileController(Frame oOwner, ArrayList<String> aSachnummern, AbstractDialogView parent) {
        this.parent = parent;
        this.init(oOwner, aSachnummern);
    }

    public DlgSteckerAnschlagteileController(Frame oOwner, String sHgUg, String sSachnummer, String sBenennung) {
        ArrayList<String> aSachnummern = new ArrayList<String>();
        aSachnummern.add(sSachnummer);
        this.init(oOwner, aSachnummern, true, sHgUg, sSachnummer, sBenennung);
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        this.model.init(oWFStateData);
    }

    protected void init(Frame oOwner, ArrayList<String> aSachnummern) {
        this.init(oOwner, aSachnummern, false, null, null, null);
    }

    protected void init(Frame oOwner, ArrayList<String> aSachnummern, boolean bLokalteil, String sHgUg, String sSachnummer, String sBenennung) {
        this.model = new DlgSteckerAnschlagteileModel();
        super.init(this.model);
        this.getStecker(aSachnummern);
        this.loadTLZumUebernehmen();
        this.dlg = new DlgSteckerAnschlagteile(oOwner, this.model, this);
        this.dlg.update();
        this.dlg.setModal(true);
        this.dlg.setVisible(true);
    }

    protected void getStecker(ArrayList aSachnummern) {
        Vector<Teil> cAspgTeile = new Vector<Teil>();
        String sMenge = "1";
        for (int i = 0; i < aSachnummern.size(); ++i) {
            cAspgTeile.add(new Teil((String)aSachnummern.get(i), sMenge, "ST"));
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfHashMap = new TrfHashMap(null);
        try {
            String sprache = GlobalObjects.getInstance().getLanguage();
            trfHashMap.setValue("sprache", sprache);
            trfHashMap.setValue("teileaspg", cAspgTeile);
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHashMap, Command.LOAD_STECKER);
        }
        catch (CommunicationException e) {
            log.error((Object)("ladeStecker: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
        }
        if (trfHashMap.getError() != null) {
            log.error((Object)(Resource.getInstance().getFehlerLadenKonfiguration() + ": " + trfHashMap.getError().getMessage()));
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerLadenKonfiguration() + ": " + trfHashMap.getError().getMessage(), Resource.getInstance().getTeilelisteBearbeiten(), 0);
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        this.model.setSachnummern(TeilHelper.toArrayList((Vector)trfHashMap.getValue("teileaspg")));
    }

    protected boolean loadTeileinfo(String sHgUg, String sSachnummer, String sFremdeTnr, JComponent component) {
        Cursor cursor = null;
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        if (component != null) {
            cursor = component.getCursor();
            component.setCursor(Cursor.getPredefinedCursor(3));
        }
        this.model.setTeileinfo(null);
        TrfHashMap trfHashMap = new TrfHashMap(null);
        trfHashMap.setValue("hgug", sHgUg);
        trfHashMap.setValue("sachnummer", sSachnummer);
        trfHashMap.setValue("fremdetnr", sFremdeTnr);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHashMap, Command.LOAD_TEILEINFO);
        }
        catch (CommunicationException ex) {
            log.error((Object)("loadTeileinfo: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            if (component != null) {
                component.setCursor(cursor);
            }
            return false;
        }
        boolean bFound = true;
        if (trfHashMap.getError() != null) {
            String sMsg = "";
            if (trfHashMap.getError() instanceof NoDataFoundException) {
                sMsg = Resource.getInstance().getTeilNichtGefundenZuSuchkriterium();
                log.info((Object)sMsg);
            } else {
                sMsg = Resource.getInstance().getFehlerLadeTeileinfo() + ": " + trfHashMap.getError().getMessage();
                log.error((Object)sMsg);
            }
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            if (component != null) {
                component.setCursor(cursor);
            }
            JOptionPane.showMessageDialog(MainView.getInstance(), sMsg, Resource.getInstance().getTeileinformation(), 0);
            bFound = false;
        }
        Teileinfo oTeileinfo = (Teileinfo)trfHashMap.getValue("teileinfo");
        this.model.setTeileinfo(oTeileinfo);
        Vector<String> aMarken = null;
        if (oTeileinfo != null) {
            aMarken = oTeileinfo.getMarken();
        }
        this.model.setMarken(aMarken);
        if (oTeileinfo != null && oTeileinfo.getSachnummern() != null && oTeileinfo.getSachnummern().size() > 0) {
            this.showFremdeTnrSucheErgebnisliste(oTeileinfo.getSachnummern());
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        if (component != null) {
            component.setCursor(cursor);
        }
        return bFound;
    }

    protected void showFremdeTnrSucheErgebnisliste(Collection<SearchBTETeile.PartOrBTE> teile) {
        WorkflowStateData data = new WorkflowStateData();
        data.setWert("modus", "Teileinfo");
        data.setWert("teilenummern", teile);
        MainView.getInstance().showDlg(SuchergebnisseController.class, data);
    }

    @Override
    public WorkflowStateData getExitData() {
        return null;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    public void handleUebernehmen(int nIndex, Collection<Teil> aTeil) {
        ComboTeilelisteItem oTeilelisteItem = this.getListeZuIndex(nIndex);
        String sTeilelisteID = oTeilelisteItem.getID();
        if (sTeilelisteID == null || sTeilelisteID.trim().equals("")) {
            return;
        }
        String sEigentuemer = oTeilelisteItem.getEigentuemer();
        String sMarke = oTeilelisteItem.getMarke();
        if (sMarke == null || sMarke.equals("")) {
            Collection<String> cMarken = this.model.getMarken();
            if (cMarken.size() != 1) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), "unerwarteter Fehler: es darf keine neue Teileliste angelegt werden, wenn die Marke nicht eindeutig ist", Resource.getInstance().getTeileinfo(), 0);
                return;
            }
            sMarke = (String)cMarken.toArray()[0];
        }
        DlgTeilelisteController ctrl = new DlgTeilelisteController();
        ctrl.uebernehmeTeile(MainView.getInstance(), oTeilelisteItem, sMarke, aTeil, true, true);
        if (!sTeilelisteID.equals(oTeilelisteItem.getID()) || !sEigentuemer.equals(oTeilelisteItem.getEigentuemer())) {
            this.loadTLZumUebernehmen();
        }
        this.refreshParent();
        this.dlg.updateTeilelisten();
    }

    protected ComboTeilelisteItem getListeZuIndex(int nInd) {
        return this.model.getTeileliste(nInd);
    }

    protected void loadTLZumUebernehmen() {
        log.debug((Object)"Performing loadTLZumUebernehmen");
        this.model.storeTeilelistenIDs(null);
        String sMarke = null;
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        JavaSucheInfo objSucheInfo = GlobalObjects.getInstance().getEtkData().getSucheInfo();
        sMarke = objSucheInfo != null ? objSucheInfo.getMarke() : oLoginInfo.getSettings().getMarke();
        Vector<String> aMarke = new Vector<String>();
        aMarke.add(sMarke);
        this.model.setMarken((Collection<String>)aMarke);
        TrfHashMap trfTeilelistenIDs = DlgTeilelisteController.loadTeilelistenIDs(aMarke, false);
        if (trfTeilelistenIDs == null) {
            return;
        }
        this.model.storeTeilelistenIDs(trfTeilelistenIDs);
    }

    public void refreshParent() {
        if (this.parent != null && this.parent instanceof AbstractDlgMitTLView) {
            AbstractDlgMitTLView oMitTLView = (AbstractDlgMitTLView)this.parent;
            oMitTLView.getController().loadTeilelistenIDs();
            oMitTLView.updateTeilelisten();
        }
        if (this.parent instanceof BTEView) {
            BTEView oBTEView = (BTEView)this.parent;
            oBTEView.refreshKleineTeileliste();
        }
    }
}

