/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.teileverwendung.tvnachbenennung;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.EnhancedTextDocument;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import webetk.app.GenericTeil;
import webetk.app.Markt;
import webetk.app.SearchBTETeile;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.app.teilevwdgteil.Baureihe;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.AbstractDlgMitTLView;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.MarkeProduktKatalogUmfangVLAuswahl;
import webetk.javaclient.dialog.MarkeProduktKatalogUmfangVLPanelSet;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.bte.BTEView;
import webetk.javaclient.dialog.btinfo.Bildtafelinfo;
import webetk.javaclient.dialog.spezifteilesuche.suchergebnisse.TeilenummernZeile;
import webetk.javaclient.dialog.teileverwendung.tvnachbenennung.AufzuklappZeile;
import webetk.javaclient.dialog.teileverwendung.tvnachbenennung.DatenZeile;
import webetk.javaclient.dialog.teileverwendung.tvnachbenennung.TVNachBenennungController;
import webetk.javaclient.dialog.teileverwendung.tvnachbenennung.TVNachBenennungModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.GenericRow;
import webetk.javaclient.generictable.GenericRowAdapter;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.GenericTableMouseEventListener;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.javaclient.menuitem.MenuItemAnzeigeBildtafel;
import webetk.javaclient.menuitem.MenuItemCopySachnummer;
import webetk.javaclient.menuitem.MenuItemTeileinformation;
import webetk.resources.Resource;

public class TVNachBenennungView
extends AbstractDlgMitTLView {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(TVNachBenennungView.class);
    private TVNachBenennungController controller;
    private TVNachBenennungModel model;
    private JPanel panHeader = null;
    private JPanel panContent = null;
    private JPanel panSuchen = null;
    private JLayeredPane panErgebnisBildtafeln = null;
    private JTextField tfSuchbegriff = null;
    private JButtonEx buttonSuchen = null;
    private JLabel labGesucht = null;
    private GenericTableModel tableModel = null;
    private GenericTable table = null;
    private JScrollPane scrollPaneTable = null;
    private JPanel panErgebnisBildtafelnButton = null;
    private GenericTableModel tableTeilenummernModel;
    private GenericTable tableTeilenummern;
    private JButtonEx buttonWeiterTeilenummern = null;
    private JPanel panErgebnisTeilenummern = null;
    private JScrollPane scrollPaneTableTeile = null;
    private GenericTable tableTeileBte = null;
    private JScrollPane scrollPaneTableTeileBte = null;
    private GenericTableModel tableModelTeileBte = null;
    private String sTableSource = null;
    private static String BILDTAFELN = "BILDTAFELN";
    private static String TEILE_BTE = "TEILE_BTE";
    private boolean teileShown = true;
    private JPopupMenu menuPopup = null;
    private JMenu menuHauptTeileverwendung = null;
    private JMenuItem menuitemBildtafelinformation = null;
    private JMenuItem menuitemBildtafelAnzeigen = null;
    private JPopupMenu menuPopupTeile = null;
    private JMenuItem menuitemCopySachnummer = null;
    private JMenuItem menuitemTeileinformation = null;
    private JPopupMenu menuPopupTeileBte = null;
    private JMenuItem menuitemBildtafelinformationTeileBte = null;
    private JMenuItem menuitemBildtafelAnzeigenTeileBte = null;
    private ArrayList<JComponent> menus = new ArrayList();
    private boolean mbUpdateTeileliste = true;
    private JComboBox comboMarktPrio;
    private JLabel fuerMarktPrio;
    private boolean mbSuppressComboMarktPrioActionListener = false;
    private JList listMarktWeitere;
    private JScrollPane spMarktWeitere;
    private boolean mbSuppressListWeitereMaerkteSelectionListener = false;
    private boolean marktWeitereExpanded = false;

    @Override
    protected void initComponents() {
        super.initComponents();
        this.panHeader = new HeaderPanel(Resource.getInstance().getTeileverwendungNachBenennung(), ImageCache.getInstance().getHeaderIcon("tvnt"));
        this.panContent = this.createContent();
        this.setLayout(new BorderLayout());
        this.add((Component)this.panHeader, "North");
        this.add((Component)this.panContent, "Center");
    }

    @Override
    public void initMenus() {
        this.menus.clear();
        this.menuHauptTeileverwendung = new JMenu(Resource.getInstance().getErweitert());
        this.menuHauptTeileverwendung.setBackground(UIHelper.getDarkerBackground());
        this.menus.add(this.menuHauptTeileverwendung);
        this.menuitemTeileinformation = new MenuItemTeileinformation(this);
        this.menuHauptTeileverwendung.add(this.menuitemTeileinformation);
        JMenu menuHauptZurueck = new JMenu(Resource.getInstance().getZurueck());
        menuHauptZurueck.setBackground(UIHelper.getDarkerBackground());
        Vector<String> oZurueckStrings = GlobalObjects.getInstance().getEtkData().getZurueckBezeichnungen();
        if (oZurueckStrings.size() > 0) {
            for (int i = 0; i < oZurueckStrings.size(); ++i) {
                final String sBezeichnung = oZurueckStrings.get(i);
                String sMenuitemText = GlobalObjects.getInstance().getEtkData().getZurueckMenuitemText(sBezeichnung);
                JMenuItem menuitemZurueck = new JMenuItem(sMenuitemText);
                menuitemZurueck.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractDialogView oView = GlobalObjects.getInstance().getEtkData().getZurueckDialogView(sBezeichnung);
                        GlobalObjects.getInstance().getEtkData().removeZurueckDialog(sBezeichnung);
                        if (oView != null) {
                            oView.initMenus();
                            if (oView instanceof BTEView) {
                                ((BTEView)oView).refreshKleineTeileliste();
                            }
                            MainView.getInstance().displayDialogView(oView);
                        }
                    }
                });
                menuHauptZurueck.add(menuitemZurueck);
            }
            this.menus.add(menuHauptZurueck);
        }
        this.menuPopup = new JPopupMenu();
        this.menuitemBildtafelinformation = new JMenuItem(Resource.getInstance().getBildtafelinformation());
        this.menuPopup.add(this.menuitemBildtafelinformation);
        this.menuitemBildtafelAnzeigen = new MenuItemAnzeigeBildtafel("teileverwendung_teil", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemBildtafelAnzeigen);
        this.menuitemBildtafelinformation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TVNachBenennungView.this.showBildtafelinfo(TVNachBenennungView.this.table.getTable().getSelectedRow());
            }
        });
        this.menuPopupTeile = new JPopupMenu();
        this.menuitemTeileinformation = new MenuItemTeileinformation(this);
        this.menuPopupTeile.add(this.menuitemTeileinformation);
        this.menuPopupTeile.addSeparator();
        this.menuitemCopySachnummer = new MenuItemCopySachnummer(this);
        this.menuPopupTeile.add(this.menuitemCopySachnummer);
        this.menuPopupTeileBte = new JPopupMenu();
        this.menuitemBildtafelinformationTeileBte = new JMenuItem(Resource.getInstance().getBildtafelinformation());
        this.menuPopupTeileBte.add(this.menuitemBildtafelinformationTeileBte);
        this.menuitemBildtafelAnzeigenTeileBte = new MenuItemAnzeigeBildtafel("teileverwendung_teil", this.controller, this.model, this);
        this.menuPopupTeileBte.add(this.menuitemBildtafelAnzeigenTeileBte);
        this.menuitemBildtafelinformationTeileBte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TVNachBenennungView.this.showBildtafelinfoTeileBte(TVNachBenennungView.this.tableTeileBte.getTable().getSelectedRow());
            }
        });
    }

    @Override
    public Iterator<JComponent> getMenus() {
        return this.menus.iterator();
    }

    private JPanel createContent() {
        this.panContent = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0, 0, 350};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(1, 1);
        hl.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.panContent.setLayout(hl);
        this.panContent.add((Component)this.createSuchenPanel(), c.rc(1, 1));
        this.panContent.add((Component)this.createErgebnisPanel(), c.rc(3, 1));
        this.panContent.add((Component)this.createErgebnisTeilenummern(), c.rc(5, 1));
        return this.panContent;
    }

    private JLayeredPane createErgebnisPanel() {
        this.panErgebnisBildtafeln = new JLayeredPane();
        TitledBorder tb = new TitledBorder(UIHelper.getStandardBorder(), Resource.getInstance().getErgebnisBildtafeln());
        tb.setTitleFont(UIHelper.getBoldFont());
        this.panErgebnisBildtafeln.setBorder(tb);
        this.panErgebnisBildtafeln.setLayout(null);
        this.listMarktWeitere = new JList();
        this.spMarktWeitere = new JScrollPane(this.listMarktWeitere);
        this.spMarktWeitere.setVisible(false);
        this.panErgebnisBildtafeln.add((Component)this.spMarktWeitere, JLayeredPane.PALETTE_LAYER);
        this.panErgebnisBildtafelnButton = this.createMarktAuswahl();
        this.panErgebnisBildtafeln.add((Component)this.panErgebnisBildtafelnButton, JLayeredPane.DEFAULT_LAYER);
        return this.panErgebnisBildtafeln;
    }

    private JPanel createMarktAuswahl() {
        this.fuerMarktPrio = new JLabel(Resource.getInstance().getFuerMarktPrio());
        this.comboMarktPrio = new JComboBox();
        this.comboMarktPrio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TVNachBenennungView.this.mbSuppressComboMarktPrioActionListener) {
                    return;
                }
                Markt newPrioMarkt = (Markt)TVNachBenennungView.this.comboMarktPrio.getSelectedItem();
                TVNachBenennungView.this.model.getMarktDaten().changePrioMarkt(newPrioMarkt);
                TVNachBenennungView.this.updateMaerkte();
                TVNachBenennungView.this.updateBildtafeln(TVNachBenennungView.this.model.isPKW());
            }
        });
        JLabel weitereMaerkte = new JLabel(Resource.getInstance().getWeitereMaerkte());
        JLabel marktWeiterePfeilAuf = new JLabel(ImageCache.getInstance().getIcon("aufklappen.gif"));
        marktWeiterePfeilAuf.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                TVNachBenennungView.this.showListMarktWeitere(true);
            }
        });
        JLabel marktWeiterePfeilZu = new JLabel(ImageCache.getInstance().getIcon("zuklappen.gif"));
        marktWeiterePfeilZu.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                TVNachBenennungView.this.showListMarktWeitere(false);
            }
        });
        this.listMarktWeitere.setSelectionMode(2);
        this.listMarktWeitere.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                if (TVNachBenennungView.this.mbSuppressListWeitereMaerkteSelectionListener) {
                    return;
                }
                int[] newSelInd = TVNachBenennungView.this.listMarktWeitere.getSelectedIndices();
                TVNachBenennungView.this.model.getMarktDaten().setSelSonstigeMaerkte(newSelInd);
                TVNachBenennungView.this.updateBildtafeln(TVNachBenennungView.this.model.isPKW());
            }
        });
        JPanel panel = new JPanel();
        int[] w = new int[]{0, 5, 0, 52, -7, 5, -5};
        int[] h = new int[]{0, 0};
        HIGLayout layout = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        layout.setColumnWeight(7, 1);
        panel.setLayout(layout);
        panel.add((Component)this.fuerMarktPrio, c.rc(1, 1, "l"));
        panel.add((Component)this.comboMarktPrio, c.rc(1, 3, "l"));
        panel.add((Component)weitereMaerkte, c.rc(1, 5, "l"));
        if (this.marktWeitereExpanded) {
            this.spMarktWeitere.setVisible(true);
            this.listMarktWeitere.setVisible(true);
            panel.add((Component)marktWeiterePfeilZu, c.rc(1, 7, "l"));
        } else {
            this.spMarktWeitere.setVisible(false);
            this.listMarktWeitere.setVisible(false);
            panel.add((Component)marktWeiterePfeilAuf, c.rc(1, 7, "l"));
        }
        panel.setBounds(11, 27, 993, 29);
        return panel;
    }

    private void showListMarktWeitere(boolean show) {
        this.marktWeitereExpanded = show;
        this.panErgebnisBildtafeln.remove(this.panErgebnisBildtafelnButton);
        this.panErgebnisBildtafelnButton = this.createMarktAuswahl();
        this.panErgebnisBildtafeln.add((Component)this.panErgebnisBildtafelnButton, JLayeredPane.DEFAULT_LAYER);
        this.updateMaerkte();
        this.updateBildtafeln(this.model.isPKW());
    }

    private JPanel createSuchenPanel() {
        this.panSuchen = new TitledPanel(Resource.getInstance().getVerwendungSuchenFuer());
        MarkeProduktKatalogUmfangVLPanelSet panAuswahl = null;
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        boolean bShowAuswahl = oLoginInfo.displayMarkeProduktKatalogumfang();
        if (bShowAuswahl) {
            MarkeProduktKatalogUmfangVLAuswahl mpkAuswahl = new MarkeProduktKatalogUmfangVLAuswahl(null, new EmptyBorder(0, 0, 0, 0), true, this.model.getMarke(), this.model.getProduktart(), this.model.getKatalogumfang(), true, false);
            panAuswahl = mpkAuswahl.getMpkPanelSet();
            mpkAuswahl.addPropertyChangeListener("Marke", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    TVNachBenennungView.this.model.setMarke((String)evt.getNewValue());
                }
            });
            mpkAuswahl.addPropertyChangeListener("Produktart", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    TVNachBenennungView.this.model.setProduktart((String)evt.getNewValue());
                }
            });
            mpkAuswahl.addPropertyChangeListener("KATUMFANG", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    TVNachBenennungView.this.model.setKatalogumfang((String)evt.getNewValue());
                }
            });
        }
        int[] w_suchen = new int[]{10, 0, 5, 0, 2, 0, 20, 0, 0, 10};
        int[] h_suchen = new int[]{10, 0, 10, 0, 5, 0, 2, 0, 10};
        HIGLayout layoutSuchen = new HIGLayout(w_suchen, h_suchen);
        HIGConstraints c = new HIGConstraints();
        this.panSuchen.setLayout(layoutSuchen);
        layoutSuchen.setColumnWeight(9, 1);
        layoutSuchen.setRowWeight(6, 1);
        JLabel labTeilenummer = new JLabel(Resource.getInstance().getBenennung());
        this.tfSuchbegriff = new JTextField(30);
        this.tfSuchbegriff.setDocument(new EnhancedTextDocument(40, 0));
        this.buttonSuchen = new JButtonEx(Resource.getInstance().getSuchen(), ImageCache.getInstance().getIcon("search.gif"));
        this.tfSuchbegriff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
                if (TVNachBenennungView.this.tfSuchbegriff.getText().length() < 3) {
                    log.error((Object)"Bei weniger als 3 Zeichen wird die Suche nicht getartet!");
                    MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                    TVNachBenennungView.this.tfSuchbegriff.setCursor(Cursor.getPredefinedCursor(2));
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getTeileverwendungNachBenennung(), 0);
                    return;
                }
                TVNachBenennungView.this.searchByBenennung();
                TVNachBenennungView.this.searchTeileverwendung(null);
                if (TVNachBenennungView.this.model.getAnzTeilenummernBen() > 0) {
                    TVNachBenennungView.this.teileShown = true;
                } else {
                    TVNachBenennungView.this.teileShown = false;
                }
                if (TVNachBenennungView.this.model.getAnzBildtafeln() == 0 && TVNachBenennungView.this.model.getAnzTeilenummernBen() == 0) {
                    log.info((Object)"Keine Daten gefunden");
                    MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                    TVNachBenennungView.this.tfSuchbegriff.setCursor(Cursor.getPredefinedCursor(2));
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getTeileverwendungNachBenennung(), 0);
                }
                TVNachBenennungView.this.update();
            }
        });
        this.buttonSuchen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
                if (TVNachBenennungView.this.tfSuchbegriff.getText().length() < 3) {
                    log.error((Object)"keine Teileverwendung nach Benennung gefunden!");
                    MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                    TVNachBenennungView.this.tfSuchbegriff.setCursor(Cursor.getPredefinedCursor(2));
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getTeileverwendungNachBenennung(), 0);
                    return;
                }
                TVNachBenennungView.this.searchTeileverwendung(null);
                TVNachBenennungView.this.searchByBenennung();
                if (TVNachBenennungView.this.model.getAnzTeilenummernBen() > 0) {
                    TVNachBenennungView.this.teileShown = true;
                } else {
                    TVNachBenennungView.this.teileShown = false;
                }
                if (TVNachBenennungView.this.model.getAnzBildtafeln() == 0 && TVNachBenennungView.this.model.getAnzTeilenummernBen() == 0) {
                    log.error((Object)"keine Teileverwendung nach Benennung gefunden!");
                    MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                    TVNachBenennungView.this.tfSuchbegriff.setCursor(Cursor.getPredefinedCursor(2));
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getTeileverwendungNachBenennung(), 0);
                }
                TVNachBenennungView.this.update();
            }
        });
        if (bShowAuswahl) {
            this.panSuchen.add((Component)panAuswahl, c.rcwh(2, 2, 8, 1, "lr"));
        } else {
            layoutSuchen.setRowHeight(3, 0);
        }
        this.panSuchen.add((Component)labTeilenummer, c.rc(4, 2));
        this.panSuchen.add((Component)this.tfSuchbegriff, c.rc(4, 6, "lr"));
        this.panSuchen.add((Component)this.buttonSuchen, c.rc(4, 8));
        return this.panSuchen;
    }

    protected JScrollPane createTabelleBtes(boolean bFzg) {
        AufzuklappZeile.resetRenderer();
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn("", 0, JLabel.class, false, DatenZeile.getHasInfoRenderer());
        tableConfig.addIconColumn("visualisierung.gif", Resource.getInstance().getAnzeigeBildtafel());
        tableConfig.addColumn("", 0, JLabel.class, false, AufzuklappZeile.getAufklappenRenderer());
        String sBaureiheProtoyp = bFzg ? "3' E21" : "XXXXXXXXXXXXXXXXXXXX";
        tableConfig.addColumn(Resource.getInstance().getBaureihe(), 0, true, sBaureiheProtoyp);
        tableConfig.addColumn(Resource.getInstance().getModell(), 0, true, "XXXXXXXXXXXX");
        if (bFzg) {
            tableConfig.addColumn(Resource.getInstance().getKarosserie(), 0, false, "XXXXXXXXXX");
        }
        tableConfig.addColumn(Resource.getInstance().getNueKR(), 0, false, "ECE");
        int nRowCount = tableConfig.getColumnCount();
        tableConfig.setHeaderTooltip(nRowCount - 1, Resource.getInstance().getKatalogausfuehrungRegion());
        tableConfig.addColumn(Resource.getInstance().getBtNummer(), 0, false, "51_1169");
        tableConfig.addColumn(Resource.getInstance().getBtUeberschrift(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableConfig.addColumn("", 0, true, "XXX");
        this.tableModel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tableModel);
        this.table.getTable().getColumnModel().getColumn(0).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setWidth(20);
        this.table.getTable().getColumnModel().getColumn(2).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(2).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(2).setWidth(20);
        GenericTableMouseEventAdapter listenerBildtafelinfo = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                TVNachBenennungView.this.showBildtafelinfo(e.getRow());
            }
        };
        this.table.addMouseListener(listenerBildtafelinfo, 0);
        GenericTableMouseEventAdapter listenerBildtafelAnzeigen = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                TVNachBenennungView.this.sTableSource = BILDTAFELN;
                ((MenuItemAnzeigeBildtafel)TVNachBenennungView.this.menuitemBildtafelAnzeigen).showBildtafel();
            }
        };
        this.table.addMouseListener(listenerBildtafelAnzeigen, 1);
        GenericTableMouseEventAdapter listenerPlusMinus = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                TVNachBenennungView.this.doClickOnExpandCollapse(e.getRow());
            }
        };
        this.table.addMouseListener(listenerPlusMinus, 2);
        this.table.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (TVNachBenennungView.this.table.getTable().getSelectedRowCount() != 1) {
                    return;
                }
                int nSelectedRow = TVNachBenennungView.this.table.getTable().getSelectedRow();
                if (!(TVNachBenennungView.this.tableModel.getRow(nSelectedRow) instanceof DatenZeile)) {
                    return;
                }
                boolean zeileHatInfo = ((DatenZeile)TVNachBenennungView.this.tableModel.getRow(nSelectedRow)).hasInfo();
                TVNachBenennungView.this.menuitemBildtafelinformation.setEnabled(zeileHatInfo);
                TVNachBenennungView.this.sTableSource = BILDTAFELN;
                TVNachBenennungView.this.menuPopup.show(TVNachBenennungView.this.table.getTable(), evt.getX(), evt.getY());
            }
        });
        this.scrollPaneTable = this.table.getScrollPane();
        this.scrollPaneTable.setBounds(11, 57, 993, 154);
        return this.scrollPaneTable;
    }

    protected JScrollPane createTabelleTeileBte(boolean bFzg) {
        AufzuklappZeile.resetRenderer();
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn("", 0, JLabel.class, false, DatenZeile.getHasInfoRenderer());
        tableConfig.addIconColumn("visualisierung.gif", Resource.getInstance().getAnzeigeBildtafel());
        tableConfig.addColumn("", 0, JLabel.class, false, AufzuklappZeile.getAufklappenRenderer());
        String sBaureiheProtoyp = bFzg ? "3' E21" : "XXXXXXXXXXXXXXXXXXXX";
        tableConfig.addColumn(Resource.getInstance().getBaureihe(), 0, true, sBaureiheProtoyp);
        tableConfig.addColumn(Resource.getInstance().getModell(), 0, true, "XXXXXXXXXXXX");
        if (bFzg) {
            tableConfig.addColumn(Resource.getInstance().getKarosserie(), 0, false, "XXXXXXXXXX");
        }
        tableConfig.addColumn(Resource.getInstance().getNueKR(), 0, false, "ECE");
        int nRowCount = tableConfig.getColumnCount();
        tableConfig.setHeaderTooltip(nRowCount - 1, Resource.getInstance().getKatalogausfuehrungRegion());
        tableConfig.addColumn(Resource.getInstance().getBtNummer(), 0, false, "51_1169");
        tableConfig.addColumn(Resource.getInstance().getBtUeberschrift(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableConfig.addColumn(Resource.getInstance().getMenge(), 0, false, "XX");
        this.tableModelTeileBte = new GenericTableModel(tableConfig);
        this.tableTeileBte = new GenericTable(this.tableModelTeileBte);
        this.tableTeileBte.getTable().getColumnModel().getColumn(0).setMinWidth(20);
        this.tableTeileBte.getTable().getColumnModel().getColumn(0).setMaxWidth(20);
        this.tableTeileBte.getTable().getColumnModel().getColumn(0).setWidth(20);
        this.tableTeileBte.getTable().getColumnModel().getColumn(1).setMinWidth(20);
        this.tableTeileBte.getTable().getColumnModel().getColumn(1).setMaxWidth(20);
        this.tableTeileBte.getTable().getColumnModel().getColumn(1).setWidth(20);
        this.tableTeileBte.getTable().getColumnModel().getColumn(2).setMinWidth(20);
        this.tableTeileBte.getTable().getColumnModel().getColumn(2).setMaxWidth(20);
        this.tableTeileBte.getTable().getColumnModel().getColumn(2).setWidth(20);
        GenericTableMouseEventAdapter listenerBildtafelinfo = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                TVNachBenennungView.this.showBildtafelinfoTeileBte(e.getRow());
            }
        };
        this.tableTeileBte.addMouseListener(listenerBildtafelinfo, 0);
        GenericTableMouseEventAdapter listenerBildtafelAnzeigen = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                TVNachBenennungView.this.sTableSource = TEILE_BTE;
                ((MenuItemAnzeigeBildtafel)TVNachBenennungView.this.menuitemBildtafelAnzeigen).showBildtafel();
            }
        };
        this.tableTeileBte.addMouseListener(listenerBildtafelAnzeigen, 1);
        GenericTableMouseEventAdapter listenerPlusMinus = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                TVNachBenennungView.this.doClickOnExpandCollapseTeileBte(e.getRow());
            }
        };
        this.tableTeileBte.addMouseListener(listenerPlusMinus, 2);
        this.tableTeileBte.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (TVNachBenennungView.this.tableTeileBte.getTable().getSelectedRowCount() != 1) {
                    return;
                }
                int nSelectedRow = TVNachBenennungView.this.tableTeileBte.getTable().getSelectedRow();
                if (!(TVNachBenennungView.this.tableModelTeileBte.getRow(nSelectedRow) instanceof DatenZeile)) {
                    return;
                }
                boolean zeileHatInfo = ((DatenZeile)TVNachBenennungView.this.tableModelTeileBte.getRow(nSelectedRow)).hasInfo();
                TVNachBenennungView.this.menuitemBildtafelinformationTeileBte.setEnabled(zeileHatInfo);
                TVNachBenennungView.this.sTableSource = TEILE_BTE;
                TVNachBenennungView.this.menuPopupTeileBte.show(TVNachBenennungView.this.tableTeileBte.getTable(), evt.getX(), evt.getY());
            }
        });
        this.scrollPaneTableTeileBte = this.tableTeileBte.getScrollPane();
        return this.scrollPaneTableTeileBte;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        super.init(oDlgModel, oDlgController);
        this.model = (TVNachBenennungModel)oDlgModel;
        this.controller = (TVNachBenennungController)oDlgController;
        this.initComponents();
        this.initMenus();
        this.controller.loadTeilelistenIDs();
        this.update();
    }

    @Override
    public void update() {
        String sSachnummerGesucht = this.model.getSachnummerGesucht();
        boolean bEnabled = sSachnummerGesucht != null && sSachnummerGesucht.length() == 7;
        this.menuitemTeileinformation.setEnabled(bEnabled);
        this.menuitemTeileinformation.repaint();
        this.panErgebnisBildtafeln.setVisible(this.model.getAnzBildtafeln() != 0);
        this.panErgebnisTeilenummern.setVisible(this.model.getAnzTeilenummernBen() != 0);
        if (this.model.getAnzBildtafeln() == 0 && this.model.getAnzTeilenummernBen() == 0) {
            return;
        }
        if (this.mbUpdateTeileliste) {
            this.updateTeilelisten();
            this.mbUpdateTeileliste = false;
        }
        if (this.scrollPaneTable != null) {
            this.panErgebnisBildtafeln.remove(this.scrollPaneTable);
        }
        if (this.scrollPaneTableTeile != null) {
            this.panErgebnisTeilenummern.remove(this.scrollPaneTableTeile);
        }
        if (this.scrollPaneTableTeileBte != null) {
            this.panErgebnisTeilenummern.remove(this.scrollPaneTableTeileBte);
        }
        ((HeaderPanel)this.panHeader).setBigTitle(Resource.getInstance().getTeileverwendungNachBenennung() + " ' " + this.tfSuchbegriff.getText() + " ' ");
        int[] w = new int[]{0, 0, 0};
        int[] h = this.model.getAnzBildtafeln() != 0 && this.model.getAnzTeilenummernBen() > 0 ? new int[]{0, 0, 0, 10, 0, 10} : new int[]{0, 0, 0, 10};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(2, 1);
        hl.setRowWeight(3, 1);
        this.panContent.removeAll();
        if (this.model.getAnzBildtafeln() != 0 && this.model.getAnzTeilenummernBen() > 0) {
            hl.setRowWeight(5, 1);
        }
        this.panContent.setLayout(hl);
        HIGConstraints c = new HIGConstraints();
        if (this.model.getAnzBildtafeln() != 0) {
            this.panErgebnisBildtafeln.add((Component)this.createTabelleBtes(this.model.isPKW()), JLayeredPane.DEFAULT_LAYER);
        }
        if (this.model.getAnzTeilenummernBen() > 0) {
            if (this.teileShown) {
                this.buttonZurueck.setVisible(false);
                this.labGesucht.setText("");
                this.panErgebnisTeilenummern.add((Component)this.createTabelleTeilenummern(), c.rc(4, 2));
            } else {
                this.buttonZurueck.setVisible(true);
                this.updateTNRPanel();
            }
        }
        this.panContent.add((Component)this.panHeader, c.rcwh(1, 1, 3, 1, "tlbr"));
        if (this.model.getAnzBildtafeln() != 0 && this.model.getAnzTeilenummernBen() > 0) {
            this.panContent.add((Component)this.panErgebnisBildtafeln, c.rc(3, 2, "tlrb"));
            this.panContent.add((Component)this.panErgebnisTeilenummern, c.rc(5, 2, "tlbr"));
        }
        if (this.model.getAnzTeilenummernBen() == 0) {
            this.panContent.add((Component)this.panErgebnisBildtafeln, c.rc(3, 2, "tlrb"));
        }
        if (this.model.getAnzBildtafeln() == 0 && this.model.getAnzTeilenummernBen() > 0) {
            this.panContent.add((Component)this.panErgebnisTeilenummern, c.rc(3, 2, "tlrb"));
        }
        if (this.model.getAnzBildtafeln() != 0) {
            this.updateMaerkte();
            this.updateBildtafeln(this.model.isPKW());
        }
        if (this.teileShown) {
            this.updateTeilenummern();
        }
        this.panContent.repaint();
        this.panContent.validate();
        this.panContent.updateUI();
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        this.tfSuchbegriff.setCursor(Cursor.getPredefinedCursor(2));
    }

    private void updateMaerkte() {
        this.mbSuppressComboMarktPrioActionListener = true;
        this.comboMarktPrio.removeAllItems();
        for (Markt markt : this.model.getMarktDaten().getAuswahlPrimaerMarkt()) {
            this.comboMarktPrio.addItem(markt);
        }
        Markt selPrioMarkt = this.model.getMarktDaten().getSelPrimaerMarkt();
        if (selPrioMarkt != null) {
            this.comboMarktPrio.setSelectedItem(selPrioMarkt);
        } else {
            this.comboMarktPrio.setSelectedIndex(0);
        }
        this.mbSuppressComboMarktPrioActionListener = false;
        this.mbSuppressListWeitereMaerkteSelectionListener = true;
        this.listMarktWeitere.setListData(this.model.getMarktDaten().getAuswahlSonstigeMaerkte());
        int[] aSelIndizes = this.model.getMarktDaten().getIndicesSelSonstigeMaerkte();
        if (aSelIndizes != null) {
            this.listMarktWeitere.setSelectedIndices(aSelIndizes);
        }
        this.mbSuppressListWeitereMaerkteSelectionListener = false;
        if (this.comboMarktPrio != null && this.spMarktWeitere != null) {
            Dimension dimMarktPrio = this.comboMarktPrio.getPreferredSize();
            Dimension dimLabel = this.fuerMarktPrio.getPreferredSize();
            int xMarktWeitere = 68 + dimLabel.width + dimMarktPrio.width;
            this.spMarktWeitere.setBounds(xMarktWeitere, 52, dimMarktPrio.width, 160);
        }
    }

    private void updateBildtafeln(boolean bFzg) {
        if (this.tableModel != null) {
            this.tableModel.removeAllRows();
        }
        Vector<GenericRow> cZeilen = this.model.getAnzeigedatenSortiertNachMarkt(bFzg);
        for (GenericRow oZeile : cZeilen) {
            this.tableModel.addRow(oZeile);
        }
        this.panErgebnisBildtafeln.repaint();
        this.panErgebnisBildtafeln.validate();
        this.panErgebnisBildtafeln.updateUI();
    }

    private void updateTeilenummern() {
        int nIndexTeilenummerSelMin = -1;
        Collection<SearchBTETeile.PartOrBTE> cTeilenummern = this.model.getTeilenummernBen();
        if (cTeilenummern != null && cTeilenummern.size() > 0) {
            for (SearchBTETeile.PartOrBTE oTeil : cTeilenummern) {
                String sTeilenummer = oTeil.getIdNummer();
                String sBenennung = oTeil.getBenennung();
                String sZusatz = oTeil.getZusatz();
                String sBenennungKommentar = oTeil.getBenennungKommentar();
                if (sTeilenummer.length() == 11) {
                    sTeilenummer = sTeilenummer.substring(0, 2) + " " + sTeilenummer.substring(2, 4) + " " + sTeilenummer.substring(4, 5) + " " + sTeilenummer.substring(5, 8) + " " + sTeilenummer.substring(8, 11);
                }
                this.tableTeilenummernModel.addRow(new TeilenummernZeile(sTeilenummer, sBenennung, sZusatz, sBenennungKommentar));
            }
            if (nIndexTeilenummerSelMin != -1) {
                JScrollPane sc = this.tableTeilenummern.getScrollPane();
                int nTeilenummerRowShowVisible = nIndexTeilenummerSelMin <= 2 ? 0 : nIndexTeilenummerSelMin - 2;
                Rectangle rect = this.tableTeilenummern.getTable().getCellRect(nTeilenummerRowShowVisible, 0, true);
                sc.getViewport().setViewPosition(rect.getLocation());
            }
        }
        this.panErgebnisTeilenummern.repaint();
    }

    private void updateTNRPanel() {
        String sSachnummerGesuchtInfo;
        this.labGesucht.setText("");
        if (this.scrollPaneTableTeileBte != null) {
            this.panErgebnisTeilenummern.remove(this.scrollPaneTableTeileBte);
        }
        if (this.model.getAnzeigedatenTNR() == null) {
            return;
        }
        if (this.scrollPaneTableTeile != null) {
            this.panErgebnisTeilenummern.remove(this.scrollPaneTableTeile);
        }
        this.labGesucht.setText((sSachnummerGesuchtInfo = this.model.getSelTNRBen()) == null ? "" : sSachnummerGesuchtInfo);
        HIGConstraints c = new HIGConstraints();
        this.panErgebnisTeilenummern.add((Component)this.createTabelleTeileBte(this.model.isPKW()), c.rc(4, 2));
        this.teileShown = false;
        GenericRowAdapter oZeile = null;
        TrfHashMap oAnzeigedaten = this.model.getAnzeigedatenTNR();
        if (this.model.getAnzeigedatenTNR() != null) {
            String sArt;
            int i = 1;
            while ((sArt = (String)oAnzeigedaten.getValue(i + "art")) != null) {
                String sBaureiheExt = null;
                if (sArt.equals("Baureihe")) {
                    sBaureiheExt = (String)oAnzeigedaten.getValue(i + "baureihe_ext");
                    String sIsExpandiert = (String)oAnzeigedaten.getValue(i + "isexpandiert");
                    boolean bIsExpandiert = sIsExpandiert.equals("true");
                    oZeile = new AufzuklappZeile(bIsExpandiert, sBaureiheExt);
                } else {
                    String sBaureihe = (String)oAnzeigedaten.getValue(i + "baureihe");
                    sBaureiheExt = (String)oAnzeigedaten.getValue(i + "baureihe_ext");
                    String sKarosserie = null;
                    String sKarosserieExt = null;
                    String sBauart = null;
                    if (this.model.isPKW()) {
                        sKarosserie = (String)oAnzeigedaten.getValue(i + "karosserie");
                        sKarosserieExt = (String)oAnzeigedaten.getValue(i + "karosserie_ext");
                    } else {
                        sBauart = (String)oAnzeigedaten.getValue(i + "bauart");
                    }
                    String sModell = (String)oAnzeigedaten.getValue(i + "modell");
                    String sRegion = (String)oAnzeigedaten.getValue(i + "region");
                    String sBtNummer = (String)oAnzeigedaten.getValue(i + "btnummer");
                    String sBtUeberschrift = (String)oAnzeigedaten.getValue(i + "benennung");
                    String sMenge = (String)oAnzeigedaten.getValue(i + "menge");
                    String sHasBtInfo = (String)oAnzeigedaten.getValue(i + "hasbtinfo");
                    boolean bHasBtInfo = sHasBtInfo != null && sHasBtInfo.equals("true");
                    oZeile = this.model.isPKW() ? new DatenZeile(bHasBtInfo, sBtNummer, sBtUeberschrift, sBaureihe, sBaureiheExt, sModell, sKarosserie, sKarosserieExt, sRegion, null, sMenge) : new DatenZeile(bHasBtInfo, sBtNummer, sBtUeberschrift, sBauart, sBaureihe, sBaureiheExt, sModell, sRegion, null, sMenge);
                }
                this.tableModelTeileBte.addRow(oZeile);
                ++i;
            }
        }
        this.panErgebnisTeilenummern.repaint();
        this.panErgebnisTeilenummern.validate();
        this.panErgebnisTeilenummern.updateUI();
    }

    private void uebernehmenInTeilelisteBte() {
        this.uebernehmenInTeileliste(this.model.getSelSachnummern(), false);
    }

    private void uebernehmenInTeileliste() {
        Vector<GenericTeil> cTeile = new Vector<GenericTeil>();
        GenericTable jTable = this.tableTeilenummern.getTable();
        int nCountSelectedRows = jTable.getSelectedRowCount();
        if (nCountSelectedRows == 0) {
            return;
        }
        int[] selectedRows = jTable.getSelectedRows();
        for (int i = 0; i < nCountSelectedRows; ++i) {
            int nRow = selectedRows[i];
            TeilenummernZeile oZeile = (TeilenummernZeile)this.tableTeilenummernModel.getRow(nRow);
            GenericTeil t = new GenericTeil();
            t.setSachnummer(oZeile.getSachnummer());
            String sTeilenummer = oZeile.getTeilenummer();
            String HGUG = sTeilenummer.trim().replaceAll(" +", "").substring(0, 4);
            t.setHG(HGUG.substring(0, 2));
            t.setUG(HGUG.substring(2, 4));
            cTeile.add(t);
        }
        this.uebernehmenInTeileListe(cTeile, false);
    }

    void searchTeileverwendung(String sBaureihe) {
        this.controller.performSearch(this.tfSuchbegriff.getText(), sBaureihe);
        if (this.model.hasMarkeChanged()) {
            this.controller.loadTeilelistenIDs();
            this.model.resetMarkeChangedFlag();
            this.mbUpdateTeileliste = true;
        }
    }

    private void doClickOnExpandCollapse(int nRow) {
        if (!(this.tableModel.getRow(nRow) instanceof AufzuklappZeile)) {
            return;
        }
        AufzuklappZeile oZeile = (AufzuklappZeile)this.tableModel.getRow(nRow);
        if (oZeile.isExpanded()) {
            this.searchTeileverwendung(null);
        } else {
            int counter = 0;
            for (Baureihe baureihe : this.model.getBaureihen()) {
                if (baureihe.getExpandiert() && counter < nRow) {
                    nRow -= baureihe.getModellspalten().size();
                }
                ++counter;
            }
            String sBaureihe = this.model.getBaureiheZuIndex(nRow);
            this.searchTeileverwendung(sBaureihe);
        }
        this.updateBildtafeln(this.model.isPKW());
    }

    private void doClickOnExpandCollapseTeileBte(int nRow) {
        if (!(this.tableModelTeileBte.getRow(nRow) instanceof AufzuklappZeile)) {
            return;
        }
        AufzuklappZeile oZeile = (AufzuklappZeile)this.tableModelTeileBte.getRow(nRow);
        if (oZeile.isExpanded()) {
            this.suchenTeilenummern(null);
        } else {
            int nIndexZeile = nRow + 1;
            String sBaureihe = (String)this.model.getAnzeigedatenTNR().getValue(nIndexZeile + "baureihe");
            this.suchenTeilenummern(sBaureihe);
        }
        this.update();
    }

    public void searchByBenennung() {
        String sBenennung = this.tfSuchbegriff.getText();
        sBenennung = sBenennung == null ? "" : sBenennung;
        int nCount = 0;
        for (int i = 0; i < sBenennung.length(); ++i) {
            nCount = sBenennung.charAt(i) != '*' ? nCount + 1 : nCount;
        }
        if (nCount < 3) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheInvalidBen(), this.model.getDialogTitel(), 0);
            this.tfSuchbegriff.requestFocus();
            return;
        }
        if (!this.controller.performSearchBenennung(sBenennung, this.tfSuchbegriff)) {
            log.info((Object)"Irgendetwas ist schiefgelaufen (TVNachBenennungView.java");
            return;
        }
        this.model.setExitAction("anzeigeergebnisse1ts");
    }

    private JPanel createErgebnisTeilenummern() {
        this.panErgebnisTeilenummern = new TitledPanel(Resource.getInstance().getErgebnisTeilenummern(), new BorderLayout());
        this.buttonWeiterTeilenummern = new JButtonEx();
        this.buttonWeiterTeilenummern.setIcon(ImageCache.getInstance().getIcon("arrw04_10b.gif"));
        this.buttonWeiterTeilenummern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TVNachBenennungView.this.suchenTeilenummern(null);
            }
        });
        this.buttonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (TVNachBenennungView.this.teileShown) {
                    TVNachBenennungView.this.uebernehmenInTeileliste();
                } else {
                    TVNachBenennungView.this.uebernehmenInTeilelisteBte();
                }
            }
        });
        this.buttonZurueck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TVNachBenennungView.this.teileShown = true;
                TVNachBenennungView.this.update();
            }
        });
        JPanel panTeileliste = new JPanel();
        this.labGesucht = new JLabel();
        int[] w_teilelistePanel = new int[]{10, 0, 10, 0, 10, 0, 10, 0, 10, 0};
        int[] h_teilelistePanel = new int[]{5, 0, 5, 0};
        HIGLayout layout_teilelistePanel = new HIGLayout(w_teilelistePanel, h_teilelistePanel);
        layout_teilelistePanel.setColumnWeight(9, 1);
        HIGConstraints c = new HIGConstraints();
        panTeileliste.setLayout(layout_teilelistePanel);
        panTeileliste.add((Component)this.labGesucht, c.rcwh(2, 2, 5, 1, "l"));
        panTeileliste.add((Component)this.labTeileliste, c.rc(4, 2, "r"));
        panTeileliste.add((Component)this.comboTeileliste, c.rc(4, 4));
        panTeileliste.add((Component)this.buttonUebernehmen, c.rc(4, 6, "l"));
        panTeileliste.add((Component)this.buttonUeberpruefen, c.rc(4, 8, "l"));
        panTeileliste.add((Component)this.buttonZurueck, c.rc(4, 10, "l"));
        int[] w = new int[]{5, 0, 5};
        int[] h = new int[]{5, 0, 5, 0, 5};
        HIGLayout layout = new HIGLayout(w, h);
        layout.setColumnWeight(2, 1);
        layout.setRowWeight(4, 1);
        this.panErgebnisTeilenummern.setLayout(layout);
        this.panErgebnisTeilenummern.add((Component)panTeileliste, c.rc(2, 2, "lr"));
        return this.panErgebnisTeilenummern;
    }

    private JScrollPane createTabelleTeilenummern() {
        TableConfiguration tableTeilenummernConfig = new TableConfiguration();
        tableTeilenummernConfig.addIconColumn("info.gif", Resource.getInstance().getTeileinformation());
        tableTeilenummernConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "52 10 1 942 724YY");
        tableTeilenummernConfig.addColumn(Resource.getInstance().getTeilebenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableTeilenummernConfig.addColumn(Resource.getInstance().getZusatz(), 2, true, "XXXXXXXXXXXXXXXYYYY");
        tableTeilenummernConfig.addColumn(Resource.getInstance().getKommentar(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableTeilenummernConfig.setUsePrototypeIcons(true);
        this.tableTeilenummernModel = new GenericTableModel(tableTeilenummernConfig);
        this.tableTeilenummern = new GenericTable(this.tableTeilenummernModel);
        this.tableTeilenummern.getTable().getColumnModel().getColumn(0).setMinWidth(20);
        this.tableTeilenummern.getTable().getColumnModel().getColumn(0).setMaxWidth(20);
        this.tableTeilenummern.getTable().getColumnModel().getColumn(0).setWidth(20);
        GenericTableMouseEventListener listenerTeileInfo = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                int nRow = TVNachBenennungView.this.tableTeilenummern.getTable().getSelectedRow();
                TeilenummernZeile oZeile = (TeilenummernZeile)TVNachBenennungView.this.tableTeilenummernModel.getRow(nRow);
                TVNachBenennungView.this.model.setSachnummerGesucht(oZeile.getSachnummer());
                ((MenuItemTeileinformation)TVNachBenennungView.this.menuitemTeileinformation).showTeileinfo();
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.tableTeilenummern.addMouseListener(listenerTeileInfo, 0);
        GenericTableMouseEventListener listenerTable = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                int nRow = TVNachBenennungView.this.tableTeilenummern.getTable().getSelectedRow();
                TeilenummernZeile oZeile = (TeilenummernZeile)TVNachBenennungView.this.tableTeilenummernModel.getRow(nRow);
                TVNachBenennungView.this.model.setSachnummerGesucht(oZeile.getSachnummer());
                TVNachBenennungView.this.menuitemTeileinformation.setEnabled(true);
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
                TVNachBenennungView.this.suchenTeilenummern(null);
                TVNachBenennungView.this.teileShown = false;
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (TVNachBenennungView.this.tableTeilenummern.getTable().getSelectedRowCount() != 1) {
                    return;
                }
                TVNachBenennungView.this.menuPopupTeile.show(TVNachBenennungView.this.tableTeilenummern.getTable(), evt.getX(), evt.getY());
            }
        };
        this.tableTeilenummern.addMouseListener(listenerTable, 1);
        this.tableTeilenummern.addMouseListener(listenerTable, 2);
        this.tableTeilenummern.addMouseListener(listenerTable, 3);
        this.tableTeilenummern.addMouseListener(listenerTable, 4);
        this.scrollPaneTableTeile = this.tableTeilenummern.getScrollPane();
        return this.scrollPaneTableTeile;
    }

    private void suchenTeilenummern(String baureihe) {
        ArrayList<String> cSachnummern = new ArrayList<String>();
        ArrayList<String> cBenennung = new ArrayList<String>();
        String tnr = "";
        GenericTable jTable = this.tableTeilenummern.getTable();
        int nCountSelectedRows = jTable.getSelectedRowCount();
        if (nCountSelectedRows == 0) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getHinweisKeineTeile(), this.model.getDialogTitel(), 0);
            return;
        }
        int[] selectedRows = jTable.getSelectedRows();
        for (int i = 0; i < nCountSelectedRows; ++i) {
            int nRow = selectedRows[i];
            TeilenummernZeile oZeile = (TeilenummernZeile)this.tableTeilenummernModel.getRow(nRow);
            String sSachnummer = oZeile.getSachnummer();
            cSachnummern.add(sSachnummer);
            cBenennung.add(oZeile.getBenennung());
            tnr = oZeile.getTeilenummer();
        }
        if (!this.controller.performSearchSachnummern(cSachnummern, baureihe)) {
            return;
        }
        this.model.setSelSachnummern(cSachnummern);
        this.model.setSelTNRBen(tnr + " " + (String)cBenennung.iterator().next());
        this.buttonZurueck.setVisible(true);
        this.updateTNRPanel();
    }

    private void showBildtafelinfo(int nRow) {
        if (!(this.tableModel.getRow(nRow) instanceof DatenZeile)) {
            return;
        }
        DatenZeile oZeile = (DatenZeile)this.tableModel.getRow(nRow);
        if (!oZeile.hasInfo()) {
            return;
        }
        String sBtNummer = oZeile.getBtNummer();
        String sProduktart = this.model.getProduktart();
        Bildtafelinfo dlgBildtafelinfo = new Bildtafelinfo((Frame)MainView.getInstance(), sBtNummer, sProduktart);
        dlgBildtafelinfo.setVisible(true);
    }

    private void showBildtafelinfoTeileBte(int nRow) {
        if (!(this.tableModelTeileBte.getRow(nRow) instanceof DatenZeile)) {
            return;
        }
        DatenZeile oZeile = (DatenZeile)this.tableModelTeileBte.getRow(nRow);
        if (!oZeile.hasInfo()) {
            return;
        }
        String sBtNummer = oZeile.getBtNummer();
        String sProduktart = this.model.getProduktart();
        Bildtafelinfo dlgBildtafelinfo = new Bildtafelinfo((Frame)MainView.getInstance(), sBtNummer, sProduktart);
        dlgBildtafelinfo.setVisible(true);
    }

    @Override
    public void setFocus() {
        if (this.tfSuchbegriff != null) {
            this.tfSuchbegriff.requestFocus();
        }
    }

    @Override
    public HashMap<String, Object> getInfoZurBildtafel() {
        int nRow = -1;
        DatenZeile oZeile = null;
        String sSachnummerGesucht = this.model.getSachnummerGesucht();
        this.menuPopup.isVisible();
        if (this.table != null && this.sTableSource.equals(BILDTAFELN)) {
            nRow = this.table.getTable().getSelectedRow();
            if (!(this.tableModel.getRow(nRow) instanceof DatenZeile)) {
                return null;
            }
            oZeile = (DatenZeile)this.tableModel.getRow(nRow);
        } else if (this.tableTeileBte != null && this.sTableSource.equals(TEILE_BTE)) {
            nRow = this.tableTeileBte.getTable().getSelectedRow();
            if (!(this.tableModelTeileBte.getRow(nRow) instanceof DatenZeile)) {
                return null;
            }
            oZeile = (DatenZeile)this.tableModelTeileBte.getRow(nRow);
            sSachnummerGesucht = this.model.getSelSachnummern().iterator().next();
        }
        CurrentBTE oCurrentBTE = this.controller.showBildtafel(oZeile);
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        oHashMap.put("currentbte", oCurrentBTE);
        oHashMap.put("modus", "Fahrzeugteile");
        oHashMap.put("sachnummer", sSachnummerGesucht);
        return oHashMap;
    }

    @Override
    public HashMap<String, Object> getInfoZurSachnummer() {
        if (this.model.getSachnummerGesucht() == null || this.model.getSachnummerGesucht().equals("")) {
            return null;
        }
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        String sSachnummer = this.model.getSachnummerGesucht();
        String sMarke = this.model.getMarke();
        String sProduktart = this.model.getProduktart();
        String sKatalogumfang = this.model.getKatalogumfang();
        oHashMap.put("sachnummer", sSachnummer);
        oHashMap.put("teilenummer", null);
        oHashMap.put("benennung_zusatz", null);
        oHashMap.put("marke", sMarke);
        oHashMap.put("produktart", sProduktart);
        oHashMap.put("katalogumfang", sKatalogumfang);
        return oHashMap;
    }
}

