/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.teileverwendung.tvnachteilen;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.generictable.ETKDefaultTableCellRenderer;
import webetk.javaclient.generictable.GenericRowAdapter;
import webetk.resources.Resource;

public class DatenZeile
extends GenericRowAdapter {
    private boolean mbFzg = true;
    private String msBauart = null;
    private String msBaureihe = null;
    private String msBaureiheExt = null;
    private String msModell = null;
    private String msKarosserie = null;
    private String msKarosserieExt = null;
    private String msRegion = null;
    private String msBtNummer = null;
    private String msBtUeberschrift = null;
    private String msMenge = null;
    private boolean mbHasInfo = false;
    private static ETKDefaultTableCellRenderer hasInfo = null;
    private static ETKDefaultTableCellRenderer hasNoInfo = null;

    public DatenZeile(boolean bHasInfo, String sBtNummer, String sBtUeberschrift, String sMenge, String sBaureihe, String sBaureiheExt, String sModell, String sKarosserie, String sKarosserieExt, String sRegion) {
        this.mbFzg = true;
        this.mbHasInfo = bHasInfo;
        this.msBtNummer = sBtNummer;
        this.msBtUeberschrift = sBtUeberschrift;
        this.msMenge = sMenge;
        this.msBaureihe = sBaureihe;
        this.msBaureiheExt = sBaureiheExt;
        this.msModell = sModell;
        this.msKarosserie = sKarosserie;
        this.msKarosserieExt = sKarosserieExt;
        this.msRegion = sRegion;
    }

    public DatenZeile(boolean bHasInfo, String sBtNummer, String sBtUeberschrift, String sMenge, String sBauart, String sBaureihe, String sBaureiheExt, String sModell, String sRegion) {
        this.mbFzg = false;
        this.mbHasInfo = bHasInfo;
        this.msBtNummer = sBtNummer;
        this.msBtUeberschrift = sBtUeberschrift;
        this.msMenge = sMenge;
        this.msBauart = sBauart;
        this.msBaureihe = sBaureihe;
        this.msBaureiheExt = sBaureiheExt;
        this.msModell = sModell;
        this.msRegion = sRegion;
    }

    @Override
    public Object get(int column) {
        switch (column) {
            case 0: {
                return this.mbHasInfo ? hasInfo : hasNoInfo;
            }
            case 1: {
                return ImageCache.getInstance().getIcon("visualisierung.gif");
            }
            case 3: {
                return this.msBaureiheExt;
            }
            case 4: {
                return this.msModell;
            }
            case 5: {
                if (this.mbFzg) {
                    return this.msKarosserieExt;
                }
                return this.msRegion;
            }
            case 6: {
                if (this.mbFzg) {
                    return this.msRegion;
                }
                return this.msBtNummer;
            }
            case 7: {
                if (this.mbFzg) {
                    return this.msBtNummer;
                }
                return this.msBtUeberschrift;
            }
            case 8: {
                if (this.mbFzg) {
                    return this.msBtUeberschrift;
                }
                return this.msMenge;
            }
            case 9: {
                if (this.mbFzg) {
                    return this.msMenge;
                }
                return null;
            }
        }
        return null;
    }

    public boolean hasInfo() {
        return this.mbHasInfo;
    }

    public String getBtNummer() {
        return this.msBtNummer;
    }

    public String getBtUeberschrift() {
        return this.msBtUeberschrift;
    }

    public String getMenge() {
        return this.msMenge;
    }

    public String getBaureihe() {
        return this.msBaureihe;
    }

    public String getBauart() {
        return this.msBauart;
    }

    public String getModell() {
        return this.msModell;
    }

    public String getRegion() {
        return this.msRegion;
    }

    public String getKarosserie() {
        return this.msKarosserie;
    }

    private static void initColumnIcons() {
        hasInfo = new ETKDefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
            }
        };
        hasInfo.getOriginalRenderer().setText("");
        hasInfo.getOriginalRenderer().setIcon(ImageCache.getInstance().getIcon("info.gif"));
        hasInfo.setToolTipText(Resource.getInstance().getBildtafelinformation());
        hasInfo.setHorizontalAlignment(0);
        hasNoInfo = new ETKDefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
            }
        };
        hasNoInfo.getOriginalRenderer().setText("");
        hasNoInfo.getOriginalRenderer().setIcon(ImageCache.getInstance().getIcon("info_insensitiv.jpg"));
        hasNoInfo.setToolTipText("");
        hasNoInfo.setHorizontalAlignment(0);
    }

    static TableCellRenderer getHasInfoRenderer() {
        if (hasInfo == null) {
            DatenZeile.initColumnIcons();
        }
        return hasInfo;
    }

    static TableCellRenderer getHasNoInfoRenderer() {
        if (hasNoInfo == null) {
            DatenZeile.initColumnIcons();
        }
        return hasNoInfo;
    }
}

