/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.teileverwendung.tvnachteilen;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.EnhancedTextDocument;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import webetk.app.GenericTeil;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.app.teilevwdgteil.Baureihe;
import webetk.app.teilevwdgteil.Modellspalte;
import webetk.communication.LoginInfo;
import webetk.javaclient.dialog.AbstractDlgMitTLView;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.MarkeProduktKatalogUmfangVLAuswahl;
import webetk.javaclient.dialog.MarkeProduktKatalogUmfangVLPanelSet;
import webetk.javaclient.dialog.SachnummerField;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.bte.BTEView;
import webetk.javaclient.dialog.btinfo.Bildtafelinfo;
import webetk.javaclient.dialog.teileverwendung.tvnachteilen.AufzuklappZeile;
import webetk.javaclient.dialog.teileverwendung.tvnachteilen.DatenZeile;
import webetk.javaclient.dialog.teileverwendung.tvnachteilen.TVNachTeilenController;
import webetk.javaclient.dialog.teileverwendung.tvnachteilen.TVNachTeilenModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.GenericTableMouseEventListener;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.javaclient.menuitem.MenuItemAnzeigeBildtafel;
import webetk.javaclient.menuitem.MenuItemTeileinformation;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class TVNachTeilenView
extends AbstractDlgMitTLView {
    private static final long serialVersionUID = 1L;
    private TVNachTeilenController controller;
    private TVNachTeilenModel model;
    private JPanel panHeader = null;
    private JPanel panContent = null;
    private JPanel panSuchen = null;
    private JPanel panErgebnis = null;
    private JTextField tfHgUg = null;
    private SachnummerField tfSachnummer = null;
    private JButtonEx buttonSuchen = null;
    private JLabel labGesucht = null;
    private GenericTableModel tableModel = null;
    private GenericTable table = null;
    private JScrollPane scrollPaneTable = null;
    private JMenu menuHauptTeileverwendung = null;
    private JPopupMenu menuPopup = null;
    private JMenuItem menuitemTeileinformation = null;
    private JMenuItem menuitemBildtafelinformation = null;
    private JMenuItem menuitemBildtafelAnzeigen = null;
    private ArrayList<JComponent> menus = new ArrayList();
    private boolean mbUpdateTeileliste = true;

    @Override
    protected void initComponents() {
        super.initComponents();
        this.panHeader = new HeaderPanel(Resource.getInstance().getTeileverwendung() + " " + Resource.getInstance().getNachTeilen(), ImageCache.getInstance().getHeaderIcon("tvnt"));
        this.panContent = this.createContent();
        this.setLayout(new BorderLayout());
        this.add((Component)this.panHeader, "North");
        this.add((Component)this.panContent, "Center");
    }

    @Override
    public void initMenus() {
        this.menus.clear();
        this.menuHauptTeileverwendung = new JMenu(Resource.getInstance().getErweitert());
        this.menuHauptTeileverwendung.setBackground(UIHelper.getDarkerBackground());
        this.menus.add(this.menuHauptTeileverwendung);
        this.menuitemTeileinformation = new MenuItemTeileinformation(this);
        this.menuHauptTeileverwendung.add(this.menuitemTeileinformation);
        JMenu menuHauptZurueck = new JMenu(Resource.getInstance().getZurueck());
        menuHauptZurueck.setBackground(UIHelper.getDarkerBackground());
        Vector<String> oZurueckStrings = GlobalObjects.getInstance().getEtkData().getZurueckBezeichnungen();
        if (oZurueckStrings.size() > 0) {
            for (int i = 0; i < oZurueckStrings.size(); ++i) {
                final String sBezeichnung = oZurueckStrings.get(i);
                String sMenuitemText = GlobalObjects.getInstance().getEtkData().getZurueckMenuitemText(sBezeichnung);
                JMenuItem menuitemZurueck = new JMenuItem(sMenuitemText);
                menuitemZurueck.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractDialogView oView = GlobalObjects.getInstance().getEtkData().getZurueckDialogView(sBezeichnung);
                        GlobalObjects.getInstance().getEtkData().removeZurueckDialog(sBezeichnung);
                        if (oView != null) {
                            oView.initMenus();
                            if (oView instanceof BTEView) {
                                ((BTEView)oView).refreshKleineTeileliste();
                            }
                            MainView.getInstance().displayDialogView(oView);
                        }
                    }
                });
                menuHauptZurueck.add(menuitemZurueck);
            }
            this.menus.add(menuHauptZurueck);
        }
        this.menuPopup = new JPopupMenu();
        this.menuitemBildtafelinformation = new JMenuItem(Resource.getInstance().getBildtafelinformation());
        this.menuPopup.add(this.menuitemBildtafelinformation);
        this.menuitemBildtafelAnzeigen = new MenuItemAnzeigeBildtafel("teileverwendung_teil", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemBildtafelAnzeigen);
        this.menuitemBildtafelinformation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TVNachTeilenView.this.showBildtafelinfo(TVNachTeilenView.this.table.getTable().getSelectedRow());
            }
        });
    }

    @Override
    public Iterator<JComponent> getMenus() {
        return this.menus.iterator();
    }

    private JPanel createContent() {
        this.panContent = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 10, 0};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(1, 1);
        hl.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.panContent.setLayout(hl);
        this.panContent.add((Component)this.createSuchenPanel(), c.rc(1, 1));
        this.panContent.add((Component)this.createErgebnisPanel(), c.rc(3, 1));
        return this.panContent;
    }

    private JPanel createErgebnisPanel() {
        this.panErgebnis = new TitledPanel(Resource.getInstance().getErgebnisTeilenummern());
        this.labGesucht = new JLabel();
        this.buttonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TVNachTeilenView.this.uebernehmenInTeileliste();
            }
        });
        int[] w = new int[]{10, 0, 20, 0, 20, 0, 20, 0, 10};
        int[] h = new int[]{10, 0, 10, 0, 10, 0, 10};
        HIGLayout hl = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        hl.setColumnWeight(8, 1);
        hl.setRowWeight(7, 1);
        this.panErgebnis.setLayout(hl);
        this.panErgebnis.add((Component)this.labGesucht, c.rcwh(2, 2, 5, 1, "l"));
        this.panErgebnis.add((Component)this.labTeileliste, c.rc(4, 2, "l"));
        this.panErgebnis.add((Component)this.comboTeileliste, c.rc(4, 4, "l"));
        this.panErgebnis.add((Component)this.buttonUebernehmen, c.rc(4, 6, "l"));
        this.panErgebnis.add((Component)this.buttonUeberpruefen, c.rc(4, 8, "l"));
        return this.panErgebnis;
    }

    private JPanel createSuchenPanel() {
        this.panSuchen = new TitledPanel(Resource.getInstance().getVerwendungSuchenFuer());
        MarkeProduktKatalogUmfangVLPanelSet panAuswahl = null;
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        boolean bShowAuswahl = oLoginInfo.displayMarkeProduktKatalogumfang();
        if (bShowAuswahl) {
            MarkeProduktKatalogUmfangVLAuswahl mpkAuswahl = new MarkeProduktKatalogUmfangVLAuswahl(null, new EmptyBorder(0, 0, 0, 0), true, this.model.getMarke(), this.model.getProduktart(), this.model.getKatalogumfang(), true, false);
            panAuswahl = mpkAuswahl.getMpkPanelSet();
            mpkAuswahl.addPropertyChangeListener("Marke", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    TVNachTeilenView.this.model.setMarke((String)evt.getNewValue());
                }
            });
            mpkAuswahl.addPropertyChangeListener("Produktart", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    TVNachTeilenView.this.model.setProduktart((String)evt.getNewValue());
                }
            });
            mpkAuswahl.addPropertyChangeListener("KATUMFANG", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    TVNachTeilenView.this.model.setKatalogumfang((String)evt.getNewValue());
                }
            });
        }
        int[] w_suchen = new int[]{10, 0, 5, 0, 2, 0, 20, 0, 0, 10};
        int[] h_suchen = new int[]{10, 0, 10, 0, 5, 0, 2, 0, 10};
        HIGLayout layoutSuchen = new HIGLayout(w_suchen, h_suchen);
        HIGConstraints c = new HIGConstraints();
        this.panSuchen.setLayout(layoutSuchen);
        layoutSuchen.setColumnWeight(9, 1);
        layoutSuchen.setRowWeight(6, 1);
        JLabel labTeilenummer = new JLabel(Resource.getInstance().getTeilenummer());
        JLabel labHgUg = new JLabel(Resource.getInstance().getHgug());
        JLabel labHgUg1_4 = new JLabel("12 34");
        JLabel labSachnummer = new JLabel(Resource.getInstance().getSachnummer());
        JLabel labSachnummer1_7 = new JLabel("1 234 567");
        this.tfHgUg = new JTextField(4);
        this.tfHgUg.setDocument(new EnhancedTextDocument(4, 1));
        Document doc = this.tfHgUg.getDocument();
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent ev) {
                Document doc = ev.getDocument();
                if (doc.getLength() >= 4) {
                    TVNachTeilenView.this.tfSachnummer.requestFocus();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
            }

            @Override
            public void changedUpdate(DocumentEvent ev) {
            }
        });
        this.tfSachnummer = new SachnummerField(false);
        this.buttonSuchen = new JButtonEx(Resource.getInstance().getSuchen(), ImageCache.getInstance().getIcon("search.gif"));
        this.tfSachnummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TVNachTeilenView.this.searchTeileverwendung(null);
                TVNachTeilenView.this.update();
            }
        });
        this.buttonSuchen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TVNachTeilenView.this.searchTeileverwendung(null);
                TVNachTeilenView.this.update();
            }
        });
        if (bShowAuswahl) {
            this.panSuchen.add((Component)panAuswahl, c.rcwh(2, 2, 8, 1, "lr"));
        } else {
            layoutSuchen.setRowHeight(3, 0);
        }
        this.panSuchen.add((Component)labTeilenummer, c.rc(4, 2));
        this.panSuchen.add((Component)labHgUg, c.rc(4, 4));
        this.panSuchen.add((Component)labSachnummer, c.rc(4, 6));
        this.panSuchen.add((Component)this.tfHgUg, c.rc(6, 4, "lr"));
        this.panSuchen.add((Component)labHgUg1_4, c.rc(8, 4, "lt"));
        this.panSuchen.add((Component)this.tfSachnummer, c.rc(6, 6, "lr"));
        this.panSuchen.add((Component)labSachnummer1_7, c.rc(8, 6, "lt"));
        this.panSuchen.add((Component)this.buttonSuchen, c.rc(6, 8));
        return this.panSuchen;
    }

    protected JScrollPane createTabelle(boolean bFzg) {
        AufzuklappZeile.resetRenderer();
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn("", 0, JLabel.class, false, DatenZeile.getHasInfoRenderer());
        tableConfig.addIconColumn("visualisierung.gif", Resource.getInstance().getAnzeigeBildtafel());
        tableConfig.addColumn("", 0, JLabel.class, false, AufzuklappZeile.getAufklappenRenderer());
        String sBaureiheProtoyp = bFzg ? "3' E21" : "XXXXXXXXXXXXXXXXXXXX";
        tableConfig.addColumn(Resource.getInstance().getBaureihe(), 0, true, sBaureiheProtoyp);
        tableConfig.addColumn(Resource.getInstance().getModell(), 0, true, "XXXXXXXXXXXX");
        if (bFzg) {
            tableConfig.addColumn(Resource.getInstance().getKarosserie(), 0, false, "XXXXXXXXXX");
        }
        tableConfig.addColumn(Resource.getInstance().getNueKR(), 0, false, "ECE");
        int nRowCount = tableConfig.getColumnCount();
        tableConfig.setHeaderTooltip(nRowCount - 1, Resource.getInstance().getKatalogausfuehrungRegion());
        tableConfig.addColumn(Resource.getInstance().getBtNummer(), 0, false, "51_1169");
        tableConfig.addColumn(Resource.getInstance().getBtUeberschrift(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableConfig.addColumn(Resource.getInstance().getMenge(), 0, false, "XX");
        this.tableModel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tableModel);
        this.table.getTable().getColumnModel().getColumn(0).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setWidth(20);
        this.table.getTable().getColumnModel().getColumn(2).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(2).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(2).setWidth(20);
        GenericTableMouseEventListener listenerBildtafelinfo = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                TVNachTeilenView.this.showBildtafelinfo(e.getRow());
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerBildtafelinfo, 0);
        GenericTableMouseEventListener listenerBildtafelAnzeigen = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                ((MenuItemAnzeigeBildtafel)TVNachTeilenView.this.menuitemBildtafelAnzeigen).showBildtafel();
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerBildtafelAnzeigen, 1);
        GenericTableMouseEventListener listenerPlusMinus = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                TVNachTeilenView.this.doClickOnExpandCollapse(e.getRow());
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerPlusMinus, 2);
        this.table.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (TVNachTeilenView.this.table.getTable().getSelectedRowCount() != 1) {
                    return;
                }
                int nSelectedRow = TVNachTeilenView.this.table.getTable().getSelectedRow();
                if (!(TVNachTeilenView.this.tableModel.getRow(nSelectedRow) instanceof DatenZeile)) {
                    return;
                }
                boolean zeileHatInfo = ((DatenZeile)TVNachTeilenView.this.tableModel.getRow(nSelectedRow)).hasInfo();
                TVNachTeilenView.this.menuitemBildtafelinformation.setEnabled(zeileHatInfo);
                TVNachTeilenView.this.menuPopup.show(TVNachTeilenView.this.table.getTable(), evt.getX(), evt.getY());
            }
        });
        this.scrollPaneTable = this.table.getScrollPane();
        return this.scrollPaneTable;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        super.init(oDlgModel, oDlgController);
        this.model = (TVNachTeilenModel)oDlgModel;
        this.controller = (TVNachTeilenController)oDlgController;
        this.initComponents();
        this.initMenus();
        this.controller.loadTeilelistenIDs();
        String sSachnummer = this.model.getSachnummer().toUpperCase();
        if (sSachnummer != null && sSachnummer.length() > 0) {
            this.tfSachnummer.setText(sSachnummer);
            this.searchTeileverwendung(null);
        }
        this.update();
    }

    @Override
    public void update() {
        GenericTeil t = this.model.getTeilGesucht();
        String sSachnummerGesucht = null;
        String sSachnummerGesuchtInfo = null;
        if (t != null) {
            sSachnummerGesucht = t.getSachnummer();
            sSachnummerGesuchtInfo = t.getTeilenummer() + " " + t.getBenennung();
        }
        boolean bEnabled = sSachnummerGesucht != null && sSachnummerGesucht.length() == 7;
        this.menuitemTeileinformation.setEnabled(bEnabled);
        this.menuitemTeileinformation.repaint();
        this.labGesucht.setText("");
        if (this.tableModel != null) {
            this.tableModel.removeAllRows();
        }
        this.panErgebnis.setVisible(this.model.getBaureihen() != null);
        if (this.model.getBaureihen() == null) {
            return;
        }
        if (this.mbUpdateTeileliste) {
            this.updateTeilelisten();
            this.mbUpdateTeileliste = false;
        }
        this.labGesucht.setText(sSachnummerGesuchtInfo == null ? "" : sSachnummerGesuchtInfo);
        boolean bFzg = this.model.getProduktart().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung());
        HIGConstraints c = new HIGConstraints();
        if (this.scrollPaneTable != null) {
            this.panErgebnis.remove(this.scrollPaneTable);
        }
        this.panErgebnis.add((Component)this.createTabelle(bFzg), c.rcwh(7, 2, 7, 1));
        for (Baureihe baureihe : this.model.getBaureihen()) {
            this.tableModel.addRow(new AufzuklappZeile(baureihe.getExpandiert(), baureihe.getBenennung()));
            for (Modellspalte modellspalte : baureihe.getModellspalten()) {
                String sBaureihe = modellspalte.getBaureiheID();
                String sKarosserie = null;
                String sKarosserieExt = null;
                String sBauart = null;
                if (bFzg) {
                    sKarosserie = modellspalte.getBauartKarosserieID();
                    sKarosserieExt = modellspalte.getKarosserie();
                } else {
                    sBauart = modellspalte.getBauartKarosserieID();
                }
                String sModell = modellspalte.getModell();
                String sRegion = modellspalte.getRegion();
                String sBtNummer = modellspalte.getBTNummer();
                String sBtUeberschrift = modellspalte.getBTUeberschrift();
                String sMenge = modellspalte.getMenge();
                boolean hasBTInfo = modellspalte.hasBtInfo();
                if (bFzg) {
                    this.tableModel.addRow(new DatenZeile(hasBTInfo, sBtNummer, sBtUeberschrift, sMenge, sBaureihe, baureihe.getBenennung(), sModell, sKarosserie, sKarosserieExt, sRegion));
                    continue;
                }
                this.tableModel.addRow(new DatenZeile(hasBTInfo, sBtNummer, sBtUeberschrift, sMenge, sBauart, sBaureihe, baureihe.getBenennung(), sModell, sRegion));
            }
        }
        this.panErgebnis.repaint();
    }

    private void uebernehmenInTeileliste() {
        Vector<GenericTeil> cTeile = new Vector<GenericTeil>();
        GenericTeil t = this.model.getTeilGesucht();
        cTeile.add(t);
        this.uebernehmenInTeileListe(cTeile, false);
    }

    private boolean checkNutzereingabe() {
        this.model.resetSucheInfo();
        this.model.resetAnzeigedaten();
        String sHgUg = this.tfHgUg.getText();
        String sSachnummer = this.tfSachnummer.getText().toUpperCase();
        if (sHgUg != null && sHgUg.length() != 0 && sHgUg.length() != 4) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getInvalidHgug(), Resource.getInstance().getTeileverwendungNachTeilen(), 1);
            this.tfHgUg.requestFocus();
            return false;
        }
        if (sSachnummer == null || sSachnummer.length() != 7) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getInvalidSnr3(), Resource.getInstance().getTeileverwendungNachTeilen(), 1);
            this.tfSachnummer.requestFocus();
            return false;
        }
        return true;
    }

    private boolean checkSachnummer() {
        this.model.resetAnzeigedaten();
        this.update();
        if (!this.checkNutzereingabe()) {
            return false;
        }
        return this.controller.checkSachnummer(this.tfSachnummer.getText().toUpperCase());
    }

    void searchTeileverwendung(String sBaureihe) {
        this.model.resetAnzeigedaten();
        this.update();
        if (!this.checkNutzereingabe()) {
            return;
        }
        if (!this.checkSachnummer()) {
            return;
        }
        this.controller.performSearch(this.tfSachnummer.getText().toUpperCase(), sBaureihe);
        if (this.model.hasMarkeChanged()) {
            this.controller.loadTeilelistenIDs();
            this.model.resetMarkeChangedFlag();
            this.mbUpdateTeileliste = true;
        }
    }

    private void doClickOnExpandCollapse(int nRow) {
        if (!(this.tableModel.getRow(nRow) instanceof AufzuklappZeile)) {
            return;
        }
        AufzuklappZeile oZeile = (AufzuklappZeile)this.tableModel.getRow(nRow);
        if (oZeile.isExpanded()) {
            this.searchTeileverwendung(null);
        } else {
            int counter = 0;
            for (Baureihe baureihe : this.model.getBaureihen()) {
                if (baureihe.getExpandiert() && counter < nRow) {
                    nRow -= baureihe.getModellspalten().size();
                }
                ++counter;
            }
            String sBaureihe = this.model.getBaureihen().get(nRow).getID();
            this.searchTeileverwendung(sBaureihe);
        }
        this.update();
    }

    private void showBildtafelinfo(int nRow) {
        if (!(this.tableModel.getRow(nRow) instanceof DatenZeile)) {
            return;
        }
        DatenZeile oZeile = (DatenZeile)this.tableModel.getRow(nRow);
        if (!oZeile.hasInfo()) {
            return;
        }
        String sBtNummer = oZeile.getBtNummer();
        String sProduktart = this.model.getProduktart();
        Bildtafelinfo dlgBildtafelinfo = new Bildtafelinfo((Frame)MainView.getInstance(), sBtNummer, sProduktart);
        dlgBildtafelinfo.setVisible(true);
    }

    @Override
    public void setFocus() {
        if (this.tfSachnummer != null) {
            this.tfSachnummer.requestFocus();
        }
    }

    @Override
    public HashMap<String, Object> getInfoZurBildtafel() {
        int nRow = this.table.getTable().getSelectedRow();
        if (!(this.tableModel.getRow(nRow) instanceof DatenZeile)) {
            return null;
        }
        DatenZeile oZeile = (DatenZeile)this.tableModel.getRow(nRow);
        CurrentBTE oCurrentBTE = this.controller.showBildtafel(oZeile);
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        oHashMap.put("currentbte", oCurrentBTE);
        oHashMap.put("modus", "Fahrzeugteile");
        String sSachnummerGesucht = this.model.getTeilGesucht().getSachnummer();
        oHashMap.put("sachnummer", sSachnummerGesucht);
        return oHashMap;
    }

    @Override
    public HashMap<String, Object> getInfoZurSachnummer() {
        if (this.model.getTeilGesucht() == null) {
            return null;
        }
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        String sSachnummer = this.model.getTeilGesucht().getSachnummer();
        String sTeilenummer = this.model.getTeilGesucht().getTeilenummer();
        String sBenennungZusatz = this.model.getTeilGesucht().getZusatz();
        String sMarke = this.model.getMarke();
        String sProduktart = this.model.getProduktart();
        String sKatalogumfang = this.model.getKatalogumfang();
        oHashMap.put("sachnummer", sSachnummer);
        oHashMap.put("teilenummer", sTeilenummer);
        oHashMap.put("benennung_zusatz", sBenennungZusatz);
        oHashMap.put("marke", sMarke);
        oHashMap.put("produktart", sProduktart);
        oHashMap.put("katalogumfang", sKatalogumfang);
        return oHashMap;
    }
}

