/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.interpretation;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.EnhancedTextDocument;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import webetk.app.GenericTeil;
import webetk.app.interpretation.IZeile;
import webetk.app.interpretation.Interpretation;
import webetk.communication.JavaSucheInfo;
import webetk.javaclient.dialog.AbstractDlgMitTLView;
import webetk.javaclient.dialog.ChoicePanel;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.SachnummerField;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.bte.BTEView;
import webetk.javaclient.dialog.zusatzinfo.interpretation.DlgInterpretationController;
import webetk.javaclient.dialog.zusatzinfo.interpretation.DlgInterpretationModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.GenericRow;
import webetk.javaclient.generictable.GenericRowAdapter;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.GenericTableMouseEventListener;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.javaclient.menuitem.MenuItemCopySachnummer;
import webetk.javaclient.menuitem.MenuItemEinzelteile;
import webetk.javaclient.menuitem.MenuItemTeileinformation;
import webetk.javaclient.menuitem.MenuItemTeileverwendungTeil;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class DlgInterpretationView
extends AbstractDlgMitTLView {
    private static final long serialVersionUID = 1L;
    private final int DIV_LOCATION_NORMAL = 180;
    private final int DIV_LOCATION_BAUM = 0;
    private final int DIV_LOCATION_TABELLE = 369;
    private static Logger log = Logger.getLogger(DlgInterpretationView.class);
    private DlgInterpretationController controller;
    private DlgInterpretationModel model;
    private GenericTableModel tableModel;
    private GenericTable table;
    private JPanel panContent;
    private JPanel panHeader;
    private JPanel panSuchen;
    private JPanel panErgebnis;
    private JLabel labTeilenummer;
    private JLabel labHgUg;
    private JLabel labHgUg1_4;
    private JLabel labSachnummer;
    private JLabel labSachnummer1_7;
    private JTextField tfHgUg;
    private SachnummerField tfSachnummer;
    private JButtonEx buttonSuchen;
    private JLabel labHinweisText;
    private JLabel labGesuchteTeilenummerText;
    private JLabel labGesuchteTeilenummer;
    private JLabel labZubestellendeTeilenummerText;
    private JLabel labZubestellendeTeilenummer;
    private Collection<JComponent> menuEntries = new ArrayList<JComponent>();
    private JPopupMenu menuPopup = null;
    private JMenuItem menuitemTeileinformation = null;
    private JMenuItem menuitemTeileverwendungTeil = null;
    private JMenuItem menuitemEinzelteile = null;
    private JMenuItem menuitemCopySachnummer = null;
    private Icon infoIcon = null;
    private JSplitPane horizontalSplitPane = null;
    private JTree tree = null;
    private DefaultMutableTreeNode wurzel = null;
    private int nCountNodes = -1;
    private ChoicePanel panAnsicht = null;
    private JRadioButton rbAnsichtTabelle;
    private JRadioButton rbAnsichtBaum;
    private JRadioButton rbAnsichtNormal;
    private ChoicePanel panAnzeige;
    private JRadioButton rbAnzeigeGesamt;
    private JRadioButton rbAnzeigeZweig;
    private String msTeilenummerAktuell = null;
    private boolean bSuppressHighligthInTabelle = false;
    private boolean bSuppressHighligthInBaum = false;
    private Runnable runnable = null;

    @Override
    protected void initComponents() {
        super.initComponents();
        this.panHeader = new HeaderPanel(Resource.getInstance().getInterpretation(), ImageCache.getInstance().getHeaderIcon("interpret"));
        this.panSuchen = new TitledPanel(Resource.getInstance().getSucheInterpretation());
        this.panErgebnis = new TitledPanel(Resource.getInstance().getSuchergebnis());
        this.labTeilenummer = new JLabel(Resource.getInstance().getTeilenummer());
        this.labHgUg = new JLabel(Resource.getInstance().getHgug());
        this.labHgUg1_4 = new JLabel("12 34");
        this.labSachnummer = new JLabel(Resource.getInstance().getSachnummer());
        this.labSachnummer1_7 = new JLabel("1 234 456");
        this.tfHgUg = new JTextField(4);
        this.tfHgUg.setDocument(new EnhancedTextDocument(4, 1));
        Document doc = this.tfHgUg.getDocument();
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent ev) {
                Document doc = ev.getDocument();
                if (doc.getLength() >= 4) {
                    DlgInterpretationView.this.tfSachnummer.requestFocus();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
            }

            @Override
            public void changedUpdate(DocumentEvent ev) {
            }
        });
        this.tfSachnummer = new SachnummerField(false);
        this.buttonSuchen = new JButtonEx(Resource.getInstance().getSuchen(), ImageCache.getInstance().getIcon("search.gif"));
        this.labHinweisText = new JLabel("<html>" + Resource.getInstance().getInterpretationHinweistext() + "</html>");
        this.labHinweisText.setFont(this.labHinweisText.getFont().deriveFont(1, 14.0f));
        this.labGesuchteTeilenummerText = new JLabel(Resource.getInstance().getGesuchteTeilenummer());
        this.labGesuchteTeilenummerText.setFont(UIHelper.getBoldFont());
        this.labGesuchteTeilenummer = new JLabel();
        this.labZubestellendeTeilenummerText = new JLabel(Resource.getInstance().getAktuelleTeilenummerZta() + ":");
        this.labZubestellendeTeilenummerText.setFont(UIHelper.getBoldFont());
        this.labZubestellendeTeilenummer = new JLabel();
        this.tfSachnummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgInterpretationView.this.searchInterpretation();
            }
        });
        this.buttonSuchen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgInterpretationView.this.searchInterpretation();
            }
        });
        this.horizontalSplitPane = new JSplitPane(0);
        this.rbAnzeigeGesamt = new JRadioButton(Resource.getInstance().getGesamtstruktur());
        this.rbAnzeigeGesamt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DlgInterpretationView.this.setTeilenummerGesuchtAlsAktuelleTeilenummer();
                DlgInterpretationView.this.model.setAnzeige(0);
                DlgInterpretationView.this.update();
            }
        });
        this.rbAnzeigeZweig = new JRadioButton(Resource.getInstance().getAktuellerZweig());
        this.rbAnzeigeZweig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DlgInterpretationView.this.setTeilenummerGesuchtAlsAktuelleTeilenummer();
                DlgInterpretationView.this.model.setAnzeige(1);
                DlgInterpretationView.this.update();
            }
        });
        this.panAnzeige = new ChoicePanel(Resource.getInstance().getAnzeige(), new AbstractButton[]{this.rbAnzeigeGesamt, this.rbAnzeigeZweig}, 0, 1);
        this.rbAnsichtTabelle = new JRadioButton(Resource.getInstance().getTabelle());
        this.rbAnsichtBaum = new JRadioButton(Resource.getInstance().getBaum());
        this.rbAnsichtNormal = new JRadioButton(Resource.getInstance().getNormal());
        this.panAnsicht = new ChoicePanel(Resource.getInstance().getAnsicht(), new AbstractButton[]{this.rbAnsichtTabelle, this.rbAnsichtBaum, this.rbAnsichtNormal}, 2, 1);
        this.rbAnsichtTabelle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DlgInterpretationView.this.model.setAnsicht(1);
                DlgInterpretationView.this.setAnsicht(369);
            }
        });
        this.rbAnsichtBaum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DlgInterpretationView.this.model.setAnsicht(0);
                DlgInterpretationView.this.setAnsicht(0);
            }
        });
        this.rbAnsichtNormal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DlgInterpretationView.this.model.setAnsicht(2);
                DlgInterpretationView.this.setAnsicht(180);
            }
        });
        this.buttonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgInterpretationView.this.uebernehmenInTeileliste();
            }
        });
        this.createLayout();
    }

    @Override
    public void initMenus() {
        JMenu menuZurueck = new JMenu(Resource.getInstance().getZurueck());
        menuZurueck.setBackground(UIHelper.getDarkerBackground());
        Vector<String> oZurueckStrings = GlobalObjects.getInstance().getEtkData().getZurueckBezeichnungen();
        if (oZurueckStrings.size() > 0) {
            for (int i = 0; i < oZurueckStrings.size(); ++i) {
                final String sBezeichnung = oZurueckStrings.get(i);
                String sMenuitemText = GlobalObjects.getInstance().getEtkData().getZurueckMenuitemText(sBezeichnung);
                JMenuItem menuitemZurueck = new JMenuItem(sMenuitemText);
                menuitemZurueck.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractDialogView oView = GlobalObjects.getInstance().getEtkData().getZurueckDialogView(sBezeichnung);
                        GlobalObjects.getInstance().getEtkData().removeZurueckDialog(sBezeichnung);
                        if (oView != null) {
                            oView.initMenus();
                            if (oView instanceof BTEView) {
                                ((BTEView)oView).refreshKleineTeileliste();
                            }
                            MainView.getInstance().displayDialogView(oView);
                        }
                    }
                });
                menuZurueck.add(menuitemZurueck);
            }
            this.menuEntries = new ArrayList<JComponent>();
            this.menuEntries.add(menuZurueck);
        }
        this.menuPopup = new JPopupMenu();
        this.menuitemTeileinformation = new MenuItemTeileinformation(this);
        this.menuPopup.add(this.menuitemTeileinformation);
        this.menuitemTeileverwendungTeil = new MenuItemTeileverwendungTeil("interpretation", this.controller, this.model, this);
        if (!GlobalObjects.isScore()) {
            this.menuPopup.add(this.menuitemTeileverwendungTeil);
        }
        this.menuitemEinzelteile = new MenuItemEinzelteile("interpretation", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemEinzelteile);
        this.menuPopup.addSeparator();
        this.menuitemCopySachnummer = new MenuItemCopySachnummer(this);
        this.menuPopup.add(this.menuitemCopySachnummer);
    }

    @Override
    public void setFocus() {
        this.tfSachnummer.requestFocus();
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panHeader, "North");
        JScrollPane content = new JScrollPane(this.createContent());
        this.add((Component)content, "Center");
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        log.debug((Object)"init");
        super.init(oDlgModel, oDlgController);
        this.model = (DlgInterpretationModel)oDlgModel;
        this.controller = (DlgInterpretationController)oDlgController;
        this.runnable = new Runnable(){

            @Override
            public void run() {
                DlgInterpretationView.this.scrollTeilenummerInVisibleScope();
            }
        };
        this.initComponents();
        this.initMenus();
        String sSachnummer = this.model.getSachnummer();
        if (sSachnummer != null) {
            this.tfSachnummer.setText(sSachnummer);
            this.searchInterpretation();
        }
        this.update();
        this.tfSachnummer.requestFocus();
    }

    @Override
    public void update() {
        this.labGesuchteTeilenummer.setText("");
        this.labZubestellendeTeilenummer.setText("");
        this.tableModel.removeAllRows();
        this.tree.removeAll();
        this.panErgebnis.setVisible(this.model.getInterpretation() != null);
        Interpretation oInterpretation = this.model.getInterpretation();
        if (oInterpretation == null) {
            return;
        }
        int nAnzeige = oInterpretation.getAnzeige();
        if (nAnzeige == 0) {
            this.rbAnzeigeGesamt.setSelected(true);
        }
        if (nAnzeige == 1) {
            this.rbAnzeigeZweig.setSelected(true);
        }
        String sGesuchteTeilenummer = oInterpretation.getTeilenummerGesucht();
        this.labGesuchteTeilenummer.setText(sGesuchteTeilenummer);
        String sZubestellendeTeilenummer = oInterpretation.getTeilenummerZuBestellen();
        this.labZubestellendeTeilenummer.setText(sZubestellendeTeilenummer);
        Collection<IZeile> cZeilen = oInterpretation.getZeilenFuerTabelle();
        for (IZeile oZeile : cZeilen) {
            int nStrukturnummer = oZeile.getStrukturnummer();
            String sSachnummer = oZeile.getSachnummer(false);
            String sTeilenummer = oZeile.getTeilenummer();
            String sBenennung = oZeile.getBenennung();
            String sEntfalldatum = oZeile.getEntfallDatum();
            String sBestand = oZeile.getLagerbestand();
            boolean bIsBold = oZeile.getTeilenummer().equals(oInterpretation.getTeilenummerGesucht());
            BaumKnoten oRow = new BaumKnoten(nStrukturnummer, sSachnummer, sTeilenummer, sBenennung, sEntfalldatum, sBestand, bIsBold);
            this.tableModel.addRow(oRow);
        }
        this.createNodes();
        this.updateTeilelisten();
        this.panErgebnis.repaint();
        SwingUtilities.invokeLater(this.runnable);
    }

    private JPanel createContent() {
        this.panContent = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 10, 0};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(1, 1);
        hl.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.panContent.setLayout(hl);
        this.panSuchen = this.createSuchenPanel();
        this.panContent.add((Component)this.panSuchen, c.rc(1, 1));
        this.panErgebnis = this.createErgebnisPanel();
        this.panContent.add((Component)this.panErgebnis, c.rc(3, 1));
        return this.panContent;
    }

    private void scrollTeilenummerInVisibleScope() {
        if (this.msTeilenummerAktuell == null) {
            return;
        }
        int nRowFindFirst = -1;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            GenericRow row = this.tableModel.getRow(i);
            String sTeilenummerTable = (String)row.get(2);
            if (!this.msTeilenummerAktuell.equals(sTeilenummerTable)) continue;
            nRowFindFirst = i;
            break;
        }
        if (nRowFindFirst != -1) {
            Rectangle rect = this.table.getTable().getCellRect(nRowFindFirst, 0, true);
            this.table.scrollRectToVisible(rect);
        }
        Vector<TreePath> cTreePaths = new Vector<TreePath>();
        this.addSelectionPaths(cTreePaths, this.wurzel, this.msTeilenummerAktuell);
        if (cTreePaths.size() == 0) {
            return;
        }
        TreePath[] oTreePath = new TreePath[cTreePaths.size()];
        for (int i = 0; i < cTreePaths.toArray().length; ++i) {
            oTreePath[i] = (TreePath)cTreePaths.toArray()[i];
        }
        this.tree.setSelectionPaths(oTreePath);
        this.tree.scrollPathToVisible((TreePath)cTreePaths.toArray()[0]);
    }

    private JPanel createSuchenPanel() {
        int[] w_suchen = new int[]{10, 0, 10, 0, 10, 0, 20, 0, 20, 320, 0};
        int[] h_suchen = new int[]{0, 5, 0, 1, 0};
        HIGLayout layoutSuchen = new HIGLayout(w_suchen, h_suchen);
        HIGConstraints c = new HIGConstraints();
        this.panSuchen.setLayout(layoutSuchen);
        this.panSuchen.add((Component)this.labTeilenummer, c.rc(1, 2));
        this.panSuchen.add((Component)this.labHgUg, c.rc(1, 4));
        this.panSuchen.add((Component)this.labSachnummer, c.rc(1, 6));
        this.panSuchen.add((Component)this.tfHgUg, c.rc(3, 4, "lrt"));
        this.panSuchen.add((Component)this.labHgUg1_4, c.rc(5, 4, "lt"));
        this.panSuchen.add((Component)this.tfSachnummer, c.rc(3, 6, "lrt"));
        this.panSuchen.add((Component)this.labSachnummer1_7, c.rc(5, 6, "lt"));
        this.panSuchen.add((Component)this.buttonSuchen, c.rc(3, 8, "lt"));
        this.panSuchen.add((Component)this.labHinweisText, c.rcwh(1, 10, 1, 5));
        return this.panSuchen;
    }

    private JPanel createErgebnisPanel() {
        int[] w_ergebnis = new int[]{10, 0, 20, 0, 20, 0, 10};
        int[] h_ergebnis = new int[]{5, 0, 5, 0, 10, 10, 0, 10, 0, 5, 0, 5};
        HIGLayout layoutErgebnis = new HIGLayout(w_ergebnis, h_ergebnis);
        layoutErgebnis.setColumnWeight(4, 1);
        layoutErgebnis.setRowWeight(11, 1);
        HIGConstraints c = new HIGConstraints();
        this.panErgebnis.setLayout(layoutErgebnis);
        this.panErgebnis.add((Component)this.labGesuchteTeilenummerText, c.rc(2, 2, "l"));
        this.panErgebnis.add((Component)this.labZubestellendeTeilenummerText, c.rc(2, 4, "l"));
        this.panErgebnis.add((Component)this.labGesuchteTeilenummer, c.rc(4, 2, "l"));
        this.panErgebnis.add((Component)this.labZubestellendeTeilenummer, c.rc(4, 4, "l"));
        this.panErgebnis.add((Component)this.panAnsicht, c.rcwh(2, 6, 1, 4));
        this.panErgebnis.add((Component)this.panAnzeige, c.rcwh(6, 6, 1, 4));
        this.panErgebnis.add((Component)this.createTeilelistePanel(), c.rcwh(7, 2, 5, 1));
        this.horizontalSplitPane.setDividerLocation(180);
        this.horizontalSplitPane.setPreferredSize(new Dimension(962, 360));
        this.horizontalSplitPane.setContinuousLayout(true);
        this.horizontalSplitPane.setTopComponent(this.createTabelle());
        this.horizontalSplitPane.setBottomComponent(this.createTree());
        this.horizontalSplitPane.setOneTouchExpandable(true);
        this.panErgebnis.add((Component)this.horizontalSplitPane, c.rcwh(11, 2, 5, 1));
        return this.panErgebnis;
    }

    private JComponent createTabelle() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn(Resource.getInstance().getNueNr(), 0, false, "11");
        tableConfig.setHeaderTooltip(0, Resource.getInstance().getStrukturnummer());
        tableConfig.addIconColumn("info.gif", Resource.getInstance().getTeileinformation());
        tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, " 11 11 1 743 118 ");
        tableConfig.addColumn(Resource.getInstance().getTeilebenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableConfig.addColumn(Resource.getInstance().getEntfallDatum(), 2, true, "00.00.0000");
        if (GlobalObjects.getInstance().isDMSAktiv()) {
            tableConfig.addColumn(Resource.getInstance().getBestand(), 2, true, "111");
        }
        tableConfig.setUsePrototypeIcons(true);
        MyTableCellRenderer tableCellRenderer = new MyTableCellRenderer();
        tableConfig.setRenderer(0, (TableCellRenderer)tableCellRenderer);
        tableConfig.setRenderer(2, (TableCellRenderer)tableCellRenderer);
        tableConfig.setRenderer(3, (TableCellRenderer)tableCellRenderer);
        tableConfig.setRenderer(4, (TableCellRenderer)tableCellRenderer);
        if (GlobalObjects.getInstance().isDMSAktiv()) {
            tableConfig.setRenderer(5, (TableCellRenderer)tableCellRenderer);
        }
        this.tableModel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tableModel);
        this.table.getTable().getColumnModel().getColumn(1).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setWidth(20);
        GenericTableMouseEventListener listener = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                ((MenuItemTeileinformation)DlgInterpretationView.this.menuitemTeileinformation).showTeileinfo();
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listener, 1);
        GenericTableMouseEventListener listener2 = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                String sTeilenummer = (String)DlgInterpretationView.this.tableModel.getValueAt(e.getRow(), 2);
                DlgInterpretationView.this.msTeilenummerAktuell = sTeilenummer;
                DlgInterpretationView.this.bSuppressHighligthInTabelle = true;
                DlgInterpretationView.this.hightlightTeilenummerInBaum(sTeilenummer);
                DlgInterpretationView.this.bSuppressHighligthInTabelle = false;
                SwingUtilities.invokeLater(DlgInterpretationView.this.runnable);
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listener2, 0);
        this.table.addMouseListener(listener2, 2);
        this.table.addMouseListener(listener2, 3);
        this.table.addMouseListener(listener2, 4);
        if (GlobalObjects.getInstance().isDMSAktiv()) {
            this.table.addMouseListener(listener2, 5);
        }
        this.table.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (DlgInterpretationView.this.table.getTable().getSelectedRowCount() != 1) {
                    return;
                }
                DlgInterpretationView.this.menuitemTeileverwendungTeil.setEnabled(true);
                DlgInterpretationView.this.menuitemEinzelteile.setEnabled(((MenuItemEinzelteile)DlgInterpretationView.this.menuitemEinzelteile).hatEinzelteile());
                DlgInterpretationView.this.menuPopup.show(DlgInterpretationView.this.table.getTable(), evt.getX(), evt.getY());
            }
        });
        this.table.setAllowSizingSmallerThanMinimumWidth(false);
        return this.table.getScrollPane();
    }

    private JComponent createTree() {
        this.tree = new JTree();
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setShowsRootHandles(true);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        MyTreeCellRenderer treeCellRenderer = new MyTreeCellRenderer();
        this.infoIcon = ImageCache.getInstance().getIcon("info.gif");
        treeCellRenderer.setLeafIcon(this.infoIcon);
        treeCellRenderer.setClosedIcon(this.infoIcon);
        treeCellRenderer.setOpenIcon(this.infoIcon);
        this.tree.setCellRenderer(treeCellRenderer);
        this.tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point oPoint;
                int nSelRow = DlgInterpretationView.this.tree.getRowForLocation(e.getX(), e.getY());
                Rectangle rect = DlgInterpretationView.this.tree.getRowBounds(nSelRow);
                if (rect == null) {
                    return;
                }
                int nWidth = DlgInterpretationView.this.infoIcon.getIconWidth();
                int nHeight = DlgInterpretationView.this.infoIcon.getIconHeight();
                Rectangle rectIcon = new Rectangle((int)rect.getX(), (int)rect.getY(), nWidth, nHeight);
                if (rectIcon.contains(oPoint = e.getPoint())) {
                    ((MenuItemTeileinformation)DlgInterpretationView.this.menuitemTeileinformation).showTeileinfo();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)DlgInterpretationView.this.tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                BaumKnoten oKnoten = (BaumKnoten)node.getUserObject();
                String sTeilenummer = oKnoten.msTeilenummer;
                DlgInterpretationView.this.msTeilenummerAktuell = sTeilenummer;
                DlgInterpretationView.this.bSuppressHighligthInBaum = true;
                DlgInterpretationView.this.hightlightTeilenummerInTabelle(sTeilenummer);
                DlgInterpretationView.this.bSuppressHighligthInBaum = false;
                SwingUtilities.invokeLater(DlgInterpretationView.this.runnable);
            }
        });
        return new JScrollPane(this.tree);
    }

    private void hightlightTeilenummerInTabelle(String sTeilenummer) {
        if (this.bSuppressHighligthInTabelle) {
            return;
        }
        if (sTeilenummer == null) {
            return;
        }
        this.table.getTable().removeRowSelectionInterval(0, this.tableModel.getRowCount() - 1);
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            GenericRow row = this.tableModel.getRow(i);
            String sTeilenummerTable = (String)row.get(2);
            if (!sTeilenummer.equals(sTeilenummerTable)) continue;
            this.table.getTable().addRowSelectionInterval(i, i);
        }
    }

    private void hightlightTeilenummerInBaum(String sTeilenummer) {
        if (this.bSuppressHighligthInBaum) {
            return;
        }
        if (sTeilenummer == null) {
            // empty if block
        }
    }

    private DefaultMutableTreeNode createNodes() {
        Interpretation oInterpretation = this.model.getInterpretation();
        if (oInterpretation == null) {
            return new DefaultMutableTreeNode(new BaumKnoten("", "", "", false));
        }
        boolean bIstDMSAktiv = GlobalObjects.getInstance().isDMSAktiv();
        this.nCountNodes = 1;
        IZeile oWurzel = oInterpretation.getWurzelInterpretation();
        String sToolTipText = oWurzel.getTeilenummer() + "     " + oWurzel.getBenennung() + "         " + oWurzel.getEntfallDatum();
        if (bIstDMSAktiv) {
            sToolTipText = sToolTipText + "       " + oWurzel.getLagerbestand();
        }
        boolean bIsBold = oWurzel.getTeilenummer().equals(oInterpretation.getTeilenummerGesucht());
        this.wurzel = new DefaultMutableTreeNode(new BaumKnoten(oWurzel.getSachnummer(false), oWurzel.getTeilenummer(), sToolTipText, bIsBold));
        Collection<Collection<IZeile>> cZweige = oInterpretation.getZweigeOhneWurzel();
        Iterator<Collection<IZeile>> iter = cZweige.iterator();
        while (iter.hasNext()) {
            DefaultMutableTreeNode aktuell = this.wurzel;
            Collection<IZeile> cKnotenProZweig = iter.next();
            for (IZeile oZeile : cKnotenProZweig) {
                String sTeilenummer = oZeile.getTeilenummer();
                DefaultMutableTreeNode ttnode = this.findeNode(aktuell, sTeilenummer);
                if (ttnode == null) {
                    ++this.nCountNodes;
                    sToolTipText = oZeile.getTeilenummer() + "     " + oZeile.getBenennung() + "         " + oZeile.getEntfallDatum();
                    if (bIstDMSAktiv) {
                        sToolTipText = sToolTipText + "       " + oZeile.getLagerbestand();
                    }
                    bIsBold = oZeile.getTeilenummer().equals(oInterpretation.getTeilenummerGesucht());
                    ttnode = new DefaultMutableTreeNode(new BaumKnoten(oZeile.getSachnummer(false), oZeile.getTeilenummer(), sToolTipText, bIsBold));
                    aktuell.add(ttnode);
                }
                aktuell = ttnode;
            }
        }
        DefaultTreeModel oModel = new DefaultTreeModel(this.wurzel);
        this.tree.setModel(oModel);
        for (int i = 1; i <= this.nCountNodes; ++i) {
            this.tree.expandRow(i);
        }
        return this.wurzel;
    }

    void searchInterpretation() {
        Interpretation oInterpretation;
        String sHgUg = this.tfHgUg.getText();
        String sSachnummer = this.tfSachnummer.getText();
        this.model.resetInterpretation();
        this.update();
        if (sHgUg != null && sHgUg.length() != 0 && sHgUg.length() != 4) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getInvalidHgug(), Resource.getInstance().getInterpretation(), 1);
            this.tfHgUg.requestFocus();
            return;
        }
        if (sSachnummer == null || sSachnummer.length() != 7) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getInvalidSnr3(), Resource.getInstance().getInterpretation(), 1);
            this.tfSachnummer.requestFocus();
            return;
        }
        this.controller.performSearch(sSachnummer, this.tfSachnummer);
        if (this.model.getInterpretation() != null) {
            this.controller.loadTeilelistenIDs();
        }
        if ((oInterpretation = this.model.getInterpretation()) != null) {
            this.msTeilenummerAktuell = oInterpretation.getTeilenummerGesucht();
        }
        this.update();
    }

    void loadTeilelistenIDs() {
        this.controller.loadTeilelistenIDs();
    }

    private void uebernehmenInTeileliste() {
        Vector<GenericTeil> cTeile = new Vector<GenericTeil>();
        GenericTable jTable = this.table.getTable();
        int nCountSelectedRows = jTable.getSelectedRowCount();
        if (nCountSelectedRows == 0) {
            return;
        }
        int[] selectedRows = jTable.getSelectedRows();
        for (int i = 0; i < nCountSelectedRows; ++i) {
            int nRow = selectedRows[i];
            BaumKnoten oKnoten = (BaumKnoten)this.tableModel.getRow(nRow);
            GenericTeil t = new GenericTeil();
            t.setSachnummer(oKnoten.msSachnummer);
            String sTeilenummer = oKnoten.msTeilenummer;
            String HGUG = sTeilenummer.trim().replaceAll(" +", "").substring(0, 4);
            t.setHG(HGUG.substring(0, 2));
            t.setUG(HGUG.substring(2, 4));
            t.setBenennung(oKnoten.msBenennung);
            cTeile.add(t);
        }
        this.uebernehmenInTeileliste(cTeile, false);
    }

    @Override
    public Iterator<JComponent> getMenus() {
        return this.menuEntries.iterator();
    }

    protected JPanel createTeilelistePanel() {
        JPanel p = new JPanel();
        int[] w = new int[]{0, 5, 0, 20, 0, 10, 0};
        int[] h = new int[]{0};
        HIGLayout hl = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        p.setLayout(hl);
        p.add((Component)this.labTeileliste, c.rc(1, 1, "l"));
        p.add((Component)this.comboTeileliste, c.rc(1, 3, "l"));
        p.add((Component)this.buttonUebernehmen, c.rc(1, 5, "l"));
        p.add((Component)this.buttonUeberpruefen, c.rc(1, 7, "l"));
        return p;
    }

    @Override
    public HashMap<String, Object> getInfoZurSachnummer() {
        int nRow = this.table.getTable().getSelectedRow();
        String sTeilenummer = (String)this.tableModel.getValueAt(nRow, 2);
        String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
        String sBenennung = (String)this.tableModel.getValueAt(nRow, 3);
        String sMarke = null;
        String sProduktart = null;
        String sKatalogumfang = null;
        if (GlobalObjects.getInstance().getEtkData().getSucheInfo() != null) {
            JavaSucheInfo oSucheInfo = GlobalObjects.getInstance().getEtkData().getSucheInfo();
            sMarke = oSucheInfo.getMarke();
            sProduktart = oSucheInfo.getProduktart();
            sKatalogumfang = oSucheInfo.getKatalogumfang();
        } else {
            sMarke = GlobalObjects.getInstance().getSessionInfo().getMarke();
            sProduktart = GlobalObjects.getInstance().getSessionInfo().getProdukart();
            sKatalogumfang = GlobalObjects.getInstance().getSessionInfo().getKatalogUmfang();
        }
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        oHashMap.put("sachnummer", sSachnummer);
        oHashMap.put("teilenummer", sTeilenummer);
        oHashMap.put("benennung_zusatz", sBenennung);
        oHashMap.put("marke", sMarke);
        oHashMap.put("produktart", sProduktart);
        oHashMap.put("katalogumfang", sKatalogumfang);
        return oHashMap;
    }

    private DefaultMutableTreeNode findeNode(DefaultMutableTreeNode mutter, String sNodeText) {
        if (mutter == null) {
            return null;
        }
        Enumeration<TreeNode> children = mutter.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)children.nextElement();
            BaumKnoten oKnoten = (BaumKnoten)oNode.getUserObject();
            if (!oKnoten.msTeilenummer.equals(sNodeText)) continue;
            return oNode;
        }
        return null;
    }

    private void addSelectionPaths(Collection<TreePath> cTreePaths, DefaultMutableTreeNode aktuell, String sTeilenummer) {
        if (aktuell == null) {
            return;
        }
        BaumKnoten oKnoten = (BaumKnoten)aktuell.getUserObject();
        if (oKnoten.msTeilenummer.equals(sTeilenummer)) {
            Object[] oPath = aktuell.getPath();
            cTreePaths.add(new TreePath(oPath));
        }
        for (int i = 0; i < aktuell.getChildCount(); ++i) {
            DefaultMutableTreeNode oChild = (DefaultMutableTreeNode)aktuell.getChildAt(i);
            this.addSelectionPaths(cTreePaths, oChild, sTeilenummer);
        }
    }

    private void setAnsicht(int nArt) {
        this.horizontalSplitPane.setDividerLocation(nArt);
        SwingUtilities.invokeLater(this.runnable);
    }

    private void setTeilenummerGesuchtAlsAktuelleTeilenummer() {
        this.msTeilenummerAktuell = "";
        Interpretation oInterpretation = this.model.getInterpretation();
        if (oInterpretation == null) {
            return;
        }
        this.msTeilenummerAktuell = oInterpretation.getTeilenummerGesucht();
    }

    static class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table.getModel() instanceof GenericTableModel) {
                GenericRow oGenericRow;
                GenericTableModel oGenTableModel = (GenericTableModel)table.getModel();
                if (row >= 0 && row < oGenTableModel.getRowCount() && (oGenericRow = oGenTableModel.getRow(row)) instanceof BaumKnoten) {
                    BaumKnoten oRow = (BaumKnoten)oGenericRow;
                    if (oRow.mbBold) {
                        this.setFont(UIHelper.getBoldFont());
                    } else {
                        this.setFont(UIHelper.getNormalFont());
                    }
                }
            }
            return this;
        }
    }

    static class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)value;
            Object oUserObject = oNode.getUserObject();
            if (oUserObject instanceof BaumKnoten) {
                BaumKnoten oKnoten = (BaumKnoten)oUserObject;
                Font oFont = this.getFont();
                if (oKnoten.mbBold) {
                    this.setFont(oFont.deriveFont(1));
                } else {
                    this.setFont(oFont.deriveFont(0));
                }
                this.setToolTipText(oKnoten.msToolTipText);
            }
            return this;
        }
    }

    public static class BaumKnoten
    extends GenericRowAdapter {
        private int mnStrukturNr = -1;
        private String msSachnummer = null;
        private String msTeilenummer = null;
        private String msBenennung = null;
        private String msEntfallDatum = null;
        private String msBestand = null;
        private String msToolTipText = null;
        private boolean mbBold = false;

        public BaumKnoten(String sSachnummer, String sTeilenummer, String sToolTipText, boolean bBold) {
            this.msSachnummer = sSachnummer;
            this.msTeilenummer = sTeilenummer;
            this.msToolTipText = sToolTipText;
            this.mbBold = bBold;
        }

        public BaumKnoten(int nStrukturNr, String sSachnummer, String sTeilenummer, String sBenennung, String sEntfallDatum, String sBestand, boolean bBold) {
            this.mnStrukturNr = nStrukturNr;
            this.msSachnummer = sSachnummer;
            this.msTeilenummer = sTeilenummer;
            this.msBenennung = sBenennung;
            this.msEntfallDatum = sEntfallDatum;
            this.msBestand = sBestand;
            this.mbBold = bBold;
        }

        public String toString() {
            return this.msTeilenummer;
        }

        @Override
        public Object get(int column) {
            switch (column) {
                case 0: {
                    return String.valueOf(this.mnStrukturNr);
                }
                case 2: {
                    return this.msTeilenummer;
                }
                case 3: {
                    return this.msBenennung;
                }
                case 4: {
                    return this.msEntfallDatum;
                }
                case 5: {
                    return this.msBestand;
                }
            }
            return null;
        }
    }
}

