/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.lagerzeitbeschraenkung;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.AbstractDlgMitTLController;
import webetk.javaclient.dialog.zusatzinfo.lagerzeitbeschraenkung.DlgLagerzeitbeschraenkungModel;
import webetk.javaclient.dialog.zusatzinfo.lagerzeitbeschraenkung.DlgLagerzeitbeschraenkungView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class DlgLagerzeitbeschraenkungController
extends AbstractDlgMitTLController {
    Logger log = Logger.getLogger(DlgLagerzeitbeschraenkungController.class);
    DlgLagerzeitbeschraenkungView view = new DlgLagerzeitbeschraenkungView();
    DlgLagerzeitbeschraenkungModel model = new DlgLagerzeitbeschraenkungModel();

    @Override
    public DialogView getDialogView() {
        this.log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        this.log.debug((Object)"init");
        super.init(this.model);
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        return null;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    protected void loadHauptgruppen(String sHgVon, String sHgBis) {
        this.log.debug((Object)"Performing Search Lagerzeitbeschr\u00e4nkung (Hauptgruppen)");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfHgs = new TrfHashMap(null);
        trfHgs.setValue("hgvon", sHgVon);
        trfHgs.setValue("hgbis", sHgBis);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHgs, Command.LOAD_LAGERZEIT_HGS);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgLagerzeitbeschraenkungController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfHgs.getError() != null) {
            if (trfHgs.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"keine Daten gefunden!", (Throwable)trfHgs.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getLagerzeitbeschraenkung(), 1);
                return;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfHgs.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfHgs.getError().getMessage(), Resource.getInstance().getLagerzeitbeschraenkung(), 0);
            return;
        }
        this.model.storeHauptgruppen((List)trfHgs.getValue("hgs"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void performSearch(String sHg) {
        this.log.debug((Object)"Performing Search Lagerzeitbeschr\u00e4nkung");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfLagerzeit = new TrfHashMap(null);
        trfLagerzeit.setValue("hg", sHg);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfLagerzeit, Command.LOAD_LAGERZEIT_ZU_HG);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgLagerzeitbeschraenkungController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfLagerzeit.getError() != null) {
            if (trfLagerzeit.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"keine Daten gefunden!", (Throwable)trfLagerzeit.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getLagerzeitbeschraenkung(), 1);
                return;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfLagerzeit.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfLagerzeit.getError().getMessage(), Resource.getInstance().getLagerzeitbeschraenkung(), 0);
            return;
        }
        this.model.storeAnzeigedaten((List)trfLagerzeit.getValue("genericteile"));
        Collection cButtons = (Collection)trfLagerzeit.getValue("buttons");
        this.model.storeButtonInfo(cButtons);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void getTeileAnIndex(int nIndex) {
        this.log.debug((Object)"Performing get Teile Lagerzeit (At Index) ");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfLagerzeit = new TrfHashMap(null);
        String sIndex = Integer.toString(nIndex);
        trfLagerzeit.setValue("index", sIndex);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfLagerzeit, Command.LOAD_LAGERZEIT_ZU_HG_AT_INDEX);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgLagerzeitbeschraenkungController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfLagerzeit.getError() != null) {
            if (trfLagerzeit.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"keine Daten gefunden!", (Throwable)trfLagerzeit.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getLagerzeitbeschraenkung(), 1);
                return;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfLagerzeit.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfLagerzeit.getError().getMessage(), Resource.getInstance().getLagerzeitbeschraenkung(), 0);
            return;
        }
        this.model.storeAnzeigedaten((List)trfLagerzeit.getValue("genericteile"));
        Collection cButtons = (Collection)trfLagerzeit.getValue("buttons");
        this.model.storeButtonInfo(cButtons);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

