/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.normteile;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.zusatzinfo.normteile.DlgNormteileSucheModel;
import webetk.javaclient.dialog.zusatzinfo.normteile.DlgNormteileSucheView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class DlgNormteileSucheController
extends AbstractDialogViewController {
    Logger log = Logger.getLogger(DlgNormteileSucheController.class);
    DlgNormteileSucheView view = new DlgNormteileSucheView();
    DlgNormteileSucheModel model = new DlgNormteileSucheModel();

    @Override
    public DialogView getDialogView() {
        this.log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        this.log.debug((Object)"init");
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        WorkflowStateData exitData = new WorkflowStateData();
        exitData.setWert("exitaction", "anzergebnisse");
        exitData.setWert("daten", this.model.getNormteile());
        return exitData;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    protected void performLoadNormteilbenennungen() {
        this.log.debug((Object)"Performing Load Normteilbenennungen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfNormteilbenennungen = new TrfHashMap(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfNormteilbenennungen, Command.LOAD_NORMTEILBENENNUNGEN);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgNormteileSucheController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfNormteilbenennungen.getError() != null) {
            if (trfNormteilbenennungen.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"keine Daten gefunden!", (Throwable)trfNormteilbenennungen.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getNormteile(), 1);
                return;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfNormteilbenennungen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfNormteilbenennungen.getError().getMessage(), Resource.getInstance().getNormteile(), 0);
            return;
        }
        this.model.storeNormteilbenennungen((List)trfNormteilbenennungen.getValue("normteile_benennungen"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void performLoadGrafiken(String sNormnummergruppe) {
        this.log.debug((Object)"Performing Load Grafiken");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfGrafiken = new TrfHashMap(null);
        trfGrafiken.setValue("nummer", sNormnummergruppe);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfGrafiken, Command.LOAD_NORMTEILGRAFIKEN);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgNormteileSucheController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfGrafiken.getError() != null) {
            if (trfGrafiken.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"keine Daten gefunden!", (Throwable)trfGrafiken.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getNormteile(), 1);
                return;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfGrafiken.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfGrafiken.getError().getMessage(), Resource.getInstance().getNormteile(), 0);
            return;
        }
        this.model.storeGrafiken((List)trfGrafiken.getValue("normteile_bilder"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    void performSearchByNormnummer(String sNormnummer, JComponent cTextfield) throws NoDataFoundException {
        this.log.debug((Object)"Performing Load Normteile by Normnummer");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        cTextfield.setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfNormteile = new TrfHashMap(null);
        trfNormteile.setValue("nummer", sNormnummer);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfNormteile, Command.LOAD_NORMTEILE_BY_NORMNUMMER);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgNormteileSucheController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            cTextfield.setCursor(Cursor.getPredefinedCursor(2));
            return;
        }
        if (trfNormteile.getError() != null) {
            Exception e = trfNormteile.getError();
            if (e instanceof NoDataFoundException) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                cTextfield.setCursor(Cursor.getPredefinedCursor(2));
                throw new NoDataFoundException("keine Ergebnisdaten gefunden!");
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfNormteile.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            cTextfield.setCursor(Cursor.getPredefinedCursor(2));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), Resource.getInstance().getNormteile(), 0);
            return;
        }
        this.model.setNormTeile((List)trfNormteile.getValue("normteile"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        cTextfield.setCursor(Cursor.getPredefinedCursor(2));
    }

    void performSearchByBenennung(String sBenennungID) throws NoDataFoundException {
        this.log.debug((Object)"Performing Load Normteile by Normnummer");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfNormteile = new TrfHashMap(null);
        trfNormteile.setValue("textcode", sBenennungID);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfNormteile, Command.LOAD_NORMTEILE_BY_BENENNUNG);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgNormteileSucheController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfNormteile.getError() != null) {
            Exception e = trfNormteile.getError();
            if (e instanceof NoDataFoundException) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                throw new NoDataFoundException("keine Ergebnisdaten gefunden!");
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfNormteile.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), Resource.getInstance().getNormteile(), 0);
            return;
        }
        this.model.setNormTeile((List)trfNormteile.getValue("normteile"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

