/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.satzeinzelteile.auswahl;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.AbstractDlgMitTLController;
import webetk.javaclient.dialog.zusatzinfo.satzeinzelteile.auswahl.AuswahlSatzModel;
import webetk.javaclient.dialog.zusatzinfo.satzeinzelteile.auswahl.AuswahlSatzView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class AuswahlSatzController
extends AbstractDlgMitTLController {
    private static Logger log = Logger.getLogger(AuswahlSatzController.class);
    private AuswahlSatzView view = new AuswahlSatzView();
    private AuswahlSatzModel model = new AuswahlSatzModel();

    @Override
    public DialogView getDialogView() {
        log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        super.init(this.model);
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        WorkflowStateData exitData = new WorkflowStateData();
        exitData.setWert("exitaction", this.model.getExitAction());
        return exitData;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    protected void performSearch() {
        log.debug((Object)"Performing Search Satz/Einzelteile: Hauptgruppen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfHauptgruppen = new TrfHashMap(null);
        trfHauptgruppen.setValue("marke", this.model.getMarke());
        trfHauptgruppen.setValue("produktart", this.model.getProduktart());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHauptgruppen, Command.LOAD_SATZEINZEL_HG);
        }
        catch (CommunicationException ex) {
            log.error((Object)("AuswahlSatzController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfHauptgruppen.getError() != null) {
            if (trfHauptgruppen.getError() instanceof NoDataFoundException) {
                log.error((Object)"keine Hauptgruppen gefunden!", (Throwable)trfHauptgruppen.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getSatzEinzelteile(), 0);
                return;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfHauptgruppen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfHauptgruppen.getError().getMessage(), Resource.getInstance().getSatzEinzelteile(), 0);
            return;
        }
        this.model.storeAnzeigedaten((List)trfHauptgruppen.getValue("HG_EXT_LIST"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void performSearch(String sHg) {
        log.debug((Object)"Performing Search Satz/Einzelteile: S\u00e4tze");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfSaetze = new TrfHashMap(null);
        trfSaetze.setValue("marke", this.model.getMarke());
        trfSaetze.setValue("produktart", this.model.getProduktart());
        trfSaetze.setValue("hg", sHg);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfSaetze, Command.LOAD_SATZEINZEL_SAETZE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("AuswahlSatzController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfSaetze.getError() != null) {
            if (trfSaetze.getError() instanceof NoDataFoundException) {
                log.error((Object)"keine Saetze gefunden!", (Throwable)trfSaetze.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getSatzEinzelteile(), 0);
                return;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfSaetze.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfSaetze.getError().getMessage(), Resource.getInstance().getSatzEinzelteile(), 0);
            return;
        }
        this.model.storeAnzeigedaten((List)trfSaetze.getValue("HG_EXT_LIST"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

