/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.satzeinzelteile.auswahl;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.DialogViewController;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import webetk.app.GenericTeil;
import webetk.app.satzeinzelteile.Hg;
import webetk.app.satzeinzelteile.ZusatzInfo;
import webetk.communication.LoginInfo;
import webetk.javaclient.dialog.AbstractDlgMitTLView;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.MarkeProduktKatalogUmfangVLAuswahl;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.zusatzinfo.satzeinzelteile.auswahl.AufzuklappZeile;
import webetk.javaclient.dialog.zusatzinfo.satzeinzelteile.auswahl.AuswahlSatzController;
import webetk.javaclient.dialog.zusatzinfo.satzeinzelteile.auswahl.AuswahlSatzModel;
import webetk.javaclient.dialog.zusatzinfo.satzeinzelteile.auswahl.DatenZeile;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.GenericTableMouseEventListener;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.menuitem.MenuItemCopySachnummer;
import webetk.javaclient.menuitem.MenuItemEinzelteile;
import webetk.javaclient.menuitem.MenuItemInterpretation;
import webetk.javaclient.menuitem.MenuItemTeileinformation;
import webetk.javaclient.menuitem.MenuItemTeileverwendungTeil;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class AuswahlSatzView
extends AbstractDlgMitTLView {
    private static final long serialVersionUID = 1L;
    private AuswahlSatzController controller;
    private AuswahlSatzModel model;
    private boolean bUpdateTeileliste = false;
    private GenericTableModel tableModel;
    private GenericTable table;
    private MarkeProduktKatalogUmfangVLAuswahl mpkAuswahl = null;
    private JPanel panAuswahl;
    private JPanel panHg;
    private JPopupMenu menuPopup = null;
    private JMenuItem menuitemTeileinformation = null;
    private JMenuItem menuitemTeileverwendungTeil = null;
    private JMenuItem menuitemInterpretation = null;
    private JMenuItem menuitemEinzelteile = null;
    private JMenuItem menuitemCopySachnummer = null;

    @Override
    protected void initComponents() {
        super.initComponents();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 10, 0};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(1, 1);
        l.setRowWeight(4, 1);
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        HeaderPanel panHeader = new HeaderPanel(Resource.getInstance().getSeSucheHeader(), ImageCache.getInstance().getHeaderIcon("sesatz"));
        boolean bShowAuswahl = oLoginInfo.displayMarkeProduktKatalogumfang();
        if (bShowAuswahl) {
            this.mpkAuswahl = new MarkeProduktKatalogUmfangVLAuswahl(Resource.getInstance().getSeSucheAuswahlMp(), true, this.model.getMarke(), this.model.getProduktart(), null, false, false);
            this.panAuswahl = this.mpkAuswahl.getMpkPanelSet();
            this.mpkAuswahl.addPropertyChangeListener("Marke", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    AuswahlSatzView.this.model.setMarke((String)evt.getNewValue());
                    AuswahlSatzView.this.bUpdateTeileliste = true;
                    AuswahlSatzView.this.searchHgs();
                }
            });
            this.mpkAuswahl.addPropertyChangeListener("Produktart", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    AuswahlSatzView.this.model.setProduktart((String)evt.getNewValue());
                    AuswahlSatzView.this.bUpdateTeileliste = false;
                    AuswahlSatzView.this.searchHgs();
                }
            });
        }
        this.panHg = this.createHauptGruppenPanel();
        this.setLayout(l);
        this.add((Component)panHeader, c.rc(1, 1));
        if (bShowAuswahl) {
            this.add((Component)this.panAuswahl, c.rc(2, 1));
        } else {
            l.setRowHeight(3, 0);
        }
        this.add((Component)this.panHg, c.rc(4, 1));
    }

    @Override
    public void initMenus() {
        this.menuPopup = new JPopupMenu();
        this.menuitemTeileinformation = new MenuItemTeileinformation(this);
        this.menuPopup.add(this.menuitemTeileinformation);
        this.menuitemTeileverwendungTeil = new MenuItemTeileverwendungTeil("satz_einzelteile_satz", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemTeileverwendungTeil);
        this.menuitemInterpretation = new MenuItemInterpretation("interpretation", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemInterpretation);
        this.menuitemEinzelteile = new MenuItemEinzelteile("satz_einzelteile_satz", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemEinzelteile);
        this.menuPopup.addSeparator();
        this.menuitemCopySachnummer = new MenuItemCopySachnummer(this);
        this.menuPopup.add(this.menuitemCopySachnummer);
    }

    private JPanel createHauptGruppenPanel() {
        TitledPanel p = new TitledPanel(Resource.getInstance().getAuswahlHauptgruppen());
        this.buttonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuswahlSatzView.this.uebernehmenInTeileliste();
            }
        });
        int[] w = new int[]{10, 0, 20, 0, 20, 0, 20, 0, 10};
        int[] h = new int[]{10, 0, 5, 0, 0, 10};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(9, 1);
        hl.setRowWeight(4, 1);
        p.setLayout(hl);
        HIGConstraints c = new HIGConstraints();
        p.add((Component)this.labTeileliste, c.rc(2, 2, "l"));
        p.add((Component)this.comboTeileliste, c.rc(2, 4, "l"));
        p.add((Component)this.buttonUebernehmen, c.rc(2, 6, "l"));
        p.add((Component)this.buttonUeberpruefen, c.rc(2, 8, "l"));
        JScrollPane sc = this.createTabelle();
        p.add((Component)sc, c.rcwh(4, 2, 8, 1));
        return p;
    }

    protected JScrollPane createTabelle() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn("", 0, JLabel.class, false, AufzuklappZeile.getAufklappenRenderer());
        tableConfig.addIconColumn("info.gif", Resource.getInstance().getTeileinformation());
        tableConfig.addIconColumn("auto.gif", Resource.getInstance().getTeileverwendung());
        tableConfig.addColumn(Resource.getInstance().getHg(), 0, false, "XX");
        tableConfig.setHeaderTooltip(3, Resource.getInstance().getHauptgruppe());
        tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "11 41 1 730 475");
        tableConfig.addColumn(Resource.getInstance().getBenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableConfig.addColumn(Resource.getInstance().getZusatz(), 2, true, "XXXXXXXXXXXXXXXYYYY");
        tableConfig.addColumn(Resource.getInstance().getNueZi(), 0, false, "I");
        tableConfig.setHeaderTooltip(7, Resource.getInstance().getZusatzinformation());
        this.tableModel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tableModel);
        this.table.getTable().getColumnModel().getColumn(0).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setWidth(20);
        this.table.getTable().getColumnModel().getColumn(2).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(2).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(2).setWidth(20);
        GenericTableMouseEventListener listenerPlusMinus = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                AuswahlSatzView.this.doClickOnExpandCollapse(e.getRow());
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerPlusMinus, 0);
        GenericTableMouseEventListener listenerTeileinfo = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                int nSelectedRow = AuswahlSatzView.this.table.getTable().getSelectedRow();
                if (AuswahlSatzView.this.tableModel.getRow(nSelectedRow) instanceof AufzuklappZeile) {
                    return;
                }
                ((MenuItemTeileinformation)AuswahlSatzView.this.menuitemTeileinformation).showTeileinfo();
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerTeileinfo, 1);
        GenericTableMouseEventListener listenerTeileverwendung = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                int nSelectedRow = AuswahlSatzView.this.table.getTable().getSelectedRow();
                if (AuswahlSatzView.this.tableModel.getRow(nSelectedRow) instanceof AufzuklappZeile) {
                    return;
                }
                ((MenuItemTeileverwendungTeil)AuswahlSatzView.this.menuitemTeileverwendungTeil).showTeileverwendungTeil();
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerTeileverwendung, 2);
        GenericTableMouseEventListener listener = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                int nSelectedRow = AuswahlSatzView.this.table.getTable().getSelectedRow();
                if (AuswahlSatzView.this.tableModel.getRow(nSelectedRow) instanceof AufzuklappZeile) {
                    return;
                }
                ((MenuItemEinzelteile)AuswahlSatzView.this.menuitemEinzelteile).showEinzelteile();
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listener, 4);
        this.table.addMouseListener(listener, 5);
        this.table.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (AuswahlSatzView.this.table.getTable().getSelectedRowCount() != 1) {
                    return;
                }
                int nSelectedRow = AuswahlSatzView.this.table.getTable().getSelectedRow();
                if (AuswahlSatzView.this.tableModel.getRow(nSelectedRow) instanceof AufzuklappZeile) {
                    return;
                }
                AuswahlSatzView.this.menuitemTeileverwendungTeil.setEnabled(true);
                AuswahlSatzView.this.menuitemInterpretation.setEnabled(((MenuItemInterpretation)AuswahlSatzView.this.menuitemInterpretation).hatInterpretation());
                AuswahlSatzView.this.menuPopup.show(AuswahlSatzView.this.table.getTable(), evt.getX(), evt.getY());
            }
        });
        this.table.getTable().setCellSelectionEnabled(false);
        this.table.getTable().setRowSelectionAllowed(true);
        JScrollPane scrollPane = this.table.getScrollPane();
        return scrollPane;
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        super.init(oDlgModel, oDlgController);
        this.model = (AuswahlSatzModel)oDlgModel;
        this.controller = (AuswahlSatzController)oDlgController;
        this.initComponents();
        this.initMenus();
        this.bUpdateTeileliste = true;
        this.searchHgs();
    }

    @Override
    public void update() {
        this.tableModel.removeAllRows();
        List<Hg> hgList = this.model.getAnzeigedaten();
        this.panHg.setVisible(hgList != null && !hgList.isEmpty());
        if (hgList == null || hgList.isEmpty()) {
            return;
        }
        for (Hg hg : hgList) {
            List<ZusatzInfo> zusatzInfos = hg.getZusatzInfos();
            this.tableModel.addRow(new AufzuklappZeile(!zusatzInfos.isEmpty(), hg.getHg(), hg.getBenennung()));
            for (ZusatzInfo zusatzInfo : zusatzInfos) {
                this.tableModel.addRow(new DatenZeile(zusatzInfo.getTeileNummer(), zusatzInfo.getBenennung(), zusatzInfo.getZusatz(), zusatzInfo.getZi()));
            }
        }
        if (this.bUpdateTeileliste) {
            this.updateTeilelisten();
            this.bUpdateTeileliste = false;
        }
        this.panHg.repaint();
    }

    void searchHgs() {
        this.model.resetAnzeigedaten();
        this.update();
        this.controller.performSearch();
        if (this.bUpdateTeileliste) {
            this.controller.loadTeilelistenIDs();
        }
        this.update();
    }

    void searchSaetze(String sHg) {
        this.model.resetAnzeigedaten();
        this.update();
        this.controller.performSearch(sHg);
        if (this.bUpdateTeileliste) {
            this.controller.loadTeilelistenIDs();
        }
        this.update();
    }

    void loadTeilelistenIDs() {
        this.controller.loadTeilelistenIDs();
    }

    private void doClickOnExpandCollapse(int nRow) {
        if (!(this.tableModel.getRow(nRow) instanceof AufzuklappZeile)) {
            return;
        }
        this.bUpdateTeileliste = false;
        AufzuklappZeile oZeile = (AufzuklappZeile)this.tableModel.getRow(nRow);
        if (oZeile.isExpanded()) {
            this.searchHgs();
        } else {
            String sHg = (String)oZeile.get(3);
            this.searchSaetze(sHg);
        }
    }

    private void uebernehmenInTeileliste() {
        Vector<GenericTeil> cTeile = new Vector<GenericTeil>();
        GenericTable jTable = this.table.getTable();
        int nCountSelectedRows = jTable.getSelectedRowCount();
        if (nCountSelectedRows == 0) {
            return;
        }
        int[] selectedRows = jTable.getSelectedRows();
        for (int i = 0; i < nCountSelectedRows; ++i) {
            int nRow = selectedRows[i];
            GenericTeil t = new GenericTeil();
            if (!(this.tableModel.getRow(nRow) instanceof DatenZeile)) continue;
            DatenZeile oZeile = (DatenZeile)this.tableModel.getRow(nRow);
            String sTeilenummer = (String)oZeile.get(4);
            String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
            t.setSachnummer(sSachnummer);
            String HGUG = sTeilenummer.trim().replaceAll(" +", "").substring(0, 4);
            t.setHG(HGUG.substring(0, 2));
            t.setUG(HGUG.substring(2, 4));
            t.setBenennung((String)oZeile.get(5));
            cTeile.add(t);
        }
        this.uebernehmenInTeileliste(cTeile, false);
    }

    @Override
    public HashMap<String, Object> getInfoZurSachnummer() {
        int nRow = this.table.getTable().getSelectedRow();
        String sTeilenummer = (String)this.tableModel.getValueAt(nRow, 4);
        String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
        String sBenennungZusatz = (String)this.tableModel.getValueAt(nRow, 5);
        String sZusatz = (String)this.tableModel.getValueAt(nRow, 6);
        if (sZusatz != null && !sZusatz.equals("")) {
            sBenennungZusatz = sBenennungZusatz + "/" + sZusatz;
        }
        String sMarke = this.model.getMarke();
        String sProduktart = this.model.getProduktart();
        String sKatalogumfang = this.model.getKatalogumfang();
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        oHashMap.put("sachnummer", sSachnummer);
        oHashMap.put("teilenummer", sTeilenummer);
        oHashMap.put("benennung_zusatz", sBenennungZusatz);
        oHashMap.put("marke", sMarke);
        oHashMap.put("produktart", sProduktart);
        oHashMap.put("katalogumfang", sKatalogumfang);
        return oHashMap;
    }
}

