/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.satzeinzelteile.einzelteile;

import com.bmw.tetis.psi.common.PsiCommunicationException;
import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import webetk.app.GenericTeil;
import webetk.app.satzeinzelteile.ZusatzInfo;
import webetk.javaclient.communication.asap.AsapAppletComCtrl;
import webetk.javaclient.dialog.AbstractDlgMitTLView;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.bte.BTEView;
import webetk.javaclient.dialog.zusatzinfo.satzeinzelteile.einzelteile.DatenZeile;
import webetk.javaclient.dialog.zusatzinfo.satzeinzelteile.einzelteile.EinzelteileSatzController;
import webetk.javaclient.dialog.zusatzinfo.satzeinzelteile.einzelteile.EinzelteileSatzModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.GenericTableMouseEventListener;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.javaclient.menuitem.MenuItemCopySachnummer;
import webetk.javaclient.menuitem.MenuItemInterpretation;
import webetk.javaclient.menuitem.MenuItemTeileinformation;
import webetk.javaclient.menuitem.MenuItemTeileverwendungTeil;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class EinzelteileSatzView
extends AbstractDlgMitTLView {
    private static final long serialVersionUID = 1L;
    private EinzelteileSatzController controller;
    private EinzelteileSatzModel model;
    private GenericTableModel tableModel;
    private GenericTable table;
    private JPanel panHeader;
    private JPanel panContent;
    private JPopupMenu menuPopup = null;
    private JMenuItem menuitemTeileinformation = null;
    private JMenuItem menuitemTeileverwendungTeil = null;
    private JMenuItem menuitemInterpretation = null;
    private JMenuItem menuitemCopySachnummer = null;
    private int mnColTeileinfo = -1;
    private int mnColTeileverwendung = -1;
    private boolean mbShowTeileverwendung = false;
    private int mnColTeilenummer = -1;
    private int mnColBenennung = -1;
    private int mnColZusatz = -1;
    private int mnColMenge = -1;
    private int mnColZI = -1;
    private ArrayList<JComponent> menus = new ArrayList();

    @Override
    protected void initComponents() {
        super.initComponents();
        String sTeilenummer = this.model.getTeilenummerSatz();
        String sBenennungZusatz = this.model.getBenennungZusatzSatz();
        this.panHeader = new HeaderPanel(Resource.getInstance().getEinzelteileDesSatzes(), sTeilenummer + " " + sBenennungZusatz, ImageCache.getInstance().getHeaderIcon("seeinzel"));
        this.panContent = this.createEinzelteilePanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.panHeader, "North");
        this.add((Component)this.panContent, "Center");
    }

    @Override
    public void initMenus() {
        JMenu menuZurueck = new JMenu(Resource.getInstance().getZurueck());
        menuZurueck.setBackground(UIHelper.getDarkerBackground());
        Vector<String> oZurueckStrings = GlobalObjects.getInstance().getEtkData().getZurueckBezeichnungen();
        if (oZurueckStrings.size() > 0) {
            for (int i = 0; i < oZurueckStrings.size(); ++i) {
                final String sBezeichnung = oZurueckStrings.get(i);
                String sMenuitemText = GlobalObjects.getInstance().getEtkData().getZurueckMenuitemText(sBezeichnung);
                JMenuItem menuitemZurueck = new JMenuItem(sMenuitemText);
                menuitemZurueck.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractDialogView oView = GlobalObjects.getInstance().getEtkData().getZurueckDialogView(sBezeichnung);
                        GlobalObjects.getInstance().getEtkData().removeZurueckDialog(sBezeichnung);
                        if (oView != null) {
                            oView.initMenus();
                            if (oView instanceof BTEView) {
                                ((BTEView)oView).refreshKleineTeileliste();
                            }
                            MainView.getInstance().displayDialogView(oView);
                        }
                    }
                });
                menuZurueck.add(menuitemZurueck);
            }
            this.menus = new ArrayList();
            this.menus.add(menuZurueck);
        }
        this.menuPopup = new JPopupMenu();
        this.menuitemTeileinformation = new MenuItemTeileinformation(this);
        this.menuPopup.add(this.menuitemTeileinformation);
        this.menuitemTeileverwendungTeil = new MenuItemTeileverwendungTeil("satz_einzelteile_einzelteile", this.controller, this.model, this);
        if (!GlobalObjects.isScore()) {
            this.menuPopup.add(this.menuitemTeileverwendungTeil);
        }
        this.menuitemInterpretation = new MenuItemInterpretation("satz_einzelteile_einzelteile", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemInterpretation);
        this.menuPopup.addSeparator();
        this.menuitemCopySachnummer = new MenuItemCopySachnummer(this);
        this.menuPopup.add(this.menuitemCopySachnummer);
    }

    @Override
    public Iterator<JComponent> getMenus() {
        return this.menus.iterator();
    }

    private JPanel createEinzelteilePanel() {
        TitledPanel p = new TitledPanel(Resource.getInstance().getEinzelteileDesSatzes());
        this.buttonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EinzelteileSatzView.this.uebernehmenInTeileliste();
            }
        });
        int[] w = new int[]{10, 0, 20, 0, 20, 0, 20, 0, 10};
        int[] h = new int[]{10, 0, 5, 0, 0, 10};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(9, 1);
        hl.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        p.setLayout(hl);
        p.add((Component)this.labTeileliste, c.rc(2, 2, "l"));
        p.add((Component)this.comboTeileliste, c.rc(2, 4, "l"));
        p.add((Component)this.buttonUebernehmen, c.rc(2, 6, "l"));
        p.add((Component)this.buttonUeberpruefen, c.rc(2, 8, "l"));
        JScrollPane sc = this.createTabelle();
        p.add((Component)sc, c.rcwh(4, 2, 8, 1));
        return p;
    }

    private JScrollPane createTabelle() {
        this.mbShowTeileverwendung = !GlobalObjects.isScore();
        TableConfiguration tableConfig = new TableConfiguration();
        int nColInd = 0;
        tableConfig.addIconColumn("info.gif", Resource.getInstance().getTeileinformation());
        this.mnColTeileinfo = nColInd++;
        tableConfig.addColumn("", 0, JLabel.class, false, DatenZeile.getTeileverwendungRenderer());
        this.mnColTeileverwendung = nColInd++;
        tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "11 41 1 730 475");
        this.mnColTeilenummer = nColInd++;
        tableConfig.addColumn(Resource.getInstance().getTeilebenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        this.mnColBenennung = nColInd++;
        tableConfig.addColumn(Resource.getInstance().getZusatz(), 2, true, "XXXXXXXXXXXXXXXYYYY");
        this.mnColZusatz = nColInd++;
        tableConfig.addColumn(Resource.getInstance().getMenge(), 0, false, "10000");
        this.mnColMenge = nColInd++;
        tableConfig.addColumn(Resource.getInstance().getNueZi(), 0, false, "I");
        tableConfig.setHeaderTooltip(nColInd, Resource.getInstance().getZusatzinformation());
        this.mnColZI = nColInd++;
        this.tableModel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tableModel);
        this.table.getTable().getColumnModel().getColumn(0).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setWidth(20);
        if (!GlobalObjects.isScore()) {
            this.table.getTable().getColumnModel().getColumn(1).setMinWidth(20);
            this.table.getTable().getColumnModel().getColumn(1).setMaxWidth(20);
            this.table.getTable().getColumnModel().getColumn(1).setWidth(20);
        }
        int nCol = 0;
        GenericTableMouseEventListener listenerTeileinfo = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                ((MenuItemTeileinformation)EinzelteileSatzView.this.menuitemTeileinformation).showTeileinfo();
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerTeileinfo, nCol);
        if (!GlobalObjects.isScore()) {
            GenericTableMouseEventListener listenerTeileverwendung = new GenericTableMouseEventListener(){

                @Override
                public void clickedOnCell(GenericTableMouseEvent e) {
                    ((MenuItemTeileverwendungTeil)EinzelteileSatzView.this.menuitemTeileverwendungTeil).showTeileverwendungTeil();
                }

                @Override
                public void clickedOnCellDouble(GenericTableMouseEvent evt) {
                }

                @Override
                public void popupOnCell(GenericTableMouseEvent evt) {
                }
            };
            this.table.addMouseListener(listenerTeileverwendung, ++nCol);
        }
        GenericTableMouseEventListener listenerTeilenummer = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                EinzelteileSatzView.this.showEBA(e.getRow());
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerTeilenummer, ++nCol);
        this.table.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (EinzelteileSatzView.this.table.getTable().getSelectedRowCount() != 1) {
                    return;
                }
                int nSelectedRow = EinzelteileSatzView.this.table.getTable().getSelectedRow();
                if (!((DatenZeile)EinzelteileSatzView.this.tableModel.getRow(nSelectedRow)).isBeziehbar()) {
                    return;
                }
                EinzelteileSatzView.this.menuitemTeileverwendungTeil.setEnabled(true);
                EinzelteileSatzView.this.menuitemInterpretation.setEnabled(((MenuItemInterpretation)EinzelteileSatzView.this.menuitemInterpretation).hatInterpretation());
                EinzelteileSatzView.this.menuPopup.show(EinzelteileSatzView.this.table.getTable(), evt.getX(), evt.getY());
            }
        });
        return this.table.getScrollPane();
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        super.init(oDlgModel, oDlgController);
        this.model = (EinzelteileSatzModel)oDlgModel;
        this.controller = (EinzelteileSatzController)oDlgController;
        this.initComponents();
        this.initMenus();
        this.loadEinzelteile();
        this.loadTeilelistenIDs();
        this.update();
    }

    @Override
    public void update() {
        this.tableModel.removeAllRows();
        List<ZusatzInfo> oAnzeigedaten = this.model.getAnzeigedaten();
        this.panContent.setVisible(oAnzeigedaten != null && !oAnzeigedaten.isEmpty());
        if (oAnzeigedaten == null || oAnzeigedaten.isEmpty()) {
            return;
        }
        for (ZusatzInfo zusatzInfo : oAnzeigedaten) {
            this.tableModel.addRow(new DatenZeile(this.mnColTeileinfo, this.mnColTeileverwendung, this.mbShowTeileverwendung, zusatzInfo.getTeileNummer(), this.mnColTeilenummer, zusatzInfo.getBenennung(), this.mnColBenennung, zusatzInfo.getZusatz(), this.mnColZusatz, zusatzInfo.getMenge(), this.mnColMenge, zusatzInfo.getZi(), this.mnColZI, zusatzInfo.isBeziehbar(), zusatzInfo.isEba()));
        }
        this.updateTeilelisten();
        this.panContent.repaint();
    }

    private void loadEinzelteile() {
        String sSachnummer = this.model.getSachnummerSatz();
        this.controller.performLoad(sSachnummer);
    }

    private void loadTeilelistenIDs() {
        this.controller.loadTeilelistenIDs();
    }

    private void uebernehmenInTeileliste() {
        Vector<GenericTeil> cTeile = new Vector<GenericTeil>();
        GenericTable jTable = this.table.getTable();
        int nCountSelectedRows = jTable.getSelectedRowCount();
        if (nCountSelectedRows == 0) {
            return;
        }
        int[] selectedRows = jTable.getSelectedRows();
        for (int i = 0; i < nCountSelectedRows; ++i) {
            int nRow = selectedRows[i];
            GenericTeil t = new GenericTeil();
            DatenZeile oZeile = (DatenZeile)this.tableModel.getRow(nRow);
            if (!oZeile.isBeziehbar()) continue;
            String sTeilenummer = (String)oZeile.get(this.mnColTeilenummer);
            String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
            t.setSachnummer(sSachnummer);
            String HGUG = sTeilenummer.trim().replaceAll(" +", "").substring(0, 4);
            t.setHG(HGUG.substring(0, 2));
            t.setUG(HGUG.substring(2, 4));
            t.setBenennung((String)oZeile.get(this.mnColBenennung));
            cTeile.add(t);
        }
        this.uebernehmenInTeileliste(cTeile, false);
    }

    private void showEBA(int nRow) {
        if (!((DatenZeile)this.tableModel.getRow(nRow)).isEBA()) {
            return;
        }
        String sTeilenummer = (String)this.tableModel.getValueAt(nRow, 2);
        String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
        try {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            AsapAppletComCtrl.getInstance().invokeEba(sSachnummer);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (PsiCommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerVerbindungAsap(), Resource.getInstance().getTeileinfo(), 0);
        }
    }

    @Override
    public HashMap<String, Object> getInfoZurSachnummer() {
        int nRow = this.table.getTable().getSelectedRow();
        if (!(this.tableModel.getRow(nRow) instanceof DatenZeile)) {
            return null;
        }
        DatenZeile oZeile = (DatenZeile)this.tableModel.getRow(nRow);
        if (!oZeile.isBeziehbar()) {
            return null;
        }
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        String sTeilenummer = (String)this.tableModel.getValueAt(nRow, 2);
        String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
        String sBenennungZusatz = (String)this.tableModel.getValueAt(nRow, 3);
        String sZusatz = (String)this.tableModel.getValueAt(nRow, 4);
        if (sZusatz != null && !sZusatz.equals("")) {
            sBenennungZusatz = sBenennungZusatz + "/" + sZusatz;
        }
        String sMarke = this.model.getMarke();
        String sProduktart = this.model.getProduktart();
        String sKatalogumfang = this.model.getKatalogumfang();
        oHashMap.put("sachnummer", sSachnummer);
        oHashMap.put("teilenummer", sTeilenummer);
        oHashMap.put("benennung_zusatz", sBenennungZusatz);
        oHashMap.put("marke", sMarke);
        oHashMap.put("produktart", sProduktart);
        oHashMap.put("katalogumfang", sKatalogumfang);
        return oHashMap;
    }
}

