/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.technischeliteratur;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.zusatzinfo.technischeliteratur.DlgTechnischeLiteraturSucheController;
import webetk.javaclient.dialog.zusatzinfo.technischeliteratur.DlgTechnischeLiteraturSucheModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventListener;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.resources.Resource;

public class DlgTechnischeLiteraturSucheView
extends AbstractDialogView {
    private static final long serialVersionUID = 1L;
    Logger log = Logger.getLogger(DlgTechnischeLiteraturSucheView.class);
    DlgTechnischeLiteraturSucheModel model;
    DlgTechnischeLiteraturSucheController controller;
    private GenericTableModel tableModel;
    private GenericTable table;
    private JPanel panHeader;
    private JPanel panAuswahlSprache;
    private JPanel panAuswahlThema;
    private JLabel labHinweis;
    private JLabel labInSprache;
    private JComboBox comboSprache;

    @Override
    public void initMenus() {
    }

    private void initComponents() {
        String sHeader2 = Resource.getInstance().getKeinFahrzeugIdentifiziert();
        if (GlobalObjects.getInstance().getEtkData().getFzgSucheInfo() != null) {
            sHeader2 = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo().getFzgIdString();
        }
        this.panHeader = new HeaderPanel(Resource.getInstance().getSucheTechnischeLiteratur(), sHeader2, ImageCache.getInstance().getHeaderIcon("techlit"));
        this.panAuswahlSprache = new TitledPanel(Resource.getInstance().getAuswahlSprache());
        this.panAuswahlThema = new TitledPanel(Resource.getInstance().getAuswahlNachThemenbereich());
        this.labInSprache = new JLabel(Resource.getInstance().getInSprache() + ":");
        this.labHinweis = new JLabel(Resource.getInstance().getTlSucheHinweisBen());
        this.comboSprache = new JComboBox();
        this.labInSprache.setLabelFor(this.comboSprache);
        this.createLayout();
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panHeader, "North");
        JScrollPane content = new JScrollPane(this.createContent());
        this.add((Component)content, "Center");
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        this.log.debug((Object)"init");
        this.model = (DlgTechnischeLiteraturSucheModel)oDlgModel;
        this.controller = (DlgTechnischeLiteraturSucheController)oDlgController;
        this.initComponents();
        this.loadSprachen();
        this.loadFgs();
        this.update();
    }

    @Override
    public void update() {
        this.comboSprache.removeAllItems();
        TrfHashMap oSprachen = this.model.getSprachen();
        this.comboSprache.addItem(Resource.getInstance().getAlle());
        if (oSprachen != null) {
            String sBenennung;
            int i = 1;
            while ((sBenennung = (String)oSprachen.getValue(i + "benennung")) != null) {
                this.comboSprache.addItem(sBenennung);
                ++i;
            }
        }
        this.comboSprache.setSelectedItem(Resource.getInstance().getAlle());
        TrfHashMap oAnzeigedaten = this.model.getAnzeigedaten();
        int i = 1;
        while (true) {
            String sHg = (String)oAnzeigedaten.getValue(i + "hg");
            String sFg = (String)oAnzeigedaten.getValue(i + "fg");
            String sBenennung = (String)oAnzeigedaten.getValue(i + "benennung");
            if (sBenennung == null) break;
            this.tableModel.addRow(new AbstractRow(new Object[]{sHg, sFg, sBenennung}));
            ++i;
        }
    }

    private JPanel createContent() {
        JPanel contentPanel = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 10, 0};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(1, 1);
        hl.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        contentPanel.setLayout(hl);
        contentPanel.add((Component)this.createAuswahlSprachePanel(), c.rc(1, 1));
        contentPanel.add((Component)this.createAuswahlThemaPanel(), c.rc(3, 1));
        return contentPanel;
    }

    private JPanel createAuswahlSprachePanel() {
        int[] w_suchen = new int[]{10, 0, 10, 0, 10};
        int[] h_suchen = new int[]{0, 10};
        HIGLayout layoutSuchen = new HIGLayout(w_suchen, h_suchen);
        HIGConstraints c = new HIGConstraints();
        this.panAuswahlSprache.setLayout(layoutSuchen);
        this.panAuswahlSprache.add((Component)this.labInSprache, c.rc(1, 2));
        this.panAuswahlSprache.add((Component)this.comboSprache, c.rc(1, 4, "lr"));
        return this.panAuswahlSprache;
    }

    private JPanel createAuswahlThemaPanel() {
        int[] w_ergebnis = new int[]{10, 0, 10};
        int[] h_ergebnis = new int[]{10, 0, 5, 0, 5};
        HIGLayout layoutErgebnis = new HIGLayout(w_ergebnis, h_ergebnis);
        layoutErgebnis.setColumnWeight(2, 1);
        layoutErgebnis.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        this.panAuswahlThema.setLayout(layoutErgebnis);
        this.panAuswahlThema.add((Component)this.labHinweis, c.rc(2, 2, "l"));
        this.panAuswahlThema.add((Component)this.createTabelle(), c.rc(4, 2));
        return this.panAuswahlThema;
    }

    private JComponent createTabelle() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn(Resource.getInstance().getHg(), 0, false, "11");
        tableConfig.addColumn(Resource.getInstance().getFg(), 0, false, "11");
        tableConfig.addColumn(Resource.getInstance().getBenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableConfig.setUsePrototypeIcons(true);
        this.tableModel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tableModel);
        GenericTableMouseEventListener listener = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                DlgTechnischeLiteraturSucheView.this.showTechnischeLiteratur(e.getRow());
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listener, 2);
        this.table.setAllowSizingSmallerThanMinimumWidth(false);
        this.table.getTable().setSelectionMode(0);
        return this.table.getScrollPane();
    }

    void loadSprachen() {
        this.controller.loadSprachen();
    }

    void loadFgs() {
        this.controller.loadFgs();
    }

    public void showTechnischeLiteratur(int nRow) {
        String sSpracheTL;
        int nIndex = this.comboSprache.getSelectedIndex();
        TrfHashMap oSprachen = this.model.getSprachen();
        String sISO = (String)oSprachen.getValue(nIndex + "iso");
        String sRegISO = (String)oSprachen.getValue(nIndex + "regiso");
        if (sISO == null || sISO.equals("  ")) {
            sSpracheTL = "AlleWerte";
        } else {
            sRegISO = sRegISO == null ? "  " : sRegISO;
            sSpracheTL = sISO + sRegISO;
        }
        String sFg = (String)this.tableModel.getValueAt(nRow, 1);
        this.model.setExitAction("anzergebnisse");
        try {
            this.controller.loadTechnischeLiteratur(sFg, sSpracheTL);
        }
        catch (NoDataFoundException e) {
            this.log.error((Object)"keine Ergebnisdaten gefunden!");
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getTechlitHinweisSprache(), Resource.getInstance().getTechnischeLiteratur(), 0);
            return;
        }
        this.controller.notifyAllExitListeners();
    }
}

