/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.valueline;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.InvalidInitializationException;
import webetk.NoDataFoundException;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.teilevwdgteil.Modellspalte;
import webetk.communication.CommunicationException;
import webetk.communication.JavaFzgIdInfo;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.AbstractDlgMitTLController;
import webetk.javaclient.dialog.btinfo.Bildtafelinfo;
import webetk.javaclient.dialog.zusatzinfo.valueline.ValueLineModel;
import webetk.javaclient.dialog.zusatzinfo.valueline.ValueLineView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class ValueLineController
extends AbstractDlgMitTLController {
    private static Logger log = Logger.getLogger(ValueLineController.class);
    private ValueLineView view = new ValueLineView();
    private ValueLineModel model = new ValueLineModel();

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        super.init(this.model);
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        return null;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    @Override
    public DialogView getDialogView() {
        return this.view;
    }

    public void search() {
        if (this.model.getUmfang().equals("saetze")) {
            this.loadHGs();
        } else if (this.model.getUmfang().equals("bildtafeln")) {
            this.loadBteBaureihen();
        } else if (this.model.getUmfang().equals("teilenummern")) {
            this.loadTeilenummern();
        }
        this.view.update();
    }

    public void changeToMarke(String newMarke) {
        this.model.setMarke(newMarke);
        this.loadTeilelistenIDs();
        this.search();
    }

    public void changeToProduktart(String newProduktart) {
        this.model.setProduktart(newProduktart);
        this.search();
    }

    public void changeToUmfang(String newUmfang) {
        this.model.setUmfang(newUmfang);
        this.search();
    }

    public void loadHGs() {
        log.debug((Object)"lade HGs zu Saetzen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trf = new TrfHashMap(null);
        trf.setValue("marke", this.model.getMarke());
        trf.setValue("produktart", this.model.getProduktart());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.LOAD_VALUE_LINE_HGS);
        }
        catch (CommunicationException ex) {
            log.error((Object)("CommunicationException: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trf.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trf.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trf.getError().getMessage(), Resource.getInstance().getSatzEinzelteile(), 0);
            return;
        }
        Collection hgs = (Collection)trf.getValue("HG_LIST");
        if (hgs.size() < 1) {
            log.warn((Object)"keine Value Line HGs gefunden!");
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getValueLine(), 0);
        }
        this.model.setHgs(hgs);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void loadSaetze(String hg) {
        log.debug((Object)"lade S\u00e4tze");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trf = new TrfHashMap(null);
        trf.setValue("marke", this.model.getMarke());
        trf.setValue("produktart", this.model.getProduktart());
        trf.setValue("hg", hg);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.LOAD_VALUE_LINE_SAETZE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("CommunicationException: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trf.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trf.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trf.getError().getMessage(), Resource.getInstance().getSatzEinzelteile(), 0);
            return;
        }
        Collection saetze = (Collection)trf.getValue("saetze");
        if (saetze.size() < 1) {
            log.warn((Object)"keine Value Line Saetze gefunden!");
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getValueLine(), 0);
        }
        this.model.putSaetze(hg, saetze);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void loadBteBaureihen() {
        log.debug((Object)"lade Baureihen aller Value Line Bildtafeln");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trf = new TrfHashMap(null);
        trf.setValue("marke", this.model.getMarke());
        trf.setValue("produktart", this.model.getProduktart());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.LOAD_VALUE_LINE_BTE_BAUREIHEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("CommunicationException: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trf.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trf.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trf.getError().getMessage(), Resource.getInstance().getSatzEinzelteile(), 0);
            return;
        }
        Collection baureihen = (Collection)trf.getValue("baureihenListe");
        if (baureihen == null || baureihen.size() < 1) {
            log.warn((Object)"keine Value Line Bildtafeln gefunden!");
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getValueLine(), 0);
        }
        this.model.setBaureihen(baureihen);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void loadBildtafeln(String baureihe) {
        log.debug((Object)("lade Bildtafeln fuer Baureihe " + baureihe));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trf = new TrfHashMap(null);
        trf.setValue("marke", this.model.getMarke());
        trf.setValue("produktart", this.model.getProduktart());
        trf.setValue("baureihe", baureihe);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.LOAD_VALUE_LINE_BTES);
        }
        catch (CommunicationException ex) {
            log.error((Object)("CommunicationException: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trf.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trf.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trf.getError().getMessage(), Resource.getInstance().getSatzEinzelteile(), 0);
            return;
        }
        Collection bildtafeln = (Collection)trf.getValue("MODELLSPALTEN");
        if (bildtafeln.size() < 1) {
            log.warn((Object)"keine Value Line Bildtafeln gefunden!");
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getValueLine(), 0);
        }
        this.model.putBildtafeln(baureihe, bildtafeln);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void loadTeilenummern() {
        log.debug((Object)"lade alle Value Line Teilenummern");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trf = new TrfHashMap(null);
        trf.setValue("marke", this.model.getMarke());
        trf.setValue("produktart", this.model.getProduktart());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.LOAD_VALUE_LINE_TEILENUMMERN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("CommunicationException: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trf.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trf.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trf.getError().getMessage(), Resource.getInstance().getSatzEinzelteile(), 0);
            return;
        }
        Collection teile = (Collection)trf.getValue("bildtafeln");
        if (teile.size() < 1) {
            log.warn((Object)"keine Value Line Teile gefunden!");
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getValueLine(), 0);
        }
        this.model.setTeilenummern(teile);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public HashMap<String, Object> getInfoZurBildtafel(int nRow) {
        Modellspalte bte = this.model.ermittleBildtafelZuIndex(nRow);
        if (bte == null) {
            return null;
        }
        CurrentBTE oCurrentBTE = this.loadBildtafelDaten(bte);
        if (oCurrentBTE == null) {
            return null;
        }
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        oHashMap.put("currentbte", oCurrentBTE);
        oHashMap.put("modus", "Fahrzeugteile");
        return oHashMap;
    }

    protected CurrentBTE loadBildtafelDaten(Modellspalte bte) {
        log.debug((Object)"Performing loadBildtafelDaten");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trf = new TrfHashMap(null);
        trf.setValue("btnummer", bte.getBTNummer());
        trf.setValue("marke", this.model.getMarke());
        trf.setValue("produktart", this.model.getProduktart());
        String sKatalogumfang = GlobalObjects.getInstance().getSessionInfo().getSettings().getKatalogumfang();
        trf.setValue("katalogumfang", sKatalogumfang);
        trf.setValue("baureihe", this.model.getExpandedBaureihe());
        trf.setValue("region", bte.getRegion());
        trf.setValue("modell", bte.getModell());
        if (this.model.isPKW()) {
            trf.setValue("karosserie", bte.getKarosserie());
        } else {
            trf.setValue("bauart", bte.getBauartKarosserieID());
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.BT_SHOW_TV_TEIL);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trf.getError() != null) {
            if (trf.getError() instanceof NoDataFoundException) {
                log.error((Object)"keine Teileverwendung gefunden!", (Throwable)trf.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getValueLine(), 0);
                return null;
            }
            if (trf.getError() instanceof InvalidInitializationException) {
                log.error((Object)"Teil nicht im Teilestamm enthalten (ggf. wegen 'falscher' Marke)!", (Throwable)trf.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getValueLine(), 0);
                return null;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trf.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trf.getError().getMessage(), Resource.getInstance().getValueLine(), 0);
            return null;
        }
        JavaFzgIdInfo oFzgIdInfo = (JavaFzgIdInfo)trf.getValue("fzgidinfo_java");
        GlobalObjects.getInstance().setFzgIdInfo(oFzgIdInfo);
        JavaFzgSucheInfo oFzgSucheInfo = (JavaFzgSucheInfo)trf.getValue("fzgsucheinfo_java");
        GlobalObjects.getInstance().getEtkData().setSucheInfo(oFzgSucheInfo);
        CurrentBTE oCurrentBTE = (CurrentBTE)trf.getValue("currentbte");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        ComboTeilelisteItem item = GlobalObjects.getInstance().getSessionInfo().getAktuelleTeileliste();
        if (item != null && !this.model.getMarke().equals(item.getMarke())) {
            GlobalObjects.getInstance().getSessionInfo().setAktuelleTeileliste(null);
        }
        return oCurrentBTE;
    }

    public void showBildtafelinfo(int nRow) {
        Modellspalte bte = this.model.ermittleBildtafelZuIndex(nRow);
        if (bte == null) {
            return;
        }
        if (!bte.hasBtInfo()) {
            return;
        }
        String sBtNummer = bte.getBTNummer();
        String sProduktart = this.model.getProduktart();
        Bildtafelinfo dlgBildtafelinfo = new Bildtafelinfo((Frame)MainView.getInstance(), sBtNummer, sProduktart);
        dlgBildtafelinfo.setVisible(true);
    }
}

