/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.framework;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.InitLogging;
import de.esg.commonclient.Login;
import de.esg.commonclient.dialog.DialogView;
import de.esg.tools.win32.registry.WindowsRegistry;
import java.awt.Cursor;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.log4j.Logger;
import webetk.communication.CommController;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfString;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.framework.WarumUpJAIImageLoader;
import webetk.javaclient.lookandfeel.WebETKTheme;
import webetk.javaclient.utils.ExternalCommand;
import webetk.javaclient.utils.LoginLogoutLogger;
import webetk.javaclient.workflow.MainWorkflowsteuerung;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class MainViewController {
    protected MainView mainViewInstance;
    private static MainViewController mainViewControllerInstance;
    private boolean initialized = false;
    protected MainWorkflowsteuerung mainWfSteuerungInstance;
    private static Logger log;

    public void displayDialogView(DialogView oDlgView) {
        this.mainViewInstance.displayDialogView(oDlgView);
    }

    public static void main(String[] args) throws Exception {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    LoginLogoutLogger.protokolliereLogout(GlobalObjects.getInstance().getSessionInfo().getFirmaId(), GlobalObjects.getInstance().getSessionInfo().getLogin());
                }
            });
            int nThreadId = 0;
            String sNutzer = null;
            String sPort = null;
            String sProp = null;
            int nArg = 0;
            String debugETK = null;
            System.setProperty("debugETK", "false");
            while (nArg + 1 <= args.length) {
                String sArg = args[nArg];
                if (sArg != null) {
                    System.out.println("Aufrufargument: " + sArg);
                    if (sArg.indexOf("threadid=") > -1) {
                        String sThreadId = sArg.substring(9);
                        if (sThreadId != null) {
                            System.out.println("ThreadId: " + sThreadId);
                            nThreadId = Integer.parseInt(sThreadId);
                        }
                    } else if (sArg.indexOf("userid=") > -1) {
                        sNutzer = sArg.substring(7);
                        if (sNutzer != null) {
                            System.out.println("Nutzer: " + sNutzer);
                        }
                    } else if (sArg.indexOf("serverport=") > -1) {
                        sPort = sArg.substring(11);
                        if (sPort != null) {
                            System.out.println("Port: " + sPort);
                        }
                    } else if (sArg.indexOf("prop=") > -1) {
                        sProp = sArg.substring(6);
                        if (sProp != null) {
                            System.out.println("Prop: " + sProp);
                        }
                    } else if (sArg.indexOf("debugETK=") > -1 && (debugETK = sArg.substring(9)) != null) {
                        System.out.println("debugETK(Starter)= " + debugETK);
                        if (debugETK.equals("true")) {
                            System.setProperty("debugETK", debugETK);
                        }
                    }
                }
                ++nArg;
            }
            GlobalObjects.setIpac(false);
            if (sProp != null) {
                GlobalObjects.setPropFileName(sProp);
            }
            GlobalObjects.setScore(false);
            MainViewController.getInstance().init(sNutzer, nThreadId, sPort, sProp);
        }
        catch (Throwable ex) {
            Logger.getRootLogger().fatal((Object)"Unexpected exception when initializing", ex);
            ex.printStackTrace();
            System.out.println("MainViewController: exception encountered in main: " + ex.getMessage());
            System.exit(-3);
        }
    }

    public static MainViewController getInstance() {
        if (mainViewControllerInstance == null) {
            mainViewControllerInstance = new MainViewController();
        }
        return mainViewControllerInstance;
    }

    public void initFromScore(String sNutzer) {
        GlobalObjects.setScore(true);
        this.init(sNutzer, 0, null, null);
    }

    public void init(String sNutzer, int nThreadID, String sPort, String sProp) {
        boolean bScore = GlobalObjects.isScore();
        System.setProperty("sun.java2d.ddscale", "true");
        System.out.println("Prop(init): " + sProp);
        if (sProp != null) {
            GlobalObjects.resetInstance();
            GlobalObjects.setPropFileName(sProp);
            InitLogging.initLogging(sProp);
        } else if (bScore) {
            String key = "HKEY_LOCAL_MACHINE\\SOFTWARE\\BMWgroup\\EtkLauncher";
            String propFileName = WindowsRegistry.getValueAsString(key, "instPath");
            if (propFileName != null) {
                propFileName = propFileName + "properties\\javaclient.properties";
                System.out.println("Property File aus Launcher Registry (key: " + key + ": " + propFileName);
                GlobalObjects.setPropFileName(propFileName);
            }
            InitLogging.initLogging(propFileName);
        } else {
            InitLogging.initLogging(GlobalObjects.getPropFileName());
        }
        MetalLookAndFeel.setCurrentTheme(new WebETKTheme());
        WarumUpJAIImageLoader.warmUp();
        GlobalObjects.getInstance();
        GlobalObjects.getInstance().getSessionInfo().setEinstellungenDisharmonie(true);
        String language = GlobalObjects.getInstance().getLanguage();
        if (language != null) {
            Resource.setLanguage(language);
            WebETKTheme.changeFont(language.substring(0, 2));
        } else {
            log.info((Object)"No language property found!");
        }
        this.mainViewInstance = MainView.getInstance();
        try {
            GlobalObjects globs = GlobalObjects.getInstance();
            CommController.getInstance().init(globs.getServerUrl());
            log.info((Object)("init CommController with " + globs.getServerUrl()));
            CommController oCommController = CommController.getInstance();
            String sServerURL = globs.getServerUrl();
            if (sPort != null && sPort.length() > 0) {
                int nStart = sServerURL.lastIndexOf(":") + 1;
                int nEnde = sServerURL.indexOf("/", nStart) - 1;
                sServerURL = sServerURL.substring(0, nStart) + sPort + sServerURL.substring(nEnde + 1, sServerURL.length());
                log.debug((Object)("sServerURL " + sServerURL));
            }
            oCommController.init(sServerURL);
            int nConnectionTimeout = globs.getTimeoutConnection();
            int nSocketTimeout = globs.getTimeoutSocket();
            int nHttpConnectionFactoryTimeout = globs.getTimeoutConnection();
            oCommController.setTimeouts(nConnectionTimeout, nSocketTimeout, nHttpConnectionFactoryTimeout);
        }
        catch (Exception ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), ex.toString(), "Could not connect to ETK-Server", 0);
            log.fatal((Object)"Could not intialize the communication controller!", (Throwable)ex);
            System.exit(-2);
        }
        boolean bIsIsis = this.isIsisServer();
        try {
            this.mainViewInstance.init(this, nThreadID, bScore, bIsIsis);
        }
        catch (Exception e) {
            log.fatal((Object)"Could not initialize application", (Throwable)e);
            System.exit(-1);
        }
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        if (!this.isFirmaIdProper(GlobalObjects.getInstance().getFirmaId())) {
            System.exit(-2);
        }
        if (!this.isClientAktuell()) {
            System.exit(-2);
        }
        if (!bScore) {
            if (sNutzer == null || sNutzer.length() < 1) {
                sNutzer = Login.readLoginName("ETK");
            }
            this.mainWfSteuerungInstance = MainWorkflowsteuerung.getInstance();
            WorkflowStateData oWsd = new WorkflowStateData();
            oWsd.setWert("NUTZER", sNutzer);
            this.mainWfSteuerungInstance.startWorkflow("WfLogin", oWsd);
        }
        this.initialized = true;
    }

    public boolean isFirmaIdProper(String sFirmaId) {
        if (sFirmaId == null) {
            log.error((Object)"Firma in Property-File is null!");
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": Firma in Property-File is null!", "", 0);
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfFirma = new TrfHashMap(null);
        trfFirma.setValue("id", sFirmaId);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFirma, Command.EXIST_FIRMAID);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), ex.toString(), "Could not connect to ETK-Server", 0);
            return false;
        }
        if (trfFirma.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFirma.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfFirma.getError().toString(), "Could not connect to ETK-Server", 0);
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        if (!Boolean.TRUE.equals(trfFirma.getValue("boolean"))) {
            log.error((Object)("Could not find Firma " + GlobalObjects.getInstance().getFirmaId() + " from Property file!"));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerFirma(), "", 0);
            return false;
        }
        return true;
    }

    public boolean isIsisServer() {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfString trf = new TrfString(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.CHECK_IS_ISIS);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), ex.toString(), "Could not connect to ETK-Server", 0);
            return false;
        }
        if (trf.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trf.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trf.getError().toString(), "Could not connect to ETK-Server", 0);
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        String result = trf.getString();
        return result != null && result.equals("true");
    }

    private boolean isClientAktuell() {
        String szClientVersion = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream("version.txt")));
            if (in != null) {
                String szLine = in.readLine();
                while (szLine != null) {
                    if (szLine.indexOf("Version.Programme=") == 0) {
                        szClientVersion = szLine.substring(18);
                        break;
                    }
                    szLine = in.readLine();
                }
                in.close();
            }
        }
        catch (IOException ex) {
            return true;
        }
        TrfString trf = new TrfString(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.LOAD_PROGRAMM_VERSION);
        }
        catch (CommunicationException ex) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + ex.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
            return false;
        }
        if (trf.getError() != null) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + trf.getError().getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
            return false;
        }
        String szServerVersion = trf.getString();
        if (!szClientVersion.equals(szServerVersion)) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getMsgClientVeraltet(), Resource.getInstance().getSonstigerFehler(), 0);
            String sSetupPath = GlobalObjects.getInstance().getSetupPath();
            String[] aCmds = new String[]{sSetupPath};
            ExternalCommand cmd = new ExternalCommand(aCmds, null, null);
            cmd.start();
            System.exit(0);
            return false;
        }
        return true;
    }

    public MainView getMainViewInstance() {
        return this.mainViewInstance;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    static {
        log = Logger.getLogger(MainViewController.class);
    }
}

